package com.good.service.test.data;

import org.json.JSONObject;

/**
 * Created by ibilyi on 16.11.2015.
 */
public class JsonRequest {

    public static final String REQ_ID = "reqId";
    public static final String AUTH_TOKEN = "authToken";
    public static final String M_TYPE = "mType";
    private final String reqId;
    private final String authToken;
    private final String mType;
    
    private static class InstanceHandler {
        private static final JsonRequest HANDLER = new JsonRequest();
    }

    private JsonRequest() {
        PropertiesLoader propertiesLoader = PropertiesLoader.getInstance();
        this.reqId = propertiesLoader.get(REQ_ID);
        this.authToken = propertiesLoader.get(AUTH_TOKEN);
        this.mType = propertiesLoader.get(M_TYPE);;
    }

    public String getJSONMessage() {
        JSONObject message = new JSONObject();
        message.put(REQ_ID,reqId);
        message.put(AUTH_TOKEN,authToken);
        message.put(M_TYPE,mType);
        return message.toString();
    }
    
    public static JsonRequest getInstance() {
        return InstanceHandler.HANDLER;
    }
}
