package com.good.service.test.data;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

import java.io.UnsupportedEncodingException;

/**
 * Created by ibilyi on 16.11.2015.
 */
public class HttpRequestFactory {
    private static final Log LOG = LogFactory.getLog(HttpRequestFactory.class);
    private final String password;
    private final String login;
    private final String url;
    private final HttpPost postRequest;

    private HttpRequestFactory() {
        PropertiesLoader propertiesLoader = PropertiesLoader.getInstance();
        JsonRequest jsonRequest = JsonRequest.getInstance();
        this.password = propertiesLoader.get("password");
        this.login = propertiesLoader.get("login");
        this.url = propertiesLoader.get("URL");
        StringEntity input = null;
        try {
            input = new StringEntity(jsonRequest.getJSONMessage());
        } catch (UnsupportedEncodingException e) {
            LOG.error("Could not generate request body due to exception", e);
        }
        postRequest = new HttpPost(url);
        HttpParams params = new BasicHttpParams();
        String authorization = "Basic " + new String(Base64.encodeBase64((login + ":" + password).getBytes()));
        postRequest.setHeader(new BasicHeader("Authorization", authorization));

        params.setParameter("http.protocol.version", HttpVersion.HTTP_1_0);
        postRequest.setParams(params);
        input.setContentType("application/json");
        postRequest.setEntity(input);

    }

    public HttpPost getPostRequest() {
        return this.postRequest;
    }

    public HttpClient getHTTPClient() {
        DefaultHttpClient httpClient = null;
        try {
            httpClient = new DefaultHttpClient();
            httpClient.getCredentialsProvider().setCredentials(
                    AuthScope.ANY,
                    new UsernamePasswordCredentials(login, password));
        } catch (Exception e) {
            LOG.error("Caught an exception", e);
        }
        return httpClient;
    }

    private static class InstanceHolder {
        private static final HttpRequestFactory LOADER = new HttpRequestFactory();
    }

    public static HttpRequestFactory getInstance() {
        return InstanceHolder.LOADER;
    }
}
