package com.good.security.x509;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

/**
 * Class extends {@link org.springframework.security.authentication.UsernamePasswordAuthenticationToken} for customization
 * @author Stanislav Kyfenko
 *         28.09.2015
 */
public class X509AuthenticationToken extends UsernamePasswordAuthenticationToken {

    /**
     * Instantiates a new X 509 authentication token.
     *
     * @see org.springframework.security.authentication.UsernamePasswordAuthenticationToken#UsernamePasswordAuthenticationToken(Object, Object)
     */
    public X509AuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    /**
     * Instantiates a new X 509 authentication token.
     *
     * @see org.springframework.security.authentication.UsernamePasswordAuthenticationToken#UsernamePasswordAuthenticationToken(Object, Object, Collection)
     */
    public X509AuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(principal, credentials, authorities);
    }
}