package com.good.filters.validators;

/**
 * @author Ivan Bilyi
 * 28.10.2015.
 */
public interface ValidatorBean {
    /**
     * Method that should provide validation of request data, and in case of errors method should not start execution
     * of other filters.
     * <pre>
     * {@code void filter(ValidationChain validationChain) {
     *         //validation code;
     *         if(hasErrors) {
     *             validationChain.addErrorMessage();
     *             return;
     *         }
     *         validationChain.doValidation();
     *     }
     * }
     * </pre>
     * 
     * @param validationChain chain of {@link ValidatorBean} 
     */
    void filter(ValidationChain validationChain);
}
