package com.good.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Objects;

/**
 * Deserialized data from request body. Data will be used for creation of certificates in {@link com.good.service.CertificateServerService}.
 */
public class GDP12CertificateRequest {

    /**
     * Will be used as password in created PKCS12 keystore.
     */
	private String authToken;
	/**
	 * User email addr or some other identifier.
	 * Subject for the certificate is created by the issuer.
	 */
	private String user;
	/**
	 * request ID is used in response for mapping it with request
	 */
	private String reqId;
	/**
	 * Type of request. Currently only "initialCert" is supported
	 */
	private RequestTypeEnum mType;

	/**
	 * Device ID
	 */
	private String deviceId;

	/**
	 * Device name
	 */
	private String deviceName;

	public String getUser() {
		return user;
	}

	public void setUser(final String user) {
		this.user = user;
	}

	public String getReqId() {
		return reqId;
	}

	public void setReqId(final String reqId) {
		this.reqId = reqId;
	}

	public String getAuthToken() {
		return authToken;
	}

	public void setAuthToken(final String authToken) {
		this.authToken = authToken;
	}

	public RequestTypeEnum getmType() {
		return this.mType;
	}

	public void setmType(final RequestTypeEnum requestType) {
		this.mType = requestType;
	}

	public String getDeviceId() {
		return deviceId;
	}

	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}

	public String getDeviceName() {
		return deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

	private enum RequestTypeEnum {
		INITIAL_CERT("initialCert"), RENEW_CERT("renewCert");

		private final String val;

		RequestTypeEnum(String val) {
			this.val = val;
		}

        @JsonValue
		public String getValue() {
			return this.val;
		}

        @JsonCreator
		public static RequestTypeEnum getByType(String type){
			for (RequestTypeEnum enumType:RequestTypeEnum.values()){
				if (enumType.toString().equals(type)){
					return enumType;
				}
			}
			return null;
		}

		public String toString() {
			return this.val;
		}
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		GDP12CertificateRequest that = (GDP12CertificateRequest) o;
		return Objects.equals(authToken, that.authToken) &&
				Objects.equals(user, that.user) &&
				Objects.equals(reqId, that.reqId) &&
				mType == that.mType &&
				Objects.equals(deviceId, that.deviceId) &&
				Objects.equals(deviceName, that.deviceName);
	}

	@Override
	public int hashCode() {
		return Objects.hash(authToken, user, reqId, mType, deviceId, deviceName);
	}

	@Override
    public String toString() {
        return "GDP12CertificateRequest{" +
                "authToken='" + "***" + '\'' +
                ", user='" + user + '\'' +
                ", reqId='" + reqId + '\'' +
                ", mType=" + mType +
				", deviceId='" + deviceId + '\'' +
				", deviceName='" + deviceName + '\'' +
                '}';
    }
}
