/**
 * UserSmartCredentialInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the information returned about a user Smart
 *                         Credential.
 */
public class UserSmartCredentialInfo  implements java.io.Serializable {
    /* The user ID that owns the Smart Credential. */
    private String userid;

    /* The user name of the user ID  that owns the
     *                                 Smart Credential. */
    private String userName;

    /* The group of the user ID that owns the Smart Credential. */
    private String group;

    /* This value will contain the Id
     *                                 of the Smart Credential. */
    private String id;

    /* This value will contain the Smart Credential
     *                                 Definition of the Smart Credential. */
    private String definitionId;

    /* The id of the smart credential from which
     *                                 this smart credential was cloned.
     * The value
     *                                 will be null of the smart credential
     * was not cloned. */
    private String cloneId;

    /* The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed. */
    private String serialNumber;

    /* Indicates if the serial number is associated
     *                                 with a mobile smart credential.  This
     * value
     *                                 won't be set if the serial number
     * is not set. */
    private Boolean mobile;

    /* The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded. */
    private String cardUID;

    /* The state of the user smart credential. */
    private SmartCredentialState state;

    /* The card manager keys of this smart
     *                                 credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null. */
    private byte[][] cardManagerKeys;

    /* The version of the card manager keys of this
     *                                 smart credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null. */
    private Integer cardManagerKeyVersion;

    /* The state of the last print/encode/proximity
     *                                 request. */
    private com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState;

    /* The print date of the user smart credential.
     *                                 This value is the last time a
     *                                 print/encode/proximity operation was
     * started. */
    private java.util.Calendar issueDate;

    /* Information about the last
     *                                 print/encode/proximity request. */
    private String issueInfo;

    /* A flag indicating if this Smart Credential is sealed
     *                                 or not.  A sealed Smart Credential
     * can not be modified
     *                                 or printed.  Normally a Smart Credential
     * will be
     *                                 sealed after printing is complete. */
    private boolean sealed;

    /* A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until
     *                                 approved. */
    private boolean approved;

    /* A flag indicating if the enrollment values
     *                                 for this Smart Credential have been
     * successfully
     *                                 validated against the type description
     * specified in the Definition. */
    private boolean valid;

    /* This value will contain the creation date
     *                                 of the Smart Credential. */
    private java.util.Calendar createDate;

    /* This value will contain the expiry date
     *                                 of the Smart Credential.  The expiry
     * date
     *                                 may not be set. */
    private java.util.Calendar expiryDate;

    /* A list of Definition specific values collected
     *                                 during enrollment. */
    private NameValue[] enrollmentValues;

    /* A list of variable values for this Smart Credential
     *                                 that can be used to unblock the Smart
     * Credential. */
    private String[] unblockVariables;

    /* A list of digital Ids DNs created for this
     *                                 Smart Credential. */
    private String[] digitalIds;

    /* A flag indicating if this smart credential
     *                                 has digital id details. */
    private boolean hasDigitalIdDetails;

    /* The details for the digital ids created for
     *                                 this Smart Credential.  This information
     * will only be returned from
     *                                 userSmartCredentialInfoGet if the
     * getDetails
     *                                 argument is set to true. */
    private UserDigitalIdDetails[] digitalIdDetails;

    /* If a token is associated with this
     *                                 Smart credential, the TokenVendorId
     * will
     *                                 be set to its token vendor Id. */
    private String tokenVendorId;

    /* If a token is associated with this
     *                                 Smart credential, the TokenSerialNumber
     * will
     *                                 be set to its token serial number. */
    private String tokenSerialNumber;

    /* Friendly name for this user smart credential. */
    private String friendlyName;

    /* A flag indicating if this user smart credential
     *                                 supports PACS.  A user smart credential
     * supports PACS if its smart credential
     *                                 definition includes one or more PACS. */
    private boolean supportsPACS;

    /* A list of smart credential specific parameters.
     *                                 For example, for mobile smart credentials,
     * these parameters might include information
     *                                 about the device on which this smart
     * credential
     *                                 was loaded.  The administrator must
     * have the
     *                                 userSmartCredentialParameterView permission
     * to see these values.  Otherwise a null value
     *                                 will be returned. */
    private NameValue[] smartCredentialParameters;

    /* A flag indicating if this user smart credential
     *                                 supports certificate security challenges. */
    private boolean supportsSecurityChallenge;

    /* If this smart credential has been encoded
     *                                 onto a card this value will show the
     * type
     *                                 of card. */
    private String cardType;

    /* If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the platform type of the
     * mobile application. */
    private String mobilePlatform;

    /* If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the version of the
     *                                 mobile application. */
    private String mobileVersion;

    /* Comments for this user smart credential. */
    private String comment;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    public UserSmartCredentialInfo() {
    }

    public UserSmartCredentialInfo(
           String userid,
           String userName,
           String group,
           String id,
           String definitionId,
           String cloneId,
           String serialNumber,
           Boolean mobile,
           String cardUID,
           SmartCredentialState state,
           byte[][] cardManagerKeys,
           Integer cardManagerKeyVersion,
           com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState,
           java.util.Calendar issueDate,
           String issueInfo,
           boolean sealed,
           boolean approved,
           boolean valid,
           java.util.Calendar createDate,
           java.util.Calendar expiryDate,
           NameValue[] enrollmentValues,
           String[] unblockVariables,
           String[] digitalIds,
           boolean hasDigitalIdDetails,
           UserDigitalIdDetails[] digitalIdDetails,
           String tokenVendorId,
           String tokenSerialNumber,
           String friendlyName,
           boolean supportsPACS,
           NameValue[] smartCredentialParameters,
           boolean supportsSecurityChallenge,
           String cardType,
           String mobilePlatform,
           String mobileVersion,
           String comment,
           String[] rolesGrantingAccess) {
           this.userid = userid;
           this.userName = userName;
           this.group = group;
           this.id = id;
           this.definitionId = definitionId;
           this.cloneId = cloneId;
           this.serialNumber = serialNumber;
           this.mobile = mobile;
           this.cardUID = cardUID;
           this.state = state;
           this.cardManagerKeys = cardManagerKeys;
           this.cardManagerKeyVersion = cardManagerKeyVersion;
           this.issueState = issueState;
           this.issueDate = issueDate;
           this.issueInfo = issueInfo;
           this.sealed = sealed;
           this.approved = approved;
           this.valid = valid;
           this.createDate = createDate;
           this.expiryDate = expiryDate;
           this.enrollmentValues = enrollmentValues;
           this.unblockVariables = unblockVariables;
           this.digitalIds = digitalIds;
           this.hasDigitalIdDetails = hasDigitalIdDetails;
           this.digitalIdDetails = digitalIdDetails;
           this.tokenVendorId = tokenVendorId;
           this.tokenSerialNumber = tokenSerialNumber;
           this.friendlyName = friendlyName;
           this.supportsPACS = supportsPACS;
           this.smartCredentialParameters = smartCredentialParameters;
           this.supportsSecurityChallenge = supportsSecurityChallenge;
           this.cardType = cardType;
           this.mobilePlatform = mobilePlatform;
           this.mobileVersion = mobileVersion;
           this.comment = comment;
           this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the userid value for this UserSmartCredentialInfo.
     * 
     * @return userid   * The user ID that owns the Smart Credential.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserSmartCredentialInfo.
     * 
     * @param userid   * The user ID that owns the Smart Credential.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the userName value for this UserSmartCredentialInfo.
     * 
     * @return userName   * The user name of the user ID  that owns the
     *                                 Smart Credential.
     */
    public String getUserName() {
        return userName;
    }


    /**
     * Sets the userName value for this UserSmartCredentialInfo.
     * 
     * @param userName   * The user name of the user ID  that owns the
     *                                 Smart Credential.
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }


    /**
     * Gets the group value for this UserSmartCredentialInfo.
     * 
     * @return group   * The group of the user ID that owns the Smart Credential.
     */
    public String getGroup() {
        return group;
    }


    /**
     * Sets the group value for this UserSmartCredentialInfo.
     * 
     * @param group   * The group of the user ID that owns the Smart Credential.
     */
    public void setGroup(String group) {
        this.group = group;
    }


    /**
     * Gets the id value for this UserSmartCredentialInfo.
     * 
     * @return id   * This value will contain the Id
     *                                 of the Smart Credential.
     */
    public String getId() {
        return id;
    }


    /**
     * Sets the id value for this UserSmartCredentialInfo.
     * 
     * @param id   * This value will contain the Id
     *                                 of the Smart Credential.
     */
    public void setId(String id) {
        this.id = id;
    }


    /**
     * Gets the definitionId value for this UserSmartCredentialInfo.
     * 
     * @return definitionId   * This value will contain the Smart Credential
     *                                 Definition of the Smart Credential.
     */
    public String getDefinitionId() {
        return definitionId;
    }


    /**
     * Sets the definitionId value for this UserSmartCredentialInfo.
     * 
     * @param definitionId   * This value will contain the Smart Credential
     *                                 Definition of the Smart Credential.
     */
    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }


    /**
     * Gets the cloneId value for this UserSmartCredentialInfo.
     * 
     * @return cloneId   * The id of the smart credential from which
     *                                 this smart credential was cloned.
     * The value
     *                                 will be null of the smart credential
     * was not cloned.
     */
    public String getCloneId() {
        return cloneId;
    }


    /**
     * Sets the cloneId value for this UserSmartCredentialInfo.
     * 
     * @param cloneId   * The id of the smart credential from which
     *                                 this smart credential was cloned.
     * The value
     *                                 will be null of the smart credential
     * was not cloned.
     */
    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }


    /**
     * Gets the serialNumber value for this UserSmartCredentialInfo.
     * 
     * @return serialNumber   * The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this UserSmartCredentialInfo.
     * 
     * @param serialNumber   * The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the mobile value for this UserSmartCredentialInfo.
     * 
     * @return mobile   * Indicates if the serial number is associated
     *                                 with a mobile smart credential.  This
     * value
     *                                 won't be set if the serial number
     * is not set.
     */
    public Boolean getMobile() {
        return mobile;
    }


    /**
     * Sets the mobile value for this UserSmartCredentialInfo.
     * 
     * @param mobile   * Indicates if the serial number is associated
     *                                 with a mobile smart credential.  This
     * value
     *                                 won't be set if the serial number
     * is not set.
     */
    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }


    /**
     * Gets the cardUID value for this UserSmartCredentialInfo.
     * 
     * @return cardUID   * The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded.
     */
    public String getCardUID() {
        return cardUID;
    }


    /**
     * Sets the cardUID value for this UserSmartCredentialInfo.
     * 
     * @param cardUID   * The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded.
     */
    public void setCardUID(String cardUID) {
        this.cardUID = cardUID;
    }


    /**
     * Gets the state value for this UserSmartCredentialInfo.
     * 
     * @return state   * The state of the user smart credential.
     */
    public SmartCredentialState getState() {
        return state;
    }


    /**
     * Sets the state value for this UserSmartCredentialInfo.
     * 
     * @param state   * The state of the user smart credential.
     */
    public void setState(SmartCredentialState state) {
        this.state = state;
    }


    /**
     * Gets the cardManagerKeys value for this UserSmartCredentialInfo.
     * 
     * @return cardManagerKeys   * The card manager keys of this smart
     *                                 credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null.
     */
    public byte[][] getCardManagerKeys() {
        return cardManagerKeys;
    }


    /**
     * Sets the cardManagerKeys value for this UserSmartCredentialInfo.
     * 
     * @param cardManagerKeys   * The card manager keys of this smart
     *                                 credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null.
     */
    public void setCardManagerKeys(byte[][] cardManagerKeys) {
        this.cardManagerKeys = cardManagerKeys;
    }


    /**
     * Gets the cardManagerKeyVersion value for this UserSmartCredentialInfo.
     * 
     * @return cardManagerKeyVersion   * The version of the card manager keys of this
     *                                 smart credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null.
     */
    public Integer getCardManagerKeyVersion() {
        return cardManagerKeyVersion;
    }


    /**
     * Sets the cardManagerKeyVersion value for this UserSmartCredentialInfo.
     * 
     * @param cardManagerKeyVersion   * The version of the card manager keys of this
     *                                 smart credential.  If the admininstrator
     * does
     *                                 not have permission to view the card
     * manager keys, this value will be null.
     */
    public void setCardManagerKeyVersion(Integer cardManagerKeyVersion) {
        this.cardManagerKeyVersion = cardManagerKeyVersion;
    }


    /**
     * Gets the issueState value for this UserSmartCredentialInfo.
     * 
     * @return issueState   * The state of the last print/encode/proximity
     *                                 request.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialIssueState getIssueState() {
        return issueState;
    }


    /**
     * Sets the issueState value for this UserSmartCredentialInfo.
     * 
     * @param issueState   * The state of the last print/encode/proximity
     *                                 request.
     */
    public void setIssueState(com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState) {
        this.issueState = issueState;
    }


    /**
     * Gets the issueDate value for this UserSmartCredentialInfo.
     * 
     * @return issueDate   * The print date of the user smart credential.
     *                                 This value is the last time a
     *                                 print/encode/proximity operation was
     * started.
     */
    public java.util.Calendar getIssueDate() {
        return issueDate;
    }


    /**
     * Sets the issueDate value for this UserSmartCredentialInfo.
     * 
     * @param issueDate   * The print date of the user smart credential.
     *                                 This value is the last time a
     *                                 print/encode/proximity operation was
     * started.
     */
    public void setIssueDate(java.util.Calendar issueDate) {
        this.issueDate = issueDate;
    }


    /**
     * Gets the issueInfo value for this UserSmartCredentialInfo.
     * 
     * @return issueInfo   * Information about the last
     *                                 print/encode/proximity request.
     */
    public String getIssueInfo() {
        return issueInfo;
    }


    /**
     * Sets the issueInfo value for this UserSmartCredentialInfo.
     * 
     * @param issueInfo   * Information about the last
     *                                 print/encode/proximity request.
     */
    public void setIssueInfo(String issueInfo) {
        this.issueInfo = issueInfo;
    }


    /**
     * Gets the sealed value for this UserSmartCredentialInfo.
     * 
     * @return sealed   * A flag indicating if this Smart Credential is sealed
     *                                 or not.  A sealed Smart Credential
     * can not be modified
     *                                 or printed.  Normally a Smart Credential
     * will be
     *                                 sealed after printing is complete.
     */
    public boolean isSealed() {
        return sealed;
    }


    /**
     * Sets the sealed value for this UserSmartCredentialInfo.
     * 
     * @param sealed   * A flag indicating if this Smart Credential is sealed
     *                                 or not.  A sealed Smart Credential
     * can not be modified
     *                                 or printed.  Normally a Smart Credential
     * will be
     *                                 sealed after printing is complete.
     */
    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }


    /**
     * Gets the approved value for this UserSmartCredentialInfo.
     * 
     * @return approved   * A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until
     *                                 approved.
     */
    public boolean isApproved() {
        return approved;
    }


    /**
     * Sets the approved value for this UserSmartCredentialInfo.
     * 
     * @param approved   * A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until
     *                                 approved.
     */
    public void setApproved(boolean approved) {
        this.approved = approved;
    }


    /**
     * Gets the valid value for this UserSmartCredentialInfo.
     * 
     * @return valid   * A flag indicating if the enrollment values
     *                                 for this Smart Credential have been
     * successfully
     *                                 validated against the type description
     * specified in the Definition.
     */
    public boolean isValid() {
        return valid;
    }


    /**
     * Sets the valid value for this UserSmartCredentialInfo.
     * 
     * @param valid   * A flag indicating if the enrollment values
     *                                 for this Smart Credential have been
     * successfully
     *                                 validated against the type description
     * specified in the Definition.
     */
    public void setValid(boolean valid) {
        this.valid = valid;
    }


    /**
     * Gets the createDate value for this UserSmartCredentialInfo.
     * 
     * @return createDate   * This value will contain the creation date
     *                                 of the Smart Credential.
     */
    public java.util.Calendar getCreateDate() {
        return createDate;
    }


    /**
     * Sets the createDate value for this UserSmartCredentialInfo.
     * 
     * @param createDate   * This value will contain the creation date
     *                                 of the Smart Credential.
     */
    public void setCreateDate(java.util.Calendar createDate) {
        this.createDate = createDate;
    }


    /**
     * Gets the expiryDate value for this UserSmartCredentialInfo.
     * 
     * @return expiryDate   * This value will contain the expiry date
     *                                 of the Smart Credential.  The expiry
     * date
     *                                 may not be set.
     */
    public java.util.Calendar getExpiryDate() {
        return expiryDate;
    }


    /**
     * Sets the expiryDate value for this UserSmartCredentialInfo.
     * 
     * @param expiryDate   * This value will contain the expiry date
     *                                 of the Smart Credential.  The expiry
     * date
     *                                 may not be set.
     */
    public void setExpiryDate(java.util.Calendar expiryDate) {
        this.expiryDate = expiryDate;
    }


    /**
     * Gets the enrollmentValues value for this UserSmartCredentialInfo.
     * 
     * @return enrollmentValues   * A list of Definition specific values collected
     *                                 during enrollment.
     */
    public NameValue[] getEnrollmentValues() {
        return enrollmentValues;
    }


    /**
     * Sets the enrollmentValues value for this UserSmartCredentialInfo.
     * 
     * @param enrollmentValues   * A list of Definition specific values collected
     *                                 during enrollment.
     */
    public void setEnrollmentValues(NameValue[] enrollmentValues) {
        this.enrollmentValues = enrollmentValues;
    }


    /**
     * Gets the unblockVariables value for this UserSmartCredentialInfo.
     * 
     * @return unblockVariables   * A list of variable values for this Smart Credential
     *                                 that can be used to unblock the Smart
     * Credential.
     */
    public String[] getUnblockVariables() {
        return unblockVariables;
    }


    /**
     * Sets the unblockVariables value for this UserSmartCredentialInfo.
     * 
     * @param unblockVariables   * A list of variable values for this Smart Credential
     *                                 that can be used to unblock the Smart
     * Credential.
     */
    public void setUnblockVariables(String[] unblockVariables) {
        this.unblockVariables = unblockVariables;
    }


    /**
     * Gets the digitalIds value for this UserSmartCredentialInfo.
     * 
     * @return digitalIds   * A list of digital Ids DNs created for this
     *                                 Smart Credential.
     */
    public String[] getDigitalIds() {
        return digitalIds;
    }


    /**
     * Sets the digitalIds value for this UserSmartCredentialInfo.
     * 
     * @param digitalIds   * A list of digital Ids DNs created for this
     *                                 Smart Credential.
     */
    public void setDigitalIds(String[] digitalIds) {
        this.digitalIds = digitalIds;
    }


    /**
     * Gets the hasDigitalIdDetails value for this UserSmartCredentialInfo.
     * 
     * @return hasDigitalIdDetails   * A flag indicating if this smart credential
     *                                 has digital id details.
     */
    public boolean isHasDigitalIdDetails() {
        return hasDigitalIdDetails;
    }


    /**
     * Sets the hasDigitalIdDetails value for this UserSmartCredentialInfo.
     * 
     * @param hasDigitalIdDetails   * A flag indicating if this smart credential
     *                                 has digital id details.
     */
    public void setHasDigitalIdDetails(boolean hasDigitalIdDetails) {
        this.hasDigitalIdDetails = hasDigitalIdDetails;
    }


    /**
     * Gets the digitalIdDetails value for this UserSmartCredentialInfo.
     * 
     * @return digitalIdDetails   * The details for the digital ids created for
     *                                 this Smart Credential.  This information
     * will only be returned from
     *                                 userSmartCredentialInfoGet if the
     * getDetails
     *                                 argument is set to true.
     */
    public UserDigitalIdDetails[] getDigitalIdDetails() {
        return digitalIdDetails;
    }


    /**
     * Sets the digitalIdDetails value for this UserSmartCredentialInfo.
     * 
     * @param digitalIdDetails   * The details for the digital ids created for
     *                                 this Smart Credential.  This information
     * will only be returned from
     *                                 userSmartCredentialInfoGet if the
     * getDetails
     *                                 argument is set to true.
     */
    public void setDigitalIdDetails(UserDigitalIdDetails[] digitalIdDetails) {
        this.digitalIdDetails = digitalIdDetails;
    }


    /**
     * Gets the tokenVendorId value for this UserSmartCredentialInfo.
     * 
     * @return tokenVendorId   * If a token is associated with this
     *                                 Smart credential, the TokenVendorId
     * will
     *                                 be set to its token vendor Id.
     */
    public String getTokenVendorId() {
        return tokenVendorId;
    }


    /**
     * Sets the tokenVendorId value for this UserSmartCredentialInfo.
     * 
     * @param tokenVendorId   * If a token is associated with this
     *                                 Smart credential, the TokenVendorId
     * will
     *                                 be set to its token vendor Id.
     */
    public void setTokenVendorId(String tokenVendorId) {
        this.tokenVendorId = tokenVendorId;
    }


    /**
     * Gets the tokenSerialNumber value for this UserSmartCredentialInfo.
     * 
     * @return tokenSerialNumber   * If a token is associated with this
     *                                 Smart credential, the TokenSerialNumber
     * will
     *                                 be set to its token serial number.
     */
    public String getTokenSerialNumber() {
        return tokenSerialNumber;
    }


    /**
     * Sets the tokenSerialNumber value for this UserSmartCredentialInfo.
     * 
     * @param tokenSerialNumber   * If a token is associated with this
     *                                 Smart credential, the TokenSerialNumber
     * will
     *                                 be set to its token serial number.
     */
    public void setTokenSerialNumber(String tokenSerialNumber) {
        this.tokenSerialNumber = tokenSerialNumber;
    }


    /**
     * Gets the friendlyName value for this UserSmartCredentialInfo.
     * 
     * @return friendlyName   * Friendly name for this user smart credential.
     */
    public String getFriendlyName() {
        return friendlyName;
    }


    /**
     * Sets the friendlyName value for this UserSmartCredentialInfo.
     * 
     * @param friendlyName   * Friendly name for this user smart credential.
     */
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }


    /**
     * Gets the supportsPACS value for this UserSmartCredentialInfo.
     * 
     * @return supportsPACS   * A flag indicating if this user smart credential
     *                                 supports PACS.  A user smart credential
     * supports PACS if its smart credential
     *                                 definition includes one or more PACS.
     */
    public boolean isSupportsPACS() {
        return supportsPACS;
    }


    /**
     * Sets the supportsPACS value for this UserSmartCredentialInfo.
     * 
     * @param supportsPACS   * A flag indicating if this user smart credential
     *                                 supports PACS.  A user smart credential
     * supports PACS if its smart credential
     *                                 definition includes one or more PACS.
     */
    public void setSupportsPACS(boolean supportsPACS) {
        this.supportsPACS = supportsPACS;
    }


    /**
     * Gets the smartCredentialParameters value for this UserSmartCredentialInfo.
     * 
     * @return smartCredentialParameters   * A list of smart credential specific parameters.
     *                                 For example, for mobile smart credentials,
     * these parameters might include information
     *                                 about the device on which this smart
     * credential
     *                                 was loaded.  The administrator must
     * have the
     *                                 userSmartCredentialParameterView permission
     * to see these values.  Otherwise a null value
     *                                 will be returned.
     */
    public NameValue[] getSmartCredentialParameters() {
        return smartCredentialParameters;
    }


    /**
     * Sets the smartCredentialParameters value for this UserSmartCredentialInfo.
     * 
     * @param smartCredentialParameters   * A list of smart credential specific parameters.
     *                                 For example, for mobile smart credentials,
     * these parameters might include information
     *                                 about the device on which this smart
     * credential
     *                                 was loaded.  The administrator must
     * have the
     *                                 userSmartCredentialParameterView permission
     * to see these values.  Otherwise a null value
     *                                 will be returned.
     */
    public void setSmartCredentialParameters(NameValue[] smartCredentialParameters) {
        this.smartCredentialParameters = smartCredentialParameters;
    }


    /**
     * Gets the supportsSecurityChallenge value for this UserSmartCredentialInfo.
     * 
     * @return supportsSecurityChallenge   * A flag indicating if this user smart credential
     *                                 supports certificate security challenges.
     */
    public boolean isSupportsSecurityChallenge() {
        return supportsSecurityChallenge;
    }


    /**
     * Sets the supportsSecurityChallenge value for this UserSmartCredentialInfo.
     * 
     * @param supportsSecurityChallenge   * A flag indicating if this user smart credential
     *                                 supports certificate security challenges.
     */
    public void setSupportsSecurityChallenge(boolean supportsSecurityChallenge) {
        this.supportsSecurityChallenge = supportsSecurityChallenge;
    }


    /**
     * Gets the cardType value for this UserSmartCredentialInfo.
     * 
     * @return cardType   * If this smart credential has been encoded
     *                                 onto a card this value will show the
     * type
     *                                 of card.
     */
    public String getCardType() {
        return cardType;
    }


    /**
     * Sets the cardType value for this UserSmartCredentialInfo.
     * 
     * @param cardType   * If this smart credential has been encoded
     *                                 onto a card this value will show the
     * type
     *                                 of card.
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }


    /**
     * Gets the mobilePlatform value for this UserSmartCredentialInfo.
     * 
     * @return mobilePlatform   * If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the platform type of the
     * mobile application.
     */
    public String getMobilePlatform() {
        return mobilePlatform;
    }


    /**
     * Sets the mobilePlatform value for this UserSmartCredentialInfo.
     * 
     * @param mobilePlatform   * If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the platform type of the
     * mobile application.
     */
    public void setMobilePlatform(String mobilePlatform) {
        this.mobilePlatform = mobilePlatform;
    }


    /**
     * Gets the mobileVersion value for this UserSmartCredentialInfo.
     * 
     * @return mobileVersion   * If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the version of the
     *                                 mobile application.
     */
    public String getMobileVersion() {
        return mobileVersion;
    }


    /**
     * Sets the mobileVersion value for this UserSmartCredentialInfo.
     * 
     * @param mobileVersion   * If this smart credential has been registered
     *                                 with the Entrust IdentityGuard Mobile
     * Smart Credential application, this value
     *                                 will show the version of the
     *                                 mobile application.
     */
    public void setMobileVersion(String mobileVersion) {
        this.mobileVersion = mobileVersion;
    }


    /**
     * Gets the comment value for this UserSmartCredentialInfo.
     * 
     * @return comment   * Comments for this user smart credential.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserSmartCredentialInfo.
     * 
     * @param comment   * Comments for this user smart credential.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }


    /**
     * Gets the rolesGrantingAccess value for this UserSmartCredentialInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this UserSmartCredentialInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserSmartCredentialInfo)) return false;
        UserSmartCredentialInfo other = (UserSmartCredentialInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.userName==null && other.getUserName()==null) || 
             (this.userName!=null &&
              this.userName.equals(other.getUserName()))) &&
            ((this.group==null && other.getGroup()==null) || 
             (this.group!=null &&
              this.group.equals(other.getGroup()))) &&
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.definitionId==null && other.getDefinitionId()==null) || 
             (this.definitionId!=null &&
              this.definitionId.equals(other.getDefinitionId()))) &&
            ((this.cloneId==null && other.getCloneId()==null) || 
             (this.cloneId!=null &&
              this.cloneId.equals(other.getCloneId()))) &&
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.mobile==null && other.getMobile()==null) || 
             (this.mobile!=null &&
              this.mobile.equals(other.getMobile()))) &&
            ((this.cardUID==null && other.getCardUID()==null) || 
             (this.cardUID!=null &&
              this.cardUID.equals(other.getCardUID()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.cardManagerKeys==null && other.getCardManagerKeys()==null) || 
             (this.cardManagerKeys!=null &&
              java.util.Arrays.equals(this.cardManagerKeys, other.getCardManagerKeys()))) &&
            ((this.cardManagerKeyVersion==null && other.getCardManagerKeyVersion()==null) || 
             (this.cardManagerKeyVersion!=null &&
              this.cardManagerKeyVersion.equals(other.getCardManagerKeyVersion()))) &&
            ((this.issueState==null && other.getIssueState()==null) || 
             (this.issueState!=null &&
              this.issueState.equals(other.getIssueState()))) &&
            ((this.issueDate==null && other.getIssueDate()==null) || 
             (this.issueDate!=null &&
              this.issueDate.equals(other.getIssueDate()))) &&
            ((this.issueInfo==null && other.getIssueInfo()==null) || 
             (this.issueInfo!=null &&
              this.issueInfo.equals(other.getIssueInfo()))) &&
            this.sealed == other.isSealed() &&
            this.approved == other.isApproved() &&
            this.valid == other.isValid() &&
            ((this.createDate==null && other.getCreateDate()==null) || 
             (this.createDate!=null &&
              this.createDate.equals(other.getCreateDate()))) &&
            ((this.expiryDate==null && other.getExpiryDate()==null) || 
             (this.expiryDate!=null &&
              this.expiryDate.equals(other.getExpiryDate()))) &&
            ((this.enrollmentValues==null && other.getEnrollmentValues()==null) || 
             (this.enrollmentValues!=null &&
              java.util.Arrays.equals(this.enrollmentValues, other.getEnrollmentValues()))) &&
            ((this.unblockVariables==null && other.getUnblockVariables()==null) || 
             (this.unblockVariables!=null &&
              java.util.Arrays.equals(this.unblockVariables, other.getUnblockVariables()))) &&
            ((this.digitalIds==null && other.getDigitalIds()==null) || 
             (this.digitalIds!=null &&
              java.util.Arrays.equals(this.digitalIds, other.getDigitalIds()))) &&
            this.hasDigitalIdDetails == other.isHasDigitalIdDetails() &&
            ((this.digitalIdDetails==null && other.getDigitalIdDetails()==null) || 
             (this.digitalIdDetails!=null &&
              java.util.Arrays.equals(this.digitalIdDetails, other.getDigitalIdDetails()))) &&
            ((this.tokenVendorId==null && other.getTokenVendorId()==null) || 
             (this.tokenVendorId!=null &&
              this.tokenVendorId.equals(other.getTokenVendorId()))) &&
            ((this.tokenSerialNumber==null && other.getTokenSerialNumber()==null) || 
             (this.tokenSerialNumber!=null &&
              this.tokenSerialNumber.equals(other.getTokenSerialNumber()))) &&
            ((this.friendlyName==null && other.getFriendlyName()==null) || 
             (this.friendlyName!=null &&
              this.friendlyName.equals(other.getFriendlyName()))) &&
            this.supportsPACS == other.isSupportsPACS() &&
            ((this.smartCredentialParameters==null && other.getSmartCredentialParameters()==null) || 
             (this.smartCredentialParameters!=null &&
              java.util.Arrays.equals(this.smartCredentialParameters, other.getSmartCredentialParameters()))) &&
            this.supportsSecurityChallenge == other.isSupportsSecurityChallenge() &&
            ((this.cardType==null && other.getCardType()==null) || 
             (this.cardType!=null &&
              this.cardType.equals(other.getCardType()))) &&
            ((this.mobilePlatform==null && other.getMobilePlatform()==null) || 
             (this.mobilePlatform!=null &&
              this.mobilePlatform.equals(other.getMobilePlatform()))) &&
            ((this.mobileVersion==null && other.getMobileVersion()==null) || 
             (this.mobileVersion!=null &&
              this.mobileVersion.equals(other.getMobileVersion()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getUserName() != null) {
            _hashCode += getUserName().hashCode();
        }
        if (getGroup() != null) {
            _hashCode += getGroup().hashCode();
        }
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getDefinitionId() != null) {
            _hashCode += getDefinitionId().hashCode();
        }
        if (getCloneId() != null) {
            _hashCode += getCloneId().hashCode();
        }
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getMobile() != null) {
            _hashCode += getMobile().hashCode();
        }
        if (getCardUID() != null) {
            _hashCode += getCardUID().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getCardManagerKeys() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCardManagerKeys());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCardManagerKeys(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCardManagerKeyVersion() != null) {
            _hashCode += getCardManagerKeyVersion().hashCode();
        }
        if (getIssueState() != null) {
            _hashCode += getIssueState().hashCode();
        }
        if (getIssueDate() != null) {
            _hashCode += getIssueDate().hashCode();
        }
        if (getIssueInfo() != null) {
            _hashCode += getIssueInfo().hashCode();
        }
        _hashCode += (isSealed() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isApproved() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isValid() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCreateDate() != null) {
            _hashCode += getCreateDate().hashCode();
        }
        if (getExpiryDate() != null) {
            _hashCode += getExpiryDate().hashCode();
        }
        if (getEnrollmentValues() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getEnrollmentValues());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getEnrollmentValues(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getUnblockVariables() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getUnblockVariables());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getUnblockVariables(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDigitalIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDigitalIds());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDigitalIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isHasDigitalIdDetails() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getDigitalIdDetails() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDigitalIdDetails());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDigitalIdDetails(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getTokenVendorId() != null) {
            _hashCode += getTokenVendorId().hashCode();
        }
        if (getTokenSerialNumber() != null) {
            _hashCode += getTokenSerialNumber().hashCode();
        }
        if (getFriendlyName() != null) {
            _hashCode += getFriendlyName().hashCode();
        }
        _hashCode += (isSupportsPACS() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getSmartCredentialParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isSupportsSecurityChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCardType() != null) {
            _hashCode += getCardType().hashCode();
        }
        if (getMobilePlatform() != null) {
            _hashCode += getMobilePlatform().hashCode();
        }
        if (getMobileVersion() != null) {
            _hashCode += getMobileVersion().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserSmartCredentialInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSmartCredentialInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("group");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Group"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("definitionId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DefinitionId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cloneId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CloneId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobile");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Mobile"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardUID");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardUID"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "State"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialState"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardManagerKeys");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardManagerKeys"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardManagerKeyVersion");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardManagerKeyVersion"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueState");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueState"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialIssueState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sealed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Sealed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("approved");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Approved"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("valid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Valid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CreateDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expiryDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExpiryDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unblockVariables");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UnblockVariables"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIds");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasDigitalIdDetails");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasDigitalIdDetails"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdDetails");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdDetails"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserDigitalIdDetails"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenVendorId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenVendorId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("friendlyName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FriendlyName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supportsPACS");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SupportsPACS"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "smartCredentialParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supportsSecurityChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SupportsSecurityChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardType"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobilePlatform");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobilePlatform"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileVersion");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileVersion"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
