/**
 * UserParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters passed when creating or modifying
 *                         a user. All values can be null indicating
 * that the
 *                         default is used when creating a user, or the
 * value is
 *                         not changed when modifying a user.
 */
public class UserParms  implements java.io.Serializable {
    /* This parameter only applies to the modify operation,
     *                                 and is ignored by other operations.
     * This value is
     *                                 the old value of a user ID and indicates
     * that the
     *                                 user ID is to be modified. */
    private String userid;

    /* The group of the user. When creating a user, if
     *                                 the user ID includes the group, then
     * this value
     *                                 must be null or match the group in
     * the user ID.
     *                                 During creation, if the group is not
     * specified
     *                                 in the user ID nor in this value,
     * then the user
     *                                 is created in the group flagged as
     * the default.
     *                                 When modifying a user, this value
     * can change the
     *                                 group to which the user belongs. */
    private String group;

    /* The name of the partition the user is to be assigned
     *                                 to, overriding the partition the user
     * will be
     *                                 created in or is already assigned
     * to. */
    private String partition;

    /* When creating or updating a user, assign them to
     *                                 no partition, overriding the partition
     * that the user would be created in or is already
     *                                 assigned to.
     *                                 This value is ignored if Partition
     * is specified. */
    private Boolean assignToNoPartition;

    /* The name of the repository that the user's
     *                                 information is to be stored in. If
     * specified, this
     *                                 must be one of the repositories in
     * the list of
     *                                 repositories assigned to the user's
     * group.
     *                                 When modifying a user, this value
     * can change the
     *                                 repository in which the user's data
     * is stored. */
    private String repository;

    /* The user's state.
     *                                 The default during user creation is
     * ACTIVE.
     *                                 When modifying a user, if this is
     * ACTIVE, the
     *                                 SuspendReason is cleared. */
    private UserState userState;

    /* A free-format string indicating the reason for a user suspension. */
    private String suspendReason;

    /* The user's contact information.
     *                                 If specified when modifying a user,
     * the user's
     *                                 contact information list will be replaced
     * by the list
     *                                 in this parameter. */
    private UserContactInfoParms[] contactInfoList;

    /* The user's aliases.
     *                                 If specified during a userSet operation
     * and
     *                                 addAliases is false or null, then
     * the user's
     *                                 existing aliases are replaced by this
     * list. */
    private String[] aliases;

    /* If true, the aliases listed in the Aliases attribute
     *                                 are merged with the existing values
     * instead of
     *                                 replacing the existing values.  If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations. */
    private Boolean addAliases;

    /* A list of aliases to remove from the user. This list
     *                                 is applied after new aliases are added.
     * This parameter
     *                                 only applies to the user set operation,
     * and is ignored
     *                                 by other operations. */
    private String[] removeAliases;

    /* The full name of the user. */
    private String fullName;

    /* The locale of the user. */
    private String locale;

    /* Parameters controlling lockout operations on
     *                                 the user.  This parameter only applies
     * to the
     *                                 userSet operation. */
    private UserLockoutParms lockoutParms;

    /* If set to true, clears the machine secrets of the user.
     *                                 If not specified, this value defaults
     * to false.
     *                                 This parameter only applies to the
     * user set operation,
     *                                 and is ignored by other operations. */
    private Boolean clearMachineSecrets;

    /* If clearMachineSecrets is not set or set to
     *                                 false this attribute can define a
     * list of
     *                                 machine secret nonces that will be
     * removed
     *                                 from the user.  All listed nonces
     * must exist
     *                                 for the user or an error will be returned. */
    private String[] removeMachineSecrets;

    /* A list of shared secrets to assign to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeSecrets is false or null, then
     * the user's
     *                                 existing shared secrets are replaced
     * by this list. */
    private SharedSecret[] sharedSecrets;

    /* If set to true, the SharedSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to the
     *                                 user set operation, and is ignored
     * by other operations. */
    private Boolean mergeSecrets;

    /* A list of shared secret names to be removed. */
    private String[] removeSharedSecrets;

    /* If set to true, remove all shared secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveSharedSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the user
     *                                 set operation, and is ignored by other
     * operations. */
    private Boolean removeAllSecrets;

    /* Question and answer pairs that will be used for
     *                                 QA authentication.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeQaSecrets is false or null, then
     * the user's
     *                                 existing question and answer pairs
     * are replaced
     *                                 by this list. */
    private NameValue[] qaSecrets;

    /* If set to true, the QaSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations. */
    private Boolean mergeQaSecrets;

    /* A list of questions to remove from the list of
     *                                 question and answer pairs. */
    private String[] removeQaSecrets;

    /* If set to true, remove all QA secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveQaSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the
     *                                 user set operation, and is ignored
     * by other
     *                                 operations. */
    private Boolean removeAllQaSecrets;

    /* Secrets to use to allow an application to
     *                                 authenticate itself to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeAuthenticationSecrets is false
     * or null, then the user's
     *                                 existing mutual authentication secrets
     * are replaced
     *                                 by this list.
     *                                 <p>
     *                                 Note that it is up to the application
     * to perform
     *                                 any encoding required so that the
     * mutual
     *                                 authentication secrets can be stored
     * as a string.
     *                                 For example, if the secret is a JPEG
     * image then
     *                                 this image must be encoded as a string
     * before
     *                                 being set here, and the calling application
     * must
     *                                 know how to convert such a string
     * back to the
     *                                 original JPEG image. */
    private NameValue[] authenticationSecrets;

    /* If set to true, the AuthenticationSecrets list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations. */
    private Boolean mergeAuthenticationSecrets;

    /* A list of authentication secret names to be removed. */
    private String[] removeAuthenticationSecrets;

    /* If set to true, removes all authentication secrets.
     *                                 If specified, this value takes precedence
     * over
     *                                 RemoveAuthenticationSecrets.  If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations. */
    private Boolean removeAllAuthenticationSecrets;

    /* The list of the names of the roles assigned to
     *                                 this user. */
    private String[] roles;

    /* If set to true, the Roles list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations. */
    private Boolean mergeRoles;

    /* A list of roles names to be removed from the user's
     *                                 list of roles.  If both MergeRoles
     * is true and
     *                                 this list is non-empty, then this
     * list of roles
     *                                 is removed first, then the other roles
     * specified
     *                                 are merged. It is an error to remove
     * a role that
     *                                 is not already assigned to the user. */
    private String[] removeRoles;

    /* Set the flag indicating if the user is allowed
     *                                 to use a one-time password (OTP) for
     * authentication.
     *                                 If not specified at user creation
     * time, defaults
     *                                 to true. */
    private Boolean OTPAllowed;

    /* If true, use the policy setting for
     *                                 OTPDeliveryEnabled. */
    private Boolean usePolicyForOTPDeliveryEnabled;

    /* A flag indicating if the OTP can be delivered
     *                                 via out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true. */
    private Boolean OTPDeliveryEnabled;

    /* If set to true, use the policy for
     *                                 maxLocationHistorySize. */
    private Boolean usePolicyForMaxLocationHistorySize;

    /* The maximum size of the user location history
     *                                 list.  This attribute can not be set
     * if
     *                                 usePolicyForMaxLocationHistorySize
     * is set to
     *                                 true. */
    private Integer maxLocationHistorySize;

    /* If true, remove all entries from the user's
     *                                 location history list. */
    private Boolean removeAllLocationHistory;

    /* A list of IP addresses of locations to be
     *                                 removed from the user's location history
     * list.
     *                                 This setting is ignored if
     *                                 removeAllLocationHistory is true. */
    private String[] removeLocationHistory;

    /* A list of IP addresses of locations to be
     *                                 added from the user's location history
     * list.
     *                                 This setting is applied after the
     *                                 removeAllLocationHistory or
     *                                 removeLocationHistory arguments. */
    private String[] addLocationHistory;

    /* If set to true, use the policy for
     *                                 checkVelocity. */
    private Boolean usePolicyForCheckVelocity;

    /* If true, the velocity check is performed
     *                                 when authenticating an IP address.
     * This attribute can not be set if
     *                                 usePolicyForCheckVelocity is set to
     * true. */
    private Boolean checkVelocity;

    /* If set to true, use the policy for
     *                                 checkIPAddressInLocationHistory. */
    private Boolean usePolicyForCheckIPAddressInLocationHistory;

    /* If true, the IP address is compared when
     *                                 comparing a location against a user's
     * location history.
     *                                 This attribute can not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is set to true. */
    private Boolean checkIPAddressInLocationHistory;

    /* If true, the expected location settings in
     *                                 policy are used instead of the per
     * user
     *                                 settings. */
    private Boolean usePolicyForExpectedLocations;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 This attribute is ignored if the
     *                                 usePolicyForExpectedLocations is set
     * to
     *                                 true. */
    private ExpectedLocation[] expectedLocations;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set. */
    private Boolean addExpectedLocations;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set or the addExpectedLocations
     * attribute is set. */
    private Boolean removeExpectedLocations;

    /* The code for setting the user Activation Expiry. */
    private ActivationExpiryCode activationExpiryCode;

    /* The number of days until the Activation period expiry.
     *                                 This parameter must be null unless
     * the ActivationExpiryCode
     *                                 is set to NUMDAYS. */
    private Integer activationDaysToExpiry;

    /* Optional descriptive comments about this user.
     *                                 Defaults to an empty string if not
     * specified
     *                                 during user creation. */
    private String comments;

    public UserParms() {
    }

    public UserParms(
           String userid,
           String group,
           String partition,
           Boolean assignToNoPartition,
           String repository,
           UserState userState,
           String suspendReason,
           UserContactInfoParms[] contactInfoList,
           String[] aliases,
           Boolean addAliases,
           String[] removeAliases,
           String fullName,
           String locale,
           UserLockoutParms lockoutParms,
           Boolean clearMachineSecrets,
           String[] removeMachineSecrets,
           SharedSecret[] sharedSecrets,
           Boolean mergeSecrets,
           String[] removeSharedSecrets,
           Boolean removeAllSecrets,
           NameValue[] qaSecrets,
           Boolean mergeQaSecrets,
           String[] removeQaSecrets,
           Boolean removeAllQaSecrets,
           NameValue[] authenticationSecrets,
           Boolean mergeAuthenticationSecrets,
           String[] removeAuthenticationSecrets,
           Boolean removeAllAuthenticationSecrets,
           String[] roles,
           Boolean mergeRoles,
           String[] removeRoles,
           Boolean OTPAllowed,
           Boolean usePolicyForOTPDeliveryEnabled,
           Boolean OTPDeliveryEnabled,
           Boolean usePolicyForMaxLocationHistorySize,
           Integer maxLocationHistorySize,
           Boolean removeAllLocationHistory,
           String[] removeLocationHistory,
           String[] addLocationHistory,
           Boolean usePolicyForCheckVelocity,
           Boolean checkVelocity,
           Boolean usePolicyForCheckIPAddressInLocationHistory,
           Boolean checkIPAddressInLocationHistory,
           Boolean usePolicyForExpectedLocations,
           ExpectedLocation[] expectedLocations,
           Boolean addExpectedLocations,
           Boolean removeExpectedLocations,
           ActivationExpiryCode activationExpiryCode,
           Integer activationDaysToExpiry,
           String comments) {
           this.userid = userid;
           this.group = group;
           this.partition = partition;
           this.assignToNoPartition = assignToNoPartition;
           this.repository = repository;
           this.userState = userState;
           this.suspendReason = suspendReason;
           this.contactInfoList = contactInfoList;
           this.aliases = aliases;
           this.addAliases = addAliases;
           this.removeAliases = removeAliases;
           this.fullName = fullName;
           this.locale = locale;
           this.lockoutParms = lockoutParms;
           this.clearMachineSecrets = clearMachineSecrets;
           this.removeMachineSecrets = removeMachineSecrets;
           this.sharedSecrets = sharedSecrets;
           this.mergeSecrets = mergeSecrets;
           this.removeSharedSecrets = removeSharedSecrets;
           this.removeAllSecrets = removeAllSecrets;
           this.qaSecrets = qaSecrets;
           this.mergeQaSecrets = mergeQaSecrets;
           this.removeQaSecrets = removeQaSecrets;
           this.removeAllQaSecrets = removeAllQaSecrets;
           this.authenticationSecrets = authenticationSecrets;
           this.mergeAuthenticationSecrets = mergeAuthenticationSecrets;
           this.removeAuthenticationSecrets = removeAuthenticationSecrets;
           this.removeAllAuthenticationSecrets = removeAllAuthenticationSecrets;
           this.roles = roles;
           this.mergeRoles = mergeRoles;
           this.removeRoles = removeRoles;
           this.OTPAllowed = OTPAllowed;
           this.usePolicyForOTPDeliveryEnabled = usePolicyForOTPDeliveryEnabled;
           this.OTPDeliveryEnabled = OTPDeliveryEnabled;
           this.usePolicyForMaxLocationHistorySize = usePolicyForMaxLocationHistorySize;
           this.maxLocationHistorySize = maxLocationHistorySize;
           this.removeAllLocationHistory = removeAllLocationHistory;
           this.removeLocationHistory = removeLocationHistory;
           this.addLocationHistory = addLocationHistory;
           this.usePolicyForCheckVelocity = usePolicyForCheckVelocity;
           this.checkVelocity = checkVelocity;
           this.usePolicyForCheckIPAddressInLocationHistory = usePolicyForCheckIPAddressInLocationHistory;
           this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
           this.usePolicyForExpectedLocations = usePolicyForExpectedLocations;
           this.expectedLocations = expectedLocations;
           this.addExpectedLocations = addExpectedLocations;
           this.removeExpectedLocations = removeExpectedLocations;
           this.activationExpiryCode = activationExpiryCode;
           this.activationDaysToExpiry = activationDaysToExpiry;
           this.comments = comments;
    }


    /**
     * Gets the userid value for this UserParms.
     * 
     * @return userid   * This parameter only applies to the modify operation,
     *                                 and is ignored by other operations.
     * This value is
     *                                 the old value of a user ID and indicates
     * that the
     *                                 user ID is to be modified.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserParms.
     * 
     * @param userid   * This parameter only applies to the modify operation,
     *                                 and is ignored by other operations.
     * This value is
     *                                 the old value of a user ID and indicates
     * that the
     *                                 user ID is to be modified.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the group value for this UserParms.
     * 
     * @return group   * The group of the user. When creating a user, if
     *                                 the user ID includes the group, then
     * this value
     *                                 must be null or match the group in
     * the user ID.
     *                                 During creation, if the group is not
     * specified
     *                                 in the user ID nor in this value,
     * then the user
     *                                 is created in the group flagged as
     * the default.
     *                                 When modifying a user, this value
     * can change the
     *                                 group to which the user belongs.
     */
    public String getGroup() {
        return group;
    }


    /**
     * Sets the group value for this UserParms.
     * 
     * @param group   * The group of the user. When creating a user, if
     *                                 the user ID includes the group, then
     * this value
     *                                 must be null or match the group in
     * the user ID.
     *                                 During creation, if the group is not
     * specified
     *                                 in the user ID nor in this value,
     * then the user
     *                                 is created in the group flagged as
     * the default.
     *                                 When modifying a user, this value
     * can change the
     *                                 group to which the user belongs.
     */
    public void setGroup(String group) {
        this.group = group;
    }


    /**
     * Gets the partition value for this UserParms.
     * 
     * @return partition   * The name of the partition the user is to be assigned
     *                                 to, overriding the partition the user
     * will be
     *                                 created in or is already assigned
     * to.
     */
    public String getPartition() {
        return partition;
    }


    /**
     * Sets the partition value for this UserParms.
     * 
     * @param partition   * The name of the partition the user is to be assigned
     *                                 to, overriding the partition the user
     * will be
     *                                 created in or is already assigned
     * to.
     */
    public void setPartition(String partition) {
        this.partition = partition;
    }


    /**
     * Gets the assignToNoPartition value for this UserParms.
     * 
     * @return assignToNoPartition   * When creating or updating a user, assign them to
     *                                 no partition, overriding the partition
     * that the user would be created in or is already
     *                                 assigned to.
     *                                 This value is ignored if Partition
     * is specified.
     */
    public Boolean getAssignToNoPartition() {
        return assignToNoPartition;
    }


    /**
     * Sets the assignToNoPartition value for this UserParms.
     * 
     * @param assignToNoPartition   * When creating or updating a user, assign them to
     *                                 no partition, overriding the partition
     * that the user would be created in or is already
     *                                 assigned to.
     *                                 This value is ignored if Partition
     * is specified.
     */
    public void setAssignToNoPartition(Boolean assignToNoPartition) {
        this.assignToNoPartition = assignToNoPartition;
    }


    /**
     * Gets the repository value for this UserParms.
     * 
     * @return repository   * The name of the repository that the user's
     *                                 information is to be stored in. If
     * specified, this
     *                                 must be one of the repositories in
     * the list of
     *                                 repositories assigned to the user's
     * group.
     *                                 When modifying a user, this value
     * can change the
     *                                 repository in which the user's data
     * is stored.
     */
    public String getRepository() {
        return repository;
    }


    /**
     * Sets the repository value for this UserParms.
     * 
     * @param repository   * The name of the repository that the user's
     *                                 information is to be stored in. If
     * specified, this
     *                                 must be one of the repositories in
     * the list of
     *                                 repositories assigned to the user's
     * group.
     *                                 When modifying a user, this value
     * can change the
     *                                 repository in which the user's data
     * is stored.
     */
    public void setRepository(String repository) {
        this.repository = repository;
    }


    /**
     * Gets the userState value for this UserParms.
     * 
     * @return userState   * The user's state.
     *                                 The default during user creation is
     * ACTIVE.
     *                                 When modifying a user, if this is
     * ACTIVE, the
     *                                 SuspendReason is cleared.
     */
    public UserState getUserState() {
        return userState;
    }


    /**
     * Sets the userState value for this UserParms.
     * 
     * @param userState   * The user's state.
     *                                 The default during user creation is
     * ACTIVE.
     *                                 When modifying a user, if this is
     * ACTIVE, the
     *                                 SuspendReason is cleared.
     */
    public void setUserState(UserState userState) {
        this.userState = userState;
    }


    /**
     * Gets the suspendReason value for this UserParms.
     * 
     * @return suspendReason   * A free-format string indicating the reason for a user suspension.
     */
    public String getSuspendReason() {
        return suspendReason;
    }


    /**
     * Sets the suspendReason value for this UserParms.
     * 
     * @param suspendReason   * A free-format string indicating the reason for a user suspension.
     */
    public void setSuspendReason(String suspendReason) {
        this.suspendReason = suspendReason;
    }


    /**
     * Gets the contactInfoList value for this UserParms.
     * 
     * @return contactInfoList   * The user's contact information.
     *                                 If specified when modifying a user,
     * the user's
     *                                 contact information list will be replaced
     * by the list
     *                                 in this parameter.
     */
    public UserContactInfoParms[] getContactInfoList() {
        return contactInfoList;
    }


    /**
     * Sets the contactInfoList value for this UserParms.
     * 
     * @param contactInfoList   * The user's contact information.
     *                                 If specified when modifying a user,
     * the user's
     *                                 contact information list will be replaced
     * by the list
     *                                 in this parameter.
     */
    public void setContactInfoList(UserContactInfoParms[] contactInfoList) {
        this.contactInfoList = contactInfoList;
    }


    /**
     * Gets the aliases value for this UserParms.
     * 
     * @return aliases   * The user's aliases.
     *                                 If specified during a userSet operation
     * and
     *                                 addAliases is false or null, then
     * the user's
     *                                 existing aliases are replaced by this
     * list.
     */
    public String[] getAliases() {
        return aliases;
    }


    /**
     * Sets the aliases value for this UserParms.
     * 
     * @param aliases   * The user's aliases.
     *                                 If specified during a userSet operation
     * and
     *                                 addAliases is false or null, then
     * the user's
     *                                 existing aliases are replaced by this
     * list.
     */
    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }


    /**
     * Gets the addAliases value for this UserParms.
     * 
     * @return addAliases   * If true, the aliases listed in the Aliases attribute
     *                                 are merged with the existing values
     * instead of
     *                                 replacing the existing values.  If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public Boolean getAddAliases() {
        return addAliases;
    }


    /**
     * Sets the addAliases value for this UserParms.
     * 
     * @param addAliases   * If true, the aliases listed in the Aliases attribute
     *                                 are merged with the existing values
     * instead of
     *                                 replacing the existing values.  If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public void setAddAliases(Boolean addAliases) {
        this.addAliases = addAliases;
    }


    /**
     * Gets the removeAliases value for this UserParms.
     * 
     * @return removeAliases   * A list of aliases to remove from the user. This list
     *                                 is applied after new aliases are added.
     * This parameter
     *                                 only applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public String[] getRemoveAliases() {
        return removeAliases;
    }


    /**
     * Sets the removeAliases value for this UserParms.
     * 
     * @param removeAliases   * A list of aliases to remove from the user. This list
     *                                 is applied after new aliases are added.
     * This parameter
     *                                 only applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public void setRemoveAliases(String[] removeAliases) {
        this.removeAliases = removeAliases;
    }


    /**
     * Gets the fullName value for this UserParms.
     * 
     * @return fullName   * The full name of the user.
     */
    public String getFullName() {
        return fullName;
    }


    /**
     * Sets the fullName value for this UserParms.
     * 
     * @param fullName   * The full name of the user.
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }


    /**
     * Gets the locale value for this UserParms.
     * 
     * @return locale   * The locale of the user.
     */
    public String getLocale() {
        return locale;
    }


    /**
     * Sets the locale value for this UserParms.
     * 
     * @param locale   * The locale of the user.
     */
    public void setLocale(String locale) {
        this.locale = locale;
    }


    /**
     * Gets the lockoutParms value for this UserParms.
     * 
     * @return lockoutParms   * Parameters controlling lockout operations on
     *                                 the user.  This parameter only applies
     * to the
     *                                 userSet operation.
     */
    public UserLockoutParms getLockoutParms() {
        return lockoutParms;
    }


    /**
     * Sets the lockoutParms value for this UserParms.
     * 
     * @param lockoutParms   * Parameters controlling lockout operations on
     *                                 the user.  This parameter only applies
     * to the
     *                                 userSet operation.
     */
    public void setLockoutParms(UserLockoutParms lockoutParms) {
        this.lockoutParms = lockoutParms;
    }


    /**
     * Gets the clearMachineSecrets value for this UserParms.
     * 
     * @return clearMachineSecrets   * If set to true, clears the machine secrets of the user.
     *                                 If not specified, this value defaults
     * to false.
     *                                 This parameter only applies to the
     * user set operation,
     *                                 and is ignored by other operations.
     */
    public Boolean getClearMachineSecrets() {
        return clearMachineSecrets;
    }


    /**
     * Sets the clearMachineSecrets value for this UserParms.
     * 
     * @param clearMachineSecrets   * If set to true, clears the machine secrets of the user.
     *                                 If not specified, this value defaults
     * to false.
     *                                 This parameter only applies to the
     * user set operation,
     *                                 and is ignored by other operations.
     */
    public void setClearMachineSecrets(Boolean clearMachineSecrets) {
        this.clearMachineSecrets = clearMachineSecrets;
    }


    /**
     * Gets the removeMachineSecrets value for this UserParms.
     * 
     * @return removeMachineSecrets   * If clearMachineSecrets is not set or set to
     *                                 false this attribute can define a
     * list of
     *                                 machine secret nonces that will be
     * removed
     *                                 from the user.  All listed nonces
     * must exist
     *                                 for the user or an error will be returned.
     */
    public String[] getRemoveMachineSecrets() {
        return removeMachineSecrets;
    }


    /**
     * Sets the removeMachineSecrets value for this UserParms.
     * 
     * @param removeMachineSecrets   * If clearMachineSecrets is not set or set to
     *                                 false this attribute can define a
     * list of
     *                                 machine secret nonces that will be
     * removed
     *                                 from the user.  All listed nonces
     * must exist
     *                                 for the user or an error will be returned.
     */
    public void setRemoveMachineSecrets(String[] removeMachineSecrets) {
        this.removeMachineSecrets = removeMachineSecrets;
    }


    /**
     * Gets the sharedSecrets value for this UserParms.
     * 
     * @return sharedSecrets   * A list of shared secrets to assign to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeSecrets is false or null, then
     * the user's
     *                                 existing shared secrets are replaced
     * by this list.
     */
    public SharedSecret[] getSharedSecrets() {
        return sharedSecrets;
    }


    /**
     * Sets the sharedSecrets value for this UserParms.
     * 
     * @param sharedSecrets   * A list of shared secrets to assign to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeSecrets is false or null, then
     * the user's
     *                                 existing shared secrets are replaced
     * by this list.
     */
    public void setSharedSecrets(SharedSecret[] sharedSecrets) {
        this.sharedSecrets = sharedSecrets;
    }


    /**
     * Gets the mergeSecrets value for this UserParms.
     * 
     * @return mergeSecrets   * If set to true, the SharedSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to the
     *                                 user set operation, and is ignored
     * by other operations.
     */
    public Boolean getMergeSecrets() {
        return mergeSecrets;
    }


    /**
     * Sets the mergeSecrets value for this UserParms.
     * 
     * @param mergeSecrets   * If set to true, the SharedSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to the
     *                                 user set operation, and is ignored
     * by other operations.
     */
    public void setMergeSecrets(Boolean mergeSecrets) {
        this.mergeSecrets = mergeSecrets;
    }


    /**
     * Gets the removeSharedSecrets value for this UserParms.
     * 
     * @return removeSharedSecrets   * A list of shared secret names to be removed.
     */
    public String[] getRemoveSharedSecrets() {
        return removeSharedSecrets;
    }


    /**
     * Sets the removeSharedSecrets value for this UserParms.
     * 
     * @param removeSharedSecrets   * A list of shared secret names to be removed.
     */
    public void setRemoveSharedSecrets(String[] removeSharedSecrets) {
        this.removeSharedSecrets = removeSharedSecrets;
    }


    /**
     * Gets the removeAllSecrets value for this UserParms.
     * 
     * @return removeAllSecrets   * If set to true, remove all shared secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveSharedSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the user
     *                                 set operation, and is ignored by other
     * operations.
     */
    public Boolean getRemoveAllSecrets() {
        return removeAllSecrets;
    }


    /**
     * Sets the removeAllSecrets value for this UserParms.
     * 
     * @param removeAllSecrets   * If set to true, remove all shared secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveSharedSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the user
     *                                 set operation, and is ignored by other
     * operations.
     */
    public void setRemoveAllSecrets(Boolean removeAllSecrets) {
        this.removeAllSecrets = removeAllSecrets;
    }


    /**
     * Gets the qaSecrets value for this UserParms.
     * 
     * @return qaSecrets   * Question and answer pairs that will be used for
     *                                 QA authentication.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeQaSecrets is false or null, then
     * the user's
     *                                 existing question and answer pairs
     * are replaced
     *                                 by this list.
     */
    public NameValue[] getQaSecrets() {
        return qaSecrets;
    }


    /**
     * Sets the qaSecrets value for this UserParms.
     * 
     * @param qaSecrets   * Question and answer pairs that will be used for
     *                                 QA authentication.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeQaSecrets is false or null, then
     * the user's
     *                                 existing question and answer pairs
     * are replaced
     *                                 by this list.
     */
    public void setQaSecrets(NameValue[] qaSecrets) {
        this.qaSecrets = qaSecrets;
    }


    /**
     * Gets the mergeQaSecrets value for this UserParms.
     * 
     * @return mergeQaSecrets   * If set to true, the QaSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public Boolean getMergeQaSecrets() {
        return mergeQaSecrets;
    }


    /**
     * Sets the mergeQaSecrets value for this UserParms.
     * 
     * @param mergeQaSecrets   * If set to true, the QaSecrets list is merged with
     *                                 the existing values. If not specified,
     * this value
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public void setMergeQaSecrets(Boolean mergeQaSecrets) {
        this.mergeQaSecrets = mergeQaSecrets;
    }


    /**
     * Gets the removeQaSecrets value for this UserParms.
     * 
     * @return removeQaSecrets   * A list of questions to remove from the list of
     *                                 question and answer pairs.
     */
    public String[] getRemoveQaSecrets() {
        return removeQaSecrets;
    }


    /**
     * Sets the removeQaSecrets value for this UserParms.
     * 
     * @param removeQaSecrets   * A list of questions to remove from the list of
     *                                 question and answer pairs.
     */
    public void setRemoveQaSecrets(String[] removeQaSecrets) {
        this.removeQaSecrets = removeQaSecrets;
    }


    /**
     * Gets the removeAllQaSecrets value for this UserParms.
     * 
     * @return removeAllQaSecrets   * If set to true, remove all QA secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveQaSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the
     *                                 user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public Boolean getRemoveAllQaSecrets() {
        return removeAllQaSecrets;
    }


    /**
     * Sets the removeAllQaSecrets value for this UserParms.
     * 
     * @param removeAllQaSecrets   * If set to true, remove all QA secrets. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveQaSecrets. If not specified
     * it defaults
     *                                 to false. This parameter only applies
     * to the
     *                                 user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public void setRemoveAllQaSecrets(Boolean removeAllQaSecrets) {
        this.removeAllQaSecrets = removeAllQaSecrets;
    }


    /**
     * Gets the authenticationSecrets value for this UserParms.
     * 
     * @return authenticationSecrets   * Secrets to use to allow an application to
     *                                 authenticate itself to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeAuthenticationSecrets is false
     * or null, then the user's
     *                                 existing mutual authentication secrets
     * are replaced
     *                                 by this list.
     *                                 <p>
     *                                 Note that it is up to the application
     * to perform
     *                                 any encoding required so that the
     * mutual
     *                                 authentication secrets can be stored
     * as a string.
     *                                 For example, if the secret is a JPEG
     * image then
     *                                 this image must be encoded as a string
     * before
     *                                 being set here, and the calling application
     * must
     *                                 know how to convert such a string
     * back to the
     *                                 original JPEG image.
     */
    public NameValue[] getAuthenticationSecrets() {
        return authenticationSecrets;
    }


    /**
     * Sets the authenticationSecrets value for this UserParms.
     * 
     * @param authenticationSecrets   * Secrets to use to allow an application to
     *                                 authenticate itself to the user.
     *                                 If specified during a userSet operation
     * and
     *                                 MergeAuthenticationSecrets is false
     * or null, then the user's
     *                                 existing mutual authentication secrets
     * are replaced
     *                                 by this list.
     *                                 <p>
     *                                 Note that it is up to the application
     * to perform
     *                                 any encoding required so that the
     * mutual
     *                                 authentication secrets can be stored
     * as a string.
     *                                 For example, if the secret is a JPEG
     * image then
     *                                 this image must be encoded as a string
     * before
     *                                 being set here, and the calling application
     * must
     *                                 know how to convert such a string
     * back to the
     *                                 original JPEG image.
     */
    public void setAuthenticationSecrets(NameValue[] authenticationSecrets) {
        this.authenticationSecrets = authenticationSecrets;
    }


    /**
     * Gets the mergeAuthenticationSecrets value for this UserParms.
     * 
     * @return mergeAuthenticationSecrets   * If set to true, the AuthenticationSecrets list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public Boolean getMergeAuthenticationSecrets() {
        return mergeAuthenticationSecrets;
    }


    /**
     * Sets the mergeAuthenticationSecrets value for this UserParms.
     * 
     * @param mergeAuthenticationSecrets   * If set to true, the AuthenticationSecrets list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public void setMergeAuthenticationSecrets(Boolean mergeAuthenticationSecrets) {
        this.mergeAuthenticationSecrets = mergeAuthenticationSecrets;
    }


    /**
     * Gets the removeAuthenticationSecrets value for this UserParms.
     * 
     * @return removeAuthenticationSecrets   * A list of authentication secret names to be removed.
     */
    public String[] getRemoveAuthenticationSecrets() {
        return removeAuthenticationSecrets;
    }


    /**
     * Sets the removeAuthenticationSecrets value for this UserParms.
     * 
     * @param removeAuthenticationSecrets   * A list of authentication secret names to be removed.
     */
    public void setRemoveAuthenticationSecrets(String[] removeAuthenticationSecrets) {
        this.removeAuthenticationSecrets = removeAuthenticationSecrets;
    }


    /**
     * Gets the removeAllAuthenticationSecrets value for this UserParms.
     * 
     * @return removeAllAuthenticationSecrets   * If set to true, removes all authentication secrets.
     *                                 If specified, this value takes precedence
     * over
     *                                 RemoveAuthenticationSecrets.  If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public Boolean getRemoveAllAuthenticationSecrets() {
        return removeAllAuthenticationSecrets;
    }


    /**
     * Sets the removeAllAuthenticationSecrets value for this UserParms.
     * 
     * @param removeAllAuthenticationSecrets   * If set to true, removes all authentication secrets.
     *                                 If specified, this value takes precedence
     * over
     *                                 RemoveAuthenticationSecrets.  If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies to
     *                                 the user set operation, and is ignored
     * by other
     *                                 operations.
     */
    public void setRemoveAllAuthenticationSecrets(Boolean removeAllAuthenticationSecrets) {
        this.removeAllAuthenticationSecrets = removeAllAuthenticationSecrets;
    }


    /**
     * Gets the roles value for this UserParms.
     * 
     * @return roles   * The list of the names of the roles assigned to
     *                                 this user.
     */
    public String[] getRoles() {
        return roles;
    }


    /**
     * Sets the roles value for this UserParms.
     * 
     * @param roles   * The list of the names of the roles assigned to
     *                                 this user.
     */
    public void setRoles(String[] roles) {
        this.roles = roles;
    }


    /**
     * Gets the mergeRoles value for this UserParms.
     * 
     * @return mergeRoles   * If set to true, the Roles list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public Boolean getMergeRoles() {
        return mergeRoles;
    }


    /**
     * Sets the mergeRoles value for this UserParms.
     * 
     * @param mergeRoles   * If set to true, the Roles list is
     *                                 merged with the existing values. If
     * not specified,
     *                                 this value defaults to false.  This
     * parameter only
     *                                 applies to the user set operation,
     * and is ignored
     *                                 by other operations.
     */
    public void setMergeRoles(Boolean mergeRoles) {
        this.mergeRoles = mergeRoles;
    }


    /**
     * Gets the removeRoles value for this UserParms.
     * 
     * @return removeRoles   * A list of roles names to be removed from the user's
     *                                 list of roles.  If both MergeRoles
     * is true and
     *                                 this list is non-empty, then this
     * list of roles
     *                                 is removed first, then the other roles
     * specified
     *                                 are merged. It is an error to remove
     * a role that
     *                                 is not already assigned to the user.
     */
    public String[] getRemoveRoles() {
        return removeRoles;
    }


    /**
     * Sets the removeRoles value for this UserParms.
     * 
     * @param removeRoles   * A list of roles names to be removed from the user's
     *                                 list of roles.  If both MergeRoles
     * is true and
     *                                 this list is non-empty, then this
     * list of roles
     *                                 is removed first, then the other roles
     * specified
     *                                 are merged. It is an error to remove
     * a role that
     *                                 is not already assigned to the user.
     */
    public void setRemoveRoles(String[] removeRoles) {
        this.removeRoles = removeRoles;
    }


    /**
     * Gets the OTPAllowed value for this UserParms.
     * 
     * @return OTPAllowed   * Set the flag indicating if the user is allowed
     *                                 to use a one-time password (OTP) for
     * authentication.
     *                                 If not specified at user creation
     * time, defaults
     *                                 to true.
     */
    public Boolean getOTPAllowed() {
        return OTPAllowed;
    }


    /**
     * Sets the OTPAllowed value for this UserParms.
     * 
     * @param OTPAllowed   * Set the flag indicating if the user is allowed
     *                                 to use a one-time password (OTP) for
     * authentication.
     *                                 If not specified at user creation
     * time, defaults
     *                                 to true.
     */
    public void setOTPAllowed(Boolean OTPAllowed) {
        this.OTPAllowed = OTPAllowed;
    }


    /**
     * Gets the usePolicyForOTPDeliveryEnabled value for this UserParms.
     * 
     * @return usePolicyForOTPDeliveryEnabled   * If true, use the policy setting for
     *                                 OTPDeliveryEnabled.
     */
    public Boolean getUsePolicyForOTPDeliveryEnabled() {
        return usePolicyForOTPDeliveryEnabled;
    }


    /**
     * Sets the usePolicyForOTPDeliveryEnabled value for this UserParms.
     * 
     * @param usePolicyForOTPDeliveryEnabled   * If true, use the policy setting for
     *                                 OTPDeliveryEnabled.
     */
    public void setUsePolicyForOTPDeliveryEnabled(Boolean usePolicyForOTPDeliveryEnabled) {
        this.usePolicyForOTPDeliveryEnabled = usePolicyForOTPDeliveryEnabled;
    }


    /**
     * Gets the OTPDeliveryEnabled value for this UserParms.
     * 
     * @return OTPDeliveryEnabled   * A flag indicating if the OTP can be delivered
     *                                 via out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true.
     */
    public Boolean getOTPDeliveryEnabled() {
        return OTPDeliveryEnabled;
    }


    /**
     * Sets the OTPDeliveryEnabled value for this UserParms.
     * 
     * @param OTPDeliveryEnabled   * A flag indicating if the OTP can be delivered
     *                                 via out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true.
     */
    public void setOTPDeliveryEnabled(Boolean OTPDeliveryEnabled) {
        this.OTPDeliveryEnabled = OTPDeliveryEnabled;
    }


    /**
     * Gets the usePolicyForMaxLocationHistorySize value for this UserParms.
     * 
     * @return usePolicyForMaxLocationHistorySize   * If set to true, use the policy for
     *                                 maxLocationHistorySize.
     */
    public Boolean getUsePolicyForMaxLocationHistorySize() {
        return usePolicyForMaxLocationHistorySize;
    }


    /**
     * Sets the usePolicyForMaxLocationHistorySize value for this UserParms.
     * 
     * @param usePolicyForMaxLocationHistorySize   * If set to true, use the policy for
     *                                 maxLocationHistorySize.
     */
    public void setUsePolicyForMaxLocationHistorySize(Boolean usePolicyForMaxLocationHistorySize) {
        this.usePolicyForMaxLocationHistorySize = usePolicyForMaxLocationHistorySize;
    }


    /**
     * Gets the maxLocationHistorySize value for this UserParms.
     * 
     * @return maxLocationHistorySize   * The maximum size of the user location history
     *                                 list.  This attribute can not be set
     * if
     *                                 usePolicyForMaxLocationHistorySize
     * is set to
     *                                 true.
     */
    public Integer getMaxLocationHistorySize() {
        return maxLocationHistorySize;
    }


    /**
     * Sets the maxLocationHistorySize value for this UserParms.
     * 
     * @param maxLocationHistorySize   * The maximum size of the user location history
     *                                 list.  This attribute can not be set
     * if
     *                                 usePolicyForMaxLocationHistorySize
     * is set to
     *                                 true.
     */
    public void setMaxLocationHistorySize(Integer maxLocationHistorySize) {
        this.maxLocationHistorySize = maxLocationHistorySize;
    }


    /**
     * Gets the removeAllLocationHistory value for this UserParms.
     * 
     * @return removeAllLocationHistory   * If true, remove all entries from the user's
     *                                 location history list.
     */
    public Boolean getRemoveAllLocationHistory() {
        return removeAllLocationHistory;
    }


    /**
     * Sets the removeAllLocationHistory value for this UserParms.
     * 
     * @param removeAllLocationHistory   * If true, remove all entries from the user's
     *                                 location history list.
     */
    public void setRemoveAllLocationHistory(Boolean removeAllLocationHistory) {
        this.removeAllLocationHistory = removeAllLocationHistory;
    }


    /**
     * Gets the removeLocationHistory value for this UserParms.
     * 
     * @return removeLocationHistory   * A list of IP addresses of locations to be
     *                                 removed from the user's location history
     * list.
     *                                 This setting is ignored if
     *                                 removeAllLocationHistory is true.
     */
    public String[] getRemoveLocationHistory() {
        return removeLocationHistory;
    }


    /**
     * Sets the removeLocationHistory value for this UserParms.
     * 
     * @param removeLocationHistory   * A list of IP addresses of locations to be
     *                                 removed from the user's location history
     * list.
     *                                 This setting is ignored if
     *                                 removeAllLocationHistory is true.
     */
    public void setRemoveLocationHistory(String[] removeLocationHistory) {
        this.removeLocationHistory = removeLocationHistory;
    }


    /**
     * Gets the addLocationHistory value for this UserParms.
     * 
     * @return addLocationHistory   * A list of IP addresses of locations to be
     *                                 added from the user's location history
     * list.
     *                                 This setting is applied after the
     *                                 removeAllLocationHistory or
     *                                 removeLocationHistory arguments.
     */
    public String[] getAddLocationHistory() {
        return addLocationHistory;
    }


    /**
     * Sets the addLocationHistory value for this UserParms.
     * 
     * @param addLocationHistory   * A list of IP addresses of locations to be
     *                                 added from the user's location history
     * list.
     *                                 This setting is applied after the
     *                                 removeAllLocationHistory or
     *                                 removeLocationHistory arguments.
     */
    public void setAddLocationHistory(String[] addLocationHistory) {
        this.addLocationHistory = addLocationHistory;
    }


    /**
     * Gets the usePolicyForCheckVelocity value for this UserParms.
     * 
     * @return usePolicyForCheckVelocity   * If set to true, use the policy for
     *                                 checkVelocity.
     */
    public Boolean getUsePolicyForCheckVelocity() {
        return usePolicyForCheckVelocity;
    }


    /**
     * Sets the usePolicyForCheckVelocity value for this UserParms.
     * 
     * @param usePolicyForCheckVelocity   * If set to true, use the policy for
     *                                 checkVelocity.
     */
    public void setUsePolicyForCheckVelocity(Boolean usePolicyForCheckVelocity) {
        this.usePolicyForCheckVelocity = usePolicyForCheckVelocity;
    }


    /**
     * Gets the checkVelocity value for this UserParms.
     * 
     * @return checkVelocity   * If true, the velocity check is performed
     *                                 when authenticating an IP address.
     * This attribute can not be set if
     *                                 usePolicyForCheckVelocity is set to
     * true.
     */
    public Boolean getCheckVelocity() {
        return checkVelocity;
    }


    /**
     * Sets the checkVelocity value for this UserParms.
     * 
     * @param checkVelocity   * If true, the velocity check is performed
     *                                 when authenticating an IP address.
     * This attribute can not be set if
     *                                 usePolicyForCheckVelocity is set to
     * true.
     */
    public void setCheckVelocity(Boolean checkVelocity) {
        this.checkVelocity = checkVelocity;
    }


    /**
     * Gets the usePolicyForCheckIPAddressInLocationHistory value for this UserParms.
     * 
     * @return usePolicyForCheckIPAddressInLocationHistory   * If set to true, use the policy for
     *                                 checkIPAddressInLocationHistory.
     */
    public Boolean getUsePolicyForCheckIPAddressInLocationHistory() {
        return usePolicyForCheckIPAddressInLocationHistory;
    }


    /**
     * Sets the usePolicyForCheckIPAddressInLocationHistory value for this UserParms.
     * 
     * @param usePolicyForCheckIPAddressInLocationHistory   * If set to true, use the policy for
     *                                 checkIPAddressInLocationHistory.
     */
    public void setUsePolicyForCheckIPAddressInLocationHistory(Boolean usePolicyForCheckIPAddressInLocationHistory) {
        this.usePolicyForCheckIPAddressInLocationHistory = usePolicyForCheckIPAddressInLocationHistory;
    }


    /**
     * Gets the checkIPAddressInLocationHistory value for this UserParms.
     * 
     * @return checkIPAddressInLocationHistory   * If true, the IP address is compared when
     *                                 comparing a location against a user's
     * location history.
     *                                 This attribute can not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is set to true.
     */
    public Boolean getCheckIPAddressInLocationHistory() {
        return checkIPAddressInLocationHistory;
    }


    /**
     * Sets the checkIPAddressInLocationHistory value for this UserParms.
     * 
     * @param checkIPAddressInLocationHistory   * If true, the IP address is compared when
     *                                 comparing a location against a user's
     * location history.
     *                                 This attribute can not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is set to true.
     */
    public void setCheckIPAddressInLocationHistory(Boolean checkIPAddressInLocationHistory) {
        this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
    }


    /**
     * Gets the usePolicyForExpectedLocations value for this UserParms.
     * 
     * @return usePolicyForExpectedLocations   * If true, the expected location settings in
     *                                 policy are used instead of the per
     * user
     *                                 settings.
     */
    public Boolean getUsePolicyForExpectedLocations() {
        return usePolicyForExpectedLocations;
    }


    /**
     * Sets the usePolicyForExpectedLocations value for this UserParms.
     * 
     * @param usePolicyForExpectedLocations   * If true, the expected location settings in
     *                                 policy are used instead of the per
     * user
     *                                 settings.
     */
    public void setUsePolicyForExpectedLocations(Boolean usePolicyForExpectedLocations) {
        this.usePolicyForExpectedLocations = usePolicyForExpectedLocations;
    }


    /**
     * Gets the expectedLocations value for this UserParms.
     * 
     * @return expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 This attribute is ignored if the
     *                                 usePolicyForExpectedLocations is set
     * to
     *                                 true.
     */
    public ExpectedLocation[] getExpectedLocations() {
        return expectedLocations;
    }


    /**
     * Sets the expectedLocations value for this UserParms.
     * 
     * @param expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 This attribute is ignored if the
     *                                 usePolicyForExpectedLocations is set
     * to
     *                                 true.
     */
    public void setExpectedLocations(ExpectedLocation[] expectedLocations) {
        this.expectedLocations = expectedLocations;
    }


    /**
     * Gets the addExpectedLocations value for this UserParms.
     * 
     * @return addExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set.
     */
    public Boolean getAddExpectedLocations() {
        return addExpectedLocations;
    }


    /**
     * Sets the addExpectedLocations value for this UserParms.
     * 
     * @param addExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set.
     */
    public void setAddExpectedLocations(Boolean addExpectedLocations) {
        this.addExpectedLocations = addExpectedLocations;
    }


    /**
     * Gets the removeExpectedLocations value for this UserParms.
     * 
     * @return removeExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set or the addExpectedLocations
     * attribute is set.
     */
    public Boolean getRemoveExpectedLocations() {
        return removeExpectedLocations;
    }


    /**
     * Sets the removeExpectedLocations value for this UserParms.
     * 
     * @param removeExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set or the addExpectedLocations
     * attribute is set.
     */
    public void setRemoveExpectedLocations(Boolean removeExpectedLocations) {
        this.removeExpectedLocations = removeExpectedLocations;
    }


    /**
     * Gets the activationExpiryCode value for this UserParms.
     * 
     * @return activationExpiryCode   * The code for setting the user Activation Expiry.
     */
    public ActivationExpiryCode getActivationExpiryCode() {
        return activationExpiryCode;
    }


    /**
     * Sets the activationExpiryCode value for this UserParms.
     * 
     * @param activationExpiryCode   * The code for setting the user Activation Expiry.
     */
    public void setActivationExpiryCode(ActivationExpiryCode activationExpiryCode) {
        this.activationExpiryCode = activationExpiryCode;
    }


    /**
     * Gets the activationDaysToExpiry value for this UserParms.
     * 
     * @return activationDaysToExpiry   * The number of days until the Activation period expiry.
     *                                 This parameter must be null unless
     * the ActivationExpiryCode
     *                                 is set to NUMDAYS.
     */
    public Integer getActivationDaysToExpiry() {
        return activationDaysToExpiry;
    }


    /**
     * Sets the activationDaysToExpiry value for this UserParms.
     * 
     * @param activationDaysToExpiry   * The number of days until the Activation period expiry.
     *                                 This parameter must be null unless
     * the ActivationExpiryCode
     *                                 is set to NUMDAYS.
     */
    public void setActivationDaysToExpiry(Integer activationDaysToExpiry) {
        this.activationDaysToExpiry = activationDaysToExpiry;
    }


    /**
     * Gets the comments value for this UserParms.
     * 
     * @return comments   * Optional descriptive comments about this user.
     *                                 Defaults to an empty string if not
     * specified
     *                                 during user creation.
     */
    public String getComments() {
        return comments;
    }


    /**
     * Sets the comments value for this UserParms.
     * 
     * @param comments   * Optional descriptive comments about this user.
     *                                 Defaults to an empty string if not
     * specified
     *                                 during user creation.
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserParms)) return false;
        UserParms other = (UserParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.group==null && other.getGroup()==null) || 
             (this.group!=null &&
              this.group.equals(other.getGroup()))) &&
            ((this.partition==null && other.getPartition()==null) || 
             (this.partition!=null &&
              this.partition.equals(other.getPartition()))) &&
            ((this.assignToNoPartition==null && other.getAssignToNoPartition()==null) || 
             (this.assignToNoPartition!=null &&
              this.assignToNoPartition.equals(other.getAssignToNoPartition()))) &&
            ((this.repository==null && other.getRepository()==null) || 
             (this.repository!=null &&
              this.repository.equals(other.getRepository()))) &&
            ((this.userState==null && other.getUserState()==null) || 
             (this.userState!=null &&
              this.userState.equals(other.getUserState()))) &&
            ((this.suspendReason==null && other.getSuspendReason()==null) || 
             (this.suspendReason!=null &&
              this.suspendReason.equals(other.getSuspendReason()))) &&
            ((this.contactInfoList==null && other.getContactInfoList()==null) || 
             (this.contactInfoList!=null &&
              java.util.Arrays.equals(this.contactInfoList, other.getContactInfoList()))) &&
            ((this.aliases==null && other.getAliases()==null) || 
             (this.aliases!=null &&
              java.util.Arrays.equals(this.aliases, other.getAliases()))) &&
            ((this.addAliases==null && other.getAddAliases()==null) || 
             (this.addAliases!=null &&
              this.addAliases.equals(other.getAddAliases()))) &&
            ((this.removeAliases==null && other.getRemoveAliases()==null) || 
             (this.removeAliases!=null &&
              java.util.Arrays.equals(this.removeAliases, other.getRemoveAliases()))) &&
            ((this.fullName==null && other.getFullName()==null) || 
             (this.fullName!=null &&
              this.fullName.equals(other.getFullName()))) &&
            ((this.locale==null && other.getLocale()==null) || 
             (this.locale!=null &&
              this.locale.equals(other.getLocale()))) &&
            ((this.lockoutParms==null && other.getLockoutParms()==null) || 
             (this.lockoutParms!=null &&
              this.lockoutParms.equals(other.getLockoutParms()))) &&
            ((this.clearMachineSecrets==null && other.getClearMachineSecrets()==null) || 
             (this.clearMachineSecrets!=null &&
              this.clearMachineSecrets.equals(other.getClearMachineSecrets()))) &&
            ((this.removeMachineSecrets==null && other.getRemoveMachineSecrets()==null) || 
             (this.removeMachineSecrets!=null &&
              java.util.Arrays.equals(this.removeMachineSecrets, other.getRemoveMachineSecrets()))) &&
            ((this.sharedSecrets==null && other.getSharedSecrets()==null) || 
             (this.sharedSecrets!=null &&
              java.util.Arrays.equals(this.sharedSecrets, other.getSharedSecrets()))) &&
            ((this.mergeSecrets==null && other.getMergeSecrets()==null) || 
             (this.mergeSecrets!=null &&
              this.mergeSecrets.equals(other.getMergeSecrets()))) &&
            ((this.removeSharedSecrets==null && other.getRemoveSharedSecrets()==null) || 
             (this.removeSharedSecrets!=null &&
              java.util.Arrays.equals(this.removeSharedSecrets, other.getRemoveSharedSecrets()))) &&
            ((this.removeAllSecrets==null && other.getRemoveAllSecrets()==null) || 
             (this.removeAllSecrets!=null &&
              this.removeAllSecrets.equals(other.getRemoveAllSecrets()))) &&
            ((this.qaSecrets==null && other.getQaSecrets()==null) || 
             (this.qaSecrets!=null &&
              java.util.Arrays.equals(this.qaSecrets, other.getQaSecrets()))) &&
            ((this.mergeQaSecrets==null && other.getMergeQaSecrets()==null) || 
             (this.mergeQaSecrets!=null &&
              this.mergeQaSecrets.equals(other.getMergeQaSecrets()))) &&
            ((this.removeQaSecrets==null && other.getRemoveQaSecrets()==null) || 
             (this.removeQaSecrets!=null &&
              java.util.Arrays.equals(this.removeQaSecrets, other.getRemoveQaSecrets()))) &&
            ((this.removeAllQaSecrets==null && other.getRemoveAllQaSecrets()==null) || 
             (this.removeAllQaSecrets!=null &&
              this.removeAllQaSecrets.equals(other.getRemoveAllQaSecrets()))) &&
            ((this.authenticationSecrets==null && other.getAuthenticationSecrets()==null) || 
             (this.authenticationSecrets!=null &&
              java.util.Arrays.equals(this.authenticationSecrets, other.getAuthenticationSecrets()))) &&
            ((this.mergeAuthenticationSecrets==null && other.getMergeAuthenticationSecrets()==null) || 
             (this.mergeAuthenticationSecrets!=null &&
              this.mergeAuthenticationSecrets.equals(other.getMergeAuthenticationSecrets()))) &&
            ((this.removeAuthenticationSecrets==null && other.getRemoveAuthenticationSecrets()==null) || 
             (this.removeAuthenticationSecrets!=null &&
              java.util.Arrays.equals(this.removeAuthenticationSecrets, other.getRemoveAuthenticationSecrets()))) &&
            ((this.removeAllAuthenticationSecrets==null && other.getRemoveAllAuthenticationSecrets()==null) || 
             (this.removeAllAuthenticationSecrets!=null &&
              this.removeAllAuthenticationSecrets.equals(other.getRemoveAllAuthenticationSecrets()))) &&
            ((this.roles==null && other.getRoles()==null) || 
             (this.roles!=null &&
              java.util.Arrays.equals(this.roles, other.getRoles()))) &&
            ((this.mergeRoles==null && other.getMergeRoles()==null) || 
             (this.mergeRoles!=null &&
              this.mergeRoles.equals(other.getMergeRoles()))) &&
            ((this.removeRoles==null && other.getRemoveRoles()==null) || 
             (this.removeRoles!=null &&
              java.util.Arrays.equals(this.removeRoles, other.getRemoveRoles()))) &&
            ((this.OTPAllowed==null && other.getOTPAllowed()==null) || 
             (this.OTPAllowed!=null &&
              this.OTPAllowed.equals(other.getOTPAllowed()))) &&
            ((this.usePolicyForOTPDeliveryEnabled==null && other.getUsePolicyForOTPDeliveryEnabled()==null) || 
             (this.usePolicyForOTPDeliveryEnabled!=null &&
              this.usePolicyForOTPDeliveryEnabled.equals(other.getUsePolicyForOTPDeliveryEnabled()))) &&
            ((this.OTPDeliveryEnabled==null && other.getOTPDeliveryEnabled()==null) || 
             (this.OTPDeliveryEnabled!=null &&
              this.OTPDeliveryEnabled.equals(other.getOTPDeliveryEnabled()))) &&
            ((this.usePolicyForMaxLocationHistorySize==null && other.getUsePolicyForMaxLocationHistorySize()==null) || 
             (this.usePolicyForMaxLocationHistorySize!=null &&
              this.usePolicyForMaxLocationHistorySize.equals(other.getUsePolicyForMaxLocationHistorySize()))) &&
            ((this.maxLocationHistorySize==null && other.getMaxLocationHistorySize()==null) || 
             (this.maxLocationHistorySize!=null &&
              this.maxLocationHistorySize.equals(other.getMaxLocationHistorySize()))) &&
            ((this.removeAllLocationHistory==null && other.getRemoveAllLocationHistory()==null) || 
             (this.removeAllLocationHistory!=null &&
              this.removeAllLocationHistory.equals(other.getRemoveAllLocationHistory()))) &&
            ((this.removeLocationHistory==null && other.getRemoveLocationHistory()==null) || 
             (this.removeLocationHistory!=null &&
              java.util.Arrays.equals(this.removeLocationHistory, other.getRemoveLocationHistory()))) &&
            ((this.addLocationHistory==null && other.getAddLocationHistory()==null) || 
             (this.addLocationHistory!=null &&
              java.util.Arrays.equals(this.addLocationHistory, other.getAddLocationHistory()))) &&
            ((this.usePolicyForCheckVelocity==null && other.getUsePolicyForCheckVelocity()==null) || 
             (this.usePolicyForCheckVelocity!=null &&
              this.usePolicyForCheckVelocity.equals(other.getUsePolicyForCheckVelocity()))) &&
            ((this.checkVelocity==null && other.getCheckVelocity()==null) || 
             (this.checkVelocity!=null &&
              this.checkVelocity.equals(other.getCheckVelocity()))) &&
            ((this.usePolicyForCheckIPAddressInLocationHistory==null && other.getUsePolicyForCheckIPAddressInLocationHistory()==null) || 
             (this.usePolicyForCheckIPAddressInLocationHistory!=null &&
              this.usePolicyForCheckIPAddressInLocationHistory.equals(other.getUsePolicyForCheckIPAddressInLocationHistory()))) &&
            ((this.checkIPAddressInLocationHistory==null && other.getCheckIPAddressInLocationHistory()==null) || 
             (this.checkIPAddressInLocationHistory!=null &&
              this.checkIPAddressInLocationHistory.equals(other.getCheckIPAddressInLocationHistory()))) &&
            ((this.usePolicyForExpectedLocations==null && other.getUsePolicyForExpectedLocations()==null) || 
             (this.usePolicyForExpectedLocations!=null &&
              this.usePolicyForExpectedLocations.equals(other.getUsePolicyForExpectedLocations()))) &&
            ((this.expectedLocations==null && other.getExpectedLocations()==null) || 
             (this.expectedLocations!=null &&
              java.util.Arrays.equals(this.expectedLocations, other.getExpectedLocations()))) &&
            ((this.addExpectedLocations==null && other.getAddExpectedLocations()==null) || 
             (this.addExpectedLocations!=null &&
              this.addExpectedLocations.equals(other.getAddExpectedLocations()))) &&
            ((this.removeExpectedLocations==null && other.getRemoveExpectedLocations()==null) || 
             (this.removeExpectedLocations!=null &&
              this.removeExpectedLocations.equals(other.getRemoveExpectedLocations()))) &&
            ((this.activationExpiryCode==null && other.getActivationExpiryCode()==null) || 
             (this.activationExpiryCode!=null &&
              this.activationExpiryCode.equals(other.getActivationExpiryCode()))) &&
            ((this.activationDaysToExpiry==null && other.getActivationDaysToExpiry()==null) || 
             (this.activationDaysToExpiry!=null &&
              this.activationDaysToExpiry.equals(other.getActivationDaysToExpiry()))) &&
            ((this.comments==null && other.getComments()==null) || 
             (this.comments!=null &&
              this.comments.equals(other.getComments())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getGroup() != null) {
            _hashCode += getGroup().hashCode();
        }
        if (getPartition() != null) {
            _hashCode += getPartition().hashCode();
        }
        if (getAssignToNoPartition() != null) {
            _hashCode += getAssignToNoPartition().hashCode();
        }
        if (getRepository() != null) {
            _hashCode += getRepository().hashCode();
        }
        if (getUserState() != null) {
            _hashCode += getUserState().hashCode();
        }
        if (getSuspendReason() != null) {
            _hashCode += getSuspendReason().hashCode();
        }
        if (getContactInfoList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getContactInfoList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getContactInfoList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAliases() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAliases());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAliases(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAddAliases() != null) {
            _hashCode += getAddAliases().hashCode();
        }
        if (getRemoveAliases() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveAliases());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveAliases(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getFullName() != null) {
            _hashCode += getFullName().hashCode();
        }
        if (getLocale() != null) {
            _hashCode += getLocale().hashCode();
        }
        if (getLockoutParms() != null) {
            _hashCode += getLockoutParms().hashCode();
        }
        if (getClearMachineSecrets() != null) {
            _hashCode += getClearMachineSecrets().hashCode();
        }
        if (getRemoveMachineSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveMachineSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveMachineSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSharedSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSharedSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSharedSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeSecrets() != null) {
            _hashCode += getMergeSecrets().hashCode();
        }
        if (getRemoveSharedSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveSharedSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveSharedSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllSecrets() != null) {
            _hashCode += getRemoveAllSecrets().hashCode();
        }
        if (getQaSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getQaSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getQaSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeQaSecrets() != null) {
            _hashCode += getMergeQaSecrets().hashCode();
        }
        if (getRemoveQaSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveQaSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveQaSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllQaSecrets() != null) {
            _hashCode += getRemoveAllQaSecrets().hashCode();
        }
        if (getAuthenticationSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthenticationSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthenticationSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeAuthenticationSecrets() != null) {
            _hashCode += getMergeAuthenticationSecrets().hashCode();
        }
        if (getRemoveAuthenticationSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveAuthenticationSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveAuthenticationSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllAuthenticationSecrets() != null) {
            _hashCode += getRemoveAllAuthenticationSecrets().hashCode();
        }
        if (getRoles() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRoles());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRoles(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeRoles() != null) {
            _hashCode += getMergeRoles().hashCode();
        }
        if (getRemoveRoles() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveRoles());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveRoles(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getOTPAllowed() != null) {
            _hashCode += getOTPAllowed().hashCode();
        }
        if (getUsePolicyForOTPDeliveryEnabled() != null) {
            _hashCode += getUsePolicyForOTPDeliveryEnabled().hashCode();
        }
        if (getOTPDeliveryEnabled() != null) {
            _hashCode += getOTPDeliveryEnabled().hashCode();
        }
        if (getUsePolicyForMaxLocationHistorySize() != null) {
            _hashCode += getUsePolicyForMaxLocationHistorySize().hashCode();
        }
        if (getMaxLocationHistorySize() != null) {
            _hashCode += getMaxLocationHistorySize().hashCode();
        }
        if (getRemoveAllLocationHistory() != null) {
            _hashCode += getRemoveAllLocationHistory().hashCode();
        }
        if (getRemoveLocationHistory() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveLocationHistory());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveLocationHistory(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAddLocationHistory() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAddLocationHistory());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAddLocationHistory(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getUsePolicyForCheckVelocity() != null) {
            _hashCode += getUsePolicyForCheckVelocity().hashCode();
        }
        if (getCheckVelocity() != null) {
            _hashCode += getCheckVelocity().hashCode();
        }
        if (getUsePolicyForCheckIPAddressInLocationHistory() != null) {
            _hashCode += getUsePolicyForCheckIPAddressInLocationHistory().hashCode();
        }
        if (getCheckIPAddressInLocationHistory() != null) {
            _hashCode += getCheckIPAddressInLocationHistory().hashCode();
        }
        if (getUsePolicyForExpectedLocations() != null) {
            _hashCode += getUsePolicyForExpectedLocations().hashCode();
        }
        if (getExpectedLocations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getExpectedLocations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getExpectedLocations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAddExpectedLocations() != null) {
            _hashCode += getAddExpectedLocations().hashCode();
        }
        if (getRemoveExpectedLocations() != null) {
            _hashCode += getRemoveExpectedLocations().hashCode();
        }
        if (getActivationExpiryCode() != null) {
            _hashCode += getActivationExpiryCode().hashCode();
        }
        if (getActivationDaysToExpiry() != null) {
            _hashCode += getActivationDaysToExpiry().hashCode();
        }
        if (getComments() != null) {
            _hashCode += getComments().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("group");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Group"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("partition");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Partition"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("assignToNoPartition");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AssignToNoPartition"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("repository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Repository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userState");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserState"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("suspendReason");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SuspendReason"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("contactInfoList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ContactInfoList"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserContactInfoParms"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("aliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Aliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addAliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "addAliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeAliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("fullName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FullName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locale");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Locale"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutParms");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lockoutParms"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserLockoutParms"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("clearMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ClearMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sharedSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SharedSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "SharedSecret"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeSharedSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveSharedSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QaSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeQaSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeQaSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeQaSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveQaSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllQaSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllQaSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeAuthenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeAuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAuthenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllAuthenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllAuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("roles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Roles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeRoles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeRoles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeRoles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveRoles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForOTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForOTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForMaxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForMaxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeAllLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "addLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForCheckVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForCheckVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForCheckIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForCheckIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ExpectedLocation"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "addExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationExpiryCode");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationExpiryCode"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ActivationExpiryCode"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationDaysToExpiry");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationDaysToExpiry"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comments");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comments"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
