/**
 * UserPVNInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the information returned when querying a user's
 *                         personal verification number (PVN).
 */
public class UserPVNInfo  implements java.io.Serializable {
    /* The user ID that owns the PVN. */
    private String userid;

    /* The user name of the user ID that owns the PVN. */
    private String userName;

    /* The group of the user ID that owns the PVN. */
    private String group;

    /* The value of the personal verification number. */
    private String PVN;

    /* The date when the PVN was last changed. */
    private java.util.Calendar lastChangeDate;

    /* Indicates if the personal verification number
     *                                 must be changed by the user.  True
     * means the
     *                                 user is required to change their PVN.
     * False
     *                                 means it is optional for the user
     * to change
     *                                 their PVN. */
    private boolean changeRequired;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    public UserPVNInfo() {
    }

    public UserPVNInfo(
           String userid,
           String userName,
           String group,
           String PVN,
           java.util.Calendar lastChangeDate,
           boolean changeRequired,
           String[] rolesGrantingAccess) {
           this.userid = userid;
           this.userName = userName;
           this.group = group;
           this.PVN = PVN;
           this.lastChangeDate = lastChangeDate;
           this.changeRequired = changeRequired;
           this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the userid value for this UserPVNInfo.
     * 
     * @return userid   * The user ID that owns the PVN.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserPVNInfo.
     * 
     * @param userid   * The user ID that owns the PVN.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the userName value for this UserPVNInfo.
     * 
     * @return userName   * The user name of the user ID that owns the PVN.
     */
    public String getUserName() {
        return userName;
    }


    /**
     * Sets the userName value for this UserPVNInfo.
     * 
     * @param userName   * The user name of the user ID that owns the PVN.
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }


    /**
     * Gets the group value for this UserPVNInfo.
     * 
     * @return group   * The group of the user ID that owns the PVN.
     */
    public String getGroup() {
        return group;
    }


    /**
     * Sets the group value for this UserPVNInfo.
     * 
     * @param group   * The group of the user ID that owns the PVN.
     */
    public void setGroup(String group) {
        this.group = group;
    }


    /**
     * Gets the PVN value for this UserPVNInfo.
     * 
     * @return PVN   * The value of the personal verification number.
     */
    public String getPVN() {
        return PVN;
    }


    /**
     * Sets the PVN value for this UserPVNInfo.
     * 
     * @param PVN   * The value of the personal verification number.
     */
    public void setPVN(String PVN) {
        this.PVN = PVN;
    }


    /**
     * Gets the lastChangeDate value for this UserPVNInfo.
     * 
     * @return lastChangeDate   * The date when the PVN was last changed.
     */
    public java.util.Calendar getLastChangeDate() {
        return lastChangeDate;
    }


    /**
     * Sets the lastChangeDate value for this UserPVNInfo.
     * 
     * @param lastChangeDate   * The date when the PVN was last changed.
     */
    public void setLastChangeDate(java.util.Calendar lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }


    /**
     * Gets the changeRequired value for this UserPVNInfo.
     * 
     * @return changeRequired   * Indicates if the personal verification number
     *                                 must be changed by the user.  True
     * means the
     *                                 user is required to change their PVN.
     * False
     *                                 means it is optional for the user
     * to change
     *                                 their PVN.
     */
    public boolean isChangeRequired() {
        return changeRequired;
    }


    /**
     * Sets the changeRequired value for this UserPVNInfo.
     * 
     * @param changeRequired   * Indicates if the personal verification number
     *                                 must be changed by the user.  True
     * means the
     *                                 user is required to change their PVN.
     * False
     *                                 means it is optional for the user
     * to change
     *                                 their PVN.
     */
    public void setChangeRequired(boolean changeRequired) {
        this.changeRequired = changeRequired;
    }


    /**
     * Gets the rolesGrantingAccess value for this UserPVNInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this UserPVNInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserPVNInfo)) return false;
        UserPVNInfo other = (UserPVNInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.userName==null && other.getUserName()==null) || 
             (this.userName!=null &&
              this.userName.equals(other.getUserName()))) &&
            ((this.group==null && other.getGroup()==null) || 
             (this.group!=null &&
              this.group.equals(other.getGroup()))) &&
            ((this.PVN==null && other.getPVN()==null) || 
             (this.PVN!=null &&
              this.PVN.equals(other.getPVN()))) &&
            ((this.lastChangeDate==null && other.getLastChangeDate()==null) || 
             (this.lastChangeDate!=null &&
              this.lastChangeDate.equals(other.getLastChangeDate()))) &&
            this.changeRequired == other.isChangeRequired() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getUserName() != null) {
            _hashCode += getUserName().hashCode();
        }
        if (getGroup() != null) {
            _hashCode += getGroup().hashCode();
        }
        if (getPVN() != null) {
            _hashCode += getPVN().hashCode();
        }
        if (getLastChangeDate() != null) {
            _hashCode += getLastChangeDate().hashCode();
        }
        _hashCode += (isChangeRequired() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserPVNInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPVNInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("group");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Group"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastChangeDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LastChangeDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("changeRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ChangeRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
