/**
 * UserFilter.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the filter to limit which users, cards, tokens
 *                         or certificates
 *                         are to be returned from the userList, userCardList,
 * 
 *                         userTokenList or userCertificateList operations.
 * To
 *                         match the filter, a user,
 *                         card, token or certificate must match all
 * of the
 *                         criteria specified.
 *                         <p>
 *                         Note that it is possible
 *                         to construct filters that cannot match any
 * users, cards,
 *                         tokens or certificates, for example by setting
 * one of
 *                         the "start date" fields to be after the corresponding
 * "end date" field. Such invalid filters will return an
 *                         empty results list, and do not result in a
 * fault.
 */
public class UserFilter  implements java.io.Serializable {
    /* If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String userid;

    /* If specified, returns only users, cards, certificates or
     *                                 tokens who have an alias matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String alias;

    /* If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value,
     *                                 or who have an alias matching this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String aliasOrUserid;

    /* If specified, returns only users, cards, certificates or
     *                                 tokens who have a full name matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String fullName;

    /* If specified, returns only users, cards,
     *                                 certificates or tokens who have a
     * locale
     *                                 matching on of the specified values.
     * A value
     *                                 that is the empty string will match
     * users who
     *                                 don't have a locale set.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String[] locale;

    /* If specified, provides a list of group names and
     *                                 returns only users, cards, certificates
     * or tokens whose user
     *                                 is in one of the specified groups */
    private String[] groups;

    /* If specified, returns only cards with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a card with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching. */
    private String serialNumber;

    /* If specified, returns only cards or users who have a
     *                                 card whose creation date is after
     * the given date. */
    private java.util.Calendar createStartDate;

    /* If specified, returns only cards or users who have a
     *                                 card whose creation date is before
     * the given date. */
    private java.util.Calendar createEndDate;

    /* If specified, returns only cards or users who have a
     *                                 card whose expiry date is after the
     * given date. This
     *                                 will include cards that don't have
     * an expiry date. */
    private java.util.Calendar expireStartDate;

    /* If specified, returns only cards or users who have a
     *                                 card whose expiry date is before the
     * given date.  This
     *                                 will not include cards that don't
     * have an expiry date. */
    private java.util.Calendar expireEndDate;

    /* If specified, returns only cards or users who have a
     *                                 card whose state matches one of the
     * given values. */
    private State[] states;

    /* If set, only cards not in any of these states,
     *                             or users who have no cards with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no cards, or users whose
     *                             only cards are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING cards will be returned. */
    private State[] absentCardStates;

    /* If specified, returns users who have one of the indicated states. */
    private UserState[] userStates;

    /* If specified, returns only cards or users who have a
     *                                 card with a challenge count no less
     * than this value. */
    private Integer minChallengeCount;

    /* If specified, returns only cards or users who have a
     *                                 card with a challenge count no greater
     * than this value. */
    private Integer maxChallengeCount;

    /* If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no less than
     *                                 this value. */
    private Integer minLeastUsedCellUsageCount;

    /* If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no greater than
     *                                 this value. */
    private Integer maxLeastUsedCellUsageCount;

    /* If specified, returns only cards or users who have a
     *                                 card whose usage threshold indicator
     * matches one of
     *                                 the given values. */
    private com.good.adapters.entrust.stubs.CardUsageThresholdIndicator[] cardUsageThresholdIndicator;

    /* If specified as true, returns only users with
     *                                 a temporary PIN, or cards, certificates
     * or tokens whose user has a temporary PIN.
     *                                 If specified as false, returns only
     * users without a temporary PIN, or cards or tokens whose user does
     * not
     *                                 have a temporary PIN. */
    private Boolean hasPIN;

    /* If set, only users with a temporary PIN with at least
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at least this many uses remaining
     * will be returned. */
    private Integer minNumTempPINUses;

    /* If set, only users with a temporary PIN with at most
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at most this many uses remaining
     * will be returned.
     *                             Temporary PINs with an unlimited number
     * of uses will
     *                             not be matched if this value is specified. */
    private Integer maxNumTempPINUses;

    /* If set, only users with a temporary PIN that expires
     *                             on or after this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or after this date will
     * be returned. */
    private java.util.Calendar tempPINExpireStartDate;

    /* If set, only users with a temporary PIN that expires
     *                             on or before this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or before this date will
     * be returned.
     *                             Temporary PINs that are set to never expire
     * will
     *                             not be matched if this value is specified. */
    private java.util.Calendar tempPINExpireEndDate;

    /* If specified as true, returns only users with
     *                                 a personal verification number (PVN),
     * or cards
     *                                 or tokens whose user has a PVN.
     *                                 If specified as false, returns only
     * users without
     *                                 a PVN, or cards or tokens whose user
     * does not
     *                                 have a PVN. */
    private Boolean hasPVN;

    /* If specified as true, returns only users with
     *                                 a password, or cards or tokens whose
     * user has a password.
     *                                 If specified as false, returns only
     * users without
     *                                 a password, or cards or tokens whose
     * user does not
     *                                 have a password. */
    private Boolean hasPassword;

    /* If specified as true, returns only users that
     *                                 require a personal verification number
     * (PVN) change,
     *                                 or cards or tokens whose user requires
     * a PVN change.
     *                                 If specified as false, returns only
     * users that
     *                                 do not require a PVN change, or cards
     * or tokens
     *                                 whose user does not require a PVN
     * change. */
    private Boolean pvnChangeRequired;

    /* If specified, returns only users who have a PVN
     *                                 last change date on or after the given
     * date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or after the given
     * date. */
    private java.util.Calendar pvnLastChangeStartDate;

    /* If specified, returns only users who have a PVN
     *                                 last change date on or before the
     * given date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or before the
     * given date. */
    private java.util.Calendar pvnLastChangeEndDate;

    /* If specified as true, returns only users that
     *                                 require a password change, or cards
     * or tokens
     *                                 whose user requires a password change.
     * If specified as false, returns only users that
     *                                 do not require a password change,
     * or cards or tokens
     *                                 whose user does not require a password
     * change. */
    private Boolean passwordChangeRequired;

    /* If specified, returns only users who have a password
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or after the given date. */
    private java.util.Calendar passwordExpireStartDate;

    /* If specified, returns only users who have a password
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or before the given date.
     *                                 Passwords set to never expire will
     * not be matched
     *                                 if this value is set. */
    private java.util.Calendar passwordExpireEndDate;

    /* If specified, returns only users who have a password
     *                                 last change date on or after the given
     * date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or after the given date. */
    private java.util.Calendar passwordLastChangeStartDate;

    /* If specified, returns only users who have a password
     *                                 last change date on or before the
     * given date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or before the given date. */
    private java.util.Calendar passwordLastChangeEndDate;

    /* If specified, returns only users who have an activation
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or after the given date. */
    private java.util.Calendar activationExpireStartDate;

    /* If specified, returns only users who have an activation
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or before the given date. */
    private java.util.Calendar activationExpireEndDate;

    /* If specified, returns only users whose activation
     *                                 state matches the given state, or
     * cards or
     *                                 tokens whose user has an activation
     * state matching
     *                                 the given state. */
    private ActivationCodeFilter activationExpireCode;

    /* If specified as true, returns only users that
     *                                 are allowed to use one-time password
     * (OTP),
     *                                 or cards or tokens whose user is allowed
     * to use
     *                                 an OTP.
     *                                 If specified as true, returns only
     * users that
     *                                 are not allowed to use an OTP,
     *                                 or cards or tokens whose user is not
     * allowed to use
     *                                 an OTP. */
    private Boolean otpAllowed;

    /* If specified, returns users whose otpDeliveryEnabled attribute
     * is one of the indicated states, or cards or tokens
     *                                 whose user has an otpDeliveryEnabled
     * attribute
     *                                 matching one of the indicated states. */
    private AttributeState[] otpDeliveryEnabled;

    /* If set, only users with at least this many
     *                              OTPs, or cards or tokens or certificates
     * whose
     *                              user has at least this many OTPs, will
     * be
     *                              returned. */
    private Integer minNumOTPs;

    /* If set, only users with at most this many
     *                              OTPs, or cards or tokens or certificates
     * whose user has at most this many OTPs, will be
     *                              returned. */
    private Integer maxNumOTPs;

    /* If specified, returns only users whose OTPs
     *                                 have an expiry date on or after the
     * given date. */
    private java.util.Calendar OTPExpiryStartDate;

    /* If specified, returns only users whose OTPs
     *                                 expire on or before the given date. */
    private java.util.Calendar OTPExpiryEndDate;

    /* If specified as true, returns only users who
     *                                 have contact information, or cards
     * or tokens
     *                                 whose user has contact information.
     * If specified
     *                                 as false, returns only users who do
     * not have
     *                                 contact information, or cards or tokens
     * whose
     *                                 user does not have contact information. */
    private Boolean hasContactInfo;

    /* If set, returns only users with at least this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria. */
    private Integer minUsableContactInfo;

    /* If set, returns only users with at most this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria. */
    private Integer maxUsableContactInfo;

    /* If set, only users with at least this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at least this many locations
     * in
     *                              their location history, will be returned. */
    private Integer minNumLocations;

    /* If set, only users with at most this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at most this many locations
     * in their
     *                              location history, will be returned. */
    private Integer maxNumLocations;

    /* If specified as true, returns only users who
     *                                 are locked out, or cards or tokens
     * whose user is
     *                                 locked out.
     *                                 If specified as false, returns only
     * users who
     *                                 are not locked out, or cards or tokens
     * whose user is
     *                                 not locked out. */
    private Boolean locked;

    /* If specified, returns only tokens or users who
     *                                 have a token whose name or id matches
     * the given
     *                                 value. */
    private String tokenVendorId;

    /* If specified, returns only tokens with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a token with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching. */
    private String tokenSerialNumber;

    /* If specified, returns only tokens or users who have a
     *                                 token whose load date is after the
     * given date. */
    private java.util.Calendar tokenLoadStartDate;

    /* If specified, returns only tokens or users who have
     *                                 a token whose load date is before
     * the given date. */
    private java.util.Calendar tokenLoadEndDate;

    /* If specified, returns only tokens or users who have a
     *                                 token whose last used date is after
     * the given date. */
    private java.util.Calendar tokenLastUsedStartDate;

    /* If specified, returns only tokens or users who have a
     *                                 token whose last used date is before
     * the given date. */
    private java.util.Calendar tokenLastUsedEndDate;

    /* If specified, returns only tokens or users who have a
     *                                 token whose state matches one of the
     * given values. */
    private State[] tokenStates;

    /* If set, only tokens not in any of these states,
     *                             or users who have no tokens with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no tokens, or users whose
     *                             only tokens are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING tokens will be returned. */
    private State[] absentTokenStates;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issuer DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching. */
    private String certificateIssuerDN;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * subject DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching. */
    private String certificateSubjectDN;

    /* If specified, returns only certificates with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a certificate with a serial
     * number
     *                                 matching this value. The '*' character
     * can be
     *                                 included for wildcard matching. */
    private String certificateSerialNumber;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is after the given date. */
    private java.util.Calendar certificateIssueStartDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is before the given date. */
    private java.util.Calendar certificateIssueEndDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is after the given date. */
    private java.util.Calendar certificateExpiryStartDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is before the given date. */
    private java.util.Calendar certificateExpiryEndDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is after the given date. */
    private java.util.Calendar certificateLastUsedStartDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is before the given date. */
    private java.util.Calendar certificateLastUsedEndDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is after the given date. */
    private java.util.Calendar certificateAssignStartDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is before the given date. */
    private java.util.Calendar certificateAssignEndDate;

    /* If specified, returns only certificates or
     *                                 users who have a certificate whose
     * state
     *                                 matches one of the given values. */
    private CertificateState[] certificateStates;

    /* If specified, returns certificates that
     *                                 are or are not self signed. */
    private Boolean certificateSelfSigned;

    /* If specified, returns certificates that
     *                                 were or were not issued by a registered
     * CA. */
    private Boolean certificateCANotRegistered;

    /* If specified, returns certificates that
     *                                 were issued by one of the named registered
     * CAs. */
    private String[] certificateCAs;

    /* If set, only certificates not in any of these
     *                                states, or users who have no certificates
     * with
     *                                any of the states in this list will
     * be returned.
     *                                For example, if this list includes
     * ACTIVE in a
     *                                call to userList, only users with no
     * certificates, or users whose only certificates
     *                                are in the INACTIVE state will be returned.
     * No
     *                                users with ACTIVE certificates will
     * be returned. */
    private CertificateState[] absentCertificateStates;

    /* If specified, returns Smart Credentials that
     *                                 have an Id matching the given value.
     * The '*' character can be included for wildcard
     *                                 matching. */
    private String smartCredentialID;

    /* If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * Definitions. */
    private String[] smartCredentialDefinitions;

    /* If specified, returns Smart Credentials that
     *                                 have a serial number that matches
     * the
     *                                 given value.  An empty string value
     * will match
     *                                 Smart Credentials that do not have
     * a
     *                                 serial number.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching. */
    private String smartCredentialSerialNumber;

    /* If specified, returns Smart Credentials that
     *                                 have a card UID that matches the
     *                                 given value. */
    private String smartCredentialCardUID;

    /* If specified, returns Smart Credentials that
     *                                 have a card type that matches the
     *                                 given value. */
    private String smartCredentialCardType;

    /* If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * states. */
    private SmartCredentialState[] smartCredentialStates;

    /* If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential states. */
    private SmartCredentialState[] absentSmartCredentialStates;

    /* If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * print states. */
    private com.good.adapters.entrust.stubs.SmartCredentialIssueState[] smartCredentialIssueStates;

    /* If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential print states. */
    private com.good.adapters.entrust.stubs.SmartCredentialIssueState[] absentSmartCredentialIssueStates;

    /* If specified, returns Smart Credentials that
     *                                 are or are not sealed. */
    private Boolean smartCredentialSealed;

    /* If specified, returns Smart Credentials that
     *                                 are or are not approved. */
    private Boolean smartCredentialApproved;

    /* If specified, returns Smart Credentials that
     *                                 have or have not got enrollment values
     * that
     *                                 have been validated against the type
     * description
     *                                 of their Definition. */
    private Boolean smartCredentialValid;

    /* If specified, returns only
     *                                 Smart Credentials whose creation date
     * is after the given date. */
    private java.util.Calendar smartCredentialCreateStartDate;

    /* If specified, returns only
     *                                 Smart Credentials whose creation date
     * is before the given date. */
    private java.util.Calendar smartCredentialCreateEndDate;

    /* If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date. */
    private java.util.Calendar smartCredentialExpiryStartDate;

    /* If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date. */
    private java.util.Calendar smartCredentialExpiryEndDate;

    /* If specified, returns only
     *                                 Smart Credentials whose issue date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date. */
    private java.util.Calendar smartCredentialIssueStartDate;

    /* If specified, returns only
     *                                 Smart Credentials whose issue date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date. */
    private java.util.Calendar smartCredentialIssueEndDate;

    /* If specified, returns only
     *                                 Smart Credentials that support/don't
     * support
     *                                 unblock. */
    private Boolean smartCredentialSupportsUnblock;

    /* If specified, returns Smart Credentials that
     *                                 match the given Smart Credential variable
     * filters. */
    private com.good.adapters.entrust.stubs.SmartCredentialVariableFilter[] smartCredentialVariableFilters;

    /* If specified, returns the Digital Id that
     *                                 has the specified DN */
    private String digitalIdDN;

    /* If specified, returns Digital Ids that
     *                                 have one of the specified Managed
     * CAs. */
    private String[] digitalIdManagedCAs;

    /* If specified, returns Digital Ids that
     *                                 have one of the specified Digital
     * Id Configs. */
    private String[] digitalIdConfigs;

    /* If specified, returns only
     *                                 Digital Ids with the given client
     * type. */
    private String digitalIdClientType;

    /* If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is after the given date. */
    private java.util.Calendar digitalIdCreateRecoverStartDate;

    /* If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is before the given date. */
    private java.util.Calendar digitalIdCreateRecoverEndDate;

    /* If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is after the given date. */
    private java.util.Calendar digitalIdExpiryStartDate;

    /* If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is before the given date. */
    private java.util.Calendar digitalIdExpiryEndDate;

    /* If set, only users with at least this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at least this many Q/A
     * pairs, will be returned.
     *                             To find all users with Q/A pairs defined,
     * set this value to 1. */
    private Integer minNumQa;

    /* If set, only users with at most this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at most this many Q/A pairs,
     * will be returned.
     *                             To find all users with no Q/A pairs, set
     * this value to 0. */
    private Integer maxNumQa;

    /* If set, only users with at least this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at least this many machine
     * secrets,
     *                             will be returned. To find all users who
     * have machine secrets,
     *                             or cards or tokens whose user has machine
     * secrets,
     *                             set this value to 1. */
    private Integer minNumMachineSecrets;

    /* If set, only users with at most this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at most this many machine
     * secrets,
     *                             will be returned. To
     *                             find all users who do not have any machine
     * secrets,
     *                             or cards or tokens whose user does not
     * have any machine secrets,
     *                             set this value to 1. */
    private Integer maxNumMachineSecrets;

    /* If specified as true, returns any user who has
     *                             mutual authentication secrets, or any
     * card or token whose
     *                             user has mutual authentication secrets.
     * If specified as false, only
     *                             users who do not have mutual authentication
     * secrets, or
     *                             cards or tokens whose user does not have
     * any mutual
     *                             authentication secrets, will be returned. */
    private Boolean hasAuthenticationSecrets;

    /* If specified as true, returns any user who has a
     *                             role, or cards or tokens whose user has
     * a role.
     *                             If specified as false, only users who
     * do not
     *                             have a role, or cards or tokens whose
     * user does not
     *                             have a role, will be returned. */
    private Boolean hasRole;

    /* If specified, only users who have at least one of
     *                             the roles in this list, or cards or tokens
     * whose
     *                             user has at least one of the roles in
     * this list,
     *                             will be returned. */
    private String[] roles;

    /* If specified, returns only
     *                                 users whose last successful authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a successful authentication
     *                                 will be returned. */
    private java.util.Calendar lastAuthStartDate;

    /* If specified, returns only
     *                                 users whose last successful authentication
     * is before the given date. */
    private java.util.Calendar lastAuthEndDate;

    /* If specified as true, returns only
     *                                 users who have never had a successful
     * authentication.  If specified as false,
     *                                 returns only users who have had a
     *                                 successful authentication. */
    private Boolean lastAuthNever;

    /* If specified, returns only
     *                                 users whose last successful authentication
     * was one of the given types. */
    private AuthenticationType[] lastAuthTypes;

    /* If specified, returns only
     *                                 users whose last failed authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a failed authentication
     *                                 will be returned. */
    private java.util.Calendar lastFailedAuthStartDate;

    /* If specified, returns only
     *                                 users whose last failed authentication
     * is before the given date. */
    private java.util.Calendar lastFailedAuthEndDate;

    /* If specified as true, returns only
     *                                 users who have never had a failed
     *                                 authentication.  If specified as false,
     * returns only users who have had a
     *                                 failed authentication. */
    private Boolean lastFailedAuthNever;

    /* If specified, returns only
     *                                 users whose last failed authentication
     * was one of the given types. */
    private AuthenticationType[] lastFailedAuthTypes;

    /* If specified, returns only users who
     *                                 are/are not disabled in the repository.
     * This search criteria is not supported in
     *                                 Entrust IdentityGuard 9.1 and will
     * be ignored
     *                                 if specified. */
    private Boolean disabledInRepository;

    /* Return user federations whose type
     *                                matches one of the given value. */
    private String[] federationTypes;

    /* The partner ID of the federation. For example
     *                                 the SAML partner entity ID. */
    private String federationPartnerID;

    /* A flag indicating if this server is the
     *                                 originator of the federation. */
    private Boolean federationOriginator;

    /* An invalid user is a user that doesn't pass
     *                                data integrity.  In the case of LDAP,
     * this
     *                                is a likely indication that the user
     * has been
     *                                renamed in the repository without being
     * renamed within Entrust IdentityGuard.  If this
     *                                flag is set to true, only users that
     * pass
     *                                data integrity will be returned.  If
     * this flag
     *                                is set to false, only users that don't
     * pass
     *                                data integrity will be returned. */
    private Boolean invalidUsers;

    /* The number of users, cards or tokens to return.
     *                                 If not specified or the value is 0
     * or less, it defaults
     *                                 to 100. */
    private Integer maxReturn;

    /* The nextUser number. If specified, indicates that searching
     * should start at the given user. This value is used to
     *                                 get the next set of users, cards,
     * or tokens following a previous search.
     *                                 The value to set here is the nextUser
     * value from
     *                                 the previous search results. */
    private java.math.BigInteger nextUser;

    public UserFilter() {
    }

    public UserFilter(
           String userid,
           String alias,
           String aliasOrUserid,
           String fullName,
           String[] locale,
           String[] groups,
           String serialNumber,
           java.util.Calendar createStartDate,
           java.util.Calendar createEndDate,
           java.util.Calendar expireStartDate,
           java.util.Calendar expireEndDate,
           State[] states,
           State[] absentCardStates,
           UserState[] userStates,
           Integer minChallengeCount,
           Integer maxChallengeCount,
           Integer minLeastUsedCellUsageCount,
           Integer maxLeastUsedCellUsageCount,
           com.good.adapters.entrust.stubs.CardUsageThresholdIndicator[] cardUsageThresholdIndicator,
           Boolean hasPIN,
           Integer minNumTempPINUses,
           Integer maxNumTempPINUses,
           java.util.Calendar tempPINExpireStartDate,
           java.util.Calendar tempPINExpireEndDate,
           Boolean hasPVN,
           Boolean hasPassword,
           Boolean pvnChangeRequired,
           java.util.Calendar pvnLastChangeStartDate,
           java.util.Calendar pvnLastChangeEndDate,
           Boolean passwordChangeRequired,
           java.util.Calendar passwordExpireStartDate,
           java.util.Calendar passwordExpireEndDate,
           java.util.Calendar passwordLastChangeStartDate,
           java.util.Calendar passwordLastChangeEndDate,
           java.util.Calendar activationExpireStartDate,
           java.util.Calendar activationExpireEndDate,
           ActivationCodeFilter activationExpireCode,
           Boolean otpAllowed,
           AttributeState[] otpDeliveryEnabled,
           Integer minNumOTPs,
           Integer maxNumOTPs,
           java.util.Calendar OTPExpiryStartDate,
           java.util.Calendar OTPExpiryEndDate,
           Boolean hasContactInfo,
           Integer minUsableContactInfo,
           Integer maxUsableContactInfo,
           Integer minNumLocations,
           Integer maxNumLocations,
           Boolean locked,
           String tokenVendorId,
           String tokenSerialNumber,
           java.util.Calendar tokenLoadStartDate,
           java.util.Calendar tokenLoadEndDate,
           java.util.Calendar tokenLastUsedStartDate,
           java.util.Calendar tokenLastUsedEndDate,
           State[] tokenStates,
           State[] absentTokenStates,
           String certificateIssuerDN,
           String certificateSubjectDN,
           String certificateSerialNumber,
           java.util.Calendar certificateIssueStartDate,
           java.util.Calendar certificateIssueEndDate,
           java.util.Calendar certificateExpiryStartDate,
           java.util.Calendar certificateExpiryEndDate,
           java.util.Calendar certificateLastUsedStartDate,
           java.util.Calendar certificateLastUsedEndDate,
           java.util.Calendar certificateAssignStartDate,
           java.util.Calendar certificateAssignEndDate,
           CertificateState[] certificateStates,
           Boolean certificateSelfSigned,
           Boolean certificateCANotRegistered,
           String[] certificateCAs,
           CertificateState[] absentCertificateStates,
           String smartCredentialID,
           String[] smartCredentialDefinitions,
           String smartCredentialSerialNumber,
           String smartCredentialCardUID,
           String smartCredentialCardType,
           SmartCredentialState[] smartCredentialStates,
           SmartCredentialState[] absentSmartCredentialStates,
           com.good.adapters.entrust.stubs.SmartCredentialIssueState[] smartCredentialIssueStates,
           com.good.adapters.entrust.stubs.SmartCredentialIssueState[] absentSmartCredentialIssueStates,
           Boolean smartCredentialSealed,
           Boolean smartCredentialApproved,
           Boolean smartCredentialValid,
           java.util.Calendar smartCredentialCreateStartDate,
           java.util.Calendar smartCredentialCreateEndDate,
           java.util.Calendar smartCredentialExpiryStartDate,
           java.util.Calendar smartCredentialExpiryEndDate,
           java.util.Calendar smartCredentialIssueStartDate,
           java.util.Calendar smartCredentialIssueEndDate,
           Boolean smartCredentialSupportsUnblock,
           com.good.adapters.entrust.stubs.SmartCredentialVariableFilter[] smartCredentialVariableFilters,
           String digitalIdDN,
           String[] digitalIdManagedCAs,
           String[] digitalIdConfigs,
           String digitalIdClientType,
           java.util.Calendar digitalIdCreateRecoverStartDate,
           java.util.Calendar digitalIdCreateRecoverEndDate,
           java.util.Calendar digitalIdExpiryStartDate,
           java.util.Calendar digitalIdExpiryEndDate,
           Integer minNumQa,
           Integer maxNumQa,
           Integer minNumMachineSecrets,
           Integer maxNumMachineSecrets,
           Boolean hasAuthenticationSecrets,
           Boolean hasRole,
           String[] roles,
           java.util.Calendar lastAuthStartDate,
           java.util.Calendar lastAuthEndDate,
           Boolean lastAuthNever,
           AuthenticationType[] lastAuthTypes,
           java.util.Calendar lastFailedAuthStartDate,
           java.util.Calendar lastFailedAuthEndDate,
           Boolean lastFailedAuthNever,
           AuthenticationType[] lastFailedAuthTypes,
           Boolean disabledInRepository,
           String[] federationTypes,
           String federationPartnerID,
           Boolean federationOriginator,
           Boolean invalidUsers,
           Integer maxReturn,
           java.math.BigInteger nextUser) {
           this.userid = userid;
           this.alias = alias;
           this.aliasOrUserid = aliasOrUserid;
           this.fullName = fullName;
           this.locale = locale;
           this.groups = groups;
           this.serialNumber = serialNumber;
           this.createStartDate = createStartDate;
           this.createEndDate = createEndDate;
           this.expireStartDate = expireStartDate;
           this.expireEndDate = expireEndDate;
           this.states = states;
           this.absentCardStates = absentCardStates;
           this.userStates = userStates;
           this.minChallengeCount = minChallengeCount;
           this.maxChallengeCount = maxChallengeCount;
           this.minLeastUsedCellUsageCount = minLeastUsedCellUsageCount;
           this.maxLeastUsedCellUsageCount = maxLeastUsedCellUsageCount;
           this.cardUsageThresholdIndicator = cardUsageThresholdIndicator;
           this.hasPIN = hasPIN;
           this.minNumTempPINUses = minNumTempPINUses;
           this.maxNumTempPINUses = maxNumTempPINUses;
           this.tempPINExpireStartDate = tempPINExpireStartDate;
           this.tempPINExpireEndDate = tempPINExpireEndDate;
           this.hasPVN = hasPVN;
           this.hasPassword = hasPassword;
           this.pvnChangeRequired = pvnChangeRequired;
           this.pvnLastChangeStartDate = pvnLastChangeStartDate;
           this.pvnLastChangeEndDate = pvnLastChangeEndDate;
           this.passwordChangeRequired = passwordChangeRequired;
           this.passwordExpireStartDate = passwordExpireStartDate;
           this.passwordExpireEndDate = passwordExpireEndDate;
           this.passwordLastChangeStartDate = passwordLastChangeStartDate;
           this.passwordLastChangeEndDate = passwordLastChangeEndDate;
           this.activationExpireStartDate = activationExpireStartDate;
           this.activationExpireEndDate = activationExpireEndDate;
           this.activationExpireCode = activationExpireCode;
           this.otpAllowed = otpAllowed;
           this.otpDeliveryEnabled = otpDeliveryEnabled;
           this.minNumOTPs = minNumOTPs;
           this.maxNumOTPs = maxNumOTPs;
           this.OTPExpiryStartDate = OTPExpiryStartDate;
           this.OTPExpiryEndDate = OTPExpiryEndDate;
           this.hasContactInfo = hasContactInfo;
           this.minUsableContactInfo = minUsableContactInfo;
           this.maxUsableContactInfo = maxUsableContactInfo;
           this.minNumLocations = minNumLocations;
           this.maxNumLocations = maxNumLocations;
           this.locked = locked;
           this.tokenVendorId = tokenVendorId;
           this.tokenSerialNumber = tokenSerialNumber;
           this.tokenLoadStartDate = tokenLoadStartDate;
           this.tokenLoadEndDate = tokenLoadEndDate;
           this.tokenLastUsedStartDate = tokenLastUsedStartDate;
           this.tokenLastUsedEndDate = tokenLastUsedEndDate;
           this.tokenStates = tokenStates;
           this.absentTokenStates = absentTokenStates;
           this.certificateIssuerDN = certificateIssuerDN;
           this.certificateSubjectDN = certificateSubjectDN;
           this.certificateSerialNumber = certificateSerialNumber;
           this.certificateIssueStartDate = certificateIssueStartDate;
           this.certificateIssueEndDate = certificateIssueEndDate;
           this.certificateExpiryStartDate = certificateExpiryStartDate;
           this.certificateExpiryEndDate = certificateExpiryEndDate;
           this.certificateLastUsedStartDate = certificateLastUsedStartDate;
           this.certificateLastUsedEndDate = certificateLastUsedEndDate;
           this.certificateAssignStartDate = certificateAssignStartDate;
           this.certificateAssignEndDate = certificateAssignEndDate;
           this.certificateStates = certificateStates;
           this.certificateSelfSigned = certificateSelfSigned;
           this.certificateCANotRegistered = certificateCANotRegistered;
           this.certificateCAs = certificateCAs;
           this.absentCertificateStates = absentCertificateStates;
           this.smartCredentialID = smartCredentialID;
           this.smartCredentialDefinitions = smartCredentialDefinitions;
           this.smartCredentialSerialNumber = smartCredentialSerialNumber;
           this.smartCredentialCardUID = smartCredentialCardUID;
           this.smartCredentialCardType = smartCredentialCardType;
           this.smartCredentialStates = smartCredentialStates;
           this.absentSmartCredentialStates = absentSmartCredentialStates;
           this.smartCredentialIssueStates = smartCredentialIssueStates;
           this.absentSmartCredentialIssueStates = absentSmartCredentialIssueStates;
           this.smartCredentialSealed = smartCredentialSealed;
           this.smartCredentialApproved = smartCredentialApproved;
           this.smartCredentialValid = smartCredentialValid;
           this.smartCredentialCreateStartDate = smartCredentialCreateStartDate;
           this.smartCredentialCreateEndDate = smartCredentialCreateEndDate;
           this.smartCredentialExpiryStartDate = smartCredentialExpiryStartDate;
           this.smartCredentialExpiryEndDate = smartCredentialExpiryEndDate;
           this.smartCredentialIssueStartDate = smartCredentialIssueStartDate;
           this.smartCredentialIssueEndDate = smartCredentialIssueEndDate;
           this.smartCredentialSupportsUnblock = smartCredentialSupportsUnblock;
           this.smartCredentialVariableFilters = smartCredentialVariableFilters;
           this.digitalIdDN = digitalIdDN;
           this.digitalIdManagedCAs = digitalIdManagedCAs;
           this.digitalIdConfigs = digitalIdConfigs;
           this.digitalIdClientType = digitalIdClientType;
           this.digitalIdCreateRecoverStartDate = digitalIdCreateRecoverStartDate;
           this.digitalIdCreateRecoverEndDate = digitalIdCreateRecoverEndDate;
           this.digitalIdExpiryStartDate = digitalIdExpiryStartDate;
           this.digitalIdExpiryEndDate = digitalIdExpiryEndDate;
           this.minNumQa = minNumQa;
           this.maxNumQa = maxNumQa;
           this.minNumMachineSecrets = minNumMachineSecrets;
           this.maxNumMachineSecrets = maxNumMachineSecrets;
           this.hasAuthenticationSecrets = hasAuthenticationSecrets;
           this.hasRole = hasRole;
           this.roles = roles;
           this.lastAuthStartDate = lastAuthStartDate;
           this.lastAuthEndDate = lastAuthEndDate;
           this.lastAuthNever = lastAuthNever;
           this.lastAuthTypes = lastAuthTypes;
           this.lastFailedAuthStartDate = lastFailedAuthStartDate;
           this.lastFailedAuthEndDate = lastFailedAuthEndDate;
           this.lastFailedAuthNever = lastFailedAuthNever;
           this.lastFailedAuthTypes = lastFailedAuthTypes;
           this.disabledInRepository = disabledInRepository;
           this.federationTypes = federationTypes;
           this.federationPartnerID = federationPartnerID;
           this.federationOriginator = federationOriginator;
           this.invalidUsers = invalidUsers;
           this.maxReturn = maxReturn;
           this.nextUser = nextUser;
    }


    /**
     * Gets the userid value for this UserFilter.
     * 
     * @return userid   * If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserFilter.
     * 
     * @param userid   * If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the alias value for this UserFilter.
     * 
     * @return alias   * If specified, returns only users, cards, certificates or
     *                                 tokens who have an alias matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String getAlias() {
        return alias;
    }


    /**
     * Sets the alias value for this UserFilter.
     * 
     * @param alias   * If specified, returns only users, cards, certificates or
     *                                 tokens who have an alias matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }


    /**
     * Gets the aliasOrUserid value for this UserFilter.
     * 
     * @return aliasOrUserid   * If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value,
     *                                 or who have an alias matching this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String getAliasOrUserid() {
        return aliasOrUserid;
    }


    /**
     * Sets the aliasOrUserid value for this UserFilter.
     * 
     * @param aliasOrUserid   * If specified, returns only users, cards, certificates or
     *                                 tokens whose user name matches this
     * value,
     *                                 or who have an alias matching this
     * value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setAliasOrUserid(String aliasOrUserid) {
        this.aliasOrUserid = aliasOrUserid;
    }


    /**
     * Gets the fullName value for this UserFilter.
     * 
     * @return fullName   * If specified, returns only users, cards, certificates or
     *                                 tokens who have a full name matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String getFullName() {
        return fullName;
    }


    /**
     * Sets the fullName value for this UserFilter.
     * 
     * @param fullName   * If specified, returns only users, cards, certificates or
     *                                 tokens who have a full name matching
     * this value.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }


    /**
     * Gets the locale value for this UserFilter.
     * 
     * @return locale   * If specified, returns only users, cards,
     *                                 certificates or tokens who have a
     * locale
     *                                 matching on of the specified values.
     * A value
     *                                 that is the empty string will match
     * users who
     *                                 don't have a locale set.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String[] getLocale() {
        return locale;
    }


    /**
     * Sets the locale value for this UserFilter.
     * 
     * @param locale   * If specified, returns only users, cards,
     *                                 certificates or tokens who have a
     * locale
     *                                 matching on of the specified values.
     * A value
     *                                 that is the empty string will match
     * users who
     *                                 don't have a locale set.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setLocale(String[] locale) {
        this.locale = locale;
    }


    /**
     * Gets the groups value for this UserFilter.
     * 
     * @return groups   * If specified, provides a list of group names and
     *                                 returns only users, cards, certificates
     * or tokens whose user
     *                                 is in one of the specified groups
     */
    public String[] getGroups() {
        return groups;
    }


    /**
     * Sets the groups value for this UserFilter.
     * 
     * @param groups   * If specified, provides a list of group names and
     *                                 returns only users, cards, certificates
     * or tokens whose user
     *                                 is in one of the specified groups
     */
    public void setGroups(String[] groups) {
        this.groups = groups;
    }


    /**
     * Gets the serialNumber value for this UserFilter.
     * 
     * @return serialNumber   * If specified, returns only cards with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a card with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this UserFilter.
     * 
     * @param serialNumber   * If specified, returns only cards with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a card with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the createStartDate value for this UserFilter.
     * 
     * @return createStartDate   * If specified, returns only cards or users who have a
     *                                 card whose creation date is after
     * the given date.
     */
    public java.util.Calendar getCreateStartDate() {
        return createStartDate;
    }


    /**
     * Sets the createStartDate value for this UserFilter.
     * 
     * @param createStartDate   * If specified, returns only cards or users who have a
     *                                 card whose creation date is after
     * the given date.
     */
    public void setCreateStartDate(java.util.Calendar createStartDate) {
        this.createStartDate = createStartDate;
    }


    /**
     * Gets the createEndDate value for this UserFilter.
     * 
     * @return createEndDate   * If specified, returns only cards or users who have a
     *                                 card whose creation date is before
     * the given date.
     */
    public java.util.Calendar getCreateEndDate() {
        return createEndDate;
    }


    /**
     * Sets the createEndDate value for this UserFilter.
     * 
     * @param createEndDate   * If specified, returns only cards or users who have a
     *                                 card whose creation date is before
     * the given date.
     */
    public void setCreateEndDate(java.util.Calendar createEndDate) {
        this.createEndDate = createEndDate;
    }


    /**
     * Gets the expireStartDate value for this UserFilter.
     * 
     * @return expireStartDate   * If specified, returns only cards or users who have a
     *                                 card whose expiry date is after the
     * given date. This
     *                                 will include cards that don't have
     * an expiry date.
     */
    public java.util.Calendar getExpireStartDate() {
        return expireStartDate;
    }


    /**
     * Sets the expireStartDate value for this UserFilter.
     * 
     * @param expireStartDate   * If specified, returns only cards or users who have a
     *                                 card whose expiry date is after the
     * given date. This
     *                                 will include cards that don't have
     * an expiry date.
     */
    public void setExpireStartDate(java.util.Calendar expireStartDate) {
        this.expireStartDate = expireStartDate;
    }


    /**
     * Gets the expireEndDate value for this UserFilter.
     * 
     * @return expireEndDate   * If specified, returns only cards or users who have a
     *                                 card whose expiry date is before the
     * given date.  This
     *                                 will not include cards that don't
     * have an expiry date.
     */
    public java.util.Calendar getExpireEndDate() {
        return expireEndDate;
    }


    /**
     * Sets the expireEndDate value for this UserFilter.
     * 
     * @param expireEndDate   * If specified, returns only cards or users who have a
     *                                 card whose expiry date is before the
     * given date.  This
     *                                 will not include cards that don't
     * have an expiry date.
     */
    public void setExpireEndDate(java.util.Calendar expireEndDate) {
        this.expireEndDate = expireEndDate;
    }


    /**
     * Gets the states value for this UserFilter.
     * 
     * @return states   * If specified, returns only cards or users who have a
     *                                 card whose state matches one of the
     * given values.
     */
    public State[] getStates() {
        return states;
    }


    /**
     * Sets the states value for this UserFilter.
     * 
     * @param states   * If specified, returns only cards or users who have a
     *                                 card whose state matches one of the
     * given values.
     */
    public void setStates(State[] states) {
        this.states = states;
    }


    /**
     * Gets the absentCardStates value for this UserFilter.
     * 
     * @return absentCardStates   * If set, only cards not in any of these states,
     *                             or users who have no cards with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no cards, or users whose
     *                             only cards are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING cards will be returned.
     */
    public State[] getAbsentCardStates() {
        return absentCardStates;
    }


    /**
     * Sets the absentCardStates value for this UserFilter.
     * 
     * @param absentCardStates   * If set, only cards not in any of these states,
     *                             or users who have no cards with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no cards, or users whose
     *                             only cards are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING cards will be returned.
     */
    public void setAbsentCardStates(State[] absentCardStates) {
        this.absentCardStates = absentCardStates;
    }


    /**
     * Gets the userStates value for this UserFilter.
     * 
     * @return userStates   * If specified, returns users who have one of the indicated states.
     */
    public UserState[] getUserStates() {
        return userStates;
    }


    /**
     * Sets the userStates value for this UserFilter.
     * 
     * @param userStates   * If specified, returns users who have one of the indicated states.
     */
    public void setUserStates(UserState[] userStates) {
        this.userStates = userStates;
    }


    /**
     * Gets the minChallengeCount value for this UserFilter.
     * 
     * @return minChallengeCount   * If specified, returns only cards or users who have a
     *                                 card with a challenge count no less
     * than this value.
     */
    public Integer getMinChallengeCount() {
        return minChallengeCount;
    }


    /**
     * Sets the minChallengeCount value for this UserFilter.
     * 
     * @param minChallengeCount   * If specified, returns only cards or users who have a
     *                                 card with a challenge count no less
     * than this value.
     */
    public void setMinChallengeCount(Integer minChallengeCount) {
        this.minChallengeCount = minChallengeCount;
    }


    /**
     * Gets the maxChallengeCount value for this UserFilter.
     * 
     * @return maxChallengeCount   * If specified, returns only cards or users who have a
     *                                 card with a challenge count no greater
     * than this value.
     */
    public Integer getMaxChallengeCount() {
        return maxChallengeCount;
    }


    /**
     * Sets the maxChallengeCount value for this UserFilter.
     * 
     * @param maxChallengeCount   * If specified, returns only cards or users who have a
     *                                 card with a challenge count no greater
     * than this value.
     */
    public void setMaxChallengeCount(Integer maxChallengeCount) {
        this.maxChallengeCount = maxChallengeCount;
    }


    /**
     * Gets the minLeastUsedCellUsageCount value for this UserFilter.
     * 
     * @return minLeastUsedCellUsageCount   * If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no less than
     *                                 this value.
     */
    public Integer getMinLeastUsedCellUsageCount() {
        return minLeastUsedCellUsageCount;
    }


    /**
     * Sets the minLeastUsedCellUsageCount value for this UserFilter.
     * 
     * @param minLeastUsedCellUsageCount   * If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no less than
     *                                 this value.
     */
    public void setMinLeastUsedCellUsageCount(Integer minLeastUsedCellUsageCount) {
        this.minLeastUsedCellUsageCount = minLeastUsedCellUsageCount;
    }


    /**
     * Gets the maxLeastUsedCellUsageCount value for this UserFilter.
     * 
     * @return maxLeastUsedCellUsageCount   * If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no greater than
     *                                 this value.
     */
    public Integer getMaxLeastUsedCellUsageCount() {
        return maxLeastUsedCellUsageCount;
    }


    /**
     * Sets the maxLeastUsedCellUsageCount value for this UserFilter.
     * 
     * @param maxLeastUsedCellUsageCount   * If specified, returns only cards or users who have a
     *                                 card with a least used cell usage
     * count no greater than
     *                                 this value.
     */
    public void setMaxLeastUsedCellUsageCount(Integer maxLeastUsedCellUsageCount) {
        this.maxLeastUsedCellUsageCount = maxLeastUsedCellUsageCount;
    }


    /**
     * Gets the cardUsageThresholdIndicator value for this UserFilter.
     * 
     * @return cardUsageThresholdIndicator   * If specified, returns only cards or users who have a
     *                                 card whose usage threshold indicator
     * matches one of
     *                                 the given values.
     */
    public com.good.adapters.entrust.stubs.CardUsageThresholdIndicator[] getCardUsageThresholdIndicator() {
        return cardUsageThresholdIndicator;
    }


    /**
     * Sets the cardUsageThresholdIndicator value for this UserFilter.
     * 
     * @param cardUsageThresholdIndicator   * If specified, returns only cards or users who have a
     *                                 card whose usage threshold indicator
     * matches one of
     *                                 the given values.
     */
    public void setCardUsageThresholdIndicator(com.good.adapters.entrust.stubs.CardUsageThresholdIndicator[] cardUsageThresholdIndicator) {
        this.cardUsageThresholdIndicator = cardUsageThresholdIndicator;
    }


    /**
     * Gets the hasPIN value for this UserFilter.
     * 
     * @return hasPIN   * If specified as true, returns only users with
     *                                 a temporary PIN, or cards, certificates
     * or tokens whose user has a temporary PIN.
     *                                 If specified as false, returns only
     * users without a temporary PIN, or cards or tokens whose user does
     * not
     *                                 have a temporary PIN.
     */
    public Boolean getHasPIN() {
        return hasPIN;
    }


    /**
     * Sets the hasPIN value for this UserFilter.
     * 
     * @param hasPIN   * If specified as true, returns only users with
     *                                 a temporary PIN, or cards, certificates
     * or tokens whose user has a temporary PIN.
     *                                 If specified as false, returns only
     * users without a temporary PIN, or cards or tokens whose user does
     * not
     *                                 have a temporary PIN.
     */
    public void setHasPIN(Boolean hasPIN) {
        this.hasPIN = hasPIN;
    }


    /**
     * Gets the minNumTempPINUses value for this UserFilter.
     * 
     * @return minNumTempPINUses   * If set, only users with a temporary PIN with at least
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at least this many uses remaining
     * will be returned.
     */
    public Integer getMinNumTempPINUses() {
        return minNumTempPINUses;
    }


    /**
     * Sets the minNumTempPINUses value for this UserFilter.
     * 
     * @param minNumTempPINUses   * If set, only users with a temporary PIN with at least
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at least this many uses remaining
     * will be returned.
     */
    public void setMinNumTempPINUses(Integer minNumTempPINUses) {
        this.minNumTempPINUses = minNumTempPINUses;
    }


    /**
     * Gets the maxNumTempPINUses value for this UserFilter.
     * 
     * @return maxNumTempPINUses   * If set, only users with a temporary PIN with at most
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at most this many uses remaining
     * will be returned.
     *                             Temporary PINs with an unlimited number
     * of uses will
     *                             not be matched if this value is specified.
     */
    public Integer getMaxNumTempPINUses() {
        return maxNumTempPINUses;
    }


    /**
     * Sets the maxNumTempPINUses value for this UserFilter.
     * 
     * @param maxNumTempPINUses   * If set, only users with a temporary PIN with at most
     *                             this many uses remaining, or cards or
     * tokens whose user has a temporary PIN
     *                             with at most this many uses remaining
     * will be returned.
     *                             Temporary PINs with an unlimited number
     * of uses will
     *                             not be matched if this value is specified.
     */
    public void setMaxNumTempPINUses(Integer maxNumTempPINUses) {
        this.maxNumTempPINUses = maxNumTempPINUses;
    }


    /**
     * Gets the tempPINExpireStartDate value for this UserFilter.
     * 
     * @return tempPINExpireStartDate   * If set, only users with a temporary PIN that expires
     *                             on or after this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or after this date will
     * be returned.
     */
    public java.util.Calendar getTempPINExpireStartDate() {
        return tempPINExpireStartDate;
    }


    /**
     * Sets the tempPINExpireStartDate value for this UserFilter.
     * 
     * @param tempPINExpireStartDate   * If set, only users with a temporary PIN that expires
     *                             on or after this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or after this date will
     * be returned.
     */
    public void setTempPINExpireStartDate(java.util.Calendar tempPINExpireStartDate) {
        this.tempPINExpireStartDate = tempPINExpireStartDate;
    }


    /**
     * Gets the tempPINExpireEndDate value for this UserFilter.
     * 
     * @return tempPINExpireEndDate   * If set, only users with a temporary PIN that expires
     *                             on or before this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or before this date will
     * be returned.
     *                             Temporary PINs that are set to never expire
     * will
     *                             not be matched if this value is specified.
     */
    public java.util.Calendar getTempPINExpireEndDate() {
        return tempPINExpireEndDate;
    }


    /**
     * Sets the tempPINExpireEndDate value for this UserFilter.
     * 
     * @param tempPINExpireEndDate   * If set, only users with a temporary PIN that expires
     *                             on or before this date, or cards or tokens
     * whose user has a temporary PIN
     *                             that expires on or before this date will
     * be returned.
     *                             Temporary PINs that are set to never expire
     * will
     *                             not be matched if this value is specified.
     */
    public void setTempPINExpireEndDate(java.util.Calendar tempPINExpireEndDate) {
        this.tempPINExpireEndDate = tempPINExpireEndDate;
    }


    /**
     * Gets the hasPVN value for this UserFilter.
     * 
     * @return hasPVN   * If specified as true, returns only users with
     *                                 a personal verification number (PVN),
     * or cards
     *                                 or tokens whose user has a PVN.
     *                                 If specified as false, returns only
     * users without
     *                                 a PVN, or cards or tokens whose user
     * does not
     *                                 have a PVN.
     */
    public Boolean getHasPVN() {
        return hasPVN;
    }


    /**
     * Sets the hasPVN value for this UserFilter.
     * 
     * @param hasPVN   * If specified as true, returns only users with
     *                                 a personal verification number (PVN),
     * or cards
     *                                 or tokens whose user has a PVN.
     *                                 If specified as false, returns only
     * users without
     *                                 a PVN, or cards or tokens whose user
     * does not
     *                                 have a PVN.
     */
    public void setHasPVN(Boolean hasPVN) {
        this.hasPVN = hasPVN;
    }


    /**
     * Gets the hasPassword value for this UserFilter.
     * 
     * @return hasPassword   * If specified as true, returns only users with
     *                                 a password, or cards or tokens whose
     * user has a password.
     *                                 If specified as false, returns only
     * users without
     *                                 a password, or cards or tokens whose
     * user does not
     *                                 have a password.
     */
    public Boolean getHasPassword() {
        return hasPassword;
    }


    /**
     * Sets the hasPassword value for this UserFilter.
     * 
     * @param hasPassword   * If specified as true, returns only users with
     *                                 a password, or cards or tokens whose
     * user has a password.
     *                                 If specified as false, returns only
     * users without
     *                                 a password, or cards or tokens whose
     * user does not
     *                                 have a password.
     */
    public void setHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
    }


    /**
     * Gets the pvnChangeRequired value for this UserFilter.
     * 
     * @return pvnChangeRequired   * If specified as true, returns only users that
     *                                 require a personal verification number
     * (PVN) change,
     *                                 or cards or tokens whose user requires
     * a PVN change.
     *                                 If specified as false, returns only
     * users that
     *                                 do not require a PVN change, or cards
     * or tokens
     *                                 whose user does not require a PVN
     * change.
     */
    public Boolean getPvnChangeRequired() {
        return pvnChangeRequired;
    }


    /**
     * Sets the pvnChangeRequired value for this UserFilter.
     * 
     * @param pvnChangeRequired   * If specified as true, returns only users that
     *                                 require a personal verification number
     * (PVN) change,
     *                                 or cards or tokens whose user requires
     * a PVN change.
     *                                 If specified as false, returns only
     * users that
     *                                 do not require a PVN change, or cards
     * or tokens
     *                                 whose user does not require a PVN
     * change.
     */
    public void setPvnChangeRequired(Boolean pvnChangeRequired) {
        this.pvnChangeRequired = pvnChangeRequired;
    }


    /**
     * Gets the pvnLastChangeStartDate value for this UserFilter.
     * 
     * @return pvnLastChangeStartDate   * If specified, returns only users who have a PVN
     *                                 last change date on or after the given
     * date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or after the given
     * date.
     */
    public java.util.Calendar getPvnLastChangeStartDate() {
        return pvnLastChangeStartDate;
    }


    /**
     * Sets the pvnLastChangeStartDate value for this UserFilter.
     * 
     * @param pvnLastChangeStartDate   * If specified, returns only users who have a PVN
     *                                 last change date on or after the given
     * date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or after the given
     * date.
     */
    public void setPvnLastChangeStartDate(java.util.Calendar pvnLastChangeStartDate) {
        this.pvnLastChangeStartDate = pvnLastChangeStartDate;
    }


    /**
     * Gets the pvnLastChangeEndDate value for this UserFilter.
     * 
     * @return pvnLastChangeEndDate   * If specified, returns only users who have a PVN
     *                                 last change date on or before the
     * given date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or before the
     * given date.
     */
    public java.util.Calendar getPvnLastChangeEndDate() {
        return pvnLastChangeEndDate;
    }


    /**
     * Sets the pvnLastChangeEndDate value for this UserFilter.
     * 
     * @param pvnLastChangeEndDate   * If specified, returns only users who have a PVN
     *                                 last change date on or before the
     * given date,
     *                                 or cards or tokens whose user has
     * a PVN
     *                                 last change date on or before the
     * given date.
     */
    public void setPvnLastChangeEndDate(java.util.Calendar pvnLastChangeEndDate) {
        this.pvnLastChangeEndDate = pvnLastChangeEndDate;
    }


    /**
     * Gets the passwordChangeRequired value for this UserFilter.
     * 
     * @return passwordChangeRequired   * If specified as true, returns only users that
     *                                 require a password change, or cards
     * or tokens
     *                                 whose user requires a password change.
     * If specified as false, returns only users that
     *                                 do not require a password change,
     * or cards or tokens
     *                                 whose user does not require a password
     * change.
     */
    public Boolean getPasswordChangeRequired() {
        return passwordChangeRequired;
    }


    /**
     * Sets the passwordChangeRequired value for this UserFilter.
     * 
     * @param passwordChangeRequired   * If specified as true, returns only users that
     *                                 require a password change, or cards
     * or tokens
     *                                 whose user requires a password change.
     * If specified as false, returns only users that
     *                                 do not require a password change,
     * or cards or tokens
     *                                 whose user does not require a password
     * change.
     */
    public void setPasswordChangeRequired(Boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }


    /**
     * Gets the passwordExpireStartDate value for this UserFilter.
     * 
     * @return passwordExpireStartDate   * If specified, returns only users who have a password
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or after the given date.
     */
    public java.util.Calendar getPasswordExpireStartDate() {
        return passwordExpireStartDate;
    }


    /**
     * Sets the passwordExpireStartDate value for this UserFilter.
     * 
     * @param passwordExpireStartDate   * If specified, returns only users who have a password
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or after the given date.
     */
    public void setPasswordExpireStartDate(java.util.Calendar passwordExpireStartDate) {
        this.passwordExpireStartDate = passwordExpireStartDate;
    }


    /**
     * Gets the passwordExpireEndDate value for this UserFilter.
     * 
     * @return passwordExpireEndDate   * If specified, returns only users who have a password
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or before the given date.
     *                                 Passwords set to never expire will
     * not be matched
     *                                 if this value is set.
     */
    public java.util.Calendar getPasswordExpireEndDate() {
        return passwordExpireEndDate;
    }


    /**
     * Sets the passwordExpireEndDate value for this UserFilter.
     * 
     * @param passwordExpireEndDate   * If specified, returns only users who have a password
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has a password expiring
     * on or before the given date.
     *                                 Passwords set to never expire will
     * not be matched
     *                                 if this value is set.
     */
    public void setPasswordExpireEndDate(java.util.Calendar passwordExpireEndDate) {
        this.passwordExpireEndDate = passwordExpireEndDate;
    }


    /**
     * Gets the passwordLastChangeStartDate value for this UserFilter.
     * 
     * @return passwordLastChangeStartDate   * If specified, returns only users who have a password
     *                                 last change date on or after the given
     * date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or after the given date.
     */
    public java.util.Calendar getPasswordLastChangeStartDate() {
        return passwordLastChangeStartDate;
    }


    /**
     * Sets the passwordLastChangeStartDate value for this UserFilter.
     * 
     * @param passwordLastChangeStartDate   * If specified, returns only users who have a password
     *                                 last change date on or after the given
     * date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or after the given date.
     */
    public void setPasswordLastChangeStartDate(java.util.Calendar passwordLastChangeStartDate) {
        this.passwordLastChangeStartDate = passwordLastChangeStartDate;
    }


    /**
     * Gets the passwordLastChangeEndDate value for this UserFilter.
     * 
     * @return passwordLastChangeEndDate   * If specified, returns only users who have a password
     *                                 last change date on or before the
     * given date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or before the given date.
     */
    public java.util.Calendar getPasswordLastChangeEndDate() {
        return passwordLastChangeEndDate;
    }


    /**
     * Sets the passwordLastChangeEndDate value for this UserFilter.
     * 
     * @param passwordLastChangeEndDate   * If specified, returns only users who have a password
     *                                 last change date on or before the
     * given date, or cards or
     *                                 tokens whose user last changed their
     * password
     *                                 on or before the given date.
     */
    public void setPasswordLastChangeEndDate(java.util.Calendar passwordLastChangeEndDate) {
        this.passwordLastChangeEndDate = passwordLastChangeEndDate;
    }


    /**
     * Gets the activationExpireStartDate value for this UserFilter.
     * 
     * @return activationExpireStartDate   * If specified, returns only users who have an activation
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or after the given date.
     */
    public java.util.Calendar getActivationExpireStartDate() {
        return activationExpireStartDate;
    }


    /**
     * Sets the activationExpireStartDate value for this UserFilter.
     * 
     * @param activationExpireStartDate   * If specified, returns only users who have an activation
     *                                 expiry date on or after the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or after the given date.
     */
    public void setActivationExpireStartDate(java.util.Calendar activationExpireStartDate) {
        this.activationExpireStartDate = activationExpireStartDate;
    }


    /**
     * Gets the activationExpireEndDate value for this UserFilter.
     * 
     * @return activationExpireEndDate   * If specified, returns only users who have an activation
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or before the given date.
     */
    public java.util.Calendar getActivationExpireEndDate() {
        return activationExpireEndDate;
    }


    /**
     * Sets the activationExpireEndDate value for this UserFilter.
     * 
     * @param activationExpireEndDate   * If specified, returns only users who have an activation
     *                                 expiry date on or before the given
     * date, or cards or
     *                                 tokens whose user has an activation
     * expiry date
     *                                 on or before the given date.
     */
    public void setActivationExpireEndDate(java.util.Calendar activationExpireEndDate) {
        this.activationExpireEndDate = activationExpireEndDate;
    }


    /**
     * Gets the activationExpireCode value for this UserFilter.
     * 
     * @return activationExpireCode   * If specified, returns only users whose activation
     *                                 state matches the given state, or
     * cards or
     *                                 tokens whose user has an activation
     * state matching
     *                                 the given state.
     */
    public ActivationCodeFilter getActivationExpireCode() {
        return activationExpireCode;
    }


    /**
     * Sets the activationExpireCode value for this UserFilter.
     * 
     * @param activationExpireCode   * If specified, returns only users whose activation
     *                                 state matches the given state, or
     * cards or
     *                                 tokens whose user has an activation
     * state matching
     *                                 the given state.
     */
    public void setActivationExpireCode(ActivationCodeFilter activationExpireCode) {
        this.activationExpireCode = activationExpireCode;
    }


    /**
     * Gets the otpAllowed value for this UserFilter.
     * 
     * @return otpAllowed   * If specified as true, returns only users that
     *                                 are allowed to use one-time password
     * (OTP),
     *                                 or cards or tokens whose user is allowed
     * to use
     *                                 an OTP.
     *                                 If specified as true, returns only
     * users that
     *                                 are not allowed to use an OTP,
     *                                 or cards or tokens whose user is not
     * allowed to use
     *                                 an OTP.
     */
    public Boolean getOtpAllowed() {
        return otpAllowed;
    }


    /**
     * Sets the otpAllowed value for this UserFilter.
     * 
     * @param otpAllowed   * If specified as true, returns only users that
     *                                 are allowed to use one-time password
     * (OTP),
     *                                 or cards or tokens whose user is allowed
     * to use
     *                                 an OTP.
     *                                 If specified as true, returns only
     * users that
     *                                 are not allowed to use an OTP,
     *                                 or cards or tokens whose user is not
     * allowed to use
     *                                 an OTP.
     */
    public void setOtpAllowed(Boolean otpAllowed) {
        this.otpAllowed = otpAllowed;
    }


    /**
     * Gets the otpDeliveryEnabled value for this UserFilter.
     * 
     * @return otpDeliveryEnabled   * If specified, returns users whose otpDeliveryEnabled attribute
     * is one of the indicated states, or cards or tokens
     *                                 whose user has an otpDeliveryEnabled
     * attribute
     *                                 matching one of the indicated states.
     */
    public AttributeState[] getOtpDeliveryEnabled() {
        return otpDeliveryEnabled;
    }


    /**
     * Sets the otpDeliveryEnabled value for this UserFilter.
     * 
     * @param otpDeliveryEnabled   * If specified, returns users whose otpDeliveryEnabled attribute
     * is one of the indicated states, or cards or tokens
     *                                 whose user has an otpDeliveryEnabled
     * attribute
     *                                 matching one of the indicated states.
     */
    public void setOtpDeliveryEnabled(AttributeState[] otpDeliveryEnabled) {
        this.otpDeliveryEnabled = otpDeliveryEnabled;
    }


    /**
     * Gets the minNumOTPs value for this UserFilter.
     * 
     * @return minNumOTPs   * If set, only users with at least this many
     *                              OTPs, or cards or tokens or certificates
     * whose
     *                              user has at least this many OTPs, will
     * be
     *                              returned.
     */
    public Integer getMinNumOTPs() {
        return minNumOTPs;
    }


    /**
     * Sets the minNumOTPs value for this UserFilter.
     * 
     * @param minNumOTPs   * If set, only users with at least this many
     *                              OTPs, or cards or tokens or certificates
     * whose
     *                              user has at least this many OTPs, will
     * be
     *                              returned.
     */
    public void setMinNumOTPs(Integer minNumOTPs) {
        this.minNumOTPs = minNumOTPs;
    }


    /**
     * Gets the maxNumOTPs value for this UserFilter.
     * 
     * @return maxNumOTPs   * If set, only users with at most this many
     *                              OTPs, or cards or tokens or certificates
     * whose user has at most this many OTPs, will be
     *                              returned.
     */
    public Integer getMaxNumOTPs() {
        return maxNumOTPs;
    }


    /**
     * Sets the maxNumOTPs value for this UserFilter.
     * 
     * @param maxNumOTPs   * If set, only users with at most this many
     *                              OTPs, or cards or tokens or certificates
     * whose user has at most this many OTPs, will be
     *                              returned.
     */
    public void setMaxNumOTPs(Integer maxNumOTPs) {
        this.maxNumOTPs = maxNumOTPs;
    }


    /**
     * Gets the OTPExpiryStartDate value for this UserFilter.
     * 
     * @return OTPExpiryStartDate   * If specified, returns only users whose OTPs
     *                                 have an expiry date on or after the
     * given date.
     */
    public java.util.Calendar getOTPExpiryStartDate() {
        return OTPExpiryStartDate;
    }


    /**
     * Sets the OTPExpiryStartDate value for this UserFilter.
     * 
     * @param OTPExpiryStartDate   * If specified, returns only users whose OTPs
     *                                 have an expiry date on or after the
     * given date.
     */
    public void setOTPExpiryStartDate(java.util.Calendar OTPExpiryStartDate) {
        this.OTPExpiryStartDate = OTPExpiryStartDate;
    }


    /**
     * Gets the OTPExpiryEndDate value for this UserFilter.
     * 
     * @return OTPExpiryEndDate   * If specified, returns only users whose OTPs
     *                                 expire on or before the given date.
     */
    public java.util.Calendar getOTPExpiryEndDate() {
        return OTPExpiryEndDate;
    }


    /**
     * Sets the OTPExpiryEndDate value for this UserFilter.
     * 
     * @param OTPExpiryEndDate   * If specified, returns only users whose OTPs
     *                                 expire on or before the given date.
     */
    public void setOTPExpiryEndDate(java.util.Calendar OTPExpiryEndDate) {
        this.OTPExpiryEndDate = OTPExpiryEndDate;
    }


    /**
     * Gets the hasContactInfo value for this UserFilter.
     * 
     * @return hasContactInfo   * If specified as true, returns only users who
     *                                 have contact information, or cards
     * or tokens
     *                                 whose user has contact information.
     * If specified
     *                                 as false, returns only users who do
     * not have
     *                                 contact information, or cards or tokens
     * whose
     *                                 user does not have contact information.
     */
    public Boolean getHasContactInfo() {
        return hasContactInfo;
    }


    /**
     * Sets the hasContactInfo value for this UserFilter.
     * 
     * @param hasContactInfo   * If specified as true, returns only users who
     *                                 have contact information, or cards
     * or tokens
     *                                 whose user has contact information.
     * If specified
     *                                 as false, returns only users who do
     * not have
     *                                 contact information, or cards or tokens
     * whose
     *                                 user does not have contact information.
     */
    public void setHasContactInfo(Boolean hasContactInfo) {
        this.hasContactInfo = hasContactInfo;
    }


    /**
     * Gets the minUsableContactInfo value for this UserFilter.
     * 
     * @return minUsableContactInfo   * If set, returns only users with at least this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria.
     */
    public Integer getMinUsableContactInfo() {
        return minUsableContactInfo;
    }


    /**
     * Sets the minUsableContactInfo value for this UserFilter.
     * 
     * @param minUsableContactInfo   * If set, returns only users with at least this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria.
     */
    public void setMinUsableContactInfo(Integer minUsableContactInfo) {
        this.minUsableContactInfo = minUsableContactInfo;
    }


    /**
     * Gets the maxUsableContactInfo value for this UserFilter.
     * 
     * @return maxUsableContactInfo   * If set, returns only users with at most this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria.
     */
    public Integer getMaxUsableContactInfo() {
        return maxUsableContactInfo;
    }


    /**
     * Sets the maxUsableContactInfo value for this UserFilter.
     * 
     * @param maxUsableContactInfo   * If set, returns only users with at most this many
     *                                 contact information that refer to
     * a delivery
     *                                 mechanism other than the special "NONE"
     * mechanism, or cards or tokens whose user matches
     *                                 this criteria.
     */
    public void setMaxUsableContactInfo(Integer maxUsableContactInfo) {
        this.maxUsableContactInfo = maxUsableContactInfo;
    }


    /**
     * Gets the minNumLocations value for this UserFilter.
     * 
     * @return minNumLocations   * If set, only users with at least this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at least this many locations
     * in
     *                              their location history, will be returned.
     */
    public Integer getMinNumLocations() {
        return minNumLocations;
    }


    /**
     * Sets the minNumLocations value for this UserFilter.
     * 
     * @param minNumLocations   * If set, only users with at least this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at least this many locations
     * in
     *                              their location history, will be returned.
     */
    public void setMinNumLocations(Integer minNumLocations) {
        this.minNumLocations = minNumLocations;
    }


    /**
     * Gets the maxNumLocations value for this UserFilter.
     * 
     * @return maxNumLocations   * If set, only users with at most this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at most this many locations
     * in their
     *                              location history, will be returned.
     */
    public Integer getMaxNumLocations() {
        return maxNumLocations;
    }


    /**
     * Sets the maxNumLocations value for this UserFilter.
     * 
     * @param maxNumLocations   * If set, only users with at most this many
     *                              locations in their location history,
     * or cards or tokens
     *                              whose user has at most this many locations
     * in their
     *                              location history, will be returned.
     */
    public void setMaxNumLocations(Integer maxNumLocations) {
        this.maxNumLocations = maxNumLocations;
    }


    /**
     * Gets the locked value for this UserFilter.
     * 
     * @return locked   * If specified as true, returns only users who
     *                                 are locked out, or cards or tokens
     * whose user is
     *                                 locked out.
     *                                 If specified as false, returns only
     * users who
     *                                 are not locked out, or cards or tokens
     * whose user is
     *                                 not locked out.
     */
    public Boolean getLocked() {
        return locked;
    }


    /**
     * Sets the locked value for this UserFilter.
     * 
     * @param locked   * If specified as true, returns only users who
     *                                 are locked out, or cards or tokens
     * whose user is
     *                                 locked out.
     *                                 If specified as false, returns only
     * users who
     *                                 are not locked out, or cards or tokens
     * whose user is
     *                                 not locked out.
     */
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }


    /**
     * Gets the tokenVendorId value for this UserFilter.
     * 
     * @return tokenVendorId   * If specified, returns only tokens or users who
     *                                 have a token whose name or id matches
     * the given
     *                                 value.
     */
    public String getTokenVendorId() {
        return tokenVendorId;
    }


    /**
     * Sets the tokenVendorId value for this UserFilter.
     * 
     * @param tokenVendorId   * If specified, returns only tokens or users who
     *                                 have a token whose name or id matches
     * the given
     *                                 value.
     */
    public void setTokenVendorId(String tokenVendorId) {
        this.tokenVendorId = tokenVendorId;
    }


    /**
     * Gets the tokenSerialNumber value for this UserFilter.
     * 
     * @return tokenSerialNumber   * If specified, returns only tokens with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a token with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching.
     */
    public String getTokenSerialNumber() {
        return tokenSerialNumber;
    }


    /**
     * Sets the tokenSerialNumber value for this UserFilter.
     * 
     * @param tokenSerialNumber   * If specified, returns only tokens with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a token with a serial number
     * matching
     *                                 this value. The '*' character can
     * be included for wildcard
     *                                 matching.
     */
    public void setTokenSerialNumber(String tokenSerialNumber) {
        this.tokenSerialNumber = tokenSerialNumber;
    }


    /**
     * Gets the tokenLoadStartDate value for this UserFilter.
     * 
     * @return tokenLoadStartDate   * If specified, returns only tokens or users who have a
     *                                 token whose load date is after the
     * given date.
     */
    public java.util.Calendar getTokenLoadStartDate() {
        return tokenLoadStartDate;
    }


    /**
     * Sets the tokenLoadStartDate value for this UserFilter.
     * 
     * @param tokenLoadStartDate   * If specified, returns only tokens or users who have a
     *                                 token whose load date is after the
     * given date.
     */
    public void setTokenLoadStartDate(java.util.Calendar tokenLoadStartDate) {
        this.tokenLoadStartDate = tokenLoadStartDate;
    }


    /**
     * Gets the tokenLoadEndDate value for this UserFilter.
     * 
     * @return tokenLoadEndDate   * If specified, returns only tokens or users who have
     *                                 a token whose load date is before
     * the given date.
     */
    public java.util.Calendar getTokenLoadEndDate() {
        return tokenLoadEndDate;
    }


    /**
     * Sets the tokenLoadEndDate value for this UserFilter.
     * 
     * @param tokenLoadEndDate   * If specified, returns only tokens or users who have
     *                                 a token whose load date is before
     * the given date.
     */
    public void setTokenLoadEndDate(java.util.Calendar tokenLoadEndDate) {
        this.tokenLoadEndDate = tokenLoadEndDate;
    }


    /**
     * Gets the tokenLastUsedStartDate value for this UserFilter.
     * 
     * @return tokenLastUsedStartDate   * If specified, returns only tokens or users who have a
     *                                 token whose last used date is after
     * the given date.
     */
    public java.util.Calendar getTokenLastUsedStartDate() {
        return tokenLastUsedStartDate;
    }


    /**
     * Sets the tokenLastUsedStartDate value for this UserFilter.
     * 
     * @param tokenLastUsedStartDate   * If specified, returns only tokens or users who have a
     *                                 token whose last used date is after
     * the given date.
     */
    public void setTokenLastUsedStartDate(java.util.Calendar tokenLastUsedStartDate) {
        this.tokenLastUsedStartDate = tokenLastUsedStartDate;
    }


    /**
     * Gets the tokenLastUsedEndDate value for this UserFilter.
     * 
     * @return tokenLastUsedEndDate   * If specified, returns only tokens or users who have a
     *                                 token whose last used date is before
     * the given date.
     */
    public java.util.Calendar getTokenLastUsedEndDate() {
        return tokenLastUsedEndDate;
    }


    /**
     * Sets the tokenLastUsedEndDate value for this UserFilter.
     * 
     * @param tokenLastUsedEndDate   * If specified, returns only tokens or users who have a
     *                                 token whose last used date is before
     * the given date.
     */
    public void setTokenLastUsedEndDate(java.util.Calendar tokenLastUsedEndDate) {
        this.tokenLastUsedEndDate = tokenLastUsedEndDate;
    }


    /**
     * Gets the tokenStates value for this UserFilter.
     * 
     * @return tokenStates   * If specified, returns only tokens or users who have a
     *                                 token whose state matches one of the
     * given values.
     */
    public State[] getTokenStates() {
        return tokenStates;
    }


    /**
     * Sets the tokenStates value for this UserFilter.
     * 
     * @param tokenStates   * If specified, returns only tokens or users who have a
     *                                 token whose state matches one of the
     * given values.
     */
    public void setTokenStates(State[] tokenStates) {
        this.tokenStates = tokenStates;
    }


    /**
     * Gets the absentTokenStates value for this UserFilter.
     * 
     * @return absentTokenStates   * If set, only tokens not in any of these states,
     *                             or users who have no tokens with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no tokens, or users whose
     *                             only tokens are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING tokens will be returned.
     */
    public State[] getAbsentTokenStates() {
        return absentTokenStates;
    }


    /**
     * Sets the absentTokenStates value for this UserFilter.
     * 
     * @param absentTokenStates   * If set, only tokens not in any of these states,
     *                             or users who have no tokens with any of
     * the states in this list will be returned. For
     *                             example, if this list includes both CURRENT
     * and
     *                             PENDING in a call to userList, only users
     * with no tokens, or users whose
     *                             only tokens are in the HOLD_PENDING, HOLD
     * or
     *                             CANCELED states will be returned.  No
     * users with
     *                             CURRENT or PENDING tokens will be returned.
     */
    public void setAbsentTokenStates(State[] absentTokenStates) {
        this.absentTokenStates = absentTokenStates;
    }


    /**
     * Gets the certificateIssuerDN value for this UserFilter.
     * 
     * @return certificateIssuerDN   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issuer DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching.
     */
    public String getCertificateIssuerDN() {
        return certificateIssuerDN;
    }


    /**
     * Sets the certificateIssuerDN value for this UserFilter.
     * 
     * @param certificateIssuerDN   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issuer DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching.
     */
    public void setCertificateIssuerDN(String certificateIssuerDN) {
        this.certificateIssuerDN = certificateIssuerDN;
    }


    /**
     * Gets the certificateSubjectDN value for this UserFilter.
     * 
     * @return certificateSubjectDN   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * subject DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching.
     */
    public String getCertificateSubjectDN() {
        return certificateSubjectDN;
    }


    /**
     * Sets the certificateSubjectDN value for this UserFilter.
     * 
     * @param certificateSubjectDN   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * subject DN
     *                                 matches the given value.  The '*'
     * character
     *                                 can be included for wildcard matching.
     */
    public void setCertificateSubjectDN(String certificateSubjectDN) {
        this.certificateSubjectDN = certificateSubjectDN;
    }


    /**
     * Gets the certificateSerialNumber value for this UserFilter.
     * 
     * @return certificateSerialNumber   * If specified, returns only certificates with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a certificate with a serial
     * number
     *                                 matching this value. The '*' character
     * can be
     *                                 included for wildcard matching.
     */
    public String getCertificateSerialNumber() {
        return certificateSerialNumber;
    }


    /**
     * Sets the certificateSerialNumber value for this UserFilter.
     * 
     * @param certificateSerialNumber   * If specified, returns only certificates with
     *                                 a serial number matching this value,
     * or users
     *                                 who have a certificate with a serial
     * number
     *                                 matching this value. The '*' character
     * can be
     *                                 included for wildcard matching.
     */
    public void setCertificateSerialNumber(String certificateSerialNumber) {
        this.certificateSerialNumber = certificateSerialNumber;
    }


    /**
     * Gets the certificateIssueStartDate value for this UserFilter.
     * 
     * @return certificateIssueStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is after the given date.
     */
    public java.util.Calendar getCertificateIssueStartDate() {
        return certificateIssueStartDate;
    }


    /**
     * Sets the certificateIssueStartDate value for this UserFilter.
     * 
     * @param certificateIssueStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is after the given date.
     */
    public void setCertificateIssueStartDate(java.util.Calendar certificateIssueStartDate) {
        this.certificateIssueStartDate = certificateIssueStartDate;
    }


    /**
     * Gets the certificateIssueEndDate value for this UserFilter.
     * 
     * @return certificateIssueEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is before the given date.
     */
    public java.util.Calendar getCertificateIssueEndDate() {
        return certificateIssueEndDate;
    }


    /**
     * Sets the certificateIssueEndDate value for this UserFilter.
     * 
     * @param certificateIssueEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * issue date
     *                                 is before the given date.
     */
    public void setCertificateIssueEndDate(java.util.Calendar certificateIssueEndDate) {
        this.certificateIssueEndDate = certificateIssueEndDate;
    }


    /**
     * Gets the certificateExpiryStartDate value for this UserFilter.
     * 
     * @return certificateExpiryStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is after the given date.
     */
    public java.util.Calendar getCertificateExpiryStartDate() {
        return certificateExpiryStartDate;
    }


    /**
     * Sets the certificateExpiryStartDate value for this UserFilter.
     * 
     * @param certificateExpiryStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is after the given date.
     */
    public void setCertificateExpiryStartDate(java.util.Calendar certificateExpiryStartDate) {
        this.certificateExpiryStartDate = certificateExpiryStartDate;
    }


    /**
     * Gets the certificateExpiryEndDate value for this UserFilter.
     * 
     * @return certificateExpiryEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is before the given date.
     */
    public java.util.Calendar getCertificateExpiryEndDate() {
        return certificateExpiryEndDate;
    }


    /**
     * Sets the certificateExpiryEndDate value for this UserFilter.
     * 
     * @param certificateExpiryEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * expiry date
     *                                 is before the given date.
     */
    public void setCertificateExpiryEndDate(java.util.Calendar certificateExpiryEndDate) {
        this.certificateExpiryEndDate = certificateExpiryEndDate;
    }


    /**
     * Gets the certificateLastUsedStartDate value for this UserFilter.
     * 
     * @return certificateLastUsedStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is after the given date.
     */
    public java.util.Calendar getCertificateLastUsedStartDate() {
        return certificateLastUsedStartDate;
    }


    /**
     * Sets the certificateLastUsedStartDate value for this UserFilter.
     * 
     * @param certificateLastUsedStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is after the given date.
     */
    public void setCertificateLastUsedStartDate(java.util.Calendar certificateLastUsedStartDate) {
        this.certificateLastUsedStartDate = certificateLastUsedStartDate;
    }


    /**
     * Gets the certificateLastUsedEndDate value for this UserFilter.
     * 
     * @return certificateLastUsedEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is before the given date.
     */
    public java.util.Calendar getCertificateLastUsedEndDate() {
        return certificateLastUsedEndDate;
    }


    /**
     * Sets the certificateLastUsedEndDate value for this UserFilter.
     * 
     * @param certificateLastUsedEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * last used
     *                                 date is before the given date.
     */
    public void setCertificateLastUsedEndDate(java.util.Calendar certificateLastUsedEndDate) {
        this.certificateLastUsedEndDate = certificateLastUsedEndDate;
    }


    /**
     * Gets the certificateAssignStartDate value for this UserFilter.
     * 
     * @return certificateAssignStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is after the given date.
     */
    public java.util.Calendar getCertificateAssignStartDate() {
        return certificateAssignStartDate;
    }


    /**
     * Sets the certificateAssignStartDate value for this UserFilter.
     * 
     * @param certificateAssignStartDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is after the given date.
     */
    public void setCertificateAssignStartDate(java.util.Calendar certificateAssignStartDate) {
        this.certificateAssignStartDate = certificateAssignStartDate;
    }


    /**
     * Gets the certificateAssignEndDate value for this UserFilter.
     * 
     * @return certificateAssignEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is before the given date.
     */
    public java.util.Calendar getCertificateAssignEndDate() {
        return certificateAssignEndDate;
    }


    /**
     * Sets the certificateAssignEndDate value for this UserFilter.
     * 
     * @param certificateAssignEndDate   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * assign
     *                                 date is before the given date.
     */
    public void setCertificateAssignEndDate(java.util.Calendar certificateAssignEndDate) {
        this.certificateAssignEndDate = certificateAssignEndDate;
    }


    /**
     * Gets the certificateStates value for this UserFilter.
     * 
     * @return certificateStates   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * state
     *                                 matches one of the given values.
     */
    public CertificateState[] getCertificateStates() {
        return certificateStates;
    }


    /**
     * Sets the certificateStates value for this UserFilter.
     * 
     * @param certificateStates   * If specified, returns only certificates or
     *                                 users who have a certificate whose
     * state
     *                                 matches one of the given values.
     */
    public void setCertificateStates(CertificateState[] certificateStates) {
        this.certificateStates = certificateStates;
    }


    /**
     * Gets the certificateSelfSigned value for this UserFilter.
     * 
     * @return certificateSelfSigned   * If specified, returns certificates that
     *                                 are or are not self signed.
     */
    public Boolean getCertificateSelfSigned() {
        return certificateSelfSigned;
    }


    /**
     * Sets the certificateSelfSigned value for this UserFilter.
     * 
     * @param certificateSelfSigned   * If specified, returns certificates that
     *                                 are or are not self signed.
     */
    public void setCertificateSelfSigned(Boolean certificateSelfSigned) {
        this.certificateSelfSigned = certificateSelfSigned;
    }


    /**
     * Gets the certificateCANotRegistered value for this UserFilter.
     * 
     * @return certificateCANotRegistered   * If specified, returns certificates that
     *                                 were or were not issued by a registered
     * CA.
     */
    public Boolean getCertificateCANotRegistered() {
        return certificateCANotRegistered;
    }


    /**
     * Sets the certificateCANotRegistered value for this UserFilter.
     * 
     * @param certificateCANotRegistered   * If specified, returns certificates that
     *                                 were or were not issued by a registered
     * CA.
     */
    public void setCertificateCANotRegistered(Boolean certificateCANotRegistered) {
        this.certificateCANotRegistered = certificateCANotRegistered;
    }


    /**
     * Gets the certificateCAs value for this UserFilter.
     * 
     * @return certificateCAs   * If specified, returns certificates that
     *                                 were issued by one of the named registered
     * CAs.
     */
    public String[] getCertificateCAs() {
        return certificateCAs;
    }


    /**
     * Sets the certificateCAs value for this UserFilter.
     * 
     * @param certificateCAs   * If specified, returns certificates that
     *                                 were issued by one of the named registered
     * CAs.
     */
    public void setCertificateCAs(String[] certificateCAs) {
        this.certificateCAs = certificateCAs;
    }


    /**
     * Gets the absentCertificateStates value for this UserFilter.
     * 
     * @return absentCertificateStates   * If set, only certificates not in any of these
     *                                states, or users who have no certificates
     * with
     *                                any of the states in this list will
     * be returned.
     *                                For example, if this list includes
     * ACTIVE in a
     *                                call to userList, only users with no
     * certificates, or users whose only certificates
     *                                are in the INACTIVE state will be returned.
     * No
     *                                users with ACTIVE certificates will
     * be returned.
     */
    public CertificateState[] getAbsentCertificateStates() {
        return absentCertificateStates;
    }


    /**
     * Sets the absentCertificateStates value for this UserFilter.
     * 
     * @param absentCertificateStates   * If set, only certificates not in any of these
     *                                states, or users who have no certificates
     * with
     *                                any of the states in this list will
     * be returned.
     *                                For example, if this list includes
     * ACTIVE in a
     *                                call to userList, only users with no
     * certificates, or users whose only certificates
     *                                are in the INACTIVE state will be returned.
     * No
     *                                users with ACTIVE certificates will
     * be returned.
     */
    public void setAbsentCertificateStates(CertificateState[] absentCertificateStates) {
        this.absentCertificateStates = absentCertificateStates;
    }


    /**
     * Gets the smartCredentialID value for this UserFilter.
     * 
     * @return smartCredentialID   * If specified, returns Smart Credentials that
     *                                 have an Id matching the given value.
     * The '*' character can be included for wildcard
     *                                 matching.
     */
    public String getSmartCredentialID() {
        return smartCredentialID;
    }


    /**
     * Sets the smartCredentialID value for this UserFilter.
     * 
     * @param smartCredentialID   * If specified, returns Smart Credentials that
     *                                 have an Id matching the given value.
     * The '*' character can be included for wildcard
     *                                 matching.
     */
    public void setSmartCredentialID(String smartCredentialID) {
        this.smartCredentialID = smartCredentialID;
    }


    /**
     * Gets the smartCredentialDefinitions value for this UserFilter.
     * 
     * @return smartCredentialDefinitions   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * Definitions.
     */
    public String[] getSmartCredentialDefinitions() {
        return smartCredentialDefinitions;
    }


    /**
     * Sets the smartCredentialDefinitions value for this UserFilter.
     * 
     * @param smartCredentialDefinitions   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * Definitions.
     */
    public void setSmartCredentialDefinitions(String[] smartCredentialDefinitions) {
        this.smartCredentialDefinitions = smartCredentialDefinitions;
    }


    /**
     * Gets the smartCredentialSerialNumber value for this UserFilter.
     * 
     * @return smartCredentialSerialNumber   * If specified, returns Smart Credentials that
     *                                 have a serial number that matches
     * the
     *                                 given value.  An empty string value
     * will match
     *                                 Smart Credentials that do not have
     * a
     *                                 serial number.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public String getSmartCredentialSerialNumber() {
        return smartCredentialSerialNumber;
    }


    /**
     * Sets the smartCredentialSerialNumber value for this UserFilter.
     * 
     * @param smartCredentialSerialNumber   * If specified, returns Smart Credentials that
     *                                 have a serial number that matches
     * the
     *                                 given value.  An empty string value
     * will match
     *                                 Smart Credentials that do not have
     * a
     *                                 serial number.
     *                                 The '*' character can be included
     * for wildcard
     *                                 matching.
     */
    public void setSmartCredentialSerialNumber(String smartCredentialSerialNumber) {
        this.smartCredentialSerialNumber = smartCredentialSerialNumber;
    }


    /**
     * Gets the smartCredentialCardUID value for this UserFilter.
     * 
     * @return smartCredentialCardUID   * If specified, returns Smart Credentials that
     *                                 have a card UID that matches the
     *                                 given value.
     */
    public String getSmartCredentialCardUID() {
        return smartCredentialCardUID;
    }


    /**
     * Sets the smartCredentialCardUID value for this UserFilter.
     * 
     * @param smartCredentialCardUID   * If specified, returns Smart Credentials that
     *                                 have a card UID that matches the
     *                                 given value.
     */
    public void setSmartCredentialCardUID(String smartCredentialCardUID) {
        this.smartCredentialCardUID = smartCredentialCardUID;
    }


    /**
     * Gets the smartCredentialCardType value for this UserFilter.
     * 
     * @return smartCredentialCardType   * If specified, returns Smart Credentials that
     *                                 have a card type that matches the
     *                                 given value.
     */
    public String getSmartCredentialCardType() {
        return smartCredentialCardType;
    }


    /**
     * Sets the smartCredentialCardType value for this UserFilter.
     * 
     * @param smartCredentialCardType   * If specified, returns Smart Credentials that
     *                                 have a card type that matches the
     *                                 given value.
     */
    public void setSmartCredentialCardType(String smartCredentialCardType) {
        this.smartCredentialCardType = smartCredentialCardType;
    }


    /**
     * Gets the smartCredentialStates value for this UserFilter.
     * 
     * @return smartCredentialStates   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * states.
     */
    public SmartCredentialState[] getSmartCredentialStates() {
        return smartCredentialStates;
    }


    /**
     * Sets the smartCredentialStates value for this UserFilter.
     * 
     * @param smartCredentialStates   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * states.
     */
    public void setSmartCredentialStates(SmartCredentialState[] smartCredentialStates) {
        this.smartCredentialStates = smartCredentialStates;
    }


    /**
     * Gets the absentSmartCredentialStates value for this UserFilter.
     * 
     * @return absentSmartCredentialStates   * If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential states.
     */
    public SmartCredentialState[] getAbsentSmartCredentialStates() {
        return absentSmartCredentialStates;
    }


    /**
     * Sets the absentSmartCredentialStates value for this UserFilter.
     * 
     * @param absentSmartCredentialStates   * If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential states.
     */
    public void setAbsentSmartCredentialStates(SmartCredentialState[] absentSmartCredentialStates) {
        this.absentSmartCredentialStates = absentSmartCredentialStates;
    }


    /**
     * Gets the smartCredentialIssueStates value for this UserFilter.
     * 
     * @return smartCredentialIssueStates   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * print states.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialIssueState[] getSmartCredentialIssueStates() {
        return smartCredentialIssueStates;
    }


    /**
     * Sets the smartCredentialIssueStates value for this UserFilter.
     * 
     * @param smartCredentialIssueStates   * If specified, returns Smart Credentials that
     *                                 have one of the specified Smart Credential
     * print states.
     */
    public void setSmartCredentialIssueStates(com.good.adapters.entrust.stubs.SmartCredentialIssueState[] smartCredentialIssueStates) {
        this.smartCredentialIssueStates = smartCredentialIssueStates;
    }


    /**
     * Gets the absentSmartCredentialIssueStates value for this UserFilter.
     * 
     * @return absentSmartCredentialIssueStates   * If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential print states.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialIssueState[] getAbsentSmartCredentialIssueStates() {
        return absentSmartCredentialIssueStates;
    }


    /**
     * Sets the absentSmartCredentialIssueStates value for this UserFilter.
     * 
     * @param absentSmartCredentialIssueStates   * If specified, returns Smart Credentials that
     *                                 do not have one of the specified Smart
     * Credential print states.
     */
    public void setAbsentSmartCredentialIssueStates(com.good.adapters.entrust.stubs.SmartCredentialIssueState[] absentSmartCredentialIssueStates) {
        this.absentSmartCredentialIssueStates = absentSmartCredentialIssueStates;
    }


    /**
     * Gets the smartCredentialSealed value for this UserFilter.
     * 
     * @return smartCredentialSealed   * If specified, returns Smart Credentials that
     *                                 are or are not sealed.
     */
    public Boolean getSmartCredentialSealed() {
        return smartCredentialSealed;
    }


    /**
     * Sets the smartCredentialSealed value for this UserFilter.
     * 
     * @param smartCredentialSealed   * If specified, returns Smart Credentials that
     *                                 are or are not sealed.
     */
    public void setSmartCredentialSealed(Boolean smartCredentialSealed) {
        this.smartCredentialSealed = smartCredentialSealed;
    }


    /**
     * Gets the smartCredentialApproved value for this UserFilter.
     * 
     * @return smartCredentialApproved   * If specified, returns Smart Credentials that
     *                                 are or are not approved.
     */
    public Boolean getSmartCredentialApproved() {
        return smartCredentialApproved;
    }


    /**
     * Sets the smartCredentialApproved value for this UserFilter.
     * 
     * @param smartCredentialApproved   * If specified, returns Smart Credentials that
     *                                 are or are not approved.
     */
    public void setSmartCredentialApproved(Boolean smartCredentialApproved) {
        this.smartCredentialApproved = smartCredentialApproved;
    }


    /**
     * Gets the smartCredentialValid value for this UserFilter.
     * 
     * @return smartCredentialValid   * If specified, returns Smart Credentials that
     *                                 have or have not got enrollment values
     * that
     *                                 have been validated against the type
     * description
     *                                 of their Definition.
     */
    public Boolean getSmartCredentialValid() {
        return smartCredentialValid;
    }


    /**
     * Sets the smartCredentialValid value for this UserFilter.
     * 
     * @param smartCredentialValid   * If specified, returns Smart Credentials that
     *                                 have or have not got enrollment values
     * that
     *                                 have been validated against the type
     * description
     *                                 of their Definition.
     */
    public void setSmartCredentialValid(Boolean smartCredentialValid) {
        this.smartCredentialValid = smartCredentialValid;
    }


    /**
     * Gets the smartCredentialCreateStartDate value for this UserFilter.
     * 
     * @return smartCredentialCreateStartDate   * If specified, returns only
     *                                 Smart Credentials whose creation date
     * is after the given date.
     */
    public java.util.Calendar getSmartCredentialCreateStartDate() {
        return smartCredentialCreateStartDate;
    }


    /**
     * Sets the smartCredentialCreateStartDate value for this UserFilter.
     * 
     * @param smartCredentialCreateStartDate   * If specified, returns only
     *                                 Smart Credentials whose creation date
     * is after the given date.
     */
    public void setSmartCredentialCreateStartDate(java.util.Calendar smartCredentialCreateStartDate) {
        this.smartCredentialCreateStartDate = smartCredentialCreateStartDate;
    }


    /**
     * Gets the smartCredentialCreateEndDate value for this UserFilter.
     * 
     * @return smartCredentialCreateEndDate   * If specified, returns only
     *                                 Smart Credentials whose creation date
     * is before the given date.
     */
    public java.util.Calendar getSmartCredentialCreateEndDate() {
        return smartCredentialCreateEndDate;
    }


    /**
     * Sets the smartCredentialCreateEndDate value for this UserFilter.
     * 
     * @param smartCredentialCreateEndDate   * If specified, returns only
     *                                 Smart Credentials whose creation date
     * is before the given date.
     */
    public void setSmartCredentialCreateEndDate(java.util.Calendar smartCredentialCreateEndDate) {
        this.smartCredentialCreateEndDate = smartCredentialCreateEndDate;
    }


    /**
     * Gets the smartCredentialExpiryStartDate value for this UserFilter.
     * 
     * @return smartCredentialExpiryStartDate   * If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date.
     */
    public java.util.Calendar getSmartCredentialExpiryStartDate() {
        return smartCredentialExpiryStartDate;
    }


    /**
     * Sets the smartCredentialExpiryStartDate value for this UserFilter.
     * 
     * @param smartCredentialExpiryStartDate   * If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date.
     */
    public void setSmartCredentialExpiryStartDate(java.util.Calendar smartCredentialExpiryStartDate) {
        this.smartCredentialExpiryStartDate = smartCredentialExpiryStartDate;
    }


    /**
     * Gets the smartCredentialExpiryEndDate value for this UserFilter.
     * 
     * @return smartCredentialExpiryEndDate   * If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date.
     */
    public java.util.Calendar getSmartCredentialExpiryEndDate() {
        return smartCredentialExpiryEndDate;
    }


    /**
     * Sets the smartCredentialExpiryEndDate value for this UserFilter.
     * 
     * @param smartCredentialExpiryEndDate   * If specified, returns only
     *                                 Smart Credentials whose expiry date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an expiry date.
     */
    public void setSmartCredentialExpiryEndDate(java.util.Calendar smartCredentialExpiryEndDate) {
        this.smartCredentialExpiryEndDate = smartCredentialExpiryEndDate;
    }


    /**
     * Gets the smartCredentialIssueStartDate value for this UserFilter.
     * 
     * @return smartCredentialIssueStartDate   * If specified, returns only
     *                                 Smart Credentials whose issue date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date.
     */
    public java.util.Calendar getSmartCredentialIssueStartDate() {
        return smartCredentialIssueStartDate;
    }


    /**
     * Sets the smartCredentialIssueStartDate value for this UserFilter.
     * 
     * @param smartCredentialIssueStartDate   * If specified, returns only
     *                                 Smart Credentials whose issue date
     * is after the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date.
     */
    public void setSmartCredentialIssueStartDate(java.util.Calendar smartCredentialIssueStartDate) {
        this.smartCredentialIssueStartDate = smartCredentialIssueStartDate;
    }


    /**
     * Gets the smartCredentialIssueEndDate value for this UserFilter.
     * 
     * @return smartCredentialIssueEndDate   * If specified, returns only
     *                                 Smart Credentials whose issue date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date.
     */
    public java.util.Calendar getSmartCredentialIssueEndDate() {
        return smartCredentialIssueEndDate;
    }


    /**
     * Sets the smartCredentialIssueEndDate value for this UserFilter.
     * 
     * @param smartCredentialIssueEndDate   * If specified, returns only
     *                                 Smart Credentials whose issue date
     * is before the given date.
     *                                 This filter does not match smart credentials
     * that don't have an issue date.
     */
    public void setSmartCredentialIssueEndDate(java.util.Calendar smartCredentialIssueEndDate) {
        this.smartCredentialIssueEndDate = smartCredentialIssueEndDate;
    }


    /**
     * Gets the smartCredentialSupportsUnblock value for this UserFilter.
     * 
     * @return smartCredentialSupportsUnblock   * If specified, returns only
     *                                 Smart Credentials that support/don't
     * support
     *                                 unblock.
     */
    public Boolean getSmartCredentialSupportsUnblock() {
        return smartCredentialSupportsUnblock;
    }


    /**
     * Sets the smartCredentialSupportsUnblock value for this UserFilter.
     * 
     * @param smartCredentialSupportsUnblock   * If specified, returns only
     *                                 Smart Credentials that support/don't
     * support
     *                                 unblock.
     */
    public void setSmartCredentialSupportsUnblock(Boolean smartCredentialSupportsUnblock) {
        this.smartCredentialSupportsUnblock = smartCredentialSupportsUnblock;
    }


    /**
     * Gets the smartCredentialVariableFilters value for this UserFilter.
     * 
     * @return smartCredentialVariableFilters   * If specified, returns Smart Credentials that
     *                                 match the given Smart Credential variable
     * filters.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialVariableFilter[] getSmartCredentialVariableFilters() {
        return smartCredentialVariableFilters;
    }


    /**
     * Sets the smartCredentialVariableFilters value for this UserFilter.
     * 
     * @param smartCredentialVariableFilters   * If specified, returns Smart Credentials that
     *                                 match the given Smart Credential variable
     * filters.
     */
    public void setSmartCredentialVariableFilters(com.good.adapters.entrust.stubs.SmartCredentialVariableFilter[] smartCredentialVariableFilters) {
        this.smartCredentialVariableFilters = smartCredentialVariableFilters;
    }


    /**
     * Gets the digitalIdDN value for this UserFilter.
     * 
     * @return digitalIdDN   * If specified, returns the Digital Id that
     *                                 has the specified DN
     */
    public String getDigitalIdDN() {
        return digitalIdDN;
    }


    /**
     * Sets the digitalIdDN value for this UserFilter.
     * 
     * @param digitalIdDN   * If specified, returns the Digital Id that
     *                                 has the specified DN
     */
    public void setDigitalIdDN(String digitalIdDN) {
        this.digitalIdDN = digitalIdDN;
    }


    /**
     * Gets the digitalIdManagedCAs value for this UserFilter.
     * 
     * @return digitalIdManagedCAs   * If specified, returns Digital Ids that
     *                                 have one of the specified Managed
     * CAs.
     */
    public String[] getDigitalIdManagedCAs() {
        return digitalIdManagedCAs;
    }


    /**
     * Sets the digitalIdManagedCAs value for this UserFilter.
     * 
     * @param digitalIdManagedCAs   * If specified, returns Digital Ids that
     *                                 have one of the specified Managed
     * CAs.
     */
    public void setDigitalIdManagedCAs(String[] digitalIdManagedCAs) {
        this.digitalIdManagedCAs = digitalIdManagedCAs;
    }


    /**
     * Gets the digitalIdConfigs value for this UserFilter.
     * 
     * @return digitalIdConfigs   * If specified, returns Digital Ids that
     *                                 have one of the specified Digital
     * Id Configs.
     */
    public String[] getDigitalIdConfigs() {
        return digitalIdConfigs;
    }


    /**
     * Sets the digitalIdConfigs value for this UserFilter.
     * 
     * @param digitalIdConfigs   * If specified, returns Digital Ids that
     *                                 have one of the specified Digital
     * Id Configs.
     */
    public void setDigitalIdConfigs(String[] digitalIdConfigs) {
        this.digitalIdConfigs = digitalIdConfigs;
    }


    /**
     * Gets the digitalIdClientType value for this UserFilter.
     * 
     * @return digitalIdClientType   * If specified, returns only
     *                                 Digital Ids with the given client
     * type.
     */
    public String getDigitalIdClientType() {
        return digitalIdClientType;
    }


    /**
     * Sets the digitalIdClientType value for this UserFilter.
     * 
     * @param digitalIdClientType   * If specified, returns only
     *                                 Digital Ids with the given client
     * type.
     */
    public void setDigitalIdClientType(String digitalIdClientType) {
        this.digitalIdClientType = digitalIdClientType;
    }


    /**
     * Gets the digitalIdCreateRecoverStartDate value for this UserFilter.
     * 
     * @return digitalIdCreateRecoverStartDate   * If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is after the given date.
     */
    public java.util.Calendar getDigitalIdCreateRecoverStartDate() {
        return digitalIdCreateRecoverStartDate;
    }


    /**
     * Sets the digitalIdCreateRecoverStartDate value for this UserFilter.
     * 
     * @param digitalIdCreateRecoverStartDate   * If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is after the given date.
     */
    public void setDigitalIdCreateRecoverStartDate(java.util.Calendar digitalIdCreateRecoverStartDate) {
        this.digitalIdCreateRecoverStartDate = digitalIdCreateRecoverStartDate;
    }


    /**
     * Gets the digitalIdCreateRecoverEndDate value for this UserFilter.
     * 
     * @return digitalIdCreateRecoverEndDate   * If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is before the given date.
     */
    public java.util.Calendar getDigitalIdCreateRecoverEndDate() {
        return digitalIdCreateRecoverEndDate;
    }


    /**
     * Sets the digitalIdCreateRecoverEndDate value for this UserFilter.
     * 
     * @param digitalIdCreateRecoverEndDate   * If specified, returns only
     *                                 Digital Ids whose create/recover date
     * is before the given date.
     */
    public void setDigitalIdCreateRecoverEndDate(java.util.Calendar digitalIdCreateRecoverEndDate) {
        this.digitalIdCreateRecoverEndDate = digitalIdCreateRecoverEndDate;
    }


    /**
     * Gets the digitalIdExpiryStartDate value for this UserFilter.
     * 
     * @return digitalIdExpiryStartDate   * If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is after the given date.
     */
    public java.util.Calendar getDigitalIdExpiryStartDate() {
        return digitalIdExpiryStartDate;
    }


    /**
     * Sets the digitalIdExpiryStartDate value for this UserFilter.
     * 
     * @param digitalIdExpiryStartDate   * If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is after the given date.
     */
    public void setDigitalIdExpiryStartDate(java.util.Calendar digitalIdExpiryStartDate) {
        this.digitalIdExpiryStartDate = digitalIdExpiryStartDate;
    }


    /**
     * Gets the digitalIdExpiryEndDate value for this UserFilter.
     * 
     * @return digitalIdExpiryEndDate   * If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is before the given date.
     */
    public java.util.Calendar getDigitalIdExpiryEndDate() {
        return digitalIdExpiryEndDate;
    }


    /**
     * Sets the digitalIdExpiryEndDate value for this UserFilter.
     * 
     * @param digitalIdExpiryEndDate   * If specified, returns only
     *                                 Digital Ids whose expiry date
     *                                 is before the given date.
     */
    public void setDigitalIdExpiryEndDate(java.util.Calendar digitalIdExpiryEndDate) {
        this.digitalIdExpiryEndDate = digitalIdExpiryEndDate;
    }


    /**
     * Gets the minNumQa value for this UserFilter.
     * 
     * @return minNumQa   * If set, only users with at least this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at least this many Q/A
     * pairs, will be returned.
     *                             To find all users with Q/A pairs defined,
     * set this value to 1.
     */
    public Integer getMinNumQa() {
        return minNumQa;
    }


    /**
     * Sets the minNumQa value for this UserFilter.
     * 
     * @param minNumQa   * If set, only users with at least this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at least this many Q/A
     * pairs, will be returned.
     *                             To find all users with Q/A pairs defined,
     * set this value to 1.
     */
    public void setMinNumQa(Integer minNumQa) {
        this.minNumQa = minNumQa;
    }


    /**
     * Gets the maxNumQa value for this UserFilter.
     * 
     * @return maxNumQa   * If set, only users with at most this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at most this many Q/A pairs,
     * will be returned.
     *                             To find all users with no Q/A pairs, set
     * this value to 0.
     */
    public Integer getMaxNumQa() {
        return maxNumQa;
    }


    /**
     * Sets the maxNumQa value for this UserFilter.
     * 
     * @param maxNumQa   * If set, only users with at most this many
     *                             question/answer (Q/A) pairs defined, or
     * cards or tokens
     *                             whose user has at most this many Q/A pairs,
     * will be returned.
     *                             To find all users with no Q/A pairs, set
     * this value to 0.
     */
    public void setMaxNumQa(Integer maxNumQa) {
        this.maxNumQa = maxNumQa;
    }


    /**
     * Gets the minNumMachineSecrets value for this UserFilter.
     * 
     * @return minNumMachineSecrets   * If set, only users with at least this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at least this many machine
     * secrets,
     *                             will be returned. To find all users who
     * have machine secrets,
     *                             or cards or tokens whose user has machine
     * secrets,
     *                             set this value to 1.
     */
    public Integer getMinNumMachineSecrets() {
        return minNumMachineSecrets;
    }


    /**
     * Sets the minNumMachineSecrets value for this UserFilter.
     * 
     * @param minNumMachineSecrets   * If set, only users with at least this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at least this many machine
     * secrets,
     *                             will be returned. To find all users who
     * have machine secrets,
     *                             or cards or tokens whose user has machine
     * secrets,
     *                             set this value to 1.
     */
    public void setMinNumMachineSecrets(Integer minNumMachineSecrets) {
        this.minNumMachineSecrets = minNumMachineSecrets;
    }


    /**
     * Gets the maxNumMachineSecrets value for this UserFilter.
     * 
     * @return maxNumMachineSecrets   * If set, only users with at most this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at most this many machine
     * secrets,
     *                             will be returned. To
     *                             find all users who do not have any machine
     * secrets,
     *                             or cards or tokens whose user does not
     * have any machine secrets,
     *                             set this value to 1.
     */
    public Integer getMaxNumMachineSecrets() {
        return maxNumMachineSecrets;
    }


    /**
     * Sets the maxNumMachineSecrets value for this UserFilter.
     * 
     * @param maxNumMachineSecrets   * If set, only users with at most this many machine
     *                             secrets (registered machines), or cards
     * or tokens
     *                             whose user has at most this many machine
     * secrets,
     *                             will be returned. To
     *                             find all users who do not have any machine
     * secrets,
     *                             or cards or tokens whose user does not
     * have any machine secrets,
     *                             set this value to 1.
     */
    public void setMaxNumMachineSecrets(Integer maxNumMachineSecrets) {
        this.maxNumMachineSecrets = maxNumMachineSecrets;
    }


    /**
     * Gets the hasAuthenticationSecrets value for this UserFilter.
     * 
     * @return hasAuthenticationSecrets   * If specified as true, returns any user who has
     *                             mutual authentication secrets, or any
     * card or token whose
     *                             user has mutual authentication secrets.
     * If specified as false, only
     *                             users who do not have mutual authentication
     * secrets, or
     *                             cards or tokens whose user does not have
     * any mutual
     *                             authentication secrets, will be returned.
     */
    public Boolean getHasAuthenticationSecrets() {
        return hasAuthenticationSecrets;
    }


    /**
     * Sets the hasAuthenticationSecrets value for this UserFilter.
     * 
     * @param hasAuthenticationSecrets   * If specified as true, returns any user who has
     *                             mutual authentication secrets, or any
     * card or token whose
     *                             user has mutual authentication secrets.
     * If specified as false, only
     *                             users who do not have mutual authentication
     * secrets, or
     *                             cards or tokens whose user does not have
     * any mutual
     *                             authentication secrets, will be returned.
     */
    public void setHasAuthenticationSecrets(Boolean hasAuthenticationSecrets) {
        this.hasAuthenticationSecrets = hasAuthenticationSecrets;
    }


    /**
     * Gets the hasRole value for this UserFilter.
     * 
     * @return hasRole   * If specified as true, returns any user who has a
     *                             role, or cards or tokens whose user has
     * a role.
     *                             If specified as false, only users who
     * do not
     *                             have a role, or cards or tokens whose
     * user does not
     *                             have a role, will be returned.
     */
    public Boolean getHasRole() {
        return hasRole;
    }


    /**
     * Sets the hasRole value for this UserFilter.
     * 
     * @param hasRole   * If specified as true, returns any user who has a
     *                             role, or cards or tokens whose user has
     * a role.
     *                             If specified as false, only users who
     * do not
     *                             have a role, or cards or tokens whose
     * user does not
     *                             have a role, will be returned.
     */
    public void setHasRole(Boolean hasRole) {
        this.hasRole = hasRole;
    }


    /**
     * Gets the roles value for this UserFilter.
     * 
     * @return roles   * If specified, only users who have at least one of
     *                             the roles in this list, or cards or tokens
     * whose
     *                             user has at least one of the roles in
     * this list,
     *                             will be returned.
     */
    public String[] getRoles() {
        return roles;
    }


    /**
     * Sets the roles value for this UserFilter.
     * 
     * @param roles   * If specified, only users who have at least one of
     *                             the roles in this list, or cards or tokens
     * whose
     *                             user has at least one of the roles in
     * this list,
     *                             will be returned.
     */
    public void setRoles(String[] roles) {
        this.roles = roles;
    }


    /**
     * Gets the lastAuthStartDate value for this UserFilter.
     * 
     * @return lastAuthStartDate   * If specified, returns only
     *                                 users whose last successful authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a successful authentication
     *                                 will be returned.
     */
    public java.util.Calendar getLastAuthStartDate() {
        return lastAuthStartDate;
    }


    /**
     * Sets the lastAuthStartDate value for this UserFilter.
     * 
     * @param lastAuthStartDate   * If specified, returns only
     *                                 users whose last successful authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a successful authentication
     *                                 will be returned.
     */
    public void setLastAuthStartDate(java.util.Calendar lastAuthStartDate) {
        this.lastAuthStartDate = lastAuthStartDate;
    }


    /**
     * Gets the lastAuthEndDate value for this UserFilter.
     * 
     * @return lastAuthEndDate   * If specified, returns only
     *                                 users whose last successful authentication
     * is before the given date.
     */
    public java.util.Calendar getLastAuthEndDate() {
        return lastAuthEndDate;
    }


    /**
     * Sets the lastAuthEndDate value for this UserFilter.
     * 
     * @param lastAuthEndDate   * If specified, returns only
     *                                 users whose last successful authentication
     * is before the given date.
     */
    public void setLastAuthEndDate(java.util.Calendar lastAuthEndDate) {
        this.lastAuthEndDate = lastAuthEndDate;
    }


    /**
     * Gets the lastAuthNever value for this UserFilter.
     * 
     * @return lastAuthNever   * If specified as true, returns only
     *                                 users who have never had a successful
     * authentication.  If specified as false,
     *                                 returns only users who have had a
     *                                 successful authentication.
     */
    public Boolean getLastAuthNever() {
        return lastAuthNever;
    }


    /**
     * Sets the lastAuthNever value for this UserFilter.
     * 
     * @param lastAuthNever   * If specified as true, returns only
     *                                 users who have never had a successful
     * authentication.  If specified as false,
     *                                 returns only users who have had a
     *                                 successful authentication.
     */
    public void setLastAuthNever(Boolean lastAuthNever) {
        this.lastAuthNever = lastAuthNever;
    }


    /**
     * Gets the lastAuthTypes value for this UserFilter.
     * 
     * @return lastAuthTypes   * If specified, returns only
     *                                 users whose last successful authentication
     * was one of the given types.
     */
    public AuthenticationType[] getLastAuthTypes() {
        return lastAuthTypes;
    }


    /**
     * Sets the lastAuthTypes value for this UserFilter.
     * 
     * @param lastAuthTypes   * If specified, returns only
     *                                 users whose last successful authentication
     * was one of the given types.
     */
    public void setLastAuthTypes(AuthenticationType[] lastAuthTypes) {
        this.lastAuthTypes = lastAuthTypes;
    }


    /**
     * Gets the lastFailedAuthStartDate value for this UserFilter.
     * 
     * @return lastFailedAuthStartDate   * If specified, returns only
     *                                 users whose last failed authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a failed authentication
     *                                 will be returned.
     */
    public java.util.Calendar getLastFailedAuthStartDate() {
        return lastFailedAuthStartDate;
    }


    /**
     * Sets the lastFailedAuthStartDate value for this UserFilter.
     * 
     * @param lastFailedAuthStartDate   * If specified, returns only
     *                                 users whose last failed authentication
     * is after the given date.  If the start
     *                                 date is not specified, users who have
     * never had a failed authentication
     *                                 will be returned.
     */
    public void setLastFailedAuthStartDate(java.util.Calendar lastFailedAuthStartDate) {
        this.lastFailedAuthStartDate = lastFailedAuthStartDate;
    }


    /**
     * Gets the lastFailedAuthEndDate value for this UserFilter.
     * 
     * @return lastFailedAuthEndDate   * If specified, returns only
     *                                 users whose last failed authentication
     * is before the given date.
     */
    public java.util.Calendar getLastFailedAuthEndDate() {
        return lastFailedAuthEndDate;
    }


    /**
     * Sets the lastFailedAuthEndDate value for this UserFilter.
     * 
     * @param lastFailedAuthEndDate   * If specified, returns only
     *                                 users whose last failed authentication
     * is before the given date.
     */
    public void setLastFailedAuthEndDate(java.util.Calendar lastFailedAuthEndDate) {
        this.lastFailedAuthEndDate = lastFailedAuthEndDate;
    }


    /**
     * Gets the lastFailedAuthNever value for this UserFilter.
     * 
     * @return lastFailedAuthNever   * If specified as true, returns only
     *                                 users who have never had a failed
     *                                 authentication.  If specified as false,
     * returns only users who have had a
     *                                 failed authentication.
     */
    public Boolean getLastFailedAuthNever() {
        return lastFailedAuthNever;
    }


    /**
     * Sets the lastFailedAuthNever value for this UserFilter.
     * 
     * @param lastFailedAuthNever   * If specified as true, returns only
     *                                 users who have never had a failed
     *                                 authentication.  If specified as false,
     * returns only users who have had a
     *                                 failed authentication.
     */
    public void setLastFailedAuthNever(Boolean lastFailedAuthNever) {
        this.lastFailedAuthNever = lastFailedAuthNever;
    }


    /**
     * Gets the lastFailedAuthTypes value for this UserFilter.
     * 
     * @return lastFailedAuthTypes   * If specified, returns only
     *                                 users whose last failed authentication
     * was one of the given types.
     */
    public AuthenticationType[] getLastFailedAuthTypes() {
        return lastFailedAuthTypes;
    }


    /**
     * Sets the lastFailedAuthTypes value for this UserFilter.
     * 
     * @param lastFailedAuthTypes   * If specified, returns only
     *                                 users whose last failed authentication
     * was one of the given types.
     */
    public void setLastFailedAuthTypes(AuthenticationType[] lastFailedAuthTypes) {
        this.lastFailedAuthTypes = lastFailedAuthTypes;
    }


    /**
     * Gets the disabledInRepository value for this UserFilter.
     * 
     * @return disabledInRepository   * If specified, returns only users who
     *                                 are/are not disabled in the repository.
     * This search criteria is not supported in
     *                                 Entrust IdentityGuard 9.1 and will
     * be ignored
     *                                 if specified.
     */
    public Boolean getDisabledInRepository() {
        return disabledInRepository;
    }


    /**
     * Sets the disabledInRepository value for this UserFilter.
     * 
     * @param disabledInRepository   * If specified, returns only users who
     *                                 are/are not disabled in the repository.
     * This search criteria is not supported in
     *                                 Entrust IdentityGuard 9.1 and will
     * be ignored
     *                                 if specified.
     */
    public void setDisabledInRepository(Boolean disabledInRepository) {
        this.disabledInRepository = disabledInRepository;
    }


    /**
     * Gets the federationTypes value for this UserFilter.
     * 
     * @return federationTypes   * Return user federations whose type
     *                                matches one of the given value.
     */
    public String[] getFederationTypes() {
        return federationTypes;
    }


    /**
     * Sets the federationTypes value for this UserFilter.
     * 
     * @param federationTypes   * Return user federations whose type
     *                                matches one of the given value.
     */
    public void setFederationTypes(String[] federationTypes) {
        this.federationTypes = federationTypes;
    }


    /**
     * Gets the federationPartnerID value for this UserFilter.
     * 
     * @return federationPartnerID   * The partner ID of the federation. For example
     *                                 the SAML partner entity ID.
     */
    public String getFederationPartnerID() {
        return federationPartnerID;
    }


    /**
     * Sets the federationPartnerID value for this UserFilter.
     * 
     * @param federationPartnerID   * The partner ID of the federation. For example
     *                                 the SAML partner entity ID.
     */
    public void setFederationPartnerID(String federationPartnerID) {
        this.federationPartnerID = federationPartnerID;
    }


    /**
     * Gets the federationOriginator value for this UserFilter.
     * 
     * @return federationOriginator   * A flag indicating if this server is the
     *                                 originator of the federation.
     */
    public Boolean getFederationOriginator() {
        return federationOriginator;
    }


    /**
     * Sets the federationOriginator value for this UserFilter.
     * 
     * @param federationOriginator   * A flag indicating if this server is the
     *                                 originator of the federation.
     */
    public void setFederationOriginator(Boolean federationOriginator) {
        this.federationOriginator = federationOriginator;
    }


    /**
     * Gets the invalidUsers value for this UserFilter.
     * 
     * @return invalidUsers   * An invalid user is a user that doesn't pass
     *                                data integrity.  In the case of LDAP,
     * this
     *                                is a likely indication that the user
     * has been
     *                                renamed in the repository without being
     * renamed within Entrust IdentityGuard.  If this
     *                                flag is set to true, only users that
     * pass
     *                                data integrity will be returned.  If
     * this flag
     *                                is set to false, only users that don't
     * pass
     *                                data integrity will be returned.
     */
    public Boolean getInvalidUsers() {
        return invalidUsers;
    }


    /**
     * Sets the invalidUsers value for this UserFilter.
     * 
     * @param invalidUsers   * An invalid user is a user that doesn't pass
     *                                data integrity.  In the case of LDAP,
     * this
     *                                is a likely indication that the user
     * has been
     *                                renamed in the repository without being
     * renamed within Entrust IdentityGuard.  If this
     *                                flag is set to true, only users that
     * pass
     *                                data integrity will be returned.  If
     * this flag
     *                                is set to false, only users that don't
     * pass
     *                                data integrity will be returned.
     */
    public void setInvalidUsers(Boolean invalidUsers) {
        this.invalidUsers = invalidUsers;
    }


    /**
     * Gets the maxReturn value for this UserFilter.
     * 
     * @return maxReturn   * The number of users, cards or tokens to return.
     *                                 If not specified or the value is 0
     * or less, it defaults
     *                                 to 100.
     */
    public Integer getMaxReturn() {
        return maxReturn;
    }


    /**
     * Sets the maxReturn value for this UserFilter.
     * 
     * @param maxReturn   * The number of users, cards or tokens to return.
     *                                 If not specified or the value is 0
     * or less, it defaults
     *                                 to 100.
     */
    public void setMaxReturn(Integer maxReturn) {
        this.maxReturn = maxReturn;
    }


    /**
     * Gets the nextUser value for this UserFilter.
     * 
     * @return nextUser   * The nextUser number. If specified, indicates that searching
     * should start at the given user. This value is used to
     *                                 get the next set of users, cards,
     * or tokens following a previous search.
     *                                 The value to set here is the nextUser
     * value from
     *                                 the previous search results.
     */
    public java.math.BigInteger getNextUser() {
        return nextUser;
    }


    /**
     * Sets the nextUser value for this UserFilter.
     * 
     * @param nextUser   * The nextUser number. If specified, indicates that searching
     * should start at the given user. This value is used to
     *                                 get the next set of users, cards,
     * or tokens following a previous search.
     *                                 The value to set here is the nextUser
     * value from
     *                                 the previous search results.
     */
    public void setNextUser(java.math.BigInteger nextUser) {
        this.nextUser = nextUser;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserFilter)) return false;
        UserFilter other = (UserFilter) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.alias==null && other.getAlias()==null) || 
             (this.alias!=null &&
              this.alias.equals(other.getAlias()))) &&
            ((this.aliasOrUserid==null && other.getAliasOrUserid()==null) || 
             (this.aliasOrUserid!=null &&
              this.aliasOrUserid.equals(other.getAliasOrUserid()))) &&
            ((this.fullName==null && other.getFullName()==null) || 
             (this.fullName!=null &&
              this.fullName.equals(other.getFullName()))) &&
            ((this.locale==null && other.getLocale()==null) || 
             (this.locale!=null &&
              java.util.Arrays.equals(this.locale, other.getLocale()))) &&
            ((this.groups==null && other.getGroups()==null) || 
             (this.groups!=null &&
              java.util.Arrays.equals(this.groups, other.getGroups()))) &&
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.createStartDate==null && other.getCreateStartDate()==null) || 
             (this.createStartDate!=null &&
              this.createStartDate.equals(other.getCreateStartDate()))) &&
            ((this.createEndDate==null && other.getCreateEndDate()==null) || 
             (this.createEndDate!=null &&
              this.createEndDate.equals(other.getCreateEndDate()))) &&
            ((this.expireStartDate==null && other.getExpireStartDate()==null) || 
             (this.expireStartDate!=null &&
              this.expireStartDate.equals(other.getExpireStartDate()))) &&
            ((this.expireEndDate==null && other.getExpireEndDate()==null) || 
             (this.expireEndDate!=null &&
              this.expireEndDate.equals(other.getExpireEndDate()))) &&
            ((this.states==null && other.getStates()==null) || 
             (this.states!=null &&
              java.util.Arrays.equals(this.states, other.getStates()))) &&
            ((this.absentCardStates==null && other.getAbsentCardStates()==null) || 
             (this.absentCardStates!=null &&
              java.util.Arrays.equals(this.absentCardStates, other.getAbsentCardStates()))) &&
            ((this.userStates==null && other.getUserStates()==null) || 
             (this.userStates!=null &&
              java.util.Arrays.equals(this.userStates, other.getUserStates()))) &&
            ((this.minChallengeCount==null && other.getMinChallengeCount()==null) || 
             (this.minChallengeCount!=null &&
              this.minChallengeCount.equals(other.getMinChallengeCount()))) &&
            ((this.maxChallengeCount==null && other.getMaxChallengeCount()==null) || 
             (this.maxChallengeCount!=null &&
              this.maxChallengeCount.equals(other.getMaxChallengeCount()))) &&
            ((this.minLeastUsedCellUsageCount==null && other.getMinLeastUsedCellUsageCount()==null) || 
             (this.minLeastUsedCellUsageCount!=null &&
              this.minLeastUsedCellUsageCount.equals(other.getMinLeastUsedCellUsageCount()))) &&
            ((this.maxLeastUsedCellUsageCount==null && other.getMaxLeastUsedCellUsageCount()==null) || 
             (this.maxLeastUsedCellUsageCount!=null &&
              this.maxLeastUsedCellUsageCount.equals(other.getMaxLeastUsedCellUsageCount()))) &&
            ((this.cardUsageThresholdIndicator==null && other.getCardUsageThresholdIndicator()==null) || 
             (this.cardUsageThresholdIndicator!=null &&
              java.util.Arrays.equals(this.cardUsageThresholdIndicator, other.getCardUsageThresholdIndicator()))) &&
            ((this.hasPIN==null && other.getHasPIN()==null) || 
             (this.hasPIN!=null &&
              this.hasPIN.equals(other.getHasPIN()))) &&
            ((this.minNumTempPINUses==null && other.getMinNumTempPINUses()==null) || 
             (this.minNumTempPINUses!=null &&
              this.minNumTempPINUses.equals(other.getMinNumTempPINUses()))) &&
            ((this.maxNumTempPINUses==null && other.getMaxNumTempPINUses()==null) || 
             (this.maxNumTempPINUses!=null &&
              this.maxNumTempPINUses.equals(other.getMaxNumTempPINUses()))) &&
            ((this.tempPINExpireStartDate==null && other.getTempPINExpireStartDate()==null) || 
             (this.tempPINExpireStartDate!=null &&
              this.tempPINExpireStartDate.equals(other.getTempPINExpireStartDate()))) &&
            ((this.tempPINExpireEndDate==null && other.getTempPINExpireEndDate()==null) || 
             (this.tempPINExpireEndDate!=null &&
              this.tempPINExpireEndDate.equals(other.getTempPINExpireEndDate()))) &&
            ((this.hasPVN==null && other.getHasPVN()==null) || 
             (this.hasPVN!=null &&
              this.hasPVN.equals(other.getHasPVN()))) &&
            ((this.hasPassword==null && other.getHasPassword()==null) || 
             (this.hasPassword!=null &&
              this.hasPassword.equals(other.getHasPassword()))) &&
            ((this.pvnChangeRequired==null && other.getPvnChangeRequired()==null) || 
             (this.pvnChangeRequired!=null &&
              this.pvnChangeRequired.equals(other.getPvnChangeRequired()))) &&
            ((this.pvnLastChangeStartDate==null && other.getPvnLastChangeStartDate()==null) || 
             (this.pvnLastChangeStartDate!=null &&
              this.pvnLastChangeStartDate.equals(other.getPvnLastChangeStartDate()))) &&
            ((this.pvnLastChangeEndDate==null && other.getPvnLastChangeEndDate()==null) || 
             (this.pvnLastChangeEndDate!=null &&
              this.pvnLastChangeEndDate.equals(other.getPvnLastChangeEndDate()))) &&
            ((this.passwordChangeRequired==null && other.getPasswordChangeRequired()==null) || 
             (this.passwordChangeRequired!=null &&
              this.passwordChangeRequired.equals(other.getPasswordChangeRequired()))) &&
            ((this.passwordExpireStartDate==null && other.getPasswordExpireStartDate()==null) || 
             (this.passwordExpireStartDate!=null &&
              this.passwordExpireStartDate.equals(other.getPasswordExpireStartDate()))) &&
            ((this.passwordExpireEndDate==null && other.getPasswordExpireEndDate()==null) || 
             (this.passwordExpireEndDate!=null &&
              this.passwordExpireEndDate.equals(other.getPasswordExpireEndDate()))) &&
            ((this.passwordLastChangeStartDate==null && other.getPasswordLastChangeStartDate()==null) || 
             (this.passwordLastChangeStartDate!=null &&
              this.passwordLastChangeStartDate.equals(other.getPasswordLastChangeStartDate()))) &&
            ((this.passwordLastChangeEndDate==null && other.getPasswordLastChangeEndDate()==null) || 
             (this.passwordLastChangeEndDate!=null &&
              this.passwordLastChangeEndDate.equals(other.getPasswordLastChangeEndDate()))) &&
            ((this.activationExpireStartDate==null && other.getActivationExpireStartDate()==null) || 
             (this.activationExpireStartDate!=null &&
              this.activationExpireStartDate.equals(other.getActivationExpireStartDate()))) &&
            ((this.activationExpireEndDate==null && other.getActivationExpireEndDate()==null) || 
             (this.activationExpireEndDate!=null &&
              this.activationExpireEndDate.equals(other.getActivationExpireEndDate()))) &&
            ((this.activationExpireCode==null && other.getActivationExpireCode()==null) || 
             (this.activationExpireCode!=null &&
              this.activationExpireCode.equals(other.getActivationExpireCode()))) &&
            ((this.otpAllowed==null && other.getOtpAllowed()==null) || 
             (this.otpAllowed!=null &&
              this.otpAllowed.equals(other.getOtpAllowed()))) &&
            ((this.otpDeliveryEnabled==null && other.getOtpDeliveryEnabled()==null) || 
             (this.otpDeliveryEnabled!=null &&
              java.util.Arrays.equals(this.otpDeliveryEnabled, other.getOtpDeliveryEnabled()))) &&
            ((this.minNumOTPs==null && other.getMinNumOTPs()==null) || 
             (this.minNumOTPs!=null &&
              this.minNumOTPs.equals(other.getMinNumOTPs()))) &&
            ((this.maxNumOTPs==null && other.getMaxNumOTPs()==null) || 
             (this.maxNumOTPs!=null &&
              this.maxNumOTPs.equals(other.getMaxNumOTPs()))) &&
            ((this.OTPExpiryStartDate==null && other.getOTPExpiryStartDate()==null) || 
             (this.OTPExpiryStartDate!=null &&
              this.OTPExpiryStartDate.equals(other.getOTPExpiryStartDate()))) &&
            ((this.OTPExpiryEndDate==null && other.getOTPExpiryEndDate()==null) || 
             (this.OTPExpiryEndDate!=null &&
              this.OTPExpiryEndDate.equals(other.getOTPExpiryEndDate()))) &&
            ((this.hasContactInfo==null && other.getHasContactInfo()==null) || 
             (this.hasContactInfo!=null &&
              this.hasContactInfo.equals(other.getHasContactInfo()))) &&
            ((this.minUsableContactInfo==null && other.getMinUsableContactInfo()==null) || 
             (this.minUsableContactInfo!=null &&
              this.minUsableContactInfo.equals(other.getMinUsableContactInfo()))) &&
            ((this.maxUsableContactInfo==null && other.getMaxUsableContactInfo()==null) || 
             (this.maxUsableContactInfo!=null &&
              this.maxUsableContactInfo.equals(other.getMaxUsableContactInfo()))) &&
            ((this.minNumLocations==null && other.getMinNumLocations()==null) || 
             (this.minNumLocations!=null &&
              this.minNumLocations.equals(other.getMinNumLocations()))) &&
            ((this.maxNumLocations==null && other.getMaxNumLocations()==null) || 
             (this.maxNumLocations!=null &&
              this.maxNumLocations.equals(other.getMaxNumLocations()))) &&
            ((this.locked==null && other.getLocked()==null) || 
             (this.locked!=null &&
              this.locked.equals(other.getLocked()))) &&
            ((this.tokenVendorId==null && other.getTokenVendorId()==null) || 
             (this.tokenVendorId!=null &&
              this.tokenVendorId.equals(other.getTokenVendorId()))) &&
            ((this.tokenSerialNumber==null && other.getTokenSerialNumber()==null) || 
             (this.tokenSerialNumber!=null &&
              this.tokenSerialNumber.equals(other.getTokenSerialNumber()))) &&
            ((this.tokenLoadStartDate==null && other.getTokenLoadStartDate()==null) || 
             (this.tokenLoadStartDate!=null &&
              this.tokenLoadStartDate.equals(other.getTokenLoadStartDate()))) &&
            ((this.tokenLoadEndDate==null && other.getTokenLoadEndDate()==null) || 
             (this.tokenLoadEndDate!=null &&
              this.tokenLoadEndDate.equals(other.getTokenLoadEndDate()))) &&
            ((this.tokenLastUsedStartDate==null && other.getTokenLastUsedStartDate()==null) || 
             (this.tokenLastUsedStartDate!=null &&
              this.tokenLastUsedStartDate.equals(other.getTokenLastUsedStartDate()))) &&
            ((this.tokenLastUsedEndDate==null && other.getTokenLastUsedEndDate()==null) || 
             (this.tokenLastUsedEndDate!=null &&
              this.tokenLastUsedEndDate.equals(other.getTokenLastUsedEndDate()))) &&
            ((this.tokenStates==null && other.getTokenStates()==null) || 
             (this.tokenStates!=null &&
              java.util.Arrays.equals(this.tokenStates, other.getTokenStates()))) &&
            ((this.absentTokenStates==null && other.getAbsentTokenStates()==null) || 
             (this.absentTokenStates!=null &&
              java.util.Arrays.equals(this.absentTokenStates, other.getAbsentTokenStates()))) &&
            ((this.certificateIssuerDN==null && other.getCertificateIssuerDN()==null) || 
             (this.certificateIssuerDN!=null &&
              this.certificateIssuerDN.equals(other.getCertificateIssuerDN()))) &&
            ((this.certificateSubjectDN==null && other.getCertificateSubjectDN()==null) || 
             (this.certificateSubjectDN!=null &&
              this.certificateSubjectDN.equals(other.getCertificateSubjectDN()))) &&
            ((this.certificateSerialNumber==null && other.getCertificateSerialNumber()==null) || 
             (this.certificateSerialNumber!=null &&
              this.certificateSerialNumber.equals(other.getCertificateSerialNumber()))) &&
            ((this.certificateIssueStartDate==null && other.getCertificateIssueStartDate()==null) || 
             (this.certificateIssueStartDate!=null &&
              this.certificateIssueStartDate.equals(other.getCertificateIssueStartDate()))) &&
            ((this.certificateIssueEndDate==null && other.getCertificateIssueEndDate()==null) || 
             (this.certificateIssueEndDate!=null &&
              this.certificateIssueEndDate.equals(other.getCertificateIssueEndDate()))) &&
            ((this.certificateExpiryStartDate==null && other.getCertificateExpiryStartDate()==null) || 
             (this.certificateExpiryStartDate!=null &&
              this.certificateExpiryStartDate.equals(other.getCertificateExpiryStartDate()))) &&
            ((this.certificateExpiryEndDate==null && other.getCertificateExpiryEndDate()==null) || 
             (this.certificateExpiryEndDate!=null &&
              this.certificateExpiryEndDate.equals(other.getCertificateExpiryEndDate()))) &&
            ((this.certificateLastUsedStartDate==null && other.getCertificateLastUsedStartDate()==null) || 
             (this.certificateLastUsedStartDate!=null &&
              this.certificateLastUsedStartDate.equals(other.getCertificateLastUsedStartDate()))) &&
            ((this.certificateLastUsedEndDate==null && other.getCertificateLastUsedEndDate()==null) || 
             (this.certificateLastUsedEndDate!=null &&
              this.certificateLastUsedEndDate.equals(other.getCertificateLastUsedEndDate()))) &&
            ((this.certificateAssignStartDate==null && other.getCertificateAssignStartDate()==null) || 
             (this.certificateAssignStartDate!=null &&
              this.certificateAssignStartDate.equals(other.getCertificateAssignStartDate()))) &&
            ((this.certificateAssignEndDate==null && other.getCertificateAssignEndDate()==null) || 
             (this.certificateAssignEndDate!=null &&
              this.certificateAssignEndDate.equals(other.getCertificateAssignEndDate()))) &&
            ((this.certificateStates==null && other.getCertificateStates()==null) || 
             (this.certificateStates!=null &&
              java.util.Arrays.equals(this.certificateStates, other.getCertificateStates()))) &&
            ((this.certificateSelfSigned==null && other.getCertificateSelfSigned()==null) || 
             (this.certificateSelfSigned!=null &&
              this.certificateSelfSigned.equals(other.getCertificateSelfSigned()))) &&
            ((this.certificateCANotRegistered==null && other.getCertificateCANotRegistered()==null) || 
             (this.certificateCANotRegistered!=null &&
              this.certificateCANotRegistered.equals(other.getCertificateCANotRegistered()))) &&
            ((this.certificateCAs==null && other.getCertificateCAs()==null) || 
             (this.certificateCAs!=null &&
              java.util.Arrays.equals(this.certificateCAs, other.getCertificateCAs()))) &&
            ((this.absentCertificateStates==null && other.getAbsentCertificateStates()==null) || 
             (this.absentCertificateStates!=null &&
              java.util.Arrays.equals(this.absentCertificateStates, other.getAbsentCertificateStates()))) &&
            ((this.smartCredentialID==null && other.getSmartCredentialID()==null) || 
             (this.smartCredentialID!=null &&
              this.smartCredentialID.equals(other.getSmartCredentialID()))) &&
            ((this.smartCredentialDefinitions==null && other.getSmartCredentialDefinitions()==null) || 
             (this.smartCredentialDefinitions!=null &&
              java.util.Arrays.equals(this.smartCredentialDefinitions, other.getSmartCredentialDefinitions()))) &&
            ((this.smartCredentialSerialNumber==null && other.getSmartCredentialSerialNumber()==null) || 
             (this.smartCredentialSerialNumber!=null &&
              this.smartCredentialSerialNumber.equals(other.getSmartCredentialSerialNumber()))) &&
            ((this.smartCredentialCardUID==null && other.getSmartCredentialCardUID()==null) || 
             (this.smartCredentialCardUID!=null &&
              this.smartCredentialCardUID.equals(other.getSmartCredentialCardUID()))) &&
            ((this.smartCredentialCardType==null && other.getSmartCredentialCardType()==null) || 
             (this.smartCredentialCardType!=null &&
              this.smartCredentialCardType.equals(other.getSmartCredentialCardType()))) &&
            ((this.smartCredentialStates==null && other.getSmartCredentialStates()==null) || 
             (this.smartCredentialStates!=null &&
              java.util.Arrays.equals(this.smartCredentialStates, other.getSmartCredentialStates()))) &&
            ((this.absentSmartCredentialStates==null && other.getAbsentSmartCredentialStates()==null) || 
             (this.absentSmartCredentialStates!=null &&
              java.util.Arrays.equals(this.absentSmartCredentialStates, other.getAbsentSmartCredentialStates()))) &&
            ((this.smartCredentialIssueStates==null && other.getSmartCredentialIssueStates()==null) || 
             (this.smartCredentialIssueStates!=null &&
              java.util.Arrays.equals(this.smartCredentialIssueStates, other.getSmartCredentialIssueStates()))) &&
            ((this.absentSmartCredentialIssueStates==null && other.getAbsentSmartCredentialIssueStates()==null) || 
             (this.absentSmartCredentialIssueStates!=null &&
              java.util.Arrays.equals(this.absentSmartCredentialIssueStates, other.getAbsentSmartCredentialIssueStates()))) &&
            ((this.smartCredentialSealed==null && other.getSmartCredentialSealed()==null) || 
             (this.smartCredentialSealed!=null &&
              this.smartCredentialSealed.equals(other.getSmartCredentialSealed()))) &&
            ((this.smartCredentialApproved==null && other.getSmartCredentialApproved()==null) || 
             (this.smartCredentialApproved!=null &&
              this.smartCredentialApproved.equals(other.getSmartCredentialApproved()))) &&
            ((this.smartCredentialValid==null && other.getSmartCredentialValid()==null) || 
             (this.smartCredentialValid!=null &&
              this.smartCredentialValid.equals(other.getSmartCredentialValid()))) &&
            ((this.smartCredentialCreateStartDate==null && other.getSmartCredentialCreateStartDate()==null) || 
             (this.smartCredentialCreateStartDate!=null &&
              this.smartCredentialCreateStartDate.equals(other.getSmartCredentialCreateStartDate()))) &&
            ((this.smartCredentialCreateEndDate==null && other.getSmartCredentialCreateEndDate()==null) || 
             (this.smartCredentialCreateEndDate!=null &&
              this.smartCredentialCreateEndDate.equals(other.getSmartCredentialCreateEndDate()))) &&
            ((this.smartCredentialExpiryStartDate==null && other.getSmartCredentialExpiryStartDate()==null) || 
             (this.smartCredentialExpiryStartDate!=null &&
              this.smartCredentialExpiryStartDate.equals(other.getSmartCredentialExpiryStartDate()))) &&
            ((this.smartCredentialExpiryEndDate==null && other.getSmartCredentialExpiryEndDate()==null) || 
             (this.smartCredentialExpiryEndDate!=null &&
              this.smartCredentialExpiryEndDate.equals(other.getSmartCredentialExpiryEndDate()))) &&
            ((this.smartCredentialIssueStartDate==null && other.getSmartCredentialIssueStartDate()==null) || 
             (this.smartCredentialIssueStartDate!=null &&
              this.smartCredentialIssueStartDate.equals(other.getSmartCredentialIssueStartDate()))) &&
            ((this.smartCredentialIssueEndDate==null && other.getSmartCredentialIssueEndDate()==null) || 
             (this.smartCredentialIssueEndDate!=null &&
              this.smartCredentialIssueEndDate.equals(other.getSmartCredentialIssueEndDate()))) &&
            ((this.smartCredentialSupportsUnblock==null && other.getSmartCredentialSupportsUnblock()==null) || 
             (this.smartCredentialSupportsUnblock!=null &&
              this.smartCredentialSupportsUnblock.equals(other.getSmartCredentialSupportsUnblock()))) &&
            ((this.smartCredentialVariableFilters==null && other.getSmartCredentialVariableFilters()==null) || 
             (this.smartCredentialVariableFilters!=null &&
              java.util.Arrays.equals(this.smartCredentialVariableFilters, other.getSmartCredentialVariableFilters()))) &&
            ((this.digitalIdDN==null && other.getDigitalIdDN()==null) || 
             (this.digitalIdDN!=null &&
              this.digitalIdDN.equals(other.getDigitalIdDN()))) &&
            ((this.digitalIdManagedCAs==null && other.getDigitalIdManagedCAs()==null) || 
             (this.digitalIdManagedCAs!=null &&
              java.util.Arrays.equals(this.digitalIdManagedCAs, other.getDigitalIdManagedCAs()))) &&
            ((this.digitalIdConfigs==null && other.getDigitalIdConfigs()==null) || 
             (this.digitalIdConfigs!=null &&
              java.util.Arrays.equals(this.digitalIdConfigs, other.getDigitalIdConfigs()))) &&
            ((this.digitalIdClientType==null && other.getDigitalIdClientType()==null) || 
             (this.digitalIdClientType!=null &&
              this.digitalIdClientType.equals(other.getDigitalIdClientType()))) &&
            ((this.digitalIdCreateRecoverStartDate==null && other.getDigitalIdCreateRecoverStartDate()==null) || 
             (this.digitalIdCreateRecoverStartDate!=null &&
              this.digitalIdCreateRecoverStartDate.equals(other.getDigitalIdCreateRecoverStartDate()))) &&
            ((this.digitalIdCreateRecoverEndDate==null && other.getDigitalIdCreateRecoverEndDate()==null) || 
             (this.digitalIdCreateRecoverEndDate!=null &&
              this.digitalIdCreateRecoverEndDate.equals(other.getDigitalIdCreateRecoverEndDate()))) &&
            ((this.digitalIdExpiryStartDate==null && other.getDigitalIdExpiryStartDate()==null) || 
             (this.digitalIdExpiryStartDate!=null &&
              this.digitalIdExpiryStartDate.equals(other.getDigitalIdExpiryStartDate()))) &&
            ((this.digitalIdExpiryEndDate==null && other.getDigitalIdExpiryEndDate()==null) || 
             (this.digitalIdExpiryEndDate!=null &&
              this.digitalIdExpiryEndDate.equals(other.getDigitalIdExpiryEndDate()))) &&
            ((this.minNumQa==null && other.getMinNumQa()==null) || 
             (this.minNumQa!=null &&
              this.minNumQa.equals(other.getMinNumQa()))) &&
            ((this.maxNumQa==null && other.getMaxNumQa()==null) || 
             (this.maxNumQa!=null &&
              this.maxNumQa.equals(other.getMaxNumQa()))) &&
            ((this.minNumMachineSecrets==null && other.getMinNumMachineSecrets()==null) || 
             (this.minNumMachineSecrets!=null &&
              this.minNumMachineSecrets.equals(other.getMinNumMachineSecrets()))) &&
            ((this.maxNumMachineSecrets==null && other.getMaxNumMachineSecrets()==null) || 
             (this.maxNumMachineSecrets!=null &&
              this.maxNumMachineSecrets.equals(other.getMaxNumMachineSecrets()))) &&
            ((this.hasAuthenticationSecrets==null && other.getHasAuthenticationSecrets()==null) || 
             (this.hasAuthenticationSecrets!=null &&
              this.hasAuthenticationSecrets.equals(other.getHasAuthenticationSecrets()))) &&
            ((this.hasRole==null && other.getHasRole()==null) || 
             (this.hasRole!=null &&
              this.hasRole.equals(other.getHasRole()))) &&
            ((this.roles==null && other.getRoles()==null) || 
             (this.roles!=null &&
              java.util.Arrays.equals(this.roles, other.getRoles()))) &&
            ((this.lastAuthStartDate==null && other.getLastAuthStartDate()==null) || 
             (this.lastAuthStartDate!=null &&
              this.lastAuthStartDate.equals(other.getLastAuthStartDate()))) &&
            ((this.lastAuthEndDate==null && other.getLastAuthEndDate()==null) || 
             (this.lastAuthEndDate!=null &&
              this.lastAuthEndDate.equals(other.getLastAuthEndDate()))) &&
            ((this.lastAuthNever==null && other.getLastAuthNever()==null) || 
             (this.lastAuthNever!=null &&
              this.lastAuthNever.equals(other.getLastAuthNever()))) &&
            ((this.lastAuthTypes==null && other.getLastAuthTypes()==null) || 
             (this.lastAuthTypes!=null &&
              java.util.Arrays.equals(this.lastAuthTypes, other.getLastAuthTypes()))) &&
            ((this.lastFailedAuthStartDate==null && other.getLastFailedAuthStartDate()==null) || 
             (this.lastFailedAuthStartDate!=null &&
              this.lastFailedAuthStartDate.equals(other.getLastFailedAuthStartDate()))) &&
            ((this.lastFailedAuthEndDate==null && other.getLastFailedAuthEndDate()==null) || 
             (this.lastFailedAuthEndDate!=null &&
              this.lastFailedAuthEndDate.equals(other.getLastFailedAuthEndDate()))) &&
            ((this.lastFailedAuthNever==null && other.getLastFailedAuthNever()==null) || 
             (this.lastFailedAuthNever!=null &&
              this.lastFailedAuthNever.equals(other.getLastFailedAuthNever()))) &&
            ((this.lastFailedAuthTypes==null && other.getLastFailedAuthTypes()==null) || 
             (this.lastFailedAuthTypes!=null &&
              java.util.Arrays.equals(this.lastFailedAuthTypes, other.getLastFailedAuthTypes()))) &&
            ((this.disabledInRepository==null && other.getDisabledInRepository()==null) || 
             (this.disabledInRepository!=null &&
              this.disabledInRepository.equals(other.getDisabledInRepository()))) &&
            ((this.federationTypes==null && other.getFederationTypes()==null) || 
             (this.federationTypes!=null &&
              java.util.Arrays.equals(this.federationTypes, other.getFederationTypes()))) &&
            ((this.federationPartnerID==null && other.getFederationPartnerID()==null) || 
             (this.federationPartnerID!=null &&
              this.federationPartnerID.equals(other.getFederationPartnerID()))) &&
            ((this.federationOriginator==null && other.getFederationOriginator()==null) || 
             (this.federationOriginator!=null &&
              this.federationOriginator.equals(other.getFederationOriginator()))) &&
            ((this.invalidUsers==null && other.getInvalidUsers()==null) || 
             (this.invalidUsers!=null &&
              this.invalidUsers.equals(other.getInvalidUsers()))) &&
            ((this.maxReturn==null && other.getMaxReturn()==null) || 
             (this.maxReturn!=null &&
              this.maxReturn.equals(other.getMaxReturn()))) &&
            ((this.nextUser==null && other.getNextUser()==null) || 
             (this.nextUser!=null &&
              this.nextUser.equals(other.getNextUser())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getAlias() != null) {
            _hashCode += getAlias().hashCode();
        }
        if (getAliasOrUserid() != null) {
            _hashCode += getAliasOrUserid().hashCode();
        }
        if (getFullName() != null) {
            _hashCode += getFullName().hashCode();
        }
        if (getLocale() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getLocale());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getLocale(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getGroups() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getGroups());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getGroups(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getCreateStartDate() != null) {
            _hashCode += getCreateStartDate().hashCode();
        }
        if (getCreateEndDate() != null) {
            _hashCode += getCreateEndDate().hashCode();
        }
        if (getExpireStartDate() != null) {
            _hashCode += getExpireStartDate().hashCode();
        }
        if (getExpireEndDate() != null) {
            _hashCode += getExpireEndDate().hashCode();
        }
        if (getStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAbsentCardStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAbsentCardStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAbsentCardStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getUserStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getUserStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getUserStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMinChallengeCount() != null) {
            _hashCode += getMinChallengeCount().hashCode();
        }
        if (getMaxChallengeCount() != null) {
            _hashCode += getMaxChallengeCount().hashCode();
        }
        if (getMinLeastUsedCellUsageCount() != null) {
            _hashCode += getMinLeastUsedCellUsageCount().hashCode();
        }
        if (getMaxLeastUsedCellUsageCount() != null) {
            _hashCode += getMaxLeastUsedCellUsageCount().hashCode();
        }
        if (getCardUsageThresholdIndicator() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCardUsageThresholdIndicator());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCardUsageThresholdIndicator(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getHasPIN() != null) {
            _hashCode += getHasPIN().hashCode();
        }
        if (getMinNumTempPINUses() != null) {
            _hashCode += getMinNumTempPINUses().hashCode();
        }
        if (getMaxNumTempPINUses() != null) {
            _hashCode += getMaxNumTempPINUses().hashCode();
        }
        if (getTempPINExpireStartDate() != null) {
            _hashCode += getTempPINExpireStartDate().hashCode();
        }
        if (getTempPINExpireEndDate() != null) {
            _hashCode += getTempPINExpireEndDate().hashCode();
        }
        if (getHasPVN() != null) {
            _hashCode += getHasPVN().hashCode();
        }
        if (getHasPassword() != null) {
            _hashCode += getHasPassword().hashCode();
        }
        if (getPvnChangeRequired() != null) {
            _hashCode += getPvnChangeRequired().hashCode();
        }
        if (getPvnLastChangeStartDate() != null) {
            _hashCode += getPvnLastChangeStartDate().hashCode();
        }
        if (getPvnLastChangeEndDate() != null) {
            _hashCode += getPvnLastChangeEndDate().hashCode();
        }
        if (getPasswordChangeRequired() != null) {
            _hashCode += getPasswordChangeRequired().hashCode();
        }
        if (getPasswordExpireStartDate() != null) {
            _hashCode += getPasswordExpireStartDate().hashCode();
        }
        if (getPasswordExpireEndDate() != null) {
            _hashCode += getPasswordExpireEndDate().hashCode();
        }
        if (getPasswordLastChangeStartDate() != null) {
            _hashCode += getPasswordLastChangeStartDate().hashCode();
        }
        if (getPasswordLastChangeEndDate() != null) {
            _hashCode += getPasswordLastChangeEndDate().hashCode();
        }
        if (getActivationExpireStartDate() != null) {
            _hashCode += getActivationExpireStartDate().hashCode();
        }
        if (getActivationExpireEndDate() != null) {
            _hashCode += getActivationExpireEndDate().hashCode();
        }
        if (getActivationExpireCode() != null) {
            _hashCode += getActivationExpireCode().hashCode();
        }
        if (getOtpAllowed() != null) {
            _hashCode += getOtpAllowed().hashCode();
        }
        if (getOtpDeliveryEnabled() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOtpDeliveryEnabled());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOtpDeliveryEnabled(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMinNumOTPs() != null) {
            _hashCode += getMinNumOTPs().hashCode();
        }
        if (getMaxNumOTPs() != null) {
            _hashCode += getMaxNumOTPs().hashCode();
        }
        if (getOTPExpiryStartDate() != null) {
            _hashCode += getOTPExpiryStartDate().hashCode();
        }
        if (getOTPExpiryEndDate() != null) {
            _hashCode += getOTPExpiryEndDate().hashCode();
        }
        if (getHasContactInfo() != null) {
            _hashCode += getHasContactInfo().hashCode();
        }
        if (getMinUsableContactInfo() != null) {
            _hashCode += getMinUsableContactInfo().hashCode();
        }
        if (getMaxUsableContactInfo() != null) {
            _hashCode += getMaxUsableContactInfo().hashCode();
        }
        if (getMinNumLocations() != null) {
            _hashCode += getMinNumLocations().hashCode();
        }
        if (getMaxNumLocations() != null) {
            _hashCode += getMaxNumLocations().hashCode();
        }
        if (getLocked() != null) {
            _hashCode += getLocked().hashCode();
        }
        if (getTokenVendorId() != null) {
            _hashCode += getTokenVendorId().hashCode();
        }
        if (getTokenSerialNumber() != null) {
            _hashCode += getTokenSerialNumber().hashCode();
        }
        if (getTokenLoadStartDate() != null) {
            _hashCode += getTokenLoadStartDate().hashCode();
        }
        if (getTokenLoadEndDate() != null) {
            _hashCode += getTokenLoadEndDate().hashCode();
        }
        if (getTokenLastUsedStartDate() != null) {
            _hashCode += getTokenLastUsedStartDate().hashCode();
        }
        if (getTokenLastUsedEndDate() != null) {
            _hashCode += getTokenLastUsedEndDate().hashCode();
        }
        if (getTokenStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokenStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokenStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAbsentTokenStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAbsentTokenStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAbsentTokenStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCertificateIssuerDN() != null) {
            _hashCode += getCertificateIssuerDN().hashCode();
        }
        if (getCertificateSubjectDN() != null) {
            _hashCode += getCertificateSubjectDN().hashCode();
        }
        if (getCertificateSerialNumber() != null) {
            _hashCode += getCertificateSerialNumber().hashCode();
        }
        if (getCertificateIssueStartDate() != null) {
            _hashCode += getCertificateIssueStartDate().hashCode();
        }
        if (getCertificateIssueEndDate() != null) {
            _hashCode += getCertificateIssueEndDate().hashCode();
        }
        if (getCertificateExpiryStartDate() != null) {
            _hashCode += getCertificateExpiryStartDate().hashCode();
        }
        if (getCertificateExpiryEndDate() != null) {
            _hashCode += getCertificateExpiryEndDate().hashCode();
        }
        if (getCertificateLastUsedStartDate() != null) {
            _hashCode += getCertificateLastUsedStartDate().hashCode();
        }
        if (getCertificateLastUsedEndDate() != null) {
            _hashCode += getCertificateLastUsedEndDate().hashCode();
        }
        if (getCertificateAssignStartDate() != null) {
            _hashCode += getCertificateAssignStartDate().hashCode();
        }
        if (getCertificateAssignEndDate() != null) {
            _hashCode += getCertificateAssignEndDate().hashCode();
        }
        if (getCertificateStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCertificateStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCertificateStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCertificateSelfSigned() != null) {
            _hashCode += getCertificateSelfSigned().hashCode();
        }
        if (getCertificateCANotRegistered() != null) {
            _hashCode += getCertificateCANotRegistered().hashCode();
        }
        if (getCertificateCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCertificateCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCertificateCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAbsentCertificateStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAbsentCertificateStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAbsentCertificateStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentialID() != null) {
            _hashCode += getSmartCredentialID().hashCode();
        }
        if (getSmartCredentialDefinitions() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialDefinitions());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialDefinitions(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentialSerialNumber() != null) {
            _hashCode += getSmartCredentialSerialNumber().hashCode();
        }
        if (getSmartCredentialCardUID() != null) {
            _hashCode += getSmartCredentialCardUID().hashCode();
        }
        if (getSmartCredentialCardType() != null) {
            _hashCode += getSmartCredentialCardType().hashCode();
        }
        if (getSmartCredentialStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAbsentSmartCredentialStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAbsentSmartCredentialStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAbsentSmartCredentialStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentialIssueStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialIssueStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialIssueStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAbsentSmartCredentialIssueStates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAbsentSmartCredentialIssueStates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAbsentSmartCredentialIssueStates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentialSealed() != null) {
            _hashCode += getSmartCredentialSealed().hashCode();
        }
        if (getSmartCredentialApproved() != null) {
            _hashCode += getSmartCredentialApproved().hashCode();
        }
        if (getSmartCredentialValid() != null) {
            _hashCode += getSmartCredentialValid().hashCode();
        }
        if (getSmartCredentialCreateStartDate() != null) {
            _hashCode += getSmartCredentialCreateStartDate().hashCode();
        }
        if (getSmartCredentialCreateEndDate() != null) {
            _hashCode += getSmartCredentialCreateEndDate().hashCode();
        }
        if (getSmartCredentialExpiryStartDate() != null) {
            _hashCode += getSmartCredentialExpiryStartDate().hashCode();
        }
        if (getSmartCredentialExpiryEndDate() != null) {
            _hashCode += getSmartCredentialExpiryEndDate().hashCode();
        }
        if (getSmartCredentialIssueStartDate() != null) {
            _hashCode += getSmartCredentialIssueStartDate().hashCode();
        }
        if (getSmartCredentialIssueEndDate() != null) {
            _hashCode += getSmartCredentialIssueEndDate().hashCode();
        }
        if (getSmartCredentialSupportsUnblock() != null) {
            _hashCode += getSmartCredentialSupportsUnblock().hashCode();
        }
        if (getSmartCredentialVariableFilters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialVariableFilters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialVariableFilters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDigitalIdDN() != null) {
            _hashCode += getDigitalIdDN().hashCode();
        }
        if (getDigitalIdManagedCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDigitalIdManagedCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDigitalIdManagedCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDigitalIdConfigs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDigitalIdConfigs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDigitalIdConfigs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDigitalIdClientType() != null) {
            _hashCode += getDigitalIdClientType().hashCode();
        }
        if (getDigitalIdCreateRecoverStartDate() != null) {
            _hashCode += getDigitalIdCreateRecoverStartDate().hashCode();
        }
        if (getDigitalIdCreateRecoverEndDate() != null) {
            _hashCode += getDigitalIdCreateRecoverEndDate().hashCode();
        }
        if (getDigitalIdExpiryStartDate() != null) {
            _hashCode += getDigitalIdExpiryStartDate().hashCode();
        }
        if (getDigitalIdExpiryEndDate() != null) {
            _hashCode += getDigitalIdExpiryEndDate().hashCode();
        }
        if (getMinNumQa() != null) {
            _hashCode += getMinNumQa().hashCode();
        }
        if (getMaxNumQa() != null) {
            _hashCode += getMaxNumQa().hashCode();
        }
        if (getMinNumMachineSecrets() != null) {
            _hashCode += getMinNumMachineSecrets().hashCode();
        }
        if (getMaxNumMachineSecrets() != null) {
            _hashCode += getMaxNumMachineSecrets().hashCode();
        }
        if (getHasAuthenticationSecrets() != null) {
            _hashCode += getHasAuthenticationSecrets().hashCode();
        }
        if (getHasRole() != null) {
            _hashCode += getHasRole().hashCode();
        }
        if (getRoles() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRoles());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRoles(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getLastAuthStartDate() != null) {
            _hashCode += getLastAuthStartDate().hashCode();
        }
        if (getLastAuthEndDate() != null) {
            _hashCode += getLastAuthEndDate().hashCode();
        }
        if (getLastAuthNever() != null) {
            _hashCode += getLastAuthNever().hashCode();
        }
        if (getLastAuthTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getLastAuthTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getLastAuthTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getLastFailedAuthStartDate() != null) {
            _hashCode += getLastFailedAuthStartDate().hashCode();
        }
        if (getLastFailedAuthEndDate() != null) {
            _hashCode += getLastFailedAuthEndDate().hashCode();
        }
        if (getLastFailedAuthNever() != null) {
            _hashCode += getLastFailedAuthNever().hashCode();
        }
        if (getLastFailedAuthTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getLastFailedAuthTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getLastFailedAuthTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDisabledInRepository() != null) {
            _hashCode += getDisabledInRepository().hashCode();
        }
        if (getFederationTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getFederationTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getFederationTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getFederationPartnerID() != null) {
            _hashCode += getFederationPartnerID().hashCode();
        }
        if (getFederationOriginator() != null) {
            _hashCode += getFederationOriginator().hashCode();
        }
        if (getInvalidUsers() != null) {
            _hashCode += getInvalidUsers().hashCode();
        }
        if (getMaxReturn() != null) {
            _hashCode += getMaxReturn().hashCode();
        }
        if (getNextUser() != null) {
            _hashCode += getNextUser().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserFilter.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserFilter"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("alias");
        elemField.setXmlName(new javax.xml.namespace.QName("", "alias"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("aliasOrUserid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "aliasOrUserid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("fullName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FullName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locale");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Locale"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("groups");
        elemField.setXmlName(new javax.xml.namespace.QName("", "groups"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "serialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "createStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "createEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expireStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expireStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expireEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expireEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("states");
        elemField.setXmlName(new javax.xml.namespace.QName("", "states"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("absentCardStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "absentCardStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minChallengeCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MinChallengeCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxChallengeCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxChallengeCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minLeastUsedCellUsageCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MinLeastUsedCellUsageCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxLeastUsedCellUsageCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxLeastUsedCellUsageCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardUsageThresholdIndicator");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardUsageThresholdIndicator"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CardUsageThresholdIndicator"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasPIN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasPIN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minNumTempPINUses");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minNumTempPINUses"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumTempPINUses");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumTempPINUses"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tempPINExpireStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tempPINExpireStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tempPINExpireEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tempPINExpireEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasPVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasPVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasPassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasPassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pvnChangeRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "pvnChangeRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pvnLastChangeStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "pvnLastChangeStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pvnLastChangeEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "pvnLastChangeEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordChangeRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordChangeRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordExpireStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordExpireStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordExpireEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordExpireEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordLastChangeStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordLastChangeStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordLastChangeEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordLastChangeEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationExpireStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationExpireStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationExpireEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationExpireEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationExpireCode");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationExpireCode"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ActivationCodeFilter"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("otpAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "otpAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("otpDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "otpDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "AttributeState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minNumOTPs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minNumOTPs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumOTPs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumOTPs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPExpiryStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPExpiryStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPExpiryEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPExpiryEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasContactInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasContactInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minUsableContactInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minUsableContactInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxUsableContactInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxUsableContactInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minNumLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minNumLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locked");
        elemField.setXmlName(new javax.xml.namespace.QName("", "locked"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenVendorId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenVendorId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenLoadStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenLoadStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenLoadEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenLoadEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenLastUsedStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenLastUsedStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenLastUsedEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenLastUsedEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("absentTokenStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "absentTokenStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateIssuerDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateIssuerDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateSubjectDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateSubjectDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateIssueStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateIssueStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateIssueEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateIssueEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateExpiryStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateExpiryStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateExpiryEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateExpiryEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateLastUsedStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateLastUsedStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateLastUsedEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateLastUsedEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAssignStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateAssignStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAssignEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateAssignEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CertificateState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateSelfSigned");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateSelfSigned"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateCANotRegistered");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateCANotRegistered"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("absentCertificateStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "absentCertificateStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CertificateState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialID");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialID"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialCardUID");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialCardUID"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialCardType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialCardType"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("absentSmartCredentialStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AbsentSmartCredentialStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialIssueStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialIssueStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialIssueState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("absentSmartCredentialIssueStates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AbsentSmartCredentialIssueStates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialIssueState"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialSealed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialSealed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialApproved");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialApproved"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialValid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialValid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialCreateStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialCreateStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialCreateEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialCreateEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialExpiryStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialExpiryStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialExpiryEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialExpiryEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialIssueStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialIssueStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialIssueEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialIssueEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialSupportsUnblock");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialSupportsUnblock"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialVariableFilters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialVariableFilters"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialVariableFilter"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdClientType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdClientType"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdCreateRecoverStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdCreateRecoverStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdCreateRecoverEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdCreateRecoverEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdExpiryStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdExpiryStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIdExpiryEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIdExpiryEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minNumQa");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minNumQa"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumQa");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumQa"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minNumMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minNumMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasAuthenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasAuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hasRole");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hasRole"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("roles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "roles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastAuthStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastAuthStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastAuthEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastAuthEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastAuthNever");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastAuthNever"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastAuthTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastAuthTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastFailedAuthStartDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastFailedAuthStartDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastFailedAuthEndDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastFailedAuthEndDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastFailedAuthNever");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastFailedAuthNever"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastFailedAuthTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lastFailedAuthTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("federationTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "federationTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("federationPartnerID");
        elemField.setXmlName(new javax.xml.namespace.QName("", "federationPartnerID"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("federationOriginator");
        elemField.setXmlName(new javax.xml.namespace.QName("", "federationOriginator"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("invalidUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("", "invalidUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxReturn");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxReturn"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("nextUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "nextUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
