/**
 * PINSpecInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines a temporary PIN specification policy.
 *                         These values control how temporary PINs are
 * used for
 *                         authentication and how new temporary PINs
 * are created.
 */
public class PINSpecInfo  implements java.io.Serializable {
    /* The name of the PIN specification policy. */
    private String name;

    /* The number of characters in each cell. */
    private int cellSize;

    /* The characters that can appear in a cell. */
    private String[] cellAlphabet;

    /* A list of characters that are replaced
     *                                 in a challenge response before it
     * is validated. */
    private CellReplacement[] cellReplacements;

    /* The number of cells in a temporary PIN. */
    private int challengeSize;

    /* The lifetime in hours of the temporary PIN. A value of 0
     *                                 indicates that the PIN has infinite
     * lifetime. */
    private long lifetime;

    /* The number of times the temporary PIN can be used for authentication.
     * A value of 0
     *                                 means the PIN can be used an infinite
     * number of times. */
    private int maxUses;

    /* If true, a user's temporary PIN is automatically deleted after
     * a
     *                                 successful grid or token authentication. */
    private boolean autoDelete;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments. */
    private String comment;

    public PINSpecInfo() {
    }

    public PINSpecInfo(
           String name,
           int cellSize,
           String[] cellAlphabet,
           CellReplacement[] cellReplacements,
           int challengeSize,
           long lifetime,
           int maxUses,
           boolean autoDelete,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.cellSize = cellSize;
           this.cellAlphabet = cellAlphabet;
           this.cellReplacements = cellReplacements;
           this.challengeSize = challengeSize;
           this.lifetime = lifetime;
           this.maxUses = maxUses;
           this.autoDelete = autoDelete;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this PINSpecInfo.
     * 
     * @return name   * The name of the PIN specification policy.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this PINSpecInfo.
     * 
     * @param name   * The name of the PIN specification policy.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the cellSize value for this PINSpecInfo.
     * 
     * @return cellSize   * The number of characters in each cell.
     */
    public int getCellSize() {
        return cellSize;
    }


    /**
     * Sets the cellSize value for this PINSpecInfo.
     * 
     * @param cellSize   * The number of characters in each cell.
     */
    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }


    /**
     * Gets the cellAlphabet value for this PINSpecInfo.
     * 
     * @return cellAlphabet   * The characters that can appear in a cell.
     */
    public String[] getCellAlphabet() {
        return cellAlphabet;
    }


    /**
     * Sets the cellAlphabet value for this PINSpecInfo.
     * 
     * @param cellAlphabet   * The characters that can appear in a cell.
     */
    public void setCellAlphabet(String[] cellAlphabet) {
        this.cellAlphabet = cellAlphabet;
    }


    /**
     * Gets the cellReplacements value for this PINSpecInfo.
     * 
     * @return cellReplacements   * A list of characters that are replaced
     *                                 in a challenge response before it
     * is validated.
     */
    public CellReplacement[] getCellReplacements() {
        return cellReplacements;
    }


    /**
     * Sets the cellReplacements value for this PINSpecInfo.
     * 
     * @param cellReplacements   * A list of characters that are replaced
     *                                 in a challenge response before it
     * is validated.
     */
    public void setCellReplacements(CellReplacement[] cellReplacements) {
        this.cellReplacements = cellReplacements;
    }


    /**
     * Gets the challengeSize value for this PINSpecInfo.
     * 
     * @return challengeSize   * The number of cells in a temporary PIN.
     */
    public int getChallengeSize() {
        return challengeSize;
    }


    /**
     * Sets the challengeSize value for this PINSpecInfo.
     * 
     * @param challengeSize   * The number of cells in a temporary PIN.
     */
    public void setChallengeSize(int challengeSize) {
        this.challengeSize = challengeSize;
    }


    /**
     * Gets the lifetime value for this PINSpecInfo.
     * 
     * @return lifetime   * The lifetime in hours of the temporary PIN. A value of 0
     *                                 indicates that the PIN has infinite
     * lifetime.
     */
    public long getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this PINSpecInfo.
     * 
     * @param lifetime   * The lifetime in hours of the temporary PIN. A value of 0
     *                                 indicates that the PIN has infinite
     * lifetime.
     */
    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the maxUses value for this PINSpecInfo.
     * 
     * @return maxUses   * The number of times the temporary PIN can be used for authentication.
     * A value of 0
     *                                 means the PIN can be used an infinite
     * number of times.
     */
    public int getMaxUses() {
        return maxUses;
    }


    /**
     * Sets the maxUses value for this PINSpecInfo.
     * 
     * @param maxUses   * The number of times the temporary PIN can be used for authentication.
     * A value of 0
     *                                 means the PIN can be used an infinite
     * number of times.
     */
    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }


    /**
     * Gets the autoDelete value for this PINSpecInfo.
     * 
     * @return autoDelete   * If true, a user's temporary PIN is automatically deleted after
     * a
     *                                 successful grid or token authentication.
     */
    public boolean isAutoDelete() {
        return autoDelete;
    }


    /**
     * Sets the autoDelete value for this PINSpecInfo.
     * 
     * @param autoDelete   * If true, a user's temporary PIN is automatically deleted after
     * a
     *                                 successful grid or token authentication.
     */
    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }


    /**
     * Gets the rolesGrantingAccess value for this PINSpecInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this PINSpecInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this PINSpecInfo.
     * 
     * @return comment   * Descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this PINSpecInfo.
     * 
     * @param comment   * Descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof PINSpecInfo)) return false;
        PINSpecInfo other = (PINSpecInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            this.cellSize == other.getCellSize() &&
            ((this.cellAlphabet==null && other.getCellAlphabet()==null) || 
             (this.cellAlphabet!=null &&
              java.util.Arrays.equals(this.cellAlphabet, other.getCellAlphabet()))) &&
            ((this.cellReplacements==null && other.getCellReplacements()==null) || 
             (this.cellReplacements!=null &&
              java.util.Arrays.equals(this.cellReplacements, other.getCellReplacements()))) &&
            this.challengeSize == other.getChallengeSize() &&
            this.lifetime == other.getLifetime() &&
            this.maxUses == other.getMaxUses() &&
            this.autoDelete == other.isAutoDelete() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        _hashCode += getCellSize();
        if (getCellAlphabet() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellAlphabet());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellAlphabet(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCellReplacements() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellReplacements());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellReplacements(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getChallengeSize();
        _hashCode += new Long(getLifetime()).hashCode();
        _hashCode += getMaxUses();
        _hashCode += (isAutoDelete() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PINSpecInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PINSpecInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellReplacements");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellReplacements"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxUses");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxUses"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoDelete");
        elemField.setXmlName(new javax.xml.namespace.QName("", "autoDelete"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
