package com.good.service.test.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Created by ibilyi on 16.11.2015.
 */
public class PropertiesLoader {
    private static final Log LOG = LogFactory.getLog(PropertiesLoader.class);
    private static class InstanceHolder {
        private static final PropertiesLoader LOADER = new PropertiesLoader();
    }
    private Properties properties;
    
    private PropertiesLoader() {
        try(InputStream is = getClass().getResourceAsStream("requestParams.properties")) {
            properties = new Properties();
            properties.load(is);
        } catch (FileNotFoundException e) {
            LOG.error("Exception during properties loading", e);
        } catch (IOException e) {
            LOG.error("Exception during properties loading" , e);
        }
    }
    
    public static PropertiesLoader getInstance() {
        return InstanceHolder.LOADER;
    }
    
    public String get(String property) {
        return (String)properties.get(property);
    }
}
