package com.good.filters.utils;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.good.domain.GenericData;
import com.good.domain.P12CertificateData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import java.io.StringWriter;

/**
 * Class is responsible for serialization of {@link P12CertificateData} into JSON format. Resulting String will be
 * written into ServletResponse with {@link HttpStatus#OK}.
 * 
 * @author Ivan Bilyi
 * 29.10.2015.
 */
public class DataSerializer {
    
    private static final Log LOG = LogFactory.getLog(DataSerializer.class);

    /**
     * serializer of java object into JSON
     */
    private ObjectWriter objectWriter;

    /**
     * Serialize data into String and write it into servlet response.
     * 
     * @param certificateData the data to write in the response
     * @param servletResponse the response
     */
    public void writeResponse(GenericData certificateData, HttpServletResponse servletResponse) {
        StringWriter sw = new StringWriter();
        servletResponse.setContentType(MediaType.APPLICATION_JSON);
        try {
            objectWriter.writeValue(sw, certificateData);
            if(LOG.isDebugEnabled()) {
                LOG.debug("Writing response : " + sw.toString());
            }
            servletResponse.getOutputStream().print(sw.toString());
        } catch (Exception ex) {
            LOG.error("Exception during serialization of response entity", ex);
        }
        servletResponse.setStatus(HttpStatus.OK.value());
    }

    /**
     * Set {@link ObjectWriter} which serialize {@link P12CertificateData} into JSON String  
     */
    @Autowired
    public void setObjectWriter(ObjectWriter objectWriter) {
        this.objectWriter = objectWriter;
    }
}
