package com.good.domain;

import com.good.adapters.CertificateServer;

/**
 * Deserialized data from request body. Data will be used for 
 * {@link com.good.service.CertificateServerService#renewCertificate(P12CertificateRequest)} and 
 * {@link com.good.service.CertificateServerService#revokeAllUserCertificates(P12CertificateRequest)} operations.
 * 
 * @author Stanislav Kyfenko
 *         11.08.2015
 */
public class P12CertificateRequest {
    /**
     * Public Key Infrastructure Certificate server type.
     * Will be used for renew and revokeAll processes
     * Note: <i>Currently only Entrust is supported</i>
     */
    private CertificateServer.CertificateServerType serverType;
    /**
     * Should be used for identification in Entrust service to revoke all created certificates.
     */
    private String userName;
    /**
     *  Should be used for identification in Entrust service to revoke all created certificates.
     */
    private String userEmail;
    /**
     * certificate Password. Will be used for renew process
     */
    private String certificatePassword;

    public CertificateServer.CertificateServerType getServerType() {
        return serverType;
    }

    public void setServerType(CertificateServer.CertificateServerType serverType) {
        this.serverType = serverType;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getCertificatePassword() {
        return certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    @Override
    public String toString() {
        return "P12CertificateRequest{" +
                "serverType=" + serverType +
                ", userName='" + userName + '\'' +
                ", userEmail='" + userEmail + '\'' +
                '}';
    }
}
