package com.good.domain;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class GenericData {
    /**
     * Status of operation(success/failure). Mandatory field.
     */
    protected StatusTypeEnum status;

    /**
     * information about failure. Should be presented only when {@link P12CertificateData#status} equals
     * {@link com.good.domain.StatusTypeEnum#FAILURE}. List of available errors can be checked in
     * {@link P12CertificateFailure}.
     */
    protected P12CertificateFailure failureInfo;

    /**
     * request ID should be same as field in {@link GDP12CertificateRequest#reqId}. Is needed for client to separate
     * different responses.
     */
    protected String reqId;

    public StatusTypeEnum getStatus() {
        return status;
    }

    public void setStatus(StatusTypeEnum status) {
        this.status = status;
    }

    public P12CertificateFailure getFailureInfo() {
        return this.failureInfo;
    }

    public String getReqId() {
        return reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public GenericData(P12CertificateFailure failureInfo) {
        this(failureInfo, null);
    }

    public GenericData(P12CertificateFailure failureInfo, String reqId) {
        this.status = StatusTypeEnum.FAILURE;
        this.failureInfo = failureInfo;
        this.reqId = reqId;
    }

    public GenericData() {
        this.status = StatusTypeEnum.SUCCESS;
    }

    @Override
    public String toString() {
        return "GenericData {" +
                "status=" + status +
                ", failureInfo=" + failureInfo +
                ", reqId=" + reqId +
                '}';
    }
}
