package com.good.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.good.filters.validators.PathModificationValidator;
import com.good.filters.utils.DataSerializer;
import com.good.filters.validators.*;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.*;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Configuration class for web context. Contains all beans that should be used both in Filters and Controllers. This is
 * needed because filters uses Controller classes to check that request is supported by application.
 *
 * @author Ivan Bilyi
 * 06.11.2015.
 */
@Configuration
@EnableWebMvc
@EnableScheduling
@ComponentScan(basePackages = {"com.good.adapters.entrust.impl", "com.good.adapters.factory", "com.good.service"})
@ImportResource("WEB-INF/spring/security.xml")
public class ServletContextConfig extends WebMvcConfigurerAdapter {

    @Bean
    public PathModificationValidator pathModificationValidator() {
        return new PathModificationValidator();
    }

    @Bean
    public RequestValidator requestValidator() {
        return new RequestValidator();
    }

    @Bean
    public ObjectMappingValidator objectMappingValidator() {
        return new ObjectMappingValidator();
    }

    @Bean
    public RequestDataValidator requestDataValidator() {
        return new RequestDataValidator();
    }

    @Bean
    public DataSerializer dataSerializer() {
        return new DataSerializer();
    }

    @Bean
    public ObjectWriter objectWriter() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerFor(com.good.domain.GenericData.class);
    }

    @Bean
    public ObjectReader objectReader() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readerFor(com.good.domain.GDP12CertificateRequest.class);
    }

    @Bean
    public ValidatorBean [] validationFilters() {
        return new ValidatorBean[]{
                pathModificationValidator()
                ,requestValidator()
                ,objectMappingValidator()
                ,requestDataValidator()};
    }

    @Bean
    public static PropertyPlaceholderConfigurer propertyPlaceholderConfigurer() {
        PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setLocation(new ClassPathResource("entrustMdmWs.properties"));
        propertyPlaceholderConfigurer.setIgnoreUnresolvablePlaceholders(true);
        return propertyPlaceholderConfigurer;
    }
}
