package com.good.adapters.factory;

import com.good.adapters.CertificateServer;
import com.good.exception.CertificateServerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Certificate server factory. Decides which certificate server is appropriate to use based on certificate server type
 *
 * @author Stanislav Kyfenko
 *         05.08.2015
 */
@Component
public class CertificateServerFactory {

    private static final Log LOG = LogFactory.getLog(CertificateServerFactory.class);

    @Autowired
    private Map<String, CertificateServer> servers;

    public CertificateServer getInstance(CertificateServer.CertificateServerType serverType) throws CertificateServerException {
        CertificateServer certificateServer = servers.get(serverType.name());
        if(certificateServer == null) {
            throw new CertificateServerException(serverType + " isn't defined in factory. " +
                    "If it's implementation of new certificate server adapter, add it to factory");
        }
        LOG.debug("Found CertificateServer of type : " + serverType.toValue());
        return certificateServer;
    }
}
