/**
 * UserTokenParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters passed when assigning, creating or
 *                         modifying a user token. All values can be
 * null
 *                         indicating that the default is used for assign
 * or the
 *                         value is not changed for modify.
 */
public class UserTokenParms  implements java.io.Serializable {
    /* The set of the token. If not
     *                                 specified when assigning or creating
     * a token,
     *                                 the default set (with an empty name)
     * is used.
     *                                 The maximum number of allowed sets
     * is
     *                                 controlled by policy. */
    private String tokenSet;

    /* The state of the token. If set when assigning
     *                                 or creating a token, this must be
     * one of PENDING.
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not
     *                                 specified when assigning or creating
     * a token, the
     *                                 token state is set to PENDING.
     *                                 The state is also subject to the restriction
     * that a user can have at most one token with
     *                                 a given set
     *                                 in either of the PENDING or HOLD_PENDING
     * states and at most one token with a given set
     *                                 in either of the CURRENT or HOLD states. */
    private State state;

    /* If specified as true, the token will be reset.
     *                                 Note that some token implementations
     * require
     *                                 that one or two token responses be
     * included
     *                                 with the token reset request.  These
     * responses
     *                                 are specified in the resetTokenResponse1
     * and
     *                                 resetTokenResponse2 attributes.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token. */
    private Boolean resetToken;

    /* To reset a token, some token implementations
     *                                 require one or two token responses.
     * If
     *                                 required, this attribute specifies
     * the first
     *                                 response.  If this attribute is specified,
     * the resetToken attribute is ignored.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token. */
    private String resetTokenResponse1;

    /* To reset a token, some token implementations
     *                                 require two token responses.  If specified,
     * this attribute specifies the second response.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token. */
    private String resetTokenResponse2;

    /* The activation password.  If specified, this
     *                                 value is only used for the userTokenActivate
     * operation. */
    private String activationPassword;

    /* The activation type to be used for this token.
     *                              Can be specified for the userTokenAssign
     * or
     *                              userTokenSet methods. */
    private TokenActivationType activationType;

    /* Token parameters that will be set for this
     *                                 token during the userTokenCreate,
     *                                 userTokenAssign or userTokenSet operation.
     * If specified during a userTokenSet operation
     *                                 and MergeTokenParameters is false
     * or null, then
     *                                 the token's existing parameters are
     * replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values. */
    private NameValue[] tokenParameters;

    /* If set to true, the TokenParameters list is
     *                                 merged with the existing values during
     * the
     *                                 userTokenSet operation. If not specified,
     * this
     *                                 value defaults to false. This parameter
     * only
     *                                 applies to the userTokenSet operation
     * and is
     *                                 ignored by other operations. */
    private Boolean mergeTokenParameters;

    /* A list of token parameter names to remove from
     *                                 the list of existing token parameters.
     * This
     *                                 argument only applies to the userTokenSet
     * operation.  This argument is ignored if
     *                                 RemoveAllTokenParameters is specifies
     * as true. */
    private String[] removeTokenParameters;

    /* If set to true, remove all token parameters. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveTokenParameters. If not specified
     * it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userTokenSet operation, and
     * is ignored
     *                                 by other operations. */
    private Boolean removeAllTokenParameters;

    /* The token comment. If not set when assigning
     *                                 a token to a user, the existing token
     * comments
     *                                 are preserved. */
    private String comment;

    public UserTokenParms() {
    }

    public UserTokenParms(
           String tokenSet,
           State state,
           Boolean resetToken,
           String resetTokenResponse1,
           String resetTokenResponse2,
           String activationPassword,
           TokenActivationType activationType,
           NameValue[] tokenParameters,
           Boolean mergeTokenParameters,
           String[] removeTokenParameters,
           Boolean removeAllTokenParameters,
           String comment) {
           this.tokenSet = tokenSet;
           this.state = state;
           this.resetToken = resetToken;
           this.resetTokenResponse1 = resetTokenResponse1;
           this.resetTokenResponse2 = resetTokenResponse2;
           this.activationPassword = activationPassword;
           this.activationType = activationType;
           this.tokenParameters = tokenParameters;
           this.mergeTokenParameters = mergeTokenParameters;
           this.removeTokenParameters = removeTokenParameters;
           this.removeAllTokenParameters = removeAllTokenParameters;
           this.comment = comment;
    }


    /**
     * Gets the tokenSet value for this UserTokenParms.
     * 
     * @return tokenSet   * The set of the token. If not
     *                                 specified when assigning or creating
     * a token,
     *                                 the default set (with an empty name)
     * is used.
     *                                 The maximum number of allowed sets
     * is
     *                                 controlled by policy.
     */
    public String getTokenSet() {
        return tokenSet;
    }


    /**
     * Sets the tokenSet value for this UserTokenParms.
     * 
     * @param tokenSet   * The set of the token. If not
     *                                 specified when assigning or creating
     * a token,
     *                                 the default set (with an empty name)
     * is used.
     *                                 The maximum number of allowed sets
     * is
     *                                 controlled by policy.
     */
    public void setTokenSet(String tokenSet) {
        this.tokenSet = tokenSet;
    }


    /**
     * Gets the state value for this UserTokenParms.
     * 
     * @return state   * The state of the token. If set when assigning
     *                                 or creating a token, this must be
     * one of PENDING.
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not
     *                                 specified when assigning or creating
     * a token, the
     *                                 token state is set to PENDING.
     *                                 The state is also subject to the restriction
     * that a user can have at most one token with
     *                                 a given set
     *                                 in either of the PENDING or HOLD_PENDING
     * states and at most one token with a given set
     *                                 in either of the CURRENT or HOLD states.
     */
    public State getState() {
        return state;
    }


    /**
     * Sets the state value for this UserTokenParms.
     * 
     * @param state   * The state of the token. If set when assigning
     *                                 or creating a token, this must be
     * one of PENDING.
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not
     *                                 specified when assigning or creating
     * a token, the
     *                                 token state is set to PENDING.
     *                                 The state is also subject to the restriction
     * that a user can have at most one token with
     *                                 a given set
     *                                 in either of the PENDING or HOLD_PENDING
     * states and at most one token with a given set
     *                                 in either of the CURRENT or HOLD states.
     */
    public void setState(State state) {
        this.state = state;
    }


    /**
     * Gets the resetToken value for this UserTokenParms.
     * 
     * @return resetToken   * If specified as true, the token will be reset.
     *                                 Note that some token implementations
     * require
     *                                 that one or two token responses be
     * included
     *                                 with the token reset request.  These
     * responses
     *                                 are specified in the resetTokenResponse1
     * and
     *                                 resetTokenResponse2 attributes.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public Boolean getResetToken() {
        return resetToken;
    }


    /**
     * Sets the resetToken value for this UserTokenParms.
     * 
     * @param resetToken   * If specified as true, the token will be reset.
     *                                 Note that some token implementations
     * require
     *                                 that one or two token responses be
     * included
     *                                 with the token reset request.  These
     * responses
     *                                 are specified in the resetTokenResponse1
     * and
     *                                 resetTokenResponse2 attributes.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public void setResetToken(Boolean resetToken) {
        this.resetToken = resetToken;
    }


    /**
     * Gets the resetTokenResponse1 value for this UserTokenParms.
     * 
     * @return resetTokenResponse1   * To reset a token, some token implementations
     *                                 require one or two token responses.
     * If
     *                                 required, this attribute specifies
     * the first
     *                                 response.  If this attribute is specified,
     * the resetToken attribute is ignored.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public String getResetTokenResponse1() {
        return resetTokenResponse1;
    }


    /**
     * Sets the resetTokenResponse1 value for this UserTokenParms.
     * 
     * @param resetTokenResponse1   * To reset a token, some token implementations
     *                                 require one or two token responses.
     * If
     *                                 required, this attribute specifies
     * the first
     *                                 response.  If this attribute is specified,
     * the resetToken attribute is ignored.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public void setResetTokenResponse1(String resetTokenResponse1) {
        this.resetTokenResponse1 = resetTokenResponse1;
    }


    /**
     * Gets the resetTokenResponse2 value for this UserTokenParms.
     * 
     * @return resetTokenResponse2   * To reset a token, some token implementations
     *                                 require two token responses.  If specified,
     * this attribute specifies the second response.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public String getResetTokenResponse2() {
        return resetTokenResponse2;
    }


    /**
     * Sets the resetTokenResponse2 value for this UserTokenParms.
     * 
     * @param resetTokenResponse2   * To reset a token, some token implementations
     *                                 require two token responses.  If specified,
     * this attribute specifies the second response.
     *                                 This value is ignored when assigning
     * or
     *                                 creating a token.
     */
    public void setResetTokenResponse2(String resetTokenResponse2) {
        this.resetTokenResponse2 = resetTokenResponse2;
    }


    /**
     * Gets the activationPassword value for this UserTokenParms.
     * 
     * @return activationPassword   * The activation password.  If specified, this
     *                                 value is only used for the userTokenActivate
     * operation.
     */
    public String getActivationPassword() {
        return activationPassword;
    }


    /**
     * Sets the activationPassword value for this UserTokenParms.
     * 
     * @param activationPassword   * The activation password.  If specified, this
     *                                 value is only used for the userTokenActivate
     * operation.
     */
    public void setActivationPassword(String activationPassword) {
        this.activationPassword = activationPassword;
    }


    /**
     * Gets the activationType value for this UserTokenParms.
     * 
     * @return activationType   * The activation type to be used for this token.
     *                              Can be specified for the userTokenAssign
     * or
     *                              userTokenSet methods.
     */
    public TokenActivationType getActivationType() {
        return activationType;
    }


    /**
     * Sets the activationType value for this UserTokenParms.
     * 
     * @param activationType   * The activation type to be used for this token.
     *                              Can be specified for the userTokenAssign
     * or
     *                              userTokenSet methods.
     */
    public void setActivationType(TokenActivationType activationType) {
        this.activationType = activationType;
    }


    /**
     * Gets the tokenParameters value for this UserTokenParms.
     * 
     * @return tokenParameters   * Token parameters that will be set for this
     *                                 token during the userTokenCreate,
     *                                 userTokenAssign or userTokenSet operation.
     * If specified during a userTokenSet operation
     *                                 and MergeTokenParameters is false
     * or null, then
     *                                 the token's existing parameters are
     * replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values.
     */
    public NameValue[] getTokenParameters() {
        return tokenParameters;
    }


    /**
     * Sets the tokenParameters value for this UserTokenParms.
     * 
     * @param tokenParameters   * Token parameters that will be set for this
     *                                 token during the userTokenCreate,
     *                                 userTokenAssign or userTokenSet operation.
     * If specified during a userTokenSet operation
     *                                 and MergeTokenParameters is false
     * or null, then
     *                                 the token's existing parameters are
     * replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values.
     */
    public void setTokenParameters(NameValue[] tokenParameters) {
        this.tokenParameters = tokenParameters;
    }


    /**
     * Gets the mergeTokenParameters value for this UserTokenParms.
     * 
     * @return mergeTokenParameters   * If set to true, the TokenParameters list is
     *                                 merged with the existing values during
     * the
     *                                 userTokenSet operation. If not specified,
     * this
     *                                 value defaults to false. This parameter
     * only
     *                                 applies to the userTokenSet operation
     * and is
     *                                 ignored by other operations.
     */
    public Boolean getMergeTokenParameters() {
        return mergeTokenParameters;
    }


    /**
     * Sets the mergeTokenParameters value for this UserTokenParms.
     * 
     * @param mergeTokenParameters   * If set to true, the TokenParameters list is
     *                                 merged with the existing values during
     * the
     *                                 userTokenSet operation. If not specified,
     * this
     *                                 value defaults to false. This parameter
     * only
     *                                 applies to the userTokenSet operation
     * and is
     *                                 ignored by other operations.
     */
    public void setMergeTokenParameters(Boolean mergeTokenParameters) {
        this.mergeTokenParameters = mergeTokenParameters;
    }


    /**
     * Gets the removeTokenParameters value for this UserTokenParms.
     * 
     * @return removeTokenParameters   * A list of token parameter names to remove from
     *                                 the list of existing token parameters.
     * This
     *                                 argument only applies to the userTokenSet
     * operation.  This argument is ignored if
     *                                 RemoveAllTokenParameters is specifies
     * as true.
     */
    public String[] getRemoveTokenParameters() {
        return removeTokenParameters;
    }


    /**
     * Sets the removeTokenParameters value for this UserTokenParms.
     * 
     * @param removeTokenParameters   * A list of token parameter names to remove from
     *                                 the list of existing token parameters.
     * This
     *                                 argument only applies to the userTokenSet
     * operation.  This argument is ignored if
     *                                 RemoveAllTokenParameters is specifies
     * as true.
     */
    public void setRemoveTokenParameters(String[] removeTokenParameters) {
        this.removeTokenParameters = removeTokenParameters;
    }


    /**
     * Gets the removeAllTokenParameters value for this UserTokenParms.
     * 
     * @return removeAllTokenParameters   * If set to true, remove all token parameters. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveTokenParameters. If not specified
     * it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userTokenSet operation, and
     * is ignored
     *                                 by other operations.
     */
    public Boolean getRemoveAllTokenParameters() {
        return removeAllTokenParameters;
    }


    /**
     * Sets the removeAllTokenParameters value for this UserTokenParms.
     * 
     * @param removeAllTokenParameters   * If set to true, remove all token parameters. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveTokenParameters. If not specified
     * it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userTokenSet operation, and
     * is ignored
     *                                 by other operations.
     */
    public void setRemoveAllTokenParameters(Boolean removeAllTokenParameters) {
        this.removeAllTokenParameters = removeAllTokenParameters;
    }


    /**
     * Gets the comment value for this UserTokenParms.
     * 
     * @return comment   * The token comment. If not set when assigning
     *                                 a token to a user, the existing token
     * comments
     *                                 are preserved.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserTokenParms.
     * 
     * @param comment   * The token comment. If not set when assigning
     *                                 a token to a user, the existing token
     * comments
     *                                 are preserved.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserTokenParms)) return false;
        UserTokenParms other = (UserTokenParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.tokenSet==null && other.getTokenSet()==null) || 
             (this.tokenSet!=null &&
              this.tokenSet.equals(other.getTokenSet()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.resetToken==null && other.getResetToken()==null) || 
             (this.resetToken!=null &&
              this.resetToken.equals(other.getResetToken()))) &&
            ((this.resetTokenResponse1==null && other.getResetTokenResponse1()==null) || 
             (this.resetTokenResponse1!=null &&
              this.resetTokenResponse1.equals(other.getResetTokenResponse1()))) &&
            ((this.resetTokenResponse2==null && other.getResetTokenResponse2()==null) || 
             (this.resetTokenResponse2!=null &&
              this.resetTokenResponse2.equals(other.getResetTokenResponse2()))) &&
            ((this.activationPassword==null && other.getActivationPassword()==null) || 
             (this.activationPassword!=null &&
              this.activationPassword.equals(other.getActivationPassword()))) &&
            ((this.activationType==null && other.getActivationType()==null) || 
             (this.activationType!=null &&
              this.activationType.equals(other.getActivationType()))) &&
            ((this.tokenParameters==null && other.getTokenParameters()==null) || 
             (this.tokenParameters!=null &&
              java.util.Arrays.equals(this.tokenParameters, other.getTokenParameters()))) &&
            ((this.mergeTokenParameters==null && other.getMergeTokenParameters()==null) || 
             (this.mergeTokenParameters!=null &&
              this.mergeTokenParameters.equals(other.getMergeTokenParameters()))) &&
            ((this.removeTokenParameters==null && other.getRemoveTokenParameters()==null) || 
             (this.removeTokenParameters!=null &&
              java.util.Arrays.equals(this.removeTokenParameters, other.getRemoveTokenParameters()))) &&
            ((this.removeAllTokenParameters==null && other.getRemoveAllTokenParameters()==null) || 
             (this.removeAllTokenParameters!=null &&
              this.removeAllTokenParameters.equals(other.getRemoveAllTokenParameters()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getTokenSet() != null) {
            _hashCode += getTokenSet().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getResetToken() != null) {
            _hashCode += getResetToken().hashCode();
        }
        if (getResetTokenResponse1() != null) {
            _hashCode += getResetTokenResponse1().hashCode();
        }
        if (getResetTokenResponse2() != null) {
            _hashCode += getResetTokenResponse2().hashCode();
        }
        if (getActivationPassword() != null) {
            _hashCode += getActivationPassword().hashCode();
        }
        if (getActivationType() != null) {
            _hashCode += getActivationType().hashCode();
        }
        if (getTokenParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokenParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokenParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeTokenParameters() != null) {
            _hashCode += getMergeTokenParameters().hashCode();
        }
        if (getRemoveTokenParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveTokenParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveTokenParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllTokenParameters() != null) {
            _hashCode += getRemoveAllTokenParameters().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserTokenParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserTokenParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenSet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenSet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "State"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("resetToken");
        elemField.setXmlName(new javax.xml.namespace.QName("", "resetToken"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("resetTokenResponse1");
        elemField.setXmlName(new javax.xml.namespace.QName("", "resetTokenResponse1"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("resetTokenResponse2");
        elemField.setXmlName(new javax.xml.namespace.QName("", "resetTokenResponse2"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationPassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationPassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TokenActivationType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TokenParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeTokenParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeTokenParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeTokenParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveTokenParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllTokenParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllTokenParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
