/**
 * UserSmartCredentialParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters passed when creating or
 *                         modifying a Smart Credential.
 */
public class UserSmartCredentialParms  implements java.io.Serializable {
    /* If specified for the userSmartCredentialCreate
     *                                 operation, this value is used for
     * the
     *                                 Id of the new Smart Credential instead
     * of
     *                                 a randomly generated value.  The Id
     * must have
     *                                 the same prefix as required by policy
     * and
     *                                 must not be longer than 255 characters. */
    private String id;

    /* The Definition Id of the Smart Credential.  This
     *                                 value is required for userSmartCredentialCreate
     * operation.  This argument is ignored if
     *                                 specified for other operations. */
    private String definitionId;

    /* If specified for the userSmartCredentialCreate
     *                                 operation this value specifies the
     * id of
     *                                 a user smart credential whose enrollment
     * values
     *                                 will be cloned into the new smart
     * credential.
     *                                 The smart credential to be cloned
     * must have
     *                                 the same userid and definition as
     * the new
     *                                 smart credential.  This argument is
     * ignored
     *                                 if specified for other operations. */
    private String cloneId;

    /* The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed.  If specified, the serial
     * number must
     *                                 correspond to an existing unassigned
     * smart
     *                                 credential which will be assigned
     * to the
     *                                 user smart credential. */
    private String serialNumber;

    /* The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded.  If specified, the user smart
     * credential must be assigned a serial number. */
    private String cardUID;

    /* If set to true, the specified Serial Number
     *                                 will be treated as a mobile serial
     * number.
     *                                 Instead of assigning an unassigned
     * smart
     *                                 credential with the associated card
     * management
     *                                 keys, a new entry with randomly generated
     * card management keys will be set.
     *                                 If not set, this attribute defaults
     * to false. */
    private Boolean mobileSerialNumber;

    /* The state of the user smart credential.
     *                                 If not specified during the create
     * operation,
     *                                 the state will default to UNASSIGNED
     * if no
     *                                 serial number is specified or to the
     * state of the unassigned smart credential if
     *                                 a serial number is specified. */
    private SmartCredentialState state;

    /* This argument is used by the print module
     *                                 to set the state of the current
     *                                 print/encode/proximity operation. */
    private com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState;

    /* This argument is used by the print module.
     *                                 If specified as true, the print date
     * of
     *                                 this smart credential is updated to
     * the
     *                                 current date. */
    private Boolean issueDate;

    /* This argument is used by the print module
     *                                 to set information about the current
     * print/encode/proximity operation. */
    private String issueInfo;

    /* A flag indicating if this Smart Credential is
     *                                 valid or not.  The valid state of
     * a smart
     *                                 credential will be automatically set
     * to true
     *                                 or false depending on whether all
     * of the
     *                                 required enrollment values are specified
     * and valid.  This flag can be used to explicitly
     *                                 set the valid state.  For example,
     * if during
     *                                 the approval process an administrator
     * decides
     *                                 that more changes are required to
     * the
     *                                 enrollment values they can set the
     * valid state
     *                                 to false. */
    private Boolean valid;

    /* A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until 
     *                                 approved. */
    private Boolean approved;

    /* A flag indicating if this Smart Credential is
     *                                 sealed or not.  A sealed Smart Credential
     * can
     *                                 not be modified or printed.  Normally
     * a
     *                                 Smart Credential will be sealed after
     * printing
     *                                 is complete. */
    private Boolean sealed;

    /* Enrollment values that will be set for this
     *                                 Smart Credential during the
     *                                 userSmartCredentialCreate,
     *                                 or userSmartCredentialSet operation.
     * If specified during a userSmartCredentialSet
     *                                 operation and MergeEnrollmentParameters
     * is
     *                                 false, the Smart Credential's existing
     * parameters are replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values. */
    private NameValue[] enrollmentValues;

    /* If set to true, the EnrollmentValues list
     *                                 contains raw values rather than encoded
     * values.
     *                                 If not specified, this value defaults
     * to false. */
    private Boolean rawEnrollmentValues;

    /* If set to true, the EnrollmentValues list is
     *                                 merged with the existing values during
     * the
     *                                 userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * true. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations. */
    private Boolean mergeEnrollmentValues;

    /* A list of enrollment value names to remove from
     *                                 the list of existing enrollment values.
     * This
     *                                 argument only applies to the
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllEnrollmentValues is specifies
     * as true. */
    private String[] removeEnrollmentValues;

    /* If set to true, remove all Smart Credential
     *                                 enrollment values. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveEnrollmentParameters. If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userSmartCredentialSet operation,
     * and is
     *                                 ignored by other operations. */
    private Boolean removeAllEnrollmentValues;

    /* If specified, new values are generated for
     *                                 all specified variables.  If a specified
     * variable does not exist or does not support
     *                                 generation an error is returned. 
     * This argument
     *                                 only applies to the userSmartCredentialSet
     * operation and is ignored if specified for the
     *                                 userSmartCredentialCreate operation. */
    private String[] generateEnrollmentValues;

    /* The Smart Credential friendly name. */
    private String friendlyName;

    /* Smart Credential parameters that will be set
     *                                 for this smart credential during the
     * userSmartCredentialCreate or
     *                                 userSmartCredentialSet operation.
     * If specified
     *                                 during a userSmartCredentialSet operation
     * and
     *                                 MergeSmartCredentialParameters is
     * false or
     *                                 null, then the smart credential's
     * existing
     *                                 parameters are replaced by this list.
     * Otherwise, these values are
     *                                 merged with the existing values.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument. */
    private NameValue[] smartCredentialParameters;

    /* If set to true, the SmartCredentialParameters
     *                                 list is merged with the existing values
     * during
     *                                 the userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * false. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument. */
    private Boolean mergeSmartCredentialParameters;

    /* A list of smart credential parameter names to
     *                                 remove from the list of existing smart
     * credential parameters.  This
     *                                 argument only applies to the 
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllSmartCredentialParameters
     * is
     *                                 specified as true.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument. */
    private String[] removeSmartCredentialParameters;

    /* If set to true, remove all smart credential
     *                                 parameters. If specified, this value
     * takes
     *                                 precedence over
     *                                 RemoveSmartCredentialParameters. If
     * not
     *                                 specified it defaults to false. This
     * parameter
     *                                 only applies to the userSmartCredentialSet
     * operation, and is ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument. */
    private Boolean removeAllSmartCredentialParameters;

    /* The Smart Credential comment. */
    private String comment;

    public UserSmartCredentialParms() {
    }

    public UserSmartCredentialParms(
           String id,
           String definitionId,
           String cloneId,
           String serialNumber,
           String cardUID,
           Boolean mobileSerialNumber,
           SmartCredentialState state,
           com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState,
           Boolean issueDate,
           String issueInfo,
           Boolean valid,
           Boolean approved,
           Boolean sealed,
           NameValue[] enrollmentValues,
           Boolean rawEnrollmentValues,
           Boolean mergeEnrollmentValues,
           String[] removeEnrollmentValues,
           Boolean removeAllEnrollmentValues,
           String[] generateEnrollmentValues,
           String friendlyName,
           NameValue[] smartCredentialParameters,
           Boolean mergeSmartCredentialParameters,
           String[] removeSmartCredentialParameters,
           Boolean removeAllSmartCredentialParameters,
           String comment) {
           this.id = id;
           this.definitionId = definitionId;
           this.cloneId = cloneId;
           this.serialNumber = serialNumber;
           this.cardUID = cardUID;
           this.mobileSerialNumber = mobileSerialNumber;
           this.state = state;
           this.issueState = issueState;
           this.issueDate = issueDate;
           this.issueInfo = issueInfo;
           this.valid = valid;
           this.approved = approved;
           this.sealed = sealed;
           this.enrollmentValues = enrollmentValues;
           this.rawEnrollmentValues = rawEnrollmentValues;
           this.mergeEnrollmentValues = mergeEnrollmentValues;
           this.removeEnrollmentValues = removeEnrollmentValues;
           this.removeAllEnrollmentValues = removeAllEnrollmentValues;
           this.generateEnrollmentValues = generateEnrollmentValues;
           this.friendlyName = friendlyName;
           this.smartCredentialParameters = smartCredentialParameters;
           this.mergeSmartCredentialParameters = mergeSmartCredentialParameters;
           this.removeSmartCredentialParameters = removeSmartCredentialParameters;
           this.removeAllSmartCredentialParameters = removeAllSmartCredentialParameters;
           this.comment = comment;
    }


    /**
     * Gets the id value for this UserSmartCredentialParms.
     * 
     * @return id   * If specified for the userSmartCredentialCreate
     *                                 operation, this value is used for
     * the
     *                                 Id of the new Smart Credential instead
     * of
     *                                 a randomly generated value.  The Id
     * must have
     *                                 the same prefix as required by policy
     * and
     *                                 must not be longer than 255 characters.
     */
    public String getId() {
        return id;
    }


    /**
     * Sets the id value for this UserSmartCredentialParms.
     * 
     * @param id   * If specified for the userSmartCredentialCreate
     *                                 operation, this value is used for
     * the
     *                                 Id of the new Smart Credential instead
     * of
     *                                 a randomly generated value.  The Id
     * must have
     *                                 the same prefix as required by policy
     * and
     *                                 must not be longer than 255 characters.
     */
    public void setId(String id) {
        this.id = id;
    }


    /**
     * Gets the definitionId value for this UserSmartCredentialParms.
     * 
     * @return definitionId   * The Definition Id of the Smart Credential.  This
     *                                 value is required for userSmartCredentialCreate
     * operation.  This argument is ignored if
     *                                 specified for other operations.
     */
    public String getDefinitionId() {
        return definitionId;
    }


    /**
     * Sets the definitionId value for this UserSmartCredentialParms.
     * 
     * @param definitionId   * The Definition Id of the Smart Credential.  This
     *                                 value is required for userSmartCredentialCreate
     * operation.  This argument is ignored if
     *                                 specified for other operations.
     */
    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }


    /**
     * Gets the cloneId value for this UserSmartCredentialParms.
     * 
     * @return cloneId   * If specified for the userSmartCredentialCreate
     *                                 operation this value specifies the
     * id of
     *                                 a user smart credential whose enrollment
     * values
     *                                 will be cloned into the new smart
     * credential.
     *                                 The smart credential to be cloned
     * must have
     *                                 the same userid and definition as
     * the new
     *                                 smart credential.  This argument is
     * ignored
     *                                 if specified for other operations.
     */
    public String getCloneId() {
        return cloneId;
    }


    /**
     * Sets the cloneId value for this UserSmartCredentialParms.
     * 
     * @param cloneId   * If specified for the userSmartCredentialCreate
     *                                 operation this value specifies the
     * id of
     *                                 a user smart credential whose enrollment
     * values
     *                                 will be cloned into the new smart
     * credential.
     *                                 The smart credential to be cloned
     * must have
     *                                 the same userid and definition as
     * the new
     *                                 smart credential.  This argument is
     * ignored
     *                                 if specified for other operations.
     */
    public void setCloneId(String cloneId) {
        this.cloneId = cloneId;
    }


    /**
     * Gets the serialNumber value for this UserSmartCredentialParms.
     * 
     * @return serialNumber   * The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed.  If specified, the serial
     * number must
     *                                 correspond to an existing unassigned
     * smart
     *                                 credential which will be assigned
     * to the
     *                                 user smart credential.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this UserSmartCredentialParms.
     * 
     * @param serialNumber   * The optional serial number of the
     *                                 card onto which this Smart Credential
     * was
     *                                 printed.  If specified, the serial
     * number must
     *                                 correspond to an existing unassigned
     * smart
     *                                 credential which will be assigned
     * to the
     *                                 user smart credential.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the cardUID value for this UserSmartCredentialParms.
     * 
     * @return cardUID   * The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded.  If specified, the user smart
     * credential must be assigned a serial number.
     */
    public String getCardUID() {
        return cardUID;
    }


    /**
     * Sets the cardUID value for this UserSmartCredentialParms.
     * 
     * @param cardUID   * The optional UID of the
     *                                 card onto which this Smart Credential
     * was
     *                                 encoded.  If specified, the user smart
     * credential must be assigned a serial number.
     */
    public void setCardUID(String cardUID) {
        this.cardUID = cardUID;
    }


    /**
     * Gets the mobileSerialNumber value for this UserSmartCredentialParms.
     * 
     * @return mobileSerialNumber   * If set to true, the specified Serial Number
     *                                 will be treated as a mobile serial
     * number.
     *                                 Instead of assigning an unassigned
     * smart
     *                                 credential with the associated card
     * management
     *                                 keys, a new entry with randomly generated
     * card management keys will be set.
     *                                 If not set, this attribute defaults
     * to false.
     */
    public Boolean getMobileSerialNumber() {
        return mobileSerialNumber;
    }


    /**
     * Sets the mobileSerialNumber value for this UserSmartCredentialParms.
     * 
     * @param mobileSerialNumber   * If set to true, the specified Serial Number
     *                                 will be treated as a mobile serial
     * number.
     *                                 Instead of assigning an unassigned
     * smart
     *                                 credential with the associated card
     * management
     *                                 keys, a new entry with randomly generated
     * card management keys will be set.
     *                                 If not set, this attribute defaults
     * to false.
     */
    public void setMobileSerialNumber(Boolean mobileSerialNumber) {
        this.mobileSerialNumber = mobileSerialNumber;
    }


    /**
     * Gets the state value for this UserSmartCredentialParms.
     * 
     * @return state   * The state of the user smart credential.
     *                                 If not specified during the create
     * operation,
     *                                 the state will default to UNASSIGNED
     * if no
     *                                 serial number is specified or to the
     * state of the unassigned smart credential if
     *                                 a serial number is specified.
     */
    public SmartCredentialState getState() {
        return state;
    }


    /**
     * Sets the state value for this UserSmartCredentialParms.
     * 
     * @param state   * The state of the user smart credential.
     *                                 If not specified during the create
     * operation,
     *                                 the state will default to UNASSIGNED
     * if no
     *                                 serial number is specified or to the
     * state of the unassigned smart credential if
     *                                 a serial number is specified.
     */
    public void setState(SmartCredentialState state) {
        this.state = state;
    }


    /**
     * Gets the issueState value for this UserSmartCredentialParms.
     * 
     * @return issueState   * This argument is used by the print module
     *                                 to set the state of the current
     *                                 print/encode/proximity operation.
     */
    public com.good.adapters.entrust.stubs.SmartCredentialIssueState getIssueState() {
        return issueState;
    }


    /**
     * Sets the issueState value for this UserSmartCredentialParms.
     * 
     * @param issueState   * This argument is used by the print module
     *                                 to set the state of the current
     *                                 print/encode/proximity operation.
     */
    public void setIssueState(com.good.adapters.entrust.stubs.SmartCredentialIssueState issueState) {
        this.issueState = issueState;
    }


    /**
     * Gets the issueDate value for this UserSmartCredentialParms.
     * 
     * @return issueDate   * This argument is used by the print module.
     *                                 If specified as true, the print date
     * of
     *                                 this smart credential is updated to
     * the
     *                                 current date.
     */
    public Boolean getIssueDate() {
        return issueDate;
    }


    /**
     * Sets the issueDate value for this UserSmartCredentialParms.
     * 
     * @param issueDate   * This argument is used by the print module.
     *                                 If specified as true, the print date
     * of
     *                                 this smart credential is updated to
     * the
     *                                 current date.
     */
    public void setIssueDate(Boolean issueDate) {
        this.issueDate = issueDate;
    }


    /**
     * Gets the issueInfo value for this UserSmartCredentialParms.
     * 
     * @return issueInfo   * This argument is used by the print module
     *                                 to set information about the current
     * print/encode/proximity operation.
     */
    public String getIssueInfo() {
        return issueInfo;
    }


    /**
     * Sets the issueInfo value for this UserSmartCredentialParms.
     * 
     * @param issueInfo   * This argument is used by the print module
     *                                 to set information about the current
     * print/encode/proximity operation.
     */
    public void setIssueInfo(String issueInfo) {
        this.issueInfo = issueInfo;
    }


    /**
     * Gets the valid value for this UserSmartCredentialParms.
     * 
     * @return valid   * A flag indicating if this Smart Credential is
     *                                 valid or not.  The valid state of
     * a smart
     *                                 credential will be automatically set
     * to true
     *                                 or false depending on whether all
     * of the
     *                                 required enrollment values are specified
     * and valid.  This flag can be used to explicitly
     *                                 set the valid state.  For example,
     * if during
     *                                 the approval process an administrator
     * decides
     *                                 that more changes are required to
     * the
     *                                 enrollment values they can set the
     * valid state
     *                                 to false.
     */
    public Boolean getValid() {
        return valid;
    }


    /**
     * Sets the valid value for this UserSmartCredentialParms.
     * 
     * @param valid   * A flag indicating if this Smart Credential is
     *                                 valid or not.  The valid state of
     * a smart
     *                                 credential will be automatically set
     * to true
     *                                 or false depending on whether all
     * of the
     *                                 required enrollment values are specified
     * and valid.  This flag can be used to explicitly
     *                                 set the valid state.  For example,
     * if during
     *                                 the approval process an administrator
     * decides
     *                                 that more changes are required to
     * the
     *                                 enrollment values they can set the
     * valid state
     *                                 to false.
     */
    public void setValid(Boolean valid) {
        this.valid = valid;
    }


    /**
     * Gets the approved value for this UserSmartCredentialParms.
     * 
     * @return approved   * A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until 
     *                                 approved.
     */
    public Boolean getApproved() {
        return approved;
    }


    /**
     * Sets the approved value for this UserSmartCredentialParms.
     * 
     * @param approved   * A flag indicating if this Smart Credential has
     *                                 been approved or not.  If approval
     * is required
     *                                 for the Smart Credential Definition,
     * a Smart Credential cannot be printed until 
     *                                 approved.
     */
    public void setApproved(Boolean approved) {
        this.approved = approved;
    }


    /**
     * Gets the sealed value for this UserSmartCredentialParms.
     * 
     * @return sealed   * A flag indicating if this Smart Credential is
     *                                 sealed or not.  A sealed Smart Credential
     * can
     *                                 not be modified or printed.  Normally
     * a
     *                                 Smart Credential will be sealed after
     * printing
     *                                 is complete.
     */
    public Boolean getSealed() {
        return sealed;
    }


    /**
     * Sets the sealed value for this UserSmartCredentialParms.
     * 
     * @param sealed   * A flag indicating if this Smart Credential is
     *                                 sealed or not.  A sealed Smart Credential
     * can
     *                                 not be modified or printed.  Normally
     * a
     *                                 Smart Credential will be sealed after
     * printing
     *                                 is complete.
     */
    public void setSealed(Boolean sealed) {
        this.sealed = sealed;
    }


    /**
     * Gets the enrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return enrollmentValues   * Enrollment values that will be set for this
     *                                 Smart Credential during the
     *                                 userSmartCredentialCreate,
     *                                 or userSmartCredentialSet operation.
     * If specified during a userSmartCredentialSet
     *                                 operation and MergeEnrollmentParameters
     * is
     *                                 false, the Smart Credential's existing
     * parameters are replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values.
     */
    public NameValue[] getEnrollmentValues() {
        return enrollmentValues;
    }


    /**
     * Sets the enrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param enrollmentValues   * Enrollment values that will be set for this
     *                                 Smart Credential during the
     *                                 userSmartCredentialCreate,
     *                                 or userSmartCredentialSet operation.
     * If specified during a userSmartCredentialSet
     *                                 operation and MergeEnrollmentParameters
     * is
     *                                 false, the Smart Credential's existing
     * parameters are replaced
     *                                 by this list.  Otherwise, these values
     * are
     *                                 merged with the existing values.
     */
    public void setEnrollmentValues(NameValue[] enrollmentValues) {
        this.enrollmentValues = enrollmentValues;
    }


    /**
     * Gets the rawEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return rawEnrollmentValues   * If set to true, the EnrollmentValues list
     *                                 contains raw values rather than encoded
     * values.
     *                                 If not specified, this value defaults
     * to false.
     */
    public Boolean getRawEnrollmentValues() {
        return rawEnrollmentValues;
    }


    /**
     * Sets the rawEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param rawEnrollmentValues   * If set to true, the EnrollmentValues list
     *                                 contains raw values rather than encoded
     * values.
     *                                 If not specified, this value defaults
     * to false.
     */
    public void setRawEnrollmentValues(Boolean rawEnrollmentValues) {
        this.rawEnrollmentValues = rawEnrollmentValues;
    }


    /**
     * Gets the mergeEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return mergeEnrollmentValues   * If set to true, the EnrollmentValues list is
     *                                 merged with the existing values during
     * the
     *                                 userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * true. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations.
     */
    public Boolean getMergeEnrollmentValues() {
        return mergeEnrollmentValues;
    }


    /**
     * Sets the mergeEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param mergeEnrollmentValues   * If set to true, the EnrollmentValues list is
     *                                 merged with the existing values during
     * the
     *                                 userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * true. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations.
     */
    public void setMergeEnrollmentValues(Boolean mergeEnrollmentValues) {
        this.mergeEnrollmentValues = mergeEnrollmentValues;
    }


    /**
     * Gets the removeEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return removeEnrollmentValues   * A list of enrollment value names to remove from
     *                                 the list of existing enrollment values.
     * This
     *                                 argument only applies to the
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllEnrollmentValues is specifies
     * as true.
     */
    public String[] getRemoveEnrollmentValues() {
        return removeEnrollmentValues;
    }


    /**
     * Sets the removeEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param removeEnrollmentValues   * A list of enrollment value names to remove from
     *                                 the list of existing enrollment values.
     * This
     *                                 argument only applies to the
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllEnrollmentValues is specifies
     * as true.
     */
    public void setRemoveEnrollmentValues(String[] removeEnrollmentValues) {
        this.removeEnrollmentValues = removeEnrollmentValues;
    }


    /**
     * Gets the removeAllEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return removeAllEnrollmentValues   * If set to true, remove all Smart Credential
     *                                 enrollment values. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveEnrollmentParameters. If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userSmartCredentialSet operation,
     * and is
     *                                 ignored by other operations.
     */
    public Boolean getRemoveAllEnrollmentValues() {
        return removeAllEnrollmentValues;
    }


    /**
     * Sets the removeAllEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param removeAllEnrollmentValues   * If set to true, remove all Smart Credential
     *                                 enrollment values. If
     *                                 specified, this value takes precedence
     * over
     *                                 RemoveEnrollmentParameters. If not
     * specified it
     *                                 defaults to false. This parameter
     * only applies
     *                                 to the userSmartCredentialSet operation,
     * and is
     *                                 ignored by other operations.
     */
    public void setRemoveAllEnrollmentValues(Boolean removeAllEnrollmentValues) {
        this.removeAllEnrollmentValues = removeAllEnrollmentValues;
    }


    /**
     * Gets the generateEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @return generateEnrollmentValues   * If specified, new values are generated for
     *                                 all specified variables.  If a specified
     * variable does not exist or does not support
     *                                 generation an error is returned. 
     * This argument
     *                                 only applies to the userSmartCredentialSet
     * operation and is ignored if specified for the
     *                                 userSmartCredentialCreate operation.
     */
    public String[] getGenerateEnrollmentValues() {
        return generateEnrollmentValues;
    }


    /**
     * Sets the generateEnrollmentValues value for this UserSmartCredentialParms.
     * 
     * @param generateEnrollmentValues   * If specified, new values are generated for
     *                                 all specified variables.  If a specified
     * variable does not exist or does not support
     *                                 generation an error is returned. 
     * This argument
     *                                 only applies to the userSmartCredentialSet
     * operation and is ignored if specified for the
     *                                 userSmartCredentialCreate operation.
     */
    public void setGenerateEnrollmentValues(String[] generateEnrollmentValues) {
        this.generateEnrollmentValues = generateEnrollmentValues;
    }


    /**
     * Gets the friendlyName value for this UserSmartCredentialParms.
     * 
     * @return friendlyName   * The Smart Credential friendly name.
     */
    public String getFriendlyName() {
        return friendlyName;
    }


    /**
     * Sets the friendlyName value for this UserSmartCredentialParms.
     * 
     * @param friendlyName   * The Smart Credential friendly name.
     */
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }


    /**
     * Gets the smartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @return smartCredentialParameters   * Smart Credential parameters that will be set
     *                                 for this smart credential during the
     * userSmartCredentialCreate or
     *                                 userSmartCredentialSet operation.
     * If specified
     *                                 during a userSmartCredentialSet operation
     * and
     *                                 MergeSmartCredentialParameters is
     * false or
     *                                 null, then the smart credential's
     * existing
     *                                 parameters are replaced by this list.
     * Otherwise, these values are
     *                                 merged with the existing values.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public NameValue[] getSmartCredentialParameters() {
        return smartCredentialParameters;
    }


    /**
     * Sets the smartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @param smartCredentialParameters   * Smart Credential parameters that will be set
     *                                 for this smart credential during the
     * userSmartCredentialCreate or
     *                                 userSmartCredentialSet operation.
     * If specified
     *                                 during a userSmartCredentialSet operation
     * and
     *                                 MergeSmartCredentialParameters is
     * false or
     *                                 null, then the smart credential's
     * existing
     *                                 parameters are replaced by this list.
     * Otherwise, these values are
     *                                 merged with the existing values.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public void setSmartCredentialParameters(NameValue[] smartCredentialParameters) {
        this.smartCredentialParameters = smartCredentialParameters;
    }


    /**
     * Gets the mergeSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @return mergeSmartCredentialParameters   * If set to true, the SmartCredentialParameters
     *                                 list is merged with the existing values
     * during
     *                                 the userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * false. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public Boolean getMergeSmartCredentialParameters() {
        return mergeSmartCredentialParameters;
    }


    /**
     * Sets the mergeSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @param mergeSmartCredentialParameters   * If set to true, the SmartCredentialParameters
     *                                 list is merged with the existing values
     * during
     *                                 the userSmartCredentialSet operation.
     * If not
     *                                 specified, this value defaults to
     * false. This
     *                                 parameter only applies to the
     *                                 userSmartCredentialSet operation and
     * is
     *                                 ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public void setMergeSmartCredentialParameters(Boolean mergeSmartCredentialParameters) {
        this.mergeSmartCredentialParameters = mergeSmartCredentialParameters;
    }


    /**
     * Gets the removeSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @return removeSmartCredentialParameters   * A list of smart credential parameter names to
     *                                 remove from the list of existing smart
     * credential parameters.  This
     *                                 argument only applies to the 
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllSmartCredentialParameters
     * is
     *                                 specified as true.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public String[] getRemoveSmartCredentialParameters() {
        return removeSmartCredentialParameters;
    }


    /**
     * Sets the removeSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @param removeSmartCredentialParameters   * A list of smart credential parameter names to
     *                                 remove from the list of existing smart
     * credential parameters.  This
     *                                 argument only applies to the 
     *                                 userSmartCredentialSet
     *                                 operation.  This argument is ignored
     * if
     *                                 RemoveAllSmartCredentialParameters
     * is
     *                                 specified as true.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public void setRemoveSmartCredentialParameters(String[] removeSmartCredentialParameters) {
        this.removeSmartCredentialParameters = removeSmartCredentialParameters;
    }


    /**
     * Gets the removeAllSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @return removeAllSmartCredentialParameters   * If set to true, remove all smart credential
     *                                 parameters. If specified, this value
     * takes
     *                                 precedence over
     *                                 RemoveSmartCredentialParameters. If
     * not
     *                                 specified it defaults to false. This
     * parameter
     *                                 only applies to the userSmartCredentialSet
     * operation, and is ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public Boolean getRemoveAllSmartCredentialParameters() {
        return removeAllSmartCredentialParameters;
    }


    /**
     * Sets the removeAllSmartCredentialParameters value for this UserSmartCredentialParms.
     * 
     * @param removeAllSmartCredentialParameters   * If set to true, remove all smart credential
     *                                 parameters. If specified, this value
     * takes
     *                                 precedence over
     *                                 RemoveSmartCredentialParameters. If
     * not
     *                                 specified it defaults to false. This
     * parameter
     *                                 only applies to the userSmartCredentialSet
     * operation, and is ignored by other operations.
     *                                 The administrator must have the
     *                                 userSmartCredentialParameterSet permission
     * to
     *                                 specify this argument.
     */
    public void setRemoveAllSmartCredentialParameters(Boolean removeAllSmartCredentialParameters) {
        this.removeAllSmartCredentialParameters = removeAllSmartCredentialParameters;
    }


    /**
     * Gets the comment value for this UserSmartCredentialParms.
     * 
     * @return comment   * The Smart Credential comment.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserSmartCredentialParms.
     * 
     * @param comment   * The Smart Credential comment.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserSmartCredentialParms)) return false;
        UserSmartCredentialParms other = (UserSmartCredentialParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.definitionId==null && other.getDefinitionId()==null) || 
             (this.definitionId!=null &&
              this.definitionId.equals(other.getDefinitionId()))) &&
            ((this.cloneId==null && other.getCloneId()==null) || 
             (this.cloneId!=null &&
              this.cloneId.equals(other.getCloneId()))) &&
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.cardUID==null && other.getCardUID()==null) || 
             (this.cardUID!=null &&
              this.cardUID.equals(other.getCardUID()))) &&
            ((this.mobileSerialNumber==null && other.getMobileSerialNumber()==null) || 
             (this.mobileSerialNumber!=null &&
              this.mobileSerialNumber.equals(other.getMobileSerialNumber()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.issueState==null && other.getIssueState()==null) || 
             (this.issueState!=null &&
              this.issueState.equals(other.getIssueState()))) &&
            ((this.issueDate==null && other.getIssueDate()==null) || 
             (this.issueDate!=null &&
              this.issueDate.equals(other.getIssueDate()))) &&
            ((this.issueInfo==null && other.getIssueInfo()==null) || 
             (this.issueInfo!=null &&
              this.issueInfo.equals(other.getIssueInfo()))) &&
            ((this.valid==null && other.getValid()==null) || 
             (this.valid!=null &&
              this.valid.equals(other.getValid()))) &&
            ((this.approved==null && other.getApproved()==null) || 
             (this.approved!=null &&
              this.approved.equals(other.getApproved()))) &&
            ((this.sealed==null && other.getSealed()==null) || 
             (this.sealed!=null &&
              this.sealed.equals(other.getSealed()))) &&
            ((this.enrollmentValues==null && other.getEnrollmentValues()==null) || 
             (this.enrollmentValues!=null &&
              java.util.Arrays.equals(this.enrollmentValues, other.getEnrollmentValues()))) &&
            ((this.rawEnrollmentValues==null && other.getRawEnrollmentValues()==null) || 
             (this.rawEnrollmentValues!=null &&
              this.rawEnrollmentValues.equals(other.getRawEnrollmentValues()))) &&
            ((this.mergeEnrollmentValues==null && other.getMergeEnrollmentValues()==null) || 
             (this.mergeEnrollmentValues!=null &&
              this.mergeEnrollmentValues.equals(other.getMergeEnrollmentValues()))) &&
            ((this.removeEnrollmentValues==null && other.getRemoveEnrollmentValues()==null) || 
             (this.removeEnrollmentValues!=null &&
              java.util.Arrays.equals(this.removeEnrollmentValues, other.getRemoveEnrollmentValues()))) &&
            ((this.removeAllEnrollmentValues==null && other.getRemoveAllEnrollmentValues()==null) || 
             (this.removeAllEnrollmentValues!=null &&
              this.removeAllEnrollmentValues.equals(other.getRemoveAllEnrollmentValues()))) &&
            ((this.generateEnrollmentValues==null && other.getGenerateEnrollmentValues()==null) || 
             (this.generateEnrollmentValues!=null &&
              java.util.Arrays.equals(this.generateEnrollmentValues, other.getGenerateEnrollmentValues()))) &&
            ((this.friendlyName==null && other.getFriendlyName()==null) || 
             (this.friendlyName!=null &&
              this.friendlyName.equals(other.getFriendlyName()))) &&
            ((this.smartCredentialParameters==null && other.getSmartCredentialParameters()==null) || 
             (this.smartCredentialParameters!=null &&
              java.util.Arrays.equals(this.smartCredentialParameters, other.getSmartCredentialParameters()))) &&
            ((this.mergeSmartCredentialParameters==null && other.getMergeSmartCredentialParameters()==null) || 
             (this.mergeSmartCredentialParameters!=null &&
              this.mergeSmartCredentialParameters.equals(other.getMergeSmartCredentialParameters()))) &&
            ((this.removeSmartCredentialParameters==null && other.getRemoveSmartCredentialParameters()==null) || 
             (this.removeSmartCredentialParameters!=null &&
              java.util.Arrays.equals(this.removeSmartCredentialParameters, other.getRemoveSmartCredentialParameters()))) &&
            ((this.removeAllSmartCredentialParameters==null && other.getRemoveAllSmartCredentialParameters()==null) || 
             (this.removeAllSmartCredentialParameters!=null &&
              this.removeAllSmartCredentialParameters.equals(other.getRemoveAllSmartCredentialParameters()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getDefinitionId() != null) {
            _hashCode += getDefinitionId().hashCode();
        }
        if (getCloneId() != null) {
            _hashCode += getCloneId().hashCode();
        }
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getCardUID() != null) {
            _hashCode += getCardUID().hashCode();
        }
        if (getMobileSerialNumber() != null) {
            _hashCode += getMobileSerialNumber().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getIssueState() != null) {
            _hashCode += getIssueState().hashCode();
        }
        if (getIssueDate() != null) {
            _hashCode += getIssueDate().hashCode();
        }
        if (getIssueInfo() != null) {
            _hashCode += getIssueInfo().hashCode();
        }
        if (getValid() != null) {
            _hashCode += getValid().hashCode();
        }
        if (getApproved() != null) {
            _hashCode += getApproved().hashCode();
        }
        if (getSealed() != null) {
            _hashCode += getSealed().hashCode();
        }
        if (getEnrollmentValues() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getEnrollmentValues());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getEnrollmentValues(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRawEnrollmentValues() != null) {
            _hashCode += getRawEnrollmentValues().hashCode();
        }
        if (getMergeEnrollmentValues() != null) {
            _hashCode += getMergeEnrollmentValues().hashCode();
        }
        if (getRemoveEnrollmentValues() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveEnrollmentValues());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveEnrollmentValues(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllEnrollmentValues() != null) {
            _hashCode += getRemoveAllEnrollmentValues().hashCode();
        }
        if (getGenerateEnrollmentValues() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getGenerateEnrollmentValues());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getGenerateEnrollmentValues(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getFriendlyName() != null) {
            _hashCode += getFriendlyName().hashCode();
        }
        if (getSmartCredentialParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMergeSmartCredentialParameters() != null) {
            _hashCode += getMergeSmartCredentialParameters().hashCode();
        }
        if (getRemoveSmartCredentialParameters() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRemoveSmartCredentialParameters());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRemoveSmartCredentialParameters(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRemoveAllSmartCredentialParameters() != null) {
            _hashCode += getRemoveAllSmartCredentialParameters().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserSmartCredentialParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSmartCredentialParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("definitionId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DefinitionId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cloneId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CloneId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardUID");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CardUID"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "State"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueState");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueState"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "SmartCredentialIssueState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "IssueInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("valid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Valid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("approved");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Approved"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sealed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Sealed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "EnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rawEnrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RawEnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeEnrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeEnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeEnrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveEnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllEnrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllEnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("generateEnrollmentValues");
        elemField.setXmlName(new javax.xml.namespace.QName("", "GenerateEnrollmentValues"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("friendlyName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FriendlyName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mergeSmartCredentialParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MergeSmartCredentialParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeSmartCredentialParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveSmartCredentialParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllSmartCredentialParameters");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllSmartCredentialParameters"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
