/**
 * TransactionCertificateParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters used for the transaction
 *                         certificate create and set operations.
 */
public class TransactionCertificateParms  implements java.io.Serializable {
    /* The name of the transaction certificate.
     *                                 If specified, it is used to rename
     * the
     *                                 transaction certificate
     *                                 during the set operation. */
    private String name;

    /* The state of the transaction certificate.
     *                                 During the create operation, the states
     * PENDING or ACTIVE can be specified.  During
     *                                 the set operation, the states ACTIVE
     * or
     *                                 INACTIVE can be specified.  If this
     * value
     *                                 is not specified during the create
     * operation
     *                                 it defaults to ACTIVE.
     *                                 If specified during the set operation,
     * it is
     *                                 used to change the state of the transaction
     * certificate.  The state of an active
     *                                 transaction certificate can be changed
     * to
     *                                 inactive and the state of an inactive
     * transaction certificate can be changed to
     *                                 active if there isn't already an active
     * transaction certificate. */
    private com.good.adapters.entrust.stubs.TransactionCertificateState state;

    /* Specifies the subject DN for the transaction
     *                                 certificate during the create or set
     * operation.
     *                                 If not specified during the create
     * operation,
     *                                 the subject DN will
     *                                 be cn=name where name is the name
     * of the
     *                                 transaction certificate.  The subject
     * DN
     *                                 can only be changed during the set
     * operation
     *                                 for transaction certificates in the
     * pending
     *                                 state. */
    private String subjectDN;

    /* During the create operation, this value
     *                                 specifies the lifetime of the transaction
     * certificate lifetime in days.  If not
     *                                 specified, the lifetime defaults to
     * 365 days.
     *                                 This value must be between 1 and 7300
     * (20 years).  The lifetime is only applied
     *                                 to the creation of active certificates. */
    private Integer lifetime;

    /* If provided, this value specifies the hashing
     *                                 algorithm used when the transaction
     * certificate is used to sign a transaction
     *                                 receipt.  This algorithm is also used
     * to
     *                                 sign the certificate when
     *                                 creating an active transaction certificate.
     * The value must be SHA-1.
     *                                 If not specified during the create
     * operation,
     *                                 it defaults to SHA-1. */
    private String hashAlg;

    /* If provided, this value species the key
     *                                 algorithm used to generate the
     *                                 key pair for this transaction certificate
     * during the create operation.
     *                                 The value must be one of RSA-1024
     * or RSA-2048.
     *                                 If not specified, it defaults to RSA-2048. */
    private String keyAlg;

    /* During the create operation, creation
     *                                 of a pending or active transaction
     * certificate
     *                                 will fail if a pending or active transaction
     * certificate already exists unless the
     *                                 force option is specified as true.
     * If
     *                                 the force option is specified as true,
     * the existing pending transaction certificate
     *                                 will be deleted and the existing active
     * transaction certificate will have it's state
     *                                 changed to inactive. */
    private Boolean force;

    public TransactionCertificateParms() {
    }

    public TransactionCertificateParms(
           String name,
           com.good.adapters.entrust.stubs.TransactionCertificateState state,
           String subjectDN,
           Integer lifetime,
           String hashAlg,
           String keyAlg,
           Boolean force) {
           this.name = name;
           this.state = state;
           this.subjectDN = subjectDN;
           this.lifetime = lifetime;
           this.hashAlg = hashAlg;
           this.keyAlg = keyAlg;
           this.force = force;
    }


    /**
     * Gets the name value for this TransactionCertificateParms.
     * 
     * @return name   * The name of the transaction certificate.
     *                                 If specified, it is used to rename
     * the
     *                                 transaction certificate
     *                                 during the set operation.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this TransactionCertificateParms.
     * 
     * @param name   * The name of the transaction certificate.
     *                                 If specified, it is used to rename
     * the
     *                                 transaction certificate
     *                                 during the set operation.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the state value for this TransactionCertificateParms.
     * 
     * @return state   * The state of the transaction certificate.
     *                                 During the create operation, the states
     * PENDING or ACTIVE can be specified.  During
     *                                 the set operation, the states ACTIVE
     * or
     *                                 INACTIVE can be specified.  If this
     * value
     *                                 is not specified during the create
     * operation
     *                                 it defaults to ACTIVE.
     *                                 If specified during the set operation,
     * it is
     *                                 used to change the state of the transaction
     * certificate.  The state of an active
     *                                 transaction certificate can be changed
     * to
     *                                 inactive and the state of an inactive
     * transaction certificate can be changed to
     *                                 active if there isn't already an active
     * transaction certificate.
     */
    public com.good.adapters.entrust.stubs.TransactionCertificateState getState() {
        return state;
    }


    /**
     * Sets the state value for this TransactionCertificateParms.
     * 
     * @param state   * The state of the transaction certificate.
     *                                 During the create operation, the states
     * PENDING or ACTIVE can be specified.  During
     *                                 the set operation, the states ACTIVE
     * or
     *                                 INACTIVE can be specified.  If this
     * value
     *                                 is not specified during the create
     * operation
     *                                 it defaults to ACTIVE.
     *                                 If specified during the set operation,
     * it is
     *                                 used to change the state of the transaction
     * certificate.  The state of an active
     *                                 transaction certificate can be changed
     * to
     *                                 inactive and the state of an inactive
     * transaction certificate can be changed to
     *                                 active if there isn't already an active
     * transaction certificate.
     */
    public void setState(com.good.adapters.entrust.stubs.TransactionCertificateState state) {
        this.state = state;
    }


    /**
     * Gets the subjectDN value for this TransactionCertificateParms.
     * 
     * @return subjectDN   * Specifies the subject DN for the transaction
     *                                 certificate during the create or set
     * operation.
     *                                 If not specified during the create
     * operation,
     *                                 the subject DN will
     *                                 be cn=name where name is the name
     * of the
     *                                 transaction certificate.  The subject
     * DN
     *                                 can only be changed during the set
     * operation
     *                                 for transaction certificates in the
     * pending
     *                                 state.
     */
    public String getSubjectDN() {
        return subjectDN;
    }


    /**
     * Sets the subjectDN value for this TransactionCertificateParms.
     * 
     * @param subjectDN   * Specifies the subject DN for the transaction
     *                                 certificate during the create or set
     * operation.
     *                                 If not specified during the create
     * operation,
     *                                 the subject DN will
     *                                 be cn=name where name is the name
     * of the
     *                                 transaction certificate.  The subject
     * DN
     *                                 can only be changed during the set
     * operation
     *                                 for transaction certificates in the
     * pending
     *                                 state.
     */
    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }


    /**
     * Gets the lifetime value for this TransactionCertificateParms.
     * 
     * @return lifetime   * During the create operation, this value
     *                                 specifies the lifetime of the transaction
     * certificate lifetime in days.  If not
     *                                 specified, the lifetime defaults to
     * 365 days.
     *                                 This value must be between 1 and 7300
     * (20 years).  The lifetime is only applied
     *                                 to the creation of active certificates.
     */
    public Integer getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this TransactionCertificateParms.
     * 
     * @param lifetime   * During the create operation, this value
     *                                 specifies the lifetime of the transaction
     * certificate lifetime in days.  If not
     *                                 specified, the lifetime defaults to
     * 365 days.
     *                                 This value must be between 1 and 7300
     * (20 years).  The lifetime is only applied
     *                                 to the creation of active certificates.
     */
    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the hashAlg value for this TransactionCertificateParms.
     * 
     * @return hashAlg   * If provided, this value specifies the hashing
     *                                 algorithm used when the transaction
     * certificate is used to sign a transaction
     *                                 receipt.  This algorithm is also used
     * to
     *                                 sign the certificate when
     *                                 creating an active transaction certificate.
     * The value must be SHA-1.
     *                                 If not specified during the create
     * operation,
     *                                 it defaults to SHA-1.
     */
    public String getHashAlg() {
        return hashAlg;
    }


    /**
     * Sets the hashAlg value for this TransactionCertificateParms.
     * 
     * @param hashAlg   * If provided, this value specifies the hashing
     *                                 algorithm used when the transaction
     * certificate is used to sign a transaction
     *                                 receipt.  This algorithm is also used
     * to
     *                                 sign the certificate when
     *                                 creating an active transaction certificate.
     * The value must be SHA-1.
     *                                 If not specified during the create
     * operation,
     *                                 it defaults to SHA-1.
     */
    public void setHashAlg(String hashAlg) {
        this.hashAlg = hashAlg;
    }


    /**
     * Gets the keyAlg value for this TransactionCertificateParms.
     * 
     * @return keyAlg   * If provided, this value species the key
     *                                 algorithm used to generate the
     *                                 key pair for this transaction certificate
     * during the create operation.
     *                                 The value must be one of RSA-1024
     * or RSA-2048.
     *                                 If not specified, it defaults to RSA-2048.
     */
    public String getKeyAlg() {
        return keyAlg;
    }


    /**
     * Sets the keyAlg value for this TransactionCertificateParms.
     * 
     * @param keyAlg   * If provided, this value species the key
     *                                 algorithm used to generate the
     *                                 key pair for this transaction certificate
     * during the create operation.
     *                                 The value must be one of RSA-1024
     * or RSA-2048.
     *                                 If not specified, it defaults to RSA-2048.
     */
    public void setKeyAlg(String keyAlg) {
        this.keyAlg = keyAlg;
    }


    /**
     * Gets the force value for this TransactionCertificateParms.
     * 
     * @return force   * During the create operation, creation
     *                                 of a pending or active transaction
     * certificate
     *                                 will fail if a pending or active transaction
     * certificate already exists unless the
     *                                 force option is specified as true.
     * If
     *                                 the force option is specified as true,
     * the existing pending transaction certificate
     *                                 will be deleted and the existing active
     * transaction certificate will have it's state
     *                                 changed to inactive.
     */
    public Boolean getForce() {
        return force;
    }


    /**
     * Sets the force value for this TransactionCertificateParms.
     * 
     * @param force   * During the create operation, creation
     *                                 of a pending or active transaction
     * certificate
     *                                 will fail if a pending or active transaction
     * certificate already exists unless the
     *                                 force option is specified as true.
     * If
     *                                 the force option is specified as true,
     * the existing pending transaction certificate
     *                                 will be deleted and the existing active
     * transaction certificate will have it's state
     *                                 changed to inactive.
     */
    public void setForce(Boolean force) {
        this.force = force;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof TransactionCertificateParms)) return false;
        TransactionCertificateParms other = (TransactionCertificateParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.subjectDN==null && other.getSubjectDN()==null) || 
             (this.subjectDN!=null &&
              this.subjectDN.equals(other.getSubjectDN()))) &&
            ((this.lifetime==null && other.getLifetime()==null) || 
             (this.lifetime!=null &&
              this.lifetime.equals(other.getLifetime()))) &&
            ((this.hashAlg==null && other.getHashAlg()==null) || 
             (this.hashAlg!=null &&
              this.hashAlg.equals(other.getHashAlg()))) &&
            ((this.keyAlg==null && other.getKeyAlg()==null) || 
             (this.keyAlg!=null &&
              this.keyAlg.equals(other.getKeyAlg()))) &&
            ((this.force==null && other.getForce()==null) || 
             (this.force!=null &&
              this.force.equals(other.getForce())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getSubjectDN() != null) {
            _hashCode += getSubjectDN().hashCode();
        }
        if (getLifetime() != null) {
            _hashCode += getLifetime().hashCode();
        }
        if (getHashAlg() != null) {
            _hashCode += getHashAlg().hashCode();
        }
        if (getKeyAlg() != null) {
            _hashCode += getKeyAlg().hashCode();
        }
        if (getForce() != null) {
            _hashCode += getForce().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(TransactionCertificateParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TransactionCertificateParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "state"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TransactionCertificateState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("subjectDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "subjectDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hashAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hashAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("keyAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "keyAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("force");
        elemField.setXmlName(new javax.xml.namespace.QName("", "force"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
