/**
 * PartitionInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines information about a partition. Partitions
 *                         are used to reserve ranges of user numbers
 * and card serial numbers, allowing for more predictable
 *                         serial number issuance between different groups.
 */
public class PartitionInfo  implements java.io.Serializable {
    /* The name of the partition. */
    private String name;

    /* Current number of users in the system issued using this partition. */
    private java.math.BigInteger numUsers;

    /* The user number to assign to the next user
     *                                 created by a group using this partition.
     * Will be null if no more users can be created in
     *                                 this partition. */
    private java.math.BigInteger nextUserNumber;

    /* List of ranges of user numbers which can be issued
     *                                 by this policy. Will be null if no
     * user number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order. */
    private Range[] userNumberRanges;

    /* The serial number to assign to the next card created
     *                                 by a group using this partition. Will
     * be null if no
     *                                 more cards can be created in this
     * partition. */
    private java.math.BigInteger nextCardSerialNumber;

    /* List of ranges of card serial numbers which can be issued
     *                                 by this policy. Will be null if no
     * card serial number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order. */
    private Range[] cardSerialNumberRanges;

    /* Current number of licensed soft tokens in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition. */
    private java.math.BigInteger numTokens;

    /* Current number of licensed smart credentials in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition. */
    private java.math.BigInteger numSmartCredentials;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments about this partition, that could
     *                                 be used to provide a full description
     * of this
     *                                 partition's intended purpose. */
    private String comment;

    public PartitionInfo() {
    }

    public PartitionInfo(
           String name,
           java.math.BigInteger numUsers,
           java.math.BigInteger nextUserNumber,
           Range[] userNumberRanges,
           java.math.BigInteger nextCardSerialNumber,
           Range[] cardSerialNumberRanges,
           java.math.BigInteger numTokens,
           java.math.BigInteger numSmartCredentials,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.numUsers = numUsers;
           this.nextUserNumber = nextUserNumber;
           this.userNumberRanges = userNumberRanges;
           this.nextCardSerialNumber = nextCardSerialNumber;
           this.cardSerialNumberRanges = cardSerialNumberRanges;
           this.numTokens = numTokens;
           this.numSmartCredentials = numSmartCredentials;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this PartitionInfo.
     * 
     * @return name   * The name of the partition.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this PartitionInfo.
     * 
     * @param name   * The name of the partition.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the numUsers value for this PartitionInfo.
     * 
     * @return numUsers   * Current number of users in the system issued using this partition.
     */
    public java.math.BigInteger getNumUsers() {
        return numUsers;
    }


    /**
     * Sets the numUsers value for this PartitionInfo.
     * 
     * @param numUsers   * Current number of users in the system issued using this partition.
     */
    public void setNumUsers(java.math.BigInteger numUsers) {
        this.numUsers = numUsers;
    }


    /**
     * Gets the nextUserNumber value for this PartitionInfo.
     * 
     * @return nextUserNumber   * The user number to assign to the next user
     *                                 created by a group using this partition.
     * Will be null if no more users can be created in
     *                                 this partition.
     */
    public java.math.BigInteger getNextUserNumber() {
        return nextUserNumber;
    }


    /**
     * Sets the nextUserNumber value for this PartitionInfo.
     * 
     * @param nextUserNumber   * The user number to assign to the next user
     *                                 created by a group using this partition.
     * Will be null if no more users can be created in
     *                                 this partition.
     */
    public void setNextUserNumber(java.math.BigInteger nextUserNumber) {
        this.nextUserNumber = nextUserNumber;
    }


    /**
     * Gets the userNumberRanges value for this PartitionInfo.
     * 
     * @return userNumberRanges   * List of ranges of user numbers which can be issued
     *                                 by this policy. Will be null if no
     * user number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order.
     */
    public Range[] getUserNumberRanges() {
        return userNumberRanges;
    }


    /**
     * Sets the userNumberRanges value for this PartitionInfo.
     * 
     * @param userNumberRanges   * List of ranges of user numbers which can be issued
     *                                 by this policy. Will be null if no
     * user number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order.
     */
    public void setUserNumberRanges(Range[] userNumberRanges) {
        this.userNumberRanges = userNumberRanges;
    }


    /**
     * Gets the nextCardSerialNumber value for this PartitionInfo.
     * 
     * @return nextCardSerialNumber   * The serial number to assign to the next card created
     *                                 by a group using this partition. Will
     * be null if no
     *                                 more cards can be created in this
     * partition.
     */
    public java.math.BigInteger getNextCardSerialNumber() {
        return nextCardSerialNumber;
    }


    /**
     * Sets the nextCardSerialNumber value for this PartitionInfo.
     * 
     * @param nextCardSerialNumber   * The serial number to assign to the next card created
     *                                 by a group using this partition. Will
     * be null if no
     *                                 more cards can be created in this
     * partition.
     */
    public void setNextCardSerialNumber(java.math.BigInteger nextCardSerialNumber) {
        this.nextCardSerialNumber = nextCardSerialNumber;
    }


    /**
     * Gets the cardSerialNumberRanges value for this PartitionInfo.
     * 
     * @return cardSerialNumberRanges   * List of ranges of card serial numbers which can be issued
     *                                 by this policy. Will be null if no
     * card serial number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order.
     */
    public Range[] getCardSerialNumberRanges() {
        return cardSerialNumberRanges;
    }


    /**
     * Sets the cardSerialNumberRanges value for this PartitionInfo.
     * 
     * @param cardSerialNumberRanges   * List of ranges of card serial numbers which can be issued
     *                                 by this policy. Will be null if no
     * card serial number
     *                                 ranges are assigned. These will be
     * sorted so
     *                                 that the minimum number in each range
     * is in
     *                                 ascending order.
     */
    public void setCardSerialNumberRanges(Range[] cardSerialNumberRanges) {
        this.cardSerialNumberRanges = cardSerialNumberRanges;
    }


    /**
     * Gets the numTokens value for this PartitionInfo.
     * 
     * @return numTokens   * Current number of licensed soft tokens in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition.
     */
    public java.math.BigInteger getNumTokens() {
        return numTokens;
    }


    /**
     * Sets the numTokens value for this PartitionInfo.
     * 
     * @param numTokens   * Current number of licensed soft tokens in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition.
     */
    public void setNumTokens(java.math.BigInteger numTokens) {
        this.numTokens = numTokens;
    }


    /**
     * Gets the numSmartCredentials value for this PartitionInfo.
     * 
     * @return numSmartCredentials   * Current number of licensed smart credentials in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition.
     */
    public java.math.BigInteger getNumSmartCredentials() {
        return numSmartCredentials;
    }


    /**
     * Sets the numSmartCredentials value for this PartitionInfo.
     * 
     * @param numSmartCredentials   * Current number of licensed smart credentials in the
     *                                 system that are assigned to users
     * who belong
     *                                 to this partition.
     */
    public void setNumSmartCredentials(java.math.BigInteger numSmartCredentials) {
        this.numSmartCredentials = numSmartCredentials;
    }


    /**
     * Gets the rolesGrantingAccess value for this PartitionInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this PartitionInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this PartitionInfo.
     * 
     * @return comment   * Descriptive comments about this partition, that could
     *                                 be used to provide a full description
     * of this
     *                                 partition's intended purpose.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this PartitionInfo.
     * 
     * @param comment   * Descriptive comments about this partition, that could
     *                                 be used to provide a full description
     * of this
     *                                 partition's intended purpose.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof PartitionInfo)) return false;
        PartitionInfo other = (PartitionInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.numUsers==null && other.getNumUsers()==null) || 
             (this.numUsers!=null &&
              this.numUsers.equals(other.getNumUsers()))) &&
            ((this.nextUserNumber==null && other.getNextUserNumber()==null) || 
             (this.nextUserNumber!=null &&
              this.nextUserNumber.equals(other.getNextUserNumber()))) &&
            ((this.userNumberRanges==null && other.getUserNumberRanges()==null) || 
             (this.userNumberRanges!=null &&
              java.util.Arrays.equals(this.userNumberRanges, other.getUserNumberRanges()))) &&
            ((this.nextCardSerialNumber==null && other.getNextCardSerialNumber()==null) || 
             (this.nextCardSerialNumber!=null &&
              this.nextCardSerialNumber.equals(other.getNextCardSerialNumber()))) &&
            ((this.cardSerialNumberRanges==null && other.getCardSerialNumberRanges()==null) || 
             (this.cardSerialNumberRanges!=null &&
              java.util.Arrays.equals(this.cardSerialNumberRanges, other.getCardSerialNumberRanges()))) &&
            ((this.numTokens==null && other.getNumTokens()==null) || 
             (this.numTokens!=null &&
              this.numTokens.equals(other.getNumTokens()))) &&
            ((this.numSmartCredentials==null && other.getNumSmartCredentials()==null) || 
             (this.numSmartCredentials!=null &&
              this.numSmartCredentials.equals(other.getNumSmartCredentials()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getNumUsers() != null) {
            _hashCode += getNumUsers().hashCode();
        }
        if (getNextUserNumber() != null) {
            _hashCode += getNextUserNumber().hashCode();
        }
        if (getUserNumberRanges() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getUserNumberRanges());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getUserNumberRanges(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getNextCardSerialNumber() != null) {
            _hashCode += getNextCardSerialNumber().hashCode();
        }
        if (getCardSerialNumberRanges() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCardSerialNumberRanges());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCardSerialNumberRanges(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getNumTokens() != null) {
            _hashCode += getNumTokens().hashCode();
        }
        if (getNumSmartCredentials() != null) {
            _hashCode += getNumSmartCredentials().hashCode();
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PartitionInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PartitionInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("nextUserNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "nextUserNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userNumberRanges");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userNumberRanges"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "Range"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("nextCardSerialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "nextCardSerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardSerialNumberRanges");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cardSerialNumberRanges"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "Range"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
