/**
 * ChallengeSet.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * This structure defines the components returned as part of a grid
 * challenge. It contains an array of Challenges which define the
 *             challenge the user must respond to, as well as additional
 * data
 *             that describes the format of a valid challenge response.
 * Note
 *             that the settings for what is a valid response are based
 * on the
 *             most up-to-date policy settings, while the user's card
 * may have
 *             been generated with older settings that mean the card
 * is no longer
 *             valid according to the new ones.  For example, if the
 * user's card
 *             was generated with one character per cell, then the policy
 * was
 *             changed to two characters per cell, the value in this
 * structure for
 *             number of characters per cell would be two, even though
 * the user's
 *             card only has one character per cell.
 */
public class ChallengeSet  implements java.io.Serializable {
    /* This string includes all the characters allowed in a
     *                   challenge response.  This does not include cell
     * replacements,
     *                   where, for example, the character 'l' may automatically
     * be
     *                   replaced by the digit '1' by the server. */
    private String cardCellAlphabet;

    /* The number of characters in a single card cell. */
    private int cardCellSize;

    /* The list of serial numbers of cards that the user could use
     * to authenticate.  This will be <code>null</code>
     *                   if the system policy settings do not allow returning
     * of this
     *                   value, the user has a temporary PIN but no active
     * cards or
     *                   for anonymous authentication. */
    private String[] cardSerialNumbers;

    /* An array of Challenge components. This is the challenge that
     * the user must successfully answer. */
    private Challenge[] challenge;

    /* The characters allowed in a temporary PIN challenge response. */
    private String temporaryPinCellAlphabet;

    /* The number of characters in a temporary PIN cell. */
    private int temporaryPinCellSize;

    /* The number of cells in a temporary PIN challenge response. */
    private int temporaryPinChallengeSize;

    /* If true, the user currently has a temporary PIN assigned.
     *                   If the system does not allow returning of user data
     * in the
     *                   challenge set, this value will be false, regardless
     * of
     *                   whether or not the user actually has a temporary
     * PIN. */
    private boolean userHasTemporaryPin;

    public ChallengeSet() {
    }

    public ChallengeSet(
           String cardCellAlphabet,
           int cardCellSize,
           String[] cardSerialNumbers,
           Challenge[] challenge,
           String temporaryPinCellAlphabet,
           int temporaryPinCellSize,
           int temporaryPinChallengeSize,
           boolean userHasTemporaryPin) {
           this.cardCellAlphabet = cardCellAlphabet;
           this.cardCellSize = cardCellSize;
           this.cardSerialNumbers = cardSerialNumbers;
           this.challenge = challenge;
           this.temporaryPinCellAlphabet = temporaryPinCellAlphabet;
           this.temporaryPinCellSize = temporaryPinCellSize;
           this.temporaryPinChallengeSize = temporaryPinChallengeSize;
           this.userHasTemporaryPin = userHasTemporaryPin;
    }


    /**
     * Gets the cardCellAlphabet value for this ChallengeSet.
     * 
     * @return cardCellAlphabet   * This string includes all the characters allowed in a
     *                   challenge response.  This does not include cell
     * replacements,
     *                   where, for example, the character 'l' may automatically
     * be
     *                   replaced by the digit '1' by the server.
     */
    public String getCardCellAlphabet() {
        return cardCellAlphabet;
    }


    /**
     * Sets the cardCellAlphabet value for this ChallengeSet.
     * 
     * @param cardCellAlphabet   * This string includes all the characters allowed in a
     *                   challenge response.  This does not include cell
     * replacements,
     *                   where, for example, the character 'l' may automatically
     * be
     *                   replaced by the digit '1' by the server.
     */
    public void setCardCellAlphabet(String cardCellAlphabet) {
        this.cardCellAlphabet = cardCellAlphabet;
    }


    /**
     * Gets the cardCellSize value for this ChallengeSet.
     * 
     * @return cardCellSize   * The number of characters in a single card cell.
     */
    public int getCardCellSize() {
        return cardCellSize;
    }


    /**
     * Sets the cardCellSize value for this ChallengeSet.
     * 
     * @param cardCellSize   * The number of characters in a single card cell.
     */
    public void setCardCellSize(int cardCellSize) {
        this.cardCellSize = cardCellSize;
    }


    /**
     * Gets the cardSerialNumbers value for this ChallengeSet.
     * 
     * @return cardSerialNumbers   * The list of serial numbers of cards that the user could use
     * to authenticate.  This will be <code>null</code>
     *                   if the system policy settings do not allow returning
     * of this
     *                   value, the user has a temporary PIN but no active
     * cards or
     *                   for anonymous authentication.
     */
    public String[] getCardSerialNumbers() {
        return cardSerialNumbers;
    }


    /**
     * Sets the cardSerialNumbers value for this ChallengeSet.
     * 
     * @param cardSerialNumbers   * The list of serial numbers of cards that the user could use
     * to authenticate.  This will be <code>null</code>
     *                   if the system policy settings do not allow returning
     * of this
     *                   value, the user has a temporary PIN but no active
     * cards or
     *                   for anonymous authentication.
     */
    public void setCardSerialNumbers(String[] cardSerialNumbers) {
        this.cardSerialNumbers = cardSerialNumbers;
    }


    /**
     * Gets the challenge value for this ChallengeSet.
     * 
     * @return challenge   * An array of Challenge components. This is the challenge that
     * the user must successfully answer.
     */
    public Challenge[] getChallenge() {
        return challenge;
    }


    /**
     * Sets the challenge value for this ChallengeSet.
     * 
     * @param challenge   * An array of Challenge components. This is the challenge that
     * the user must successfully answer.
     */
    public void setChallenge(Challenge[] challenge) {
        this.challenge = challenge;
    }


    /**
     * Gets the temporaryPinCellAlphabet value for this ChallengeSet.
     * 
     * @return temporaryPinCellAlphabet   * The characters allowed in a temporary PIN challenge response.
     */
    public String getTemporaryPinCellAlphabet() {
        return temporaryPinCellAlphabet;
    }


    /**
     * Sets the temporaryPinCellAlphabet value for this ChallengeSet.
     * 
     * @param temporaryPinCellAlphabet   * The characters allowed in a temporary PIN challenge response.
     */
    public void setTemporaryPinCellAlphabet(String temporaryPinCellAlphabet) {
        this.temporaryPinCellAlphabet = temporaryPinCellAlphabet;
    }


    /**
     * Gets the temporaryPinCellSize value for this ChallengeSet.
     * 
     * @return temporaryPinCellSize   * The number of characters in a temporary PIN cell.
     */
    public int getTemporaryPinCellSize() {
        return temporaryPinCellSize;
    }


    /**
     * Sets the temporaryPinCellSize value for this ChallengeSet.
     * 
     * @param temporaryPinCellSize   * The number of characters in a temporary PIN cell.
     */
    public void setTemporaryPinCellSize(int temporaryPinCellSize) {
        this.temporaryPinCellSize = temporaryPinCellSize;
    }


    /**
     * Gets the temporaryPinChallengeSize value for this ChallengeSet.
     * 
     * @return temporaryPinChallengeSize   * The number of cells in a temporary PIN challenge response.
     */
    public int getTemporaryPinChallengeSize() {
        return temporaryPinChallengeSize;
    }


    /**
     * Sets the temporaryPinChallengeSize value for this ChallengeSet.
     * 
     * @param temporaryPinChallengeSize   * The number of cells in a temporary PIN challenge response.
     */
    public void setTemporaryPinChallengeSize(int temporaryPinChallengeSize) {
        this.temporaryPinChallengeSize = temporaryPinChallengeSize;
    }


    /**
     * Gets the userHasTemporaryPin value for this ChallengeSet.
     * 
     * @return userHasTemporaryPin   * If true, the user currently has a temporary PIN assigned.
     *                   If the system does not allow returning of user data
     * in the
     *                   challenge set, this value will be false, regardless
     * of
     *                   whether or not the user actually has a temporary
     * PIN.
     */
    public boolean isUserHasTemporaryPin() {
        return userHasTemporaryPin;
    }


    /**
     * Sets the userHasTemporaryPin value for this ChallengeSet.
     * 
     * @param userHasTemporaryPin   * If true, the user currently has a temporary PIN assigned.
     *                   If the system does not allow returning of user data
     * in the
     *                   challenge set, this value will be false, regardless
     * of
     *                   whether or not the user actually has a temporary
     * PIN.
     */
    public void setUserHasTemporaryPin(boolean userHasTemporaryPin) {
        this.userHasTemporaryPin = userHasTemporaryPin;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof ChallengeSet)) return false;
        ChallengeSet other = (ChallengeSet) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.cardCellAlphabet==null && other.getCardCellAlphabet()==null) || 
             (this.cardCellAlphabet!=null &&
              this.cardCellAlphabet.equals(other.getCardCellAlphabet()))) &&
            this.cardCellSize == other.getCardCellSize() &&
            ((this.cardSerialNumbers==null && other.getCardSerialNumbers()==null) || 
             (this.cardSerialNumbers!=null &&
              java.util.Arrays.equals(this.cardSerialNumbers, other.getCardSerialNumbers()))) &&
            ((this.challenge==null && other.getChallenge()==null) || 
             (this.challenge!=null &&
              java.util.Arrays.equals(this.challenge, other.getChallenge()))) &&
            ((this.temporaryPinCellAlphabet==null && other.getTemporaryPinCellAlphabet()==null) || 
             (this.temporaryPinCellAlphabet!=null &&
              this.temporaryPinCellAlphabet.equals(other.getTemporaryPinCellAlphabet()))) &&
            this.temporaryPinCellSize == other.getTemporaryPinCellSize() &&
            this.temporaryPinChallengeSize == other.getTemporaryPinChallengeSize() &&
            this.userHasTemporaryPin == other.isUserHasTemporaryPin();
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getCardCellAlphabet() != null) {
            _hashCode += getCardCellAlphabet().hashCode();
        }
        _hashCode += getCardCellSize();
        if (getCardSerialNumbers() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCardSerialNumbers());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCardSerialNumbers(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getChallenge() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getChallenge());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getChallenge(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getTemporaryPinCellAlphabet() != null) {
            _hashCode += getTemporaryPinCellAlphabet().hashCode();
        }
        _hashCode += getTemporaryPinCellSize();
        _hashCode += getTemporaryPinChallengeSize();
        _hashCode += (isUserHasTemporaryPin() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(ChallengeSet.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "ChallengeSet"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardCellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cardCellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardCellSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cardCellSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardSerialNumbers");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cardSerialNumbers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "Challenge"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("temporaryPinCellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "temporaryPinCellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("temporaryPinCellSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "temporaryPinCellSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("temporaryPinChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "temporaryPinChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userHasTemporaryPin");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userHasTemporaryPin"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
