/**
 * CellReplacement.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines a cell replacement element for the cell alphabet
 *                         in a card, temporary PIN, or one-time password
 * (OTP).
 *                         Basically, this represents a mapping from
 * a character
 *                         not in the given alphabet to a character in
 * the alphabet.
 *                         <p>
 *                         This is useful in cases where multiple characters
 * that may
 *                         be entered by a user should be treated as
 * the same character.
 *                         For example, '0' is easily confused with 'o'
 * and 'O', so
 *                         you may define a cell alphabet containing
 * the character '0',
 *                         and have cell replacements mapping 'o' to
 * '0', and 'O' to
 *                         '0', making all of these characters equivalent
 * for
 *                         authentication purposes.
 */
public class CellReplacement  implements java.io.Serializable {
    /* The character to be replaced. This character
     *                                 must not appear in the cell alphabet
     * that the
     *                                 replacement is being applied to. */
    private String from;

    /* The character it is replaced with. This character
     *                                 must appear in the cell alphabet that
     * the
     *                                 replacement is being applied to. */
    private String to;

    public CellReplacement() {
    }

    public CellReplacement(
           String from,
           String to) {
           this.from = from;
           this.to = to;
    }


    /**
     * Gets the from value for this CellReplacement.
     * 
     * @return from   * The character to be replaced. This character
     *                                 must not appear in the cell alphabet
     * that the
     *                                 replacement is being applied to.
     */
    public String getFrom() {
        return from;
    }


    /**
     * Sets the from value for this CellReplacement.
     * 
     * @param from   * The character to be replaced. This character
     *                                 must not appear in the cell alphabet
     * that the
     *                                 replacement is being applied to.
     */
    public void setFrom(String from) {
        this.from = from;
    }


    /**
     * Gets the to value for this CellReplacement.
     * 
     * @return to   * The character it is replaced with. This character
     *                                 must appear in the cell alphabet that
     * the
     *                                 replacement is being applied to.
     */
    public String getTo() {
        return to;
    }


    /**
     * Sets the to value for this CellReplacement.
     * 
     * @param to   * The character it is replaced with. This character
     *                                 must appear in the cell alphabet that
     * the
     *                                 replacement is being applied to.
     */
    public void setTo(String to) {
        this.to = to;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CellReplacement)) return false;
        CellReplacement other = (CellReplacement) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.from==null && other.getFrom()==null) || 
             (this.from!=null &&
              this.from.equals(other.getFrom()))) &&
            ((this.to==null && other.getTo()==null) || 
             (this.to!=null &&
              this.to.equals(other.getTo())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getFrom() != null) {
            _hashCode += getFrom().hashCode();
        }
        if (getTo() != null) {
            _hashCode += getTo().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CellReplacement.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("from");
        elemField.setXmlName(new javax.xml.namespace.QName("", "from"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("to");
        elemField.setXmlName(new javax.xml.namespace.QName("", "to"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
