/**
 * CardSpecInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines a card specification policy. These values
 *                         control how cards are used for authentication
 * and how
 *                         new cards are created.
 */
public class CardSpecInfo  implements java.io.Serializable {
    /* The name of the card specification policy. */
    private String name;

    /* The number of rows in cards created using this policy. */
    private int numRows;

    /* The number of columns in cards created using this policy. */
    private int numColumns;

    /* The number of characters in each cell of cards created using
     * this policy. */
    private int cellSize;

    /* The characters that can appear in a card cell. */
    private String[] cellAlphabet;

    /* A list of characters that are replaced in a challenge
     *                                 response before it is validated. */
    private CellReplacement[] cellReplacements;

    /* The number of cells in a challenge. */
    private int challengeSize;

    /* The minimum number of cells in a challenge. */
    private int minChallengeSize;

    /* The maximum number of cells in a challenge. */
    private int maxChallengeSize;

    /* The lifetime in days of a card created using
     *                                 this policy. A value of 0
     *                                 indicates that the card has infinite
     * lifetime. */
    private long lifetime;

    /* The amount of time in days that a superseded
     *                                 card can be used after it is superseded.
     * A value of 0
     *                                 indicates that it can be used indefinitely. */
    private long supersede;

    /* If true, challenges are sorted by column/row after
     *                                 generation. This makes it easier for
     * people to
     *                                 respond to the challenge. */
    private boolean sortChallenge;

    /* If false, the hasPin flag and serial number list
     *                                 are not included in challenges. */
    private boolean userInfoInChallenge;

    /* If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer. */
    private boolean disableChallengeRetention;

    /* Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private int challengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true. */
    private boolean updateLockoutForReplacedChallenge;

    /* If true, anonymous authentication operations are not
     *                                 allowed. */
    private boolean disableAnonymousAuth;

    /* Identifies the challenge generation algorithm being
     *                                 used. */
    private ChallengeGenAlg challengeGenAlg;

    /* Indicates whether or not usage statistics are being
     *                                 gathered. This only applies when the
     * RANDOM challenge
     *                                 generation algorithm is being used.
     * When the
     *                                 LEASTUSED challenge generation algorithm
     * is
     *                                 being used, usage statistics are always
     * gathered, regardless
     *                                 of this setting. */
    private boolean gatherUsageStatistics;

    /* Indicates the minimum number of least used cells that
     *                                 will be included in every generated
     * challenge. Only
     *                                 applies when the LEASTUSED challenge
     * generation
     *                                 algorithm is being used. */
    private int leastUsedCellsPerChallenge;

    /* The challenge count warning threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, a warning will be logged
     * each time
     *                                 the card is used to authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it should be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true. */
    private int challengeCountWarningThreshold;

    /* The challenge count replacement threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, the card will be moved
     * to the HOLD
     *                                 state and can no longer be used to
     * authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it must be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true. */
    private int challengeCountReplacementThreshold;

    /* The least used cell warning threshold. The least used
     *                                 cell in a card is the cell that has
     * been appeared the
     *                                 least number of times in a successfully
     * authenticated
     *                                 challenge. When the least used cell
     * in a card has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 a warning will be logged each time
     * the card is used to authenticate. The card should be
     *                                 replaced at this point. */
    private int leastUsedCellWarningThreshold;

    /* The least used cell replacement threshold.
     *                                 When the least used cell in a card
     * has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 the card will be moved to the HOLD
     * state and can
     *                                 no longer be used to authenticate.
     * The card must be replaced at this point. */
    private int leastUsedCellReplacementThreshold;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments. */
    private String comment;

    public CardSpecInfo() {
    }

    public CardSpecInfo(
           String name,
           int numRows,
           int numColumns,
           int cellSize,
           String[] cellAlphabet,
           CellReplacement[] cellReplacements,
           int challengeSize,
           int minChallengeSize,
           int maxChallengeSize,
           long lifetime,
           long supersede,
           boolean sortChallenge,
           boolean userInfoInChallenge,
           boolean disableChallengeRetention,
           int challengeLifetime,
           boolean updateLockoutForReplacedChallenge,
           boolean disableAnonymousAuth,
           ChallengeGenAlg challengeGenAlg,
           boolean gatherUsageStatistics,
           int leastUsedCellsPerChallenge,
           int challengeCountWarningThreshold,
           int challengeCountReplacementThreshold,
           int leastUsedCellWarningThreshold,
           int leastUsedCellReplacementThreshold,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.numRows = numRows;
           this.numColumns = numColumns;
           this.cellSize = cellSize;
           this.cellAlphabet = cellAlphabet;
           this.cellReplacements = cellReplacements;
           this.challengeSize = challengeSize;
           this.minChallengeSize = minChallengeSize;
           this.maxChallengeSize = maxChallengeSize;
           this.lifetime = lifetime;
           this.supersede = supersede;
           this.sortChallenge = sortChallenge;
           this.userInfoInChallenge = userInfoInChallenge;
           this.disableChallengeRetention = disableChallengeRetention;
           this.challengeLifetime = challengeLifetime;
           this.updateLockoutForReplacedChallenge = updateLockoutForReplacedChallenge;
           this.disableAnonymousAuth = disableAnonymousAuth;
           this.challengeGenAlg = challengeGenAlg;
           this.gatherUsageStatistics = gatherUsageStatistics;
           this.leastUsedCellsPerChallenge = leastUsedCellsPerChallenge;
           this.challengeCountWarningThreshold = challengeCountWarningThreshold;
           this.challengeCountReplacementThreshold = challengeCountReplacementThreshold;
           this.leastUsedCellWarningThreshold = leastUsedCellWarningThreshold;
           this.leastUsedCellReplacementThreshold = leastUsedCellReplacementThreshold;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this CardSpecInfo.
     * 
     * @return name   * The name of the card specification policy.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this CardSpecInfo.
     * 
     * @param name   * The name of the card specification policy.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the numRows value for this CardSpecInfo.
     * 
     * @return numRows   * The number of rows in cards created using this policy.
     */
    public int getNumRows() {
        return numRows;
    }


    /**
     * Sets the numRows value for this CardSpecInfo.
     * 
     * @param numRows   * The number of rows in cards created using this policy.
     */
    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }


    /**
     * Gets the numColumns value for this CardSpecInfo.
     * 
     * @return numColumns   * The number of columns in cards created using this policy.
     */
    public int getNumColumns() {
        return numColumns;
    }


    /**
     * Sets the numColumns value for this CardSpecInfo.
     * 
     * @param numColumns   * The number of columns in cards created using this policy.
     */
    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }


    /**
     * Gets the cellSize value for this CardSpecInfo.
     * 
     * @return cellSize   * The number of characters in each cell of cards created using
     * this policy.
     */
    public int getCellSize() {
        return cellSize;
    }


    /**
     * Sets the cellSize value for this CardSpecInfo.
     * 
     * @param cellSize   * The number of characters in each cell of cards created using
     * this policy.
     */
    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }


    /**
     * Gets the cellAlphabet value for this CardSpecInfo.
     * 
     * @return cellAlphabet   * The characters that can appear in a card cell.
     */
    public String[] getCellAlphabet() {
        return cellAlphabet;
    }


    /**
     * Sets the cellAlphabet value for this CardSpecInfo.
     * 
     * @param cellAlphabet   * The characters that can appear in a card cell.
     */
    public void setCellAlphabet(String[] cellAlphabet) {
        this.cellAlphabet = cellAlphabet;
    }


    /**
     * Gets the cellReplacements value for this CardSpecInfo.
     * 
     * @return cellReplacements   * A list of characters that are replaced in a challenge
     *                                 response before it is validated.
     */
    public CellReplacement[] getCellReplacements() {
        return cellReplacements;
    }


    /**
     * Sets the cellReplacements value for this CardSpecInfo.
     * 
     * @param cellReplacements   * A list of characters that are replaced in a challenge
     *                                 response before it is validated.
     */
    public void setCellReplacements(CellReplacement[] cellReplacements) {
        this.cellReplacements = cellReplacements;
    }


    /**
     * Gets the challengeSize value for this CardSpecInfo.
     * 
     * @return challengeSize   * The number of cells in a challenge.
     */
    public int getChallengeSize() {
        return challengeSize;
    }


    /**
     * Sets the challengeSize value for this CardSpecInfo.
     * 
     * @param challengeSize   * The number of cells in a challenge.
     */
    public void setChallengeSize(int challengeSize) {
        this.challengeSize = challengeSize;
    }


    /**
     * Gets the minChallengeSize value for this CardSpecInfo.
     * 
     * @return minChallengeSize   * The minimum number of cells in a challenge.
     */
    public int getMinChallengeSize() {
        return minChallengeSize;
    }


    /**
     * Sets the minChallengeSize value for this CardSpecInfo.
     * 
     * @param minChallengeSize   * The minimum number of cells in a challenge.
     */
    public void setMinChallengeSize(int minChallengeSize) {
        this.minChallengeSize = minChallengeSize;
    }


    /**
     * Gets the maxChallengeSize value for this CardSpecInfo.
     * 
     * @return maxChallengeSize   * The maximum number of cells in a challenge.
     */
    public int getMaxChallengeSize() {
        return maxChallengeSize;
    }


    /**
     * Sets the maxChallengeSize value for this CardSpecInfo.
     * 
     * @param maxChallengeSize   * The maximum number of cells in a challenge.
     */
    public void setMaxChallengeSize(int maxChallengeSize) {
        this.maxChallengeSize = maxChallengeSize;
    }


    /**
     * Gets the lifetime value for this CardSpecInfo.
     * 
     * @return lifetime   * The lifetime in days of a card created using
     *                                 this policy. A value of 0
     *                                 indicates that the card has infinite
     * lifetime.
     */
    public long getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this CardSpecInfo.
     * 
     * @param lifetime   * The lifetime in days of a card created using
     *                                 this policy. A value of 0
     *                                 indicates that the card has infinite
     * lifetime.
     */
    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the supersede value for this CardSpecInfo.
     * 
     * @return supersede   * The amount of time in days that a superseded
     *                                 card can be used after it is superseded.
     * A value of 0
     *                                 indicates that it can be used indefinitely.
     */
    public long getSupersede() {
        return supersede;
    }


    /**
     * Sets the supersede value for this CardSpecInfo.
     * 
     * @param supersede   * The amount of time in days that a superseded
     *                                 card can be used after it is superseded.
     * A value of 0
     *                                 indicates that it can be used indefinitely.
     */
    public void setSupersede(long supersede) {
        this.supersede = supersede;
    }


    /**
     * Gets the sortChallenge value for this CardSpecInfo.
     * 
     * @return sortChallenge   * If true, challenges are sorted by column/row after
     *                                 generation. This makes it easier for
     * people to
     *                                 respond to the challenge.
     */
    public boolean isSortChallenge() {
        return sortChallenge;
    }


    /**
     * Sets the sortChallenge value for this CardSpecInfo.
     * 
     * @param sortChallenge   * If true, challenges are sorted by column/row after
     *                                 generation. This makes it easier for
     * people to
     *                                 respond to the challenge.
     */
    public void setSortChallenge(boolean sortChallenge) {
        this.sortChallenge = sortChallenge;
    }


    /**
     * Gets the userInfoInChallenge value for this CardSpecInfo.
     * 
     * @return userInfoInChallenge   * If false, the hasPin flag and serial number list
     *                                 are not included in challenges.
     */
    public boolean isUserInfoInChallenge() {
        return userInfoInChallenge;
    }


    /**
     * Sets the userInfoInChallenge value for this CardSpecInfo.
     * 
     * @param userInfoInChallenge   * If false, the hasPin flag and serial number list
     *                                 are not included in challenges.
     */
    public void setUserInfoInChallenge(boolean userInfoInChallenge) {
        this.userInfoInChallenge = userInfoInChallenge;
    }


    /**
     * Gets the disableChallengeRetention value for this CardSpecInfo.
     * 
     * @return disableChallengeRetention   * If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer.
     */
    public boolean isDisableChallengeRetention() {
        return disableChallengeRetention;
    }


    /**
     * Sets the disableChallengeRetention value for this CardSpecInfo.
     * 
     * @param disableChallengeRetention   * If true, challenge retention is disabled for
     *                                 GRID challenges.  This means a new
     * challenge
     *                                 will be generated for every challenge
     * request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows part of the GRID to request
     * different
     *                                 challenges until they receive a challenge
     * that they can answer.
     */
    public void setDisableChallengeRetention(boolean disableChallengeRetention) {
        this.disableChallengeRetention = disableChallengeRetention;
    }


    /**
     * Gets the challengeLifetime value for this CardSpecInfo.
     * 
     * @return challengeLifetime   * Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public int getChallengeLifetime() {
        return challengeLifetime;
    }


    /**
     * Sets the challengeLifetime value for this CardSpecInfo.
     * 
     * @param challengeLifetime   * Specifies the GRID challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setChallengeLifetime(int challengeLifetime) {
        this.challengeLifetime = challengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedChallenge value for this CardSpecInfo.
     * 
     * @return updateLockoutForReplacedChallenge   * If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public boolean isUpdateLockoutForReplacedChallenge() {
        return updateLockoutForReplacedChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedChallenge value for this CardSpecInfo.
     * 
     * @param updateLockoutForReplacedChallenge   * If true, the lockout count is updated when
     *                                 an existing GRID challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public void setUpdateLockoutForReplacedChallenge(boolean updateLockoutForReplacedChallenge) {
        this.updateLockoutForReplacedChallenge = updateLockoutForReplacedChallenge;
    }


    /**
     * Gets the disableAnonymousAuth value for this CardSpecInfo.
     * 
     * @return disableAnonymousAuth   * If true, anonymous authentication operations are not
     *                                 allowed.
     */
    public boolean isDisableAnonymousAuth() {
        return disableAnonymousAuth;
    }


    /**
     * Sets the disableAnonymousAuth value for this CardSpecInfo.
     * 
     * @param disableAnonymousAuth   * If true, anonymous authentication operations are not
     *                                 allowed.
     */
    public void setDisableAnonymousAuth(boolean disableAnonymousAuth) {
        this.disableAnonymousAuth = disableAnonymousAuth;
    }


    /**
     * Gets the challengeGenAlg value for this CardSpecInfo.
     * 
     * @return challengeGenAlg   * Identifies the challenge generation algorithm being
     *                                 used.
     */
    public ChallengeGenAlg getChallengeGenAlg() {
        return challengeGenAlg;
    }


    /**
     * Sets the challengeGenAlg value for this CardSpecInfo.
     * 
     * @param challengeGenAlg   * Identifies the challenge generation algorithm being
     *                                 used.
     */
    public void setChallengeGenAlg(ChallengeGenAlg challengeGenAlg) {
        this.challengeGenAlg = challengeGenAlg;
    }


    /**
     * Gets the gatherUsageStatistics value for this CardSpecInfo.
     * 
     * @return gatherUsageStatistics   * Indicates whether or not usage statistics are being
     *                                 gathered. This only applies when the
     * RANDOM challenge
     *                                 generation algorithm is being used.
     * When the
     *                                 LEASTUSED challenge generation algorithm
     * is
     *                                 being used, usage statistics are always
     * gathered, regardless
     *                                 of this setting.
     */
    public boolean isGatherUsageStatistics() {
        return gatherUsageStatistics;
    }


    /**
     * Sets the gatherUsageStatistics value for this CardSpecInfo.
     * 
     * @param gatherUsageStatistics   * Indicates whether or not usage statistics are being
     *                                 gathered. This only applies when the
     * RANDOM challenge
     *                                 generation algorithm is being used.
     * When the
     *                                 LEASTUSED challenge generation algorithm
     * is
     *                                 being used, usage statistics are always
     * gathered, regardless
     *                                 of this setting.
     */
    public void setGatherUsageStatistics(boolean gatherUsageStatistics) {
        this.gatherUsageStatistics = gatherUsageStatistics;
    }


    /**
     * Gets the leastUsedCellsPerChallenge value for this CardSpecInfo.
     * 
     * @return leastUsedCellsPerChallenge   * Indicates the minimum number of least used cells that
     *                                 will be included in every generated
     * challenge. Only
     *                                 applies when the LEASTUSED challenge
     * generation
     *                                 algorithm is being used.
     */
    public int getLeastUsedCellsPerChallenge() {
        return leastUsedCellsPerChallenge;
    }


    /**
     * Sets the leastUsedCellsPerChallenge value for this CardSpecInfo.
     * 
     * @param leastUsedCellsPerChallenge   * Indicates the minimum number of least used cells that
     *                                 will be included in every generated
     * challenge. Only
     *                                 applies when the LEASTUSED challenge
     * generation
     *                                 algorithm is being used.
     */
    public void setLeastUsedCellsPerChallenge(int leastUsedCellsPerChallenge) {
        this.leastUsedCellsPerChallenge = leastUsedCellsPerChallenge;
    }


    /**
     * Gets the challengeCountWarningThreshold value for this CardSpecInfo.
     * 
     * @return challengeCountWarningThreshold   * The challenge count warning threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, a warning will be logged
     * each time
     *                                 the card is used to authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it should be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true.
     */
    public int getChallengeCountWarningThreshold() {
        return challengeCountWarningThreshold;
    }


    /**
     * Sets the challengeCountWarningThreshold value for this CardSpecInfo.
     * 
     * @param challengeCountWarningThreshold   * The challenge count warning threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, a warning will be logged
     * each time
     *                                 the card is used to authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it should be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true.
     */
    public void setChallengeCountWarningThreshold(int challengeCountWarningThreshold) {
        this.challengeCountWarningThreshold = challengeCountWarningThreshold;
    }


    /**
     * Gets the challengeCountReplacementThreshold value for this CardSpecInfo.
     * 
     * @return challengeCountReplacementThreshold   * The challenge count replacement threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, the card will be moved
     * to the HOLD
     *                                 state and can no longer be used to
     * authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it must be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true.
     */
    public int getChallengeCountReplacementThreshold() {
        return challengeCountReplacementThreshold;
    }


    /**
     * Sets the challengeCountReplacementThreshold value for this CardSpecInfo.
     * 
     * @param challengeCountReplacementThreshold   * The challenge count replacement threshold; represents a
     *                                 number of challenges that can be generated
     * for
     *                                 a card and used to authenticate and
     * when this number
     *                                 is reached, the card will be moved
     * to the HOLD
     *                                 state and can no longer be used to
     * authenticate.
     *                                 Once a card has been used to authenticate
     * this
     *                                 many challenges it must be replaced.
     * <p>
     *                                 This threshold is used for the LEASTUSED
     * challenge
     *                                 algorithm, or the RANDOM algorithm
     * when gatherUsageStatistics
     *                                 has been set to true.
     */
    public void setChallengeCountReplacementThreshold(int challengeCountReplacementThreshold) {
        this.challengeCountReplacementThreshold = challengeCountReplacementThreshold;
    }


    /**
     * Gets the leastUsedCellWarningThreshold value for this CardSpecInfo.
     * 
     * @return leastUsedCellWarningThreshold   * The least used cell warning threshold. The least used
     *                                 cell in a card is the cell that has
     * been appeared the
     *                                 least number of times in a successfully
     * authenticated
     *                                 challenge. When the least used cell
     * in a card has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 a warning will be logged each time
     * the card is used to authenticate. The card should be
     *                                 replaced at this point.
     */
    public int getLeastUsedCellWarningThreshold() {
        return leastUsedCellWarningThreshold;
    }


    /**
     * Sets the leastUsedCellWarningThreshold value for this CardSpecInfo.
     * 
     * @param leastUsedCellWarningThreshold   * The least used cell warning threshold. The least used
     *                                 cell in a card is the cell that has
     * been appeared the
     *                                 least number of times in a successfully
     * authenticated
     *                                 challenge. When the least used cell
     * in a card has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 a warning will be logged each time
     * the card is used to authenticate. The card should be
     *                                 replaced at this point.
     */
    public void setLeastUsedCellWarningThreshold(int leastUsedCellWarningThreshold) {
        this.leastUsedCellWarningThreshold = leastUsedCellWarningThreshold;
    }


    /**
     * Gets the leastUsedCellReplacementThreshold value for this CardSpecInfo.
     * 
     * @return leastUsedCellReplacementThreshold   * The least used cell replacement threshold.
     *                                 When the least used cell in a card
     * has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 the card will be moved to the HOLD
     * state and can
     *                                 no longer be used to authenticate.
     * The card must be replaced at this point.
     */
    public int getLeastUsedCellReplacementThreshold() {
        return leastUsedCellReplacementThreshold;
    }


    /**
     * Sets the leastUsedCellReplacementThreshold value for this CardSpecInfo.
     * 
     * @param leastUsedCellReplacementThreshold   * The least used cell replacement threshold.
     *                                 When the least used cell in a card
     * has
     *                                 been used a number of times equal
     * to this threshold,
     *                                 the card will be moved to the HOLD
     * state and can
     *                                 no longer be used to authenticate.
     * The card must be replaced at this point.
     */
    public void setLeastUsedCellReplacementThreshold(int leastUsedCellReplacementThreshold) {
        this.leastUsedCellReplacementThreshold = leastUsedCellReplacementThreshold;
    }


    /**
     * Gets the rolesGrantingAccess value for this CardSpecInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this CardSpecInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this CardSpecInfo.
     * 
     * @return comment   * Descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this CardSpecInfo.
     * 
     * @param comment   * Descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CardSpecInfo)) return false;
        CardSpecInfo other = (CardSpecInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            this.numRows == other.getNumRows() &&
            this.numColumns == other.getNumColumns() &&
            this.cellSize == other.getCellSize() &&
            ((this.cellAlphabet==null && other.getCellAlphabet()==null) || 
             (this.cellAlphabet!=null &&
              java.util.Arrays.equals(this.cellAlphabet, other.getCellAlphabet()))) &&
            ((this.cellReplacements==null && other.getCellReplacements()==null) || 
             (this.cellReplacements!=null &&
              java.util.Arrays.equals(this.cellReplacements, other.getCellReplacements()))) &&
            this.challengeSize == other.getChallengeSize() &&
            this.minChallengeSize == other.getMinChallengeSize() &&
            this.maxChallengeSize == other.getMaxChallengeSize() &&
            this.lifetime == other.getLifetime() &&
            this.supersede == other.getSupersede() &&
            this.sortChallenge == other.isSortChallenge() &&
            this.userInfoInChallenge == other.isUserInfoInChallenge() &&
            this.disableChallengeRetention == other.isDisableChallengeRetention() &&
            this.challengeLifetime == other.getChallengeLifetime() &&
            this.updateLockoutForReplacedChallenge == other.isUpdateLockoutForReplacedChallenge() &&
            this.disableAnonymousAuth == other.isDisableAnonymousAuth() &&
            ((this.challengeGenAlg==null && other.getChallengeGenAlg()==null) || 
             (this.challengeGenAlg!=null &&
              this.challengeGenAlg.equals(other.getChallengeGenAlg()))) &&
            this.gatherUsageStatistics == other.isGatherUsageStatistics() &&
            this.leastUsedCellsPerChallenge == other.getLeastUsedCellsPerChallenge() &&
            this.challengeCountWarningThreshold == other.getChallengeCountWarningThreshold() &&
            this.challengeCountReplacementThreshold == other.getChallengeCountReplacementThreshold() &&
            this.leastUsedCellWarningThreshold == other.getLeastUsedCellWarningThreshold() &&
            this.leastUsedCellReplacementThreshold == other.getLeastUsedCellReplacementThreshold() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        _hashCode += getNumRows();
        _hashCode += getNumColumns();
        _hashCode += getCellSize();
        if (getCellAlphabet() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellAlphabet());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellAlphabet(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCellReplacements() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCellReplacements());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCellReplacements(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getChallengeSize();
        _hashCode += getMinChallengeSize();
        _hashCode += getMaxChallengeSize();
        _hashCode += new Long(getLifetime()).hashCode();
        _hashCode += new Long(getSupersede()).hashCode();
        _hashCode += (isSortChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isUserInfoInChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isDisableChallengeRetention() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getChallengeLifetime();
        _hashCode += (isUpdateLockoutForReplacedChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isDisableAnonymousAuth() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getChallengeGenAlg() != null) {
            _hashCode += getChallengeGenAlg().hashCode();
        }
        _hashCode += (isGatherUsageStatistics() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getLeastUsedCellsPerChallenge();
        _hashCode += getChallengeCountWarningThreshold();
        _hashCode += getChallengeCountReplacementThreshold();
        _hashCode += getLeastUsedCellWarningThreshold();
        _hashCode += getLeastUsedCellReplacementThreshold();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CardSpecInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CardSpecInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numRows");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numRows"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numColumns");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numColumns"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cellReplacements");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cellReplacements"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supersede");
        elemField.setXmlName(new javax.xml.namespace.QName("", "supersede"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sortChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "sortChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userInfoInChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userInfoInChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableAnonymousAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableAnonymousAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeGenAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeGenAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ChallengeGenAlg"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("gatherUsageStatistics");
        elemField.setXmlName(new javax.xml.namespace.QName("", "gatherUsageStatistics"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellsPerChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellsPerChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeCountWarningThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeCountWarningThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeCountReplacementThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challengeCountReplacementThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellWarningThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellWarningThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellReplacementThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "leastUsedCellReplacementThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
