/**
 * CACertificateInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the information returned about a CA
 *                         certificate
 */
public class CACertificateInfo  implements java.io.Serializable {
    /* The name of the CA certificate. */
    private String name;

    /* The state of the CA certificate. */
    private CertificateState state;

    /* The subject DN of the CA certificate. */
    private String subjectDN;

    /* The issuer DN of the CA certificate. */
    private String issuerDN;

    /* The serial number of the CA certificate. */
    private String serialNumber;

    /* The issue date of the CA certificate. */
    private java.util.Calendar issueDate;

    /* The expiry date of the CA certificate. */
    private java.util.Calendar expiryDate;

    /* If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true. */
    private boolean LDAPUseURLCDP;

    /* The LDAP URL for this CA certificate.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required. */
    private String LDAPURL;

    /* The LDAP User DN for this CA certificate.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used. */
    private String LDAPUserDN;

    /* A flag indicating whether this CA Certificate
     *                                 has a LDAP User Password set.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used. */
    private boolean LDAPHasUserPassword;

    /* The OCSP URL for this CA certificate.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking. */
    private String OCSPURL;

    /* A flag indicating whether the AIA extension
     *                                 of certificates should be used to
     * locate
     *                                 the OCSP server which is used to retrieve
     * certificate revocation information.
     *                                 If OCSPUseAIA is set to false and
     * an OCSPURL
     *                                 value isn't specified, then OCSP is
     * not used
     *                                 to perform revocation checking. */
    private boolean OCSPUseAIA;

    /* The comment for this CA certificate. */
    private String comment;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    public CACertificateInfo() {
    }

    public CACertificateInfo(
           String name,
           CertificateState state,
           String subjectDN,
           String issuerDN,
           String serialNumber,
           java.util.Calendar issueDate,
           java.util.Calendar expiryDate,
           boolean LDAPUseURLCDP,
           String LDAPURL,
           String LDAPUserDN,
           boolean LDAPHasUserPassword,
           String OCSPURL,
           boolean OCSPUseAIA,
           String comment,
           String[] rolesGrantingAccess) {
           this.name = name;
           this.state = state;
           this.subjectDN = subjectDN;
           this.issuerDN = issuerDN;
           this.serialNumber = serialNumber;
           this.issueDate = issueDate;
           this.expiryDate = expiryDate;
           this.LDAPUseURLCDP = LDAPUseURLCDP;
           this.LDAPURL = LDAPURL;
           this.LDAPUserDN = LDAPUserDN;
           this.LDAPHasUserPassword = LDAPHasUserPassword;
           this.OCSPURL = OCSPURL;
           this.OCSPUseAIA = OCSPUseAIA;
           this.comment = comment;
           this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the name value for this CACertificateInfo.
     * 
     * @return name   * The name of the CA certificate.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this CACertificateInfo.
     * 
     * @param name   * The name of the CA certificate.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the state value for this CACertificateInfo.
     * 
     * @return state   * The state of the CA certificate.
     */
    public CertificateState getState() {
        return state;
    }


    /**
     * Sets the state value for this CACertificateInfo.
     * 
     * @param state   * The state of the CA certificate.
     */
    public void setState(CertificateState state) {
        this.state = state;
    }


    /**
     * Gets the subjectDN value for this CACertificateInfo.
     * 
     * @return subjectDN   * The subject DN of the CA certificate.
     */
    public String getSubjectDN() {
        return subjectDN;
    }


    /**
     * Sets the subjectDN value for this CACertificateInfo.
     * 
     * @param subjectDN   * The subject DN of the CA certificate.
     */
    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }


    /**
     * Gets the issuerDN value for this CACertificateInfo.
     * 
     * @return issuerDN   * The issuer DN of the CA certificate.
     */
    public String getIssuerDN() {
        return issuerDN;
    }


    /**
     * Sets the issuerDN value for this CACertificateInfo.
     * 
     * @param issuerDN   * The issuer DN of the CA certificate.
     */
    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }


    /**
     * Gets the serialNumber value for this CACertificateInfo.
     * 
     * @return serialNumber   * The serial number of the CA certificate.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this CACertificateInfo.
     * 
     * @param serialNumber   * The serial number of the CA certificate.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the issueDate value for this CACertificateInfo.
     * 
     * @return issueDate   * The issue date of the CA certificate.
     */
    public java.util.Calendar getIssueDate() {
        return issueDate;
    }


    /**
     * Sets the issueDate value for this CACertificateInfo.
     * 
     * @param issueDate   * The issue date of the CA certificate.
     */
    public void setIssueDate(java.util.Calendar issueDate) {
        this.issueDate = issueDate;
    }


    /**
     * Gets the expiryDate value for this CACertificateInfo.
     * 
     * @return expiryDate   * The expiry date of the CA certificate.
     */
    public java.util.Calendar getExpiryDate() {
        return expiryDate;
    }


    /**
     * Sets the expiryDate value for this CACertificateInfo.
     * 
     * @param expiryDate   * The expiry date of the CA certificate.
     */
    public void setExpiryDate(java.util.Calendar expiryDate) {
        this.expiryDate = expiryDate;
    }


    /**
     * Gets the LDAPUseURLCDP value for this CACertificateInfo.
     * 
     * @return LDAPUseURLCDP   * If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true.
     */
    public boolean isLDAPUseURLCDP() {
        return LDAPUseURLCDP;
    }


    /**
     * Sets the LDAPUseURLCDP value for this CACertificateInfo.
     * 
     * @param LDAPUseURLCDP   * If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true.
     */
    public void setLDAPUseURLCDP(boolean LDAPUseURLCDP) {
        this.LDAPUseURLCDP = LDAPUseURLCDP;
    }


    /**
     * Gets the LDAPURL value for this CACertificateInfo.
     * 
     * @return LDAPURL   * The LDAP URL for this CA certificate.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required.
     */
    public String getLDAPURL() {
        return LDAPURL;
    }


    /**
     * Sets the LDAPURL value for this CACertificateInfo.
     * 
     * @param LDAPURL   * The LDAP URL for this CA certificate.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required.
     */
    public void setLDAPURL(String LDAPURL) {
        this.LDAPURL = LDAPURL;
    }


    /**
     * Gets the LDAPUserDN value for this CACertificateInfo.
     * 
     * @return LDAPUserDN   * The LDAP User DN for this CA certificate.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used.
     */
    public String getLDAPUserDN() {
        return LDAPUserDN;
    }


    /**
     * Sets the LDAPUserDN value for this CACertificateInfo.
     * 
     * @param LDAPUserDN   * The LDAP User DN for this CA certificate.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used.
     */
    public void setLDAPUserDN(String LDAPUserDN) {
        this.LDAPUserDN = LDAPUserDN;
    }


    /**
     * Gets the LDAPHasUserPassword value for this CACertificateInfo.
     * 
     * @return LDAPHasUserPassword   * A flag indicating whether this CA Certificate
     *                                 has a LDAP User Password set.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used.
     */
    public boolean isLDAPHasUserPassword() {
        return LDAPHasUserPassword;
    }


    /**
     * Sets the LDAPHasUserPassword value for this CACertificateInfo.
     * 
     * @param LDAPHasUserPassword   * A flag indicating whether this CA Certificate
     *                                 has a LDAP User Password set.
     *                                 If specified, the User DN and password
     * values are used to authenticate to the LDAP
     *                                 server.  If not specified, anonymous
     * binding
     *                                 is used.
     */
    public void setLDAPHasUserPassword(boolean LDAPHasUserPassword) {
        this.LDAPHasUserPassword = LDAPHasUserPassword;
    }


    /**
     * Gets the OCSPURL value for this CACertificateInfo.
     * 
     * @return OCSPURL   * The OCSP URL for this CA certificate.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public String getOCSPURL() {
        return OCSPURL;
    }


    /**
     * Sets the OCSPURL value for this CACertificateInfo.
     * 
     * @param OCSPURL   * The OCSP URL for this CA certificate.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public void setOCSPURL(String OCSPURL) {
        this.OCSPURL = OCSPURL;
    }


    /**
     * Gets the OCSPUseAIA value for this CACertificateInfo.
     * 
     * @return OCSPUseAIA   * A flag indicating whether the AIA extension
     *                                 of certificates should be used to
     * locate
     *                                 the OCSP server which is used to retrieve
     * certificate revocation information.
     *                                 If OCSPUseAIA is set to false and
     * an OCSPURL
     *                                 value isn't specified, then OCSP is
     * not used
     *                                 to perform revocation checking.
     */
    public boolean isOCSPUseAIA() {
        return OCSPUseAIA;
    }


    /**
     * Sets the OCSPUseAIA value for this CACertificateInfo.
     * 
     * @param OCSPUseAIA   * A flag indicating whether the AIA extension
     *                                 of certificates should be used to
     * locate
     *                                 the OCSP server which is used to retrieve
     * certificate revocation information.
     *                                 If OCSPUseAIA is set to false and
     * an OCSPURL
     *                                 value isn't specified, then OCSP is
     * not used
     *                                 to perform revocation checking.
     */
    public void setOCSPUseAIA(boolean OCSPUseAIA) {
        this.OCSPUseAIA = OCSPUseAIA;
    }


    /**
     * Gets the comment value for this CACertificateInfo.
     * 
     * @return comment   * The comment for this CA certificate.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this CACertificateInfo.
     * 
     * @param comment   * The comment for this CA certificate.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }


    /**
     * Gets the rolesGrantingAccess value for this CACertificateInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this CACertificateInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CACertificateInfo)) return false;
        CACertificateInfo other = (CACertificateInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.subjectDN==null && other.getSubjectDN()==null) || 
             (this.subjectDN!=null &&
              this.subjectDN.equals(other.getSubjectDN()))) &&
            ((this.issuerDN==null && other.getIssuerDN()==null) || 
             (this.issuerDN!=null &&
              this.issuerDN.equals(other.getIssuerDN()))) &&
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.issueDate==null && other.getIssueDate()==null) || 
             (this.issueDate!=null &&
              this.issueDate.equals(other.getIssueDate()))) &&
            ((this.expiryDate==null && other.getExpiryDate()==null) || 
             (this.expiryDate!=null &&
              this.expiryDate.equals(other.getExpiryDate()))) &&
            this.LDAPUseURLCDP == other.isLDAPUseURLCDP() &&
            ((this.LDAPURL==null && other.getLDAPURL()==null) || 
             (this.LDAPURL!=null &&
              this.LDAPURL.equals(other.getLDAPURL()))) &&
            ((this.LDAPUserDN==null && other.getLDAPUserDN()==null) || 
             (this.LDAPUserDN!=null &&
              this.LDAPUserDN.equals(other.getLDAPUserDN()))) &&
            this.LDAPHasUserPassword == other.isLDAPHasUserPassword() &&
            ((this.OCSPURL==null && other.getOCSPURL()==null) || 
             (this.OCSPURL!=null &&
              this.OCSPURL.equals(other.getOCSPURL()))) &&
            this.OCSPUseAIA == other.isOCSPUseAIA() &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getSubjectDN() != null) {
            _hashCode += getSubjectDN().hashCode();
        }
        if (getIssuerDN() != null) {
            _hashCode += getIssuerDN().hashCode();
        }
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getIssueDate() != null) {
            _hashCode += getIssueDate().hashCode();
        }
        if (getExpiryDate() != null) {
            _hashCode += getExpiryDate().hashCode();
        }
        _hashCode += (isLDAPUseURLCDP() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getLDAPURL() != null) {
            _hashCode += getLDAPURL().hashCode();
        }
        if (getLDAPUserDN() != null) {
            _hashCode += getLDAPUserDN().hashCode();
        }
        _hashCode += (isLDAPHasUserPassword() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getOCSPURL() != null) {
            _hashCode += getOCSPURL().hashCode();
        }
        _hashCode += (isOCSPUseAIA() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CACertificateInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CACertificateInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "state"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CertificateState"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("subjectDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "subjectDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issuerDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "issuerDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "serialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("issueDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "issueDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expiryDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expiryDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPUseURLCDP");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPUseURLCDP"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPURL");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPURL"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPUserDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPUserDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPHasUserPassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPHasUserPassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OCSPURL");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OCSPURL"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OCSPUseAIA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OCSPUseAIA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
