package com.good.security.x509;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/**
 * Class provide creation of {@link org.springframework.security.core.userdetails.User} with credentials from {@link X509Certificate}.
 * 
 * @author Stanislav Kyfenko
 *         28.09.2015
 */
@Component
public class X509CustomAuthenticationProvider extends AbstractUserDetailsAuthenticationProvider {

    /**
     * Perform additional authentication checks. In current implementation this method doesn't do anything  
     */
    @Override
    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        //Do nothing
    }

    /**
     * Method generates {@link org.springframework.security.core.userdetails.User} using username and X509 certificate
     * 
     * @param username the username
     * @param authentication {@link javax.security.cert.X509Certificate}
     * @return {@link X509CustomUser}
     * @throws AuthenticationException doesn't throwed by this method
     */
    @Override
    protected X509CustomUser retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        List<GrantedAuthority> grantedAuths = new ArrayList<>();

        X509Certificate certificate = (X509Certificate) authentication.getPrincipal();

        return new X509CustomUser(certificate.getSubjectDN().getName(), "", grantedAuths);
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return (X509AuthenticationToken.class.isAssignableFrom(authentication));
    }
}
