package com.good.filters;

import com.good.config.SupportedOperations;
import com.good.domain.GenericData;
import com.good.domain.P12CertificateData;
import com.good.domain.P12CertificateFailure;
import com.good.filters.utils.DataSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Class handles all exceptions that can be thrown during filters or servlet work and generate proper JSON response.
 * <i>Note: this class should be executed before all other classes in {@link org.springframework.web.filter.DelegatingFilterProxy} filter chain.</i>
 * 
 * @author Ivan Bilyi
 * 29.10.2015.
 */
public class GlobalExceptionHandlerFilter extends GenericFilterBean {
    
    /**
     * Bean that is responsible for serialization of {@link P12CertificateData} into JSON
     */
    @Autowired
    private DataSerializer dataSerializer;

    /**
     * Method passes execution down through filter chain and in case of any exception generate proper response to the client.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        logger.debug("GlobalExceptionHandlerFilter");
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        } catch (AccessDeniedException e) {
            logger.error("Unknown exception was caught.", e);
            if (servletResponse instanceof HttpServletResponse) {
                if (SupportedOperations.GET_INFO.getValue().equalsIgnoreCase(servletRequest.getParameter("operation"))) {
                    ((HttpServletResponse) servletResponse).setStatus(HttpServletResponse.SC_UNAUTHORIZED);
                } else {
                    dataSerializer.writeResponse(new GenericData(P12CertificateFailure.getByValue(e.getMessage())), (HttpServletResponse) servletResponse);
                }
            }
        } catch (Exception e) {
            logger.error("Unknown exception was caught.", e);
            if (servletResponse instanceof HttpServletResponse) {
                dataSerializer.writeResponse(new GenericData(P12CertificateFailure.UNKNOWN), (HttpServletResponse) servletResponse);
            }
        }
    }
}
