package com.good.domain;

import com.fasterxml.jackson.annotation.JsonValue;

public enum StatusTypeEnum {
    SUCCESS("success"), FAILURE("failure");
    private final String val;

    StatusTypeEnum(String val) {
        this.val = val;
    }

    @JsonValue
    public String getValue() {
        return this.val;
    }

    public static StatusTypeEnum getByValue(String value) {

        StatusTypeEnum [] statusTypeEnums = values();
        for(StatusTypeEnum statusTypeEnum : statusTypeEnums) {
            if(statusTypeEnum.getValue().equals(value)) {
                return statusTypeEnum;
            }
        }
        return null;
    }
}
