package com.good.domain;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Class represents enumeration of all server failure reasons that is supported
 * 
 * @author Ivan Bilyi
 * 26.10.2015.
 */
public enum P12CertificateFailure {
    /**
     * User does not exist or is not allowed by PKI server. Currently doesn't supported
     */
    UNKNOWN_USER("unknownUser"),
    /**
     * Badly formatted request body
     */
    BAD_REQUEST("badRequest"),
    /**
     * Web endpoint doesn't found
     */
    UNKNOWN_REQUEST("unknownRequest"),
    /**
     * incorrect authToken
     */
    AUTH_FAILURE("authFailure"),
    /**
     * Unsupported/Unrecognized algorithm was specified. 
     * <i>This information should be in header. As header currently not supported, this exception also doesn't supported.</i>
     */
    BAD_ALG("badAlg"),
    /**
     * Certificate used for authentication not found
     */
    UNKNOWN_CERT("unknownCert"),
    /**
     * Signature/Integrity check failed
     * <i>This information should be in header. As header currently not supported, this exception also doesn't supported.</i>
     */
    BAD_MESSAGE_CHECK("badMessageCheck"),
    /**
     * Time in the signature was not close enough
     * <i>This information should be in header. As header currently not supported, this exception also doesn't supported.</i>
     */
    BAD_TIME("badTime"),
    /**
     * unknown server error.
     */
    UNKNOWN("unknown");
    
    private final String message;
    
    P12CertificateFailure(String message){
        this.message = message;
    }
    
    @JsonValue
    public String getValue() {
        return this.message;
    }
    
    public String toString(){
        return this.message;
    }

    /**
     * Get proper failure message for string. Will return null if no {@link P12CertificateFailure} was found.
     * 
     * @param value the failure message
     * @return the failure message
     */
    public static P12CertificateFailure getByValue(String value) {
        P12CertificateFailure [] allFilures = values();
        for(P12CertificateFailure failure : allFilures) {
            if(failure.message.equals(value)) {
                return failure;
            }
        }
        return null;
    }
}
