package com.good.config;

import com.good.service.CertificateServerService;

/**
 * Enum with all supported operations. New operations should be added here. This enum is used by
 * {@link CertificateServerService#getInfo()} for returning all the operations implemented by the connector server.
 * It is also used by {@link com.good.filters.validators.PathModificationValidator} for redirecting incoming calls
 * to the appropriate end point.
 */
public enum SupportedOperations {
    GET_USER_KEY_PAIR("getUserKeyPair"), GET_INFO("getInfo");
    private final String val;

    SupportedOperations(String val) {
        this.val = val;
    }

    public String getValue() {
        return this.val;
    }
    public static boolean contains(String operation){
        for(SupportedOperations op:values()){
            if (op.getValue().equals(operation)){
                return true;
            }
        }
        return false;
    }
}
