/**
 * UserSpecParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Parameters used to modify a user specification policy. All
 *                     parameters are optional.
 *                     <p>
 *                     Some of the parameters have
 *                     restrictions that are affected by other parameters
 * that
 *                     may or may not be set. In this case, when modifying
 * an existing
 *                     policy, the resulting policy must obey the restrictions
 * listed. For example, if only the QAChallengeSize parameter is
 *                     included, the resulting policy must obey the restrictions
 * placed on the QAChallengeSize.
 */
public class UserSpecParms  implements java.io.Serializable {
    /* The maximum number of aliases that can be assigned
     *                                to a user. A value of 0 means that
     * users are
     *                                not allowed to have aliases. */
    private Integer maxAliases;

    /* The maximum number of contact information entries that can
     * be
     *                             created for a user. A value of 0 means
     * that
     *                             no contact information can be stored for
     * a user. */
    private Integer maxContactInfoNumber;

    /* The authentication lockout mode. */
    private LockoutMode lockoutMode;

    /* The number of consecutive authentication failures allowed before
     * a
     *                             user is locked out.  A value of 0 means
     * the user is
     *                             never locked out, no matter how many times
     * they
     *                             fail to authenticate.
     *                             The various maxXXXFailures policies should
     * be used 
     *                             instead of this policy. */
    private Integer maxFailures;

    /* The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode. */
    private Integer maxGlobalFailures;

    /* The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxCertificateFailures;

    /* The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxExternalFailures;

    /* The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxGridFailures;

    /* The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxTokenCRFailures;

    /* The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxTokenROFailures;

    /* The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxOTPFailures;

    /* The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxQAFailures;

    /* The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxRBAIPAuthFailures;

    /* The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxRBAMachineAuthFailures;

    /* The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxRBACertificateAuthFailures;

    /* The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxRBAExternalRiskAuthFailures;

    /* The number of minutes a user remains locked.  A value
     *                             of 0 means the user remains locked until
     * unlocked by an
     *                             administrator.
     *                             This policy is used with the GLOBAL, ALL_AUTHENTICATOR
     * and
     *                             PER_AUTHENTICATOR lockout modes. */
    private Integer lockoutTime;

    /* The maximum size of the shared secrets for
     *                             a user, in kilobytes. A value of 0 means
     * that users are
     *                             not allowed to have shared secrets. */
    private Integer maxSecretSize;

    /* The maximum number of shared secrets for
     *                             a user. A value of 0 means that users
     * are
     *                             not allowed to have shared secrets. */
    private Integer maxSecretNumber;

    /* The type of authentications that can be used for
     *                             generic authentication operations with
     * a normal
     *                             security level. */
    private AuthenticationType[] genericAuthType;

    /* The type of authentications that can be used for
     *                             generic authentication operations with
     * an
     *                             enhanced security level. */
    private AuthenticationType[] enhancedGenericAuthType;

    /* The type of authentications that can be used for
     *                             machine registration authentication operations. */
    private AuthenticationType[] machineAuthType;

    /* The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE. */
    private AuthenticationType[] authTypeCanViewSecrets;

    /* The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE. */
    private AuthenticationType[] authTypeCanModifySecrets;

    /* The maximum number of machine secrets for
     *                             a user. A value of 0 means that no machine
     * secrets can be stored. */
    private Integer maxMachineSecrets;

    /* The maximum size of a single machine secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored. */
    private Integer maxMachineSecretsSize;

    /* A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              To set this flag to false, the
     *                              machineSecretRequiresAppData setting
     * must be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * must be 0. */
    private Boolean machineSecretRequiresMachineNonce;

    /* A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication. */
    private Boolean machineSecretRequiresSequenceNonce;

    /* A count indicating how many application data
     *                             values in a machine secret being used
     * for
     *                             authentication can be bad before
     *                             validation fails. */
    private Integer machineSecretRequiresAppData;

    /* A count indicating how many application data
     *                             values in the machine secret can be bad
     * before
     *                             validation fails. */
    private Integer machineSecretAllowsBadAppData;

    /* Machine secret lifetime in hours. This must be a
     *                             value between 0 and 876000 inclusive.
     * A value of 0
     *                             means infinite lifetime. */
    private Integer machineSecretLifetime;

    /* A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed. */
    private Boolean failedMachineAuthIncrementsLockout;

    /* The maximum number of authentication secrets for
     *                             a user. A value of 0 means that no
     *                             authentication secrets can be stored. */
    private Integer maxAuthSecrets;

    /* The maximum size of authentication secrets for a user,
     *                             in kilobytes. A value of 0 means that
     * no
     *                             authentication secrets can be stored. */
    private Integer maxAuthSecretsSize;

    /* The maximum number of questions and answer pairs for a
     *                             user. A value of 0 means that no question
     * and answer pairs can
     *                             be stored. */
    private Integer maxQuestions;

    /* The maximum size of questions and answer (QA) pairs stored
     * for a user,
     *                             in kilobytes. A value of 0 means that
     * no QA pairs can be stored. */
    private Integer maxQASize;

    /* The number of questions in a QA challenge. This value
     *                             must satisfy the restriction
     *                             1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize */
    private Integer QAChallengeSize;

    /* The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default.  This value must satisfy
     * the restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize */
    private Integer minQAChallengeSize;

    /* The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default. This value must satisfy the
     * restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize */
    private Integer maxQAChallengeSize;

    /* If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer. */
    private Boolean disableQAChallengeRetention;

    /* Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private Integer QAChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true. */
    private Boolean updateLockoutForReplacedQAChallenge;

    /* The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     * This value must satisfy the restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaDefaultWrongAnswersAllowed must
     * be less than QAChallengeSize */
    private Integer qaDefaultWrongAnswersAllowed;

    /* The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct,
     * when the call
     *                                 to authenticate such a challenge overrides
     * the
     *                                 default. This value must satisfy the
     * restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaMaximumWrongAnswersAllowed must
     * be less than maxQAChallengeSize */
    private Integer qaMaximumWrongAnswersAllowed;

    /* Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge. */
    private Boolean qaInexactMatchAllowed;

    /* The characters that can appear in a one-time password (OTP). */
    private String[] OTPCellAlphabet;

    /* A list of characters that are replaced in a
     *                             one-time password (OTP) response before
     * it is validated. */
    private CellReplacement[] OTPCellReplacements;

    /* The lifetime in seconds of a OTP.  A value of
     *                             0 means an infinite lifetime. */
    private Integer OTPLifetime;

    /* The number of characters in a one-time password (OTP).
     *                                 Must be at least 1. */
    private Integer OTPLength;

    /* Flag indicating if a user's one-time password (OTP) can be
     * delivered via
     *                             an out-of-band delivery mechanism. */
    private Boolean OTPDeliveryEnabled;

    /* Flag indicating if the OTP is generated for each
     *                             challenge request.  If set to false, a
     * new OTP
     *                             is only generated if an OTP doesn't exist
     * or the
     *                             current OTP is expired. */
    private Boolean OTPAlwaysGenerate;

    /* Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested. */
    private Boolean OTPDynamicRefresh;

    /* Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer. */
    private Integer OTPNumberOutstanding;

    /* When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy. */
    private Integer OTPRefreshThreshold;

    /* Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge. */
    private Boolean returnAuthSecretWithChall;

    /* Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is deleted. */
    private Boolean autoUnassignTokens;

    /* Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group. */
    private Boolean autoMoveTokens;

    /* If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request. */
    private Boolean disableTokenChallengeRetention;

    /* Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private Integer tokenChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true. */
    private Boolean updateLockoutForReplacedTokenChallenge;

    /* The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer. */
    private Integer maxAllowedTokenSets;

    /* Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request. */
    private Boolean allowNONEAuthentication;

    /* Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type. */
    private Boolean considerTempPINLast;

    /* Flag indicating if information about the
     *                                 last authentication for a user is
     * stored. */
    private Boolean storeLastAuthInfo;

    /* Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data. */
    private Boolean allowCreateIfDisabledInRepository;

    /* Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data. */
    private Boolean allowCreateIfExpiredInRepository;

    /* Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail. */
    private Boolean allowAuthIfDisabledInRepository;

    /* Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail. */
    private Boolean allowAuthIfExpiredInRepository;

    /* Specifies how transaction receipts are signed. */
    private com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType;

    /* Specifies the transaction lifetime in seconds. */
    private Integer transactionLifetime;

    /* Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction. */
    private Integer maxNumTransactionDetails;

    /* Specifies if self-signed user certificates
     *                                 can be assigned to a user. */
    private Boolean allowSelfSignedUserCert;

    /* Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user. */
    private Boolean allowCertNotIssuedByRegisteredCA;

    /* Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user.  If this value
     *                                 is set to true, the AllowedRegisteredCAs
     * 
     *                                 parameter should not be set. */
    private Boolean allowAllRegisteredCAs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true. */
    private Boolean addAllowedRegisteredCAs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true. */
    private Boolean removeAllowedRegisteredCAs;

    /* User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllRegistredCAs value is
     * set to true,
     *                                 this value should not be set. */
    private String[] allowedRegisteredCAs;

    /* Specifies if a user certificate that is
     *                                 not issued by a managed CA can be
     *                                 used to authenticate a user. */
    private Boolean allowCertNotIssuedByManagedCA;

    /* Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user.
     *                                 If this value is set to true, the
     * AllowedManagedCAs 
     *                                 parameter should not be set. */
    private Boolean allowAllManagedCAs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true. */
    private Boolean addAllowedManagedCAs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true. */
    private Boolean removeAllowedManagedCAs;

    /* User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllManagedCAs value is set
     * to true,
     *                                 this value should not be set. */
    private String[] allowedManagedCAs;

    /* Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256.  If not
     *                                 specified, this value defaults to
     * SHA-256. */
    private String certificateAuthenticationHashAlg;

    /* Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32. */
    private Integer certificateAuthenticationChallengeSize;

    /* Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer. */
    private Integer maxCertsPerUser;

    /* A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user. */
    private Boolean autoDeleteUserCerts;

    /* If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request. */
    private Boolean disableCertificateChallengeRetention;

    /* If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges. */
    private Boolean allowCertificateChallengeDelivery;

    /* If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges. */
    private Boolean allowCertificateTransactionDelivery;

    /* If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges. */
    private Boolean allowCertificateSign;

    /* Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private Integer certificateChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true. */
    private Boolean updateLockoutForReplacedCertificateChallenge;

    /* Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user. */
    private Boolean allowAllSmartCredentialDefinitions;

    /* If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set
     *                                 to true. */
    private Boolean addAllowedSmartCredentialDefinitions;

    /* If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set to
     *                                 true. */
    private Boolean removeAllowedSmartCredentialDefinitions;

    /* Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set. */
    private String[] allowedSmartCredentialDefinitions;

    /* Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private Integer maxSmartCredentialsPerUser;

    /* The prefix added to Smart Credential Ids. */
    private String smartCredentialIDPrefix;

    /* The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation. Specify an
     * empty
     *                                 string value to remove the current
     * value. */
    private String smartCredentialTokenVendor;

    /* Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the user
     *                                 they belong to is deleted. */
    private Boolean autoUnassignSmartCredentials;

    /* Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned. */
    private Boolean autoCancelSmartCredentials;

    /* Flag indicating if the force option is applied
     *                                 when auto-canceling smart credentials.
     * This option only applies when
     *                                 AutoCancelSmartCredentials is true. */
    private Boolean autoCancelSmartCredentialsForce;

    /* Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group. */
    private Boolean autoMoveSmartCredentials;

    /* Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued. */
    private Boolean autoRegisterSmartCredentialsToPACS;

    /* Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted. */
    private Boolean autoSuspendSmartCredentialsFromPACS;

    /* Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy. */
    private Boolean allowSoftwareSmartCredentials;

    /* Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN. */
    private PINPromptType mobileSmartCredentialPINPrompt;

    /* Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION. */
    private Integer mobileSmartCredentialSessionTimeout;

    /* Specifies that any Digital Id Configs can be
     *                                 used to create Digital Ids for a user. */
    private Boolean allowAllDigitalIdConfigs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set
     *                                 to true. */
    private Boolean addAllowedDigitalIdConfigs;

    /* If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set to
     *                                 true. */
    private Boolean removeAllowedDigitalIdConfigs;

    /* Specifies a list of Digital Ids Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set. */
    private String[] allowedDigitalIdConfigs;

    /* Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private Integer maxDigitalIdsPerUser;

    /* Specifies the maximum number of Client Types
     *                                 per Digital Id.
     *                                 This value must be a non-negative
     * integer. */
    private Integer maxClientTypesPerDigitalId;

    /* Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted. */
    private Boolean autoCancelDigitalIds;

    /* User registration password lifetime in minutes. 
     *                                 This value must be a non-negative
     * integer.
     *                                 A value of 0 means infinite lifetime. */
    private Integer userRegistrationPasswordLifetime;

    /* The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32. */
    private Integer userRegistrationPasswordLength;

    /* Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private Integer maxFederationsPerUser;

    /* The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer. */
    private Integer maxNumUserPreferences;

    /* The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer. */
    private Integer maxSizeUserPreference;

    /* The required length of new personal verification
     *                                 numbers (PVNs). */
    private Integer PVNLength;

    /* Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator. */
    private Boolean PVNChangeRequiredOnAdminReset;

    /* The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating.
     *                                 This list can only include the GRID,
     * TOKENRO, TOKENCR
     *                                 and OTP authentication types. */
    private AuthenticationType[] authTypesRequiringPVN;

    /* If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true. */
    private Boolean allTokenVendorsRequirePVN;

    /* If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true. */
    private String[] tokenVendorsRequiringPVN;

    /* The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately. */
    private Integer numDaysForActivation;

    /* The authentication types that trigger user activation on
     *                                 the first successful authentication
     * with one of these
     *                                 types. This list can only include
     * the GRID, TOKENRO,
     *                                 and TOKENCR authentication types. */
    private AuthenticationType[] activationAuthTypes;

    /* Indicate if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history. */
    private Boolean checkIPAddressInLocationHistory;

    /* The maximum size of a user's location history. */
    private Integer maxLocationHistorySize;

    /* The lifetime (in days) of an entry in the
     *                                 user's location history. */
    private Integer locationHistoryLifetime;

    /* The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication. */
    private Integer maxVelocity;

    /* If true, the velocity check is performed
     *                                 during IP authentication. */
    private Boolean checkVelocity;

    /* The country blacklist is a list of country
     *                                 codes. Valid country codes can be
     * obtained
     *                                 from the country information returned
     * by the
     *                                 countryList operation.
     *                                 <p>
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication. */
    private String[] countryBlacklist;

    /* The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the countries
     *                                 in the countryBlacklist attribute
     * will be added
     *                                 to the current value.  This attribute
     * will be
     *                                 ignored if the countryBlacklist attribute
     * is
     *                                 not set. */
    private Boolean addCountryBlacklist;

    /* The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set, the countries
     * in the countryBlacklist attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the countryBlacklist
     * is not set.
     *                                 or the addCountryBlacklist attribute
     * is set. */
    private Boolean removeCountryBlacklist;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication. */
    private ExpectedLocation[] expectedLocations;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set. */
    private Boolean addExpectedLocations;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set.  or the addExpectedLocations
     * attribute is set. */
    private Boolean removeExpectedLocations;

    /* If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list. */
    private Integer maxUserExpectedLocationsSize;

    /* Determines whether the values in the
     *                                 normalReject parameter are added to
     * the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored. */
    private Boolean normalRejectAdd;

    /* Determines whether the values in the
     *                                 normalReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored. */
    private Boolean normalRejectRemove;

    /* A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected.
     *                                 If normalRejectAdd is specified as
     * true,
     *                                 these values are added to the existing
     * values.  Otherwise, if normalRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values. */
    private RBAExpressionList normalReject;

    /* Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * added to the
     *                                 existing values or replace the existing
     * values.  If normalAuthenticated is not
     *                                 specified, this value is ignored. */
    private Boolean normalAuthenticatedAdd;

    /* Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * removed from
     *                                 the existing values or replace the
     * existing
     *                                 values.  If normalAuthenticated is
     * not
     *                                 specified, this value is ignored. */
    private Boolean normalAuthenticatedRemove;

    /* A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated.
     *                                 If normalAuthenticatedAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if
     *                                 normalAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values. */
    private RBAExpressionList normalAuthenticated;

    /* Determines whether the values in the
     *                                 enhancedReject parameter are added
     * to the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored. */
    private Boolean enhancedRejectAdd;

    /* Determines whether the values in the
     *                                 enhancedReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored. */
    private Boolean enhancedRejectRemove;

    /* A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected.
     *                                 If enhancedRejectAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if enhancedRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values. */
    private RBAExpressionList enhancedReject;

    /* Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * added to
     *                                 the existing values or replace the
     * existing
     *                                 values.  If enhancedAuthenticated
     * is not
     *                                 specified, this value is ignored. */
    private Boolean enhancedAuthenticatedAdd;

    /* Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * removed
     *                                 from the existing values or replace
     * the
     *                                 existing values.  If enhancedAuthenticated
     * is
     *                                 not specified, this value is ignored. */
    private Boolean enhancedAuthenticatedRemove;

    /* A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated.
     * If enhancedAuthenticatedAdd is specified as
     *                                 true, these values are added to the
     * existing
     *                                 values.  Otherwise, if
     *                                 enhancedAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values. */
    private RBAExpressionList enhancedAuthenticated;

    /* A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value. */
    private Integer externalRiskScoreNormalPass;

    /* A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value. */
    private Integer externalRiskScoreNormalFail;

    /* A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value. */
    private Integer externalRiskScoreEnhancedPass;

    /* A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value. */
    private Integer externalRiskScoreEnhancedFail;

    /* The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  Specify an empty
     * string value to unset the risk engine policy.
     *                                 If this value is not set, external
     * risk scoring
     *                                 is not available. */
    private String externalRiskEngine;

    /* A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery. */
    private Boolean performTransactionDelivery;

    /* A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP. */
    private Boolean softTokenPINRequired;

    /* The number of digits in an OTP response from a
     *                                 soft token. Allowed values are 4,
     * 6, and 8. */
    private Integer softTokenOTPLength;

    /* Descriptive comments. */
    private String comment;

    public UserSpecParms() {
    }

    public UserSpecParms(
           Integer maxAliases,
           Integer maxContactInfoNumber,
           LockoutMode lockoutMode,
           Integer maxFailures,
           Integer maxGlobalFailures,
           Integer maxCertificateFailures,
           Integer maxExternalFailures,
           Integer maxGridFailures,
           Integer maxTokenCRFailures,
           Integer maxTokenROFailures,
           Integer maxOTPFailures,
           Integer maxQAFailures,
           Integer maxRBAIPAuthFailures,
           Integer maxRBAMachineAuthFailures,
           Integer maxRBACertificateAuthFailures,
           Integer maxRBAExternalRiskAuthFailures,
           Integer lockoutTime,
           Integer maxSecretSize,
           Integer maxSecretNumber,
           AuthenticationType[] genericAuthType,
           AuthenticationType[] enhancedGenericAuthType,
           AuthenticationType[] machineAuthType,
           AuthenticationType[] authTypeCanViewSecrets,
           AuthenticationType[] authTypeCanModifySecrets,
           Integer maxMachineSecrets,
           Integer maxMachineSecretsSize,
           Boolean machineSecretRequiresMachineNonce,
           Boolean machineSecretRequiresSequenceNonce,
           Integer machineSecretRequiresAppData,
           Integer machineSecretAllowsBadAppData,
           Integer machineSecretLifetime,
           Boolean failedMachineAuthIncrementsLockout,
           Integer maxAuthSecrets,
           Integer maxAuthSecretsSize,
           Integer maxQuestions,
           Integer maxQASize,
           Integer QAChallengeSize,
           Integer minQAChallengeSize,
           Integer maxQAChallengeSize,
           Boolean disableQAChallengeRetention,
           Integer QAChallengeLifetime,
           Boolean updateLockoutForReplacedQAChallenge,
           Integer qaDefaultWrongAnswersAllowed,
           Integer qaMaximumWrongAnswersAllowed,
           Boolean qaInexactMatchAllowed,
           String[] OTPCellAlphabet,
           CellReplacement[] OTPCellReplacements,
           Integer OTPLifetime,
           Integer OTPLength,
           Boolean OTPDeliveryEnabled,
           Boolean OTPAlwaysGenerate,
           Boolean OTPDynamicRefresh,
           Integer OTPNumberOutstanding,
           Integer OTPRefreshThreshold,
           Boolean returnAuthSecretWithChall,
           Boolean autoUnassignTokens,
           Boolean autoMoveTokens,
           Boolean disableTokenChallengeRetention,
           Integer tokenChallengeLifetime,
           Boolean updateLockoutForReplacedTokenChallenge,
           Integer maxAllowedTokenSets,
           Boolean allowNONEAuthentication,
           Boolean considerTempPINLast,
           Boolean storeLastAuthInfo,
           Boolean allowCreateIfDisabledInRepository,
           Boolean allowCreateIfExpiredInRepository,
           Boolean allowAuthIfDisabledInRepository,
           Boolean allowAuthIfExpiredInRepository,
           com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType,
           Integer transactionLifetime,
           Integer maxNumTransactionDetails,
           Boolean allowSelfSignedUserCert,
           Boolean allowCertNotIssuedByRegisteredCA,
           Boolean allowAllRegisteredCAs,
           Boolean addAllowedRegisteredCAs,
           Boolean removeAllowedRegisteredCAs,
           String[] allowedRegisteredCAs,
           Boolean allowCertNotIssuedByManagedCA,
           Boolean allowAllManagedCAs,
           Boolean addAllowedManagedCAs,
           Boolean removeAllowedManagedCAs,
           String[] allowedManagedCAs,
           String certificateAuthenticationHashAlg,
           Integer certificateAuthenticationChallengeSize,
           Integer maxCertsPerUser,
           Boolean autoDeleteUserCerts,
           Boolean disableCertificateChallengeRetention,
           Boolean allowCertificateChallengeDelivery,
           Boolean allowCertificateTransactionDelivery,
           Boolean allowCertificateSign,
           Integer certificateChallengeLifetime,
           Boolean updateLockoutForReplacedCertificateChallenge,
           Boolean allowAllSmartCredentialDefinitions,
           Boolean addAllowedSmartCredentialDefinitions,
           Boolean removeAllowedSmartCredentialDefinitions,
           String[] allowedSmartCredentialDefinitions,
           Integer maxSmartCredentialsPerUser,
           String smartCredentialIDPrefix,
           String smartCredentialTokenVendor,
           Boolean autoUnassignSmartCredentials,
           Boolean autoCancelSmartCredentials,
           Boolean autoCancelSmartCredentialsForce,
           Boolean autoMoveSmartCredentials,
           Boolean autoRegisterSmartCredentialsToPACS,
           Boolean autoSuspendSmartCredentialsFromPACS,
           Boolean allowSoftwareSmartCredentials,
           PINPromptType mobileSmartCredentialPINPrompt,
           Integer mobileSmartCredentialSessionTimeout,
           Boolean allowAllDigitalIdConfigs,
           Boolean addAllowedDigitalIdConfigs,
           Boolean removeAllowedDigitalIdConfigs,
           String[] allowedDigitalIdConfigs,
           Integer maxDigitalIdsPerUser,
           Integer maxClientTypesPerDigitalId,
           Boolean autoCancelDigitalIds,
           Integer userRegistrationPasswordLifetime,
           Integer userRegistrationPasswordLength,
           Integer maxFederationsPerUser,
           Integer maxNumUserPreferences,
           Integer maxSizeUserPreference,
           Integer PVNLength,
           Boolean PVNChangeRequiredOnAdminReset,
           AuthenticationType[] authTypesRequiringPVN,
           Boolean allTokenVendorsRequirePVN,
           String[] tokenVendorsRequiringPVN,
           Integer numDaysForActivation,
           AuthenticationType[] activationAuthTypes,
           Boolean checkIPAddressInLocationHistory,
           Integer maxLocationHistorySize,
           Integer locationHistoryLifetime,
           Integer maxVelocity,
           Boolean checkVelocity,
           String[] countryBlacklist,
           Boolean addCountryBlacklist,
           Boolean removeCountryBlacklist,
           ExpectedLocation[] expectedLocations,
           Boolean addExpectedLocations,
           Boolean removeExpectedLocations,
           Integer maxUserExpectedLocationsSize,
           Boolean normalRejectAdd,
           Boolean normalRejectRemove,
           RBAExpressionList normalReject,
           Boolean normalAuthenticatedAdd,
           Boolean normalAuthenticatedRemove,
           RBAExpressionList normalAuthenticated,
           Boolean enhancedRejectAdd,
           Boolean enhancedRejectRemove,
           RBAExpressionList enhancedReject,
           Boolean enhancedAuthenticatedAdd,
           Boolean enhancedAuthenticatedRemove,
           RBAExpressionList enhancedAuthenticated,
           Integer externalRiskScoreNormalPass,
           Integer externalRiskScoreNormalFail,
           Integer externalRiskScoreEnhancedPass,
           Integer externalRiskScoreEnhancedFail,
           String externalRiskEngine,
           Boolean performTransactionDelivery,
           Boolean softTokenPINRequired,
           Integer softTokenOTPLength,
           String comment) {
           this.maxAliases = maxAliases;
           this.maxContactInfoNumber = maxContactInfoNumber;
           this.lockoutMode = lockoutMode;
           this.maxFailures = maxFailures;
           this.maxGlobalFailures = maxGlobalFailures;
           this.maxCertificateFailures = maxCertificateFailures;
           this.maxExternalFailures = maxExternalFailures;
           this.maxGridFailures = maxGridFailures;
           this.maxTokenCRFailures = maxTokenCRFailures;
           this.maxTokenROFailures = maxTokenROFailures;
           this.maxOTPFailures = maxOTPFailures;
           this.maxQAFailures = maxQAFailures;
           this.maxRBAIPAuthFailures = maxRBAIPAuthFailures;
           this.maxRBAMachineAuthFailures = maxRBAMachineAuthFailures;
           this.maxRBACertificateAuthFailures = maxRBACertificateAuthFailures;
           this.maxRBAExternalRiskAuthFailures = maxRBAExternalRiskAuthFailures;
           this.lockoutTime = lockoutTime;
           this.maxSecretSize = maxSecretSize;
           this.maxSecretNumber = maxSecretNumber;
           this.genericAuthType = genericAuthType;
           this.enhancedGenericAuthType = enhancedGenericAuthType;
           this.machineAuthType = machineAuthType;
           this.authTypeCanViewSecrets = authTypeCanViewSecrets;
           this.authTypeCanModifySecrets = authTypeCanModifySecrets;
           this.maxMachineSecrets = maxMachineSecrets;
           this.maxMachineSecretsSize = maxMachineSecretsSize;
           this.machineSecretRequiresMachineNonce = machineSecretRequiresMachineNonce;
           this.machineSecretRequiresSequenceNonce = machineSecretRequiresSequenceNonce;
           this.machineSecretRequiresAppData = machineSecretRequiresAppData;
           this.machineSecretAllowsBadAppData = machineSecretAllowsBadAppData;
           this.machineSecretLifetime = machineSecretLifetime;
           this.failedMachineAuthIncrementsLockout = failedMachineAuthIncrementsLockout;
           this.maxAuthSecrets = maxAuthSecrets;
           this.maxAuthSecretsSize = maxAuthSecretsSize;
           this.maxQuestions = maxQuestions;
           this.maxQASize = maxQASize;
           this.QAChallengeSize = QAChallengeSize;
           this.minQAChallengeSize = minQAChallengeSize;
           this.maxQAChallengeSize = maxQAChallengeSize;
           this.disableQAChallengeRetention = disableQAChallengeRetention;
           this.QAChallengeLifetime = QAChallengeLifetime;
           this.updateLockoutForReplacedQAChallenge = updateLockoutForReplacedQAChallenge;
           this.qaDefaultWrongAnswersAllowed = qaDefaultWrongAnswersAllowed;
           this.qaMaximumWrongAnswersAllowed = qaMaximumWrongAnswersAllowed;
           this.qaInexactMatchAllowed = qaInexactMatchAllowed;
           this.OTPCellAlphabet = OTPCellAlphabet;
           this.OTPCellReplacements = OTPCellReplacements;
           this.OTPLifetime = OTPLifetime;
           this.OTPLength = OTPLength;
           this.OTPDeliveryEnabled = OTPDeliveryEnabled;
           this.OTPAlwaysGenerate = OTPAlwaysGenerate;
           this.OTPDynamicRefresh = OTPDynamicRefresh;
           this.OTPNumberOutstanding = OTPNumberOutstanding;
           this.OTPRefreshThreshold = OTPRefreshThreshold;
           this.returnAuthSecretWithChall = returnAuthSecretWithChall;
           this.autoUnassignTokens = autoUnassignTokens;
           this.autoMoveTokens = autoMoveTokens;
           this.disableTokenChallengeRetention = disableTokenChallengeRetention;
           this.tokenChallengeLifetime = tokenChallengeLifetime;
           this.updateLockoutForReplacedTokenChallenge = updateLockoutForReplacedTokenChallenge;
           this.maxAllowedTokenSets = maxAllowedTokenSets;
           this.allowNONEAuthentication = allowNONEAuthentication;
           this.considerTempPINLast = considerTempPINLast;
           this.storeLastAuthInfo = storeLastAuthInfo;
           this.allowCreateIfDisabledInRepository = allowCreateIfDisabledInRepository;
           this.allowCreateIfExpiredInRepository = allowCreateIfExpiredInRepository;
           this.allowAuthIfDisabledInRepository = allowAuthIfDisabledInRepository;
           this.allowAuthIfExpiredInRepository = allowAuthIfExpiredInRepository;
           this.transactionSignatureType = transactionSignatureType;
           this.transactionLifetime = transactionLifetime;
           this.maxNumTransactionDetails = maxNumTransactionDetails;
           this.allowSelfSignedUserCert = allowSelfSignedUserCert;
           this.allowCertNotIssuedByRegisteredCA = allowCertNotIssuedByRegisteredCA;
           this.allowAllRegisteredCAs = allowAllRegisteredCAs;
           this.addAllowedRegisteredCAs = addAllowedRegisteredCAs;
           this.removeAllowedRegisteredCAs = removeAllowedRegisteredCAs;
           this.allowedRegisteredCAs = allowedRegisteredCAs;
           this.allowCertNotIssuedByManagedCA = allowCertNotIssuedByManagedCA;
           this.allowAllManagedCAs = allowAllManagedCAs;
           this.addAllowedManagedCAs = addAllowedManagedCAs;
           this.removeAllowedManagedCAs = removeAllowedManagedCAs;
           this.allowedManagedCAs = allowedManagedCAs;
           this.certificateAuthenticationHashAlg = certificateAuthenticationHashAlg;
           this.certificateAuthenticationChallengeSize = certificateAuthenticationChallengeSize;
           this.maxCertsPerUser = maxCertsPerUser;
           this.autoDeleteUserCerts = autoDeleteUserCerts;
           this.disableCertificateChallengeRetention = disableCertificateChallengeRetention;
           this.allowCertificateChallengeDelivery = allowCertificateChallengeDelivery;
           this.allowCertificateTransactionDelivery = allowCertificateTransactionDelivery;
           this.allowCertificateSign = allowCertificateSign;
           this.certificateChallengeLifetime = certificateChallengeLifetime;
           this.updateLockoutForReplacedCertificateChallenge = updateLockoutForReplacedCertificateChallenge;
           this.allowAllSmartCredentialDefinitions = allowAllSmartCredentialDefinitions;
           this.addAllowedSmartCredentialDefinitions = addAllowedSmartCredentialDefinitions;
           this.removeAllowedSmartCredentialDefinitions = removeAllowedSmartCredentialDefinitions;
           this.allowedSmartCredentialDefinitions = allowedSmartCredentialDefinitions;
           this.maxSmartCredentialsPerUser = maxSmartCredentialsPerUser;
           this.smartCredentialIDPrefix = smartCredentialIDPrefix;
           this.smartCredentialTokenVendor = smartCredentialTokenVendor;
           this.autoUnassignSmartCredentials = autoUnassignSmartCredentials;
           this.autoCancelSmartCredentials = autoCancelSmartCredentials;
           this.autoCancelSmartCredentialsForce = autoCancelSmartCredentialsForce;
           this.autoMoveSmartCredentials = autoMoveSmartCredentials;
           this.autoRegisterSmartCredentialsToPACS = autoRegisterSmartCredentialsToPACS;
           this.autoSuspendSmartCredentialsFromPACS = autoSuspendSmartCredentialsFromPACS;
           this.allowSoftwareSmartCredentials = allowSoftwareSmartCredentials;
           this.mobileSmartCredentialPINPrompt = mobileSmartCredentialPINPrompt;
           this.mobileSmartCredentialSessionTimeout = mobileSmartCredentialSessionTimeout;
           this.allowAllDigitalIdConfigs = allowAllDigitalIdConfigs;
           this.addAllowedDigitalIdConfigs = addAllowedDigitalIdConfigs;
           this.removeAllowedDigitalIdConfigs = removeAllowedDigitalIdConfigs;
           this.allowedDigitalIdConfigs = allowedDigitalIdConfigs;
           this.maxDigitalIdsPerUser = maxDigitalIdsPerUser;
           this.maxClientTypesPerDigitalId = maxClientTypesPerDigitalId;
           this.autoCancelDigitalIds = autoCancelDigitalIds;
           this.userRegistrationPasswordLifetime = userRegistrationPasswordLifetime;
           this.userRegistrationPasswordLength = userRegistrationPasswordLength;
           this.maxFederationsPerUser = maxFederationsPerUser;
           this.maxNumUserPreferences = maxNumUserPreferences;
           this.maxSizeUserPreference = maxSizeUserPreference;
           this.PVNLength = PVNLength;
           this.PVNChangeRequiredOnAdminReset = PVNChangeRequiredOnAdminReset;
           this.authTypesRequiringPVN = authTypesRequiringPVN;
           this.allTokenVendorsRequirePVN = allTokenVendorsRequirePVN;
           this.tokenVendorsRequiringPVN = tokenVendorsRequiringPVN;
           this.numDaysForActivation = numDaysForActivation;
           this.activationAuthTypes = activationAuthTypes;
           this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
           this.maxLocationHistorySize = maxLocationHistorySize;
           this.locationHistoryLifetime = locationHistoryLifetime;
           this.maxVelocity = maxVelocity;
           this.checkVelocity = checkVelocity;
           this.countryBlacklist = countryBlacklist;
           this.addCountryBlacklist = addCountryBlacklist;
           this.removeCountryBlacklist = removeCountryBlacklist;
           this.expectedLocations = expectedLocations;
           this.addExpectedLocations = addExpectedLocations;
           this.removeExpectedLocations = removeExpectedLocations;
           this.maxUserExpectedLocationsSize = maxUserExpectedLocationsSize;
           this.normalRejectAdd = normalRejectAdd;
           this.normalRejectRemove = normalRejectRemove;
           this.normalReject = normalReject;
           this.normalAuthenticatedAdd = normalAuthenticatedAdd;
           this.normalAuthenticatedRemove = normalAuthenticatedRemove;
           this.normalAuthenticated = normalAuthenticated;
           this.enhancedRejectAdd = enhancedRejectAdd;
           this.enhancedRejectRemove = enhancedRejectRemove;
           this.enhancedReject = enhancedReject;
           this.enhancedAuthenticatedAdd = enhancedAuthenticatedAdd;
           this.enhancedAuthenticatedRemove = enhancedAuthenticatedRemove;
           this.enhancedAuthenticated = enhancedAuthenticated;
           this.externalRiskScoreNormalPass = externalRiskScoreNormalPass;
           this.externalRiskScoreNormalFail = externalRiskScoreNormalFail;
           this.externalRiskScoreEnhancedPass = externalRiskScoreEnhancedPass;
           this.externalRiskScoreEnhancedFail = externalRiskScoreEnhancedFail;
           this.externalRiskEngine = externalRiskEngine;
           this.performTransactionDelivery = performTransactionDelivery;
           this.softTokenPINRequired = softTokenPINRequired;
           this.softTokenOTPLength = softTokenOTPLength;
           this.comment = comment;
    }


    /**
     * Gets the maxAliases value for this UserSpecParms.
     * 
     * @return maxAliases   * The maximum number of aliases that can be assigned
     *                                to a user. A value of 0 means that
     * users are
     *                                not allowed to have aliases.
     */
    public Integer getMaxAliases() {
        return maxAliases;
    }


    /**
     * Sets the maxAliases value for this UserSpecParms.
     * 
     * @param maxAliases   * The maximum number of aliases that can be assigned
     *                                to a user. A value of 0 means that
     * users are
     *                                not allowed to have aliases.
     */
    public void setMaxAliases(Integer maxAliases) {
        this.maxAliases = maxAliases;
    }


    /**
     * Gets the maxContactInfoNumber value for this UserSpecParms.
     * 
     * @return maxContactInfoNumber   * The maximum number of contact information entries that can
     * be
     *                             created for a user. A value of 0 means
     * that
     *                             no contact information can be stored for
     * a user.
     */
    public Integer getMaxContactInfoNumber() {
        return maxContactInfoNumber;
    }


    /**
     * Sets the maxContactInfoNumber value for this UserSpecParms.
     * 
     * @param maxContactInfoNumber   * The maximum number of contact information entries that can
     * be
     *                             created for a user. A value of 0 means
     * that
     *                             no contact information can be stored for
     * a user.
     */
    public void setMaxContactInfoNumber(Integer maxContactInfoNumber) {
        this.maxContactInfoNumber = maxContactInfoNumber;
    }


    /**
     * Gets the lockoutMode value for this UserSpecParms.
     * 
     * @return lockoutMode   * The authentication lockout mode.
     */
    public LockoutMode getLockoutMode() {
        return lockoutMode;
    }


    /**
     * Sets the lockoutMode value for this UserSpecParms.
     * 
     * @param lockoutMode   * The authentication lockout mode.
     */
    public void setLockoutMode(LockoutMode lockoutMode) {
        this.lockoutMode = lockoutMode;
    }


    /**
     * Gets the maxFailures value for this UserSpecParms.
     * 
     * @return maxFailures   * The number of consecutive authentication failures allowed before
     * a
     *                             user is locked out.  A value of 0 means
     * the user is
     *                             never locked out, no matter how many times
     * they
     *                             fail to authenticate.
     *                             The various maxXXXFailures policies should
     * be used 
     *                             instead of this policy.
     */
    public Integer getMaxFailures() {
        return maxFailures;
    }


    /**
     * Sets the maxFailures value for this UserSpecParms.
     * 
     * @param maxFailures   * The number of consecutive authentication failures allowed before
     * a
     *                             user is locked out.  A value of 0 means
     * the user is
     *                             never locked out, no matter how many times
     * they
     *                             fail to authenticate.
     *                             The various maxXXXFailures policies should
     * be used 
     *                             instead of this policy.
     */
    public void setMaxFailures(Integer maxFailures) {
        this.maxFailures = maxFailures;
    }


    /**
     * Gets the maxGlobalFailures value for this UserSpecParms.
     * 
     * @return maxGlobalFailures   * The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode.
     */
    public Integer getMaxGlobalFailures() {
        return maxGlobalFailures;
    }


    /**
     * Sets the maxGlobalFailures value for this UserSpecParms.
     * 
     * @param maxGlobalFailures   * The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode.
     */
    public void setMaxGlobalFailures(Integer maxGlobalFailures) {
        this.maxGlobalFailures = maxGlobalFailures;
    }


    /**
     * Gets the maxCertificateFailures value for this UserSpecParms.
     * 
     * @return maxCertificateFailures   * The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxCertificateFailures() {
        return maxCertificateFailures;
    }


    /**
     * Sets the maxCertificateFailures value for this UserSpecParms.
     * 
     * @param maxCertificateFailures   * The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxCertificateFailures(Integer maxCertificateFailures) {
        this.maxCertificateFailures = maxCertificateFailures;
    }


    /**
     * Gets the maxExternalFailures value for this UserSpecParms.
     * 
     * @return maxExternalFailures   * The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxExternalFailures() {
        return maxExternalFailures;
    }


    /**
     * Sets the maxExternalFailures value for this UserSpecParms.
     * 
     * @param maxExternalFailures   * The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxExternalFailures(Integer maxExternalFailures) {
        this.maxExternalFailures = maxExternalFailures;
    }


    /**
     * Gets the maxGridFailures value for this UserSpecParms.
     * 
     * @return maxGridFailures   * The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxGridFailures() {
        return maxGridFailures;
    }


    /**
     * Sets the maxGridFailures value for this UserSpecParms.
     * 
     * @param maxGridFailures   * The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxGridFailures(Integer maxGridFailures) {
        this.maxGridFailures = maxGridFailures;
    }


    /**
     * Gets the maxTokenCRFailures value for this UserSpecParms.
     * 
     * @return maxTokenCRFailures   * The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxTokenCRFailures() {
        return maxTokenCRFailures;
    }


    /**
     * Sets the maxTokenCRFailures value for this UserSpecParms.
     * 
     * @param maxTokenCRFailures   * The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxTokenCRFailures(Integer maxTokenCRFailures) {
        this.maxTokenCRFailures = maxTokenCRFailures;
    }


    /**
     * Gets the maxTokenROFailures value for this UserSpecParms.
     * 
     * @return maxTokenROFailures   * The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxTokenROFailures() {
        return maxTokenROFailures;
    }


    /**
     * Sets the maxTokenROFailures value for this UserSpecParms.
     * 
     * @param maxTokenROFailures   * The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxTokenROFailures(Integer maxTokenROFailures) {
        this.maxTokenROFailures = maxTokenROFailures;
    }


    /**
     * Gets the maxOTPFailures value for this UserSpecParms.
     * 
     * @return maxOTPFailures   * The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxOTPFailures() {
        return maxOTPFailures;
    }


    /**
     * Sets the maxOTPFailures value for this UserSpecParms.
     * 
     * @param maxOTPFailures   * The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxOTPFailures(Integer maxOTPFailures) {
        this.maxOTPFailures = maxOTPFailures;
    }


    /**
     * Gets the maxQAFailures value for this UserSpecParms.
     * 
     * @return maxQAFailures   * The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxQAFailures() {
        return maxQAFailures;
    }


    /**
     * Sets the maxQAFailures value for this UserSpecParms.
     * 
     * @param maxQAFailures   * The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxQAFailures(Integer maxQAFailures) {
        this.maxQAFailures = maxQAFailures;
    }


    /**
     * Gets the maxRBAIPAuthFailures value for this UserSpecParms.
     * 
     * @return maxRBAIPAuthFailures   * The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxRBAIPAuthFailures() {
        return maxRBAIPAuthFailures;
    }


    /**
     * Sets the maxRBAIPAuthFailures value for this UserSpecParms.
     * 
     * @param maxRBAIPAuthFailures   * The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAIPAuthFailures(Integer maxRBAIPAuthFailures) {
        this.maxRBAIPAuthFailures = maxRBAIPAuthFailures;
    }


    /**
     * Gets the maxRBAMachineAuthFailures value for this UserSpecParms.
     * 
     * @return maxRBAMachineAuthFailures   * The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxRBAMachineAuthFailures() {
        return maxRBAMachineAuthFailures;
    }


    /**
     * Sets the maxRBAMachineAuthFailures value for this UserSpecParms.
     * 
     * @param maxRBAMachineAuthFailures   * The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAMachineAuthFailures(Integer maxRBAMachineAuthFailures) {
        this.maxRBAMachineAuthFailures = maxRBAMachineAuthFailures;
    }


    /**
     * Gets the maxRBACertificateAuthFailures value for this UserSpecParms.
     * 
     * @return maxRBACertificateAuthFailures   * The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxRBACertificateAuthFailures() {
        return maxRBACertificateAuthFailures;
    }


    /**
     * Sets the maxRBACertificateAuthFailures value for this UserSpecParms.
     * 
     * @param maxRBACertificateAuthFailures   * The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBACertificateAuthFailures(Integer maxRBACertificateAuthFailures) {
        this.maxRBACertificateAuthFailures = maxRBACertificateAuthFailures;
    }


    /**
     * Gets the maxRBAExternalRiskAuthFailures value for this UserSpecParms.
     * 
     * @return maxRBAExternalRiskAuthFailures   * The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxRBAExternalRiskAuthFailures() {
        return maxRBAExternalRiskAuthFailures;
    }


    /**
     * Sets the maxRBAExternalRiskAuthFailures value for this UserSpecParms.
     * 
     * @param maxRBAExternalRiskAuthFailures   * The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAExternalRiskAuthFailures(Integer maxRBAExternalRiskAuthFailures) {
        this.maxRBAExternalRiskAuthFailures = maxRBAExternalRiskAuthFailures;
    }


    /**
     * Gets the lockoutTime value for this UserSpecParms.
     * 
     * @return lockoutTime   * The number of minutes a user remains locked.  A value
     *                             of 0 means the user remains locked until
     * unlocked by an
     *                             administrator.
     *                             This policy is used with the GLOBAL, ALL_AUTHENTICATOR
     * and
     *                             PER_AUTHENTICATOR lockout modes.
     */
    public Integer getLockoutTime() {
        return lockoutTime;
    }


    /**
     * Sets the lockoutTime value for this UserSpecParms.
     * 
     * @param lockoutTime   * The number of minutes a user remains locked.  A value
     *                             of 0 means the user remains locked until
     * unlocked by an
     *                             administrator.
     *                             This policy is used with the GLOBAL, ALL_AUTHENTICATOR
     * and
     *                             PER_AUTHENTICATOR lockout modes.
     */
    public void setLockoutTime(Integer lockoutTime) {
        this.lockoutTime = lockoutTime;
    }


    /**
     * Gets the maxSecretSize value for this UserSpecParms.
     * 
     * @return maxSecretSize   * The maximum size of the shared secrets for
     *                             a user, in kilobytes. A value of 0 means
     * that users are
     *                             not allowed to have shared secrets.
     */
    public Integer getMaxSecretSize() {
        return maxSecretSize;
    }


    /**
     * Sets the maxSecretSize value for this UserSpecParms.
     * 
     * @param maxSecretSize   * The maximum size of the shared secrets for
     *                             a user, in kilobytes. A value of 0 means
     * that users are
     *                             not allowed to have shared secrets.
     */
    public void setMaxSecretSize(Integer maxSecretSize) {
        this.maxSecretSize = maxSecretSize;
    }


    /**
     * Gets the maxSecretNumber value for this UserSpecParms.
     * 
     * @return maxSecretNumber   * The maximum number of shared secrets for
     *                             a user. A value of 0 means that users
     * are
     *                             not allowed to have shared secrets.
     */
    public Integer getMaxSecretNumber() {
        return maxSecretNumber;
    }


    /**
     * Sets the maxSecretNumber value for this UserSpecParms.
     * 
     * @param maxSecretNumber   * The maximum number of shared secrets for
     *                             a user. A value of 0 means that users
     * are
     *                             not allowed to have shared secrets.
     */
    public void setMaxSecretNumber(Integer maxSecretNumber) {
        this.maxSecretNumber = maxSecretNumber;
    }


    /**
     * Gets the genericAuthType value for this UserSpecParms.
     * 
     * @return genericAuthType   * The type of authentications that can be used for
     *                             generic authentication operations with
     * a normal
     *                             security level.
     */
    public AuthenticationType[] getGenericAuthType() {
        return genericAuthType;
    }


    /**
     * Sets the genericAuthType value for this UserSpecParms.
     * 
     * @param genericAuthType   * The type of authentications that can be used for
     *                             generic authentication operations with
     * a normal
     *                             security level.
     */
    public void setGenericAuthType(AuthenticationType[] genericAuthType) {
        this.genericAuthType = genericAuthType;
    }


    /**
     * Gets the enhancedGenericAuthType value for this UserSpecParms.
     * 
     * @return enhancedGenericAuthType   * The type of authentications that can be used for
     *                             generic authentication operations with
     * an
     *                             enhanced security level.
     */
    public AuthenticationType[] getEnhancedGenericAuthType() {
        return enhancedGenericAuthType;
    }


    /**
     * Sets the enhancedGenericAuthType value for this UserSpecParms.
     * 
     * @param enhancedGenericAuthType   * The type of authentications that can be used for
     *                             generic authentication operations with
     * an
     *                             enhanced security level.
     */
    public void setEnhancedGenericAuthType(AuthenticationType[] enhancedGenericAuthType) {
        this.enhancedGenericAuthType = enhancedGenericAuthType;
    }


    /**
     * Gets the machineAuthType value for this UserSpecParms.
     * 
     * @return machineAuthType   * The type of authentications that can be used for
     *                             machine registration authentication operations.
     */
    public AuthenticationType[] getMachineAuthType() {
        return machineAuthType;
    }


    /**
     * Sets the machineAuthType value for this UserSpecParms.
     * 
     * @param machineAuthType   * The type of authentications that can be used for
     *                             machine registration authentication operations.
     */
    public void setMachineAuthType(AuthenticationType[] machineAuthType) {
        this.machineAuthType = machineAuthType;
    }


    /**
     * Gets the authTypeCanViewSecrets value for this UserSpecParms.
     * 
     * @return authTypeCanViewSecrets   * The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE.
     */
    public AuthenticationType[] getAuthTypeCanViewSecrets() {
        return authTypeCanViewSecrets;
    }


    /**
     * Sets the authTypeCanViewSecrets value for this UserSpecParms.
     * 
     * @param authTypeCanViewSecrets   * The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE.
     */
    public void setAuthTypeCanViewSecrets(AuthenticationType[] authTypeCanViewSecrets) {
        this.authTypeCanViewSecrets = authTypeCanViewSecrets;
    }


    /**
     * Gets the authTypeCanModifySecrets value for this UserSpecParms.
     * 
     * @return authTypeCanModifySecrets   * The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE.
     */
    public AuthenticationType[] getAuthTypeCanModifySecrets() {
        return authTypeCanModifySecrets;
    }


    /**
     * Sets the authTypeCanModifySecrets value for this UserSpecParms.
     * 
     * @param authTypeCanModifySecrets   * The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     * This list cannot
     *                                 include the authentication type NONE.
     */
    public void setAuthTypeCanModifySecrets(AuthenticationType[] authTypeCanModifySecrets) {
        this.authTypeCanModifySecrets = authTypeCanModifySecrets;
    }


    /**
     * Gets the maxMachineSecrets value for this UserSpecParms.
     * 
     * @return maxMachineSecrets   * The maximum number of machine secrets for
     *                             a user. A value of 0 means that no machine
     * secrets can be stored.
     */
    public Integer getMaxMachineSecrets() {
        return maxMachineSecrets;
    }


    /**
     * Sets the maxMachineSecrets value for this UserSpecParms.
     * 
     * @param maxMachineSecrets   * The maximum number of machine secrets for
     *                             a user. A value of 0 means that no machine
     * secrets can be stored.
     */
    public void setMaxMachineSecrets(Integer maxMachineSecrets) {
        this.maxMachineSecrets = maxMachineSecrets;
    }


    /**
     * Gets the maxMachineSecretsSize value for this UserSpecParms.
     * 
     * @return maxMachineSecretsSize   * The maximum size of a single machine secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored.
     */
    public Integer getMaxMachineSecretsSize() {
        return maxMachineSecretsSize;
    }


    /**
     * Sets the maxMachineSecretsSize value for this UserSpecParms.
     * 
     * @param maxMachineSecretsSize   * The maximum size of a single machine secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored.
     */
    public void setMaxMachineSecretsSize(Integer maxMachineSecretsSize) {
        this.maxMachineSecretsSize = maxMachineSecretsSize;
    }


    /**
     * Gets the machineSecretRequiresMachineNonce value for this UserSpecParms.
     * 
     * @return machineSecretRequiresMachineNonce   * A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              To set this flag to false, the
     *                              machineSecretRequiresAppData setting
     * must be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * must be 0.
     */
    public Boolean getMachineSecretRequiresMachineNonce() {
        return machineSecretRequiresMachineNonce;
    }


    /**
     * Sets the machineSecretRequiresMachineNonce value for this UserSpecParms.
     * 
     * @param machineSecretRequiresMachineNonce   * A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              To set this flag to false, the
     *                              machineSecretRequiresAppData setting
     * must be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * must be 0.
     */
    public void setMachineSecretRequiresMachineNonce(Boolean machineSecretRequiresMachineNonce) {
        this.machineSecretRequiresMachineNonce = machineSecretRequiresMachineNonce;
    }


    /**
     * Gets the machineSecretRequiresSequenceNonce value for this UserSpecParms.
     * 
     * @return machineSecretRequiresSequenceNonce   * A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication.
     */
    public Boolean getMachineSecretRequiresSequenceNonce() {
        return machineSecretRequiresSequenceNonce;
    }


    /**
     * Sets the machineSecretRequiresSequenceNonce value for this UserSpecParms.
     * 
     * @param machineSecretRequiresSequenceNonce   * A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication.
     */
    public void setMachineSecretRequiresSequenceNonce(Boolean machineSecretRequiresSequenceNonce) {
        this.machineSecretRequiresSequenceNonce = machineSecretRequiresSequenceNonce;
    }


    /**
     * Gets the machineSecretRequiresAppData value for this UserSpecParms.
     * 
     * @return machineSecretRequiresAppData   * A count indicating how many application data
     *                             values in a machine secret being used
     * for
     *                             authentication can be bad before
     *                             validation fails.
     */
    public Integer getMachineSecretRequiresAppData() {
        return machineSecretRequiresAppData;
    }


    /**
     * Sets the machineSecretRequiresAppData value for this UserSpecParms.
     * 
     * @param machineSecretRequiresAppData   * A count indicating how many application data
     *                             values in a machine secret being used
     * for
     *                             authentication can be bad before
     *                             validation fails.
     */
    public void setMachineSecretRequiresAppData(Integer machineSecretRequiresAppData) {
        this.machineSecretRequiresAppData = machineSecretRequiresAppData;
    }


    /**
     * Gets the machineSecretAllowsBadAppData value for this UserSpecParms.
     * 
     * @return machineSecretAllowsBadAppData   * A count indicating how many application data
     *                             values in the machine secret can be bad
     * before
     *                             validation fails.
     */
    public Integer getMachineSecretAllowsBadAppData() {
        return machineSecretAllowsBadAppData;
    }


    /**
     * Sets the machineSecretAllowsBadAppData value for this UserSpecParms.
     * 
     * @param machineSecretAllowsBadAppData   * A count indicating how many application data
     *                             values in the machine secret can be bad
     * before
     *                             validation fails.
     */
    public void setMachineSecretAllowsBadAppData(Integer machineSecretAllowsBadAppData) {
        this.machineSecretAllowsBadAppData = machineSecretAllowsBadAppData;
    }


    /**
     * Gets the machineSecretLifetime value for this UserSpecParms.
     * 
     * @return machineSecretLifetime   * Machine secret lifetime in hours. This must be a
     *                             value between 0 and 876000 inclusive.
     * A value of 0
     *                             means infinite lifetime.
     */
    public Integer getMachineSecretLifetime() {
        return machineSecretLifetime;
    }


    /**
     * Sets the machineSecretLifetime value for this UserSpecParms.
     * 
     * @param machineSecretLifetime   * Machine secret lifetime in hours. This must be a
     *                             value between 0 and 876000 inclusive.
     * A value of 0
     *                             means infinite lifetime.
     */
    public void setMachineSecretLifetime(Integer machineSecretLifetime) {
        this.machineSecretLifetime = machineSecretLifetime;
    }


    /**
     * Gets the failedMachineAuthIncrementsLockout value for this UserSpecParms.
     * 
     * @return failedMachineAuthIncrementsLockout   * A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed.
     */
    public Boolean getFailedMachineAuthIncrementsLockout() {
        return failedMachineAuthIncrementsLockout;
    }


    /**
     * Sets the failedMachineAuthIncrementsLockout value for this UserSpecParms.
     * 
     * @param failedMachineAuthIncrementsLockout   * A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed.
     */
    public void setFailedMachineAuthIncrementsLockout(Boolean failedMachineAuthIncrementsLockout) {
        this.failedMachineAuthIncrementsLockout = failedMachineAuthIncrementsLockout;
    }


    /**
     * Gets the maxAuthSecrets value for this UserSpecParms.
     * 
     * @return maxAuthSecrets   * The maximum number of authentication secrets for
     *                             a user. A value of 0 means that no
     *                             authentication secrets can be stored.
     */
    public Integer getMaxAuthSecrets() {
        return maxAuthSecrets;
    }


    /**
     * Sets the maxAuthSecrets value for this UserSpecParms.
     * 
     * @param maxAuthSecrets   * The maximum number of authentication secrets for
     *                             a user. A value of 0 means that no
     *                             authentication secrets can be stored.
     */
    public void setMaxAuthSecrets(Integer maxAuthSecrets) {
        this.maxAuthSecrets = maxAuthSecrets;
    }


    /**
     * Gets the maxAuthSecretsSize value for this UserSpecParms.
     * 
     * @return maxAuthSecretsSize   * The maximum size of authentication secrets for a user,
     *                             in kilobytes. A value of 0 means that
     * no
     *                             authentication secrets can be stored.
     */
    public Integer getMaxAuthSecretsSize() {
        return maxAuthSecretsSize;
    }


    /**
     * Sets the maxAuthSecretsSize value for this UserSpecParms.
     * 
     * @param maxAuthSecretsSize   * The maximum size of authentication secrets for a user,
     *                             in kilobytes. A value of 0 means that
     * no
     *                             authentication secrets can be stored.
     */
    public void setMaxAuthSecretsSize(Integer maxAuthSecretsSize) {
        this.maxAuthSecretsSize = maxAuthSecretsSize;
    }


    /**
     * Gets the maxQuestions value for this UserSpecParms.
     * 
     * @return maxQuestions   * The maximum number of questions and answer pairs for a
     *                             user. A value of 0 means that no question
     * and answer pairs can
     *                             be stored.
     */
    public Integer getMaxQuestions() {
        return maxQuestions;
    }


    /**
     * Sets the maxQuestions value for this UserSpecParms.
     * 
     * @param maxQuestions   * The maximum number of questions and answer pairs for a
     *                             user. A value of 0 means that no question
     * and answer pairs can
     *                             be stored.
     */
    public void setMaxQuestions(Integer maxQuestions) {
        this.maxQuestions = maxQuestions;
    }


    /**
     * Gets the maxQASize value for this UserSpecParms.
     * 
     * @return maxQASize   * The maximum size of questions and answer (QA) pairs stored
     * for a user,
     *                             in kilobytes. A value of 0 means that
     * no QA pairs can be stored.
     */
    public Integer getMaxQASize() {
        return maxQASize;
    }


    /**
     * Sets the maxQASize value for this UserSpecParms.
     * 
     * @param maxQASize   * The maximum size of questions and answer (QA) pairs stored
     * for a user,
     *                             in kilobytes. A value of 0 means that
     * no QA pairs can be stored.
     */
    public void setMaxQASize(Integer maxQASize) {
        this.maxQASize = maxQASize;
    }


    /**
     * Gets the QAChallengeSize value for this UserSpecParms.
     * 
     * @return QAChallengeSize   * The number of questions in a QA challenge. This value
     *                             must satisfy the restriction
     *                             1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public Integer getQAChallengeSize() {
        return QAChallengeSize;
    }


    /**
     * Sets the QAChallengeSize value for this UserSpecParms.
     * 
     * @param QAChallengeSize   * The number of questions in a QA challenge. This value
     *                             must satisfy the restriction
     *                             1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public void setQAChallengeSize(Integer QAChallengeSize) {
        this.QAChallengeSize = QAChallengeSize;
    }


    /**
     * Gets the minQAChallengeSize value for this UserSpecParms.
     * 
     * @return minQAChallengeSize   * The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default.  This value must satisfy
     * the restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public Integer getMinQAChallengeSize() {
        return minQAChallengeSize;
    }


    /**
     * Sets the minQAChallengeSize value for this UserSpecParms.
     * 
     * @param minQAChallengeSize   * The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default.  This value must satisfy
     * the restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public void setMinQAChallengeSize(Integer minQAChallengeSize) {
        this.minQAChallengeSize = minQAChallengeSize;
    }


    /**
     * Gets the maxQAChallengeSize value for this UserSpecParms.
     * 
     * @return maxQAChallengeSize   * The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default. This value must satisfy the
     * restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public Integer getMaxQAChallengeSize() {
        return maxQAChallengeSize;
    }


    /**
     * Sets the maxQAChallengeSize value for this UserSpecParms.
     * 
     * @param maxQAChallengeSize   * The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default. This value must satisfy the
     * restriction
     *                                 1<=minQAChallengeSize<=QAChallengeSize<=maxQAChallengeSize
     */
    public void setMaxQAChallengeSize(Integer maxQAChallengeSize) {
        this.maxQAChallengeSize = maxQAChallengeSize;
    }


    /**
     * Gets the disableQAChallengeRetention value for this UserSpecParms.
     * 
     * @return disableQAChallengeRetention   * If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer.
     */
    public Boolean getDisableQAChallengeRetention() {
        return disableQAChallengeRetention;
    }


    /**
     * Sets the disableQAChallengeRetention value for this UserSpecParms.
     * 
     * @param disableQAChallengeRetention   * If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer.
     */
    public void setDisableQAChallengeRetention(Boolean disableQAChallengeRetention) {
        this.disableQAChallengeRetention = disableQAChallengeRetention;
    }


    /**
     * Gets the QAChallengeLifetime value for this UserSpecParms.
     * 
     * @return QAChallengeLifetime   * Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public Integer getQAChallengeLifetime() {
        return QAChallengeLifetime;
    }


    /**
     * Sets the QAChallengeLifetime value for this UserSpecParms.
     * 
     * @param QAChallengeLifetime   * Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setQAChallengeLifetime(Integer QAChallengeLifetime) {
        this.QAChallengeLifetime = QAChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedQAChallenge value for this UserSpecParms.
     * 
     * @return updateLockoutForReplacedQAChallenge   * If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public Boolean getUpdateLockoutForReplacedQAChallenge() {
        return updateLockoutForReplacedQAChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedQAChallenge value for this UserSpecParms.
     * 
     * @param updateLockoutForReplacedQAChallenge   * If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public void setUpdateLockoutForReplacedQAChallenge(Boolean updateLockoutForReplacedQAChallenge) {
        this.updateLockoutForReplacedQAChallenge = updateLockoutForReplacedQAChallenge;
    }


    /**
     * Gets the qaDefaultWrongAnswersAllowed value for this UserSpecParms.
     * 
     * @return qaDefaultWrongAnswersAllowed   * The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     * This value must satisfy the restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaDefaultWrongAnswersAllowed must
     * be less than QAChallengeSize
     */
    public Integer getQaDefaultWrongAnswersAllowed() {
        return qaDefaultWrongAnswersAllowed;
    }


    /**
     * Sets the qaDefaultWrongAnswersAllowed value for this UserSpecParms.
     * 
     * @param qaDefaultWrongAnswersAllowed   * The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     * This value must satisfy the restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaDefaultWrongAnswersAllowed must
     * be less than QAChallengeSize
     */
    public void setQaDefaultWrongAnswersAllowed(Integer qaDefaultWrongAnswersAllowed) {
        this.qaDefaultWrongAnswersAllowed = qaDefaultWrongAnswersAllowed;
    }


    /**
     * Gets the qaMaximumWrongAnswersAllowed value for this UserSpecParms.
     * 
     * @return qaMaximumWrongAnswersAllowed   * The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct,
     * when the call
     *                                 to authenticate such a challenge overrides
     * the
     *                                 default. This value must satisfy the
     * restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaMaximumWrongAnswersAllowed must
     * be less than maxQAChallengeSize
     */
    public Integer getQaMaximumWrongAnswersAllowed() {
        return qaMaximumWrongAnswersAllowed;
    }


    /**
     * Sets the qaMaximumWrongAnswersAllowed value for this UserSpecParms.
     * 
     * @param qaMaximumWrongAnswersAllowed   * The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct,
     * when the call
     *                                 to authenticate such a challenge overrides
     * the
     *                                 default. This value must satisfy the
     * restriction
     *                                 0<=qaDefaultWrongAnswersAllowed<=qaMaximumWrongAnswersAllowed,
     * and
     *                                 qaMaximumWrongAnswersAllowed must
     * be less than maxQAChallengeSize
     */
    public void setQaMaximumWrongAnswersAllowed(Integer qaMaximumWrongAnswersAllowed) {
        this.qaMaximumWrongAnswersAllowed = qaMaximumWrongAnswersAllowed;
    }


    /**
     * Gets the qaInexactMatchAllowed value for this UserSpecParms.
     * 
     * @return qaInexactMatchAllowed   * Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge.
     */
    public Boolean getQaInexactMatchAllowed() {
        return qaInexactMatchAllowed;
    }


    /**
     * Sets the qaInexactMatchAllowed value for this UserSpecParms.
     * 
     * @param qaInexactMatchAllowed   * Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge.
     */
    public void setQaInexactMatchAllowed(Boolean qaInexactMatchAllowed) {
        this.qaInexactMatchAllowed = qaInexactMatchAllowed;
    }


    /**
     * Gets the OTPCellAlphabet value for this UserSpecParms.
     * 
     * @return OTPCellAlphabet   * The characters that can appear in a one-time password (OTP).
     */
    public String[] getOTPCellAlphabet() {
        return OTPCellAlphabet;
    }


    /**
     * Sets the OTPCellAlphabet value for this UserSpecParms.
     * 
     * @param OTPCellAlphabet   * The characters that can appear in a one-time password (OTP).
     */
    public void setOTPCellAlphabet(String[] OTPCellAlphabet) {
        this.OTPCellAlphabet = OTPCellAlphabet;
    }


    /**
     * Gets the OTPCellReplacements value for this UserSpecParms.
     * 
     * @return OTPCellReplacements   * A list of characters that are replaced in a
     *                             one-time password (OTP) response before
     * it is validated.
     */
    public CellReplacement[] getOTPCellReplacements() {
        return OTPCellReplacements;
    }


    /**
     * Sets the OTPCellReplacements value for this UserSpecParms.
     * 
     * @param OTPCellReplacements   * A list of characters that are replaced in a
     *                             one-time password (OTP) response before
     * it is validated.
     */
    public void setOTPCellReplacements(CellReplacement[] OTPCellReplacements) {
        this.OTPCellReplacements = OTPCellReplacements;
    }


    /**
     * Gets the OTPLifetime value for this UserSpecParms.
     * 
     * @return OTPLifetime   * The lifetime in seconds of a OTP.  A value of
     *                             0 means an infinite lifetime.
     */
    public Integer getOTPLifetime() {
        return OTPLifetime;
    }


    /**
     * Sets the OTPLifetime value for this UserSpecParms.
     * 
     * @param OTPLifetime   * The lifetime in seconds of a OTP.  A value of
     *                             0 means an infinite lifetime.
     */
    public void setOTPLifetime(Integer OTPLifetime) {
        this.OTPLifetime = OTPLifetime;
    }


    /**
     * Gets the OTPLength value for this UserSpecParms.
     * 
     * @return OTPLength   * The number of characters in a one-time password (OTP).
     *                                 Must be at least 1.
     */
    public Integer getOTPLength() {
        return OTPLength;
    }


    /**
     * Sets the OTPLength value for this UserSpecParms.
     * 
     * @param OTPLength   * The number of characters in a one-time password (OTP).
     *                                 Must be at least 1.
     */
    public void setOTPLength(Integer OTPLength) {
        this.OTPLength = OTPLength;
    }


    /**
     * Gets the OTPDeliveryEnabled value for this UserSpecParms.
     * 
     * @return OTPDeliveryEnabled   * Flag indicating if a user's one-time password (OTP) can be
     * delivered via
     *                             an out-of-band delivery mechanism.
     */
    public Boolean getOTPDeliveryEnabled() {
        return OTPDeliveryEnabled;
    }


    /**
     * Sets the OTPDeliveryEnabled value for this UserSpecParms.
     * 
     * @param OTPDeliveryEnabled   * Flag indicating if a user's one-time password (OTP) can be
     * delivered via
     *                             an out-of-band delivery mechanism.
     */
    public void setOTPDeliveryEnabled(Boolean OTPDeliveryEnabled) {
        this.OTPDeliveryEnabled = OTPDeliveryEnabled;
    }


    /**
     * Gets the OTPAlwaysGenerate value for this UserSpecParms.
     * 
     * @return OTPAlwaysGenerate   * Flag indicating if the OTP is generated for each
     *                             challenge request.  If set to false, a
     * new OTP
     *                             is only generated if an OTP doesn't exist
     * or the
     *                             current OTP is expired.
     */
    public Boolean getOTPAlwaysGenerate() {
        return OTPAlwaysGenerate;
    }


    /**
     * Sets the OTPAlwaysGenerate value for this UserSpecParms.
     * 
     * @param OTPAlwaysGenerate   * Flag indicating if the OTP is generated for each
     *                             challenge request.  If set to false, a
     * new OTP
     *                             is only generated if an OTP doesn't exist
     * or the
     *                             current OTP is expired.
     */
    public void setOTPAlwaysGenerate(Boolean OTPAlwaysGenerate) {
        this.OTPAlwaysGenerate = OTPAlwaysGenerate;
    }


    /**
     * Gets the OTPDynamicRefresh value for this UserSpecParms.
     * 
     * @return OTPDynamicRefresh   * Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested.
     */
    public Boolean getOTPDynamicRefresh() {
        return OTPDynamicRefresh;
    }


    /**
     * Sets the OTPDynamicRefresh value for this UserSpecParms.
     * 
     * @param OTPDynamicRefresh   * Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested.
     */
    public void setOTPDynamicRefresh(Boolean OTPDynamicRefresh) {
        this.OTPDynamicRefresh = OTPDynamicRefresh;
    }


    /**
     * Gets the OTPNumberOutstanding value for this UserSpecParms.
     * 
     * @return OTPNumberOutstanding   * Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer.
     */
    public Integer getOTPNumberOutstanding() {
        return OTPNumberOutstanding;
    }


    /**
     * Sets the OTPNumberOutstanding value for this UserSpecParms.
     * 
     * @param OTPNumberOutstanding   * Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer.
     */
    public void setOTPNumberOutstanding(Integer OTPNumberOutstanding) {
        this.OTPNumberOutstanding = OTPNumberOutstanding;
    }


    /**
     * Gets the OTPRefreshThreshold value for this UserSpecParms.
     * 
     * @return OTPRefreshThreshold   * When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy.
     */
    public Integer getOTPRefreshThreshold() {
        return OTPRefreshThreshold;
    }


    /**
     * Sets the OTPRefreshThreshold value for this UserSpecParms.
     * 
     * @param OTPRefreshThreshold   * When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy.
     */
    public void setOTPRefreshThreshold(Integer OTPRefreshThreshold) {
        this.OTPRefreshThreshold = OTPRefreshThreshold;
    }


    /**
     * Gets the returnAuthSecretWithChall value for this UserSpecParms.
     * 
     * @return returnAuthSecretWithChall   * Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge.
     */
    public Boolean getReturnAuthSecretWithChall() {
        return returnAuthSecretWithChall;
    }


    /**
     * Sets the returnAuthSecretWithChall value for this UserSpecParms.
     * 
     * @param returnAuthSecretWithChall   * Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge.
     */
    public void setReturnAuthSecretWithChall(Boolean returnAuthSecretWithChall) {
        this.returnAuthSecretWithChall = returnAuthSecretWithChall;
    }


    /**
     * Gets the autoUnassignTokens value for this UserSpecParms.
     * 
     * @return autoUnassignTokens   * Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is deleted.
     */
    public Boolean getAutoUnassignTokens() {
        return autoUnassignTokens;
    }


    /**
     * Sets the autoUnassignTokens value for this UserSpecParms.
     * 
     * @param autoUnassignTokens   * Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is deleted.
     */
    public void setAutoUnassignTokens(Boolean autoUnassignTokens) {
        this.autoUnassignTokens = autoUnassignTokens;
    }


    /**
     * Gets the autoMoveTokens value for this UserSpecParms.
     * 
     * @return autoMoveTokens   * Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group.
     */
    public Boolean getAutoMoveTokens() {
        return autoMoveTokens;
    }


    /**
     * Sets the autoMoveTokens value for this UserSpecParms.
     * 
     * @param autoMoveTokens   * Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group.
     */
    public void setAutoMoveTokens(Boolean autoMoveTokens) {
        this.autoMoveTokens = autoMoveTokens;
    }


    /**
     * Gets the disableTokenChallengeRetention value for this UserSpecParms.
     * 
     * @return disableTokenChallengeRetention   * If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request.
     */
    public Boolean getDisableTokenChallengeRetention() {
        return disableTokenChallengeRetention;
    }


    /**
     * Sets the disableTokenChallengeRetention value for this UserSpecParms.
     * 
     * @param disableTokenChallengeRetention   * If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request.
     */
    public void setDisableTokenChallengeRetention(Boolean disableTokenChallengeRetention) {
        this.disableTokenChallengeRetention = disableTokenChallengeRetention;
    }


    /**
     * Gets the tokenChallengeLifetime value for this UserSpecParms.
     * 
     * @return tokenChallengeLifetime   * Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public Integer getTokenChallengeLifetime() {
        return tokenChallengeLifetime;
    }


    /**
     * Sets the tokenChallengeLifetime value for this UserSpecParms.
     * 
     * @param tokenChallengeLifetime   * Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setTokenChallengeLifetime(Integer tokenChallengeLifetime) {
        this.tokenChallengeLifetime = tokenChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedTokenChallenge value for this UserSpecParms.
     * 
     * @return updateLockoutForReplacedTokenChallenge   * If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public Boolean getUpdateLockoutForReplacedTokenChallenge() {
        return updateLockoutForReplacedTokenChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedTokenChallenge value for this UserSpecParms.
     * 
     * @param updateLockoutForReplacedTokenChallenge   * If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public void setUpdateLockoutForReplacedTokenChallenge(Boolean updateLockoutForReplacedTokenChallenge) {
        this.updateLockoutForReplacedTokenChallenge = updateLockoutForReplacedTokenChallenge;
    }


    /**
     * Gets the maxAllowedTokenSets value for this UserSpecParms.
     * 
     * @return maxAllowedTokenSets   * The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer.
     */
    public Integer getMaxAllowedTokenSets() {
        return maxAllowedTokenSets;
    }


    /**
     * Sets the maxAllowedTokenSets value for this UserSpecParms.
     * 
     * @param maxAllowedTokenSets   * The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer.
     */
    public void setMaxAllowedTokenSets(Integer maxAllowedTokenSets) {
        this.maxAllowedTokenSets = maxAllowedTokenSets;
    }


    /**
     * Gets the allowNONEAuthentication value for this UserSpecParms.
     * 
     * @return allowNONEAuthentication   * Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request.
     */
    public Boolean getAllowNONEAuthentication() {
        return allowNONEAuthentication;
    }


    /**
     * Sets the allowNONEAuthentication value for this UserSpecParms.
     * 
     * @param allowNONEAuthentication   * Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request.
     */
    public void setAllowNONEAuthentication(Boolean allowNONEAuthentication) {
        this.allowNONEAuthentication = allowNONEAuthentication;
    }


    /**
     * Gets the considerTempPINLast value for this UserSpecParms.
     * 
     * @return considerTempPINLast   * Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type.
     */
    public Boolean getConsiderTempPINLast() {
        return considerTempPINLast;
    }


    /**
     * Sets the considerTempPINLast value for this UserSpecParms.
     * 
     * @param considerTempPINLast   * Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type.
     */
    public void setConsiderTempPINLast(Boolean considerTempPINLast) {
        this.considerTempPINLast = considerTempPINLast;
    }


    /**
     * Gets the storeLastAuthInfo value for this UserSpecParms.
     * 
     * @return storeLastAuthInfo   * Flag indicating if information about the
     *                                 last authentication for a user is
     * stored.
     */
    public Boolean getStoreLastAuthInfo() {
        return storeLastAuthInfo;
    }


    /**
     * Sets the storeLastAuthInfo value for this UserSpecParms.
     * 
     * @param storeLastAuthInfo   * Flag indicating if information about the
     *                                 last authentication for a user is
     * stored.
     */
    public void setStoreLastAuthInfo(Boolean storeLastAuthInfo) {
        this.storeLastAuthInfo = storeLastAuthInfo;
    }


    /**
     * Gets the allowCreateIfDisabledInRepository value for this UserSpecParms.
     * 
     * @return allowCreateIfDisabledInRepository   * Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public Boolean getAllowCreateIfDisabledInRepository() {
        return allowCreateIfDisabledInRepository;
    }


    /**
     * Sets the allowCreateIfDisabledInRepository value for this UserSpecParms.
     * 
     * @param allowCreateIfDisabledInRepository   * Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public void setAllowCreateIfDisabledInRepository(Boolean allowCreateIfDisabledInRepository) {
        this.allowCreateIfDisabledInRepository = allowCreateIfDisabledInRepository;
    }


    /**
     * Gets the allowCreateIfExpiredInRepository value for this UserSpecParms.
     * 
     * @return allowCreateIfExpiredInRepository   * Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public Boolean getAllowCreateIfExpiredInRepository() {
        return allowCreateIfExpiredInRepository;
    }


    /**
     * Sets the allowCreateIfExpiredInRepository value for this UserSpecParms.
     * 
     * @param allowCreateIfExpiredInRepository   * Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public void setAllowCreateIfExpiredInRepository(Boolean allowCreateIfExpiredInRepository) {
        this.allowCreateIfExpiredInRepository = allowCreateIfExpiredInRepository;
    }


    /**
     * Gets the allowAuthIfDisabledInRepository value for this UserSpecParms.
     * 
     * @return allowAuthIfDisabledInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public Boolean getAllowAuthIfDisabledInRepository() {
        return allowAuthIfDisabledInRepository;
    }


    /**
     * Sets the allowAuthIfDisabledInRepository value for this UserSpecParms.
     * 
     * @param allowAuthIfDisabledInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public void setAllowAuthIfDisabledInRepository(Boolean allowAuthIfDisabledInRepository) {
        this.allowAuthIfDisabledInRepository = allowAuthIfDisabledInRepository;
    }


    /**
     * Gets the allowAuthIfExpiredInRepository value for this UserSpecParms.
     * 
     * @return allowAuthIfExpiredInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public Boolean getAllowAuthIfExpiredInRepository() {
        return allowAuthIfExpiredInRepository;
    }


    /**
     * Sets the allowAuthIfExpiredInRepository value for this UserSpecParms.
     * 
     * @param allowAuthIfExpiredInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public void setAllowAuthIfExpiredInRepository(Boolean allowAuthIfExpiredInRepository) {
        this.allowAuthIfExpiredInRepository = allowAuthIfExpiredInRepository;
    }


    /**
     * Gets the transactionSignatureType value for this UserSpecParms.
     * 
     * @return transactionSignatureType   * Specifies how transaction receipts are signed.
     */
    public com.good.adapters.entrust.stubs.TransactionSignatureType getTransactionSignatureType() {
        return transactionSignatureType;
    }


    /**
     * Sets the transactionSignatureType value for this UserSpecParms.
     * 
     * @param transactionSignatureType   * Specifies how transaction receipts are signed.
     */
    public void setTransactionSignatureType(com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType) {
        this.transactionSignatureType = transactionSignatureType;
    }


    /**
     * Gets the transactionLifetime value for this UserSpecParms.
     * 
     * @return transactionLifetime   * Specifies the transaction lifetime in seconds.
     */
    public Integer getTransactionLifetime() {
        return transactionLifetime;
    }


    /**
     * Sets the transactionLifetime value for this UserSpecParms.
     * 
     * @param transactionLifetime   * Specifies the transaction lifetime in seconds.
     */
    public void setTransactionLifetime(Integer transactionLifetime) {
        this.transactionLifetime = transactionLifetime;
    }


    /**
     * Gets the maxNumTransactionDetails value for this UserSpecParms.
     * 
     * @return maxNumTransactionDetails   * Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction.
     */
    public Integer getMaxNumTransactionDetails() {
        return maxNumTransactionDetails;
    }


    /**
     * Sets the maxNumTransactionDetails value for this UserSpecParms.
     * 
     * @param maxNumTransactionDetails   * Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction.
     */
    public void setMaxNumTransactionDetails(Integer maxNumTransactionDetails) {
        this.maxNumTransactionDetails = maxNumTransactionDetails;
    }


    /**
     * Gets the allowSelfSignedUserCert value for this UserSpecParms.
     * 
     * @return allowSelfSignedUserCert   * Specifies if self-signed user certificates
     *                                 can be assigned to a user.
     */
    public Boolean getAllowSelfSignedUserCert() {
        return allowSelfSignedUserCert;
    }


    /**
     * Sets the allowSelfSignedUserCert value for this UserSpecParms.
     * 
     * @param allowSelfSignedUserCert   * Specifies if self-signed user certificates
     *                                 can be assigned to a user.
     */
    public void setAllowSelfSignedUserCert(Boolean allowSelfSignedUserCert) {
        this.allowSelfSignedUserCert = allowSelfSignedUserCert;
    }


    /**
     * Gets the allowCertNotIssuedByRegisteredCA value for this UserSpecParms.
     * 
     * @return allowCertNotIssuedByRegisteredCA   * Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user.
     */
    public Boolean getAllowCertNotIssuedByRegisteredCA() {
        return allowCertNotIssuedByRegisteredCA;
    }


    /**
     * Sets the allowCertNotIssuedByRegisteredCA value for this UserSpecParms.
     * 
     * @param allowCertNotIssuedByRegisteredCA   * Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user.
     */
    public void setAllowCertNotIssuedByRegisteredCA(Boolean allowCertNotIssuedByRegisteredCA) {
        this.allowCertNotIssuedByRegisteredCA = allowCertNotIssuedByRegisteredCA;
    }


    /**
     * Gets the allowAllRegisteredCAs value for this UserSpecParms.
     * 
     * @return allowAllRegisteredCAs   * Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user.  If this value
     *                                 is set to true, the AllowedRegisteredCAs
     * 
     *                                 parameter should not be set.
     */
    public Boolean getAllowAllRegisteredCAs() {
        return allowAllRegisteredCAs;
    }


    /**
     * Sets the allowAllRegisteredCAs value for this UserSpecParms.
     * 
     * @param allowAllRegisteredCAs   * Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user.  If this value
     *                                 is set to true, the AllowedRegisteredCAs
     * 
     *                                 parameter should not be set.
     */
    public void setAllowAllRegisteredCAs(Boolean allowAllRegisteredCAs) {
        this.allowAllRegisteredCAs = allowAllRegisteredCAs;
    }


    /**
     * Gets the addAllowedRegisteredCAs value for this UserSpecParms.
     * 
     * @return addAllowedRegisteredCAs   * If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true.
     */
    public Boolean getAddAllowedRegisteredCAs() {
        return addAllowedRegisteredCAs;
    }


    /**
     * Sets the addAllowedRegisteredCAs value for this UserSpecParms.
     * 
     * @param addAllowedRegisteredCAs   * If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true.
     */
    public void setAddAllowedRegisteredCAs(Boolean addAllowedRegisteredCAs) {
        this.addAllowedRegisteredCAs = addAllowedRegisteredCAs;
    }


    /**
     * Gets the removeAllowedRegisteredCAs value for this UserSpecParms.
     * 
     * @return removeAllowedRegisteredCAs   * If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true.
     */
    public Boolean getRemoveAllowedRegisteredCAs() {
        return removeAllowedRegisteredCAs;
    }


    /**
     * Sets the removeAllowedRegisteredCAs value for this UserSpecParms.
     * 
     * @param removeAllowedRegisteredCAs   * If this value is set to true, the values
     *                                 specified in the AllowedRegisteredCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedRegisteredCAs and
     *                                 RemoveAllowedRegisteredCAs can not
     * be set to
     *                                 true.
     */
    public void setRemoveAllowedRegisteredCAs(Boolean removeAllowedRegisteredCAs) {
        this.removeAllowedRegisteredCAs = removeAllowedRegisteredCAs;
    }


    /**
     * Gets the allowedRegisteredCAs value for this UserSpecParms.
     * 
     * @return allowedRegisteredCAs   * User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllRegistredCAs value is
     * set to true,
     *                                 this value should not be set.
     */
    public String[] getAllowedRegisteredCAs() {
        return allowedRegisteredCAs;
    }


    /**
     * Sets the allowedRegisteredCAs value for this UserSpecParms.
     * 
     * @param allowedRegisteredCAs   * User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllRegistredCAs value is
     * set to true,
     *                                 this value should not be set.
     */
    public void setAllowedRegisteredCAs(String[] allowedRegisteredCAs) {
        this.allowedRegisteredCAs = allowedRegisteredCAs;
    }


    /**
     * Gets the allowCertNotIssuedByManagedCA value for this UserSpecParms.
     * 
     * @return allowCertNotIssuedByManagedCA   * Specifies if a user certificate that is
     *                                 not issued by a managed CA can be
     *                                 used to authenticate a user.
     */
    public Boolean getAllowCertNotIssuedByManagedCA() {
        return allowCertNotIssuedByManagedCA;
    }


    /**
     * Sets the allowCertNotIssuedByManagedCA value for this UserSpecParms.
     * 
     * @param allowCertNotIssuedByManagedCA   * Specifies if a user certificate that is
     *                                 not issued by a managed CA can be
     *                                 used to authenticate a user.
     */
    public void setAllowCertNotIssuedByManagedCA(Boolean allowCertNotIssuedByManagedCA) {
        this.allowCertNotIssuedByManagedCA = allowCertNotIssuedByManagedCA;
    }


    /**
     * Gets the allowAllManagedCAs value for this UserSpecParms.
     * 
     * @return allowAllManagedCAs   * Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user.
     *                                 If this value is set to true, the
     * AllowedManagedCAs 
     *                                 parameter should not be set.
     */
    public Boolean getAllowAllManagedCAs() {
        return allowAllManagedCAs;
    }


    /**
     * Sets the allowAllManagedCAs value for this UserSpecParms.
     * 
     * @param allowAllManagedCAs   * Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user.
     *                                 If this value is set to true, the
     * AllowedManagedCAs 
     *                                 parameter should not be set.
     */
    public void setAllowAllManagedCAs(Boolean allowAllManagedCAs) {
        this.allowAllManagedCAs = allowAllManagedCAs;
    }


    /**
     * Gets the addAllowedManagedCAs value for this UserSpecParms.
     * 
     * @return addAllowedManagedCAs   * If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true.
     */
    public Boolean getAddAllowedManagedCAs() {
        return addAllowedManagedCAs;
    }


    /**
     * Sets the addAllowedManagedCAs value for this UserSpecParms.
     * 
     * @param addAllowedManagedCAs   * If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true.
     */
    public void setAddAllowedManagedCAs(Boolean addAllowedManagedCAs) {
        this.addAllowedManagedCAs = addAllowedManagedCAs;
    }


    /**
     * Gets the removeAllowedManagedCAs value for this UserSpecParms.
     * 
     * @return removeAllowedManagedCAs   * If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true.
     */
    public Boolean getRemoveAllowedManagedCAs() {
        return removeAllowedManagedCAs;
    }


    /**
     * Sets the removeAllowedManagedCAs value for this UserSpecParms.
     * 
     * @param removeAllowedManagedCAs   * If this value is set to true, the values
     *                                 specified in the AllowedManagedCAs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedManagedCAs and
     *                                 RemoveAllowedManagedCAs can not be
     * set to
     *                                 true.
     */
    public void setRemoveAllowedManagedCAs(Boolean removeAllowedManagedCAs) {
        this.removeAllowedManagedCAs = removeAllowedManagedCAs;
    }


    /**
     * Gets the allowedManagedCAs value for this UserSpecParms.
     * 
     * @return allowedManagedCAs   * User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllManagedCAs value is set
     * to true,
     *                                 this value should not be set.
     */
    public String[] getAllowedManagedCAs() {
        return allowedManagedCAs;
    }


    /**
     * Sets the allowedManagedCAs value for this UserSpecParms.
     * 
     * @param allowedManagedCAs   * User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set.
     * If
     *                                 the AllowAllManagedCAs value is set
     * to true,
     *                                 this value should not be set.
     */
    public void setAllowedManagedCAs(String[] allowedManagedCAs) {
        this.allowedManagedCAs = allowedManagedCAs;
    }


    /**
     * Gets the certificateAuthenticationHashAlg value for this UserSpecParms.
     * 
     * @return certificateAuthenticationHashAlg   * Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256.  If not
     *                                 specified, this value defaults to
     * SHA-256.
     */
    public String getCertificateAuthenticationHashAlg() {
        return certificateAuthenticationHashAlg;
    }


    /**
     * Sets the certificateAuthenticationHashAlg value for this UserSpecParms.
     * 
     * @param certificateAuthenticationHashAlg   * Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256.  If not
     *                                 specified, this value defaults to
     * SHA-256.
     */
    public void setCertificateAuthenticationHashAlg(String certificateAuthenticationHashAlg) {
        this.certificateAuthenticationHashAlg = certificateAuthenticationHashAlg;
    }


    /**
     * Gets the certificateAuthenticationChallengeSize value for this UserSpecParms.
     * 
     * @return certificateAuthenticationChallengeSize   * Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32.
     */
    public Integer getCertificateAuthenticationChallengeSize() {
        return certificateAuthenticationChallengeSize;
    }


    /**
     * Sets the certificateAuthenticationChallengeSize value for this UserSpecParms.
     * 
     * @param certificateAuthenticationChallengeSize   * Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32.
     */
    public void setCertificateAuthenticationChallengeSize(Integer certificateAuthenticationChallengeSize) {
        this.certificateAuthenticationChallengeSize = certificateAuthenticationChallengeSize;
    }


    /**
     * Gets the maxCertsPerUser value for this UserSpecParms.
     * 
     * @return maxCertsPerUser   * Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public Integer getMaxCertsPerUser() {
        return maxCertsPerUser;
    }


    /**
     * Sets the maxCertsPerUser value for this UserSpecParms.
     * 
     * @param maxCertsPerUser   * Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxCertsPerUser(Integer maxCertsPerUser) {
        this.maxCertsPerUser = maxCertsPerUser;
    }


    /**
     * Gets the autoDeleteUserCerts value for this UserSpecParms.
     * 
     * @return autoDeleteUserCerts   * A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user.
     */
    public Boolean getAutoDeleteUserCerts() {
        return autoDeleteUserCerts;
    }


    /**
     * Sets the autoDeleteUserCerts value for this UserSpecParms.
     * 
     * @param autoDeleteUserCerts   * A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user.
     */
    public void setAutoDeleteUserCerts(Boolean autoDeleteUserCerts) {
        this.autoDeleteUserCerts = autoDeleteUserCerts;
    }


    /**
     * Gets the disableCertificateChallengeRetention value for this UserSpecParms.
     * 
     * @return disableCertificateChallengeRetention   * If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request.
     */
    public Boolean getDisableCertificateChallengeRetention() {
        return disableCertificateChallengeRetention;
    }


    /**
     * Sets the disableCertificateChallengeRetention value for this UserSpecParms.
     * 
     * @param disableCertificateChallengeRetention   * If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request.
     */
    public void setDisableCertificateChallengeRetention(Boolean disableCertificateChallengeRetention) {
        this.disableCertificateChallengeRetention = disableCertificateChallengeRetention;
    }


    /**
     * Gets the allowCertificateChallengeDelivery value for this UserSpecParms.
     * 
     * @return allowCertificateChallengeDelivery   * If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public Boolean getAllowCertificateChallengeDelivery() {
        return allowCertificateChallengeDelivery;
    }


    /**
     * Sets the allowCertificateChallengeDelivery value for this UserSpecParms.
     * 
     * @param allowCertificateChallengeDelivery   * If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public void setAllowCertificateChallengeDelivery(Boolean allowCertificateChallengeDelivery) {
        this.allowCertificateChallengeDelivery = allowCertificateChallengeDelivery;
    }


    /**
     * Gets the allowCertificateTransactionDelivery value for this UserSpecParms.
     * 
     * @return allowCertificateTransactionDelivery   * If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public Boolean getAllowCertificateTransactionDelivery() {
        return allowCertificateTransactionDelivery;
    }


    /**
     * Sets the allowCertificateTransactionDelivery value for this UserSpecParms.
     * 
     * @param allowCertificateTransactionDelivery   * If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public void setAllowCertificateTransactionDelivery(Boolean allowCertificateTransactionDelivery) {
        this.allowCertificateTransactionDelivery = allowCertificateTransactionDelivery;
    }


    /**
     * Gets the allowCertificateSign value for this UserSpecParms.
     * 
     * @return allowCertificateSign   * If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges.
     */
    public Boolean getAllowCertificateSign() {
        return allowCertificateSign;
    }


    /**
     * Sets the allowCertificateSign value for this UserSpecParms.
     * 
     * @param allowCertificateSign   * If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges.
     */
    public void setAllowCertificateSign(Boolean allowCertificateSign) {
        this.allowCertificateSign = allowCertificateSign;
    }


    /**
     * Gets the certificateChallengeLifetime value for this UserSpecParms.
     * 
     * @return certificateChallengeLifetime   * Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public Integer getCertificateChallengeLifetime() {
        return certificateChallengeLifetime;
    }


    /**
     * Sets the certificateChallengeLifetime value for this UserSpecParms.
     * 
     * @param certificateChallengeLifetime   * Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setCertificateChallengeLifetime(Integer certificateChallengeLifetime) {
        this.certificateChallengeLifetime = certificateChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedCertificateChallenge value for this UserSpecParms.
     * 
     * @return updateLockoutForReplacedCertificateChallenge   * If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public Boolean getUpdateLockoutForReplacedCertificateChallenge() {
        return updateLockoutForReplacedCertificateChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedCertificateChallenge value for this UserSpecParms.
     * 
     * @param updateLockoutForReplacedCertificateChallenge   * If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public void setUpdateLockoutForReplacedCertificateChallenge(Boolean updateLockoutForReplacedCertificateChallenge) {
        this.updateLockoutForReplacedCertificateChallenge = updateLockoutForReplacedCertificateChallenge;
    }


    /**
     * Gets the allowAllSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @return allowAllSmartCredentialDefinitions   * Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user.
     */
    public Boolean getAllowAllSmartCredentialDefinitions() {
        return allowAllSmartCredentialDefinitions;
    }


    /**
     * Sets the allowAllSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @param allowAllSmartCredentialDefinitions   * Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user.
     */
    public void setAllowAllSmartCredentialDefinitions(Boolean allowAllSmartCredentialDefinitions) {
        this.allowAllSmartCredentialDefinitions = allowAllSmartCredentialDefinitions;
    }


    /**
     * Gets the addAllowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @return addAllowedSmartCredentialDefinitions   * If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set
     *                                 to true.
     */
    public Boolean getAddAllowedSmartCredentialDefinitions() {
        return addAllowedSmartCredentialDefinitions;
    }


    /**
     * Sets the addAllowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @param addAllowedSmartCredentialDefinitions   * If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set
     *                                 to true.
     */
    public void setAddAllowedSmartCredentialDefinitions(Boolean addAllowedSmartCredentialDefinitions) {
        this.addAllowedSmartCredentialDefinitions = addAllowedSmartCredentialDefinitions;
    }


    /**
     * Gets the removeAllowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @return removeAllowedSmartCredentialDefinitions   * If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set to
     *                                 true.
     */
    public Boolean getRemoveAllowedSmartCredentialDefinitions() {
        return removeAllowedSmartCredentialDefinitions;
    }


    /**
     * Sets the removeAllowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @param removeAllowedSmartCredentialDefinitions   * If this value is set to true, the values
     *                                 specified in the AllowedSmartCredentialDefinitions
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedSmartCredentialDefinitions
     * and
     *                                 RemoveAllowedSmartCredentialDefinitions
     * can not be set to
     *                                 true.
     */
    public void setRemoveAllowedSmartCredentialDefinitions(Boolean removeAllowedSmartCredentialDefinitions) {
        this.removeAllowedSmartCredentialDefinitions = removeAllowedSmartCredentialDefinitions;
    }


    /**
     * Gets the allowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @return allowedSmartCredentialDefinitions   * Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedSmartCredentialDefinitions() {
        return allowedSmartCredentialDefinitions;
    }


    /**
     * Sets the allowedSmartCredentialDefinitions value for this UserSpecParms.
     * 
     * @param allowedSmartCredentialDefinitions   * Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedSmartCredentialDefinitions(String[] allowedSmartCredentialDefinitions) {
        this.allowedSmartCredentialDefinitions = allowedSmartCredentialDefinitions;
    }


    /**
     * Gets the maxSmartCredentialsPerUser value for this UserSpecParms.
     * 
     * @return maxSmartCredentialsPerUser   * Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public Integer getMaxSmartCredentialsPerUser() {
        return maxSmartCredentialsPerUser;
    }


    /**
     * Sets the maxSmartCredentialsPerUser value for this UserSpecParms.
     * 
     * @param maxSmartCredentialsPerUser   * Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxSmartCredentialsPerUser(Integer maxSmartCredentialsPerUser) {
        this.maxSmartCredentialsPerUser = maxSmartCredentialsPerUser;
    }


    /**
     * Gets the smartCredentialIDPrefix value for this UserSpecParms.
     * 
     * @return smartCredentialIDPrefix   * The prefix added to Smart Credential Ids.
     */
    public String getSmartCredentialIDPrefix() {
        return smartCredentialIDPrefix;
    }


    /**
     * Sets the smartCredentialIDPrefix value for this UserSpecParms.
     * 
     * @param smartCredentialIDPrefix   * The prefix added to Smart Credential Ids.
     */
    public void setSmartCredentialIDPrefix(String smartCredentialIDPrefix) {
        this.smartCredentialIDPrefix = smartCredentialIDPrefix;
    }


    /**
     * Gets the smartCredentialTokenVendor value for this UserSpecParms.
     * 
     * @return smartCredentialTokenVendor   * The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation. Specify an
     * empty
     *                                 string value to remove the current
     * value.
     */
    public String getSmartCredentialTokenVendor() {
        return smartCredentialTokenVendor;
    }


    /**
     * Sets the smartCredentialTokenVendor value for this UserSpecParms.
     * 
     * @param smartCredentialTokenVendor   * The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation. Specify an
     * empty
     *                                 string value to remove the current
     * value.
     */
    public void setSmartCredentialTokenVendor(String smartCredentialTokenVendor) {
        this.smartCredentialTokenVendor = smartCredentialTokenVendor;
    }


    /**
     * Gets the autoUnassignSmartCredentials value for this UserSpecParms.
     * 
     * @return autoUnassignSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the user
     *                                 they belong to is deleted.
     */
    public Boolean getAutoUnassignSmartCredentials() {
        return autoUnassignSmartCredentials;
    }


    /**
     * Sets the autoUnassignSmartCredentials value for this UserSpecParms.
     * 
     * @param autoUnassignSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the user
     *                                 they belong to is deleted.
     */
    public void setAutoUnassignSmartCredentials(Boolean autoUnassignSmartCredentials) {
        this.autoUnassignSmartCredentials = autoUnassignSmartCredentials;
    }


    /**
     * Gets the autoCancelSmartCredentials value for this UserSpecParms.
     * 
     * @return autoCancelSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned.
     */
    public Boolean getAutoCancelSmartCredentials() {
        return autoCancelSmartCredentials;
    }


    /**
     * Sets the autoCancelSmartCredentials value for this UserSpecParms.
     * 
     * @param autoCancelSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned.
     */
    public void setAutoCancelSmartCredentials(Boolean autoCancelSmartCredentials) {
        this.autoCancelSmartCredentials = autoCancelSmartCredentials;
    }


    /**
     * Gets the autoCancelSmartCredentialsForce value for this UserSpecParms.
     * 
     * @return autoCancelSmartCredentialsForce   * Flag indicating if the force option is applied
     *                                 when auto-canceling smart credentials.
     * This option only applies when
     *                                 AutoCancelSmartCredentials is true.
     */
    public Boolean getAutoCancelSmartCredentialsForce() {
        return autoCancelSmartCredentialsForce;
    }


    /**
     * Sets the autoCancelSmartCredentialsForce value for this UserSpecParms.
     * 
     * @param autoCancelSmartCredentialsForce   * Flag indicating if the force option is applied
     *                                 when auto-canceling smart credentials.
     * This option only applies when
     *                                 AutoCancelSmartCredentials is true.
     */
    public void setAutoCancelSmartCredentialsForce(Boolean autoCancelSmartCredentialsForce) {
        this.autoCancelSmartCredentialsForce = autoCancelSmartCredentialsForce;
    }


    /**
     * Gets the autoMoveSmartCredentials value for this UserSpecParms.
     * 
     * @return autoMoveSmartCredentials   * Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group.
     */
    public Boolean getAutoMoveSmartCredentials() {
        return autoMoveSmartCredentials;
    }


    /**
     * Sets the autoMoveSmartCredentials value for this UserSpecParms.
     * 
     * @param autoMoveSmartCredentials   * Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group.
     */
    public void setAutoMoveSmartCredentials(Boolean autoMoveSmartCredentials) {
        this.autoMoveSmartCredentials = autoMoveSmartCredentials;
    }


    /**
     * Gets the autoRegisterSmartCredentialsToPACS value for this UserSpecParms.
     * 
     * @return autoRegisterSmartCredentialsToPACS   * Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued.
     */
    public Boolean getAutoRegisterSmartCredentialsToPACS() {
        return autoRegisterSmartCredentialsToPACS;
    }


    /**
     * Sets the autoRegisterSmartCredentialsToPACS value for this UserSpecParms.
     * 
     * @param autoRegisterSmartCredentialsToPACS   * Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued.
     */
    public void setAutoRegisterSmartCredentialsToPACS(Boolean autoRegisterSmartCredentialsToPACS) {
        this.autoRegisterSmartCredentialsToPACS = autoRegisterSmartCredentialsToPACS;
    }


    /**
     * Gets the autoSuspendSmartCredentialsFromPACS value for this UserSpecParms.
     * 
     * @return autoSuspendSmartCredentialsFromPACS   * Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted.
     */
    public Boolean getAutoSuspendSmartCredentialsFromPACS() {
        return autoSuspendSmartCredentialsFromPACS;
    }


    /**
     * Sets the autoSuspendSmartCredentialsFromPACS value for this UserSpecParms.
     * 
     * @param autoSuspendSmartCredentialsFromPACS   * Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted.
     */
    public void setAutoSuspendSmartCredentialsFromPACS(Boolean autoSuspendSmartCredentialsFromPACS) {
        this.autoSuspendSmartCredentialsFromPACS = autoSuspendSmartCredentialsFromPACS;
    }


    /**
     * Gets the allowSoftwareSmartCredentials value for this UserSpecParms.
     * 
     * @return allowSoftwareSmartCredentials   * Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy.
     */
    public Boolean getAllowSoftwareSmartCredentials() {
        return allowSoftwareSmartCredentials;
    }


    /**
     * Sets the allowSoftwareSmartCredentials value for this UserSpecParms.
     * 
     * @param allowSoftwareSmartCredentials   * Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy.
     */
    public void setAllowSoftwareSmartCredentials(Boolean allowSoftwareSmartCredentials) {
        this.allowSoftwareSmartCredentials = allowSoftwareSmartCredentials;
    }


    /**
     * Gets the mobileSmartCredentialPINPrompt value for this UserSpecParms.
     * 
     * @return mobileSmartCredentialPINPrompt   * Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN.
     */
    public PINPromptType getMobileSmartCredentialPINPrompt() {
        return mobileSmartCredentialPINPrompt;
    }


    /**
     * Sets the mobileSmartCredentialPINPrompt value for this UserSpecParms.
     * 
     * @param mobileSmartCredentialPINPrompt   * Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN.
     */
    public void setMobileSmartCredentialPINPrompt(PINPromptType mobileSmartCredentialPINPrompt) {
        this.mobileSmartCredentialPINPrompt = mobileSmartCredentialPINPrompt;
    }


    /**
     * Gets the mobileSmartCredentialSessionTimeout value for this UserSpecParms.
     * 
     * @return mobileSmartCredentialSessionTimeout   * Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION.
     */
    public Integer getMobileSmartCredentialSessionTimeout() {
        return mobileSmartCredentialSessionTimeout;
    }


    /**
     * Sets the mobileSmartCredentialSessionTimeout value for this UserSpecParms.
     * 
     * @param mobileSmartCredentialSessionTimeout   * Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION.
     */
    public void setMobileSmartCredentialSessionTimeout(Integer mobileSmartCredentialSessionTimeout) {
        this.mobileSmartCredentialSessionTimeout = mobileSmartCredentialSessionTimeout;
    }


    /**
     * Gets the allowAllDigitalIdConfigs value for this UserSpecParms.
     * 
     * @return allowAllDigitalIdConfigs   * Specifies that any Digital Id Configs can be
     *                                 used to create Digital Ids for a user.
     */
    public Boolean getAllowAllDigitalIdConfigs() {
        return allowAllDigitalIdConfigs;
    }


    /**
     * Sets the allowAllDigitalIdConfigs value for this UserSpecParms.
     * 
     * @param allowAllDigitalIdConfigs   * Specifies that any Digital Id Configs can be
     *                                 used to create Digital Ids for a user.
     */
    public void setAllowAllDigitalIdConfigs(Boolean allowAllDigitalIdConfigs) {
        this.allowAllDigitalIdConfigs = allowAllDigitalIdConfigs;
    }


    /**
     * Gets the addAllowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @return addAllowedDigitalIdConfigs   * If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set
     *                                 to true.
     */
    public Boolean getAddAllowedDigitalIdConfigs() {
        return addAllowedDigitalIdConfigs;
    }


    /**
     * Sets the addAllowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @param addAllowedDigitalIdConfigs   * If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are added to the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set
     *                                 to true.
     */
    public void setAddAllowedDigitalIdConfigs(Boolean addAllowedDigitalIdConfigs) {
        this.addAllowedDigitalIdConfigs = addAllowedDigitalIdConfigs;
    }


    /**
     * Gets the removeAllowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @return removeAllowedDigitalIdConfigs   * If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set to
     *                                 true.
     */
    public Boolean getRemoveAllowedDigitalIdConfigs() {
        return removeAllowedDigitalIdConfigs;
    }


    /**
     * Sets the removeAllowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @param removeAllowedDigitalIdConfigs   * If this value is set to true, the values
     *                                 specified in the AllowedDigitalIdConfigs
     * parameter are removed from the existing values
     *                                 instead of overwriting them.
     *                                 Both AddAllowedDigitalIdConfigs and
     * RemoveAllowedDigitalIdConfigs can not be set to
     *                                 true.
     */
    public void setRemoveAllowedDigitalIdConfigs(Boolean removeAllowedDigitalIdConfigs) {
        this.removeAllowedDigitalIdConfigs = removeAllowedDigitalIdConfigs;
    }


    /**
     * Gets the allowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @return allowedDigitalIdConfigs   * Specifies a list of Digital Ids Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedDigitalIdConfigs() {
        return allowedDigitalIdConfigs;
    }


    /**
     * Sets the allowedDigitalIdConfigs value for this UserSpecParms.
     * 
     * @param allowedDigitalIdConfigs   * Specifies a list of Digital Ids Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedDigitalIdConfigs(String[] allowedDigitalIdConfigs) {
        this.allowedDigitalIdConfigs = allowedDigitalIdConfigs;
    }


    /**
     * Gets the maxDigitalIdsPerUser value for this UserSpecParms.
     * 
     * @return maxDigitalIdsPerUser   * Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public Integer getMaxDigitalIdsPerUser() {
        return maxDigitalIdsPerUser;
    }


    /**
     * Sets the maxDigitalIdsPerUser value for this UserSpecParms.
     * 
     * @param maxDigitalIdsPerUser   * Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxDigitalIdsPerUser(Integer maxDigitalIdsPerUser) {
        this.maxDigitalIdsPerUser = maxDigitalIdsPerUser;
    }


    /**
     * Gets the maxClientTypesPerDigitalId value for this UserSpecParms.
     * 
     * @return maxClientTypesPerDigitalId   * Specifies the maximum number of Client Types
     *                                 per Digital Id.
     *                                 This value must be a non-negative
     * integer.
     */
    public Integer getMaxClientTypesPerDigitalId() {
        return maxClientTypesPerDigitalId;
    }


    /**
     * Sets the maxClientTypesPerDigitalId value for this UserSpecParms.
     * 
     * @param maxClientTypesPerDigitalId   * Specifies the maximum number of Client Types
     *                                 per Digital Id.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxClientTypesPerDigitalId(Integer maxClientTypesPerDigitalId) {
        this.maxClientTypesPerDigitalId = maxClientTypesPerDigitalId;
    }


    /**
     * Gets the autoCancelDigitalIds value for this UserSpecParms.
     * 
     * @return autoCancelDigitalIds   * Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted.
     */
    public Boolean getAutoCancelDigitalIds() {
        return autoCancelDigitalIds;
    }


    /**
     * Sets the autoCancelDigitalIds value for this UserSpecParms.
     * 
     * @param autoCancelDigitalIds   * Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted.
     */
    public void setAutoCancelDigitalIds(Boolean autoCancelDigitalIds) {
        this.autoCancelDigitalIds = autoCancelDigitalIds;
    }


    /**
     * Gets the userRegistrationPasswordLifetime value for this UserSpecParms.
     * 
     * @return userRegistrationPasswordLifetime   * User registration password lifetime in minutes. 
     *                                 This value must be a non-negative
     * integer.
     *                                 A value of 0 means infinite lifetime.
     */
    public Integer getUserRegistrationPasswordLifetime() {
        return userRegistrationPasswordLifetime;
    }


    /**
     * Sets the userRegistrationPasswordLifetime value for this UserSpecParms.
     * 
     * @param userRegistrationPasswordLifetime   * User registration password lifetime in minutes. 
     *                                 This value must be a non-negative
     * integer.
     *                                 A value of 0 means infinite lifetime.
     */
    public void setUserRegistrationPasswordLifetime(Integer userRegistrationPasswordLifetime) {
        this.userRegistrationPasswordLifetime = userRegistrationPasswordLifetime;
    }


    /**
     * Gets the userRegistrationPasswordLength value for this UserSpecParms.
     * 
     * @return userRegistrationPasswordLength   * The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32.
     */
    public Integer getUserRegistrationPasswordLength() {
        return userRegistrationPasswordLength;
    }


    /**
     * Sets the userRegistrationPasswordLength value for this UserSpecParms.
     * 
     * @param userRegistrationPasswordLength   * The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32.
     */
    public void setUserRegistrationPasswordLength(Integer userRegistrationPasswordLength) {
        this.userRegistrationPasswordLength = userRegistrationPasswordLength;
    }


    /**
     * Gets the maxFederationsPerUser value for this UserSpecParms.
     * 
     * @return maxFederationsPerUser   * Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public Integer getMaxFederationsPerUser() {
        return maxFederationsPerUser;
    }


    /**
     * Sets the maxFederationsPerUser value for this UserSpecParms.
     * 
     * @param maxFederationsPerUser   * Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxFederationsPerUser(Integer maxFederationsPerUser) {
        this.maxFederationsPerUser = maxFederationsPerUser;
    }


    /**
     * Gets the maxNumUserPreferences value for this UserSpecParms.
     * 
     * @return maxNumUserPreferences   * The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer.
     */
    public Integer getMaxNumUserPreferences() {
        return maxNumUserPreferences;
    }


    /**
     * Sets the maxNumUserPreferences value for this UserSpecParms.
     * 
     * @param maxNumUserPreferences   * The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer.
     */
    public void setMaxNumUserPreferences(Integer maxNumUserPreferences) {
        this.maxNumUserPreferences = maxNumUserPreferences;
    }


    /**
     * Gets the maxSizeUserPreference value for this UserSpecParms.
     * 
     * @return maxSizeUserPreference   * The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer.
     */
    public Integer getMaxSizeUserPreference() {
        return maxSizeUserPreference;
    }


    /**
     * Sets the maxSizeUserPreference value for this UserSpecParms.
     * 
     * @param maxSizeUserPreference   * The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer.
     */
    public void setMaxSizeUserPreference(Integer maxSizeUserPreference) {
        this.maxSizeUserPreference = maxSizeUserPreference;
    }


    /**
     * Gets the PVNLength value for this UserSpecParms.
     * 
     * @return PVNLength   * The required length of new personal verification
     *                                 numbers (PVNs).
     */
    public Integer getPVNLength() {
        return PVNLength;
    }


    /**
     * Sets the PVNLength value for this UserSpecParms.
     * 
     * @param PVNLength   * The required length of new personal verification
     *                                 numbers (PVNs).
     */
    public void setPVNLength(Integer PVNLength) {
        this.PVNLength = PVNLength;
    }


    /**
     * Gets the PVNChangeRequiredOnAdminReset value for this UserSpecParms.
     * 
     * @return PVNChangeRequiredOnAdminReset   * Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator.
     */
    public Boolean getPVNChangeRequiredOnAdminReset() {
        return PVNChangeRequiredOnAdminReset;
    }


    /**
     * Sets the PVNChangeRequiredOnAdminReset value for this UserSpecParms.
     * 
     * @param PVNChangeRequiredOnAdminReset   * Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator.
     */
    public void setPVNChangeRequiredOnAdminReset(Boolean PVNChangeRequiredOnAdminReset) {
        this.PVNChangeRequiredOnAdminReset = PVNChangeRequiredOnAdminReset;
    }


    /**
     * Gets the authTypesRequiringPVN value for this UserSpecParms.
     * 
     * @return authTypesRequiringPVN   * The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating.
     *                                 This list can only include the GRID,
     * TOKENRO, TOKENCR
     *                                 and OTP authentication types.
     */
    public AuthenticationType[] getAuthTypesRequiringPVN() {
        return authTypesRequiringPVN;
    }


    /**
     * Sets the authTypesRequiringPVN value for this UserSpecParms.
     * 
     * @param authTypesRequiringPVN   * The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating.
     *                                 This list can only include the GRID,
     * TOKENRO, TOKENCR
     *                                 and OTP authentication types.
     */
    public void setAuthTypesRequiringPVN(AuthenticationType[] authTypesRequiringPVN) {
        this.authTypesRequiringPVN = authTypesRequiringPVN;
    }


    /**
     * Gets the allTokenVendorsRequirePVN value for this UserSpecParms.
     * 
     * @return allTokenVendorsRequirePVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true.
     */
    public Boolean getAllTokenVendorsRequirePVN() {
        return allTokenVendorsRequirePVN;
    }


    /**
     * Sets the allTokenVendorsRequirePVN value for this UserSpecParms.
     * 
     * @param allTokenVendorsRequirePVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true.
     */
    public void setAllTokenVendorsRequirePVN(Boolean allTokenVendorsRequirePVN) {
        this.allTokenVendorsRequirePVN = allTokenVendorsRequirePVN;
    }


    /**
     * Gets the tokenVendorsRequiringPVN value for this UserSpecParms.
     * 
     * @return tokenVendorsRequiringPVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true.
     */
    public String[] getTokenVendorsRequiringPVN() {
        return tokenVendorsRequiringPVN;
    }


    /**
     * Sets the tokenVendorsRequiringPVN value for this UserSpecParms.
     * 
     * @param tokenVendorsRequiringPVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true.
     */
    public void setTokenVendorsRequiringPVN(String[] tokenVendorsRequiringPVN) {
        this.tokenVendorsRequiringPVN = tokenVendorsRequiringPVN;
    }


    /**
     * Gets the numDaysForActivation value for this UserSpecParms.
     * 
     * @return numDaysForActivation   * The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately.
     */
    public Integer getNumDaysForActivation() {
        return numDaysForActivation;
    }


    /**
     * Sets the numDaysForActivation value for this UserSpecParms.
     * 
     * @param numDaysForActivation   * The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately.
     */
    public void setNumDaysForActivation(Integer numDaysForActivation) {
        this.numDaysForActivation = numDaysForActivation;
    }


    /**
     * Gets the activationAuthTypes value for this UserSpecParms.
     * 
     * @return activationAuthTypes   * The authentication types that trigger user activation on
     *                                 the first successful authentication
     * with one of these
     *                                 types. This list can only include
     * the GRID, TOKENRO,
     *                                 and TOKENCR authentication types.
     */
    public AuthenticationType[] getActivationAuthTypes() {
        return activationAuthTypes;
    }


    /**
     * Sets the activationAuthTypes value for this UserSpecParms.
     * 
     * @param activationAuthTypes   * The authentication types that trigger user activation on
     *                                 the first successful authentication
     * with one of these
     *                                 types. This list can only include
     * the GRID, TOKENRO,
     *                                 and TOKENCR authentication types.
     */
    public void setActivationAuthTypes(AuthenticationType[] activationAuthTypes) {
        this.activationAuthTypes = activationAuthTypes;
    }


    /**
     * Gets the checkIPAddressInLocationHistory value for this UserSpecParms.
     * 
     * @return checkIPAddressInLocationHistory   * Indicate if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history.
     */
    public Boolean getCheckIPAddressInLocationHistory() {
        return checkIPAddressInLocationHistory;
    }


    /**
     * Sets the checkIPAddressInLocationHistory value for this UserSpecParms.
     * 
     * @param checkIPAddressInLocationHistory   * Indicate if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history.
     */
    public void setCheckIPAddressInLocationHistory(Boolean checkIPAddressInLocationHistory) {
        this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
    }


    /**
     * Gets the maxLocationHistorySize value for this UserSpecParms.
     * 
     * @return maxLocationHistorySize   * The maximum size of a user's location history.
     */
    public Integer getMaxLocationHistorySize() {
        return maxLocationHistorySize;
    }


    /**
     * Sets the maxLocationHistorySize value for this UserSpecParms.
     * 
     * @param maxLocationHistorySize   * The maximum size of a user's location history.
     */
    public void setMaxLocationHistorySize(Integer maxLocationHistorySize) {
        this.maxLocationHistorySize = maxLocationHistorySize;
    }


    /**
     * Gets the locationHistoryLifetime value for this UserSpecParms.
     * 
     * @return locationHistoryLifetime   * The lifetime (in days) of an entry in the
     *                                 user's location history.
     */
    public Integer getLocationHistoryLifetime() {
        return locationHistoryLifetime;
    }


    /**
     * Sets the locationHistoryLifetime value for this UserSpecParms.
     * 
     * @param locationHistoryLifetime   * The lifetime (in days) of an entry in the
     *                                 user's location history.
     */
    public void setLocationHistoryLifetime(Integer locationHistoryLifetime) {
        this.locationHistoryLifetime = locationHistoryLifetime;
    }


    /**
     * Gets the maxVelocity value for this UserSpecParms.
     * 
     * @return maxVelocity   * The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication.
     */
    public Integer getMaxVelocity() {
        return maxVelocity;
    }


    /**
     * Sets the maxVelocity value for this UserSpecParms.
     * 
     * @param maxVelocity   * The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication.
     */
    public void setMaxVelocity(Integer maxVelocity) {
        this.maxVelocity = maxVelocity;
    }


    /**
     * Gets the checkVelocity value for this UserSpecParms.
     * 
     * @return checkVelocity   * If true, the velocity check is performed
     *                                 during IP authentication.
     */
    public Boolean getCheckVelocity() {
        return checkVelocity;
    }


    /**
     * Sets the checkVelocity value for this UserSpecParms.
     * 
     * @param checkVelocity   * If true, the velocity check is performed
     *                                 during IP authentication.
     */
    public void setCheckVelocity(Boolean checkVelocity) {
        this.checkVelocity = checkVelocity;
    }


    /**
     * Gets the countryBlacklist value for this UserSpecParms.
     * 
     * @return countryBlacklist   * The country blacklist is a list of country
     *                                 codes. Valid country codes can be
     * obtained
     *                                 from the country information returned
     * by the
     *                                 countryList operation.
     *                                 <p>
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     */
    public String[] getCountryBlacklist() {
        return countryBlacklist;
    }


    /**
     * Sets the countryBlacklist value for this UserSpecParms.
     * 
     * @param countryBlacklist   * The country blacklist is a list of country
     *                                 codes. Valid country codes can be
     * obtained
     *                                 from the country information returned
     * by the
     *                                 countryList operation.
     *                                 <p>
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     */
    public void setCountryBlacklist(String[] countryBlacklist) {
        this.countryBlacklist = countryBlacklist;
    }


    /**
     * Gets the addCountryBlacklist value for this UserSpecParms.
     * 
     * @return addCountryBlacklist   * The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the countries
     *                                 in the countryBlacklist attribute
     * will be added
     *                                 to the current value.  This attribute
     * will be
     *                                 ignored if the countryBlacklist attribute
     * is
     *                                 not set.
     */
    public Boolean getAddCountryBlacklist() {
        return addCountryBlacklist;
    }


    /**
     * Sets the addCountryBlacklist value for this UserSpecParms.
     * 
     * @param addCountryBlacklist   * The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the countries
     *                                 in the countryBlacklist attribute
     * will be added
     *                                 to the current value.  This attribute
     * will be
     *                                 ignored if the countryBlacklist attribute
     * is
     *                                 not set.
     */
    public void setAddCountryBlacklist(Boolean addCountryBlacklist) {
        this.addCountryBlacklist = addCountryBlacklist;
    }


    /**
     * Gets the removeCountryBlacklist value for this UserSpecParms.
     * 
     * @return removeCountryBlacklist   * The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set, the countries
     * in the countryBlacklist attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the countryBlacklist
     * is not set.
     *                                 or the addCountryBlacklist attribute
     * is set.
     */
    public Boolean getRemoveCountryBlacklist() {
        return removeCountryBlacklist;
    }


    /**
     * Sets the removeCountryBlacklist value for this UserSpecParms.
     * 
     * @param removeCountryBlacklist   * The country blacklist is a list of country
     *                                 codes.  Users authenticating from
     * these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     *                                 <p>
     *                                 If this attribute is set, the countries
     * in the countryBlacklist attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the countryBlacklist
     * is not set.
     *                                 or the addCountryBlacklist attribute
     * is set.
     */
    public void setRemoveCountryBlacklist(Boolean removeCountryBlacklist) {
        this.removeCountryBlacklist = removeCountryBlacklist;
    }


    /**
     * Gets the expectedLocations value for this UserSpecParms.
     * 
     * @return expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     */
    public ExpectedLocation[] getExpectedLocations() {
        return expectedLocations;
    }


    /**
     * Sets the expectedLocations value for this UserSpecParms.
     * 
     * @param expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     */
    public void setExpectedLocations(ExpectedLocation[] expectedLocations) {
        this.expectedLocations = expectedLocations;
    }


    /**
     * Gets the addExpectedLocations value for this UserSpecParms.
     * 
     * @return addExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set.
     */
    public Boolean getAddExpectedLocations() {
        return addExpectedLocations;
    }


    /**
     * Sets the addExpectedLocations value for this UserSpecParms.
     * 
     * @param addExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set to true,
     * the locations
     *                                 in the expectedLocations attribute
     * will be
     *                                 added to the current value.  This
     * attribute
     *                                 will be ignored if the expectedLocation
     * attribute is not set.
     */
    public void setAddExpectedLocations(Boolean addExpectedLocations) {
        this.addExpectedLocations = addExpectedLocations;
    }


    /**
     * Gets the removeExpectedLocations value for this UserSpecParms.
     * 
     * @return removeExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set.  or the addExpectedLocations
     * attribute is set.
     */
    public Boolean getRemoveExpectedLocations() {
        return removeExpectedLocations;
    }


    /**
     * Sets the removeExpectedLocations value for this UserSpecParms.
     * 
     * @param removeExpectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     *                                 <p>
     *                                 If this attribute is set, the locations
     * in the expectedLocations attribute will be
     *                                 removed from the current value.  This
     * attribute
     *                                 is ignored if the expectedLocations
     * attribute
     *                                 is not set.  or the addExpectedLocations
     * attribute is set.
     */
    public void setRemoveExpectedLocations(Boolean removeExpectedLocations) {
        this.removeExpectedLocations = removeExpectedLocations;
    }


    /**
     * Gets the maxUserExpectedLocationsSize value for this UserSpecParms.
     * 
     * @return maxUserExpectedLocationsSize   * If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list.
     */
    public Integer getMaxUserExpectedLocationsSize() {
        return maxUserExpectedLocationsSize;
    }


    /**
     * Sets the maxUserExpectedLocationsSize value for this UserSpecParms.
     * 
     * @param maxUserExpectedLocationsSize   * If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list.
     */
    public void setMaxUserExpectedLocationsSize(Integer maxUserExpectedLocationsSize) {
        this.maxUserExpectedLocationsSize = maxUserExpectedLocationsSize;
    }


    /**
     * Gets the normalRejectAdd value for this UserSpecParms.
     * 
     * @return normalRejectAdd   * Determines whether the values in the
     *                                 normalReject parameter are added to
     * the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored.
     */
    public Boolean getNormalRejectAdd() {
        return normalRejectAdd;
    }


    /**
     * Sets the normalRejectAdd value for this UserSpecParms.
     * 
     * @param normalRejectAdd   * Determines whether the values in the
     *                                 normalReject parameter are added to
     * the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored.
     */
    public void setNormalRejectAdd(Boolean normalRejectAdd) {
        this.normalRejectAdd = normalRejectAdd;
    }


    /**
     * Gets the normalRejectRemove value for this UserSpecParms.
     * 
     * @return normalRejectRemove   * Determines whether the values in the
     *                                 normalReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored.
     */
    public Boolean getNormalRejectRemove() {
        return normalRejectRemove;
    }


    /**
     * Sets the normalRejectRemove value for this UserSpecParms.
     * 
     * @param normalRejectRemove   * Determines whether the values in the
     *                                 normalReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If normalReject is not specified,
     *                                 this value is ignored.
     */
    public void setNormalRejectRemove(Boolean normalRejectRemove) {
        this.normalRejectRemove = normalRejectRemove;
    }


    /**
     * Gets the normalReject value for this UserSpecParms.
     * 
     * @return normalReject   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected.
     *                                 If normalRejectAdd is specified as
     * true,
     *                                 these values are added to the existing
     * values.  Otherwise, if normalRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public RBAExpressionList getNormalReject() {
        return normalReject;
    }


    /**
     * Sets the normalReject value for this UserSpecParms.
     * 
     * @param normalReject   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected.
     *                                 If normalRejectAdd is specified as
     * true,
     *                                 these values are added to the existing
     * values.  Otherwise, if normalRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public void setNormalReject(RBAExpressionList normalReject) {
        this.normalReject = normalReject;
    }


    /**
     * Gets the normalAuthenticatedAdd value for this UserSpecParms.
     * 
     * @return normalAuthenticatedAdd   * Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * added to the
     *                                 existing values or replace the existing
     * values.  If normalAuthenticated is not
     *                                 specified, this value is ignored.
     */
    public Boolean getNormalAuthenticatedAdd() {
        return normalAuthenticatedAdd;
    }


    /**
     * Sets the normalAuthenticatedAdd value for this UserSpecParms.
     * 
     * @param normalAuthenticatedAdd   * Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * added to the
     *                                 existing values or replace the existing
     * values.  If normalAuthenticated is not
     *                                 specified, this value is ignored.
     */
    public void setNormalAuthenticatedAdd(Boolean normalAuthenticatedAdd) {
        this.normalAuthenticatedAdd = normalAuthenticatedAdd;
    }


    /**
     * Gets the normalAuthenticatedRemove value for this UserSpecParms.
     * 
     * @return normalAuthenticatedRemove   * Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * removed from
     *                                 the existing values or replace the
     * existing
     *                                 values.  If normalAuthenticated is
     * not
     *                                 specified, this value is ignored.
     */
    public Boolean getNormalAuthenticatedRemove() {
        return normalAuthenticatedRemove;
    }


    /**
     * Sets the normalAuthenticatedRemove value for this UserSpecParms.
     * 
     * @param normalAuthenticatedRemove   * Determines whether the values in the
     *                                 normalAuthenticated parameter are
     * removed from
     *                                 the existing values or replace the
     * existing
     *                                 values.  If normalAuthenticated is
     * not
     *                                 specified, this value is ignored.
     */
    public void setNormalAuthenticatedRemove(Boolean normalAuthenticatedRemove) {
        this.normalAuthenticatedRemove = normalAuthenticatedRemove;
    }


    /**
     * Gets the normalAuthenticated value for this UserSpecParms.
     * 
     * @return normalAuthenticated   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated.
     *                                 If normalAuthenticatedAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if
     *                                 normalAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public RBAExpressionList getNormalAuthenticated() {
        return normalAuthenticated;
    }


    /**
     * Sets the normalAuthenticated value for this UserSpecParms.
     * 
     * @param normalAuthenticated   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated.
     *                                 If normalAuthenticatedAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if
     *                                 normalAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public void setNormalAuthenticated(RBAExpressionList normalAuthenticated) {
        this.normalAuthenticated = normalAuthenticated;
    }


    /**
     * Gets the enhancedRejectAdd value for this UserSpecParms.
     * 
     * @return enhancedRejectAdd   * Determines whether the values in the
     *                                 enhancedReject parameter are added
     * to the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored.
     */
    public Boolean getEnhancedRejectAdd() {
        return enhancedRejectAdd;
    }


    /**
     * Sets the enhancedRejectAdd value for this UserSpecParms.
     * 
     * @param enhancedRejectAdd   * Determines whether the values in the
     *                                 enhancedReject parameter are added
     * to the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored.
     */
    public void setEnhancedRejectAdd(Boolean enhancedRejectAdd) {
        this.enhancedRejectAdd = enhancedRejectAdd;
    }


    /**
     * Gets the enhancedRejectRemove value for this UserSpecParms.
     * 
     * @return enhancedRejectRemove   * Determines whether the values in the
     *                                 enhancedReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored.
     */
    public Boolean getEnhancedRejectRemove() {
        return enhancedRejectRemove;
    }


    /**
     * Sets the enhancedRejectRemove value for this UserSpecParms.
     * 
     * @param enhancedRejectRemove   * Determines whether the values in the
     *                                 enhancedReject parameter are removed
     * from the
     *                                 existing values or replace the existing
     * values.  If enhancedReject is not specified,
     *                                 this value is ignored.
     */
    public void setEnhancedRejectRemove(Boolean enhancedRejectRemove) {
        this.enhancedRejectRemove = enhancedRejectRemove;
    }


    /**
     * Gets the enhancedReject value for this UserSpecParms.
     * 
     * @return enhancedReject   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected.
     *                                 If enhancedRejectAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if enhancedRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public RBAExpressionList getEnhancedReject() {
        return enhancedReject;
    }


    /**
     * Sets the enhancedReject value for this UserSpecParms.
     * 
     * @param enhancedReject   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected.
     *                                 If enhancedRejectAdd is specified
     * as true,
     *                                 these values are added to the existing
     * values.  Otherwise, if enhancedRejectRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public void setEnhancedReject(RBAExpressionList enhancedReject) {
        this.enhancedReject = enhancedReject;
    }


    /**
     * Gets the enhancedAuthenticatedAdd value for this UserSpecParms.
     * 
     * @return enhancedAuthenticatedAdd   * Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * added to
     *                                 the existing values or replace the
     * existing
     *                                 values.  If enhancedAuthenticated
     * is not
     *                                 specified, this value is ignored.
     */
    public Boolean getEnhancedAuthenticatedAdd() {
        return enhancedAuthenticatedAdd;
    }


    /**
     * Sets the enhancedAuthenticatedAdd value for this UserSpecParms.
     * 
     * @param enhancedAuthenticatedAdd   * Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * added to
     *                                 the existing values or replace the
     * existing
     *                                 values.  If enhancedAuthenticated
     * is not
     *                                 specified, this value is ignored.
     */
    public void setEnhancedAuthenticatedAdd(Boolean enhancedAuthenticatedAdd) {
        this.enhancedAuthenticatedAdd = enhancedAuthenticatedAdd;
    }


    /**
     * Gets the enhancedAuthenticatedRemove value for this UserSpecParms.
     * 
     * @return enhancedAuthenticatedRemove   * Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * removed
     *                                 from the existing values or replace
     * the
     *                                 existing values.  If enhancedAuthenticated
     * is
     *                                 not specified, this value is ignored.
     */
    public Boolean getEnhancedAuthenticatedRemove() {
        return enhancedAuthenticatedRemove;
    }


    /**
     * Sets the enhancedAuthenticatedRemove value for this UserSpecParms.
     * 
     * @param enhancedAuthenticatedRemove   * Determines whether the values in the
     *                                 enhancedAuthenticated parameter are
     * removed
     *                                 from the existing values or replace
     * the
     *                                 existing values.  If enhancedAuthenticated
     * is
     *                                 not specified, this value is ignored.
     */
    public void setEnhancedAuthenticatedRemove(Boolean enhancedAuthenticatedRemove) {
        this.enhancedAuthenticatedRemove = enhancedAuthenticatedRemove;
    }


    /**
     * Gets the enhancedAuthenticated value for this UserSpecParms.
     * 
     * @return enhancedAuthenticated   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated.
     * If enhancedAuthenticatedAdd is specified as
     *                                 true, these values are added to the
     * existing
     *                                 values.  Otherwise, if
     *                                 enhancedAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public RBAExpressionList getEnhancedAuthenticated() {
        return enhancedAuthenticated;
    }


    /**
     * Sets the enhancedAuthenticated value for this UserSpecParms.
     * 
     * @param enhancedAuthenticated   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated.
     * If enhancedAuthenticatedAdd is specified as
     *                                 true, these values are added to the
     * existing
     *                                 values.  Otherwise, if
     *                                 enhancedAuthenticatedRemove
     *                                 is specified as true, these values
     * are removed
     *                                 from the existing values.  Otherwise,
     * these
     *                                 values replace the existing values.
     */
    public void setEnhancedAuthenticated(RBAExpressionList enhancedAuthenticated) {
        this.enhancedAuthenticated = enhancedAuthenticated;
    }


    /**
     * Gets the externalRiskScoreNormalPass value for this UserSpecParms.
     * 
     * @return externalRiskScoreNormalPass   * A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public Integer getExternalRiskScoreNormalPass() {
        return externalRiskScoreNormalPass;
    }


    /**
     * Sets the externalRiskScoreNormalPass value for this UserSpecParms.
     * 
     * @param externalRiskScoreNormalPass   * A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public void setExternalRiskScoreNormalPass(Integer externalRiskScoreNormalPass) {
        this.externalRiskScoreNormalPass = externalRiskScoreNormalPass;
    }


    /**
     * Gets the externalRiskScoreNormalFail value for this UserSpecParms.
     * 
     * @return externalRiskScoreNormalFail   * A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public Integer getExternalRiskScoreNormalFail() {
        return externalRiskScoreNormalFail;
    }


    /**
     * Sets the externalRiskScoreNormalFail value for this UserSpecParms.
     * 
     * @param externalRiskScoreNormalFail   * A risk score threshold used for normal
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public void setExternalRiskScoreNormalFail(Integer externalRiskScoreNormalFail) {
        this.externalRiskScoreNormalFail = externalRiskScoreNormalFail;
    }


    /**
     * Gets the externalRiskScoreEnhancedPass value for this UserSpecParms.
     * 
     * @return externalRiskScoreEnhancedPass   * A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public Integer getExternalRiskScoreEnhancedPass() {
        return externalRiskScoreEnhancedPass;
    }


    /**
     * Sets the externalRiskScoreEnhancedPass value for this UserSpecParms.
     * 
     * @param externalRiskScoreEnhancedPass   * A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public void setExternalRiskScoreEnhancedPass(Integer externalRiskScoreEnhancedPass) {
        this.externalRiskScoreEnhancedPass = externalRiskScoreEnhancedPass;
    }


    /**
     * Gets the externalRiskScoreEnhancedFail value for this UserSpecParms.
     * 
     * @return externalRiskScoreEnhancedFail   * A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public Integer getExternalRiskScoreEnhancedFail() {
        return externalRiskScoreEnhancedFail;
    }


    /**
     * Sets the externalRiskScoreEnhancedFail value for this UserSpecParms.
     * 
     * @param externalRiskScoreEnhancedFail   * A risk score threshold used for enhanced
     *                                 transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public void setExternalRiskScoreEnhancedFail(Integer externalRiskScoreEnhancedFail) {
        this.externalRiskScoreEnhancedFail = externalRiskScoreEnhancedFail;
    }


    /**
     * Gets the externalRiskEngine value for this UserSpecParms.
     * 
     * @return externalRiskEngine   * The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  Specify an empty
     * string value to unset the risk engine policy.
     *                                 If this value is not set, external
     * risk scoring
     *                                 is not available.
     */
    public String getExternalRiskEngine() {
        return externalRiskEngine;
    }


    /**
     * Sets the externalRiskEngine value for this UserSpecParms.
     * 
     * @param externalRiskEngine   * The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  Specify an empty
     * string value to unset the risk engine policy.
     *                                 If this value is not set, external
     * risk scoring
     *                                 is not available.
     */
    public void setExternalRiskEngine(String externalRiskEngine) {
        this.externalRiskEngine = externalRiskEngine;
    }


    /**
     * Gets the performTransactionDelivery value for this UserSpecParms.
     * 
     * @return performTransactionDelivery   * A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery.
     */
    public Boolean getPerformTransactionDelivery() {
        return performTransactionDelivery;
    }


    /**
     * Sets the performTransactionDelivery value for this UserSpecParms.
     * 
     * @param performTransactionDelivery   * A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery.
     */
    public void setPerformTransactionDelivery(Boolean performTransactionDelivery) {
        this.performTransactionDelivery = performTransactionDelivery;
    }


    /**
     * Gets the softTokenPINRequired value for this UserSpecParms.
     * 
     * @return softTokenPINRequired   * A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP.
     */
    public Boolean getSoftTokenPINRequired() {
        return softTokenPINRequired;
    }


    /**
     * Sets the softTokenPINRequired value for this UserSpecParms.
     * 
     * @param softTokenPINRequired   * A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP.
     */
    public void setSoftTokenPINRequired(Boolean softTokenPINRequired) {
        this.softTokenPINRequired = softTokenPINRequired;
    }


    /**
     * Gets the softTokenOTPLength value for this UserSpecParms.
     * 
     * @return softTokenOTPLength   * The number of digits in an OTP response from a
     *                                 soft token. Allowed values are 4,
     * 6, and 8.
     */
    public Integer getSoftTokenOTPLength() {
        return softTokenOTPLength;
    }


    /**
     * Sets the softTokenOTPLength value for this UserSpecParms.
     * 
     * @param softTokenOTPLength   * The number of digits in an OTP response from a
     *                                 soft token. Allowed values are 4,
     * 6, and 8.
     */
    public void setSoftTokenOTPLength(Integer softTokenOTPLength) {
        this.softTokenOTPLength = softTokenOTPLength;
    }


    /**
     * Gets the comment value for this UserSpecParms.
     * 
     * @return comment   * Descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserSpecParms.
     * 
     * @param comment   * Descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserSpecParms)) return false;
        UserSpecParms other = (UserSpecParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.maxAliases==null && other.getMaxAliases()==null) || 
             (this.maxAliases!=null &&
              this.maxAliases.equals(other.getMaxAliases()))) &&
            ((this.maxContactInfoNumber==null && other.getMaxContactInfoNumber()==null) || 
             (this.maxContactInfoNumber!=null &&
              this.maxContactInfoNumber.equals(other.getMaxContactInfoNumber()))) &&
            ((this.lockoutMode==null && other.getLockoutMode()==null) || 
             (this.lockoutMode!=null &&
              this.lockoutMode.equals(other.getLockoutMode()))) &&
            ((this.maxFailures==null && other.getMaxFailures()==null) || 
             (this.maxFailures!=null &&
              this.maxFailures.equals(other.getMaxFailures()))) &&
            ((this.maxGlobalFailures==null && other.getMaxGlobalFailures()==null) || 
             (this.maxGlobalFailures!=null &&
              this.maxGlobalFailures.equals(other.getMaxGlobalFailures()))) &&
            ((this.maxCertificateFailures==null && other.getMaxCertificateFailures()==null) || 
             (this.maxCertificateFailures!=null &&
              this.maxCertificateFailures.equals(other.getMaxCertificateFailures()))) &&
            ((this.maxExternalFailures==null && other.getMaxExternalFailures()==null) || 
             (this.maxExternalFailures!=null &&
              this.maxExternalFailures.equals(other.getMaxExternalFailures()))) &&
            ((this.maxGridFailures==null && other.getMaxGridFailures()==null) || 
             (this.maxGridFailures!=null &&
              this.maxGridFailures.equals(other.getMaxGridFailures()))) &&
            ((this.maxTokenCRFailures==null && other.getMaxTokenCRFailures()==null) || 
             (this.maxTokenCRFailures!=null &&
              this.maxTokenCRFailures.equals(other.getMaxTokenCRFailures()))) &&
            ((this.maxTokenROFailures==null && other.getMaxTokenROFailures()==null) || 
             (this.maxTokenROFailures!=null &&
              this.maxTokenROFailures.equals(other.getMaxTokenROFailures()))) &&
            ((this.maxOTPFailures==null && other.getMaxOTPFailures()==null) || 
             (this.maxOTPFailures!=null &&
              this.maxOTPFailures.equals(other.getMaxOTPFailures()))) &&
            ((this.maxQAFailures==null && other.getMaxQAFailures()==null) || 
             (this.maxQAFailures!=null &&
              this.maxQAFailures.equals(other.getMaxQAFailures()))) &&
            ((this.maxRBAIPAuthFailures==null && other.getMaxRBAIPAuthFailures()==null) || 
             (this.maxRBAIPAuthFailures!=null &&
              this.maxRBAIPAuthFailures.equals(other.getMaxRBAIPAuthFailures()))) &&
            ((this.maxRBAMachineAuthFailures==null && other.getMaxRBAMachineAuthFailures()==null) || 
             (this.maxRBAMachineAuthFailures!=null &&
              this.maxRBAMachineAuthFailures.equals(other.getMaxRBAMachineAuthFailures()))) &&
            ((this.maxRBACertificateAuthFailures==null && other.getMaxRBACertificateAuthFailures()==null) || 
             (this.maxRBACertificateAuthFailures!=null &&
              this.maxRBACertificateAuthFailures.equals(other.getMaxRBACertificateAuthFailures()))) &&
            ((this.maxRBAExternalRiskAuthFailures==null && other.getMaxRBAExternalRiskAuthFailures()==null) || 
             (this.maxRBAExternalRiskAuthFailures!=null &&
              this.maxRBAExternalRiskAuthFailures.equals(other.getMaxRBAExternalRiskAuthFailures()))) &&
            ((this.lockoutTime==null && other.getLockoutTime()==null) || 
             (this.lockoutTime!=null &&
              this.lockoutTime.equals(other.getLockoutTime()))) &&
            ((this.maxSecretSize==null && other.getMaxSecretSize()==null) || 
             (this.maxSecretSize!=null &&
              this.maxSecretSize.equals(other.getMaxSecretSize()))) &&
            ((this.maxSecretNumber==null && other.getMaxSecretNumber()==null) || 
             (this.maxSecretNumber!=null &&
              this.maxSecretNumber.equals(other.getMaxSecretNumber()))) &&
            ((this.genericAuthType==null && other.getGenericAuthType()==null) || 
             (this.genericAuthType!=null &&
              java.util.Arrays.equals(this.genericAuthType, other.getGenericAuthType()))) &&
            ((this.enhancedGenericAuthType==null && other.getEnhancedGenericAuthType()==null) || 
             (this.enhancedGenericAuthType!=null &&
              java.util.Arrays.equals(this.enhancedGenericAuthType, other.getEnhancedGenericAuthType()))) &&
            ((this.machineAuthType==null && other.getMachineAuthType()==null) || 
             (this.machineAuthType!=null &&
              java.util.Arrays.equals(this.machineAuthType, other.getMachineAuthType()))) &&
            ((this.authTypeCanViewSecrets==null && other.getAuthTypeCanViewSecrets()==null) || 
             (this.authTypeCanViewSecrets!=null &&
              java.util.Arrays.equals(this.authTypeCanViewSecrets, other.getAuthTypeCanViewSecrets()))) &&
            ((this.authTypeCanModifySecrets==null && other.getAuthTypeCanModifySecrets()==null) || 
             (this.authTypeCanModifySecrets!=null &&
              java.util.Arrays.equals(this.authTypeCanModifySecrets, other.getAuthTypeCanModifySecrets()))) &&
            ((this.maxMachineSecrets==null && other.getMaxMachineSecrets()==null) || 
             (this.maxMachineSecrets!=null &&
              this.maxMachineSecrets.equals(other.getMaxMachineSecrets()))) &&
            ((this.maxMachineSecretsSize==null && other.getMaxMachineSecretsSize()==null) || 
             (this.maxMachineSecretsSize!=null &&
              this.maxMachineSecretsSize.equals(other.getMaxMachineSecretsSize()))) &&
            ((this.machineSecretRequiresMachineNonce==null && other.getMachineSecretRequiresMachineNonce()==null) || 
             (this.machineSecretRequiresMachineNonce!=null &&
              this.machineSecretRequiresMachineNonce.equals(other.getMachineSecretRequiresMachineNonce()))) &&
            ((this.machineSecretRequiresSequenceNonce==null && other.getMachineSecretRequiresSequenceNonce()==null) || 
             (this.machineSecretRequiresSequenceNonce!=null &&
              this.machineSecretRequiresSequenceNonce.equals(other.getMachineSecretRequiresSequenceNonce()))) &&
            ((this.machineSecretRequiresAppData==null && other.getMachineSecretRequiresAppData()==null) || 
             (this.machineSecretRequiresAppData!=null &&
              this.machineSecretRequiresAppData.equals(other.getMachineSecretRequiresAppData()))) &&
            ((this.machineSecretAllowsBadAppData==null && other.getMachineSecretAllowsBadAppData()==null) || 
             (this.machineSecretAllowsBadAppData!=null &&
              this.machineSecretAllowsBadAppData.equals(other.getMachineSecretAllowsBadAppData()))) &&
            ((this.machineSecretLifetime==null && other.getMachineSecretLifetime()==null) || 
             (this.machineSecretLifetime!=null &&
              this.machineSecretLifetime.equals(other.getMachineSecretLifetime()))) &&
            ((this.failedMachineAuthIncrementsLockout==null && other.getFailedMachineAuthIncrementsLockout()==null) || 
             (this.failedMachineAuthIncrementsLockout!=null &&
              this.failedMachineAuthIncrementsLockout.equals(other.getFailedMachineAuthIncrementsLockout()))) &&
            ((this.maxAuthSecrets==null && other.getMaxAuthSecrets()==null) || 
             (this.maxAuthSecrets!=null &&
              this.maxAuthSecrets.equals(other.getMaxAuthSecrets()))) &&
            ((this.maxAuthSecretsSize==null && other.getMaxAuthSecretsSize()==null) || 
             (this.maxAuthSecretsSize!=null &&
              this.maxAuthSecretsSize.equals(other.getMaxAuthSecretsSize()))) &&
            ((this.maxQuestions==null && other.getMaxQuestions()==null) || 
             (this.maxQuestions!=null &&
              this.maxQuestions.equals(other.getMaxQuestions()))) &&
            ((this.maxQASize==null && other.getMaxQASize()==null) || 
             (this.maxQASize!=null &&
              this.maxQASize.equals(other.getMaxQASize()))) &&
            ((this.QAChallengeSize==null && other.getQAChallengeSize()==null) || 
             (this.QAChallengeSize!=null &&
              this.QAChallengeSize.equals(other.getQAChallengeSize()))) &&
            ((this.minQAChallengeSize==null && other.getMinQAChallengeSize()==null) || 
             (this.minQAChallengeSize!=null &&
              this.minQAChallengeSize.equals(other.getMinQAChallengeSize()))) &&
            ((this.maxQAChallengeSize==null && other.getMaxQAChallengeSize()==null) || 
             (this.maxQAChallengeSize!=null &&
              this.maxQAChallengeSize.equals(other.getMaxQAChallengeSize()))) &&
            ((this.disableQAChallengeRetention==null && other.getDisableQAChallengeRetention()==null) || 
             (this.disableQAChallengeRetention!=null &&
              this.disableQAChallengeRetention.equals(other.getDisableQAChallengeRetention()))) &&
            ((this.QAChallengeLifetime==null && other.getQAChallengeLifetime()==null) || 
             (this.QAChallengeLifetime!=null &&
              this.QAChallengeLifetime.equals(other.getQAChallengeLifetime()))) &&
            ((this.updateLockoutForReplacedQAChallenge==null && other.getUpdateLockoutForReplacedQAChallenge()==null) || 
             (this.updateLockoutForReplacedQAChallenge!=null &&
              this.updateLockoutForReplacedQAChallenge.equals(other.getUpdateLockoutForReplacedQAChallenge()))) &&
            ((this.qaDefaultWrongAnswersAllowed==null && other.getQaDefaultWrongAnswersAllowed()==null) || 
             (this.qaDefaultWrongAnswersAllowed!=null &&
              this.qaDefaultWrongAnswersAllowed.equals(other.getQaDefaultWrongAnswersAllowed()))) &&
            ((this.qaMaximumWrongAnswersAllowed==null && other.getQaMaximumWrongAnswersAllowed()==null) || 
             (this.qaMaximumWrongAnswersAllowed!=null &&
              this.qaMaximumWrongAnswersAllowed.equals(other.getQaMaximumWrongAnswersAllowed()))) &&
            ((this.qaInexactMatchAllowed==null && other.getQaInexactMatchAllowed()==null) || 
             (this.qaInexactMatchAllowed!=null &&
              this.qaInexactMatchAllowed.equals(other.getQaInexactMatchAllowed()))) &&
            ((this.OTPCellAlphabet==null && other.getOTPCellAlphabet()==null) || 
             (this.OTPCellAlphabet!=null &&
              java.util.Arrays.equals(this.OTPCellAlphabet, other.getOTPCellAlphabet()))) &&
            ((this.OTPCellReplacements==null && other.getOTPCellReplacements()==null) || 
             (this.OTPCellReplacements!=null &&
              java.util.Arrays.equals(this.OTPCellReplacements, other.getOTPCellReplacements()))) &&
            ((this.OTPLifetime==null && other.getOTPLifetime()==null) || 
             (this.OTPLifetime!=null &&
              this.OTPLifetime.equals(other.getOTPLifetime()))) &&
            ((this.OTPLength==null && other.getOTPLength()==null) || 
             (this.OTPLength!=null &&
              this.OTPLength.equals(other.getOTPLength()))) &&
            ((this.OTPDeliveryEnabled==null && other.getOTPDeliveryEnabled()==null) || 
             (this.OTPDeliveryEnabled!=null &&
              this.OTPDeliveryEnabled.equals(other.getOTPDeliveryEnabled()))) &&
            ((this.OTPAlwaysGenerate==null && other.getOTPAlwaysGenerate()==null) || 
             (this.OTPAlwaysGenerate!=null &&
              this.OTPAlwaysGenerate.equals(other.getOTPAlwaysGenerate()))) &&
            ((this.OTPDynamicRefresh==null && other.getOTPDynamicRefresh()==null) || 
             (this.OTPDynamicRefresh!=null &&
              this.OTPDynamicRefresh.equals(other.getOTPDynamicRefresh()))) &&
            ((this.OTPNumberOutstanding==null && other.getOTPNumberOutstanding()==null) || 
             (this.OTPNumberOutstanding!=null &&
              this.OTPNumberOutstanding.equals(other.getOTPNumberOutstanding()))) &&
            ((this.OTPRefreshThreshold==null && other.getOTPRefreshThreshold()==null) || 
             (this.OTPRefreshThreshold!=null &&
              this.OTPRefreshThreshold.equals(other.getOTPRefreshThreshold()))) &&
            ((this.returnAuthSecretWithChall==null && other.getReturnAuthSecretWithChall()==null) || 
             (this.returnAuthSecretWithChall!=null &&
              this.returnAuthSecretWithChall.equals(other.getReturnAuthSecretWithChall()))) &&
            ((this.autoUnassignTokens==null && other.getAutoUnassignTokens()==null) || 
             (this.autoUnassignTokens!=null &&
              this.autoUnassignTokens.equals(other.getAutoUnassignTokens()))) &&
            ((this.autoMoveTokens==null && other.getAutoMoveTokens()==null) || 
             (this.autoMoveTokens!=null &&
              this.autoMoveTokens.equals(other.getAutoMoveTokens()))) &&
            ((this.disableTokenChallengeRetention==null && other.getDisableTokenChallengeRetention()==null) || 
             (this.disableTokenChallengeRetention!=null &&
              this.disableTokenChallengeRetention.equals(other.getDisableTokenChallengeRetention()))) &&
            ((this.tokenChallengeLifetime==null && other.getTokenChallengeLifetime()==null) || 
             (this.tokenChallengeLifetime!=null &&
              this.tokenChallengeLifetime.equals(other.getTokenChallengeLifetime()))) &&
            ((this.updateLockoutForReplacedTokenChallenge==null && other.getUpdateLockoutForReplacedTokenChallenge()==null) || 
             (this.updateLockoutForReplacedTokenChallenge!=null &&
              this.updateLockoutForReplacedTokenChallenge.equals(other.getUpdateLockoutForReplacedTokenChallenge()))) &&
            ((this.maxAllowedTokenSets==null && other.getMaxAllowedTokenSets()==null) || 
             (this.maxAllowedTokenSets!=null &&
              this.maxAllowedTokenSets.equals(other.getMaxAllowedTokenSets()))) &&
            ((this.allowNONEAuthentication==null && other.getAllowNONEAuthentication()==null) || 
             (this.allowNONEAuthentication!=null &&
              this.allowNONEAuthentication.equals(other.getAllowNONEAuthentication()))) &&
            ((this.considerTempPINLast==null && other.getConsiderTempPINLast()==null) || 
             (this.considerTempPINLast!=null &&
              this.considerTempPINLast.equals(other.getConsiderTempPINLast()))) &&
            ((this.storeLastAuthInfo==null && other.getStoreLastAuthInfo()==null) || 
             (this.storeLastAuthInfo!=null &&
              this.storeLastAuthInfo.equals(other.getStoreLastAuthInfo()))) &&
            ((this.allowCreateIfDisabledInRepository==null && other.getAllowCreateIfDisabledInRepository()==null) || 
             (this.allowCreateIfDisabledInRepository!=null &&
              this.allowCreateIfDisabledInRepository.equals(other.getAllowCreateIfDisabledInRepository()))) &&
            ((this.allowCreateIfExpiredInRepository==null && other.getAllowCreateIfExpiredInRepository()==null) || 
             (this.allowCreateIfExpiredInRepository!=null &&
              this.allowCreateIfExpiredInRepository.equals(other.getAllowCreateIfExpiredInRepository()))) &&
            ((this.allowAuthIfDisabledInRepository==null && other.getAllowAuthIfDisabledInRepository()==null) || 
             (this.allowAuthIfDisabledInRepository!=null &&
              this.allowAuthIfDisabledInRepository.equals(other.getAllowAuthIfDisabledInRepository()))) &&
            ((this.allowAuthIfExpiredInRepository==null && other.getAllowAuthIfExpiredInRepository()==null) || 
             (this.allowAuthIfExpiredInRepository!=null &&
              this.allowAuthIfExpiredInRepository.equals(other.getAllowAuthIfExpiredInRepository()))) &&
            ((this.transactionSignatureType==null && other.getTransactionSignatureType()==null) || 
             (this.transactionSignatureType!=null &&
              this.transactionSignatureType.equals(other.getTransactionSignatureType()))) &&
            ((this.transactionLifetime==null && other.getTransactionLifetime()==null) || 
             (this.transactionLifetime!=null &&
              this.transactionLifetime.equals(other.getTransactionLifetime()))) &&
            ((this.maxNumTransactionDetails==null && other.getMaxNumTransactionDetails()==null) || 
             (this.maxNumTransactionDetails!=null &&
              this.maxNumTransactionDetails.equals(other.getMaxNumTransactionDetails()))) &&
            ((this.allowSelfSignedUserCert==null && other.getAllowSelfSignedUserCert()==null) || 
             (this.allowSelfSignedUserCert!=null &&
              this.allowSelfSignedUserCert.equals(other.getAllowSelfSignedUserCert()))) &&
            ((this.allowCertNotIssuedByRegisteredCA==null && other.getAllowCertNotIssuedByRegisteredCA()==null) || 
             (this.allowCertNotIssuedByRegisteredCA!=null &&
              this.allowCertNotIssuedByRegisteredCA.equals(other.getAllowCertNotIssuedByRegisteredCA()))) &&
            ((this.allowAllRegisteredCAs==null && other.getAllowAllRegisteredCAs()==null) || 
             (this.allowAllRegisteredCAs!=null &&
              this.allowAllRegisteredCAs.equals(other.getAllowAllRegisteredCAs()))) &&
            ((this.addAllowedRegisteredCAs==null && other.getAddAllowedRegisteredCAs()==null) || 
             (this.addAllowedRegisteredCAs!=null &&
              this.addAllowedRegisteredCAs.equals(other.getAddAllowedRegisteredCAs()))) &&
            ((this.removeAllowedRegisteredCAs==null && other.getRemoveAllowedRegisteredCAs()==null) || 
             (this.removeAllowedRegisteredCAs!=null &&
              this.removeAllowedRegisteredCAs.equals(other.getRemoveAllowedRegisteredCAs()))) &&
            ((this.allowedRegisteredCAs==null && other.getAllowedRegisteredCAs()==null) || 
             (this.allowedRegisteredCAs!=null &&
              java.util.Arrays.equals(this.allowedRegisteredCAs, other.getAllowedRegisteredCAs()))) &&
            ((this.allowCertNotIssuedByManagedCA==null && other.getAllowCertNotIssuedByManagedCA()==null) || 
             (this.allowCertNotIssuedByManagedCA!=null &&
              this.allowCertNotIssuedByManagedCA.equals(other.getAllowCertNotIssuedByManagedCA()))) &&
            ((this.allowAllManagedCAs==null && other.getAllowAllManagedCAs()==null) || 
             (this.allowAllManagedCAs!=null &&
              this.allowAllManagedCAs.equals(other.getAllowAllManagedCAs()))) &&
            ((this.addAllowedManagedCAs==null && other.getAddAllowedManagedCAs()==null) || 
             (this.addAllowedManagedCAs!=null &&
              this.addAllowedManagedCAs.equals(other.getAddAllowedManagedCAs()))) &&
            ((this.removeAllowedManagedCAs==null && other.getRemoveAllowedManagedCAs()==null) || 
             (this.removeAllowedManagedCAs!=null &&
              this.removeAllowedManagedCAs.equals(other.getRemoveAllowedManagedCAs()))) &&
            ((this.allowedManagedCAs==null && other.getAllowedManagedCAs()==null) || 
             (this.allowedManagedCAs!=null &&
              java.util.Arrays.equals(this.allowedManagedCAs, other.getAllowedManagedCAs()))) &&
            ((this.certificateAuthenticationHashAlg==null && other.getCertificateAuthenticationHashAlg()==null) || 
             (this.certificateAuthenticationHashAlg!=null &&
              this.certificateAuthenticationHashAlg.equals(other.getCertificateAuthenticationHashAlg()))) &&
            ((this.certificateAuthenticationChallengeSize==null && other.getCertificateAuthenticationChallengeSize()==null) || 
             (this.certificateAuthenticationChallengeSize!=null &&
              this.certificateAuthenticationChallengeSize.equals(other.getCertificateAuthenticationChallengeSize()))) &&
            ((this.maxCertsPerUser==null && other.getMaxCertsPerUser()==null) || 
             (this.maxCertsPerUser!=null &&
              this.maxCertsPerUser.equals(other.getMaxCertsPerUser()))) &&
            ((this.autoDeleteUserCerts==null && other.getAutoDeleteUserCerts()==null) || 
             (this.autoDeleteUserCerts!=null &&
              this.autoDeleteUserCerts.equals(other.getAutoDeleteUserCerts()))) &&
            ((this.disableCertificateChallengeRetention==null && other.getDisableCertificateChallengeRetention()==null) || 
             (this.disableCertificateChallengeRetention!=null &&
              this.disableCertificateChallengeRetention.equals(other.getDisableCertificateChallengeRetention()))) &&
            ((this.allowCertificateChallengeDelivery==null && other.getAllowCertificateChallengeDelivery()==null) || 
             (this.allowCertificateChallengeDelivery!=null &&
              this.allowCertificateChallengeDelivery.equals(other.getAllowCertificateChallengeDelivery()))) &&
            ((this.allowCertificateTransactionDelivery==null && other.getAllowCertificateTransactionDelivery()==null) || 
             (this.allowCertificateTransactionDelivery!=null &&
              this.allowCertificateTransactionDelivery.equals(other.getAllowCertificateTransactionDelivery()))) &&
            ((this.allowCertificateSign==null && other.getAllowCertificateSign()==null) || 
             (this.allowCertificateSign!=null &&
              this.allowCertificateSign.equals(other.getAllowCertificateSign()))) &&
            ((this.certificateChallengeLifetime==null && other.getCertificateChallengeLifetime()==null) || 
             (this.certificateChallengeLifetime!=null &&
              this.certificateChallengeLifetime.equals(other.getCertificateChallengeLifetime()))) &&
            ((this.updateLockoutForReplacedCertificateChallenge==null && other.getUpdateLockoutForReplacedCertificateChallenge()==null) || 
             (this.updateLockoutForReplacedCertificateChallenge!=null &&
              this.updateLockoutForReplacedCertificateChallenge.equals(other.getUpdateLockoutForReplacedCertificateChallenge()))) &&
            ((this.allowAllSmartCredentialDefinitions==null && other.getAllowAllSmartCredentialDefinitions()==null) || 
             (this.allowAllSmartCredentialDefinitions!=null &&
              this.allowAllSmartCredentialDefinitions.equals(other.getAllowAllSmartCredentialDefinitions()))) &&
            ((this.addAllowedSmartCredentialDefinitions==null && other.getAddAllowedSmartCredentialDefinitions()==null) || 
             (this.addAllowedSmartCredentialDefinitions!=null &&
              this.addAllowedSmartCredentialDefinitions.equals(other.getAddAllowedSmartCredentialDefinitions()))) &&
            ((this.removeAllowedSmartCredentialDefinitions==null && other.getRemoveAllowedSmartCredentialDefinitions()==null) || 
             (this.removeAllowedSmartCredentialDefinitions!=null &&
              this.removeAllowedSmartCredentialDefinitions.equals(other.getRemoveAllowedSmartCredentialDefinitions()))) &&
            ((this.allowedSmartCredentialDefinitions==null && other.getAllowedSmartCredentialDefinitions()==null) || 
             (this.allowedSmartCredentialDefinitions!=null &&
              java.util.Arrays.equals(this.allowedSmartCredentialDefinitions, other.getAllowedSmartCredentialDefinitions()))) &&
            ((this.maxSmartCredentialsPerUser==null && other.getMaxSmartCredentialsPerUser()==null) || 
             (this.maxSmartCredentialsPerUser!=null &&
              this.maxSmartCredentialsPerUser.equals(other.getMaxSmartCredentialsPerUser()))) &&
            ((this.smartCredentialIDPrefix==null && other.getSmartCredentialIDPrefix()==null) || 
             (this.smartCredentialIDPrefix!=null &&
              this.smartCredentialIDPrefix.equals(other.getSmartCredentialIDPrefix()))) &&
            ((this.smartCredentialTokenVendor==null && other.getSmartCredentialTokenVendor()==null) || 
             (this.smartCredentialTokenVendor!=null &&
              this.smartCredentialTokenVendor.equals(other.getSmartCredentialTokenVendor()))) &&
            ((this.autoUnassignSmartCredentials==null && other.getAutoUnassignSmartCredentials()==null) || 
             (this.autoUnassignSmartCredentials!=null &&
              this.autoUnassignSmartCredentials.equals(other.getAutoUnassignSmartCredentials()))) &&
            ((this.autoCancelSmartCredentials==null && other.getAutoCancelSmartCredentials()==null) || 
             (this.autoCancelSmartCredentials!=null &&
              this.autoCancelSmartCredentials.equals(other.getAutoCancelSmartCredentials()))) &&
            ((this.autoCancelSmartCredentialsForce==null && other.getAutoCancelSmartCredentialsForce()==null) || 
             (this.autoCancelSmartCredentialsForce!=null &&
              this.autoCancelSmartCredentialsForce.equals(other.getAutoCancelSmartCredentialsForce()))) &&
            ((this.autoMoveSmartCredentials==null && other.getAutoMoveSmartCredentials()==null) || 
             (this.autoMoveSmartCredentials!=null &&
              this.autoMoveSmartCredentials.equals(other.getAutoMoveSmartCredentials()))) &&
            ((this.autoRegisterSmartCredentialsToPACS==null && other.getAutoRegisterSmartCredentialsToPACS()==null) || 
             (this.autoRegisterSmartCredentialsToPACS!=null &&
              this.autoRegisterSmartCredentialsToPACS.equals(other.getAutoRegisterSmartCredentialsToPACS()))) &&
            ((this.autoSuspendSmartCredentialsFromPACS==null && other.getAutoSuspendSmartCredentialsFromPACS()==null) || 
             (this.autoSuspendSmartCredentialsFromPACS!=null &&
              this.autoSuspendSmartCredentialsFromPACS.equals(other.getAutoSuspendSmartCredentialsFromPACS()))) &&
            ((this.allowSoftwareSmartCredentials==null && other.getAllowSoftwareSmartCredentials()==null) || 
             (this.allowSoftwareSmartCredentials!=null &&
              this.allowSoftwareSmartCredentials.equals(other.getAllowSoftwareSmartCredentials()))) &&
            ((this.mobileSmartCredentialPINPrompt==null && other.getMobileSmartCredentialPINPrompt()==null) || 
             (this.mobileSmartCredentialPINPrompt!=null &&
              this.mobileSmartCredentialPINPrompt.equals(other.getMobileSmartCredentialPINPrompt()))) &&
            ((this.mobileSmartCredentialSessionTimeout==null && other.getMobileSmartCredentialSessionTimeout()==null) || 
             (this.mobileSmartCredentialSessionTimeout!=null &&
              this.mobileSmartCredentialSessionTimeout.equals(other.getMobileSmartCredentialSessionTimeout()))) &&
            ((this.allowAllDigitalIdConfigs==null && other.getAllowAllDigitalIdConfigs()==null) || 
             (this.allowAllDigitalIdConfigs!=null &&
              this.allowAllDigitalIdConfigs.equals(other.getAllowAllDigitalIdConfigs()))) &&
            ((this.addAllowedDigitalIdConfigs==null && other.getAddAllowedDigitalIdConfigs()==null) || 
             (this.addAllowedDigitalIdConfigs!=null &&
              this.addAllowedDigitalIdConfigs.equals(other.getAddAllowedDigitalIdConfigs()))) &&
            ((this.removeAllowedDigitalIdConfigs==null && other.getRemoveAllowedDigitalIdConfigs()==null) || 
             (this.removeAllowedDigitalIdConfigs!=null &&
              this.removeAllowedDigitalIdConfigs.equals(other.getRemoveAllowedDigitalIdConfigs()))) &&
            ((this.allowedDigitalIdConfigs==null && other.getAllowedDigitalIdConfigs()==null) || 
             (this.allowedDigitalIdConfigs!=null &&
              java.util.Arrays.equals(this.allowedDigitalIdConfigs, other.getAllowedDigitalIdConfigs()))) &&
            ((this.maxDigitalIdsPerUser==null && other.getMaxDigitalIdsPerUser()==null) || 
             (this.maxDigitalIdsPerUser!=null &&
              this.maxDigitalIdsPerUser.equals(other.getMaxDigitalIdsPerUser()))) &&
            ((this.maxClientTypesPerDigitalId==null && other.getMaxClientTypesPerDigitalId()==null) || 
             (this.maxClientTypesPerDigitalId!=null &&
              this.maxClientTypesPerDigitalId.equals(other.getMaxClientTypesPerDigitalId()))) &&
            ((this.autoCancelDigitalIds==null && other.getAutoCancelDigitalIds()==null) || 
             (this.autoCancelDigitalIds!=null &&
              this.autoCancelDigitalIds.equals(other.getAutoCancelDigitalIds()))) &&
            ((this.userRegistrationPasswordLifetime==null && other.getUserRegistrationPasswordLifetime()==null) || 
             (this.userRegistrationPasswordLifetime!=null &&
              this.userRegistrationPasswordLifetime.equals(other.getUserRegistrationPasswordLifetime()))) &&
            ((this.userRegistrationPasswordLength==null && other.getUserRegistrationPasswordLength()==null) || 
             (this.userRegistrationPasswordLength!=null &&
              this.userRegistrationPasswordLength.equals(other.getUserRegistrationPasswordLength()))) &&
            ((this.maxFederationsPerUser==null && other.getMaxFederationsPerUser()==null) || 
             (this.maxFederationsPerUser!=null &&
              this.maxFederationsPerUser.equals(other.getMaxFederationsPerUser()))) &&
            ((this.maxNumUserPreferences==null && other.getMaxNumUserPreferences()==null) || 
             (this.maxNumUserPreferences!=null &&
              this.maxNumUserPreferences.equals(other.getMaxNumUserPreferences()))) &&
            ((this.maxSizeUserPreference==null && other.getMaxSizeUserPreference()==null) || 
             (this.maxSizeUserPreference!=null &&
              this.maxSizeUserPreference.equals(other.getMaxSizeUserPreference()))) &&
            ((this.PVNLength==null && other.getPVNLength()==null) || 
             (this.PVNLength!=null &&
              this.PVNLength.equals(other.getPVNLength()))) &&
            ((this.PVNChangeRequiredOnAdminReset==null && other.getPVNChangeRequiredOnAdminReset()==null) || 
             (this.PVNChangeRequiredOnAdminReset!=null &&
              this.PVNChangeRequiredOnAdminReset.equals(other.getPVNChangeRequiredOnAdminReset()))) &&
            ((this.authTypesRequiringPVN==null && other.getAuthTypesRequiringPVN()==null) || 
             (this.authTypesRequiringPVN!=null &&
              java.util.Arrays.equals(this.authTypesRequiringPVN, other.getAuthTypesRequiringPVN()))) &&
            ((this.allTokenVendorsRequirePVN==null && other.getAllTokenVendorsRequirePVN()==null) || 
             (this.allTokenVendorsRequirePVN!=null &&
              this.allTokenVendorsRequirePVN.equals(other.getAllTokenVendorsRequirePVN()))) &&
            ((this.tokenVendorsRequiringPVN==null && other.getTokenVendorsRequiringPVN()==null) || 
             (this.tokenVendorsRequiringPVN!=null &&
              java.util.Arrays.equals(this.tokenVendorsRequiringPVN, other.getTokenVendorsRequiringPVN()))) &&
            ((this.numDaysForActivation==null && other.getNumDaysForActivation()==null) || 
             (this.numDaysForActivation!=null &&
              this.numDaysForActivation.equals(other.getNumDaysForActivation()))) &&
            ((this.activationAuthTypes==null && other.getActivationAuthTypes()==null) || 
             (this.activationAuthTypes!=null &&
              java.util.Arrays.equals(this.activationAuthTypes, other.getActivationAuthTypes()))) &&
            ((this.checkIPAddressInLocationHistory==null && other.getCheckIPAddressInLocationHistory()==null) || 
             (this.checkIPAddressInLocationHistory!=null &&
              this.checkIPAddressInLocationHistory.equals(other.getCheckIPAddressInLocationHistory()))) &&
            ((this.maxLocationHistorySize==null && other.getMaxLocationHistorySize()==null) || 
             (this.maxLocationHistorySize!=null &&
              this.maxLocationHistorySize.equals(other.getMaxLocationHistorySize()))) &&
            ((this.locationHistoryLifetime==null && other.getLocationHistoryLifetime()==null) || 
             (this.locationHistoryLifetime!=null &&
              this.locationHistoryLifetime.equals(other.getLocationHistoryLifetime()))) &&
            ((this.maxVelocity==null && other.getMaxVelocity()==null) || 
             (this.maxVelocity!=null &&
              this.maxVelocity.equals(other.getMaxVelocity()))) &&
            ((this.checkVelocity==null && other.getCheckVelocity()==null) || 
             (this.checkVelocity!=null &&
              this.checkVelocity.equals(other.getCheckVelocity()))) &&
            ((this.countryBlacklist==null && other.getCountryBlacklist()==null) || 
             (this.countryBlacklist!=null &&
              java.util.Arrays.equals(this.countryBlacklist, other.getCountryBlacklist()))) &&
            ((this.addCountryBlacklist==null && other.getAddCountryBlacklist()==null) || 
             (this.addCountryBlacklist!=null &&
              this.addCountryBlacklist.equals(other.getAddCountryBlacklist()))) &&
            ((this.removeCountryBlacklist==null && other.getRemoveCountryBlacklist()==null) || 
             (this.removeCountryBlacklist!=null &&
              this.removeCountryBlacklist.equals(other.getRemoveCountryBlacklist()))) &&
            ((this.expectedLocations==null && other.getExpectedLocations()==null) || 
             (this.expectedLocations!=null &&
              java.util.Arrays.equals(this.expectedLocations, other.getExpectedLocations()))) &&
            ((this.addExpectedLocations==null && other.getAddExpectedLocations()==null) || 
             (this.addExpectedLocations!=null &&
              this.addExpectedLocations.equals(other.getAddExpectedLocations()))) &&
            ((this.removeExpectedLocations==null && other.getRemoveExpectedLocations()==null) || 
             (this.removeExpectedLocations!=null &&
              this.removeExpectedLocations.equals(other.getRemoveExpectedLocations()))) &&
            ((this.maxUserExpectedLocationsSize==null && other.getMaxUserExpectedLocationsSize()==null) || 
             (this.maxUserExpectedLocationsSize!=null &&
              this.maxUserExpectedLocationsSize.equals(other.getMaxUserExpectedLocationsSize()))) &&
            ((this.normalRejectAdd==null && other.getNormalRejectAdd()==null) || 
             (this.normalRejectAdd!=null &&
              this.normalRejectAdd.equals(other.getNormalRejectAdd()))) &&
            ((this.normalRejectRemove==null && other.getNormalRejectRemove()==null) || 
             (this.normalRejectRemove!=null &&
              this.normalRejectRemove.equals(other.getNormalRejectRemove()))) &&
            ((this.normalReject==null && other.getNormalReject()==null) || 
             (this.normalReject!=null &&
              this.normalReject.equals(other.getNormalReject()))) &&
            ((this.normalAuthenticatedAdd==null && other.getNormalAuthenticatedAdd()==null) || 
             (this.normalAuthenticatedAdd!=null &&
              this.normalAuthenticatedAdd.equals(other.getNormalAuthenticatedAdd()))) &&
            ((this.normalAuthenticatedRemove==null && other.getNormalAuthenticatedRemove()==null) || 
             (this.normalAuthenticatedRemove!=null &&
              this.normalAuthenticatedRemove.equals(other.getNormalAuthenticatedRemove()))) &&
            ((this.normalAuthenticated==null && other.getNormalAuthenticated()==null) || 
             (this.normalAuthenticated!=null &&
              this.normalAuthenticated.equals(other.getNormalAuthenticated()))) &&
            ((this.enhancedRejectAdd==null && other.getEnhancedRejectAdd()==null) || 
             (this.enhancedRejectAdd!=null &&
              this.enhancedRejectAdd.equals(other.getEnhancedRejectAdd()))) &&
            ((this.enhancedRejectRemove==null && other.getEnhancedRejectRemove()==null) || 
             (this.enhancedRejectRemove!=null &&
              this.enhancedRejectRemove.equals(other.getEnhancedRejectRemove()))) &&
            ((this.enhancedReject==null && other.getEnhancedReject()==null) || 
             (this.enhancedReject!=null &&
              this.enhancedReject.equals(other.getEnhancedReject()))) &&
            ((this.enhancedAuthenticatedAdd==null && other.getEnhancedAuthenticatedAdd()==null) || 
             (this.enhancedAuthenticatedAdd!=null &&
              this.enhancedAuthenticatedAdd.equals(other.getEnhancedAuthenticatedAdd()))) &&
            ((this.enhancedAuthenticatedRemove==null && other.getEnhancedAuthenticatedRemove()==null) || 
             (this.enhancedAuthenticatedRemove!=null &&
              this.enhancedAuthenticatedRemove.equals(other.getEnhancedAuthenticatedRemove()))) &&
            ((this.enhancedAuthenticated==null && other.getEnhancedAuthenticated()==null) || 
             (this.enhancedAuthenticated!=null &&
              this.enhancedAuthenticated.equals(other.getEnhancedAuthenticated()))) &&
            ((this.externalRiskScoreNormalPass==null && other.getExternalRiskScoreNormalPass()==null) || 
             (this.externalRiskScoreNormalPass!=null &&
              this.externalRiskScoreNormalPass.equals(other.getExternalRiskScoreNormalPass()))) &&
            ((this.externalRiskScoreNormalFail==null && other.getExternalRiskScoreNormalFail()==null) || 
             (this.externalRiskScoreNormalFail!=null &&
              this.externalRiskScoreNormalFail.equals(other.getExternalRiskScoreNormalFail()))) &&
            ((this.externalRiskScoreEnhancedPass==null && other.getExternalRiskScoreEnhancedPass()==null) || 
             (this.externalRiskScoreEnhancedPass!=null &&
              this.externalRiskScoreEnhancedPass.equals(other.getExternalRiskScoreEnhancedPass()))) &&
            ((this.externalRiskScoreEnhancedFail==null && other.getExternalRiskScoreEnhancedFail()==null) || 
             (this.externalRiskScoreEnhancedFail!=null &&
              this.externalRiskScoreEnhancedFail.equals(other.getExternalRiskScoreEnhancedFail()))) &&
            ((this.externalRiskEngine==null && other.getExternalRiskEngine()==null) || 
             (this.externalRiskEngine!=null &&
              this.externalRiskEngine.equals(other.getExternalRiskEngine()))) &&
            ((this.performTransactionDelivery==null && other.getPerformTransactionDelivery()==null) || 
             (this.performTransactionDelivery!=null &&
              this.performTransactionDelivery.equals(other.getPerformTransactionDelivery()))) &&
            ((this.softTokenPINRequired==null && other.getSoftTokenPINRequired()==null) || 
             (this.softTokenPINRequired!=null &&
              this.softTokenPINRequired.equals(other.getSoftTokenPINRequired()))) &&
            ((this.softTokenOTPLength==null && other.getSoftTokenOTPLength()==null) || 
             (this.softTokenOTPLength!=null &&
              this.softTokenOTPLength.equals(other.getSoftTokenOTPLength()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getMaxAliases() != null) {
            _hashCode += getMaxAliases().hashCode();
        }
        if (getMaxContactInfoNumber() != null) {
            _hashCode += getMaxContactInfoNumber().hashCode();
        }
        if (getLockoutMode() != null) {
            _hashCode += getLockoutMode().hashCode();
        }
        if (getMaxFailures() != null) {
            _hashCode += getMaxFailures().hashCode();
        }
        if (getMaxGlobalFailures() != null) {
            _hashCode += getMaxGlobalFailures().hashCode();
        }
        if (getMaxCertificateFailures() != null) {
            _hashCode += getMaxCertificateFailures().hashCode();
        }
        if (getMaxExternalFailures() != null) {
            _hashCode += getMaxExternalFailures().hashCode();
        }
        if (getMaxGridFailures() != null) {
            _hashCode += getMaxGridFailures().hashCode();
        }
        if (getMaxTokenCRFailures() != null) {
            _hashCode += getMaxTokenCRFailures().hashCode();
        }
        if (getMaxTokenROFailures() != null) {
            _hashCode += getMaxTokenROFailures().hashCode();
        }
        if (getMaxOTPFailures() != null) {
            _hashCode += getMaxOTPFailures().hashCode();
        }
        if (getMaxQAFailures() != null) {
            _hashCode += getMaxQAFailures().hashCode();
        }
        if (getMaxRBAIPAuthFailures() != null) {
            _hashCode += getMaxRBAIPAuthFailures().hashCode();
        }
        if (getMaxRBAMachineAuthFailures() != null) {
            _hashCode += getMaxRBAMachineAuthFailures().hashCode();
        }
        if (getMaxRBACertificateAuthFailures() != null) {
            _hashCode += getMaxRBACertificateAuthFailures().hashCode();
        }
        if (getMaxRBAExternalRiskAuthFailures() != null) {
            _hashCode += getMaxRBAExternalRiskAuthFailures().hashCode();
        }
        if (getLockoutTime() != null) {
            _hashCode += getLockoutTime().hashCode();
        }
        if (getMaxSecretSize() != null) {
            _hashCode += getMaxSecretSize().hashCode();
        }
        if (getMaxSecretNumber() != null) {
            _hashCode += getMaxSecretNumber().hashCode();
        }
        if (getGenericAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getGenericAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getGenericAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getEnhancedGenericAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getEnhancedGenericAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getEnhancedGenericAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMachineAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getMachineAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getMachineAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAuthTypeCanViewSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypeCanViewSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypeCanViewSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAuthTypeCanModifySecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypeCanModifySecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypeCanModifySecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMaxMachineSecrets() != null) {
            _hashCode += getMaxMachineSecrets().hashCode();
        }
        if (getMaxMachineSecretsSize() != null) {
            _hashCode += getMaxMachineSecretsSize().hashCode();
        }
        if (getMachineSecretRequiresMachineNonce() != null) {
            _hashCode += getMachineSecretRequiresMachineNonce().hashCode();
        }
        if (getMachineSecretRequiresSequenceNonce() != null) {
            _hashCode += getMachineSecretRequiresSequenceNonce().hashCode();
        }
        if (getMachineSecretRequiresAppData() != null) {
            _hashCode += getMachineSecretRequiresAppData().hashCode();
        }
        if (getMachineSecretAllowsBadAppData() != null) {
            _hashCode += getMachineSecretAllowsBadAppData().hashCode();
        }
        if (getMachineSecretLifetime() != null) {
            _hashCode += getMachineSecretLifetime().hashCode();
        }
        if (getFailedMachineAuthIncrementsLockout() != null) {
            _hashCode += getFailedMachineAuthIncrementsLockout().hashCode();
        }
        if (getMaxAuthSecrets() != null) {
            _hashCode += getMaxAuthSecrets().hashCode();
        }
        if (getMaxAuthSecretsSize() != null) {
            _hashCode += getMaxAuthSecretsSize().hashCode();
        }
        if (getMaxQuestions() != null) {
            _hashCode += getMaxQuestions().hashCode();
        }
        if (getMaxQASize() != null) {
            _hashCode += getMaxQASize().hashCode();
        }
        if (getQAChallengeSize() != null) {
            _hashCode += getQAChallengeSize().hashCode();
        }
        if (getMinQAChallengeSize() != null) {
            _hashCode += getMinQAChallengeSize().hashCode();
        }
        if (getMaxQAChallengeSize() != null) {
            _hashCode += getMaxQAChallengeSize().hashCode();
        }
        if (getDisableQAChallengeRetention() != null) {
            _hashCode += getDisableQAChallengeRetention().hashCode();
        }
        if (getQAChallengeLifetime() != null) {
            _hashCode += getQAChallengeLifetime().hashCode();
        }
        if (getUpdateLockoutForReplacedQAChallenge() != null) {
            _hashCode += getUpdateLockoutForReplacedQAChallenge().hashCode();
        }
        if (getQaDefaultWrongAnswersAllowed() != null) {
            _hashCode += getQaDefaultWrongAnswersAllowed().hashCode();
        }
        if (getQaMaximumWrongAnswersAllowed() != null) {
            _hashCode += getQaMaximumWrongAnswersAllowed().hashCode();
        }
        if (getQaInexactMatchAllowed() != null) {
            _hashCode += getQaInexactMatchAllowed().hashCode();
        }
        if (getOTPCellAlphabet() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOTPCellAlphabet());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOTPCellAlphabet(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getOTPCellReplacements() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOTPCellReplacements());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOTPCellReplacements(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getOTPLifetime() != null) {
            _hashCode += getOTPLifetime().hashCode();
        }
        if (getOTPLength() != null) {
            _hashCode += getOTPLength().hashCode();
        }
        if (getOTPDeliveryEnabled() != null) {
            _hashCode += getOTPDeliveryEnabled().hashCode();
        }
        if (getOTPAlwaysGenerate() != null) {
            _hashCode += getOTPAlwaysGenerate().hashCode();
        }
        if (getOTPDynamicRefresh() != null) {
            _hashCode += getOTPDynamicRefresh().hashCode();
        }
        if (getOTPNumberOutstanding() != null) {
            _hashCode += getOTPNumberOutstanding().hashCode();
        }
        if (getOTPRefreshThreshold() != null) {
            _hashCode += getOTPRefreshThreshold().hashCode();
        }
        if (getReturnAuthSecretWithChall() != null) {
            _hashCode += getReturnAuthSecretWithChall().hashCode();
        }
        if (getAutoUnassignTokens() != null) {
            _hashCode += getAutoUnassignTokens().hashCode();
        }
        if (getAutoMoveTokens() != null) {
            _hashCode += getAutoMoveTokens().hashCode();
        }
        if (getDisableTokenChallengeRetention() != null) {
            _hashCode += getDisableTokenChallengeRetention().hashCode();
        }
        if (getTokenChallengeLifetime() != null) {
            _hashCode += getTokenChallengeLifetime().hashCode();
        }
        if (getUpdateLockoutForReplacedTokenChallenge() != null) {
            _hashCode += getUpdateLockoutForReplacedTokenChallenge().hashCode();
        }
        if (getMaxAllowedTokenSets() != null) {
            _hashCode += getMaxAllowedTokenSets().hashCode();
        }
        if (getAllowNONEAuthentication() != null) {
            _hashCode += getAllowNONEAuthentication().hashCode();
        }
        if (getConsiderTempPINLast() != null) {
            _hashCode += getConsiderTempPINLast().hashCode();
        }
        if (getStoreLastAuthInfo() != null) {
            _hashCode += getStoreLastAuthInfo().hashCode();
        }
        if (getAllowCreateIfDisabledInRepository() != null) {
            _hashCode += getAllowCreateIfDisabledInRepository().hashCode();
        }
        if (getAllowCreateIfExpiredInRepository() != null) {
            _hashCode += getAllowCreateIfExpiredInRepository().hashCode();
        }
        if (getAllowAuthIfDisabledInRepository() != null) {
            _hashCode += getAllowAuthIfDisabledInRepository().hashCode();
        }
        if (getAllowAuthIfExpiredInRepository() != null) {
            _hashCode += getAllowAuthIfExpiredInRepository().hashCode();
        }
        if (getTransactionSignatureType() != null) {
            _hashCode += getTransactionSignatureType().hashCode();
        }
        if (getTransactionLifetime() != null) {
            _hashCode += getTransactionLifetime().hashCode();
        }
        if (getMaxNumTransactionDetails() != null) {
            _hashCode += getMaxNumTransactionDetails().hashCode();
        }
        if (getAllowSelfSignedUserCert() != null) {
            _hashCode += getAllowSelfSignedUserCert().hashCode();
        }
        if (getAllowCertNotIssuedByRegisteredCA() != null) {
            _hashCode += getAllowCertNotIssuedByRegisteredCA().hashCode();
        }
        if (getAllowAllRegisteredCAs() != null) {
            _hashCode += getAllowAllRegisteredCAs().hashCode();
        }
        if (getAddAllowedRegisteredCAs() != null) {
            _hashCode += getAddAllowedRegisteredCAs().hashCode();
        }
        if (getRemoveAllowedRegisteredCAs() != null) {
            _hashCode += getRemoveAllowedRegisteredCAs().hashCode();
        }
        if (getAllowedRegisteredCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedRegisteredCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedRegisteredCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAllowCertNotIssuedByManagedCA() != null) {
            _hashCode += getAllowCertNotIssuedByManagedCA().hashCode();
        }
        if (getAllowAllManagedCAs() != null) {
            _hashCode += getAllowAllManagedCAs().hashCode();
        }
        if (getAddAllowedManagedCAs() != null) {
            _hashCode += getAddAllowedManagedCAs().hashCode();
        }
        if (getRemoveAllowedManagedCAs() != null) {
            _hashCode += getRemoveAllowedManagedCAs().hashCode();
        }
        if (getAllowedManagedCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedManagedCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedManagedCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCertificateAuthenticationHashAlg() != null) {
            _hashCode += getCertificateAuthenticationHashAlg().hashCode();
        }
        if (getCertificateAuthenticationChallengeSize() != null) {
            _hashCode += getCertificateAuthenticationChallengeSize().hashCode();
        }
        if (getMaxCertsPerUser() != null) {
            _hashCode += getMaxCertsPerUser().hashCode();
        }
        if (getAutoDeleteUserCerts() != null) {
            _hashCode += getAutoDeleteUserCerts().hashCode();
        }
        if (getDisableCertificateChallengeRetention() != null) {
            _hashCode += getDisableCertificateChallengeRetention().hashCode();
        }
        if (getAllowCertificateChallengeDelivery() != null) {
            _hashCode += getAllowCertificateChallengeDelivery().hashCode();
        }
        if (getAllowCertificateTransactionDelivery() != null) {
            _hashCode += getAllowCertificateTransactionDelivery().hashCode();
        }
        if (getAllowCertificateSign() != null) {
            _hashCode += getAllowCertificateSign().hashCode();
        }
        if (getCertificateChallengeLifetime() != null) {
            _hashCode += getCertificateChallengeLifetime().hashCode();
        }
        if (getUpdateLockoutForReplacedCertificateChallenge() != null) {
            _hashCode += getUpdateLockoutForReplacedCertificateChallenge().hashCode();
        }
        if (getAllowAllSmartCredentialDefinitions() != null) {
            _hashCode += getAllowAllSmartCredentialDefinitions().hashCode();
        }
        if (getAddAllowedSmartCredentialDefinitions() != null) {
            _hashCode += getAddAllowedSmartCredentialDefinitions().hashCode();
        }
        if (getRemoveAllowedSmartCredentialDefinitions() != null) {
            _hashCode += getRemoveAllowedSmartCredentialDefinitions().hashCode();
        }
        if (getAllowedSmartCredentialDefinitions() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedSmartCredentialDefinitions());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedSmartCredentialDefinitions(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMaxSmartCredentialsPerUser() != null) {
            _hashCode += getMaxSmartCredentialsPerUser().hashCode();
        }
        if (getSmartCredentialIDPrefix() != null) {
            _hashCode += getSmartCredentialIDPrefix().hashCode();
        }
        if (getSmartCredentialTokenVendor() != null) {
            _hashCode += getSmartCredentialTokenVendor().hashCode();
        }
        if (getAutoUnassignSmartCredentials() != null) {
            _hashCode += getAutoUnassignSmartCredentials().hashCode();
        }
        if (getAutoCancelSmartCredentials() != null) {
            _hashCode += getAutoCancelSmartCredentials().hashCode();
        }
        if (getAutoCancelSmartCredentialsForce() != null) {
            _hashCode += getAutoCancelSmartCredentialsForce().hashCode();
        }
        if (getAutoMoveSmartCredentials() != null) {
            _hashCode += getAutoMoveSmartCredentials().hashCode();
        }
        if (getAutoRegisterSmartCredentialsToPACS() != null) {
            _hashCode += getAutoRegisterSmartCredentialsToPACS().hashCode();
        }
        if (getAutoSuspendSmartCredentialsFromPACS() != null) {
            _hashCode += getAutoSuspendSmartCredentialsFromPACS().hashCode();
        }
        if (getAllowSoftwareSmartCredentials() != null) {
            _hashCode += getAllowSoftwareSmartCredentials().hashCode();
        }
        if (getMobileSmartCredentialPINPrompt() != null) {
            _hashCode += getMobileSmartCredentialPINPrompt().hashCode();
        }
        if (getMobileSmartCredentialSessionTimeout() != null) {
            _hashCode += getMobileSmartCredentialSessionTimeout().hashCode();
        }
        if (getAllowAllDigitalIdConfigs() != null) {
            _hashCode += getAllowAllDigitalIdConfigs().hashCode();
        }
        if (getAddAllowedDigitalIdConfigs() != null) {
            _hashCode += getAddAllowedDigitalIdConfigs().hashCode();
        }
        if (getRemoveAllowedDigitalIdConfigs() != null) {
            _hashCode += getRemoveAllowedDigitalIdConfigs().hashCode();
        }
        if (getAllowedDigitalIdConfigs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedDigitalIdConfigs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedDigitalIdConfigs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMaxDigitalIdsPerUser() != null) {
            _hashCode += getMaxDigitalIdsPerUser().hashCode();
        }
        if (getMaxClientTypesPerDigitalId() != null) {
            _hashCode += getMaxClientTypesPerDigitalId().hashCode();
        }
        if (getAutoCancelDigitalIds() != null) {
            _hashCode += getAutoCancelDigitalIds().hashCode();
        }
        if (getUserRegistrationPasswordLifetime() != null) {
            _hashCode += getUserRegistrationPasswordLifetime().hashCode();
        }
        if (getUserRegistrationPasswordLength() != null) {
            _hashCode += getUserRegistrationPasswordLength().hashCode();
        }
        if (getMaxFederationsPerUser() != null) {
            _hashCode += getMaxFederationsPerUser().hashCode();
        }
        if (getMaxNumUserPreferences() != null) {
            _hashCode += getMaxNumUserPreferences().hashCode();
        }
        if (getMaxSizeUserPreference() != null) {
            _hashCode += getMaxSizeUserPreference().hashCode();
        }
        if (getPVNLength() != null) {
            _hashCode += getPVNLength().hashCode();
        }
        if (getPVNChangeRequiredOnAdminReset() != null) {
            _hashCode += getPVNChangeRequiredOnAdminReset().hashCode();
        }
        if (getAuthTypesRequiringPVN() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypesRequiringPVN());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypesRequiringPVN(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAllTokenVendorsRequirePVN() != null) {
            _hashCode += getAllTokenVendorsRequirePVN().hashCode();
        }
        if (getTokenVendorsRequiringPVN() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokenVendorsRequiringPVN());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokenVendorsRequiringPVN(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getNumDaysForActivation() != null) {
            _hashCode += getNumDaysForActivation().hashCode();
        }
        if (getActivationAuthTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getActivationAuthTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getActivationAuthTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCheckIPAddressInLocationHistory() != null) {
            _hashCode += getCheckIPAddressInLocationHistory().hashCode();
        }
        if (getMaxLocationHistorySize() != null) {
            _hashCode += getMaxLocationHistorySize().hashCode();
        }
        if (getLocationHistoryLifetime() != null) {
            _hashCode += getLocationHistoryLifetime().hashCode();
        }
        if (getMaxVelocity() != null) {
            _hashCode += getMaxVelocity().hashCode();
        }
        if (getCheckVelocity() != null) {
            _hashCode += getCheckVelocity().hashCode();
        }
        if (getCountryBlacklist() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCountryBlacklist());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCountryBlacklist(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAddCountryBlacklist() != null) {
            _hashCode += getAddCountryBlacklist().hashCode();
        }
        if (getRemoveCountryBlacklist() != null) {
            _hashCode += getRemoveCountryBlacklist().hashCode();
        }
        if (getExpectedLocations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getExpectedLocations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getExpectedLocations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAddExpectedLocations() != null) {
            _hashCode += getAddExpectedLocations().hashCode();
        }
        if (getRemoveExpectedLocations() != null) {
            _hashCode += getRemoveExpectedLocations().hashCode();
        }
        if (getMaxUserExpectedLocationsSize() != null) {
            _hashCode += getMaxUserExpectedLocationsSize().hashCode();
        }
        if (getNormalRejectAdd() != null) {
            _hashCode += getNormalRejectAdd().hashCode();
        }
        if (getNormalRejectRemove() != null) {
            _hashCode += getNormalRejectRemove().hashCode();
        }
        if (getNormalReject() != null) {
            _hashCode += getNormalReject().hashCode();
        }
        if (getNormalAuthenticatedAdd() != null) {
            _hashCode += getNormalAuthenticatedAdd().hashCode();
        }
        if (getNormalAuthenticatedRemove() != null) {
            _hashCode += getNormalAuthenticatedRemove().hashCode();
        }
        if (getNormalAuthenticated() != null) {
            _hashCode += getNormalAuthenticated().hashCode();
        }
        if (getEnhancedRejectAdd() != null) {
            _hashCode += getEnhancedRejectAdd().hashCode();
        }
        if (getEnhancedRejectRemove() != null) {
            _hashCode += getEnhancedRejectRemove().hashCode();
        }
        if (getEnhancedReject() != null) {
            _hashCode += getEnhancedReject().hashCode();
        }
        if (getEnhancedAuthenticatedAdd() != null) {
            _hashCode += getEnhancedAuthenticatedAdd().hashCode();
        }
        if (getEnhancedAuthenticatedRemove() != null) {
            _hashCode += getEnhancedAuthenticatedRemove().hashCode();
        }
        if (getEnhancedAuthenticated() != null) {
            _hashCode += getEnhancedAuthenticated().hashCode();
        }
        if (getExternalRiskScoreNormalPass() != null) {
            _hashCode += getExternalRiskScoreNormalPass().hashCode();
        }
        if (getExternalRiskScoreNormalFail() != null) {
            _hashCode += getExternalRiskScoreNormalFail().hashCode();
        }
        if (getExternalRiskScoreEnhancedPass() != null) {
            _hashCode += getExternalRiskScoreEnhancedPass().hashCode();
        }
        if (getExternalRiskScoreEnhancedFail() != null) {
            _hashCode += getExternalRiskScoreEnhancedFail().hashCode();
        }
        if (getExternalRiskEngine() != null) {
            _hashCode += getExternalRiskEngine().hashCode();
        }
        if (getPerformTransactionDelivery() != null) {
            _hashCode += getPerformTransactionDelivery().hashCode();
        }
        if (getSoftTokenPINRequired() != null) {
            _hashCode += getSoftTokenPINRequired().hashCode();
        }
        if (getSoftTokenOTPLength() != null) {
            _hashCode += getSoftTokenOTPLength().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserSpecParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSpecParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxContactInfoNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxContactInfoNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutMode");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lockoutMode"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "LockoutMode"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxGlobalFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxGlobalFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxCertificateFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxCertificateFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxExternalFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxExternalFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxGridFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxGridFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxTokenCRFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxTokenCRFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxTokenROFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxTokenROFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxOTPFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxOTPFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQAFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQAFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAIPAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAIPAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAMachineAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAMachineAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBACertificateAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBACertificateAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAExternalRiskAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAExternalRiskAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutTime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lockoutTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSecretSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxSecretSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSecretNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxSecretNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("genericAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "genericAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedGenericAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedGenericAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypeCanViewSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "authTypeCanViewSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypeCanModifySecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "authTypeCanModifySecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxMachineSecretsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxMachineSecretsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresMachineNonce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresMachineNonce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresSequenceNonce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresSequenceNonce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresAppData");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresAppData"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretAllowsBadAppData");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretAllowsBadAppData"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("failedMachineAuthIncrementsLockout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "failedMachineAuthIncrementsLockout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAuthSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAuthSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAuthSecretsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAuthSecretsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQuestions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQuestions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQASize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQASize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("QAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minQAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minQAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableQAChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableQAChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("QAChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QAChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedQAChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedQAChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaDefaultWrongAnswersAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaDefaultWrongAnswersAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaMaximumWrongAnswersAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaMaximumWrongAnswersAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaInexactMatchAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaInexactMatchAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPCellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPCellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPCellReplacements");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPCellReplacements"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPAlwaysGenerate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPAlwaysGenerate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDynamicRefresh");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDynamicRefresh"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPNumberOutstanding");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPNumberOutstanding"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPRefreshThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPRefreshThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("returnAuthSecretWithChall");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ReturnAuthSecretWithChall"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoUnassignTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "autoUnassignTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoMoveTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "autoMoveTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableTokenChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableTokenChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedTokenChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedTokenChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAllowedTokenSets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAllowedTokenSets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowNONEAuthentication");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowNONEAuthentication"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("considerTempPINLast");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ConsiderTempPINLast"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("storeLastAuthInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "storeLastAuthInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCreateIfDisabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCreateIfDisabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCreateIfExpiredInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCreateIfExpiredInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAuthIfDisabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAuthIfDisabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAuthIfExpiredInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAuthIfExpiredInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transactionSignatureType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "transactionSignatureType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "TransactionSignatureType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transactionLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "transactionLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumTransactionDetails");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxNumTransactionDetails"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowSelfSignedUserCert");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowSelfSignedUserCert"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertNotIssuedByRegisteredCA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCertNotIssuedByRegisteredCA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addAllowedRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AddAllowedRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllowedRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllowedRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertNotIssuedByManagedCA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCertNotIssuedByManagedCA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addAllowedManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AddAllowedManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllowedManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllowedManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAuthenticationHashAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateAuthenticationHashAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAuthenticationChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateAuthenticationChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxCertsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxCertsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoDeleteUserCerts");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoDeleteUserCerts"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableCertificateChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableCertificateChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateChallengeDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateChallengeDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateTransactionDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateTransactionDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateSign");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateSign"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedCertificateChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedCertificateChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addAllowedSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AddAllowedSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllowedSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllowedSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSmartCredentialsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxSmartCredentialsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialIDPrefix");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialIDPrefix"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialTokenVendor");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialTokenVendor"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoUnassignSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoUnassignSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelSmartCredentialsForce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelSmartCredentialsForce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoMoveSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoMoveSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoRegisterSmartCredentialsToPACS");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoRegisterSmartCredentialsToPACS"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoSuspendSmartCredentialsFromPACS");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoSuspendSmartCredentialsFromPACS"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowSoftwareSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowSoftwareSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileSmartCredentialPINPrompt");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileSmartCredentialPINPrompt"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PINPromptType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileSmartCredentialSessionTimeout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileSmartCredentialSessionTimeout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addAllowedDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AddAllowedDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllowedDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RemoveAllowedDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxDigitalIdsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxDigitalIdsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxClientTypesPerDigitalId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxClientTypesPerDigitalId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelDigitalIds");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelDigitalIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userRegistrationPasswordLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserRegistrationPasswordLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userRegistrationPasswordLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserRegistrationPasswordLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxFederationsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxFederationsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumUserPreferences");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxNumUserPreferences"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSizeUserPreference");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxSizeUserPreference"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVNLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVNLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVNChangeRequiredOnAdminReset");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVNChangeRequiredOnAdminReset"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypesRequiringPVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "authTypesRequiringPVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allTokenVendorsRequirePVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allTokenVendorsRequirePVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenVendorsRequiringPVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenVendorsRequiringPVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numDaysForActivation");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numDaysForActivation"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationAuthTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationAuthTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locationHistoryLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "locationHistoryLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countryBlacklist");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countryBlacklist"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addCountryBlacklist");
        elemField.setXmlName(new javax.xml.namespace.QName("", "addCountryBlacklist"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeCountryBlacklist");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeCountryBlacklist"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ExpectedLocation"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("addExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "addExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "removeExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxUserExpectedLocationsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxUserExpectedLocationsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalRejectAdd");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalRejectAdd"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalRejectRemove");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalRejectRemove"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalReject");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalReject"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalAuthenticatedAdd");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalAuthenticatedAdd"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalAuthenticatedRemove");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalAuthenticatedRemove"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalAuthenticated");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalAuthenticated"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedRejectAdd");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedRejectAdd"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedRejectRemove");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedRejectRemove"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedReject");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedReject"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedAuthenticatedAdd");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedAuthenticatedAdd"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedAuthenticatedRemove");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedAuthenticatedRemove"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedAuthenticated");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedAuthenticated"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreNormalPass");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreNormalPass"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreNormalFail");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreNormalFail"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreEnhancedPass");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreEnhancedPass"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreEnhancedFail");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreEnhancedFail"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskEngine");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskEngine"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("performTransactionDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PerformTransactionDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("softTokenPINRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SoftTokenPINRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("softTokenOTPLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SoftTokenOTPLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
