/**
 * UserCardParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters passed when creating or modifying
 *                         a user card. All values can be null indicating
 * that the
 *                         default is used when creating a card, or the
 * value is
 *                         not changed when modifying a card.
 */
public class UserCardParms  implements java.io.Serializable {
    /* If specified, indicates that instead of creating a new
     *                                 card, an existing preproduced card
     * will be assigned to
     *                                 this user. This parameter is ignored
     * by the userCardSet
     *                                 and userCardUnassign operations. */
    private String serialNumber;

    /* The lifetime of the card in milliseconds. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the card has an infinite
     * lifetime.  If
     *                                 not set for userCardCreate, defaults
     * to the
     *                                 value set in the policy. */
    private Long lifetime;

    /* The superseded lifetime of a card, in
     *                                 milliseconds. During card creation,
     * this value will define
     *                                 the superseded lifetime of an existing
     * card that
     *                                 is superseded by the card being created
     * or
     *                                 assigned to the user. If not set for
     * user card creation, the superseded
     *                                 lifetime value in the policy is used.
     * During card update, this applies to the card being updated. A value
     * of 0 means the
     *                                 card has an infinite superseded lifetime. */
    private Long supersede;

    /* The state of the card. If set during user
     *                                 card creation, this must be one of
     * PENDING,
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not specified for
     *                                 user card creation, the card state
     * is set to PENDING.
     *                                 This state is also subject to the
     * restriction
     *                                 that a user can have at most one card
     * in either
     *                                 of the PENDING or HOLD_PENDING states,
     * and at
     *                                 most one card in either of the CURRENT
     * or HOLD
     *                                 states. */
    private State state;

    /* The number of times this card has been used in successful
     *                                 authentication. If not set, this parameter
     * will not be
     *                                 used. This parameter is ignored by
     * user card creation. */
    private Integer challengeCount;

    /* The number of times the least used cell on the card has
     *                                 been used in a successfully authenticated
     * challenge. If
     *                                 not set, this parameter will not be
     * used. This parameter
     *                                 is ignored when creating a card. */
    private Integer leastUsedCellUsageCount;

    /* The card comment. If this value is not set when creating a
     *                                 new card, it defaults to an empty
     * string. If it
     *                                 is not set when assigning a pre-produced
     * card to
     *                                 a user, the existing pre-produced
     * card comments
     *                                 are preserved. */
    private String comment;

    public UserCardParms() {
    }

    public UserCardParms(
           String serialNumber,
           Long lifetime,
           Long supersede,
           State state,
           Integer challengeCount,
           Integer leastUsedCellUsageCount,
           String comment) {
           this.serialNumber = serialNumber;
           this.lifetime = lifetime;
           this.supersede = supersede;
           this.state = state;
           this.challengeCount = challengeCount;
           this.leastUsedCellUsageCount = leastUsedCellUsageCount;
           this.comment = comment;
    }


    /**
     * Gets the serialNumber value for this UserCardParms.
     * 
     * @return serialNumber   * If specified, indicates that instead of creating a new
     *                                 card, an existing preproduced card
     * will be assigned to
     *                                 this user. This parameter is ignored
     * by the userCardSet
     *                                 and userCardUnassign operations.
     */
    public String getSerialNumber() {
        return serialNumber;
    }


    /**
     * Sets the serialNumber value for this UserCardParms.
     * 
     * @param serialNumber   * If specified, indicates that instead of creating a new
     *                                 card, an existing preproduced card
     * will be assigned to
     *                                 this user. This parameter is ignored
     * by the userCardSet
     *                                 and userCardUnassign operations.
     */
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }


    /**
     * Gets the lifetime value for this UserCardParms.
     * 
     * @return lifetime   * The lifetime of the card in milliseconds. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the card has an infinite
     * lifetime.  If
     *                                 not set for userCardCreate, defaults
     * to the
     *                                 value set in the policy.
     */
    public Long getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this UserCardParms.
     * 
     * @param lifetime   * The lifetime of the card in milliseconds. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the card has an infinite
     * lifetime.  If
     *                                 not set for userCardCreate, defaults
     * to the
     *                                 value set in the policy.
     */
    public void setLifetime(Long lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the supersede value for this UserCardParms.
     * 
     * @return supersede   * The superseded lifetime of a card, in
     *                                 milliseconds. During card creation,
     * this value will define
     *                                 the superseded lifetime of an existing
     * card that
     *                                 is superseded by the card being created
     * or
     *                                 assigned to the user. If not set for
     * user card creation, the superseded
     *                                 lifetime value in the policy is used.
     * During card update, this applies to the card being updated. A value
     * of 0 means the
     *                                 card has an infinite superseded lifetime.
     */
    public Long getSupersede() {
        return supersede;
    }


    /**
     * Sets the supersede value for this UserCardParms.
     * 
     * @param supersede   * The superseded lifetime of a card, in
     *                                 milliseconds. During card creation,
     * this value will define
     *                                 the superseded lifetime of an existing
     * card that
     *                                 is superseded by the card being created
     * or
     *                                 assigned to the user. If not set for
     * user card creation, the superseded
     *                                 lifetime value in the policy is used.
     * During card update, this applies to the card being updated. A value
     * of 0 means the
     *                                 card has an infinite superseded lifetime.
     */
    public void setSupersede(Long supersede) {
        this.supersede = supersede;
    }


    /**
     * Gets the state value for this UserCardParms.
     * 
     * @return state   * The state of the card. If set during user
     *                                 card creation, this must be one of
     * PENDING,
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not specified for
     *                                 user card creation, the card state
     * is set to PENDING.
     *                                 This state is also subject to the
     * restriction
     *                                 that a user can have at most one card
     * in either
     *                                 of the PENDING or HOLD_PENDING states,
     * and at
     *                                 most one card in either of the CURRENT
     * or HOLD
     *                                 states.
     */
    public State getState() {
        return state;
    }


    /**
     * Sets the state value for this UserCardParms.
     * 
     * @param state   * The state of the card. If set during user
     *                                 card creation, this must be one of
     * PENDING,
     *                                 HOLD_PENDING, CURRENT, or HOLD. If
     * not specified for
     *                                 user card creation, the card state
     * is set to PENDING.
     *                                 This state is also subject to the
     * restriction
     *                                 that a user can have at most one card
     * in either
     *                                 of the PENDING or HOLD_PENDING states,
     * and at
     *                                 most one card in either of the CURRENT
     * or HOLD
     *                                 states.
     */
    public void setState(State state) {
        this.state = state;
    }


    /**
     * Gets the challengeCount value for this UserCardParms.
     * 
     * @return challengeCount   * The number of times this card has been used in successful
     *                                 authentication. If not set, this parameter
     * will not be
     *                                 used. This parameter is ignored by
     * user card creation.
     */
    public Integer getChallengeCount() {
        return challengeCount;
    }


    /**
     * Sets the challengeCount value for this UserCardParms.
     * 
     * @param challengeCount   * The number of times this card has been used in successful
     *                                 authentication. If not set, this parameter
     * will not be
     *                                 used. This parameter is ignored by
     * user card creation.
     */
    public void setChallengeCount(Integer challengeCount) {
        this.challengeCount = challengeCount;
    }


    /**
     * Gets the leastUsedCellUsageCount value for this UserCardParms.
     * 
     * @return leastUsedCellUsageCount   * The number of times the least used cell on the card has
     *                                 been used in a successfully authenticated
     * challenge. If
     *                                 not set, this parameter will not be
     * used. This parameter
     *                                 is ignored when creating a card.
     */
    public Integer getLeastUsedCellUsageCount() {
        return leastUsedCellUsageCount;
    }


    /**
     * Sets the leastUsedCellUsageCount value for this UserCardParms.
     * 
     * @param leastUsedCellUsageCount   * The number of times the least used cell on the card has
     *                                 been used in a successfully authenticated
     * challenge. If
     *                                 not set, this parameter will not be
     * used. This parameter
     *                                 is ignored when creating a card.
     */
    public void setLeastUsedCellUsageCount(Integer leastUsedCellUsageCount) {
        this.leastUsedCellUsageCount = leastUsedCellUsageCount;
    }


    /**
     * Gets the comment value for this UserCardParms.
     * 
     * @return comment   * The card comment. If this value is not set when creating a
     *                                 new card, it defaults to an empty
     * string. If it
     *                                 is not set when assigning a pre-produced
     * card to
     *                                 a user, the existing pre-produced
     * card comments
     *                                 are preserved.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserCardParms.
     * 
     * @param comment   * The card comment. If this value is not set when creating a
     *                                 new card, it defaults to an empty
     * string. If it
     *                                 is not set when assigning a pre-produced
     * card to
     *                                 a user, the existing pre-produced
     * card comments
     *                                 are preserved.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserCardParms)) return false;
        UserCardParms other = (UserCardParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.serialNumber==null && other.getSerialNumber()==null) || 
             (this.serialNumber!=null &&
              this.serialNumber.equals(other.getSerialNumber()))) &&
            ((this.lifetime==null && other.getLifetime()==null) || 
             (this.lifetime!=null &&
              this.lifetime.equals(other.getLifetime()))) &&
            ((this.supersede==null && other.getSupersede()==null) || 
             (this.supersede!=null &&
              this.supersede.equals(other.getSupersede()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.challengeCount==null && other.getChallengeCount()==null) || 
             (this.challengeCount!=null &&
              this.challengeCount.equals(other.getChallengeCount()))) &&
            ((this.leastUsedCellUsageCount==null && other.getLeastUsedCellUsageCount()==null) || 
             (this.leastUsedCellUsageCount!=null &&
              this.leastUsedCellUsageCount.equals(other.getLeastUsedCellUsageCount()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getSerialNumber() != null) {
            _hashCode += getSerialNumber().hashCode();
        }
        if (getLifetime() != null) {
            _hashCode += getLifetime().hashCode();
        }
        if (getSupersede() != null) {
            _hashCode += getSupersede().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getChallengeCount() != null) {
            _hashCode += getChallengeCount().hashCode();
        }
        if (getLeastUsedCellUsageCount() != null) {
            _hashCode += getLeastUsedCellUsageCount().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserCardParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserCardParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("serialNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SerialNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supersede");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Supersede"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "State"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "State"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challengeCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ChallengeCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("leastUsedCellUsageCount");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LeastUsedCellUsageCount"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
