/**
 * TokenLicenseParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Parameters used to update the system's soft token license settings.
 */
public class TokenLicenseParms  implements java.io.Serializable {
    /* The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system. */
    private String installKey;

    /* The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system. */
    private String activationKey;

    /* Flag that controls whether or not a full licensed token
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate token count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum token
     * limit. */
    private boolean countTokens;

    /* If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed tokens in the system is within
     * this percentage of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 900
     *                             tokens in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored. */
    private Integer countLimitPercent;

    /* If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed in the system is within countLimit
     * of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 950
     *                             licensed tokens in the system, and this
     * value is set to 100,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 100 tokens of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored. */
    private Integer countLimit;

    /* If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written. */
    private Integer timeLimit;

    /* Flag that controls whether or not token counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of licensed tokens in the system because
     * the countTokens
     *                                 flag was true.  If countTokens is
     * true and this
     *                                 flag is null or false, licensed tokens
     * in partitions are counted,
     *                                 but any mismatches between the number
     * of tokens
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date. */
    private Boolean updatePartitions;

    public TokenLicenseParms() {
    }

    public TokenLicenseParms(
           String installKey,
           String activationKey,
           boolean countTokens,
           Integer countLimitPercent,
           Integer countLimit,
           Integer timeLimit,
           Boolean updatePartitions) {
           this.installKey = installKey;
           this.activationKey = activationKey;
           this.countTokens = countTokens;
           this.countLimitPercent = countLimitPercent;
           this.countLimit = countLimit;
           this.timeLimit = timeLimit;
           this.updatePartitions = updatePartitions;
    }


    /**
     * Gets the installKey value for this TokenLicenseParms.
     * 
     * @return installKey   * The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system.
     */
    public String getInstallKey() {
        return installKey;
    }


    /**
     * Sets the installKey value for this TokenLicenseParms.
     * 
     * @param installKey   * The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system.
     */
    public void setInstallKey(String installKey) {
        this.installKey = installKey;
    }


    /**
     * Gets the activationKey value for this TokenLicenseParms.
     * 
     * @return activationKey   * The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system.
     */
    public String getActivationKey() {
        return activationKey;
    }


    /**
     * Sets the activationKey value for this TokenLicenseParms.
     * 
     * @param activationKey   * The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countTokens flag is set to true.
     * In this 
     *                                 case, the tokenLicenseCheck call only
     * performs the
     *                                 count of licensed tokens in the system.
     */
    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }


    /**
     * Gets the countTokens value for this TokenLicenseParms.
     * 
     * @return countTokens   * Flag that controls whether or not a full licensed token
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate token count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum token
     * limit.
     */
    public boolean isCountTokens() {
        return countTokens;
    }


    /**
     * Sets the countTokens value for this TokenLicenseParms.
     * 
     * @param countTokens   * Flag that controls whether or not a full licensed token
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate token count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum token
     * limit.
     */
    public void setCountTokens(boolean countTokens) {
        this.countTokens = countTokens;
    }


    /**
     * Gets the countLimitPercent value for this TokenLicenseParms.
     * 
     * @return countLimitPercent   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed tokens in the system is within
     * this percentage of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 900
     *                             tokens in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public Integer getCountLimitPercent() {
        return countLimitPercent;
    }


    /**
     * Sets the countLimitPercent value for this TokenLicenseParms.
     * 
     * @param countLimitPercent   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed tokens in the system is within
     * this percentage of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 900
     *                             tokens in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public void setCountLimitPercent(Integer countLimitPercent) {
        this.countLimitPercent = countLimitPercent;
    }


    /**
     * Gets the countLimit value for this TokenLicenseParms.
     * 
     * @return countLimit   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed in the system is within countLimit
     * of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 950
     *                             licensed tokens in the system, and this
     * value is set to 100,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 100 tokens of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public Integer getCountLimit() {
        return countLimit;
    }


    /**
     * Sets the countLimit value for this TokenLicenseParms.
     * 
     * @param countLimit   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             licensed in the system is within countLimit
     * of the
     *                             number of tokens allowed by the license.
     * For example,
     *                             if the license allows for 1000 tokens,
     * there are 950
     *                             licensed tokens in the system, and this
     * value is set to 100,
     *                             a warning audit is written as the number
     * of tokens
     *                             is within 100 tokens of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }


    /**
     * Gets the timeLimit value for this TokenLicenseParms.
     * 
     * @return timeLimit   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written.
     */
    public Integer getTimeLimit() {
        return timeLimit;
    }


    /**
     * Sets the timeLimit value for this TokenLicenseParms.
     * 
     * @param timeLimit   * If countTokens is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written.
     */
    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }


    /**
     * Gets the updatePartitions value for this TokenLicenseParms.
     * 
     * @return updatePartitions   * Flag that controls whether or not token counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of licensed tokens in the system because
     * the countTokens
     *                                 flag was true.  If countTokens is
     * true and this
     *                                 flag is null or false, licensed tokens
     * in partitions are counted,
     *                                 but any mismatches between the number
     * of tokens
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date.
     */
    public Boolean getUpdatePartitions() {
        return updatePartitions;
    }


    /**
     * Sets the updatePartitions value for this TokenLicenseParms.
     * 
     * @param updatePartitions   * Flag that controls whether or not token counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of licensed tokens in the system because
     * the countTokens
     *                                 flag was true.  If countTokens is
     * true and this
     *                                 flag is null or false, licensed tokens
     * in partitions are counted,
     *                                 but any mismatches between the number
     * of tokens
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date.
     */
    public void setUpdatePartitions(Boolean updatePartitions) {
        this.updatePartitions = updatePartitions;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof TokenLicenseParms)) return false;
        TokenLicenseParms other = (TokenLicenseParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.installKey==null && other.getInstallKey()==null) || 
             (this.installKey!=null &&
              this.installKey.equals(other.getInstallKey()))) &&
            ((this.activationKey==null && other.getActivationKey()==null) || 
             (this.activationKey!=null &&
              this.activationKey.equals(other.getActivationKey()))) &&
            this.countTokens == other.isCountTokens() &&
            ((this.countLimitPercent==null && other.getCountLimitPercent()==null) || 
             (this.countLimitPercent!=null &&
              this.countLimitPercent.equals(other.getCountLimitPercent()))) &&
            ((this.countLimit==null && other.getCountLimit()==null) || 
             (this.countLimit!=null &&
              this.countLimit.equals(other.getCountLimit()))) &&
            ((this.timeLimit==null && other.getTimeLimit()==null) || 
             (this.timeLimit!=null &&
              this.timeLimit.equals(other.getTimeLimit()))) &&
            ((this.updatePartitions==null && other.getUpdatePartitions()==null) || 
             (this.updatePartitions!=null &&
              this.updatePartitions.equals(other.getUpdatePartitions())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getInstallKey() != null) {
            _hashCode += getInstallKey().hashCode();
        }
        if (getActivationKey() != null) {
            _hashCode += getActivationKey().hashCode();
        }
        _hashCode += (isCountTokens() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCountLimitPercent() != null) {
            _hashCode += getCountLimitPercent().hashCode();
        }
        if (getCountLimit() != null) {
            _hashCode += getCountLimit().hashCode();
        }
        if (getTimeLimit() != null) {
            _hashCode += getTimeLimit().hashCode();
        }
        if (getUpdatePartitions() != null) {
            _hashCode += getUpdatePartitions().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(TokenLicenseParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "TokenLicenseParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("installKey");
        elemField.setXmlName(new javax.xml.namespace.QName("", "installKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationKey");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countLimitPercent");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countLimitPercent"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countLimit");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countLimit"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("timeLimit");
        elemField.setXmlName(new javax.xml.namespace.QName("", "timeLimit"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updatePartitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updatePartitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
