/**
 * SmartCredentialData.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * This structure contains information about a smart credential that
 * can be used to authenticate a certificate challenge.
 */
public class SmartCredentialData  implements java.io.Serializable {
    /* The Id of the smart credential. */
    private String smartCredentialId;

    /* The optional friendly name of the smart credential. */
    private String friendlyName;

    /* A flag indicating if this smart credential supports
     *                   delivery security challenges. */
    private boolean supportsSecurityChallenge;

    /* A flag indicating if this smart credential is mobile or
     *                   not. */
    private boolean mobile;

    /* A value indicating if the certificate challenge and/or
     *                   transaction details were delivered
     *                   as part of generating the challenge. */
    private DeliveryStatus deliveryStatus;

    /* When included in the authenticateGenericChallenge response
     *                   this value will include the base-64 encoded signed
     * challenge
     *                   response. */
    private String response;

    public SmartCredentialData() {
    }

    public SmartCredentialData(
           String smartCredentialId,
           String friendlyName,
           boolean supportsSecurityChallenge,
           boolean mobile,
           DeliveryStatus deliveryStatus,
           String response) {
           this.smartCredentialId = smartCredentialId;
           this.friendlyName = friendlyName;
           this.supportsSecurityChallenge = supportsSecurityChallenge;
           this.mobile = mobile;
           this.deliveryStatus = deliveryStatus;
           this.response = response;
    }


    /**
     * Gets the smartCredentialId value for this SmartCredentialData.
     * 
     * @return smartCredentialId   * The Id of the smart credential.
     */
    public String getSmartCredentialId() {
        return smartCredentialId;
    }


    /**
     * Sets the smartCredentialId value for this SmartCredentialData.
     * 
     * @param smartCredentialId   * The Id of the smart credential.
     */
    public void setSmartCredentialId(String smartCredentialId) {
        this.smartCredentialId = smartCredentialId;
    }


    /**
     * Gets the friendlyName value for this SmartCredentialData.
     * 
     * @return friendlyName   * The optional friendly name of the smart credential.
     */
    public String getFriendlyName() {
        return friendlyName;
    }


    /**
     * Sets the friendlyName value for this SmartCredentialData.
     * 
     * @param friendlyName   * The optional friendly name of the smart credential.
     */
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }


    /**
     * Gets the supportsSecurityChallenge value for this SmartCredentialData.
     * 
     * @return supportsSecurityChallenge   * A flag indicating if this smart credential supports
     *                   delivery security challenges.
     */
    public boolean isSupportsSecurityChallenge() {
        return supportsSecurityChallenge;
    }


    /**
     * Sets the supportsSecurityChallenge value for this SmartCredentialData.
     * 
     * @param supportsSecurityChallenge   * A flag indicating if this smart credential supports
     *                   delivery security challenges.
     */
    public void setSupportsSecurityChallenge(boolean supportsSecurityChallenge) {
        this.supportsSecurityChallenge = supportsSecurityChallenge;
    }


    /**
     * Gets the mobile value for this SmartCredentialData.
     * 
     * @return mobile   * A flag indicating if this smart credential is mobile or
     *                   not.
     */
    public boolean isMobile() {
        return mobile;
    }


    /**
     * Sets the mobile value for this SmartCredentialData.
     * 
     * @param mobile   * A flag indicating if this smart credential is mobile or
     *                   not.
     */
    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }


    /**
     * Gets the deliveryStatus value for this SmartCredentialData.
     * 
     * @return deliveryStatus   * A value indicating if the certificate challenge and/or
     *                   transaction details were delivered
     *                   as part of generating the challenge.
     */
    public DeliveryStatus getDeliveryStatus() {
        return deliveryStatus;
    }


    /**
     * Sets the deliveryStatus value for this SmartCredentialData.
     * 
     * @param deliveryStatus   * A value indicating if the certificate challenge and/or
     *                   transaction details were delivered
     *                   as part of generating the challenge.
     */
    public void setDeliveryStatus(DeliveryStatus deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }


    /**
     * Gets the response value for this SmartCredentialData.
     * 
     * @return response   * When included in the authenticateGenericChallenge response
     *                   this value will include the base-64 encoded signed
     * challenge
     *                   response.
     */
    public String getResponse() {
        return response;
    }


    /**
     * Sets the response value for this SmartCredentialData.
     * 
     * @param response   * When included in the authenticateGenericChallenge response
     *                   this value will include the base-64 encoded signed
     * challenge
     *                   response.
     */
    public void setResponse(String response) {
        this.response = response;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof SmartCredentialData)) return false;
        SmartCredentialData other = (SmartCredentialData) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.smartCredentialId==null && other.getSmartCredentialId()==null) || 
             (this.smartCredentialId!=null &&
              this.smartCredentialId.equals(other.getSmartCredentialId()))) &&
            ((this.friendlyName==null && other.getFriendlyName()==null) || 
             (this.friendlyName!=null &&
              this.friendlyName.equals(other.getFriendlyName()))) &&
            this.supportsSecurityChallenge == other.isSupportsSecurityChallenge() &&
            this.mobile == other.isMobile() &&
            ((this.deliveryStatus==null && other.getDeliveryStatus()==null) || 
             (this.deliveryStatus!=null &&
              this.deliveryStatus.equals(other.getDeliveryStatus()))) &&
            ((this.response==null && other.getResponse()==null) || 
             (this.response!=null &&
              this.response.equals(other.getResponse())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getSmartCredentialId() != null) {
            _hashCode += getSmartCredentialId().hashCode();
        }
        if (getFriendlyName() != null) {
            _hashCode += getFriendlyName().hashCode();
        }
        _hashCode += (isSupportsSecurityChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isMobile() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getDeliveryStatus() != null) {
            _hashCode += getDeliveryStatus().hashCode();
        }
        if (getResponse() != null) {
            _hashCode += getResponse().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(SmartCredentialData.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "SmartCredentialData"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("friendlyName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FriendlyName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("supportsSecurityChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "supportsSecurityChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobile");
        elemField.setXmlName(new javax.xml.namespace.QName("", "mobile"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("deliveryStatus");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DeliveryStatus"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "DeliveryStatus"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("response");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Response"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
