/**
 * RoleInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines information about a role.
 */
public class RoleInfo  implements java.io.Serializable {
    /* The name of the role. */
    private String name;

    /* Flag indicating if this role is a built-in
     *                                 system role, or one that was created
     * after the
     *                                 system was installed. The built-in
     * system roles
     *                                 cannot be modified with roleSet, nor
     * can they
     *                                 be deleted with roleDelete. */
    private boolean systemRole;

    /* If true, it means this role grants all permissions. */
    private boolean allPermissions;

    /* The list of the names of the permissions granted
     *                                 by the role. Any permission not included
     * in
     *                                 this list is not allowed for the role.
     * If allPermissions is true, this list will be
     *                                 nil. */
    private String[] permissions;

    /* If true, it means this role grants access to
     *                                 all policies. */
    private boolean allPolicies;

    /* The list of the names of policies that this role
     *                                 grants access to. If allPolicies is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all policies in the system. */
    private String[] policyList;

    /* If true, it means this role grants access to
     *                                 all groups. */
    private boolean allGroups;

    /* If true, when assigned to an administrator,
     *                                 this role grants access to users who
     * belong to
     *                                 the same group as the administrator.
     * At most one
     *                                 of allGroups and ownGroup can be true. */
    private boolean ownGroup;

    /* The list of the names of the groups that this role grants access
     * to. If allGroups is true, this list will be filled
     *                                 in with the names of all groups in
     * the system.
     *                                 If ownGroup is true, this list will
     * have a single
     *                                 entry which is the name of the caller's
     * group.
     *                                 In general, the allGroups and ownGroup
     * flags
     *                                 should be checked before this list. */
    private String[] groupList;

    /* If true, it means this role grants access to
     *                                 all roles. */
    private boolean allRoles;

    /* The list of the names of the roles that this role grants access
     * to. If allRoles is true, this list will be filled
     *                                 in with the names of all roles in
     * the system.
     *                                 In general, the allRoles flag
     *                                 should be checked before this list. */
    private String[] roleList;

    /* If true, it means this role grants access to
     *                                 all Smart Credential Definitions. */
    private boolean allSmartCredentialDefinitions;

    /* The list of the names of Smart Credential Definitions that
     *                                 this role grants access to. If
     *                                 allSmartCredentialDefinitions is true,
     * this list will be filled in with the names of
     *                                 all Smart Credential Definitions in
     * the system. */
    private String[] smartCredentialDefinitionList;

    /* If true, it means this role grants access to
     *                                 all Smart Credential Print Modules. */
    private boolean allSmartCredentialPrintModules;

    /* The list of the names of Smart Credential Print Modules that
     * this role grants access to. If
     *                                 allSmartCredentialPrintModules is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all Smart Credential Print Modules
     * in the system. */
    private String[] smartCredentialPrintModuleList;

    /* If the skipSecondAuth flag is set to true
     *                                 for a role, administrators in this
     * role
     *                                 will skip second factor authentication
     * when
     *                                 logging into the Entrust IdentityGuard
     * Administration Interface or Service even
     *                                 when policy dictates that second factor
     * authentication is required.
     *                                 This flag should be set to true for
     * administration identities that require
     *                                 unattended login such as those used
     * for
     *                                 services. */
    private boolean skipSecondAuth;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments about this role. */
    private String comment;

    public RoleInfo() {
    }

    public RoleInfo(
           String name,
           boolean systemRole,
           boolean allPermissions,
           String[] permissions,
           boolean allPolicies,
           String[] policyList,
           boolean allGroups,
           boolean ownGroup,
           String[] groupList,
           boolean allRoles,
           String[] roleList,
           boolean allSmartCredentialDefinitions,
           String[] smartCredentialDefinitionList,
           boolean allSmartCredentialPrintModules,
           String[] smartCredentialPrintModuleList,
           boolean skipSecondAuth,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.systemRole = systemRole;
           this.allPermissions = allPermissions;
           this.permissions = permissions;
           this.allPolicies = allPolicies;
           this.policyList = policyList;
           this.allGroups = allGroups;
           this.ownGroup = ownGroup;
           this.groupList = groupList;
           this.allRoles = allRoles;
           this.roleList = roleList;
           this.allSmartCredentialDefinitions = allSmartCredentialDefinitions;
           this.smartCredentialDefinitionList = smartCredentialDefinitionList;
           this.allSmartCredentialPrintModules = allSmartCredentialPrintModules;
           this.smartCredentialPrintModuleList = smartCredentialPrintModuleList;
           this.skipSecondAuth = skipSecondAuth;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this RoleInfo.
     * 
     * @return name   * The name of the role.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this RoleInfo.
     * 
     * @param name   * The name of the role.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the systemRole value for this RoleInfo.
     * 
     * @return systemRole   * Flag indicating if this role is a built-in
     *                                 system role, or one that was created
     * after the
     *                                 system was installed. The built-in
     * system roles
     *                                 cannot be modified with roleSet, nor
     * can they
     *                                 be deleted with roleDelete.
     */
    public boolean isSystemRole() {
        return systemRole;
    }


    /**
     * Sets the systemRole value for this RoleInfo.
     * 
     * @param systemRole   * Flag indicating if this role is a built-in
     *                                 system role, or one that was created
     * after the
     *                                 system was installed. The built-in
     * system roles
     *                                 cannot be modified with roleSet, nor
     * can they
     *                                 be deleted with roleDelete.
     */
    public void setSystemRole(boolean systemRole) {
        this.systemRole = systemRole;
    }


    /**
     * Gets the allPermissions value for this RoleInfo.
     * 
     * @return allPermissions   * If true, it means this role grants all permissions.
     */
    public boolean isAllPermissions() {
        return allPermissions;
    }


    /**
     * Sets the allPermissions value for this RoleInfo.
     * 
     * @param allPermissions   * If true, it means this role grants all permissions.
     */
    public void setAllPermissions(boolean allPermissions) {
        this.allPermissions = allPermissions;
    }


    /**
     * Gets the permissions value for this RoleInfo.
     * 
     * @return permissions   * The list of the names of the permissions granted
     *                                 by the role. Any permission not included
     * in
     *                                 this list is not allowed for the role.
     * If allPermissions is true, this list will be
     *                                 nil.
     */
    public String[] getPermissions() {
        return permissions;
    }


    /**
     * Sets the permissions value for this RoleInfo.
     * 
     * @param permissions   * The list of the names of the permissions granted
     *                                 by the role. Any permission not included
     * in
     *                                 this list is not allowed for the role.
     * If allPermissions is true, this list will be
     *                                 nil.
     */
    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }


    /**
     * Gets the allPolicies value for this RoleInfo.
     * 
     * @return allPolicies   * If true, it means this role grants access to
     *                                 all policies.
     */
    public boolean isAllPolicies() {
        return allPolicies;
    }


    /**
     * Sets the allPolicies value for this RoleInfo.
     * 
     * @param allPolicies   * If true, it means this role grants access to
     *                                 all policies.
     */
    public void setAllPolicies(boolean allPolicies) {
        this.allPolicies = allPolicies;
    }


    /**
     * Gets the policyList value for this RoleInfo.
     * 
     * @return policyList   * The list of the names of policies that this role
     *                                 grants access to. If allPolicies is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all policies in the system.
     */
    public String[] getPolicyList() {
        return policyList;
    }


    /**
     * Sets the policyList value for this RoleInfo.
     * 
     * @param policyList   * The list of the names of policies that this role
     *                                 grants access to. If allPolicies is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all policies in the system.
     */
    public void setPolicyList(String[] policyList) {
        this.policyList = policyList;
    }


    /**
     * Gets the allGroups value for this RoleInfo.
     * 
     * @return allGroups   * If true, it means this role grants access to
     *                                 all groups.
     */
    public boolean isAllGroups() {
        return allGroups;
    }


    /**
     * Sets the allGroups value for this RoleInfo.
     * 
     * @param allGroups   * If true, it means this role grants access to
     *                                 all groups.
     */
    public void setAllGroups(boolean allGroups) {
        this.allGroups = allGroups;
    }


    /**
     * Gets the ownGroup value for this RoleInfo.
     * 
     * @return ownGroup   * If true, when assigned to an administrator,
     *                                 this role grants access to users who
     * belong to
     *                                 the same group as the administrator.
     * At most one
     *                                 of allGroups and ownGroup can be true.
     */
    public boolean isOwnGroup() {
        return ownGroup;
    }


    /**
     * Sets the ownGroup value for this RoleInfo.
     * 
     * @param ownGroup   * If true, when assigned to an administrator,
     *                                 this role grants access to users who
     * belong to
     *                                 the same group as the administrator.
     * At most one
     *                                 of allGroups and ownGroup can be true.
     */
    public void setOwnGroup(boolean ownGroup) {
        this.ownGroup = ownGroup;
    }


    /**
     * Gets the groupList value for this RoleInfo.
     * 
     * @return groupList   * The list of the names of the groups that this role grants access
     * to. If allGroups is true, this list will be filled
     *                                 in with the names of all groups in
     * the system.
     *                                 If ownGroup is true, this list will
     * have a single
     *                                 entry which is the name of the caller's
     * group.
     *                                 In general, the allGroups and ownGroup
     * flags
     *                                 should be checked before this list.
     */
    public String[] getGroupList() {
        return groupList;
    }


    /**
     * Sets the groupList value for this RoleInfo.
     * 
     * @param groupList   * The list of the names of the groups that this role grants access
     * to. If allGroups is true, this list will be filled
     *                                 in with the names of all groups in
     * the system.
     *                                 If ownGroup is true, this list will
     * have a single
     *                                 entry which is the name of the caller's
     * group.
     *                                 In general, the allGroups and ownGroup
     * flags
     *                                 should be checked before this list.
     */
    public void setGroupList(String[] groupList) {
        this.groupList = groupList;
    }


    /**
     * Gets the allRoles value for this RoleInfo.
     * 
     * @return allRoles   * If true, it means this role grants access to
     *                                 all roles.
     */
    public boolean isAllRoles() {
        return allRoles;
    }


    /**
     * Sets the allRoles value for this RoleInfo.
     * 
     * @param allRoles   * If true, it means this role grants access to
     *                                 all roles.
     */
    public void setAllRoles(boolean allRoles) {
        this.allRoles = allRoles;
    }


    /**
     * Gets the roleList value for this RoleInfo.
     * 
     * @return roleList   * The list of the names of the roles that this role grants access
     * to. If allRoles is true, this list will be filled
     *                                 in with the names of all roles in
     * the system.
     *                                 In general, the allRoles flag
     *                                 should be checked before this list.
     */
    public String[] getRoleList() {
        return roleList;
    }


    /**
     * Sets the roleList value for this RoleInfo.
     * 
     * @param roleList   * The list of the names of the roles that this role grants access
     * to. If allRoles is true, this list will be filled
     *                                 in with the names of all roles in
     * the system.
     *                                 In general, the allRoles flag
     *                                 should be checked before this list.
     */
    public void setRoleList(String[] roleList) {
        this.roleList = roleList;
    }


    /**
     * Gets the allSmartCredentialDefinitions value for this RoleInfo.
     * 
     * @return allSmartCredentialDefinitions   * If true, it means this role grants access to
     *                                 all Smart Credential Definitions.
     */
    public boolean isAllSmartCredentialDefinitions() {
        return allSmartCredentialDefinitions;
    }


    /**
     * Sets the allSmartCredentialDefinitions value for this RoleInfo.
     * 
     * @param allSmartCredentialDefinitions   * If true, it means this role grants access to
     *                                 all Smart Credential Definitions.
     */
    public void setAllSmartCredentialDefinitions(boolean allSmartCredentialDefinitions) {
        this.allSmartCredentialDefinitions = allSmartCredentialDefinitions;
    }


    /**
     * Gets the smartCredentialDefinitionList value for this RoleInfo.
     * 
     * @return smartCredentialDefinitionList   * The list of the names of Smart Credential Definitions that
     *                                 this role grants access to. If
     *                                 allSmartCredentialDefinitions is true,
     * this list will be filled in with the names of
     *                                 all Smart Credential Definitions in
     * the system.
     */
    public String[] getSmartCredentialDefinitionList() {
        return smartCredentialDefinitionList;
    }


    /**
     * Sets the smartCredentialDefinitionList value for this RoleInfo.
     * 
     * @param smartCredentialDefinitionList   * The list of the names of Smart Credential Definitions that
     *                                 this role grants access to. If
     *                                 allSmartCredentialDefinitions is true,
     * this list will be filled in with the names of
     *                                 all Smart Credential Definitions in
     * the system.
     */
    public void setSmartCredentialDefinitionList(String[] smartCredentialDefinitionList) {
        this.smartCredentialDefinitionList = smartCredentialDefinitionList;
    }


    /**
     * Gets the allSmartCredentialPrintModules value for this RoleInfo.
     * 
     * @return allSmartCredentialPrintModules   * If true, it means this role grants access to
     *                                 all Smart Credential Print Modules.
     */
    public boolean isAllSmartCredentialPrintModules() {
        return allSmartCredentialPrintModules;
    }


    /**
     * Sets the allSmartCredentialPrintModules value for this RoleInfo.
     * 
     * @param allSmartCredentialPrintModules   * If true, it means this role grants access to
     *                                 all Smart Credential Print Modules.
     */
    public void setAllSmartCredentialPrintModules(boolean allSmartCredentialPrintModules) {
        this.allSmartCredentialPrintModules = allSmartCredentialPrintModules;
    }


    /**
     * Gets the smartCredentialPrintModuleList value for this RoleInfo.
     * 
     * @return smartCredentialPrintModuleList   * The list of the names of Smart Credential Print Modules that
     * this role grants access to. If
     *                                 allSmartCredentialPrintModules is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all Smart Credential Print Modules
     * in the system.
     */
    public String[] getSmartCredentialPrintModuleList() {
        return smartCredentialPrintModuleList;
    }


    /**
     * Sets the smartCredentialPrintModuleList value for this RoleInfo.
     * 
     * @param smartCredentialPrintModuleList   * The list of the names of Smart Credential Print Modules that
     * this role grants access to. If
     *                                 allSmartCredentialPrintModules is
     * true,
     *                                 this list will be filled in with the
     * names of
     *                                 all Smart Credential Print Modules
     * in the system.
     */
    public void setSmartCredentialPrintModuleList(String[] smartCredentialPrintModuleList) {
        this.smartCredentialPrintModuleList = smartCredentialPrintModuleList;
    }


    /**
     * Gets the skipSecondAuth value for this RoleInfo.
     * 
     * @return skipSecondAuth   * If the skipSecondAuth flag is set to true
     *                                 for a role, administrators in this
     * role
     *                                 will skip second factor authentication
     * when
     *                                 logging into the Entrust IdentityGuard
     * Administration Interface or Service even
     *                                 when policy dictates that second factor
     * authentication is required.
     *                                 This flag should be set to true for
     * administration identities that require
     *                                 unattended login such as those used
     * for
     *                                 services.
     */
    public boolean isSkipSecondAuth() {
        return skipSecondAuth;
    }


    /**
     * Sets the skipSecondAuth value for this RoleInfo.
     * 
     * @param skipSecondAuth   * If the skipSecondAuth flag is set to true
     *                                 for a role, administrators in this
     * role
     *                                 will skip second factor authentication
     * when
     *                                 logging into the Entrust IdentityGuard
     * Administration Interface or Service even
     *                                 when policy dictates that second factor
     * authentication is required.
     *                                 This flag should be set to true for
     * administration identities that require
     *                                 unattended login such as those used
     * for
     *                                 services.
     */
    public void setSkipSecondAuth(boolean skipSecondAuth) {
        this.skipSecondAuth = skipSecondAuth;
    }


    /**
     * Gets the rolesGrantingAccess value for this RoleInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this RoleInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this RoleInfo.
     * 
     * @return comment   * Descriptive comments about this role.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this RoleInfo.
     * 
     * @param comment   * Descriptive comments about this role.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof RoleInfo)) return false;
        RoleInfo other = (RoleInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            this.systemRole == other.isSystemRole() &&
            this.allPermissions == other.isAllPermissions() &&
            ((this.permissions==null && other.getPermissions()==null) || 
             (this.permissions!=null &&
              java.util.Arrays.equals(this.permissions, other.getPermissions()))) &&
            this.allPolicies == other.isAllPolicies() &&
            ((this.policyList==null && other.getPolicyList()==null) || 
             (this.policyList!=null &&
              java.util.Arrays.equals(this.policyList, other.getPolicyList()))) &&
            this.allGroups == other.isAllGroups() &&
            this.ownGroup == other.isOwnGroup() &&
            ((this.groupList==null && other.getGroupList()==null) || 
             (this.groupList!=null &&
              java.util.Arrays.equals(this.groupList, other.getGroupList()))) &&
            this.allRoles == other.isAllRoles() &&
            ((this.roleList==null && other.getRoleList()==null) || 
             (this.roleList!=null &&
              java.util.Arrays.equals(this.roleList, other.getRoleList()))) &&
            this.allSmartCredentialDefinitions == other.isAllSmartCredentialDefinitions() &&
            ((this.smartCredentialDefinitionList==null && other.getSmartCredentialDefinitionList()==null) || 
             (this.smartCredentialDefinitionList!=null &&
              java.util.Arrays.equals(this.smartCredentialDefinitionList, other.getSmartCredentialDefinitionList()))) &&
            this.allSmartCredentialPrintModules == other.isAllSmartCredentialPrintModules() &&
            ((this.smartCredentialPrintModuleList==null && other.getSmartCredentialPrintModuleList()==null) || 
             (this.smartCredentialPrintModuleList!=null &&
              java.util.Arrays.equals(this.smartCredentialPrintModuleList, other.getSmartCredentialPrintModuleList()))) &&
            this.skipSecondAuth == other.isSkipSecondAuth() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        _hashCode += (isSystemRole() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllPermissions() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getPermissions() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getPermissions());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getPermissions(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllPolicies() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getPolicyList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getPolicyList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getPolicyList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllGroups() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isOwnGroup() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getGroupList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getGroupList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getGroupList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllRoles() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getRoleList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRoleList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRoleList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllSmartCredentialDefinitions() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getSmartCredentialDefinitionList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialDefinitionList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialDefinitionList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllSmartCredentialPrintModules() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getSmartCredentialPrintModuleList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentialPrintModuleList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentialPrintModuleList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isSkipSecondAuth() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(RoleInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RoleInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("systemRole");
        elemField.setXmlName(new javax.xml.namespace.QName("", "systemRole"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allPermissions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allPermissions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("permissions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "permissions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allPolicies");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allPolicies"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("policyList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "policyList"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allGroups");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allGroups"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("ownGroup");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ownGroup"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("groupList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "groupList"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allRoles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allRoles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("roleList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "roleList"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialDefinitionList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialDefinitionList"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allSmartCredentialPrintModules");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allSmartCredentialPrintModules"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialPrintModuleList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialPrintModuleList"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("skipSecondAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SkipSecondAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
