/**
 * PolicyInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines basic information about a policy.
 */
public class PolicyInfo  implements java.io.Serializable {
    /* The name of the policy. */
    private String name;

    /* If true, it means this policy is the default,
     *                                 and is used in situations where no
     * policy is
     *                                 specified but a policy is required,
     * such as
     *                                 during group creation. If false, this
     * is not
     *                                 the default policy. */
    private boolean defaultPolicy;

    /* The user specification for this policy. */
    private UserSpecInfo userSpec;

    /* The card specification for this policy. */
    private CardSpecInfo cardSpec;

    /* The PIN specification for this policy. */
    private PINSpecInfo pinSpec;

    /* The default password rules for this policy. */
    private PasswordRulesInfo passwordRules;

    /* The list of named password rules for this
     *                                 policy. */
    private PasswordRulesInfo[] namedPasswordRules;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments about this policy, that could
     *                                 be used to provide a full description
     * of this
     *                                 policy's intended purpose. */
    private String comment;

    public PolicyInfo() {
    }

    public PolicyInfo(
           String name,
           boolean defaultPolicy,
           UserSpecInfo userSpec,
           CardSpecInfo cardSpec,
           PINSpecInfo pinSpec,
           PasswordRulesInfo passwordRules,
           PasswordRulesInfo[] namedPasswordRules,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.defaultPolicy = defaultPolicy;
           this.userSpec = userSpec;
           this.cardSpec = cardSpec;
           this.pinSpec = pinSpec;
           this.passwordRules = passwordRules;
           this.namedPasswordRules = namedPasswordRules;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this PolicyInfo.
     * 
     * @return name   * The name of the policy.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this PolicyInfo.
     * 
     * @param name   * The name of the policy.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the defaultPolicy value for this PolicyInfo.
     * 
     * @return defaultPolicy   * If true, it means this policy is the default,
     *                                 and is used in situations where no
     * policy is
     *                                 specified but a policy is required,
     * such as
     *                                 during group creation. If false, this
     * is not
     *                                 the default policy.
     */
    public boolean isDefaultPolicy() {
        return defaultPolicy;
    }


    /**
     * Sets the defaultPolicy value for this PolicyInfo.
     * 
     * @param defaultPolicy   * If true, it means this policy is the default,
     *                                 and is used in situations where no
     * policy is
     *                                 specified but a policy is required,
     * such as
     *                                 during group creation. If false, this
     * is not
     *                                 the default policy.
     */
    public void setDefaultPolicy(boolean defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }


    /**
     * Gets the userSpec value for this PolicyInfo.
     * 
     * @return userSpec   * The user specification for this policy.
     */
    public UserSpecInfo getUserSpec() {
        return userSpec;
    }


    /**
     * Sets the userSpec value for this PolicyInfo.
     * 
     * @param userSpec   * The user specification for this policy.
     */
    public void setUserSpec(UserSpecInfo userSpec) {
        this.userSpec = userSpec;
    }


    /**
     * Gets the cardSpec value for this PolicyInfo.
     * 
     * @return cardSpec   * The card specification for this policy.
     */
    public CardSpecInfo getCardSpec() {
        return cardSpec;
    }


    /**
     * Sets the cardSpec value for this PolicyInfo.
     * 
     * @param cardSpec   * The card specification for this policy.
     */
    public void setCardSpec(CardSpecInfo cardSpec) {
        this.cardSpec = cardSpec;
    }


    /**
     * Gets the pinSpec value for this PolicyInfo.
     * 
     * @return pinSpec   * The PIN specification for this policy.
     */
    public PINSpecInfo getPinSpec() {
        return pinSpec;
    }


    /**
     * Sets the pinSpec value for this PolicyInfo.
     * 
     * @param pinSpec   * The PIN specification for this policy.
     */
    public void setPinSpec(PINSpecInfo pinSpec) {
        this.pinSpec = pinSpec;
    }


    /**
     * Gets the passwordRules value for this PolicyInfo.
     * 
     * @return passwordRules   * The default password rules for this policy.
     */
    public PasswordRulesInfo getPasswordRules() {
        return passwordRules;
    }


    /**
     * Sets the passwordRules value for this PolicyInfo.
     * 
     * @param passwordRules   * The default password rules for this policy.
     */
    public void setPasswordRules(PasswordRulesInfo passwordRules) {
        this.passwordRules = passwordRules;
    }


    /**
     * Gets the namedPasswordRules value for this PolicyInfo.
     * 
     * @return namedPasswordRules   * The list of named password rules for this
     *                                 policy.
     */
    public PasswordRulesInfo[] getNamedPasswordRules() {
        return namedPasswordRules;
    }


    /**
     * Sets the namedPasswordRules value for this PolicyInfo.
     * 
     * @param namedPasswordRules   * The list of named password rules for this
     *                                 policy.
     */
    public void setNamedPasswordRules(PasswordRulesInfo[] namedPasswordRules) {
        this.namedPasswordRules = namedPasswordRules;
    }


    /**
     * Gets the rolesGrantingAccess value for this PolicyInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this PolicyInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this PolicyInfo.
     * 
     * @return comment   * Descriptive comments about this policy, that could
     *                                 be used to provide a full description
     * of this
     *                                 policy's intended purpose.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this PolicyInfo.
     * 
     * @param comment   * Descriptive comments about this policy, that could
     *                                 be used to provide a full description
     * of this
     *                                 policy's intended purpose.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof PolicyInfo)) return false;
        PolicyInfo other = (PolicyInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            this.defaultPolicy == other.isDefaultPolicy() &&
            ((this.userSpec==null && other.getUserSpec()==null) || 
             (this.userSpec!=null &&
              this.userSpec.equals(other.getUserSpec()))) &&
            ((this.cardSpec==null && other.getCardSpec()==null) || 
             (this.cardSpec!=null &&
              this.cardSpec.equals(other.getCardSpec()))) &&
            ((this.pinSpec==null && other.getPinSpec()==null) || 
             (this.pinSpec!=null &&
              this.pinSpec.equals(other.getPinSpec()))) &&
            ((this.passwordRules==null && other.getPasswordRules()==null) || 
             (this.passwordRules!=null &&
              this.passwordRules.equals(other.getPasswordRules()))) &&
            ((this.namedPasswordRules==null && other.getNamedPasswordRules()==null) || 
             (this.namedPasswordRules!=null &&
              java.util.Arrays.equals(this.namedPasswordRules, other.getNamedPasswordRules()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        _hashCode += (isDefaultPolicy() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getUserSpec() != null) {
            _hashCode += getUserSpec().hashCode();
        }
        if (getCardSpec() != null) {
            _hashCode += getCardSpec().hashCode();
        }
        if (getPinSpec() != null) {
            _hashCode += getPinSpec().hashCode();
        }
        if (getPasswordRules() != null) {
            _hashCode += getPasswordRules().hashCode();
        }
        if (getNamedPasswordRules() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getNamedPasswordRules());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getNamedPasswordRules(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PolicyInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PolicyInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("defaultPolicy");
        elemField.setXmlName(new javax.xml.namespace.QName("", "defaultPolicy"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userSpec");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userSpec"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSpecInfo"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cardSpec");
        elemField.setXmlName(new javax.xml.namespace.QName("", "cardSpec"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CardSpecInfo"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pinSpec");
        elemField.setXmlName(new javax.xml.namespace.QName("", "pinSpec"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PINSpecInfo"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordRules");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordRules"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordRulesInfo"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("namedPasswordRules");
        elemField.setXmlName(new javax.xml.namespace.QName("", "namedPasswordRules"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordRulesInfo"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
