/**
 * PasswordRulesParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Parameters used to modify a password policy.
 */
public class PasswordRulesParms  implements java.io.Serializable {
    /* The name of a password.  This attribute is
     *                             required when creating or modifying a
     * named
     *                             password and is ignored for the default
     * password. */
    private String passwordName;

    /* The minimum length of a password. */
    private Integer minLength;

    /* The lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has an infinite
     * lifetime. */
    private Integer lifetime;

    /* The minimum lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has no minimum
     * lifetime. */
    private Integer minLifetime;

    /* The number of old passwords kept in history to
     *                             prevent duplicates. This value must be
     * at least 1. */
    private Integer history;

    /* If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history. */
    private Boolean unique;

    /* The time in minutes before a logged in but idle
     *                             administration service session requires
     * relogin.
     *                             A value of 0 means a logged in session
     * will
     *                             not be timed out by this value.
     *                             This attribute only applies to the default
     * password rules. */
    private Integer idleTimeout;

    /* The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules. */
    private Integer confirmationInterval;

    /* Specify whether an uppercase character is
     *                                required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType uppercase;

    /* Specify the number of uppercase characters
     *                                that are required in the password if
     * uppercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value. */
    private Integer uppercaseRequired;

    /* Specify whether a lowercase character is
     *                                required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType lowercase;

    /* Specify the number of lowercase characters
     *                                that are required in the password if
     * lowercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value. */
    private Integer lowercaseRequired;

    /* Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType number;

    /* Specify the number of numeric characters
     *                                that are required in the password if
     * numeric
     *                                characters are required.  Most be a
     * positive
     *                                integer value. */
    private Integer numberRequired;

    /* Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword. */
    private PasswordCharacterType special;

    /* Specify the number of special characters
     *                                that are required in the password if
     * special
     *                                characters are required.  Most be a
     * positive
     *                                integer value. */
    private Integer specialRequired;

    /* The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute only applies to the
     * default
     *                                 password rules. */
    private AuthenticationType firstAuth;

    /* If set to one of the values GRID, TOKENRO or TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login. No other authentication types
     * can be
     *                                 specified. This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute only applies to the
     * default
     *                                 password rules. */
    private AuthenticationType secondAuth;

    /* If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service. */
    private Boolean samlAuthAllowed;

    /* If true, an administrator is allowed to use 
     *                                 Smart Credentials to login to the
     * administration service. */
    private Boolean smartcredentialAuthAllowed;

    /* If true, an administrator is allowed to use header based
     *                                 authentication to login to the administration
     * service. */
    private Boolean headerAuthAllowed;

    /* Indicates how the password will be stored in the repository.
     * This value does not apply to how master user passwords
     *                             are stored. */
    private PasswordStorage storage;

    /* The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0. */
    private Integer maxRepeatedChars;

    /* The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0. */
    private Integer maxPasswordChangeTime;

    /* The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private Integer maxPasswordFailures;

    /* Optional descriptive comments. */
    private String comment;

    public PasswordRulesParms() {
    }

    public PasswordRulesParms(
           String passwordName,
           Integer minLength,
           Integer lifetime,
           Integer minLifetime,
           Integer history,
           Boolean unique,
           Integer idleTimeout,
           Integer confirmationInterval,
           PasswordCharacterType uppercase,
           Integer uppercaseRequired,
           PasswordCharacterType lowercase,
           Integer lowercaseRequired,
           PasswordCharacterType number,
           Integer numberRequired,
           PasswordCharacterType special,
           Integer specialRequired,
           AuthenticationType firstAuth,
           AuthenticationType secondAuth,
           Boolean samlAuthAllowed,
           Boolean smartcredentialAuthAllowed,
           Boolean headerAuthAllowed,
           PasswordStorage storage,
           Integer maxRepeatedChars,
           Integer maxPasswordChangeTime,
           Integer maxPasswordFailures,
           String comment) {
           this.passwordName = passwordName;
           this.minLength = minLength;
           this.lifetime = lifetime;
           this.minLifetime = minLifetime;
           this.history = history;
           this.unique = unique;
           this.idleTimeout = idleTimeout;
           this.confirmationInterval = confirmationInterval;
           this.uppercase = uppercase;
           this.uppercaseRequired = uppercaseRequired;
           this.lowercase = lowercase;
           this.lowercaseRequired = lowercaseRequired;
           this.number = number;
           this.numberRequired = numberRequired;
           this.special = special;
           this.specialRequired = specialRequired;
           this.firstAuth = firstAuth;
           this.secondAuth = secondAuth;
           this.samlAuthAllowed = samlAuthAllowed;
           this.smartcredentialAuthAllowed = smartcredentialAuthAllowed;
           this.headerAuthAllowed = headerAuthAllowed;
           this.storage = storage;
           this.maxRepeatedChars = maxRepeatedChars;
           this.maxPasswordChangeTime = maxPasswordChangeTime;
           this.maxPasswordFailures = maxPasswordFailures;
           this.comment = comment;
    }


    /**
     * Gets the passwordName value for this PasswordRulesParms.
     * 
     * @return passwordName   * The name of a password.  This attribute is
     *                             required when creating or modifying a
     * named
     *                             password and is ignored for the default
     * password.
     */
    public String getPasswordName() {
        return passwordName;
    }


    /**
     * Sets the passwordName value for this PasswordRulesParms.
     * 
     * @param passwordName   * The name of a password.  This attribute is
     *                             required when creating or modifying a
     * named
     *                             password and is ignored for the default
     * password.
     */
    public void setPasswordName(String passwordName) {
        this.passwordName = passwordName;
    }


    /**
     * Gets the minLength value for this PasswordRulesParms.
     * 
     * @return minLength   * The minimum length of a password.
     */
    public Integer getMinLength() {
        return minLength;
    }


    /**
     * Sets the minLength value for this PasswordRulesParms.
     * 
     * @param minLength   * The minimum length of a password.
     */
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }


    /**
     * Gets the lifetime value for this PasswordRulesParms.
     * 
     * @return lifetime   * The lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has an infinite
     * lifetime.
     */
    public Integer getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this PasswordRulesParms.
     * 
     * @param lifetime   * The lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has an infinite
     * lifetime.
     */
    public void setLifetime(Integer lifetime) {
        this.lifetime = lifetime;
    }


    /**
     * Gets the minLifetime value for this PasswordRulesParms.
     * 
     * @return minLifetime   * The minimum lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has no minimum
     * lifetime.
     */
    public Integer getMinLifetime() {
        return minLifetime;
    }


    /**
     * Sets the minLifetime value for this PasswordRulesParms.
     * 
     * @param minLifetime   * The minimum lifetime of a password in days. This must be a
     *                             value between 0 and 36500. A value
     *                             of 0 means the password has no minimum
     * lifetime.
     */
    public void setMinLifetime(Integer minLifetime) {
        this.minLifetime = minLifetime;
    }


    /**
     * Gets the history value for this PasswordRulesParms.
     * 
     * @return history   * The number of old passwords kept in history to
     *                             prevent duplicates. This value must be
     * at least 1.
     */
    public Integer getHistory() {
        return history;
    }


    /**
     * Sets the history value for this PasswordRulesParms.
     * 
     * @param history   * The number of old passwords kept in history to
     *                             prevent duplicates. This value must be
     * at least 1.
     */
    public void setHistory(Integer history) {
        this.history = history;
    }


    /**
     * Gets the unique value for this PasswordRulesParms.
     * 
     * @return unique   * If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history.
     */
    public Boolean getUnique() {
        return unique;
    }


    /**
     * Sets the unique value for this PasswordRulesParms.
     * 
     * @param unique   * If true, a new password value for this
     *                                 password must be unique with respect
     * to the
     *                                 current password values of all other
     * passwords for the user in addition to not
     *                                 matching any passwords in its history.
     */
    public void setUnique(Boolean unique) {
        this.unique = unique;
    }


    /**
     * Gets the idleTimeout value for this PasswordRulesParms.
     * 
     * @return idleTimeout   * The time in minutes before a logged in but idle
     *                             administration service session requires
     * relogin.
     *                             A value of 0 means a logged in session
     * will
     *                             not be timed out by this value.
     *                             This attribute only applies to the default
     * password rules.
     */
    public Integer getIdleTimeout() {
        return idleTimeout;
    }


    /**
     * Sets the idleTimeout value for this PasswordRulesParms.
     * 
     * @param idleTimeout   * The time in minutes before a logged in but idle
     *                             administration service session requires
     * relogin.
     *                             A value of 0 means a logged in session
     * will
     *                             not be timed out by this value.
     *                             This attribute only applies to the default
     * password rules.
     */
    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }


    /**
     * Gets the confirmationInterval value for this PasswordRulesParms.
     * 
     * @return confirmationInterval   * The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public Integer getConfirmationInterval() {
        return confirmationInterval;
    }


    /**
     * Sets the confirmationInterval value for this PasswordRulesParms.
     * 
     * @param confirmationInterval   * The interval in seconds that a logged in
     *                                 administration service session is
     * validated
     *                                 to ensure that the administrator is
     * still
     *                                 a valid administrator.  A negative
     * value
     *                                 indicates that the administrator is
     * only
     *                                 validated at login time.  A value
     * of 0
     *                                 that the administrator is validated
     * during
     *                                 each request.
     *                                 This value will not be set for named
     * password
     *                                 rules.
     */
    public void setConfirmationInterval(Integer confirmationInterval) {
        this.confirmationInterval = confirmationInterval;
    }


    /**
     * Gets the uppercase value for this PasswordRulesParms.
     * 
     * @return uppercase   * Specify whether an uppercase character is
     *                                required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getUppercase() {
        return uppercase;
    }


    /**
     * Sets the uppercase value for this PasswordRulesParms.
     * 
     * @param uppercase   * Specify whether an uppercase character is
     *                                required, allowed or not allowed in
     * the pasword.
     */
    public void setUppercase(PasswordCharacterType uppercase) {
        this.uppercase = uppercase;
    }


    /**
     * Gets the uppercaseRequired value for this PasswordRulesParms.
     * 
     * @return uppercaseRequired   * Specify the number of uppercase characters
     *                                that are required in the password if
     * uppercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public Integer getUppercaseRequired() {
        return uppercaseRequired;
    }


    /**
     * Sets the uppercaseRequired value for this PasswordRulesParms.
     * 
     * @param uppercaseRequired   * Specify the number of uppercase characters
     *                                that are required in the password if
     * uppercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public void setUppercaseRequired(Integer uppercaseRequired) {
        this.uppercaseRequired = uppercaseRequired;
    }


    /**
     * Gets the lowercase value for this PasswordRulesParms.
     * 
     * @return lowercase   * Specify whether a lowercase character is
     *                                required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getLowercase() {
        return lowercase;
    }


    /**
     * Sets the lowercase value for this PasswordRulesParms.
     * 
     * @param lowercase   * Specify whether a lowercase character is
     *                                required, allowed or not allowed in
     * the pasword.
     */
    public void setLowercase(PasswordCharacterType lowercase) {
        this.lowercase = lowercase;
    }


    /**
     * Gets the lowercaseRequired value for this PasswordRulesParms.
     * 
     * @return lowercaseRequired   * Specify the number of lowercase characters
     *                                that are required in the password if
     * lowercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public Integer getLowercaseRequired() {
        return lowercaseRequired;
    }


    /**
     * Sets the lowercaseRequired value for this PasswordRulesParms.
     * 
     * @param lowercaseRequired   * Specify the number of lowercase characters
     *                                that are required in the password if
     * lowercase
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public void setLowercaseRequired(Integer lowercaseRequired) {
        this.lowercaseRequired = lowercaseRequired;
    }


    /**
     * Gets the number value for this PasswordRulesParms.
     * 
     * @return number   * Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getNumber() {
        return number;
    }


    /**
     * Sets the number value for this PasswordRulesParms.
     * 
     * @param number   * Specify whether a numeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setNumber(PasswordCharacterType number) {
        this.number = number;
    }


    /**
     * Gets the numberRequired value for this PasswordRulesParms.
     * 
     * @return numberRequired   * Specify the number of numeric characters
     *                                that are required in the password if
     * numeric
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public Integer getNumberRequired() {
        return numberRequired;
    }


    /**
     * Sets the numberRequired value for this PasswordRulesParms.
     * 
     * @param numberRequired   * Specify the number of numeric characters
     *                                that are required in the password if
     * numeric
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public void setNumberRequired(Integer numberRequired) {
        this.numberRequired = numberRequired;
    }


    /**
     * Gets the special value for this PasswordRulesParms.
     * 
     * @return special   * Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public PasswordCharacterType getSpecial() {
        return special;
    }


    /**
     * Sets the special value for this PasswordRulesParms.
     * 
     * @param special   * Specify whether a non-alphanumeric character is
     *                                 required, allowed or not allowed in
     * the pasword.
     */
    public void setSpecial(PasswordCharacterType special) {
        this.special = special;
    }


    /**
     * Gets the specialRequired value for this PasswordRulesParms.
     * 
     * @return specialRequired   * Specify the number of special characters
     *                                that are required in the password if
     * special
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public Integer getSpecialRequired() {
        return specialRequired;
    }


    /**
     * Sets the specialRequired value for this PasswordRulesParms.
     * 
     * @param specialRequired   * Specify the number of special characters
     *                                that are required in the password if
     * special
     *                                characters are required.  Most be a
     * positive
     *                                integer value.
     */
    public void setSpecialRequired(Integer specialRequired) {
        this.specialRequired = specialRequired;
    }


    /**
     * Gets the firstAuth value for this PasswordRulesParms.
     * 
     * @return firstAuth   * The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute only applies to the
     * default
     *                                 password rules.
     */
    public AuthenticationType getFirstAuth() {
        return firstAuth;
    }


    /**
     * Sets the firstAuth value for this PasswordRulesParms.
     * 
     * @param firstAuth   * The type of first-factor authentication
     *                                 used by an administrator to login
     * to the
     *                                 administration service.  Allowed values
     * are PASSWORD and EXTERNAL.
     *                                 This attribute only applies to the
     * default
     *                                 password rules.
     */
    public void setFirstAuth(AuthenticationType firstAuth) {
        this.firstAuth = firstAuth;
    }


    /**
     * Gets the secondAuth value for this PasswordRulesParms.
     * 
     * @return secondAuth   * If set to one of the values GRID, TOKENRO or TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login. No other authentication types
     * can be
     *                                 specified. This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute only applies to the
     * default
     *                                 password rules.
     */
    public AuthenticationType getSecondAuth() {
        return secondAuth;
    }


    /**
     * Sets the secondAuth value for this PasswordRulesParms.
     * 
     * @param secondAuth   * If set to one of the values GRID, TOKENRO or TOKENCR
     *                                 then an administrator will require
     * this type
     *                                 of second factor authentication to
     * login to the
     *                                 administration service.  If
     *                                 set to the value NONE, the administrator
     * will
     *                                 not require second factor authentication
     * to
     *                                 login. No other authentication types
     * can be
     *                                 specified. This value does not apply
     * to master
     *                                 user login attempts.
     *                                 This attribute only applies to the
     * default
     *                                 password rules.
     */
    public void setSecondAuth(AuthenticationType secondAuth) {
        this.secondAuth = secondAuth;
    }


    /**
     * Gets the samlAuthAllowed value for this PasswordRulesParms.
     * 
     * @return samlAuthAllowed   * If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service.
     */
    public Boolean getSamlAuthAllowed() {
        return samlAuthAllowed;
    }


    /**
     * Sets the samlAuthAllowed value for this PasswordRulesParms.
     * 
     * @param samlAuthAllowed   * If true, an administrator is allowed to use a SAML
     *                                 assertion to login to the administration
     * service.
     */
    public void setSamlAuthAllowed(Boolean samlAuthAllowed) {
        this.samlAuthAllowed = samlAuthAllowed;
    }


    /**
     * Gets the smartcredentialAuthAllowed value for this PasswordRulesParms.
     * 
     * @return smartcredentialAuthAllowed   * If true, an administrator is allowed to use 
     *                                 Smart Credentials to login to the
     * administration service.
     */
    public Boolean getSmartcredentialAuthAllowed() {
        return smartcredentialAuthAllowed;
    }


    /**
     * Sets the smartcredentialAuthAllowed value for this PasswordRulesParms.
     * 
     * @param smartcredentialAuthAllowed   * If true, an administrator is allowed to use 
     *                                 Smart Credentials to login to the
     * administration service.
     */
    public void setSmartcredentialAuthAllowed(Boolean smartcredentialAuthAllowed) {
        this.smartcredentialAuthAllowed = smartcredentialAuthAllowed;
    }


    /**
     * Gets the headerAuthAllowed value for this PasswordRulesParms.
     * 
     * @return headerAuthAllowed   * If true, an administrator is allowed to use header based
     *                                 authentication to login to the administration
     * service.
     */
    public Boolean getHeaderAuthAllowed() {
        return headerAuthAllowed;
    }


    /**
     * Sets the headerAuthAllowed value for this PasswordRulesParms.
     * 
     * @param headerAuthAllowed   * If true, an administrator is allowed to use header based
     *                                 authentication to login to the administration
     * service.
     */
    public void setHeaderAuthAllowed(Boolean headerAuthAllowed) {
        this.headerAuthAllowed = headerAuthAllowed;
    }


    /**
     * Gets the storage value for this PasswordRulesParms.
     * 
     * @return storage   * Indicates how the password will be stored in the repository.
     * This value does not apply to how master user passwords
     *                             are stored.
     */
    public PasswordStorage getStorage() {
        return storage;
    }


    /**
     * Sets the storage value for this PasswordRulesParms.
     * 
     * @param storage   * Indicates how the password will be stored in the repository.
     * This value does not apply to how master user passwords
     *                             are stored.
     */
    public void setStorage(PasswordStorage storage) {
        this.storage = storage;
    }


    /**
     * Gets the maxRepeatedChars value for this PasswordRulesParms.
     * 
     * @return maxRepeatedChars   * The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0.
     */
    public Integer getMaxRepeatedChars() {
        return maxRepeatedChars;
    }


    /**
     * Sets the maxRepeatedChars value for this PasswordRulesParms.
     * 
     * @param maxRepeatedChars   * The maximum number of times a character can
     *                                 be repeated consecutively in a password.
     * A value of 0 means there is no restriction.
     *                                 The default for a new policy is 0.
     */
    public void setMaxRepeatedChars(Integer maxRepeatedChars) {
        this.maxRepeatedChars = maxRepeatedChars;
    }


    /**
     * Gets the maxPasswordChangeTime value for this PasswordRulesParms.
     * 
     * @return maxPasswordChangeTime   * The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0.
     */
    public Integer getMaxPasswordChangeTime() {
        return maxPasswordChangeTime;
    }


    /**
     * Sets the maxPasswordChangeTime value for this PasswordRulesParms.
     * 
     * @param maxPasswordChangeTime   * The maximum time in hours in which a password
     *                                 which has been set to require change
     * must be
     *                                 changed.
     *                                 A value of 0 means there is no restriction.
     * The default for a new policy is 0.
     */
    public void setMaxPasswordChangeTime(Integer maxPasswordChangeTime) {
        this.maxPasswordChangeTime = maxPasswordChangeTime;
    }


    /**
     * Gets the maxPasswordFailures value for this PasswordRulesParms.
     * 
     * @return maxPasswordFailures   * The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public Integer getMaxPasswordFailures() {
        return maxPasswordFailures;
    }


    /**
     * Sets the maxPasswordFailures value for this PasswordRulesParms.
     * 
     * @param maxPasswordFailures   * The number of consecutive PASSWORD authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxPasswordFailures(Integer maxPasswordFailures) {
        this.maxPasswordFailures = maxPasswordFailures;
    }


    /**
     * Gets the comment value for this PasswordRulesParms.
     * 
     * @return comment   * Optional descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this PasswordRulesParms.
     * 
     * @param comment   * Optional descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof PasswordRulesParms)) return false;
        PasswordRulesParms other = (PasswordRulesParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.passwordName==null && other.getPasswordName()==null) || 
             (this.passwordName!=null &&
              this.passwordName.equals(other.getPasswordName()))) &&
            ((this.minLength==null && other.getMinLength()==null) || 
             (this.minLength!=null &&
              this.minLength.equals(other.getMinLength()))) &&
            ((this.lifetime==null && other.getLifetime()==null) || 
             (this.lifetime!=null &&
              this.lifetime.equals(other.getLifetime()))) &&
            ((this.minLifetime==null && other.getMinLifetime()==null) || 
             (this.minLifetime!=null &&
              this.minLifetime.equals(other.getMinLifetime()))) &&
            ((this.history==null && other.getHistory()==null) || 
             (this.history!=null &&
              this.history.equals(other.getHistory()))) &&
            ((this.unique==null && other.getUnique()==null) || 
             (this.unique!=null &&
              this.unique.equals(other.getUnique()))) &&
            ((this.idleTimeout==null && other.getIdleTimeout()==null) || 
             (this.idleTimeout!=null &&
              this.idleTimeout.equals(other.getIdleTimeout()))) &&
            ((this.confirmationInterval==null && other.getConfirmationInterval()==null) || 
             (this.confirmationInterval!=null &&
              this.confirmationInterval.equals(other.getConfirmationInterval()))) &&
            ((this.uppercase==null && other.getUppercase()==null) || 
             (this.uppercase!=null &&
              this.uppercase.equals(other.getUppercase()))) &&
            ((this.uppercaseRequired==null && other.getUppercaseRequired()==null) || 
             (this.uppercaseRequired!=null &&
              this.uppercaseRequired.equals(other.getUppercaseRequired()))) &&
            ((this.lowercase==null && other.getLowercase()==null) || 
             (this.lowercase!=null &&
              this.lowercase.equals(other.getLowercase()))) &&
            ((this.lowercaseRequired==null && other.getLowercaseRequired()==null) || 
             (this.lowercaseRequired!=null &&
              this.lowercaseRequired.equals(other.getLowercaseRequired()))) &&
            ((this.number==null && other.getNumber()==null) || 
             (this.number!=null &&
              this.number.equals(other.getNumber()))) &&
            ((this.numberRequired==null && other.getNumberRequired()==null) || 
             (this.numberRequired!=null &&
              this.numberRequired.equals(other.getNumberRequired()))) &&
            ((this.special==null && other.getSpecial()==null) || 
             (this.special!=null &&
              this.special.equals(other.getSpecial()))) &&
            ((this.specialRequired==null && other.getSpecialRequired()==null) || 
             (this.specialRequired!=null &&
              this.specialRequired.equals(other.getSpecialRequired()))) &&
            ((this.firstAuth==null && other.getFirstAuth()==null) || 
             (this.firstAuth!=null &&
              this.firstAuth.equals(other.getFirstAuth()))) &&
            ((this.secondAuth==null && other.getSecondAuth()==null) || 
             (this.secondAuth!=null &&
              this.secondAuth.equals(other.getSecondAuth()))) &&
            ((this.samlAuthAllowed==null && other.getSamlAuthAllowed()==null) || 
             (this.samlAuthAllowed!=null &&
              this.samlAuthAllowed.equals(other.getSamlAuthAllowed()))) &&
            ((this.smartcredentialAuthAllowed==null && other.getSmartcredentialAuthAllowed()==null) || 
             (this.smartcredentialAuthAllowed!=null &&
              this.smartcredentialAuthAllowed.equals(other.getSmartcredentialAuthAllowed()))) &&
            ((this.headerAuthAllowed==null && other.getHeaderAuthAllowed()==null) || 
             (this.headerAuthAllowed!=null &&
              this.headerAuthAllowed.equals(other.getHeaderAuthAllowed()))) &&
            ((this.storage==null && other.getStorage()==null) || 
             (this.storage!=null &&
              this.storage.equals(other.getStorage()))) &&
            ((this.maxRepeatedChars==null && other.getMaxRepeatedChars()==null) || 
             (this.maxRepeatedChars!=null &&
              this.maxRepeatedChars.equals(other.getMaxRepeatedChars()))) &&
            ((this.maxPasswordChangeTime==null && other.getMaxPasswordChangeTime()==null) || 
             (this.maxPasswordChangeTime!=null &&
              this.maxPasswordChangeTime.equals(other.getMaxPasswordChangeTime()))) &&
            ((this.maxPasswordFailures==null && other.getMaxPasswordFailures()==null) || 
             (this.maxPasswordFailures!=null &&
              this.maxPasswordFailures.equals(other.getMaxPasswordFailures()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getPasswordName() != null) {
            _hashCode += getPasswordName().hashCode();
        }
        if (getMinLength() != null) {
            _hashCode += getMinLength().hashCode();
        }
        if (getLifetime() != null) {
            _hashCode += getLifetime().hashCode();
        }
        if (getMinLifetime() != null) {
            _hashCode += getMinLifetime().hashCode();
        }
        if (getHistory() != null) {
            _hashCode += getHistory().hashCode();
        }
        if (getUnique() != null) {
            _hashCode += getUnique().hashCode();
        }
        if (getIdleTimeout() != null) {
            _hashCode += getIdleTimeout().hashCode();
        }
        if (getConfirmationInterval() != null) {
            _hashCode += getConfirmationInterval().hashCode();
        }
        if (getUppercase() != null) {
            _hashCode += getUppercase().hashCode();
        }
        if (getUppercaseRequired() != null) {
            _hashCode += getUppercaseRequired().hashCode();
        }
        if (getLowercase() != null) {
            _hashCode += getLowercase().hashCode();
        }
        if (getLowercaseRequired() != null) {
            _hashCode += getLowercaseRequired().hashCode();
        }
        if (getNumber() != null) {
            _hashCode += getNumber().hashCode();
        }
        if (getNumberRequired() != null) {
            _hashCode += getNumberRequired().hashCode();
        }
        if (getSpecial() != null) {
            _hashCode += getSpecial().hashCode();
        }
        if (getSpecialRequired() != null) {
            _hashCode += getSpecialRequired().hashCode();
        }
        if (getFirstAuth() != null) {
            _hashCode += getFirstAuth().hashCode();
        }
        if (getSecondAuth() != null) {
            _hashCode += getSecondAuth().hashCode();
        }
        if (getSamlAuthAllowed() != null) {
            _hashCode += getSamlAuthAllowed().hashCode();
        }
        if (getSmartcredentialAuthAllowed() != null) {
            _hashCode += getSmartcredentialAuthAllowed().hashCode();
        }
        if (getHeaderAuthAllowed() != null) {
            _hashCode += getHeaderAuthAllowed().hashCode();
        }
        if (getStorage() != null) {
            _hashCode += getStorage().hashCode();
        }
        if (getMaxRepeatedChars() != null) {
            _hashCode += getMaxRepeatedChars().hashCode();
        }
        if (getMaxPasswordChangeTime() != null) {
            _hashCode += getMaxPasswordChangeTime().hashCode();
        }
        if (getMaxPasswordFailures() != null) {
            _hashCode += getMaxPasswordFailures().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(PasswordRulesParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordRulesParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("passwordName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "passwordName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("history");
        elemField.setXmlName(new javax.xml.namespace.QName("", "history"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unique");
        elemField.setXmlName(new javax.xml.namespace.QName("", "unique"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("idleTimeout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "idleTimeout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("confirmationInterval");
        elemField.setXmlName(new javax.xml.namespace.QName("", "confirmationInterval"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("uppercase");
        elemField.setXmlName(new javax.xml.namespace.QName("", "uppercase"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("uppercaseRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "uppercaseRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lowercase");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lowercase"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lowercaseRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lowercaseRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("number");
        elemField.setXmlName(new javax.xml.namespace.QName("", "number"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numberRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numberRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("special");
        elemField.setXmlName(new javax.xml.namespace.QName("", "special"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "PasswordCharacterType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("specialRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "specialRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("firstAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "firstAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("secondAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "secondAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("samlAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "samlAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartcredentialAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "smartcredentialAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("headerAuthAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "headerAuthAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("storage");
        elemField.setXmlName(new javax.xml.namespace.QName("", "storage"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PasswordStorage"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRepeatedChars");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRepeatedChars"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxPasswordChangeTime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxPasswordChangeTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxPasswordFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxPasswordFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
