/**
 * ManagedCaInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines information about a managed CA; can be either an Entrust
 * managed CA or a Microsoft 
 *                         managed CA.
 */
public class ManagedCaInfo  implements java.io.Serializable {
    /* A name for the managed CA (a friendly name, can be different
     * than the CA DN). */
    private String name;

    /* The host the CA is running on. */
    private String host;

    /* If set, the proxy used to communicate with the CA. */
    private String proxy;

    /* The host the Directory used by the CA is running on. */
    private String dirHost;

    /* The port of the LDAP service provided by the Directory. */
    private int dirLdapPort;

    /* If set, the PIV content signer. */
    private ContentSigner pivContentSigner;

    /* If set, the SCEP RA. */
    private com.good.adapters.entrust.stubs.ManagedCaCredentialConfig scepRa;

    /* A flag indicating of the CA should publish
     *                                 CRLs after IdentityGuard revokes certificates. */
    private boolean publishCRLAfterRevocation;

    /* This attribute specifies the revocation cache
     *                                 timeout in minutes.  A value of 0
     * means
     *                                 revocation information is not cached. */
    private int revocationCacheTimeout;

    /* This optional value defines a URL that
     *                                 is called when a certificate is issued. */
    private String certificateIssuanceCallback;

    /* Indicates the type of managed CA. If the type is ENTRUST, then
     * the EntrustSpecificInfo
     *                                 component will be non-null; if the
     * type is MICROSOFT, then the MicrosoftSpecificInfo
     *                                 component will be non-null. */
    private ManagedCaType type;

    /* If set, indicates that this information is for an Entrust CA
     * and contains the Entrust
     *                                 specific information. */
    private com.good.adapters.entrust.stubs.ManagedCaEntrustSpecificInfo entrustSpecificInfo;

    /* If set, indicates that this information is for a Microsoft
     * CA and contains the 
     *                                 Microsoft specific information. */
    private com.good.adapters.entrust.stubs.ManagedCaMicrosoftSpecificInfo microsoftSpecificInfo;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    public ManagedCaInfo() {
    }

    public ManagedCaInfo(
           String name,
           String host,
           String proxy,
           String dirHost,
           int dirLdapPort,
           ContentSigner pivContentSigner,
           com.good.adapters.entrust.stubs.ManagedCaCredentialConfig scepRa,
           boolean publishCRLAfterRevocation,
           int revocationCacheTimeout,
           String certificateIssuanceCallback,
           ManagedCaType type,
           com.good.adapters.entrust.stubs.ManagedCaEntrustSpecificInfo entrustSpecificInfo,
           com.good.adapters.entrust.stubs.ManagedCaMicrosoftSpecificInfo microsoftSpecificInfo,
           String[] rolesGrantingAccess) {
           this.name = name;
           this.host = host;
           this.proxy = proxy;
           this.dirHost = dirHost;
           this.dirLdapPort = dirLdapPort;
           this.pivContentSigner = pivContentSigner;
           this.scepRa = scepRa;
           this.publishCRLAfterRevocation = publishCRLAfterRevocation;
           this.revocationCacheTimeout = revocationCacheTimeout;
           this.certificateIssuanceCallback = certificateIssuanceCallback;
           this.type = type;
           this.entrustSpecificInfo = entrustSpecificInfo;
           this.microsoftSpecificInfo = microsoftSpecificInfo;
           this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the name value for this ManagedCaInfo.
     * 
     * @return name   * A name for the managed CA (a friendly name, can be different
     * than the CA DN).
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this ManagedCaInfo.
     * 
     * @param name   * A name for the managed CA (a friendly name, can be different
     * than the CA DN).
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the host value for this ManagedCaInfo.
     * 
     * @return host   * The host the CA is running on.
     */
    public String getHost() {
        return host;
    }


    /**
     * Sets the host value for this ManagedCaInfo.
     * 
     * @param host   * The host the CA is running on.
     */
    public void setHost(String host) {
        this.host = host;
    }


    /**
     * Gets the proxy value for this ManagedCaInfo.
     * 
     * @return proxy   * If set, the proxy used to communicate with the CA.
     */
    public String getProxy() {
        return proxy;
    }


    /**
     * Sets the proxy value for this ManagedCaInfo.
     * 
     * @param proxy   * If set, the proxy used to communicate with the CA.
     */
    public void setProxy(String proxy) {
        this.proxy = proxy;
    }


    /**
     * Gets the dirHost value for this ManagedCaInfo.
     * 
     * @return dirHost   * The host the Directory used by the CA is running on.
     */
    public String getDirHost() {
        return dirHost;
    }


    /**
     * Sets the dirHost value for this ManagedCaInfo.
     * 
     * @param dirHost   * The host the Directory used by the CA is running on.
     */
    public void setDirHost(String dirHost) {
        this.dirHost = dirHost;
    }


    /**
     * Gets the dirLdapPort value for this ManagedCaInfo.
     * 
     * @return dirLdapPort   * The port of the LDAP service provided by the Directory.
     */
    public int getDirLdapPort() {
        return dirLdapPort;
    }


    /**
     * Sets the dirLdapPort value for this ManagedCaInfo.
     * 
     * @param dirLdapPort   * The port of the LDAP service provided by the Directory.
     */
    public void setDirLdapPort(int dirLdapPort) {
        this.dirLdapPort = dirLdapPort;
    }


    /**
     * Gets the pivContentSigner value for this ManagedCaInfo.
     * 
     * @return pivContentSigner   * If set, the PIV content signer.
     */
    public ContentSigner getPivContentSigner() {
        return pivContentSigner;
    }


    /**
     * Sets the pivContentSigner value for this ManagedCaInfo.
     * 
     * @param pivContentSigner   * If set, the PIV content signer.
     */
    public void setPivContentSigner(ContentSigner pivContentSigner) {
        this.pivContentSigner = pivContentSigner;
    }


    /**
     * Gets the scepRa value for this ManagedCaInfo.
     * 
     * @return scepRa   * If set, the SCEP RA.
     */
    public com.good.adapters.entrust.stubs.ManagedCaCredentialConfig getScepRa() {
        return scepRa;
    }


    /**
     * Sets the scepRa value for this ManagedCaInfo.
     * 
     * @param scepRa   * If set, the SCEP RA.
     */
    public void setScepRa(com.good.adapters.entrust.stubs.ManagedCaCredentialConfig scepRa) {
        this.scepRa = scepRa;
    }


    /**
     * Gets the publishCRLAfterRevocation value for this ManagedCaInfo.
     * 
     * @return publishCRLAfterRevocation   * A flag indicating of the CA should publish
     *                                 CRLs after IdentityGuard revokes certificates.
     */
    public boolean isPublishCRLAfterRevocation() {
        return publishCRLAfterRevocation;
    }


    /**
     * Sets the publishCRLAfterRevocation value for this ManagedCaInfo.
     * 
     * @param publishCRLAfterRevocation   * A flag indicating of the CA should publish
     *                                 CRLs after IdentityGuard revokes certificates.
     */
    public void setPublishCRLAfterRevocation(boolean publishCRLAfterRevocation) {
        this.publishCRLAfterRevocation = publishCRLAfterRevocation;
    }


    /**
     * Gets the revocationCacheTimeout value for this ManagedCaInfo.
     * 
     * @return revocationCacheTimeout   * This attribute specifies the revocation cache
     *                                 timeout in minutes.  A value of 0
     * means
     *                                 revocation information is not cached.
     */
    public int getRevocationCacheTimeout() {
        return revocationCacheTimeout;
    }


    /**
     * Sets the revocationCacheTimeout value for this ManagedCaInfo.
     * 
     * @param revocationCacheTimeout   * This attribute specifies the revocation cache
     *                                 timeout in minutes.  A value of 0
     * means
     *                                 revocation information is not cached.
     */
    public void setRevocationCacheTimeout(int revocationCacheTimeout) {
        this.revocationCacheTimeout = revocationCacheTimeout;
    }


    /**
     * Gets the certificateIssuanceCallback value for this ManagedCaInfo.
     * 
     * @return certificateIssuanceCallback   * This optional value defines a URL that
     *                                 is called when a certificate is issued.
     */
    public String getCertificateIssuanceCallback() {
        return certificateIssuanceCallback;
    }


    /**
     * Sets the certificateIssuanceCallback value for this ManagedCaInfo.
     * 
     * @param certificateIssuanceCallback   * This optional value defines a URL that
     *                                 is called when a certificate is issued.
     */
    public void setCertificateIssuanceCallback(String certificateIssuanceCallback) {
        this.certificateIssuanceCallback = certificateIssuanceCallback;
    }


    /**
     * Gets the type value for this ManagedCaInfo.
     * 
     * @return type   * Indicates the type of managed CA. If the type is ENTRUST, then
     * the EntrustSpecificInfo
     *                                 component will be non-null; if the
     * type is MICROSOFT, then the MicrosoftSpecificInfo
     *                                 component will be non-null.
     */
    public ManagedCaType getType() {
        return type;
    }


    /**
     * Sets the type value for this ManagedCaInfo.
     * 
     * @param type   * Indicates the type of managed CA. If the type is ENTRUST, then
     * the EntrustSpecificInfo
     *                                 component will be non-null; if the
     * type is MICROSOFT, then the MicrosoftSpecificInfo
     *                                 component will be non-null.
     */
    public void setType(ManagedCaType type) {
        this.type = type;
    }


    /**
     * Gets the entrustSpecificInfo value for this ManagedCaInfo.
     * 
     * @return entrustSpecificInfo   * If set, indicates that this information is for an Entrust CA
     * and contains the Entrust
     *                                 specific information.
     */
    public com.good.adapters.entrust.stubs.ManagedCaEntrustSpecificInfo getEntrustSpecificInfo() {
        return entrustSpecificInfo;
    }


    /**
     * Sets the entrustSpecificInfo value for this ManagedCaInfo.
     * 
     * @param entrustSpecificInfo   * If set, indicates that this information is for an Entrust CA
     * and contains the Entrust
     *                                 specific information.
     */
    public void setEntrustSpecificInfo(com.good.adapters.entrust.stubs.ManagedCaEntrustSpecificInfo entrustSpecificInfo) {
        this.entrustSpecificInfo = entrustSpecificInfo;
    }


    /**
     * Gets the microsoftSpecificInfo value for this ManagedCaInfo.
     * 
     * @return microsoftSpecificInfo   * If set, indicates that this information is for a Microsoft
     * CA and contains the 
     *                                 Microsoft specific information.
     */
    public com.good.adapters.entrust.stubs.ManagedCaMicrosoftSpecificInfo getMicrosoftSpecificInfo() {
        return microsoftSpecificInfo;
    }


    /**
     * Sets the microsoftSpecificInfo value for this ManagedCaInfo.
     * 
     * @param microsoftSpecificInfo   * If set, indicates that this information is for a Microsoft
     * CA and contains the 
     *                                 Microsoft specific information.
     */
    public void setMicrosoftSpecificInfo(com.good.adapters.entrust.stubs.ManagedCaMicrosoftSpecificInfo microsoftSpecificInfo) {
        this.microsoftSpecificInfo = microsoftSpecificInfo;
    }


    /**
     * Gets the rolesGrantingAccess value for this ManagedCaInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this ManagedCaInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof ManagedCaInfo)) return false;
        ManagedCaInfo other = (ManagedCaInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.host==null && other.getHost()==null) || 
             (this.host!=null &&
              this.host.equals(other.getHost()))) &&
            ((this.proxy==null && other.getProxy()==null) || 
             (this.proxy!=null &&
              this.proxy.equals(other.getProxy()))) &&
            ((this.dirHost==null && other.getDirHost()==null) || 
             (this.dirHost!=null &&
              this.dirHost.equals(other.getDirHost()))) &&
            this.dirLdapPort == other.getDirLdapPort() &&
            ((this.pivContentSigner==null && other.getPivContentSigner()==null) || 
             (this.pivContentSigner!=null &&
              this.pivContentSigner.equals(other.getPivContentSigner()))) &&
            ((this.scepRa==null && other.getScepRa()==null) || 
             (this.scepRa!=null &&
              this.scepRa.equals(other.getScepRa()))) &&
            this.publishCRLAfterRevocation == other.isPublishCRLAfterRevocation() &&
            this.revocationCacheTimeout == other.getRevocationCacheTimeout() &&
            ((this.certificateIssuanceCallback==null && other.getCertificateIssuanceCallback()==null) || 
             (this.certificateIssuanceCallback!=null &&
              this.certificateIssuanceCallback.equals(other.getCertificateIssuanceCallback()))) &&
            ((this.type==null && other.getType()==null) || 
             (this.type!=null &&
              this.type.equals(other.getType()))) &&
            ((this.entrustSpecificInfo==null && other.getEntrustSpecificInfo()==null) || 
             (this.entrustSpecificInfo!=null &&
              this.entrustSpecificInfo.equals(other.getEntrustSpecificInfo()))) &&
            ((this.microsoftSpecificInfo==null && other.getMicrosoftSpecificInfo()==null) || 
             (this.microsoftSpecificInfo!=null &&
              this.microsoftSpecificInfo.equals(other.getMicrosoftSpecificInfo()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getHost() != null) {
            _hashCode += getHost().hashCode();
        }
        if (getProxy() != null) {
            _hashCode += getProxy().hashCode();
        }
        if (getDirHost() != null) {
            _hashCode += getDirHost().hashCode();
        }
        _hashCode += getDirLdapPort();
        if (getPivContentSigner() != null) {
            _hashCode += getPivContentSigner().hashCode();
        }
        if (getScepRa() != null) {
            _hashCode += getScepRa().hashCode();
        }
        _hashCode += (isPublishCRLAfterRevocation() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getRevocationCacheTimeout();
        if (getCertificateIssuanceCallback() != null) {
            _hashCode += getCertificateIssuanceCallback().hashCode();
        }
        if (getType() != null) {
            _hashCode += getType().hashCode();
        }
        if (getEntrustSpecificInfo() != null) {
            _hashCode += getEntrustSpecificInfo().hashCode();
        }
        if (getMicrosoftSpecificInfo() != null) {
            _hashCode += getMicrosoftSpecificInfo().hashCode();
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(ManagedCaInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("host");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Host"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("proxy");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Proxy"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dirHost");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DirHost"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dirLdapPort");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DirLdapPort"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("pivContentSigner");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PivContentSigner"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ContentSigner"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("scepRa");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ScepRa"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaCredentialConfig"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("publishCRLAfterRevocation");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PublishCRLAfterRevocation"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("revocationCacheTimeout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RevocationCacheTimeout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateIssuanceCallback");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateIssuanceCallback"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("type");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Type"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("entrustSpecificInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "EntrustSpecificInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaEntrustSpecificInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("microsoftSpecificInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MicrosoftSpecificInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ManagedCaMicrosoftSpecificInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
