/**
 * LicenseParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Parameters used to update the system license settings.
 */
public class LicenseParms  implements java.io.Serializable {
    /* The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system. */
    private String installKey;

    /* The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system. */
    private String activationKey;

    /* Flag that controls whether or not a full user
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate user count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum user
     * limit. */
    private boolean countUsers;

    /* If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within this percentage
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 900
     *                             users in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of users
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored. */
    private Integer countLimitPercent;

    /* If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within countLimit
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 950
     *                             users in the system, and this value is
     * set to 100,
     *                             a warning audit is written as the number
     * of users
     *                             is within 100 users of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored. */
    private Integer countLimit;

    /* If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written. */
    private Integer timeLimit;

    /* Flag that controls whether or not user counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of users in the system because the
     * countUsers
     *                                 flag was true.  If countUsers is true
     * and this
     *                                 flag is null or false, users in partitions
     * are counted,
     *                                 but any mismatches between the number
     * of users
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date. */
    private Boolean updatePartitions;

    public LicenseParms() {
    }

    public LicenseParms(
           String installKey,
           String activationKey,
           boolean countUsers,
           Integer countLimitPercent,
           Integer countLimit,
           Integer timeLimit,
           Boolean updatePartitions) {
           this.installKey = installKey;
           this.activationKey = activationKey;
           this.countUsers = countUsers;
           this.countLimitPercent = countLimitPercent;
           this.countLimit = countLimit;
           this.timeLimit = timeLimit;
           this.updatePartitions = updatePartitions;
    }


    /**
     * Gets the installKey value for this LicenseParms.
     * 
     * @return installKey   * The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system.
     */
    public String getInstallKey() {
        return installKey;
    }


    /**
     * Sets the installKey value for this LicenseParms.
     * 
     * @param installKey   * The installation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system.
     */
    public void setInstallKey(String installKey) {
        this.installKey = installKey;
    }


    /**
     * Gets the activationKey value for this LicenseParms.
     * 
     * @return activationKey   * The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system.
     */
    public String getActivationKey() {
        return activationKey;
    }


    /**
     * Sets the activationKey value for this LicenseParms.
     * 
     * @param activationKey   * The activation key, supplied by Entrust. This
     *                                 may be null during a call to licenseCheck,
     * where
     *                                 the countUsers flag is set to true.
     * In this 
     *                                 case, the licenseCheck call only performs
     * the
     *                                 count of users in the system.
     */
    public void setActivationKey(String activationKey) {
        this.activationKey = activationKey;
    }


    /**
     * Gets the countUsers value for this LicenseParms.
     * 
     * @return countUsers   * Flag that controls whether or not a full user
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate user count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum user
     * limit.
     */
    public boolean isCountUsers() {
        return countUsers;
    }


    /**
     * Sets the countUsers value for this LicenseParms.
     * 
     * @param countUsers   * Flag that controls whether or not a full user
     *                                 count is performed before updating
     * the license.
     *                                 This is used to make sure the system
     * has an
     *                                 accurate user count, but can be slow
     * as it
     *                                 requires scanning every user entry
     * in the
     *                                 repository. If this value is set to
     * true,
     *                                 make sure your SOAP client allows
     * for long 
     *                                 message timeouts. This counting process
     * will result
     *                                 in audits being logged if the current
     * license
     *                                 is nearing expiry or the maximum user
     * limit.
     */
    public void setCountUsers(boolean countUsers) {
        this.countUsers = countUsers;
    }


    /**
     * Gets the countLimitPercent value for this LicenseParms.
     * 
     * @return countLimitPercent   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within this percentage
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 900
     *                             users in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of users
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public Integer getCountLimitPercent() {
        return countLimitPercent;
    }


    /**
     * Sets the countLimitPercent value for this LicenseParms.
     * 
     * @param countLimitPercent   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within this percentage
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 900
     *                             users in the system, and this value is
     * set to 10,
     *                             a warning audit is written as the number
     * of users
     *                             is within 10 percent of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public void setCountLimitPercent(Integer countLimitPercent) {
        this.countLimitPercent = countLimitPercent;
    }


    /**
     * Gets the countLimit value for this LicenseParms.
     * 
     * @return countLimit   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within countLimit
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 950
     *                             users in the system, and this value is
     * set to 100,
     *                             a warning audit is written as the number
     * of users
     *                             is within 100 users of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public Integer getCountLimit() {
        return countLimit;
    }


    /**
     * Sets the countLimit value for this LicenseParms.
     * 
     * @param countLimit   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             users in the system is within countLimit
     * of the
     *                             number of users allowed by the license.
     * For example,
     *                             if the license allows for 1000 users,
     * there are 950
     *                             users in the system, and this value is
     * set to 100,
     *                             a warning audit is written as the number
     * of users
     *                             is within 100 users of the maximum allowed.
     * If both
     *                             countLimit and countLimitPercent are specified,
     * countLimitPercent is used and countLimit is ignored.
     */
    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }


    /**
     * Gets the timeLimit value for this LicenseParms.
     * 
     * @return timeLimit   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written.
     */
    public Integer getTimeLimit() {
        return timeLimit;
    }


    /**
     * Sets the timeLimit value for this LicenseParms.
     * 
     * @param timeLimit   * If countUsers is true and this value is not null,
     *                             then a warning audit is written if the
     * number of
     *                             days until the current license expires
     * is
     *                             less than or equal to timeLimit. For example,
     * if the license expires in 100 days, and this value
     *                             is set to 150, a warning audit is written.
     */
    public void setTimeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
    }


    /**
     * Gets the updatePartitions value for this LicenseParms.
     * 
     * @return updatePartitions   * Flag that controls whether or not user counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of users in the system because the
     * countUsers
     *                                 flag was true.  If countUsers is true
     * and this
     *                                 flag is null or false, users in partitions
     * are counted,
     *                                 but any mismatches between the number
     * of users
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date.
     */
    public Boolean getUpdatePartitions() {
        return updatePartitions;
    }


    /**
     * Sets the updatePartitions value for this LicenseParms.
     * 
     * @param updatePartitions   * Flag that controls whether or not user counts in
     *                                 partitions are updated when performing
     * a count
     *                                 of users in the system because the
     * countUsers
     *                                 flag was true.  If countUsers is true
     * and this
     *                                 flag is null or false, users in partitions
     * are counted,
     *                                 but any mismatches between the number
     * of users
     *                                 in the partition and the number counted
     * are
     *                                 logged, but the partitions are not
     * updated.
     *                                 If this flag is true, the partitions
     * are updated
     *                                 in the case of a mismatch. Care must
     * be
     *                                 taken when setting this flag to true
     * to make
     *                                 sure the data in the repository is
     * up to date.
     */
    public void setUpdatePartitions(Boolean updatePartitions) {
        this.updatePartitions = updatePartitions;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof LicenseParms)) return false;
        LicenseParms other = (LicenseParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.installKey==null && other.getInstallKey()==null) || 
             (this.installKey!=null &&
              this.installKey.equals(other.getInstallKey()))) &&
            ((this.activationKey==null && other.getActivationKey()==null) || 
             (this.activationKey!=null &&
              this.activationKey.equals(other.getActivationKey()))) &&
            this.countUsers == other.isCountUsers() &&
            ((this.countLimitPercent==null && other.getCountLimitPercent()==null) || 
             (this.countLimitPercent!=null &&
              this.countLimitPercent.equals(other.getCountLimitPercent()))) &&
            ((this.countLimit==null && other.getCountLimit()==null) || 
             (this.countLimit!=null &&
              this.countLimit.equals(other.getCountLimit()))) &&
            ((this.timeLimit==null && other.getTimeLimit()==null) || 
             (this.timeLimit!=null &&
              this.timeLimit.equals(other.getTimeLimit()))) &&
            ((this.updatePartitions==null && other.getUpdatePartitions()==null) || 
             (this.updatePartitions!=null &&
              this.updatePartitions.equals(other.getUpdatePartitions())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getInstallKey() != null) {
            _hashCode += getInstallKey().hashCode();
        }
        if (getActivationKey() != null) {
            _hashCode += getActivationKey().hashCode();
        }
        _hashCode += (isCountUsers() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCountLimitPercent() != null) {
            _hashCode += getCountLimitPercent().hashCode();
        }
        if (getCountLimit() != null) {
            _hashCode += getCountLimit().hashCode();
        }
        if (getTimeLimit() != null) {
            _hashCode += getTimeLimit().hashCode();
        }
        if (getUpdatePartitions() != null) {
            _hashCode += getUpdatePartitions().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(LicenseParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "LicenseParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("installKey");
        elemField.setXmlName(new javax.xml.namespace.QName("", "installKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationKey");
        elemField.setXmlName(new javax.xml.namespace.QName("", "activationKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countLimitPercent");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countLimitPercent"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countLimit");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countLimit"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("timeLimit");
        elemField.setXmlName(new javax.xml.namespace.QName("", "timeLimit"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updatePartitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updatePartitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
