/**
 * CACertificateParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters used for the CA
 *                         certificate load and set operations.
 */
public class CACertificateParms  implements java.io.Serializable {
    /* The name of the CA certificate.
     *                                 It must be specified during the load
     * operation
     *                                 and is used to rename the CA
     *                                 certificate during the set operation. */
    private String name;

    /* Specifies the certificate data to be loaded
     *                                 During the load operation.  It must
     * be
     *                                 specified during the load operation.
     * The
     *                                 data must be a Base-64 encoded X.509
     * certificate or PKCS#7 certificate chain.
     *                                 The specified certificate must be
     * a CA
     *                                 certificate and must not already be
     * loaded
     *                                 into the system. */
    private String data;

    /* The state of the CA certificate.
     *                                 During the load operation, the state
     * defaults to ACTIVE if not specified. */
    private CertificateState state;

    /* If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true. */
    private Boolean LDAPUseURLCDP;

    /* Specifies the LDAP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be a valid
     * URL or
     *                                 an empty string.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required. */
    private String LDAPURL;

    /* Specifies the LDAP User DN for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserPassword value must be set.
     * If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to */
    private String LDAPUserDN;

    /* Specifies the LDAP User Password for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserDN value must be set.  If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to */
    private String LDAPUserPassword;

    /* Specifies the OCSP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be valid
     * URL or
     *                                 an empty string.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking. */
    private String OCSPURL;

    /* A flag that indicates if the CA certificate's
     *                                 AIA extension is used to determine
     * the
     *                                 location of the OCSP server.  If this
     * value is set to false and OCSPURL is not
     *                                 specified, then OCSP is not used to
     * perform
     *                                 revocation checking. */
    private Boolean OCSPUseAIA;

    /* Specifies the comment for the CA
     *                                 certificate during the load or set
     * operation. */
    private String comment;

    public CACertificateParms() {
    }

    public CACertificateParms(
           String name,
           String data,
           CertificateState state,
           Boolean LDAPUseURLCDP,
           String LDAPURL,
           String LDAPUserDN,
           String LDAPUserPassword,
           String OCSPURL,
           Boolean OCSPUseAIA,
           String comment) {
           this.name = name;
           this.data = data;
           this.state = state;
           this.LDAPUseURLCDP = LDAPUseURLCDP;
           this.LDAPURL = LDAPURL;
           this.LDAPUserDN = LDAPUserDN;
           this.LDAPUserPassword = LDAPUserPassword;
           this.OCSPURL = OCSPURL;
           this.OCSPUseAIA = OCSPUseAIA;
           this.comment = comment;
    }


    /**
     * Gets the name value for this CACertificateParms.
     * 
     * @return name   * The name of the CA certificate.
     *                                 It must be specified during the load
     * operation
     *                                 and is used to rename the CA
     *                                 certificate during the set operation.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this CACertificateParms.
     * 
     * @param name   * The name of the CA certificate.
     *                                 It must be specified during the load
     * operation
     *                                 and is used to rename the CA
     *                                 certificate during the set operation.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the data value for this CACertificateParms.
     * 
     * @return data   * Specifies the certificate data to be loaded
     *                                 During the load operation.  It must
     * be
     *                                 specified during the load operation.
     * The
     *                                 data must be a Base-64 encoded X.509
     * certificate or PKCS#7 certificate chain.
     *                                 The specified certificate must be
     * a CA
     *                                 certificate and must not already be
     * loaded
     *                                 into the system.
     */
    public String getData() {
        return data;
    }


    /**
     * Sets the data value for this CACertificateParms.
     * 
     * @param data   * Specifies the certificate data to be loaded
     *                                 During the load operation.  It must
     * be
     *                                 specified during the load operation.
     * The
     *                                 data must be a Base-64 encoded X.509
     * certificate or PKCS#7 certificate chain.
     *                                 The specified certificate must be
     * a CA
     *                                 certificate and must not already be
     * loaded
     *                                 into the system.
     */
    public void setData(String data) {
        this.data = data;
    }


    /**
     * Gets the state value for this CACertificateParms.
     * 
     * @return state   * The state of the CA certificate.
     *                                 During the load operation, the state
     * defaults to ACTIVE if not specified.
     */
    public CertificateState getState() {
        return state;
    }


    /**
     * Sets the state value for this CACertificateParms.
     * 
     * @param state   * The state of the CA certificate.
     *                                 During the load operation, the state
     * defaults to ACTIVE if not specified.
     */
    public void setState(CertificateState state) {
        this.state = state;
    }


    /**
     * Gets the LDAPUseURLCDP value for this CACertificateParms.
     * 
     * @return LDAPUseURLCDP   * If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true.
     */
    public Boolean getLDAPUseURLCDP() {
        return LDAPUseURLCDP;
    }


    /**
     * Sets the LDAPUseURLCDP value for this CACertificateParms.
     * 
     * @param LDAPUseURLCDP   * If an LDAP URL is not specified, this flag
     *                                 controls whether certificate authentication
     * will use URL CDPs in the certificate to find
     *                                 CRLs.  If a LDAP URL is specified,
     * this flag
     *                                 must be true.
     */
    public void setLDAPUseURLCDP(Boolean LDAPUseURLCDP) {
        this.LDAPUseURLCDP = LDAPUseURLCDP;
    }


    /**
     * Gets the LDAPURL value for this CACertificateParms.
     * 
     * @return LDAPURL   * Specifies the LDAP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be a valid
     * URL or
     *                                 an empty string.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required.
     */
    public String getLDAPURL() {
        return LDAPURL;
    }


    /**
     * Sets the LDAPURL value for this CACertificateParms.
     * 
     * @param LDAPURL   * Specifies the LDAP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be a valid
     * URL or
     *                                 an empty string.
     *                                 The LDAP URL if defined specifies
     * the LDAP
     *                                 server  used during certificate validation
     * to
     *                                 retrieve certificates and CRLs as
     * required.
     */
    public void setLDAPURL(String LDAPURL) {
        this.LDAPURL = LDAPURL;
    }


    /**
     * Gets the LDAPUserDN value for this CACertificateParms.
     * 
     * @return LDAPUserDN   * Specifies the LDAP User DN for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserPassword value must be set.
     * If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to
     */
    public String getLDAPUserDN() {
        return LDAPUserDN;
    }


    /**
     * Sets the LDAPUserDN value for this CACertificateParms.
     * 
     * @param LDAPUserDN   * Specifies the LDAP User DN for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserPassword value must be set.
     * If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to
     */
    public void setLDAPUserDN(String LDAPUserDN) {
        this.LDAPUserDN = LDAPUserDN;
    }


    /**
     * Gets the LDAPUserPassword value for this CACertificateParms.
     * 
     * @return LDAPUserPassword   * Specifies the LDAP User Password for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserDN value must be set.  If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to
     */
    public String getLDAPUserPassword() {
        return LDAPUserPassword;
    }


    /**
     * Sets the LDAPUserPassword value for this CACertificateParms.
     * 
     * @param LDAPUserPassword   * Specifies the LDAP User Password for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 This value can only be set if the
     * LDAPURL
     *                                 value is set.  If this value is set,
     * the
     *                                 LDAPUserDN value must be set.  If
     *                                 this value is not set and the LDAP
     * URL value
     *                                 is set, anonymous bind is used to
     *                                 connect to the LDAP server.
     *                                 used to
     */
    public void setLDAPUserPassword(String LDAPUserPassword) {
        this.LDAPUserPassword = LDAPUserPassword;
    }


    /**
     * Gets the OCSPURL value for this CACertificateParms.
     * 
     * @return OCSPURL   * Specifies the OCSP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be valid
     * URL or
     *                                 an empty string.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public String getOCSPURL() {
        return OCSPURL;
    }


    /**
     * Sets the OCSPURL value for this CACertificateParms.
     * 
     * @param OCSPURL   * Specifies the OCSP URL for the CA
     *                                 certificate during the load or set
     * operation.
     *                                 The specified value must be valid
     * URL or
     *                                 an empty string.
     *                                 If specified, the OCSP URL specifies
     * the 
     *                                 location of an OCSP server that may
     * be used
     *                                 during certificate authentication
     * to retrieve
     *                                 certificate revocation information.
     * If this
     *                                 value isn't specified and OCSPUseAIA
     * is set
     *                                 to false, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public void setOCSPURL(String OCSPURL) {
        this.OCSPURL = OCSPURL;
    }


    /**
     * Gets the OCSPUseAIA value for this CACertificateParms.
     * 
     * @return OCSPUseAIA   * A flag that indicates if the CA certificate's
     *                                 AIA extension is used to determine
     * the
     *                                 location of the OCSP server.  If this
     * value is set to false and OCSPURL is not
     *                                 specified, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public Boolean getOCSPUseAIA() {
        return OCSPUseAIA;
    }


    /**
     * Sets the OCSPUseAIA value for this CACertificateParms.
     * 
     * @param OCSPUseAIA   * A flag that indicates if the CA certificate's
     *                                 AIA extension is used to determine
     * the
     *                                 location of the OCSP server.  If this
     * value is set to false and OCSPURL is not
     *                                 specified, then OCSP is not used to
     * perform
     *                                 revocation checking.
     */
    public void setOCSPUseAIA(Boolean OCSPUseAIA) {
        this.OCSPUseAIA = OCSPUseAIA;
    }


    /**
     * Gets the comment value for this CACertificateParms.
     * 
     * @return comment   * Specifies the comment for the CA
     *                                 certificate during the load or set
     * operation.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this CACertificateParms.
     * 
     * @param comment   * Specifies the comment for the CA
     *                                 certificate during the load or set
     * operation.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CACertificateParms)) return false;
        CACertificateParms other = (CACertificateParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.data==null && other.getData()==null) || 
             (this.data!=null &&
              this.data.equals(other.getData()))) &&
            ((this.state==null && other.getState()==null) || 
             (this.state!=null &&
              this.state.equals(other.getState()))) &&
            ((this.LDAPUseURLCDP==null && other.getLDAPUseURLCDP()==null) || 
             (this.LDAPUseURLCDP!=null &&
              this.LDAPUseURLCDP.equals(other.getLDAPUseURLCDP()))) &&
            ((this.LDAPURL==null && other.getLDAPURL()==null) || 
             (this.LDAPURL!=null &&
              this.LDAPURL.equals(other.getLDAPURL()))) &&
            ((this.LDAPUserDN==null && other.getLDAPUserDN()==null) || 
             (this.LDAPUserDN!=null &&
              this.LDAPUserDN.equals(other.getLDAPUserDN()))) &&
            ((this.LDAPUserPassword==null && other.getLDAPUserPassword()==null) || 
             (this.LDAPUserPassword!=null &&
              this.LDAPUserPassword.equals(other.getLDAPUserPassword()))) &&
            ((this.OCSPURL==null && other.getOCSPURL()==null) || 
             (this.OCSPURL!=null &&
              this.OCSPURL.equals(other.getOCSPURL()))) &&
            ((this.OCSPUseAIA==null && other.getOCSPUseAIA()==null) || 
             (this.OCSPUseAIA!=null &&
              this.OCSPUseAIA.equals(other.getOCSPUseAIA()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getData() != null) {
            _hashCode += getData().hashCode();
        }
        if (getState() != null) {
            _hashCode += getState().hashCode();
        }
        if (getLDAPUseURLCDP() != null) {
            _hashCode += getLDAPUseURLCDP().hashCode();
        }
        if (getLDAPURL() != null) {
            _hashCode += getLDAPURL().hashCode();
        }
        if (getLDAPUserDN() != null) {
            _hashCode += getLDAPUserDN().hashCode();
        }
        if (getLDAPUserPassword() != null) {
            _hashCode += getLDAPUserPassword().hashCode();
        }
        if (getOCSPURL() != null) {
            _hashCode += getOCSPURL().hashCode();
        }
        if (getOCSPUseAIA() != null) {
            _hashCode += getOCSPUseAIA().hashCode();
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CACertificateParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CACertificateParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("data");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Data"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("state");
        elemField.setXmlName(new javax.xml.namespace.QName("", "state"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CertificateState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPUseURLCDP");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPUseURLCDP"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPURL");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPURL"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPUserDN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPUserDN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("LDAPUserPassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LDAPUserPassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OCSPURL");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OCSPURL"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OCSPUseAIA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OCSPUseAIA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
