package com.good.adapters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.good.domain.P12CertificateData;
import com.good.exception.CertificateServerException;

/**
 * Interface for Certificate Services to create Public Key Infrastructure. All supported types of Certificate Services 
 * should be listed in {@link com.good.adapters.CertificateServer.CertificateServerType}. Each type of Certificate 
 * Service should contains one implementation. 
 *
 * @author Stanislav Kyfenko
 *         04.08.2015
 */
public interface CertificateServer {

    /**
     * Certificate server type list, for each specified type should be single implementation of {@link CertificateServer}
     * If you need to add one more certificate server type, put it here
     */
    enum CertificateServerType {
        ENTRUST;

        @JsonCreator
        public static CertificateServerType fromValue(String value) {
            return valueOf(value);
        }

        @JsonValue
        public String toValue() {
            return this.name();
        }
    }

    P12CertificateData createCertificate(String userName, String email, String certificatePassword, String deviceId, String deviceName) throws CertificateServerException;

}
