package com.good.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Uses as response of create/re-new certificate. Object will be serialized into JSON and will be sent to the client.
 *
 * @author Stanislav Kyfenko 29.07.2015
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class P12CertificateData extends GenericData {
    /**
     * PKCS12 keystore. Mandatory field
     */
	private byte[] payload;
    /**
     * type of keystore. Mandatory field.
     */
	private CertificateTypeEnum payloadType;

    /**
     * password for keystore, is not mandatory field. Should be presented only when 
	 * {@link GDP12CertificateRequest#authToken} was empty and server created PKCS12 keystore with randomly generated 
	 * password.
     */
    private String password;

	public P12CertificateData(P12CertificateFailure failureInfo, String reqId) {
		super(failureInfo,reqId);
	}

	public P12CertificateData(byte[] payload,
			CertificateTypeEnum payloadType) {
		this.payload = payload;
		this.payloadType = payloadType;
		this.status = StatusTypeEnum.SUCCESS;
	}


    public P12CertificateData() {
        super();
    }

	public byte[] getPayload() {
		return this.payload;
	}

	public CertificateTypeEnum getPayloadType() {
		return this.payloadType;
	}

	public String getPassword() {
		return password;
	}

    public void setPassword(String password) {
        this.password = password;
    }


    @Override
    public String toString() {
        return "P12CertificateData{" +
                "payload.length=" + (payload == null ? null : payload.length) +
                ", payloadType=" + payloadType +
                ", status=" + status +
                ", failureInfo=" + failureInfo +
                ", reqId='" + reqId + '\'' +
                '}';
    }

    public enum CertificateTypeEnum {

		PKCS12("pkcs12");
		private final String val;

		CertificateTypeEnum(String val) {
			this.val = val;
		}

		@JsonValue
		public String getValue() {
			return this.val;
		}

		public static CertificateTypeEnum getByValue(String value) {
			switch (value) {
			case "pkcs12":
				return PKCS12;
			default:
				return null;
			}
		}

	}
}
