package com.good.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.good.config.SupportedOperations;
import com.good.service.CertificateServerService;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;

/**
 * Response data, will be used in {@link CertificateServerService#getInfo()}.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetInfoDataResponse {
    /**
     * Array of all the commands implemented by the connector server
     */
    private Set<String> operations = new TreeSet<>();

    public Set<String> getOperations() {
        return operations;
    }

    public void setOperations(Set<String> operations) {
        this.operations = operations;
    }

    public GetInfoDataResponse(){
        super();
        for (SupportedOperations operation: SupportedOperations.values()){
            operations.add(operation.getValue());
        }
    }

    @Override
    public String toString() {
        return "GetInfoDataResponse{" +
                "operations=" + operations +
                '}';
    }
}
