/**
 * UserSpecInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines a user specification policy.
 */
public class UserSpecInfo  implements java.io.Serializable {
    /* The name of the user specification policy. */
    private String name;

    /* The maximum number of aliases that can be assigned
     *                                 to a user. A value of 0 means that
     * users are
     *                                 not allowed to have aliases. */
    private int maxAliases;

    /* The maximum number of contact information entries for
     *                                 a user. A value of 0 means that no
     * contact information
     *                                 can be stored. */
    private int maxContactInfoNumber;

    /* The authentication lockout mode. */
    private LockoutMode lockoutMode;

    /* The number of consecutive authentication failures allowed before
     * a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate. 
     *                                 The various maxXXXFailures policies
     * should be used 
     *                                 instead of this policy. */
    private int maxFailures;

    /* The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode. */
    private int maxGlobalFailures;

    /* The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxCertificateFailures;

    /* The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxExternalFailures;

    /* The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxGridFailures;

    /* The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxTokenCRFailures;

    /* The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxTokenROFailures;

    /* The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxOTPFailures;

    /* The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxQAFailures;

    /* The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxRBAIPAuthFailures;

    /* The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxRBAMachineAuthFailures;

    /* The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxRBACertificateAuthFailures;

    /* The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int maxRBAExternalRiskAuthFailures;

    /* The number of minutes a user remains locked out. A value
     *                                 of 0 means the user remains locked
     * out until unlocked by an
     *                                 administrator.
     *                                 This policy is used with the GLOBAL,
     * ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes. */
    private int lockoutTime;

    /* The maximum size of the shared secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that users are not allowed to have
     * shared
     *                                 secrets. */
    private int maxSecretSize;

    /* The maximum number of shared secrets for
     *                                 a user. A value of 0 means that users
     * are
     *                                 not allowed to have shared secrets. */
    private int maxSecretNumber;

    /* The type of authentications that can be
     *                                 used for generic authentication operations
     * with a normal security level. */
    private AuthenticationType[] genericAuthType;

    /* The type of authentications that can be
     *                                 used for generic authentication operations
     * with an enhanced security level. */
    private AuthenticationType[] enhancedGenericAuthType;

    /* The type of authentications that can be
     *                                 used for machine registration
     *                                 authentication operations. */
    private AuthenticationType[] machineAuthType;

    /* The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations. */
    private AuthenticationType[] authTypeCanViewSecrets;

    /* The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations. */
    private AuthenticationType[] authTypeCanModifySecrets;

    /* The maximum number of machine secrets for
     *                                 a user. A value of 0 means that no
     * machine
     *                                 secrets can be stored. */
    private int maxMachineSecrets;

    /* The maximum size of a single machine secret
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored. */
    private int maxMachineSecretsSize;

    /* A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              If this flag is false, the
     *                              machineSecretRequiresAppData setting
     * will be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * will be 0. */
    private boolean machineSecretRequiresMachineNonce;

    /* A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication. */
    private boolean machineSecretRequiresSequenceNonce;

    /* A count indicating how many application data
     *                                 values must be contained in a machine
     * secret
     *                                 used for authentication. */
    private int machineSecretRequiresAppData;

    /* A count indicating how many application data
     *                                 values in a machine secret being used
     * for
     *                                 authentication can be bad before
     *                                 validation fails. */
    private int machineSecretAllowsBadAppData;

    /* Machine secret lifetime in hours. A value of 0
     *                                 means an infinite lifetime. */
    private int machineSecretLifetime;

    /* A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed. */
    private boolean failedMachineAuthIncrementsLockout;

    /* The maximum number of authentication secrets for
     *                                 a user. A value of 0 means that no
     * authentication secrets can be stored. */
    private int maxAuthSecrets;

    /* The maximum size of authentication secrets for a user,
     *                                 in kilobytes. A value of 0 means that
     * no
     *                                 authentication secrets can be stored. */
    private int maxAuthSecretsSize;

    /* The maximum number of question and answer pairs for a
     *                                 user. A value of 0 means that no question
     * and answer pairs can
     *                                 be stored. */
    private int maxQuestions;

    /* The maximum size of question and answer (QA) pairs stored for
     * a user,
     *                                 in kilobytes. A value of 0 means that
     * no QA pairs can be stored. */
    private int maxQASize;

    /* The number of questions in a QA challenge. */
    private int QAChallengeSize;

    /* The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default. */
    private int minQAChallengeSize;

    /* The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default. */
    private int maxQAChallengeSize;

    /* If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer. */
    private boolean disableQAChallengeRetention;

    /* Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private int QAChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true. */
    private boolean updateLockoutForReplacedQAChallenge;

    /* The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct. */
    private int qaDefaultWrongAnswersAllowed;

    /* The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct. */
    private int qaMaximumWrongAnswersAllowed;

    /* Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge. */
    private boolean qaInexactMatchAllowed;

    /* The characters that can appear in a one-time password (OTP). */
    private String[] OTPCellAlphabet;

    /* A list of characters that are replaced in a one-time password
     * (OTP) response before it is validated. */
    private CellReplacement[] OTPCellReplacements;

    /* The lifetime in seconds of a one-time password (OTP). A value
     * of
     *                                 0 means an infinite lifetime. */
    private int OTPLifetime;

    /* The number of characters in a one-time password (OTP). */
    private int OTPLength;

    /* Flag indicating if a user's one-time password (OTP)
     *                                 can be delivered via an out-of-band
     * delivery mechanism. */
    private boolean OTPDeliveryEnabled;

    /* Flag indicating if a new OTP is generated
     *                                 for each challenge request.  If set
     * to false,
     *                                 a new OTP is generated only if there
     * is no
     *                                 existing OTP or the current OTP is
     * expired. */
    private boolean OTPAlwaysGenerate;

    /* Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested. */
    private boolean OTPDynamicRefresh;

    /* Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer. */
    private int OTPNumberOutstanding;

    /* When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy. */
    private int OTPRefreshThreshold;

    /* Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge. */
    private boolean returnAuthSecretWithChall;

    /* Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is
     *                                 deleted. */
    private boolean autoUnassignTokens;

    /* Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group. */
    private boolean autoMoveTokens;

    /* If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request. */
    private boolean disableTokenChallengeRetention;

    /* Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private int tokenChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true. */
    private boolean updateLockoutForReplacedTokenChallenge;

    /* The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer. */
    private int maxAllowedTokenSets;

    /* Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request. */
    private boolean allowNONEAuthentication;

    /* Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type. */
    private boolean considerTempPINLast;

    /* Flag indicating if information about the
     *                                 last authentication for a user is
     * stored. */
    private boolean storeLastAuthInfo;

    /* Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data. */
    private boolean allowCreateIfDisabledInRepository;

    /* Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data. */
    private boolean allowCreateIfExpiredInRepository;

    /* Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail. */
    private boolean allowAuthIfDisabledInRepository;

    /* Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail. */
    private boolean allowAuthIfExpiredInRepository;

    /* Specifies how transaction receipts are signed. */
    private com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType;

    /* Specifies the lifetime of a transaction in
     *                                 seconds. */
    private int transactionLifetime;

    /* Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction. */
    private int maxNumTransactionDetails;

    /* Specifies if self-signed user certificates
     *                                 can be assigned to a user. */
    private boolean allowSelfSignedUserCert;

    /* Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user. */
    private boolean allowCertNotIssuedByRegisteredCA;

    /* Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user. */
    private boolean allowAllRegisteredCAs;

    /* User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set. */
    private String[] allowedRegisteredCAs;

    /* Specifies if a user certificate that is 
     *                                 not issued by a managed CA can be
     * 
     *                                 used to authenticate a user. */
    private boolean allowCertNotIssuedByManagedCA;

    /* Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user. */
    private boolean allowAllManagedCAs;

    /* User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set. */
    private String[] allowedManagedCAs;

    /* Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256. */
    private String certificateAuthenticationHashAlg;

    /* Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32. */
    private int certificateAuthenticationChallengeSize;

    /* Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer. */
    private int maxCertsPerUser;

    /* A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user. */
    private boolean autoDeleteUserCerts;

    /* If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request. */
    private boolean disableCertificateChallengeRetention;

    /* Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned. */
    private int certificateChallengeLifetime;

    /* If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true. */
    private boolean updateLockoutForReplacedCertificateChallenge;

    /* If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges. */
    private boolean allowCertificateChallengeDelivery;

    /* If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges. */
    private boolean allowCertificateTransactionDelivery;

    /* If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges. */
    private boolean allowCertificateSign;

    /* Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user. */
    private boolean allowAllSmartCredentialDefinitions;

    /* Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set. */
    private String[] allowedSmartCredentialDefinitions;

    /* Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private int maxSmartCredentialsPerUser;

    /* The prefix added to Smart Credential Ids. */
    private String smartCredentialIDPrefix;

    /* The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation. */
    private String smartCredentialTokenVendor;

    /* Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the
     *                                 user they belong to is deleted. */
    private boolean autoUnassignSmartCredentials;

    /* Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned. */
    private boolean autoCancelSmartCredentials;

    /* Flag indicating if the force option is applied
     *                                 when smart credentials or auto-canceled.
     * This option only applies if
     *                                 AutoCancelSmartCredentials is true. */
    private boolean autoCancelSmartCredentialsForce;

    /* Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group. */
    private boolean autoMoveSmartCredentials;

    /* Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued. */
    private boolean autoRegisterSmartCredentialsToPACS;

    /* Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted. */
    private boolean autoSuspendSmartCredentialsFromPACS;

    /* Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy. */
    private boolean allowSoftwareSmartCredentials;

    /* Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN. */
    private PINPromptType mobileSmartCredentialPINPrompt;

    /* Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION. */
    private int mobileSmartCredentialSessionTimeout;

    /* Specifies that any Digital Id Config can be
     *                                 used to create Digital Ids for a user. */
    private boolean allowAllDigitalIdConfigs;

    /* Specifies a list of Digital Id Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set. */
    private String[] allowedDigitalIdConfigs;

    /* Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private int maxDigitalIdsPerUser;

    /* Specifies the maximum number of Client Types
     *                                 for a Digital Id.
     *                                 This value must be a non-negative
     * integer. */
    private int maxClientTypesPerDigitalId;

    /* Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted. */
    private boolean autoCancelDigitalIds;

    /* User registration password lifetime in minutes.
     *                                 A value of 0 means an infinite lifetime. */
    private int userRegistrationPasswordLifetime;

    /* The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32. */
    private int userRegistrationPasswordLength;

    /* Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer. */
    private int maxFederationsPerUser;

    /* The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer. */
    private int maxNumUserPreferences;

    /* The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer. */
    private int maxSizeUserPreference;

    /* The required length of new personal verification
     *                                 numbers (PVNs). */
    private int PVNLength;

    /* Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator. */
    private boolean PVNChangeRequiredOnAdminReset;

    /* The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating. */
    private AuthenticationType[] authTypesRequiringPVN;

    /* If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true. */
    private boolean allTokenVendorsRequirePVN;

    /* If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true. */
    private String[] tokenVendorsRequiringPVN;

    /* The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately. */
    private int numDaysForActivation;

    /* The authentication types that trigger user activation on
     *                                 first successful authentication. */
    private AuthenticationType[] activationAuthTypes;

    /* Indicates if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history. */
    private boolean checkIPAddressInLocationHistory;

    /* The maximum size of a user's location history.
     *                                 If a user exceeds this many locations,
     * the
     *                                 least-recently used locations are
     * removed from
     *                                 the list. */
    private int maxLocationHistorySize;

    /* The lifetime (in days) of an entry in a user's
     *                                 location history. */
    private int locationHistoryLifetime;

    /* The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication. */
    private int maxVelocity;

    /* If true, the velocity check is performed
     *                                 during IP authentication. */
    private boolean checkVelocity;

    /* The country blacklist is a list of countries.
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication. */
    private CountryInfo[] countryBlacklist;

    /* The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication. */
    private ExpectedLocation[] expectedLocations;

    /* If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list. */
    private int maxUserExpectedLocationsSize;

    /* A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected. */
    private RBAExpressionList normalReject;

    /* A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated. */
    private RBAExpressionList normalAuthenticated;

    /* A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected. */
    private RBAExpressionList enhancedReject;

    /* A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated. */
    private RBAExpressionList enhancedAuthenticated;

    /* A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value. */
    private int externalRiskScoreNormalPass;

    /* A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value. */
    private int externalRiskScoreNormalFail;

    /* A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value. */
    private int externalRiskScoreEnhancedPass;

    /* A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value. */
    private int externalRiskScoreEnhancedFail;

    /* The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  If this value
     * is not
     *                                 set, external risk scoring is not
     * available. */
    private String externalRiskEngine;

    /* A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery. */
    private boolean performTransactionDelivery;

    /* A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP. */
    private boolean softTokenPINRequired;

    /* The number of digits in an OTP response from a
     *                                 soft token. */
    private int softTokenOTPLength;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Descriptive comments. */
    private String comment;

    public UserSpecInfo() {
    }

    public UserSpecInfo(
           String name,
           int maxAliases,
           int maxContactInfoNumber,
           LockoutMode lockoutMode,
           int maxFailures,
           int maxGlobalFailures,
           int maxCertificateFailures,
           int maxExternalFailures,
           int maxGridFailures,
           int maxTokenCRFailures,
           int maxTokenROFailures,
           int maxOTPFailures,
           int maxQAFailures,
           int maxRBAIPAuthFailures,
           int maxRBAMachineAuthFailures,
           int maxRBACertificateAuthFailures,
           int maxRBAExternalRiskAuthFailures,
           int lockoutTime,
           int maxSecretSize,
           int maxSecretNumber,
           AuthenticationType[] genericAuthType,
           AuthenticationType[] enhancedGenericAuthType,
           AuthenticationType[] machineAuthType,
           AuthenticationType[] authTypeCanViewSecrets,
           AuthenticationType[] authTypeCanModifySecrets,
           int maxMachineSecrets,
           int maxMachineSecretsSize,
           boolean machineSecretRequiresMachineNonce,
           boolean machineSecretRequiresSequenceNonce,
           int machineSecretRequiresAppData,
           int machineSecretAllowsBadAppData,
           int machineSecretLifetime,
           boolean failedMachineAuthIncrementsLockout,
           int maxAuthSecrets,
           int maxAuthSecretsSize,
           int maxQuestions,
           int maxQASize,
           int QAChallengeSize,
           int minQAChallengeSize,
           int maxQAChallengeSize,
           boolean disableQAChallengeRetention,
           int QAChallengeLifetime,
           boolean updateLockoutForReplacedQAChallenge,
           int qaDefaultWrongAnswersAllowed,
           int qaMaximumWrongAnswersAllowed,
           boolean qaInexactMatchAllowed,
           String[] OTPCellAlphabet,
           CellReplacement[] OTPCellReplacements,
           int OTPLifetime,
           int OTPLength,
           boolean OTPDeliveryEnabled,
           boolean OTPAlwaysGenerate,
           boolean OTPDynamicRefresh,
           int OTPNumberOutstanding,
           int OTPRefreshThreshold,
           boolean returnAuthSecretWithChall,
           boolean autoUnassignTokens,
           boolean autoMoveTokens,
           boolean disableTokenChallengeRetention,
           int tokenChallengeLifetime,
           boolean updateLockoutForReplacedTokenChallenge,
           int maxAllowedTokenSets,
           boolean allowNONEAuthentication,
           boolean considerTempPINLast,
           boolean storeLastAuthInfo,
           boolean allowCreateIfDisabledInRepository,
           boolean allowCreateIfExpiredInRepository,
           boolean allowAuthIfDisabledInRepository,
           boolean allowAuthIfExpiredInRepository,
           com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType,
           int transactionLifetime,
           int maxNumTransactionDetails,
           boolean allowSelfSignedUserCert,
           boolean allowCertNotIssuedByRegisteredCA,
           boolean allowAllRegisteredCAs,
           String[] allowedRegisteredCAs,
           boolean allowCertNotIssuedByManagedCA,
           boolean allowAllManagedCAs,
           String[] allowedManagedCAs,
           String certificateAuthenticationHashAlg,
           int certificateAuthenticationChallengeSize,
           int maxCertsPerUser,
           boolean autoDeleteUserCerts,
           boolean disableCertificateChallengeRetention,
           int certificateChallengeLifetime,
           boolean updateLockoutForReplacedCertificateChallenge,
           boolean allowCertificateChallengeDelivery,
           boolean allowCertificateTransactionDelivery,
           boolean allowCertificateSign,
           boolean allowAllSmartCredentialDefinitions,
           String[] allowedSmartCredentialDefinitions,
           int maxSmartCredentialsPerUser,
           String smartCredentialIDPrefix,
           String smartCredentialTokenVendor,
           boolean autoUnassignSmartCredentials,
           boolean autoCancelSmartCredentials,
           boolean autoCancelSmartCredentialsForce,
           boolean autoMoveSmartCredentials,
           boolean autoRegisterSmartCredentialsToPACS,
           boolean autoSuspendSmartCredentialsFromPACS,
           boolean allowSoftwareSmartCredentials,
           PINPromptType mobileSmartCredentialPINPrompt,
           int mobileSmartCredentialSessionTimeout,
           boolean allowAllDigitalIdConfigs,
           String[] allowedDigitalIdConfigs,
           int maxDigitalIdsPerUser,
           int maxClientTypesPerDigitalId,
           boolean autoCancelDigitalIds,
           int userRegistrationPasswordLifetime,
           int userRegistrationPasswordLength,
           int maxFederationsPerUser,
           int maxNumUserPreferences,
           int maxSizeUserPreference,
           int PVNLength,
           boolean PVNChangeRequiredOnAdminReset,
           AuthenticationType[] authTypesRequiringPVN,
           boolean allTokenVendorsRequirePVN,
           String[] tokenVendorsRequiringPVN,
           int numDaysForActivation,
           AuthenticationType[] activationAuthTypes,
           boolean checkIPAddressInLocationHistory,
           int maxLocationHistorySize,
           int locationHistoryLifetime,
           int maxVelocity,
           boolean checkVelocity,
           CountryInfo[] countryBlacklist,
           ExpectedLocation[] expectedLocations,
           int maxUserExpectedLocationsSize,
           RBAExpressionList normalReject,
           RBAExpressionList normalAuthenticated,
           RBAExpressionList enhancedReject,
           RBAExpressionList enhancedAuthenticated,
           int externalRiskScoreNormalPass,
           int externalRiskScoreNormalFail,
           int externalRiskScoreEnhancedPass,
           int externalRiskScoreEnhancedFail,
           String externalRiskEngine,
           boolean performTransactionDelivery,
           boolean softTokenPINRequired,
           int softTokenOTPLength,
           String[] rolesGrantingAccess,
           String comment) {
           this.name = name;
           this.maxAliases = maxAliases;
           this.maxContactInfoNumber = maxContactInfoNumber;
           this.lockoutMode = lockoutMode;
           this.maxFailures = maxFailures;
           this.maxGlobalFailures = maxGlobalFailures;
           this.maxCertificateFailures = maxCertificateFailures;
           this.maxExternalFailures = maxExternalFailures;
           this.maxGridFailures = maxGridFailures;
           this.maxTokenCRFailures = maxTokenCRFailures;
           this.maxTokenROFailures = maxTokenROFailures;
           this.maxOTPFailures = maxOTPFailures;
           this.maxQAFailures = maxQAFailures;
           this.maxRBAIPAuthFailures = maxRBAIPAuthFailures;
           this.maxRBAMachineAuthFailures = maxRBAMachineAuthFailures;
           this.maxRBACertificateAuthFailures = maxRBACertificateAuthFailures;
           this.maxRBAExternalRiskAuthFailures = maxRBAExternalRiskAuthFailures;
           this.lockoutTime = lockoutTime;
           this.maxSecretSize = maxSecretSize;
           this.maxSecretNumber = maxSecretNumber;
           this.genericAuthType = genericAuthType;
           this.enhancedGenericAuthType = enhancedGenericAuthType;
           this.machineAuthType = machineAuthType;
           this.authTypeCanViewSecrets = authTypeCanViewSecrets;
           this.authTypeCanModifySecrets = authTypeCanModifySecrets;
           this.maxMachineSecrets = maxMachineSecrets;
           this.maxMachineSecretsSize = maxMachineSecretsSize;
           this.machineSecretRequiresMachineNonce = machineSecretRequiresMachineNonce;
           this.machineSecretRequiresSequenceNonce = machineSecretRequiresSequenceNonce;
           this.machineSecretRequiresAppData = machineSecretRequiresAppData;
           this.machineSecretAllowsBadAppData = machineSecretAllowsBadAppData;
           this.machineSecretLifetime = machineSecretLifetime;
           this.failedMachineAuthIncrementsLockout = failedMachineAuthIncrementsLockout;
           this.maxAuthSecrets = maxAuthSecrets;
           this.maxAuthSecretsSize = maxAuthSecretsSize;
           this.maxQuestions = maxQuestions;
           this.maxQASize = maxQASize;
           this.QAChallengeSize = QAChallengeSize;
           this.minQAChallengeSize = minQAChallengeSize;
           this.maxQAChallengeSize = maxQAChallengeSize;
           this.disableQAChallengeRetention = disableQAChallengeRetention;
           this.QAChallengeLifetime = QAChallengeLifetime;
           this.updateLockoutForReplacedQAChallenge = updateLockoutForReplacedQAChallenge;
           this.qaDefaultWrongAnswersAllowed = qaDefaultWrongAnswersAllowed;
           this.qaMaximumWrongAnswersAllowed = qaMaximumWrongAnswersAllowed;
           this.qaInexactMatchAllowed = qaInexactMatchAllowed;
           this.OTPCellAlphabet = OTPCellAlphabet;
           this.OTPCellReplacements = OTPCellReplacements;
           this.OTPLifetime = OTPLifetime;
           this.OTPLength = OTPLength;
           this.OTPDeliveryEnabled = OTPDeliveryEnabled;
           this.OTPAlwaysGenerate = OTPAlwaysGenerate;
           this.OTPDynamicRefresh = OTPDynamicRefresh;
           this.OTPNumberOutstanding = OTPNumberOutstanding;
           this.OTPRefreshThreshold = OTPRefreshThreshold;
           this.returnAuthSecretWithChall = returnAuthSecretWithChall;
           this.autoUnassignTokens = autoUnassignTokens;
           this.autoMoveTokens = autoMoveTokens;
           this.disableTokenChallengeRetention = disableTokenChallengeRetention;
           this.tokenChallengeLifetime = tokenChallengeLifetime;
           this.updateLockoutForReplacedTokenChallenge = updateLockoutForReplacedTokenChallenge;
           this.maxAllowedTokenSets = maxAllowedTokenSets;
           this.allowNONEAuthentication = allowNONEAuthentication;
           this.considerTempPINLast = considerTempPINLast;
           this.storeLastAuthInfo = storeLastAuthInfo;
           this.allowCreateIfDisabledInRepository = allowCreateIfDisabledInRepository;
           this.allowCreateIfExpiredInRepository = allowCreateIfExpiredInRepository;
           this.allowAuthIfDisabledInRepository = allowAuthIfDisabledInRepository;
           this.allowAuthIfExpiredInRepository = allowAuthIfExpiredInRepository;
           this.transactionSignatureType = transactionSignatureType;
           this.transactionLifetime = transactionLifetime;
           this.maxNumTransactionDetails = maxNumTransactionDetails;
           this.allowSelfSignedUserCert = allowSelfSignedUserCert;
           this.allowCertNotIssuedByRegisteredCA = allowCertNotIssuedByRegisteredCA;
           this.allowAllRegisteredCAs = allowAllRegisteredCAs;
           this.allowedRegisteredCAs = allowedRegisteredCAs;
           this.allowCertNotIssuedByManagedCA = allowCertNotIssuedByManagedCA;
           this.allowAllManagedCAs = allowAllManagedCAs;
           this.allowedManagedCAs = allowedManagedCAs;
           this.certificateAuthenticationHashAlg = certificateAuthenticationHashAlg;
           this.certificateAuthenticationChallengeSize = certificateAuthenticationChallengeSize;
           this.maxCertsPerUser = maxCertsPerUser;
           this.autoDeleteUserCerts = autoDeleteUserCerts;
           this.disableCertificateChallengeRetention = disableCertificateChallengeRetention;
           this.certificateChallengeLifetime = certificateChallengeLifetime;
           this.updateLockoutForReplacedCertificateChallenge = updateLockoutForReplacedCertificateChallenge;
           this.allowCertificateChallengeDelivery = allowCertificateChallengeDelivery;
           this.allowCertificateTransactionDelivery = allowCertificateTransactionDelivery;
           this.allowCertificateSign = allowCertificateSign;
           this.allowAllSmartCredentialDefinitions = allowAllSmartCredentialDefinitions;
           this.allowedSmartCredentialDefinitions = allowedSmartCredentialDefinitions;
           this.maxSmartCredentialsPerUser = maxSmartCredentialsPerUser;
           this.smartCredentialIDPrefix = smartCredentialIDPrefix;
           this.smartCredentialTokenVendor = smartCredentialTokenVendor;
           this.autoUnassignSmartCredentials = autoUnassignSmartCredentials;
           this.autoCancelSmartCredentials = autoCancelSmartCredentials;
           this.autoCancelSmartCredentialsForce = autoCancelSmartCredentialsForce;
           this.autoMoveSmartCredentials = autoMoveSmartCredentials;
           this.autoRegisterSmartCredentialsToPACS = autoRegisterSmartCredentialsToPACS;
           this.autoSuspendSmartCredentialsFromPACS = autoSuspendSmartCredentialsFromPACS;
           this.allowSoftwareSmartCredentials = allowSoftwareSmartCredentials;
           this.mobileSmartCredentialPINPrompt = mobileSmartCredentialPINPrompt;
           this.mobileSmartCredentialSessionTimeout = mobileSmartCredentialSessionTimeout;
           this.allowAllDigitalIdConfigs = allowAllDigitalIdConfigs;
           this.allowedDigitalIdConfigs = allowedDigitalIdConfigs;
           this.maxDigitalIdsPerUser = maxDigitalIdsPerUser;
           this.maxClientTypesPerDigitalId = maxClientTypesPerDigitalId;
           this.autoCancelDigitalIds = autoCancelDigitalIds;
           this.userRegistrationPasswordLifetime = userRegistrationPasswordLifetime;
           this.userRegistrationPasswordLength = userRegistrationPasswordLength;
           this.maxFederationsPerUser = maxFederationsPerUser;
           this.maxNumUserPreferences = maxNumUserPreferences;
           this.maxSizeUserPreference = maxSizeUserPreference;
           this.PVNLength = PVNLength;
           this.PVNChangeRequiredOnAdminReset = PVNChangeRequiredOnAdminReset;
           this.authTypesRequiringPVN = authTypesRequiringPVN;
           this.allTokenVendorsRequirePVN = allTokenVendorsRequirePVN;
           this.tokenVendorsRequiringPVN = tokenVendorsRequiringPVN;
           this.numDaysForActivation = numDaysForActivation;
           this.activationAuthTypes = activationAuthTypes;
           this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
           this.maxLocationHistorySize = maxLocationHistorySize;
           this.locationHistoryLifetime = locationHistoryLifetime;
           this.maxVelocity = maxVelocity;
           this.checkVelocity = checkVelocity;
           this.countryBlacklist = countryBlacklist;
           this.expectedLocations = expectedLocations;
           this.maxUserExpectedLocationsSize = maxUserExpectedLocationsSize;
           this.normalReject = normalReject;
           this.normalAuthenticated = normalAuthenticated;
           this.enhancedReject = enhancedReject;
           this.enhancedAuthenticated = enhancedAuthenticated;
           this.externalRiskScoreNormalPass = externalRiskScoreNormalPass;
           this.externalRiskScoreNormalFail = externalRiskScoreNormalFail;
           this.externalRiskScoreEnhancedPass = externalRiskScoreEnhancedPass;
           this.externalRiskScoreEnhancedFail = externalRiskScoreEnhancedFail;
           this.externalRiskEngine = externalRiskEngine;
           this.performTransactionDelivery = performTransactionDelivery;
           this.softTokenPINRequired = softTokenPINRequired;
           this.softTokenOTPLength = softTokenOTPLength;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comment = comment;
    }


    /**
     * Gets the name value for this UserSpecInfo.
     * 
     * @return name   * The name of the user specification policy.
     */
    public String getName() {
        return name;
    }


    /**
     * Sets the name value for this UserSpecInfo.
     * 
     * @param name   * The name of the user specification policy.
     */
    public void setName(String name) {
        this.name = name;
    }


    /**
     * Gets the maxAliases value for this UserSpecInfo.
     * 
     * @return maxAliases   * The maximum number of aliases that can be assigned
     *                                 to a user. A value of 0 means that
     * users are
     *                                 not allowed to have aliases.
     */
    public int getMaxAliases() {
        return maxAliases;
    }


    /**
     * Sets the maxAliases value for this UserSpecInfo.
     * 
     * @param maxAliases   * The maximum number of aliases that can be assigned
     *                                 to a user. A value of 0 means that
     * users are
     *                                 not allowed to have aliases.
     */
    public void setMaxAliases(int maxAliases) {
        this.maxAliases = maxAliases;
    }


    /**
     * Gets the maxContactInfoNumber value for this UserSpecInfo.
     * 
     * @return maxContactInfoNumber   * The maximum number of contact information entries for
     *                                 a user. A value of 0 means that no
     * contact information
     *                                 can be stored.
     */
    public int getMaxContactInfoNumber() {
        return maxContactInfoNumber;
    }


    /**
     * Sets the maxContactInfoNumber value for this UserSpecInfo.
     * 
     * @param maxContactInfoNumber   * The maximum number of contact information entries for
     *                                 a user. A value of 0 means that no
     * contact information
     *                                 can be stored.
     */
    public void setMaxContactInfoNumber(int maxContactInfoNumber) {
        this.maxContactInfoNumber = maxContactInfoNumber;
    }


    /**
     * Gets the lockoutMode value for this UserSpecInfo.
     * 
     * @return lockoutMode   * The authentication lockout mode.
     */
    public LockoutMode getLockoutMode() {
        return lockoutMode;
    }


    /**
     * Sets the lockoutMode value for this UserSpecInfo.
     * 
     * @param lockoutMode   * The authentication lockout mode.
     */
    public void setLockoutMode(LockoutMode lockoutMode) {
        this.lockoutMode = lockoutMode;
    }


    /**
     * Gets the maxFailures value for this UserSpecInfo.
     * 
     * @return maxFailures   * The number of consecutive authentication failures allowed before
     * a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate. 
     *                                 The various maxXXXFailures policies
     * should be used 
     *                                 instead of this policy.
     */
    public int getMaxFailures() {
        return maxFailures;
    }


    /**
     * Sets the maxFailures value for this UserSpecInfo.
     * 
     * @param maxFailures   * The number of consecutive authentication failures allowed before
     * a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate. 
     *                                 The various maxXXXFailures policies
     * should be used 
     *                                 instead of this policy.
     */
    public void setMaxFailures(int maxFailures) {
        this.maxFailures = maxFailures;
    }


    /**
     * Gets the maxGlobalFailures value for this UserSpecInfo.
     * 
     * @return maxGlobalFailures   * The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode.
     */
    public int getMaxGlobalFailures() {
        return maxGlobalFailures;
    }


    /**
     * Sets the maxGlobalFailures value for this UserSpecInfo.
     * 
     * @param maxGlobalFailures   * The number of consecutive authentication failures 
     *                                 allowed across all authentication
     * types before a
     *                                 user is locked out. A value of 0 means
     * the user is
     *                                 never locked out, no matter how many
     * times they
     *                                 fail to authenticate.
     *                                 This policy is used with the GLOBAL
     * lockout mode.
     */
    public void setMaxGlobalFailures(int maxGlobalFailures) {
        this.maxGlobalFailures = maxGlobalFailures;
    }


    /**
     * Gets the maxCertificateFailures value for this UserSpecInfo.
     * 
     * @return maxCertificateFailures   * The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxCertificateFailures() {
        return maxCertificateFailures;
    }


    /**
     * Sets the maxCertificateFailures value for this UserSpecInfo.
     * 
     * @param maxCertificateFailures   * The number of consecutive CERTIFICATE authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxCertificateFailures(int maxCertificateFailures) {
        this.maxCertificateFailures = maxCertificateFailures;
    }


    /**
     * Gets the maxExternalFailures value for this UserSpecInfo.
     * 
     * @return maxExternalFailures   * The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxExternalFailures() {
        return maxExternalFailures;
    }


    /**
     * Sets the maxExternalFailures value for this UserSpecInfo.
     * 
     * @param maxExternalFailures   * The number of consecutive EXTERNAL authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxExternalFailures(int maxExternalFailures) {
        this.maxExternalFailures = maxExternalFailures;
    }


    /**
     * Gets the maxGridFailures value for this UserSpecInfo.
     * 
     * @return maxGridFailures   * The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxGridFailures() {
        return maxGridFailures;
    }


    /**
     * Sets the maxGridFailures value for this UserSpecInfo.
     * 
     * @param maxGridFailures   * The number of consecutive GRID authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxGridFailures(int maxGridFailures) {
        this.maxGridFailures = maxGridFailures;
    }


    /**
     * Gets the maxTokenCRFailures value for this UserSpecInfo.
     * 
     * @return maxTokenCRFailures   * The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxTokenCRFailures() {
        return maxTokenCRFailures;
    }


    /**
     * Sets the maxTokenCRFailures value for this UserSpecInfo.
     * 
     * @param maxTokenCRFailures   * The number of consecutive TOKENCR authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxTokenCRFailures(int maxTokenCRFailures) {
        this.maxTokenCRFailures = maxTokenCRFailures;
    }


    /**
     * Gets the maxTokenROFailures value for this UserSpecInfo.
     * 
     * @return maxTokenROFailures   * The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxTokenROFailures() {
        return maxTokenROFailures;
    }


    /**
     * Sets the maxTokenROFailures value for this UserSpecInfo.
     * 
     * @param maxTokenROFailures   * The number of consecutive TOKENRO authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxTokenROFailures(int maxTokenROFailures) {
        this.maxTokenROFailures = maxTokenROFailures;
    }


    /**
     * Gets the maxOTPFailures value for this UserSpecInfo.
     * 
     * @return maxOTPFailures   * The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxOTPFailures() {
        return maxOTPFailures;
    }


    /**
     * Sets the maxOTPFailures value for this UserSpecInfo.
     * 
     * @param maxOTPFailures   * The number of consecutive OTP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxOTPFailures(int maxOTPFailures) {
        this.maxOTPFailures = maxOTPFailures;
    }


    /**
     * Gets the maxQAFailures value for this UserSpecInfo.
     * 
     * @return maxQAFailures   * The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxQAFailures() {
        return maxQAFailures;
    }


    /**
     * Sets the maxQAFailures value for this UserSpecInfo.
     * 
     * @param maxQAFailures   * The number of consecutive QA authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxQAFailures(int maxQAFailures) {
        this.maxQAFailures = maxQAFailures;
    }


    /**
     * Gets the maxRBAIPAuthFailures value for this UserSpecInfo.
     * 
     * @return maxRBAIPAuthFailures   * The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxRBAIPAuthFailures() {
        return maxRBAIPAuthFailures;
    }


    /**
     * Sets the maxRBAIPAuthFailures value for this UserSpecInfo.
     * 
     * @param maxRBAIPAuthFailures   * The number of consecutive RBA IP authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAIPAuthFailures(int maxRBAIPAuthFailures) {
        this.maxRBAIPAuthFailures = maxRBAIPAuthFailures;
    }


    /**
     * Gets the maxRBAMachineAuthFailures value for this UserSpecInfo.
     * 
     * @return maxRBAMachineAuthFailures   * The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxRBAMachineAuthFailures() {
        return maxRBAMachineAuthFailures;
    }


    /**
     * Sets the maxRBAMachineAuthFailures value for this UserSpecInfo.
     * 
     * @param maxRBAMachineAuthFailures   * The number of consecutive RBA Machine authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAMachineAuthFailures(int maxRBAMachineAuthFailures) {
        this.maxRBAMachineAuthFailures = maxRBAMachineAuthFailures;
    }


    /**
     * Gets the maxRBACertificateAuthFailures value for this UserSpecInfo.
     * 
     * @return maxRBACertificateAuthFailures   * The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxRBACertificateAuthFailures() {
        return maxRBACertificateAuthFailures;
    }


    /**
     * Sets the maxRBACertificateAuthFailures value for this UserSpecInfo.
     * 
     * @param maxRBACertificateAuthFailures   * The number of consecutive RBA Certificate authentication 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBACertificateAuthFailures(int maxRBACertificateAuthFailures) {
        this.maxRBACertificateAuthFailures = maxRBACertificateAuthFailures;
    }


    /**
     * Gets the maxRBAExternalRiskAuthFailures value for this UserSpecInfo.
     * 
     * @return maxRBAExternalRiskAuthFailures   * The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getMaxRBAExternalRiskAuthFailures() {
        return maxRBAExternalRiskAuthFailures;
    }


    /**
     * Sets the maxRBAExternalRiskAuthFailures value for this UserSpecInfo.
     * 
     * @param maxRBAExternalRiskAuthFailures   * The number of consecutive RBA external risk authentication
     * 
     *                                 failures allowed before a user is
     * locked out. A value 
     *                                 of 0 means the user is never locked
     * out, no matter 
     *                                 how many times they fail to authenticate.
     * This policy is used with the ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setMaxRBAExternalRiskAuthFailures(int maxRBAExternalRiskAuthFailures) {
        this.maxRBAExternalRiskAuthFailures = maxRBAExternalRiskAuthFailures;
    }


    /**
     * Gets the lockoutTime value for this UserSpecInfo.
     * 
     * @return lockoutTime   * The number of minutes a user remains locked out. A value
     *                                 of 0 means the user remains locked
     * out until unlocked by an
     *                                 administrator.
     *                                 This policy is used with the GLOBAL,
     * ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public int getLockoutTime() {
        return lockoutTime;
    }


    /**
     * Sets the lockoutTime value for this UserSpecInfo.
     * 
     * @param lockoutTime   * The number of minutes a user remains locked out. A value
     *                                 of 0 means the user remains locked
     * out until unlocked by an
     *                                 administrator.
     *                                 This policy is used with the GLOBAL,
     * ALL_AUTHENTICATOR and
     *                                 PER_AUTHENTICATOR lockout modes.
     */
    public void setLockoutTime(int lockoutTime) {
        this.lockoutTime = lockoutTime;
    }


    /**
     * Gets the maxSecretSize value for this UserSpecInfo.
     * 
     * @return maxSecretSize   * The maximum size of the shared secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that users are not allowed to have
     * shared
     *                                 secrets.
     */
    public int getMaxSecretSize() {
        return maxSecretSize;
    }


    /**
     * Sets the maxSecretSize value for this UserSpecInfo.
     * 
     * @param maxSecretSize   * The maximum size of the shared secrets
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that users are not allowed to have
     * shared
     *                                 secrets.
     */
    public void setMaxSecretSize(int maxSecretSize) {
        this.maxSecretSize = maxSecretSize;
    }


    /**
     * Gets the maxSecretNumber value for this UserSpecInfo.
     * 
     * @return maxSecretNumber   * The maximum number of shared secrets for
     *                                 a user. A value of 0 means that users
     * are
     *                                 not allowed to have shared secrets.
     */
    public int getMaxSecretNumber() {
        return maxSecretNumber;
    }


    /**
     * Sets the maxSecretNumber value for this UserSpecInfo.
     * 
     * @param maxSecretNumber   * The maximum number of shared secrets for
     *                                 a user. A value of 0 means that users
     * are
     *                                 not allowed to have shared secrets.
     */
    public void setMaxSecretNumber(int maxSecretNumber) {
        this.maxSecretNumber = maxSecretNumber;
    }


    /**
     * Gets the genericAuthType value for this UserSpecInfo.
     * 
     * @return genericAuthType   * The type of authentications that can be
     *                                 used for generic authentication operations
     * with a normal security level.
     */
    public AuthenticationType[] getGenericAuthType() {
        return genericAuthType;
    }


    /**
     * Sets the genericAuthType value for this UserSpecInfo.
     * 
     * @param genericAuthType   * The type of authentications that can be
     *                                 used for generic authentication operations
     * with a normal security level.
     */
    public void setGenericAuthType(AuthenticationType[] genericAuthType) {
        this.genericAuthType = genericAuthType;
    }


    /**
     * Gets the enhancedGenericAuthType value for this UserSpecInfo.
     * 
     * @return enhancedGenericAuthType   * The type of authentications that can be
     *                                 used for generic authentication operations
     * with an enhanced security level.
     */
    public AuthenticationType[] getEnhancedGenericAuthType() {
        return enhancedGenericAuthType;
    }


    /**
     * Sets the enhancedGenericAuthType value for this UserSpecInfo.
     * 
     * @param enhancedGenericAuthType   * The type of authentications that can be
     *                                 used for generic authentication operations
     * with an enhanced security level.
     */
    public void setEnhancedGenericAuthType(AuthenticationType[] enhancedGenericAuthType) {
        this.enhancedGenericAuthType = enhancedGenericAuthType;
    }


    /**
     * Gets the machineAuthType value for this UserSpecInfo.
     * 
     * @return machineAuthType   * The type of authentications that can be
     *                                 used for machine registration
     *                                 authentication operations.
     */
    public AuthenticationType[] getMachineAuthType() {
        return machineAuthType;
    }


    /**
     * Sets the machineAuthType value for this UserSpecInfo.
     * 
     * @param machineAuthType   * The type of authentications that can be
     *                                 used for machine registration
     *                                 authentication operations.
     */
    public void setMachineAuthType(AuthenticationType[] machineAuthType) {
        this.machineAuthType = machineAuthType;
    }


    /**
     * Gets the authTypeCanViewSecrets value for this UserSpecInfo.
     * 
     * @return authTypeCanViewSecrets   * The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     */
    public AuthenticationType[] getAuthTypeCanViewSecrets() {
        return authTypeCanViewSecrets;
    }


    /**
     * Sets the authTypeCanViewSecrets value for this UserSpecInfo.
     * 
     * @param authTypeCanViewSecrets   * The type of authentications that can view
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     */
    public void setAuthTypeCanViewSecrets(AuthenticationType[] authTypeCanViewSecrets) {
        this.authTypeCanViewSecrets = authTypeCanViewSecrets;
    }


    /**
     * Gets the authTypeCanModifySecrets value for this UserSpecInfo.
     * 
     * @return authTypeCanModifySecrets   * The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     */
    public AuthenticationType[] getAuthTypeCanModifySecrets() {
        return authTypeCanModifySecrets;
    }


    /**
     * Sets the authTypeCanModifySecrets value for this UserSpecInfo.
     * 
     * @param authTypeCanModifySecrets   * The type of authentications that can modify
     *                                 mutual authentication secrets and
     * shared secrets
     *                                 during authentication operations.
     */
    public void setAuthTypeCanModifySecrets(AuthenticationType[] authTypeCanModifySecrets) {
        this.authTypeCanModifySecrets = authTypeCanModifySecrets;
    }


    /**
     * Gets the maxMachineSecrets value for this UserSpecInfo.
     * 
     * @return maxMachineSecrets   * The maximum number of machine secrets for
     *                                 a user. A value of 0 means that no
     * machine
     *                                 secrets can be stored.
     */
    public int getMaxMachineSecrets() {
        return maxMachineSecrets;
    }


    /**
     * Sets the maxMachineSecrets value for this UserSpecInfo.
     * 
     * @param maxMachineSecrets   * The maximum number of machine secrets for
     *                                 a user. A value of 0 means that no
     * machine
     *                                 secrets can be stored.
     */
    public void setMaxMachineSecrets(int maxMachineSecrets) {
        this.maxMachineSecrets = maxMachineSecrets;
    }


    /**
     * Gets the maxMachineSecretsSize value for this UserSpecInfo.
     * 
     * @return maxMachineSecretsSize   * The maximum size of a single machine secret
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored.
     */
    public int getMaxMachineSecretsSize() {
        return maxMachineSecretsSize;
    }


    /**
     * Sets the maxMachineSecretsSize value for this UserSpecInfo.
     * 
     * @param maxMachineSecretsSize   * The maximum size of a single machine secret
     *                                 for a user, in kilobytes. A value
     * of 0 means
     *                                 that no machine secrets can be stored.
     */
    public void setMaxMachineSecretsSize(int maxMachineSecretsSize) {
        this.maxMachineSecretsSize = maxMachineSecretsSize;
    }


    /**
     * Gets the machineSecretRequiresMachineNonce value for this UserSpecInfo.
     * 
     * @return machineSecretRequiresMachineNonce   * A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              If this flag is false, the
     *                              machineSecretRequiresAppData setting
     * will be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * will be 0.
     */
    public boolean isMachineSecretRequiresMachineNonce() {
        return machineSecretRequiresMachineNonce;
    }


    /**
     * Sets the machineSecretRequiresMachineNonce value for this UserSpecInfo.
     * 
     * @param machineSecretRequiresMachineNonce   * A flag indicating if machine secrets must
     *                              contain the machine nonce when used for
     * authentication.
     *                              If this flag is false, the
     *                              machineSecretRequiresAppData setting
     * will be
     *                              greater than 0, and the
     *                              machineSecretAllowsBadAppData setting
     * will be 0.
     */
    public void setMachineSecretRequiresMachineNonce(boolean machineSecretRequiresMachineNonce) {
        this.machineSecretRequiresMachineNonce = machineSecretRequiresMachineNonce;
    }


    /**
     * Gets the machineSecretRequiresSequenceNonce value for this UserSpecInfo.
     * 
     * @return machineSecretRequiresSequenceNonce   * A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication.
     */
    public boolean isMachineSecretRequiresSequenceNonce() {
        return machineSecretRequiresSequenceNonce;
    }


    /**
     * Sets the machineSecretRequiresSequenceNonce value for this UserSpecInfo.
     * 
     * @param machineSecretRequiresSequenceNonce   * A flag indicating if machine secrets must
     *                                 contain the sequence nonce when used
     * for authentication.
     */
    public void setMachineSecretRequiresSequenceNonce(boolean machineSecretRequiresSequenceNonce) {
        this.machineSecretRequiresSequenceNonce = machineSecretRequiresSequenceNonce;
    }


    /**
     * Gets the machineSecretRequiresAppData value for this UserSpecInfo.
     * 
     * @return machineSecretRequiresAppData   * A count indicating how many application data
     *                                 values must be contained in a machine
     * secret
     *                                 used for authentication.
     */
    public int getMachineSecretRequiresAppData() {
        return machineSecretRequiresAppData;
    }


    /**
     * Sets the machineSecretRequiresAppData value for this UserSpecInfo.
     * 
     * @param machineSecretRequiresAppData   * A count indicating how many application data
     *                                 values must be contained in a machine
     * secret
     *                                 used for authentication.
     */
    public void setMachineSecretRequiresAppData(int machineSecretRequiresAppData) {
        this.machineSecretRequiresAppData = machineSecretRequiresAppData;
    }


    /**
     * Gets the machineSecretAllowsBadAppData value for this UserSpecInfo.
     * 
     * @return machineSecretAllowsBadAppData   * A count indicating how many application data
     *                                 values in a machine secret being used
     * for
     *                                 authentication can be bad before
     *                                 validation fails.
     */
    public int getMachineSecretAllowsBadAppData() {
        return machineSecretAllowsBadAppData;
    }


    /**
     * Sets the machineSecretAllowsBadAppData value for this UserSpecInfo.
     * 
     * @param machineSecretAllowsBadAppData   * A count indicating how many application data
     *                                 values in a machine secret being used
     * for
     *                                 authentication can be bad before
     *                                 validation fails.
     */
    public void setMachineSecretAllowsBadAppData(int machineSecretAllowsBadAppData) {
        this.machineSecretAllowsBadAppData = machineSecretAllowsBadAppData;
    }


    /**
     * Gets the machineSecretLifetime value for this UserSpecInfo.
     * 
     * @return machineSecretLifetime   * Machine secret lifetime in hours. A value of 0
     *                                 means an infinite lifetime.
     */
    public int getMachineSecretLifetime() {
        return machineSecretLifetime;
    }


    /**
     * Sets the machineSecretLifetime value for this UserSpecInfo.
     * 
     * @param machineSecretLifetime   * Machine secret lifetime in hours. A value of 0
     *                                 means an infinite lifetime.
     */
    public void setMachineSecretLifetime(int machineSecretLifetime) {
        this.machineSecretLifetime = machineSecretLifetime;
    }


    /**
     * Gets the failedMachineAuthIncrementsLockout value for this UserSpecInfo.
     * 
     * @return failedMachineAuthIncrementsLockout   * A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed.
     */
    public boolean isFailedMachineAuthIncrementsLockout() {
        return failedMachineAuthIncrementsLockout;
    }


    /**
     * Sets the failedMachineAuthIncrementsLockout value for this UserSpecInfo.
     * 
     * @param failedMachineAuthIncrementsLockout   * A flag indicating whether or not a failed machine authentication
     * results in a user's failed login attempt counter for machine
     *                                 authentication being incremented.
     * If this flag is set to
     *                                 true, too many failed machine authentications
     * will cause a
     *                                 user's account to be locked out. This
     * may be problematic if, at
     *                                 the application level, a failed machine
     * authentication is always
     *                                 followed by a second factor authentication,
     * as the user will be
     *                                 locked out by failed machine authentications
     * before they can
     *                                 attempt the maximum number of second
     * factor authentications
     *                                 allowed.
     */
    public void setFailedMachineAuthIncrementsLockout(boolean failedMachineAuthIncrementsLockout) {
        this.failedMachineAuthIncrementsLockout = failedMachineAuthIncrementsLockout;
    }


    /**
     * Gets the maxAuthSecrets value for this UserSpecInfo.
     * 
     * @return maxAuthSecrets   * The maximum number of authentication secrets for
     *                                 a user. A value of 0 means that no
     * authentication secrets can be stored.
     */
    public int getMaxAuthSecrets() {
        return maxAuthSecrets;
    }


    /**
     * Sets the maxAuthSecrets value for this UserSpecInfo.
     * 
     * @param maxAuthSecrets   * The maximum number of authentication secrets for
     *                                 a user. A value of 0 means that no
     * authentication secrets can be stored.
     */
    public void setMaxAuthSecrets(int maxAuthSecrets) {
        this.maxAuthSecrets = maxAuthSecrets;
    }


    /**
     * Gets the maxAuthSecretsSize value for this UserSpecInfo.
     * 
     * @return maxAuthSecretsSize   * The maximum size of authentication secrets for a user,
     *                                 in kilobytes. A value of 0 means that
     * no
     *                                 authentication secrets can be stored.
     */
    public int getMaxAuthSecretsSize() {
        return maxAuthSecretsSize;
    }


    /**
     * Sets the maxAuthSecretsSize value for this UserSpecInfo.
     * 
     * @param maxAuthSecretsSize   * The maximum size of authentication secrets for a user,
     *                                 in kilobytes. A value of 0 means that
     * no
     *                                 authentication secrets can be stored.
     */
    public void setMaxAuthSecretsSize(int maxAuthSecretsSize) {
        this.maxAuthSecretsSize = maxAuthSecretsSize;
    }


    /**
     * Gets the maxQuestions value for this UserSpecInfo.
     * 
     * @return maxQuestions   * The maximum number of question and answer pairs for a
     *                                 user. A value of 0 means that no question
     * and answer pairs can
     *                                 be stored.
     */
    public int getMaxQuestions() {
        return maxQuestions;
    }


    /**
     * Sets the maxQuestions value for this UserSpecInfo.
     * 
     * @param maxQuestions   * The maximum number of question and answer pairs for a
     *                                 user. A value of 0 means that no question
     * and answer pairs can
     *                                 be stored.
     */
    public void setMaxQuestions(int maxQuestions) {
        this.maxQuestions = maxQuestions;
    }


    /**
     * Gets the maxQASize value for this UserSpecInfo.
     * 
     * @return maxQASize   * The maximum size of question and answer (QA) pairs stored for
     * a user,
     *                                 in kilobytes. A value of 0 means that
     * no QA pairs can be stored.
     */
    public int getMaxQASize() {
        return maxQASize;
    }


    /**
     * Sets the maxQASize value for this UserSpecInfo.
     * 
     * @param maxQASize   * The maximum size of question and answer (QA) pairs stored for
     * a user,
     *                                 in kilobytes. A value of 0 means that
     * no QA pairs can be stored.
     */
    public void setMaxQASize(int maxQASize) {
        this.maxQASize = maxQASize;
    }


    /**
     * Gets the QAChallengeSize value for this UserSpecInfo.
     * 
     * @return QAChallengeSize   * The number of questions in a QA challenge.
     */
    public int getQAChallengeSize() {
        return QAChallengeSize;
    }


    /**
     * Sets the QAChallengeSize value for this UserSpecInfo.
     * 
     * @param QAChallengeSize   * The number of questions in a QA challenge.
     */
    public void setQAChallengeSize(int QAChallengeSize) {
        this.QAChallengeSize = QAChallengeSize;
    }


    /**
     * Gets the minQAChallengeSize value for this UserSpecInfo.
     * 
     * @return minQAChallengeSize   * The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default.
     */
    public int getMinQAChallengeSize() {
        return minQAChallengeSize;
    }


    /**
     * Sets the minQAChallengeSize value for this UserSpecInfo.
     * 
     * @param minQAChallengeSize   * The minimum number of questions allowed in a
     *                                 question and answer challenge when
     * the call
     *                                 to obtain such a challenge overrides
     * the
     *                                 default.
     */
    public void setMinQAChallengeSize(int minQAChallengeSize) {
        this.minQAChallengeSize = minQAChallengeSize;
    }


    /**
     * Gets the maxQAChallengeSize value for this UserSpecInfo.
     * 
     * @return maxQAChallengeSize   * The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default.
     */
    public int getMaxQAChallengeSize() {
        return maxQAChallengeSize;
    }


    /**
     * Sets the maxQAChallengeSize value for this UserSpecInfo.
     * 
     * @param maxQAChallengeSize   * The maximum number of questions allowed in a question
     *                                 and answer challenge when the call
     * to obtain such a challenge overrides the
     *                                 default.
     */
    public void setMaxQAChallengeSize(int maxQAChallengeSize) {
        this.maxQAChallengeSize = maxQAChallengeSize;
    }


    /**
     * Gets the disableQAChallengeRetention value for this UserSpecInfo.
     * 
     * @return disableQAChallengeRetention   * If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer.
     */
    public boolean isDisableQAChallengeRetention() {
        return disableQAChallengeRetention;
    }


    /**
     * Sets the disableQAChallengeRetention value for this UserSpecInfo.
     * 
     * @param disableQAChallengeRetention   * If true, challenge retention is disabled for
     *                                 QA challenges.  This means a new challenge
     * will be generated for every challenge request.
     *                                 Note that doing this allows an attacker
     * who
     *                                 knows some of the users answers to
     * request
     *                                 different challenges until they receive
     * a
     *                                 challenge that they can answer.
     */
    public void setDisableQAChallengeRetention(boolean disableQAChallengeRetention) {
        this.disableQAChallengeRetention = disableQAChallengeRetention;
    }


    /**
     * Gets the QAChallengeLifetime value for this UserSpecInfo.
     * 
     * @return QAChallengeLifetime   * Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public int getQAChallengeLifetime() {
        return QAChallengeLifetime;
    }


    /**
     * Sets the QAChallengeLifetime value for this UserSpecInfo.
     * 
     * @param QAChallengeLifetime   * Specifies the QA challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setQAChallengeLifetime(int QAChallengeLifetime) {
        this.QAChallengeLifetime = QAChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedQAChallenge value for this UserSpecInfo.
     * 
     * @return updateLockoutForReplacedQAChallenge   * If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public boolean isUpdateLockoutForReplacedQAChallenge() {
        return updateLockoutForReplacedQAChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedQAChallenge value for this UserSpecInfo.
     * 
     * @param updateLockoutForReplacedQAChallenge   * If true, the lockout count is updated when
     *                                 an existing QA challenge is replaced
     * during a 
     *                                 challenge request either because challenge
     * retention is disabled or because its lifetime
     *                                 has expired.  If false, the lockout
     * count is
     *                                 not updated. The default for this
     * policy is
     *                                 true.
     */
    public void setUpdateLockoutForReplacedQAChallenge(boolean updateLockoutForReplacedQAChallenge) {
        this.updateLockoutForReplacedQAChallenge = updateLockoutForReplacedQAChallenge;
    }


    /**
     * Gets the qaDefaultWrongAnswersAllowed value for this UserSpecInfo.
     * 
     * @return qaDefaultWrongAnswersAllowed   * The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     */
    public int getQaDefaultWrongAnswersAllowed() {
        return qaDefaultWrongAnswersAllowed;
    }


    /**
     * Sets the qaDefaultWrongAnswersAllowed value for this UserSpecInfo.
     * 
     * @param qaDefaultWrongAnswersAllowed   * The default number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     */
    public void setQaDefaultWrongAnswersAllowed(int qaDefaultWrongAnswersAllowed) {
        this.qaDefaultWrongAnswersAllowed = qaDefaultWrongAnswersAllowed;
    }


    /**
     * Gets the qaMaximumWrongAnswersAllowed value for this UserSpecInfo.
     * 
     * @return qaMaximumWrongAnswersAllowed   * The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     */
    public int getQaMaximumWrongAnswersAllowed() {
        return qaMaximumWrongAnswersAllowed;
    }


    /**
     * Sets the qaMaximumWrongAnswersAllowed value for this UserSpecInfo.
     * 
     * @param qaMaximumWrongAnswersAllowed   * The maximum number of wrong answers that are allowed
     *                                 in response to a question and answer
     * challenge and still have
     *                                 the response be considered correct.
     */
    public void setQaMaximumWrongAnswersAllowed(int qaMaximumWrongAnswersAllowed) {
        this.qaMaximumWrongAnswersAllowed = qaMaximumWrongAnswersAllowed;
    }


    /**
     * Gets the qaInexactMatchAllowed value for this UserSpecInfo.
     * 
     * @return qaInexactMatchAllowed   * Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge.
     */
    public boolean isQaInexactMatchAllowed() {
        return qaInexactMatchAllowed;
    }


    /**
     * Sets the qaInexactMatchAllowed value for this UserSpecInfo.
     * 
     * @param qaInexactMatchAllowed   * Flag indicating if word substitutions can be used when comparing
     * the answer
     *                                 and response in a question and answer
     * challenge.
     */
    public void setQaInexactMatchAllowed(boolean qaInexactMatchAllowed) {
        this.qaInexactMatchAllowed = qaInexactMatchAllowed;
    }


    /**
     * Gets the OTPCellAlphabet value for this UserSpecInfo.
     * 
     * @return OTPCellAlphabet   * The characters that can appear in a one-time password (OTP).
     */
    public String[] getOTPCellAlphabet() {
        return OTPCellAlphabet;
    }


    /**
     * Sets the OTPCellAlphabet value for this UserSpecInfo.
     * 
     * @param OTPCellAlphabet   * The characters that can appear in a one-time password (OTP).
     */
    public void setOTPCellAlphabet(String[] OTPCellAlphabet) {
        this.OTPCellAlphabet = OTPCellAlphabet;
    }


    /**
     * Gets the OTPCellReplacements value for this UserSpecInfo.
     * 
     * @return OTPCellReplacements   * A list of characters that are replaced in a one-time password
     * (OTP) response before it is validated.
     */
    public CellReplacement[] getOTPCellReplacements() {
        return OTPCellReplacements;
    }


    /**
     * Sets the OTPCellReplacements value for this UserSpecInfo.
     * 
     * @param OTPCellReplacements   * A list of characters that are replaced in a one-time password
     * (OTP) response before it is validated.
     */
    public void setOTPCellReplacements(CellReplacement[] OTPCellReplacements) {
        this.OTPCellReplacements = OTPCellReplacements;
    }


    /**
     * Gets the OTPLifetime value for this UserSpecInfo.
     * 
     * @return OTPLifetime   * The lifetime in seconds of a one-time password (OTP). A value
     * of
     *                                 0 means an infinite lifetime.
     */
    public int getOTPLifetime() {
        return OTPLifetime;
    }


    /**
     * Sets the OTPLifetime value for this UserSpecInfo.
     * 
     * @param OTPLifetime   * The lifetime in seconds of a one-time password (OTP). A value
     * of
     *                                 0 means an infinite lifetime.
     */
    public void setOTPLifetime(int OTPLifetime) {
        this.OTPLifetime = OTPLifetime;
    }


    /**
     * Gets the OTPLength value for this UserSpecInfo.
     * 
     * @return OTPLength   * The number of characters in a one-time password (OTP).
     */
    public int getOTPLength() {
        return OTPLength;
    }


    /**
     * Sets the OTPLength value for this UserSpecInfo.
     * 
     * @param OTPLength   * The number of characters in a one-time password (OTP).
     */
    public void setOTPLength(int OTPLength) {
        this.OTPLength = OTPLength;
    }


    /**
     * Gets the OTPDeliveryEnabled value for this UserSpecInfo.
     * 
     * @return OTPDeliveryEnabled   * Flag indicating if a user's one-time password (OTP)
     *                                 can be delivered via an out-of-band
     * delivery mechanism.
     */
    public boolean isOTPDeliveryEnabled() {
        return OTPDeliveryEnabled;
    }


    /**
     * Sets the OTPDeliveryEnabled value for this UserSpecInfo.
     * 
     * @param OTPDeliveryEnabled   * Flag indicating if a user's one-time password (OTP)
     *                                 can be delivered via an out-of-band
     * delivery mechanism.
     */
    public void setOTPDeliveryEnabled(boolean OTPDeliveryEnabled) {
        this.OTPDeliveryEnabled = OTPDeliveryEnabled;
    }


    /**
     * Gets the OTPAlwaysGenerate value for this UserSpecInfo.
     * 
     * @return OTPAlwaysGenerate   * Flag indicating if a new OTP is generated
     *                                 for each challenge request.  If set
     * to false,
     *                                 a new OTP is generated only if there
     * is no
     *                                 existing OTP or the current OTP is
     * expired.
     */
    public boolean isOTPAlwaysGenerate() {
        return OTPAlwaysGenerate;
    }


    /**
     * Sets the OTPAlwaysGenerate value for this UserSpecInfo.
     * 
     * @param OTPAlwaysGenerate   * Flag indicating if a new OTP is generated
     *                                 for each challenge request.  If set
     * to false,
     *                                 a new OTP is generated only if there
     * is no
     *                                 existing OTP or the current OTP is
     * expired.
     */
    public void setOTPAlwaysGenerate(boolean OTPAlwaysGenerate) {
        this.OTPAlwaysGenerate = OTPAlwaysGenerate;
    }


    /**
     * Gets the OTPDynamicRefresh value for this UserSpecInfo.
     * 
     * @return OTPDynamicRefresh   * Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested.
     */
    public boolean isOTPDynamicRefresh() {
        return OTPDynamicRefresh;
    }


    /**
     * Sets the OTPDynamicRefresh value for this UserSpecInfo.
     * 
     * @param OTPDynamicRefresh   * Flag indicating if OTP dynamic refresh
     *                                 is enabled.  If set to true, new OTPs
     * are
     *                                 automatically generated after authentication.
     * If set to false, new OTPs are generated as
     *                                 necessary when an OTP challenge is
     * requested.
     */
    public void setOTPDynamicRefresh(boolean OTPDynamicRefresh) {
        this.OTPDynamicRefresh = OTPDynamicRefresh;
    }


    /**
     * Gets the OTPNumberOutstanding value for this UserSpecInfo.
     * 
     * @return OTPNumberOutstanding   * Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer.
     */
    public int getOTPNumberOutstanding() {
        return OTPNumberOutstanding;
    }


    /**
     * Sets the OTPNumberOutstanding value for this UserSpecInfo.
     * 
     * @param OTPNumberOutstanding   * Number of outstanding OTPs allowed for users.
     *                                 The value must be a positive integer.
     */
    public void setOTPNumberOutstanding(int OTPNumberOutstanding) {
        this.OTPNumberOutstanding = OTPNumberOutstanding;
    }


    /**
     * Gets the OTPRefreshThreshold value for this UserSpecInfo.
     * 
     * @return OTPRefreshThreshold   * When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy.
     */
    public int getOTPRefreshThreshold() {
        return OTPRefreshThreshold;
    }


    /**
     * Sets the OTPRefreshThreshold value for this UserSpecInfo.
     * 
     * @param OTPRefreshThreshold   * When the number of OTPs below the number
     *                                 outstanding reaches the specified
     * threshold,
     *                                 new OTPs are generated.  This value
     * must
     *                                 be a positive integer not exceeding
     * the
     *                                 OTPNumberOutstanding policy.
     */
    public void setOTPRefreshThreshold(int OTPRefreshThreshold) {
        this.OTPRefreshThreshold = OTPRefreshThreshold;
    }


    /**
     * Gets the returnAuthSecretWithChall value for this UserSpecInfo.
     * 
     * @return returnAuthSecretWithChall   * Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge.
     */
    public boolean isReturnAuthSecretWithChall() {
        return returnAuthSecretWithChall;
    }


    /**
     * Sets the returnAuthSecretWithChall value for this UserSpecInfo.
     * 
     * @param returnAuthSecretWithChall   * Flag indicating if mutual authentication secrets can
     *                                 be returned with a challenge.
     */
    public void setReturnAuthSecretWithChall(boolean returnAuthSecretWithChall) {
        this.returnAuthSecretWithChall = returnAuthSecretWithChall;
    }


    /**
     * Gets the autoUnassignTokens value for this UserSpecInfo.
     * 
     * @return autoUnassignTokens   * Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is
     *                                 deleted.
     */
    public boolean isAutoUnassignTokens() {
        return autoUnassignTokens;
    }


    /**
     * Sets the autoUnassignTokens value for this UserSpecInfo.
     * 
     * @param autoUnassignTokens   * Flag indicating if user tokens are automatically
     *                                 unassigned when the user they belong
     * to is
     *                                 deleted.
     */
    public void setAutoUnassignTokens(boolean autoUnassignTokens) {
        this.autoUnassignTokens = autoUnassignTokens;
    }


    /**
     * Gets the autoMoveTokens value for this UserSpecInfo.
     * 
     * @return autoMoveTokens   * Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group.
     */
    public boolean isAutoMoveTokens() {
        return autoMoveTokens;
    }


    /**
     * Sets the autoMoveTokens value for this UserSpecInfo.
     * 
     * @param autoMoveTokens   * Flag indicating if tokens are automatically
     *                                 moved to the user's group during assignment.
     * The administrator requires access to both
     *                                 groups and the tokenSet permission
     * in order
     *                                 to move the token to the user's group.
     */
    public void setAutoMoveTokens(boolean autoMoveTokens) {
        this.autoMoveTokens = autoMoveTokens;
    }


    /**
     * Gets the disableTokenChallengeRetention value for this UserSpecInfo.
     * 
     * @return disableTokenChallengeRetention   * If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request.
     */
    public boolean isDisableTokenChallengeRetention() {
        return disableTokenChallengeRetention;
    }


    /**
     * Sets the disableTokenChallengeRetention value for this UserSpecInfo.
     * 
     * @param disableTokenChallengeRetention   * If true, challenge retention is disabled for
     *                                 TOKENCR challenges.  This means a
     * new challenge
     *                                 will be generated for every challenge
     * request.
     */
    public void setDisableTokenChallengeRetention(boolean disableTokenChallengeRetention) {
        this.disableTokenChallengeRetention = disableTokenChallengeRetention;
    }


    /**
     * Gets the tokenChallengeLifetime value for this UserSpecInfo.
     * 
     * @return tokenChallengeLifetime   * Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public int getTokenChallengeLifetime() {
        return tokenChallengeLifetime;
    }


    /**
     * Sets the tokenChallengeLifetime value for this UserSpecInfo.
     * 
     * @param tokenChallengeLifetime   * Specifies the TOKENCR challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setTokenChallengeLifetime(int tokenChallengeLifetime) {
        this.tokenChallengeLifetime = tokenChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedTokenChallenge value for this UserSpecInfo.
     * 
     * @return updateLockoutForReplacedTokenChallenge   * If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public boolean isUpdateLockoutForReplacedTokenChallenge() {
        return updateLockoutForReplacedTokenChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedTokenChallenge value for this UserSpecInfo.
     * 
     * @param updateLockoutForReplacedTokenChallenge   * If true, the lockout count is updated when
     *                                 an existing TOKENCR challenge is replaced
     * during a challenge request either because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public void setUpdateLockoutForReplacedTokenChallenge(boolean updateLockoutForReplacedTokenChallenge) {
        this.updateLockoutForReplacedTokenChallenge = updateLockoutForReplacedTokenChallenge;
    }


    /**
     * Gets the maxAllowedTokenSets value for this UserSpecInfo.
     * 
     * @return maxAllowedTokenSets   * The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer.
     */
    public int getMaxAllowedTokenSets() {
        return maxAllowedTokenSets;
    }


    /**
     * Sets the maxAllowedTokenSets value for this UserSpecInfo.
     * 
     * @param maxAllowedTokenSets   * The maximum number of allowed token sets
     *                                 for users with this policy.  The value
     * must
     *                                 be a positive integer.
     */
    public void setMaxAllowedTokenSets(int maxAllowedTokenSets) {
        this.maxAllowedTokenSets = maxAllowedTokenSets;
    }


    /**
     * Gets the allowNONEAuthentication value for this UserSpecInfo.
     * 
     * @return allowNONEAuthentication   * Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request.
     */
    public boolean isAllowNONEAuthentication() {
        return allowNONEAuthentication;
    }


    /**
     * Sets the allowNONEAuthentication value for this UserSpecInfo.
     * 
     * @param allowNONEAuthentication   * Flag indicating if the NONE authentication
     *                                 type can be used when performing an
     * authentication request.
     */
    public void setAllowNONEAuthentication(boolean allowNONEAuthentication) {
        this.allowNONEAuthentication = allowNONEAuthentication;
    }


    /**
     * Gets the considerTempPINLast value for this UserSpecInfo.
     * 
     * @return considerTempPINLast   * Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type.
     */
    public boolean isConsiderTempPINLast() {
        return considerTempPINLast;
    }


    /**
     * Sets the considerTempPINLast value for this UserSpecInfo.
     * 
     * @param considerTempPINLast   * Flag indicating if the temporary PIN is
     *                                 considered last when Entrust IdentityGuard
     * is selecting a user's authentication type.
     */
    public void setConsiderTempPINLast(boolean considerTempPINLast) {
        this.considerTempPINLast = considerTempPINLast;
    }


    /**
     * Gets the storeLastAuthInfo value for this UserSpecInfo.
     * 
     * @return storeLastAuthInfo   * Flag indicating if information about the
     *                                 last authentication for a user is
     * stored.
     */
    public boolean isStoreLastAuthInfo() {
        return storeLastAuthInfo;
    }


    /**
     * Sets the storeLastAuthInfo value for this UserSpecInfo.
     * 
     * @param storeLastAuthInfo   * Flag indicating if information about the
     *                                 last authentication for a user is
     * stored.
     */
    public void setStoreLastAuthInfo(boolean storeLastAuthInfo) {
        this.storeLastAuthInfo = storeLastAuthInfo;
    }


    /**
     * Gets the allowCreateIfDisabledInRepository value for this UserSpecInfo.
     * 
     * @return allowCreateIfDisabledInRepository   * Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public boolean isAllowCreateIfDisabledInRepository() {
        return allowCreateIfDisabledInRepository;
    }


    /**
     * Sets the allowCreateIfDisabledInRepository value for this UserSpecInfo.
     * 
     * @param allowCreateIfDisabledInRepository   * Flag indicating if repository entries that are
     *                                 disabled can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 disabled repository entries will be
     * skipped over
     *                                 during user creation. If true, disabled
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public void setAllowCreateIfDisabledInRepository(boolean allowCreateIfDisabledInRepository) {
        this.allowCreateIfDisabledInRepository = allowCreateIfDisabledInRepository;
    }


    /**
     * Gets the allowCreateIfExpiredInRepository value for this UserSpecInfo.
     * 
     * @return allowCreateIfExpiredInRepository   * Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public boolean isAllowCreateIfExpiredInRepository() {
        return allowCreateIfExpiredInRepository;
    }


    /**
     * Sets the allowCreateIfExpiredInRepository value for this UserSpecInfo.
     * 
     * @param allowCreateIfExpiredInRepository   * Flag indicating if repository entries that are
     *                                 expired can be used to create Entrust
     * IdentityGuard users. If false (the default),
     *                                 expired repository entries will be
     * skipped over
     *                                 during user creation. If true, expired
     * repository entries may be used to store the
     *                                 Entrust IdentityGuard user data.
     */
    public void setAllowCreateIfExpiredInRepository(boolean allowCreateIfExpiredInRepository) {
        this.allowCreateIfExpiredInRepository = allowCreateIfExpiredInRepository;
    }


    /**
     * Gets the allowAuthIfDisabledInRepository value for this UserSpecInfo.
     * 
     * @return allowAuthIfDisabledInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public boolean isAllowAuthIfDisabledInRepository() {
        return allowAuthIfDisabledInRepository;
    }


    /**
     * Sets the allowAuthIfDisabledInRepository value for this UserSpecInfo.
     * 
     * @param allowAuthIfDisabledInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is disabled.
     *                                 If false (the default), users with
     * a disabled
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public void setAllowAuthIfDisabledInRepository(boolean allowAuthIfDisabledInRepository) {
        this.allowAuthIfDisabledInRepository = allowAuthIfDisabledInRepository;
    }


    /**
     * Gets the allowAuthIfExpiredInRepository value for this UserSpecInfo.
     * 
     * @return allowAuthIfExpiredInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public boolean isAllowAuthIfExpiredInRepository() {
        return allowAuthIfExpiredInRepository;
    }


    /**
     * Sets the allowAuthIfExpiredInRepository value for this UserSpecInfo.
     * 
     * @param allowAuthIfExpiredInRepository   * Flag indicating if an Entrust IdentityGuard
     *                                 user can perform authentication operations
     * when their repository entry is expired.
     *                                 If false (the default), users with
     * an expired
     *                                 repository entry cannot authenticate
     * and any
     *                                 attempt to authenticate will fail.
     */
    public void setAllowAuthIfExpiredInRepository(boolean allowAuthIfExpiredInRepository) {
        this.allowAuthIfExpiredInRepository = allowAuthIfExpiredInRepository;
    }


    /**
     * Gets the transactionSignatureType value for this UserSpecInfo.
     * 
     * @return transactionSignatureType   * Specifies how transaction receipts are signed.
     */
    public com.good.adapters.entrust.stubs.TransactionSignatureType getTransactionSignatureType() {
        return transactionSignatureType;
    }


    /**
     * Sets the transactionSignatureType value for this UserSpecInfo.
     * 
     * @param transactionSignatureType   * Specifies how transaction receipts are signed.
     */
    public void setTransactionSignatureType(com.good.adapters.entrust.stubs.TransactionSignatureType transactionSignatureType) {
        this.transactionSignatureType = transactionSignatureType;
    }


    /**
     * Gets the transactionLifetime value for this UserSpecInfo.
     * 
     * @return transactionLifetime   * Specifies the lifetime of a transaction in
     *                                 seconds.
     */
    public int getTransactionLifetime() {
        return transactionLifetime;
    }


    /**
     * Sets the transactionLifetime value for this UserSpecInfo.
     * 
     * @param transactionLifetime   * Specifies the lifetime of a transaction in
     *                                 seconds.
     */
    public void setTransactionLifetime(int transactionLifetime) {
        this.transactionLifetime = transactionLifetime;
    }


    /**
     * Gets the maxNumTransactionDetails value for this UserSpecInfo.
     * 
     * @return maxNumTransactionDetails   * Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction.
     */
    public int getMaxNumTransactionDetails() {
        return maxNumTransactionDetails;
    }


    /**
     * Sets the maxNumTransactionDetails value for this UserSpecInfo.
     * 
     * @param maxNumTransactionDetails   * Specifies the maximum number of transaction
     *                                 details that can be specified for
     * a
     *                                 transaction.
     */
    public void setMaxNumTransactionDetails(int maxNumTransactionDetails) {
        this.maxNumTransactionDetails = maxNumTransactionDetails;
    }


    /**
     * Gets the allowSelfSignedUserCert value for this UserSpecInfo.
     * 
     * @return allowSelfSignedUserCert   * Specifies if self-signed user certificates
     *                                 can be assigned to a user.
     */
    public boolean isAllowSelfSignedUserCert() {
        return allowSelfSignedUserCert;
    }


    /**
     * Sets the allowSelfSignedUserCert value for this UserSpecInfo.
     * 
     * @param allowSelfSignedUserCert   * Specifies if self-signed user certificates
     *                                 can be assigned to a user.
     */
    public void setAllowSelfSignedUserCert(boolean allowSelfSignedUserCert) {
        this.allowSelfSignedUserCert = allowSelfSignedUserCert;
    }


    /**
     * Gets the allowCertNotIssuedByRegisteredCA value for this UserSpecInfo.
     * 
     * @return allowCertNotIssuedByRegisteredCA   * Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user.
     */
    public boolean isAllowCertNotIssuedByRegisteredCA() {
        return allowCertNotIssuedByRegisteredCA;
    }


    /**
     * Sets the allowCertNotIssuedByRegisteredCA value for this UserSpecInfo.
     * 
     * @param allowCertNotIssuedByRegisteredCA   * Specifies if a user certificate that isn't
     *                                 self-signed but not issued by a CA
     * registered
     *                                 with Entrust IdentityGuard can be
     *                                 can be assigned to a user.
     */
    public void setAllowCertNotIssuedByRegisteredCA(boolean allowCertNotIssuedByRegisteredCA) {
        this.allowCertNotIssuedByRegisteredCA = allowCertNotIssuedByRegisteredCA;
    }


    /**
     * Gets the allowAllRegisteredCAs value for this UserSpecInfo.
     * 
     * @return allowAllRegisteredCAs   * Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user.
     */
    public boolean isAllowAllRegisteredCAs() {
        return allowAllRegisteredCAs;
    }


    /**
     * Sets the allowAllRegisteredCAs value for this UserSpecInfo.
     * 
     * @param allowAllRegisteredCAs   * Specifies that user certificates issued by
     *                                 any CA registered with Entrust IdentityGuard
     * can be assigned to a user.
     */
    public void setAllowAllRegisteredCAs(boolean allowAllRegisteredCAs) {
        this.allowAllRegisteredCAs = allowAllRegisteredCAs;
    }


    /**
     * Gets the allowedRegisteredCAs value for this UserSpecInfo.
     * 
     * @return allowedRegisteredCAs   * User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedRegisteredCAs() {
        return allowedRegisteredCAs;
    }


    /**
     * Sets the allowedRegisteredCAs value for this UserSpecInfo.
     * 
     * @param allowedRegisteredCAs   * User certificates issued by the specified
     *                                 registered CAs can be assigned to
     * a user.
     *                                 If the AllowAllRegisteredCAs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedRegisteredCAs(String[] allowedRegisteredCAs) {
        this.allowedRegisteredCAs = allowedRegisteredCAs;
    }


    /**
     * Gets the allowCertNotIssuedByManagedCA value for this UserSpecInfo.
     * 
     * @return allowCertNotIssuedByManagedCA   * Specifies if a user certificate that is 
     *                                 not issued by a managed CA can be
     * 
     *                                 used to authenticate a user.
     */
    public boolean isAllowCertNotIssuedByManagedCA() {
        return allowCertNotIssuedByManagedCA;
    }


    /**
     * Sets the allowCertNotIssuedByManagedCA value for this UserSpecInfo.
     * 
     * @param allowCertNotIssuedByManagedCA   * Specifies if a user certificate that is 
     *                                 not issued by a managed CA can be
     * 
     *                                 used to authenticate a user.
     */
    public void setAllowCertNotIssuedByManagedCA(boolean allowCertNotIssuedByManagedCA) {
        this.allowCertNotIssuedByManagedCA = allowCertNotIssuedByManagedCA;
    }


    /**
     * Gets the allowAllManagedCAs value for this UserSpecInfo.
     * 
     * @return allowAllManagedCAs   * Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user.
     */
    public boolean isAllowAllManagedCAs() {
        return allowAllManagedCAs;
    }


    /**
     * Sets the allowAllManagedCAs value for this UserSpecInfo.
     * 
     * @param allowAllManagedCAs   * Specifies that user certificates issued by
     *                                 any managed CA can be used to authenticate
     * a user.
     */
    public void setAllowAllManagedCAs(boolean allowAllManagedCAs) {
        this.allowAllManagedCAs = allowAllManagedCAs;
    }


    /**
     * Gets the allowedManagedCAs value for this UserSpecInfo.
     * 
     * @return allowedManagedCAs   * User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedManagedCAs() {
        return allowedManagedCAs;
    }


    /**
     * Sets the allowedManagedCAs value for this UserSpecInfo.
     * 
     * @param allowedManagedCAs   * User certificates issued by the specified
     *                                 managed CAs can be used to authenticate
     * a user.
     *                                 If the AllowAllManagedCAs policy is
     * set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedManagedCAs(String[] allowedManagedCAs) {
        this.allowedManagedCAs = allowedManagedCAs;
    }


    /**
     * Gets the certificateAuthenticationHashAlg value for this UserSpecInfo.
     * 
     * @return certificateAuthenticationHashAlg   * Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256.
     */
    public String getCertificateAuthenticationHashAlg() {
        return certificateAuthenticationHashAlg;
    }


    /**
     * Sets the certificateAuthenticationHashAlg value for this UserSpecInfo.
     * 
     * @param certificateAuthenticationHashAlg   * Specifies the hashing algorithm used
     *                                 for certificate authentication.  Possible
     * values are MD5, SHA-1 and SHA-256.
     */
    public void setCertificateAuthenticationHashAlg(String certificateAuthenticationHashAlg) {
        this.certificateAuthenticationHashAlg = certificateAuthenticationHashAlg;
    }


    /**
     * Gets the certificateAuthenticationChallengeSize value for this UserSpecInfo.
     * 
     * @return certificateAuthenticationChallengeSize   * Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32.
     */
    public int getCertificateAuthenticationChallengeSize() {
        return certificateAuthenticationChallengeSize;
    }


    /**
     * Sets the certificateAuthenticationChallengeSize value for this UserSpecInfo.
     * 
     * @param certificateAuthenticationChallengeSize   * Specifies the size of the certificate
     *                                 authentication challenge.  The value
     * must
     *                                 be between 32 and 1000 and has a default
     * value
     *                                 of 32.
     */
    public void setCertificateAuthenticationChallengeSize(int certificateAuthenticationChallengeSize) {
        this.certificateAuthenticationChallengeSize = certificateAuthenticationChallengeSize;
    }


    /**
     * Gets the maxCertsPerUser value for this UserSpecInfo.
     * 
     * @return maxCertsPerUser   * Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public int getMaxCertsPerUser() {
        return maxCertsPerUser;
    }


    /**
     * Sets the maxCertsPerUser value for this UserSpecInfo.
     * 
     * @param maxCertsPerUser   * Specifies the maximum number of certificates
     *                                 that can be assigned to a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxCertsPerUser(int maxCertsPerUser) {
        this.maxCertsPerUser = maxCertsPerUser;
    }


    /**
     * Gets the autoDeleteUserCerts value for this UserSpecInfo.
     * 
     * @return autoDeleteUserCerts   * A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user.
     */
    public boolean isAutoDeleteUserCerts() {
        return autoDeleteUserCerts;
    }


    /**
     * Sets the autoDeleteUserCerts value for this UserSpecInfo.
     * 
     * @param autoDeleteUserCerts   * A flag indicating whether old user
     *                                 certificates are automatically deleted
     * from
     *                                 a user when the user has reached the
     * maximum
     *                                 number of allowed certificates.  Certificates
     * are only automatically deleted when new
     *                                 certificates are assigned during
     *                                 authentication.  Certificates are
     * not 
     *                                 automatically deleted when new certificates
     * are assigned by an administrator.
     *                                 that can be assigned to a user.
     */
    public void setAutoDeleteUserCerts(boolean autoDeleteUserCerts) {
        this.autoDeleteUserCerts = autoDeleteUserCerts;
    }


    /**
     * Gets the disableCertificateChallengeRetention value for this UserSpecInfo.
     * 
     * @return disableCertificateChallengeRetention   * If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request.
     */
    public boolean isDisableCertificateChallengeRetention() {
        return disableCertificateChallengeRetention;
    }


    /**
     * Sets the disableCertificateChallengeRetention value for this UserSpecInfo.
     * 
     * @param disableCertificateChallengeRetention   * If true, challenge retention is disabled for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge will be generated for every
     * challenge
     *                                 request.
     */
    public void setDisableCertificateChallengeRetention(boolean disableCertificateChallengeRetention) {
        this.disableCertificateChallengeRetention = disableCertificateChallengeRetention;
    }


    /**
     * Gets the certificateChallengeLifetime value for this UserSpecInfo.
     * 
     * @return certificateChallengeLifetime   * Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public int getCertificateChallengeLifetime() {
        return certificateChallengeLifetime;
    }


    /**
     * Sets the certificateChallengeLifetime value for this UserSpecInfo.
     * 
     * @param certificateChallengeLifetime   * Specifies the CERTIFICATE challenge lifetime in
     *                                 seconds.  A value of 0 means infinite
     * lifetime.
     *                                 When requesting a challenge, if the
     * retained challenge has exceeded its lifetime
     *                                 a new challenge is generated.  When
     * authenticating a challenge, if the retained
     *                                 challenge has exceeded its lifetime
     * a
     *                                 USER_NO_CHALLENGE error is returned.
     */
    public void setCertificateChallengeLifetime(int certificateChallengeLifetime) {
        this.certificateChallengeLifetime = certificateChallengeLifetime;
    }


    /**
     * Gets the updateLockoutForReplacedCertificateChallenge value for this UserSpecInfo.
     * 
     * @return updateLockoutForReplacedCertificateChallenge   * If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public boolean isUpdateLockoutForReplacedCertificateChallenge() {
        return updateLockoutForReplacedCertificateChallenge;
    }


    /**
     * Sets the updateLockoutForReplacedCertificateChallenge value for this UserSpecInfo.
     * 
     * @param updateLockoutForReplacedCertificateChallenge   * If true, the lockout count is updated when
     *                                 an existing CERTIFICATE challenge
     * is replaced
     *                                 during a challenge request either
     * because
     *                                 challenge retention is disabled or
     * because its
     *                                 lifetime has expired.  If false, the
     * lockout
     *                                 count is not updated. The default
     * for this
     *                                 policy is true.
     */
    public void setUpdateLockoutForReplacedCertificateChallenge(boolean updateLockoutForReplacedCertificateChallenge) {
        this.updateLockoutForReplacedCertificateChallenge = updateLockoutForReplacedCertificateChallenge;
    }


    /**
     * Gets the allowCertificateChallengeDelivery value for this UserSpecInfo.
     * 
     * @return allowCertificateChallengeDelivery   * If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public boolean isAllowCertificateChallengeDelivery() {
        return allowCertificateChallengeDelivery;
    }


    /**
     * Sets the allowCertificateChallengeDelivery value for this UserSpecInfo.
     * 
     * @param allowCertificateChallengeDelivery   * If true, challenge delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * a new
     *                                 challenge can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public void setAllowCertificateChallengeDelivery(boolean allowCertificateChallengeDelivery) {
        this.allowCertificateChallengeDelivery = allowCertificateChallengeDelivery;
    }


    /**
     * Gets the allowCertificateTransactionDelivery value for this UserSpecInfo.
     * 
     * @return allowCertificateTransactionDelivery   * If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public boolean isAllowCertificateTransactionDelivery() {
        return allowCertificateTransactionDelivery;
    }


    /**
     * Sets the allowCertificateTransactionDelivery value for this UserSpecInfo.
     * 
     * @param allowCertificateTransactionDelivery   * If true, transaction delivery is allowed for
     *                                 CERTIFICATE challenges.  This means
     * transaction
     *                                 details can be deliveried to mobile
     * smart
     *                                 credentials that are registered to
     * receive
     *                                 certificate challenges.
     */
    public void setAllowCertificateTransactionDelivery(boolean allowCertificateTransactionDelivery) {
        this.allowCertificateTransactionDelivery = allowCertificateTransactionDelivery;
    }


    /**
     * Gets the allowCertificateSign value for this UserSpecInfo.
     * 
     * @return allowCertificateSign   * If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges.
     */
    public boolean isAllowCertificateSign() {
        return allowCertificateSign;
    }


    /**
     * Sets the allowCertificateSign value for this UserSpecInfo.
     * 
     * @param allowCertificateSign   * If true, signing operations are allowed
     *                                 for smart credentials supporting certificate
     * challenges.
     */
    public void setAllowCertificateSign(boolean allowCertificateSign) {
        this.allowCertificateSign = allowCertificateSign;
    }


    /**
     * Gets the allowAllSmartCredentialDefinitions value for this UserSpecInfo.
     * 
     * @return allowAllSmartCredentialDefinitions   * Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user.
     */
    public boolean isAllowAllSmartCredentialDefinitions() {
        return allowAllSmartCredentialDefinitions;
    }


    /**
     * Sets the allowAllSmartCredentialDefinitions value for this UserSpecInfo.
     * 
     * @param allowAllSmartCredentialDefinitions   * Specifies that any Smart Credential Definition can be
     *                                 used to create Smart Credentials for
     * a user.
     */
    public void setAllowAllSmartCredentialDefinitions(boolean allowAllSmartCredentialDefinitions) {
        this.allowAllSmartCredentialDefinitions = allowAllSmartCredentialDefinitions;
    }


    /**
     * Gets the allowedSmartCredentialDefinitions value for this UserSpecInfo.
     * 
     * @return allowedSmartCredentialDefinitions   * Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedSmartCredentialDefinitions() {
        return allowedSmartCredentialDefinitions;
    }


    /**
     * Sets the allowedSmartCredentialDefinitions value for this UserSpecInfo.
     * 
     * @param allowedSmartCredentialDefinitions   * Specifies a list of Smart Credential Definitions that can
     *                                 be used to create Smart Credentials
     * for a user.
     *                                 If the AllowAllSmartCredentialDefinitions
     * policy is set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedSmartCredentialDefinitions(String[] allowedSmartCredentialDefinitions) {
        this.allowedSmartCredentialDefinitions = allowedSmartCredentialDefinitions;
    }


    /**
     * Gets the maxSmartCredentialsPerUser value for this UserSpecInfo.
     * 
     * @return maxSmartCredentialsPerUser   * Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public int getMaxSmartCredentialsPerUser() {
        return maxSmartCredentialsPerUser;
    }


    /**
     * Sets the maxSmartCredentialsPerUser value for this UserSpecInfo.
     * 
     * @param maxSmartCredentialsPerUser   * Specifies the maximum number of Smart Credentials
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxSmartCredentialsPerUser(int maxSmartCredentialsPerUser) {
        this.maxSmartCredentialsPerUser = maxSmartCredentialsPerUser;
    }


    /**
     * Gets the smartCredentialIDPrefix value for this UserSpecInfo.
     * 
     * @return smartCredentialIDPrefix   * The prefix added to Smart Credential Ids.
     */
    public String getSmartCredentialIDPrefix() {
        return smartCredentialIDPrefix;
    }


    /**
     * Sets the smartCredentialIDPrefix value for this UserSpecInfo.
     * 
     * @param smartCredentialIDPrefix   * The prefix added to Smart Credential Ids.
     */
    public void setSmartCredentialIDPrefix(String smartCredentialIDPrefix) {
        this.smartCredentialIDPrefix = smartCredentialIDPrefix;
    }


    /**
     * Gets the smartCredentialTokenVendor value for this UserSpecInfo.
     * 
     * @return smartCredentialTokenVendor   * The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation.
     */
    public String getSmartCredentialTokenVendor() {
        return smartCredentialTokenVendor;
    }


    /**
     * Sets the smartCredentialTokenVendor value for this UserSpecInfo.
     * 
     * @param smartCredentialTokenVendor   * The token vendor used when creating a
     *                                 token for the Smart Credential OTP
     * applet.
     *                                 If not set, the default token vendor
     * is
     *                                 used.  The specified token vendor
     * must
     *                                 support token creation.
     */
    public void setSmartCredentialTokenVendor(String smartCredentialTokenVendor) {
        this.smartCredentialTokenVendor = smartCredentialTokenVendor;
    }


    /**
     * Gets the autoUnassignSmartCredentials value for this UserSpecInfo.
     * 
     * @return autoUnassignSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the
     *                                 user they belong to is deleted.
     */
    public boolean isAutoUnassignSmartCredentials() {
        return autoUnassignSmartCredentials;
    }


    /**
     * Sets the autoUnassignSmartCredentials value for this UserSpecInfo.
     * 
     * @param autoUnassignSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically unassigned when they
     * or the
     *                                 user they belong to is deleted.
     */
    public void setAutoUnassignSmartCredentials(boolean autoUnassignSmartCredentials) {
        this.autoUnassignSmartCredentials = autoUnassignSmartCredentials;
    }


    /**
     * Gets the autoCancelSmartCredentials value for this UserSpecInfo.
     * 
     * @return autoCancelSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned.
     */
    public boolean isAutoCancelSmartCredentials() {
        return autoCancelSmartCredentials;
    }


    /**
     * Sets the autoCancelSmartCredentials value for this UserSpecInfo.
     * 
     * @param autoCancelSmartCredentials   * Flag indicating if user smart credentials are
     *                                 automatically canceled when they are
     * deleted
     *                                 or unassigned.
     */
    public void setAutoCancelSmartCredentials(boolean autoCancelSmartCredentials) {
        this.autoCancelSmartCredentials = autoCancelSmartCredentials;
    }


    /**
     * Gets the autoCancelSmartCredentialsForce value for this UserSpecInfo.
     * 
     * @return autoCancelSmartCredentialsForce   * Flag indicating if the force option is applied
     *                                 when smart credentials or auto-canceled.
     * This option only applies if
     *                                 AutoCancelSmartCredentials is true.
     */
    public boolean isAutoCancelSmartCredentialsForce() {
        return autoCancelSmartCredentialsForce;
    }


    /**
     * Sets the autoCancelSmartCredentialsForce value for this UserSpecInfo.
     * 
     * @param autoCancelSmartCredentialsForce   * Flag indicating if the force option is applied
     *                                 when smart credentials or auto-canceled.
     * This option only applies if
     *                                 AutoCancelSmartCredentials is true.
     */
    public void setAutoCancelSmartCredentialsForce(boolean autoCancelSmartCredentialsForce) {
        this.autoCancelSmartCredentialsForce = autoCancelSmartCredentialsForce;
    }


    /**
     * Gets the autoMoveSmartCredentials value for this UserSpecInfo.
     * 
     * @return autoMoveSmartCredentials   * Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group.
     */
    public boolean isAutoMoveSmartCredentials() {
        return autoMoveSmartCredentials;
    }


    /**
     * Sets the autoMoveSmartCredentials value for this UserSpecInfo.
     * 
     * @param autoMoveSmartCredentials   * Flag indicating if smart credentials are
     *                                 automatically moved to the user's
     * group during
     *                                 assignment.
     *                                 The administrator requires access
     * to both
     *                                 groups and the smartCredentialSet
     * permission in
     *                                 order to move the smart credentials
     * to the
     *                                 user's group.
     */
    public void setAutoMoveSmartCredentials(boolean autoMoveSmartCredentials) {
        this.autoMoveSmartCredentials = autoMoveSmartCredentials;
    }


    /**
     * Gets the autoRegisterSmartCredentialsToPACS value for this UserSpecInfo.
     * 
     * @return autoRegisterSmartCredentialsToPACS   * Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued.
     */
    public boolean isAutoRegisterSmartCredentialsToPACS() {
        return autoRegisterSmartCredentialsToPACS;
    }


    /**
     * Sets the autoRegisterSmartCredentialsToPACS value for this UserSpecInfo.
     * 
     * @param autoRegisterSmartCredentialsToPACS   * Flag indicating if smart credentials are
     *                                 automatically registered to PACS if
     * appropriate
     *                                 when they are issued.
     */
    public void setAutoRegisterSmartCredentialsToPACS(boolean autoRegisterSmartCredentialsToPACS) {
        this.autoRegisterSmartCredentialsToPACS = autoRegisterSmartCredentialsToPACS;
    }


    /**
     * Gets the autoSuspendSmartCredentialsFromPACS value for this UserSpecInfo.
     * 
     * @return autoSuspendSmartCredentialsFromPACS   * Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted.
     */
    public boolean isAutoSuspendSmartCredentialsFromPACS() {
        return autoSuspendSmartCredentialsFromPACS;
    }


    /**
     * Sets the autoSuspendSmartCredentialsFromPACS value for this UserSpecInfo.
     * 
     * @param autoSuspendSmartCredentialsFromPACS   * Flag indicating if smart credentials are
     *                                 automatically supsended from PACS
     * if appropriate
     *                                 when they are deleted.
     */
    public void setAutoSuspendSmartCredentialsFromPACS(boolean autoSuspendSmartCredentialsFromPACS) {
        this.autoSuspendSmartCredentialsFromPACS = autoSuspendSmartCredentialsFromPACS;
    }


    /**
     * Gets the allowSoftwareSmartCredentials value for this UserSpecInfo.
     * 
     * @return allowSoftwareSmartCredentials   * Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy.
     */
    public boolean isAllowSoftwareSmartCredentials() {
        return allowSoftwareSmartCredentials;
    }


    /**
     * Sets the allowSoftwareSmartCredentials value for this UserSpecInfo.
     * 
     * @param allowSoftwareSmartCredentials   * Flag indicating if software smart credentials
     *                                 can be activated for users with this
     * policy.
     */
    public void setAllowSoftwareSmartCredentials(boolean allowSoftwareSmartCredentials) {
        this.allowSoftwareSmartCredentials = allowSoftwareSmartCredentials;
    }


    /**
     * Gets the mobileSmartCredentialPINPrompt value for this UserSpecInfo.
     * 
     * @return mobileSmartCredentialPINPrompt   * Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN.
     */
    public PINPromptType getMobileSmartCredentialPINPrompt() {
        return mobileSmartCredentialPINPrompt;
    }


    /**
     * Sets the mobileSmartCredentialPINPrompt value for this UserSpecInfo.
     * 
     * @param mobileSmartCredentialPINPrompt   * Policy indicating how the mobile smart
     *                                 credential applications will prompt
     * the user
     *                                 for their PIN.
     */
    public void setMobileSmartCredentialPINPrompt(PINPromptType mobileSmartCredentialPINPrompt) {
        this.mobileSmartCredentialPINPrompt = mobileSmartCredentialPINPrompt;
    }


    /**
     * Gets the mobileSmartCredentialSessionTimeout value for this UserSpecInfo.
     * 
     * @return mobileSmartCredentialSessionTimeout   * Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION.
     */
    public int getMobileSmartCredentialSessionTimeout() {
        return mobileSmartCredentialSessionTimeout;
    }


    /**
     * Sets the mobileSmartCredentialSessionTimeout value for this UserSpecInfo.
     * 
     * @param mobileSmartCredentialSessionTimeout   * Policy indicating the session timeout after
     *                                 which the mobile smart credential
     * will
     *                                 prompt the user to re-enter their
     * PIN when
     *                                 the Mobile SmartCredential PIN Prompt
     * policy
     *                                 is set to SESSION.
     */
    public void setMobileSmartCredentialSessionTimeout(int mobileSmartCredentialSessionTimeout) {
        this.mobileSmartCredentialSessionTimeout = mobileSmartCredentialSessionTimeout;
    }


    /**
     * Gets the allowAllDigitalIdConfigs value for this UserSpecInfo.
     * 
     * @return allowAllDigitalIdConfigs   * Specifies that any Digital Id Config can be
     *                                 used to create Digital Ids for a user.
     */
    public boolean isAllowAllDigitalIdConfigs() {
        return allowAllDigitalIdConfigs;
    }


    /**
     * Sets the allowAllDigitalIdConfigs value for this UserSpecInfo.
     * 
     * @param allowAllDigitalIdConfigs   * Specifies that any Digital Id Config can be
     *                                 used to create Digital Ids for a user.
     */
    public void setAllowAllDigitalIdConfigs(boolean allowAllDigitalIdConfigs) {
        this.allowAllDigitalIdConfigs = allowAllDigitalIdConfigs;
    }


    /**
     * Gets the allowedDigitalIdConfigs value for this UserSpecInfo.
     * 
     * @return allowedDigitalIdConfigs   * Specifies a list of Digital Id Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public String[] getAllowedDigitalIdConfigs() {
        return allowedDigitalIdConfigs;
    }


    /**
     * Sets the allowedDigitalIdConfigs value for this UserSpecInfo.
     * 
     * @param allowedDigitalIdConfigs   * Specifies a list of Digital Id Configs that can
     *                                 be used to create Digital Ids for
     * a user.
     *                                 If the AllowAllDigitalIdConfigs policy
     * is set
     *                                 to true, this policy will not be set.
     */
    public void setAllowedDigitalIdConfigs(String[] allowedDigitalIdConfigs) {
        this.allowedDigitalIdConfigs = allowedDigitalIdConfigs;
    }


    /**
     * Gets the maxDigitalIdsPerUser value for this UserSpecInfo.
     * 
     * @return maxDigitalIdsPerUser   * Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public int getMaxDigitalIdsPerUser() {
        return maxDigitalIdsPerUser;
    }


    /**
     * Sets the maxDigitalIdsPerUser value for this UserSpecInfo.
     * 
     * @param maxDigitalIdsPerUser   * Specifies the maximum number of Digital Ids
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxDigitalIdsPerUser(int maxDigitalIdsPerUser) {
        this.maxDigitalIdsPerUser = maxDigitalIdsPerUser;
    }


    /**
     * Gets the maxClientTypesPerDigitalId value for this UserSpecInfo.
     * 
     * @return maxClientTypesPerDigitalId   * Specifies the maximum number of Client Types
     *                                 for a Digital Id.
     *                                 This value must be a non-negative
     * integer.
     */
    public int getMaxClientTypesPerDigitalId() {
        return maxClientTypesPerDigitalId;
    }


    /**
     * Sets the maxClientTypesPerDigitalId value for this UserSpecInfo.
     * 
     * @param maxClientTypesPerDigitalId   * Specifies the maximum number of Client Types
     *                                 for a Digital Id.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxClientTypesPerDigitalId(int maxClientTypesPerDigitalId) {
        this.maxClientTypesPerDigitalId = maxClientTypesPerDigitalId;
    }


    /**
     * Gets the autoCancelDigitalIds value for this UserSpecInfo.
     * 
     * @return autoCancelDigitalIds   * Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted.
     */
    public boolean isAutoCancelDigitalIds() {
        return autoCancelDigitalIds;
    }


    /**
     * Sets the autoCancelDigitalIds value for this UserSpecInfo.
     * 
     * @param autoCancelDigitalIds   * Flag indicating if user digital ids are
     *                                 automatically cancelled when they,
     * a 
     *                                 smart credential using the digital
     * Id
     *                                 or the user they belong to is deleted.
     */
    public void setAutoCancelDigitalIds(boolean autoCancelDigitalIds) {
        this.autoCancelDigitalIds = autoCancelDigitalIds;
    }


    /**
     * Gets the userRegistrationPasswordLifetime value for this UserSpecInfo.
     * 
     * @return userRegistrationPasswordLifetime   * User registration password lifetime in minutes.
     *                                 A value of 0 means an infinite lifetime.
     */
    public int getUserRegistrationPasswordLifetime() {
        return userRegistrationPasswordLifetime;
    }


    /**
     * Sets the userRegistrationPasswordLifetime value for this UserSpecInfo.
     * 
     * @param userRegistrationPasswordLifetime   * User registration password lifetime in minutes.
     *                                 A value of 0 means an infinite lifetime.
     */
    public void setUserRegistrationPasswordLifetime(int userRegistrationPasswordLifetime) {
        this.userRegistrationPasswordLifetime = userRegistrationPasswordLifetime;
    }


    /**
     * Gets the userRegistrationPasswordLength value for this UserSpecInfo.
     * 
     * @return userRegistrationPasswordLength   * The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32.
     */
    public int getUserRegistrationPasswordLength() {
        return userRegistrationPasswordLength;
    }


    /**
     * Sets the userRegistrationPasswordLength value for this UserSpecInfo.
     * 
     * @param userRegistrationPasswordLength   * The number of random bytes in a user
     *                                 registration password.  The value
     * must be
     *                                 between 8 and 32.
     */
    public void setUserRegistrationPasswordLength(int userRegistrationPasswordLength) {
        this.userRegistrationPasswordLength = userRegistrationPasswordLength;
    }


    /**
     * Gets the maxFederationsPerUser value for this UserSpecInfo.
     * 
     * @return maxFederationsPerUser   * Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public int getMaxFederationsPerUser() {
        return maxFederationsPerUser;
    }


    /**
     * Sets the maxFederationsPerUser value for this UserSpecInfo.
     * 
     * @param maxFederationsPerUser   * Specifies the maximum number of federations
     *                                 that can be created for a user.
     *                                 This value must be a non-negative
     * integer.
     */
    public void setMaxFederationsPerUser(int maxFederationsPerUser) {
        this.maxFederationsPerUser = maxFederationsPerUser;
    }


    /**
     * Gets the maxNumUserPreferences value for this UserSpecInfo.
     * 
     * @return maxNumUserPreferences   * The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer.
     */
    public int getMaxNumUserPreferences() {
        return maxNumUserPreferences;
    }


    /**
     * Sets the maxNumUserPreferences value for this UserSpecInfo.
     * 
     * @param maxNumUserPreferences   * The maximum number of user preferences
     *                                 allowed for a user.  This value must
     * be a
     *                                 non-negative integer.
     */
    public void setMaxNumUserPreferences(int maxNumUserPreferences) {
        this.maxNumUserPreferences = maxNumUserPreferences;
    }


    /**
     * Gets the maxSizeUserPreference value for this UserSpecInfo.
     * 
     * @return maxSizeUserPreference   * The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer.
     */
    public int getMaxSizeUserPreference() {
        return maxSizeUserPreference;
    }


    /**
     * Sets the maxSizeUserPreference value for this UserSpecInfo.
     * 
     * @param maxSizeUserPreference   * The maximum size in characters of the value for
     *                                 a user preference.  This value must
     * be a
     *                                 non-negative integer.
     */
    public void setMaxSizeUserPreference(int maxSizeUserPreference) {
        this.maxSizeUserPreference = maxSizeUserPreference;
    }


    /**
     * Gets the PVNLength value for this UserSpecInfo.
     * 
     * @return PVNLength   * The required length of new personal verification
     *                                 numbers (PVNs).
     */
    public int getPVNLength() {
        return PVNLength;
    }


    /**
     * Sets the PVNLength value for this UserSpecInfo.
     * 
     * @param PVNLength   * The required length of new personal verification
     *                                 numbers (PVNs).
     */
    public void setPVNLength(int PVNLength) {
        this.PVNLength = PVNLength;
    }


    /**
     * Gets the PVNChangeRequiredOnAdminReset value for this UserSpecInfo.
     * 
     * @return PVNChangeRequiredOnAdminReset   * Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator.
     */
    public boolean isPVNChangeRequiredOnAdminReset() {
        return PVNChangeRequiredOnAdminReset;
    }


    /**
     * Sets the PVNChangeRequiredOnAdminReset value for this UserSpecInfo.
     * 
     * @param PVNChangeRequiredOnAdminReset   * Indicates whether a user is required to change
     *                                 their personal verification number
     * (PVN) after
     *                                 it is set by an administrator.
     */
    public void setPVNChangeRequiredOnAdminReset(boolean PVNChangeRequiredOnAdminReset) {
        this.PVNChangeRequiredOnAdminReset = PVNChangeRequiredOnAdminReset;
    }


    /**
     * Gets the authTypesRequiringPVN value for this UserSpecInfo.
     * 
     * @return authTypesRequiringPVN   * The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating.
     */
    public AuthenticationType[] getAuthTypesRequiringPVN() {
        return authTypesRequiringPVN;
    }


    /**
     * Sets the authTypesRequiringPVN value for this UserSpecInfo.
     * 
     * @param authTypesRequiringPVN   * The authentication types that require a personal
     *                                 verification number to be provided
     * when authenticating.
     */
    public void setAuthTypesRequiringPVN(AuthenticationType[] authTypesRequiringPVN) {
        this.authTypesRequiringPVN = authTypesRequiringPVN;
    }


    /**
     * Gets the allTokenVendorsRequirePVN value for this UserSpecInfo.
     * 
     * @return allTokenVendorsRequirePVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true.
     */
    public boolean isAllTokenVendorsRequirePVN() {
        return allTokenVendorsRequirePVN;
    }


    /**
     * Sets the allTokenVendorsRequirePVN value for this UserSpecInfo.
     * 
     * @param allTokenVendorsRequirePVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for all token
     *                                 vendors must specify the PVN.  If
     * set to false
     *                                 then the tokenVendorsRequringPVN attribute
     * specifies the token vendors that require
     *                                 a PVN.  When creating a new policy,
     * this
     *                                 setting defaults to true.
     */
    public void setAllTokenVendorsRequirePVN(boolean allTokenVendorsRequirePVN) {
        this.allTokenVendorsRequirePVN = allTokenVendorsRequirePVN;
    }


    /**
     * Gets the tokenVendorsRequiringPVN value for this UserSpecInfo.
     * 
     * @return tokenVendorsRequiringPVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true.
     */
    public String[] getTokenVendorsRequiringPVN() {
        return tokenVendorsRequiringPVN;
    }


    /**
     * Sets the tokenVendorsRequiringPVN value for this UserSpecInfo.
     * 
     * @param tokenVendorsRequiringPVN   * If a PVN is required for TOKENRO or TOKENCR
     *                                 authentication, this setting indicates
     * if authentication requests for a specific token
     *                                 vendor must specify the PVN.  This
     * attribute
     *                                 is ignored if tokenVendorsRequiringPVN
     * is
     *                                 set to true.
     */
    public void setTokenVendorsRequiringPVN(String[] tokenVendorsRequiringPVN) {
        this.tokenVendorsRequiringPVN = tokenVendorsRequiringPVN;
    }


    /**
     * Gets the numDaysForActivation value for this UserSpecInfo.
     * 
     * @return numDaysForActivation   * The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately.
     */
    public int getNumDaysForActivation() {
        return numDaysForActivation;
    }


    /**
     * Sets the numDaysForActivation value for this UserSpecInfo.
     * 
     * @param numDaysForActivation   * The number of days for user activation.
     *                                 A value of 0 means that the user has
     * no grace period,
     *                                 they will need to activate their card
     * or token immediately.
     */
    public void setNumDaysForActivation(int numDaysForActivation) {
        this.numDaysForActivation = numDaysForActivation;
    }


    /**
     * Gets the activationAuthTypes value for this UserSpecInfo.
     * 
     * @return activationAuthTypes   * The authentication types that trigger user activation on
     *                                 first successful authentication.
     */
    public AuthenticationType[] getActivationAuthTypes() {
        return activationAuthTypes;
    }


    /**
     * Sets the activationAuthTypes value for this UserSpecInfo.
     * 
     * @param activationAuthTypes   * The authentication types that trigger user activation on
     *                                 first successful authentication.
     */
    public void setActivationAuthTypes(AuthenticationType[] activationAuthTypes) {
        this.activationAuthTypes = activationAuthTypes;
    }


    /**
     * Gets the checkIPAddressInLocationHistory value for this UserSpecInfo.
     * 
     * @return checkIPAddressInLocationHistory   * Indicates if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history.
     */
    public boolean isCheckIPAddressInLocationHistory() {
        return checkIPAddressInLocationHistory;
    }


    /**
     * Sets the checkIPAddressInLocationHistory value for this UserSpecInfo.
     * 
     * @param checkIPAddressInLocationHistory   * Indicates if the IP address should be checked
     *                                 when comparing a location to entries
     * in a
     *                                 user's location history.
     */
    public void setCheckIPAddressInLocationHistory(boolean checkIPAddressInLocationHistory) {
        this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
    }


    /**
     * Gets the maxLocationHistorySize value for this UserSpecInfo.
     * 
     * @return maxLocationHistorySize   * The maximum size of a user's location history.
     *                                 If a user exceeds this many locations,
     * the
     *                                 least-recently used locations are
     * removed from
     *                                 the list.
     */
    public int getMaxLocationHistorySize() {
        return maxLocationHistorySize;
    }


    /**
     * Sets the maxLocationHistorySize value for this UserSpecInfo.
     * 
     * @param maxLocationHistorySize   * The maximum size of a user's location history.
     *                                 If a user exceeds this many locations,
     * the
     *                                 least-recently used locations are
     * removed from
     *                                 the list.
     */
    public void setMaxLocationHistorySize(int maxLocationHistorySize) {
        this.maxLocationHistorySize = maxLocationHistorySize;
    }


    /**
     * Gets the locationHistoryLifetime value for this UserSpecInfo.
     * 
     * @return locationHistoryLifetime   * The lifetime (in days) of an entry in a user's
     *                                 location history.
     */
    public int getLocationHistoryLifetime() {
        return locationHistoryLifetime;
    }


    /**
     * Sets the locationHistoryLifetime value for this UserSpecInfo.
     * 
     * @param locationHistoryLifetime   * The lifetime (in days) of an entry in a user's
     *                                 location history.
     */
    public void setLocationHistoryLifetime(int locationHistoryLifetime) {
        this.locationHistoryLifetime = locationHistoryLifetime;
    }


    /**
     * Gets the maxVelocity value for this UserSpecInfo.
     * 
     * @return maxVelocity   * The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication.
     */
    public int getMaxVelocity() {
        return maxVelocity;
    }


    /**
     * Sets the maxVelocity value for this UserSpecInfo.
     * 
     * @param maxVelocity   * The maximum velocity (in km/h) a user can
     *                                 travel. This value is used when comparing
     * a user's current
     *                                 location against previous locations
     * during
     *                                 IP authentication.
     */
    public void setMaxVelocity(int maxVelocity) {
        this.maxVelocity = maxVelocity;
    }


    /**
     * Gets the checkVelocity value for this UserSpecInfo.
     * 
     * @return checkVelocity   * If true, the velocity check is performed
     *                                 during IP authentication.
     */
    public boolean isCheckVelocity() {
        return checkVelocity;
    }


    /**
     * Sets the checkVelocity value for this UserSpecInfo.
     * 
     * @param checkVelocity   * If true, the velocity check is performed
     *                                 during IP authentication.
     */
    public void setCheckVelocity(boolean checkVelocity) {
        this.checkVelocity = checkVelocity;
    }


    /**
     * Gets the countryBlacklist value for this UserSpecInfo.
     * 
     * @return countryBlacklist   * The country blacklist is a list of countries.
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     */
    public CountryInfo[] getCountryBlacklist() {
        return countryBlacklist;
    }


    /**
     * Sets the countryBlacklist value for this UserSpecInfo.
     * 
     * @param countryBlacklist   * The country blacklist is a list of countries.
     *                                 Users authenticating from these
     *                                 countries may not be allowed to authenticate
     * or may require additional authentication.
     */
    public void setCountryBlacklist(CountryInfo[] countryBlacklist) {
        this.countryBlacklist = countryBlacklist;
    }


    /**
     * Gets the expectedLocations value for this UserSpecInfo.
     * 
     * @return expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     */
    public ExpectedLocation[] getExpectedLocations() {
        return expectedLocations;
    }


    /**
     * Sets the expectedLocations value for this UserSpecInfo.
     * 
     * @param expectedLocations   * The expected locations list is a list of
     *                                 locations that users are expected
     * to
     *                                 authenticate from.  Users authenticated
     * from an expected location may require
     *                                 less authentication.
     */
    public void setExpectedLocations(ExpectedLocation[] expectedLocations) {
        this.expectedLocations = expectedLocations;
    }


    /**
     * Gets the maxUserExpectedLocationsSize value for this UserSpecInfo.
     * 
     * @return maxUserExpectedLocationsSize   * If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list.
     */
    public int getMaxUserExpectedLocationsSize() {
        return maxUserExpectedLocationsSize;
    }


    /**
     * Sets the maxUserExpectedLocationsSize value for this UserSpecInfo.
     * 
     * @param maxUserExpectedLocationsSize   * If the user has their own list of
     *                                 expected locations instead of relying
     * on
     *                                 expectedLocations, this policy defines
     * the maximum size of that list.
     */
    public void setMaxUserExpectedLocationsSize(int maxUserExpectedLocationsSize) {
        this.maxUserExpectedLocationsSize = maxUserExpectedLocationsSize;
    }


    /**
     * Gets the normalReject value for this UserSpecInfo.
     * 
     * @return normalReject   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected.
     */
    public RBAExpressionList getNormalReject() {
        return normalReject;
    }


    /**
     * Sets the normalReject value for this UserSpecInfo.
     * 
     * @param normalReject   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication match
     * any
     *                                 expression in this list, the request
     * will be
     *                                 rejected.
     */
    public void setNormalReject(RBAExpressionList normalReject) {
        this.normalReject = normalReject;
    }


    /**
     * Gets the normalAuthenticated value for this UserSpecInfo.
     * 
     * @return normalAuthenticated   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated.
     */
    public RBAExpressionList getNormalAuthenticated() {
        return normalAuthenticated;
    }


    /**
     * Sets the normalAuthenticated value for this UserSpecInfo.
     * 
     * @param normalAuthenticated   * A list of RBA expressions.  If the results
     *                                 of normal RBA authentication do not
     * match any in the normalReject list and do
     *                                 match any of the expressions in this
     * list
     *                                 or the enhancedAuthenticated list,
     * the
     *                                 request will be authenticated.
     */
    public void setNormalAuthenticated(RBAExpressionList normalAuthenticated) {
        this.normalAuthenticated = normalAuthenticated;
    }


    /**
     * Gets the enhancedReject value for this UserSpecInfo.
     * 
     * @return enhancedReject   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected.
     */
    public RBAExpressionList getEnhancedReject() {
        return enhancedReject;
    }


    /**
     * Sets the enhancedReject value for this UserSpecInfo.
     * 
     * @param enhancedReject   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication match
     * any
     *                                 expression in this list or any expression
     * in the normalReject list, the request will be
     *                                 rejected.
     */
    public void setEnhancedReject(RBAExpressionList enhancedReject) {
        this.enhancedReject = enhancedReject;
    }


    /**
     * Gets the enhancedAuthenticated value for this UserSpecInfo.
     * 
     * @return enhancedAuthenticated   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated.
     */
    public RBAExpressionList getEnhancedAuthenticated() {
        return enhancedAuthenticated;
    }


    /**
     * Sets the enhancedAuthenticated value for this UserSpecInfo.
     * 
     * @param enhancedAuthenticated   * A list of RBA expressions.  If the results
     *                                 of enhanced RBA authentication were
     * not
     *                                 rejected according to the expressions
     * specified
     *                                 in the normalReject and enhancedReject
     * lists
     *                                 and they match any of the expressions
     * in this
     *                                 list, the request will be authenticated.
     */
    public void setEnhancedAuthenticated(RBAExpressionList enhancedAuthenticated) {
        this.enhancedAuthenticated = enhancedAuthenticated;
    }


    /**
     * Gets the externalRiskScoreNormalPass value for this UserSpecInfo.
     * 
     * @return externalRiskScoreNormalPass   * A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public int getExternalRiskScoreNormalPass() {
        return externalRiskScoreNormalPass;
    }


    /**
     * Sets the externalRiskScoreNormalPass value for this UserSpecInfo.
     * 
     * @param externalRiskScoreNormalPass   * A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreNormalPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreNormalPass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public void setExternalRiskScoreNormalPass(int externalRiskScoreNormalPass) {
        this.externalRiskScoreNormalPass = externalRiskScoreNormalPass;
    }


    /**
     * Gets the externalRiskScoreNormalFail value for this UserSpecInfo.
     * 
     * @return externalRiskScoreNormalFail   * A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public int getExternalRiskScoreNormalFail() {
        return externalRiskScoreNormalFail;
    }


    /**
     * Sets the externalRiskScoreNormalFail value for this UserSpecInfo.
     * 
     * @param externalRiskScoreNormalFail   * A risk score threshold used for normal transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreNormalFail policy,
     * then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreNormalFail
     * value.
     */
    public void setExternalRiskScoreNormalFail(int externalRiskScoreNormalFail) {
        this.externalRiskScoreNormalFail = externalRiskScoreNormalFail;
    }


    /**
     * Gets the externalRiskScoreEnhancedPass value for this UserSpecInfo.
     * 
     * @return externalRiskScoreEnhancedPass   * A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public int getExternalRiskScoreEnhancedPass() {
        return externalRiskScoreEnhancedPass;
    }


    /**
     * Sets the externalRiskScoreEnhancedPass value for this UserSpecInfo.
     * 
     * @param externalRiskScoreEnhancedPass   * A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is less than
     * the ExternalRiskScoreEnhancedPass policy, then
     *                                 the external risk score test passes.
     * The ExternalRiskScoreEnhancedPass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public void setExternalRiskScoreEnhancedPass(int externalRiskScoreEnhancedPass) {
        this.externalRiskScoreEnhancedPass = externalRiskScoreEnhancedPass;
    }


    /**
     * Gets the externalRiskScoreEnhancedFail value for this UserSpecInfo.
     * 
     * @return externalRiskScoreEnhancedFail   * A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public int getExternalRiskScoreEnhancedFail() {
        return externalRiskScoreEnhancedFail;
    }


    /**
     * Sets the externalRiskScoreEnhancedFail value for this UserSpecInfo.
     * 
     * @param externalRiskScoreEnhancedFail   * A risk score threshold used for enhanced transactions.
     *                                 An external risk score is a value
     * between
     *                                 0 and 100.  If the score is greater
     * than
     *                                 the ExternalRiskScoreEnhancedFail
     * policy, then
     *                                 the external risk score test fails.
     * The ExternalRiskScorePass value must be
     *                                 less than or equal to the ExternalRiskScoreEnhancedFail
     * value.
     */
    public void setExternalRiskScoreEnhancedFail(int externalRiskScoreEnhancedFail) {
        this.externalRiskScoreEnhancedFail = externalRiskScoreEnhancedFail;
    }


    /**
     * Gets the externalRiskEngine value for this UserSpecInfo.
     * 
     * @return externalRiskEngine   * The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  If this value
     * is not
     *                                 set, external risk scoring is not
     * available.
     */
    public String getExternalRiskEngine() {
        return externalRiskEngine;
    }


    /**
     * Sets the externalRiskEngine value for this UserSpecInfo.
     * 
     * @param externalRiskEngine   * The name of the risk engine to be used
     *                                 to calculate a risk score for the
     * current
     *                                 application session.  If this value
     * is not
     *                                 set, external risk scoring is not
     * available.
     */
    public void setExternalRiskEngine(String externalRiskEngine) {
        this.externalRiskEngine = externalRiskEngine;
    }


    /**
     * Gets the performTransactionDelivery value for this UserSpecInfo.
     * 
     * @return performTransactionDelivery   * A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery.
     */
    public boolean isPerformTransactionDelivery() {
        return performTransactionDelivery;
    }


    /**
     * Sets the performTransactionDelivery value for this UserSpecInfo.
     * 
     * @param performTransactionDelivery   * A flag indicating if transactions should
     *                                 be delivered to soft tokens that support
     * delivery.
     */
    public void setPerformTransactionDelivery(boolean performTransactionDelivery) {
        this.performTransactionDelivery = performTransactionDelivery;
    }


    /**
     * Gets the softTokenPINRequired value for this UserSpecInfo.
     * 
     * @return softTokenPINRequired   * A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP.
     */
    public boolean isSoftTokenPINRequired() {
        return softTokenPINRequired;
    }


    /**
     * Sets the softTokenPINRequired value for this UserSpecInfo.
     * 
     * @param softTokenPINRequired   * A flag indicating whether or not soft tokens
     *                                 require users to enter a PIN before
     * generating
     *                                 an OTP.
     */
    public void setSoftTokenPINRequired(boolean softTokenPINRequired) {
        this.softTokenPINRequired = softTokenPINRequired;
    }


    /**
     * Gets the softTokenOTPLength value for this UserSpecInfo.
     * 
     * @return softTokenOTPLength   * The number of digits in an OTP response from a
     *                                 soft token.
     */
    public int getSoftTokenOTPLength() {
        return softTokenOTPLength;
    }


    /**
     * Sets the softTokenOTPLength value for this UserSpecInfo.
     * 
     * @param softTokenOTPLength   * The number of digits in an OTP response from a
     *                                 soft token.
     */
    public void setSoftTokenOTPLength(int softTokenOTPLength) {
        this.softTokenOTPLength = softTokenOTPLength;
    }


    /**
     * Gets the rolesGrantingAccess value for this UserSpecInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this UserSpecInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comment value for this UserSpecInfo.
     * 
     * @return comment   * Descriptive comments.
     */
    public String getComment() {
        return comment;
    }


    /**
     * Sets the comment value for this UserSpecInfo.
     * 
     * @param comment   * Descriptive comments.
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserSpecInfo)) return false;
        UserSpecInfo other = (UserSpecInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            this.maxAliases == other.getMaxAliases() &&
            this.maxContactInfoNumber == other.getMaxContactInfoNumber() &&
            ((this.lockoutMode==null && other.getLockoutMode()==null) || 
             (this.lockoutMode!=null &&
              this.lockoutMode.equals(other.getLockoutMode()))) &&
            this.maxFailures == other.getMaxFailures() &&
            this.maxGlobalFailures == other.getMaxGlobalFailures() &&
            this.maxCertificateFailures == other.getMaxCertificateFailures() &&
            this.maxExternalFailures == other.getMaxExternalFailures() &&
            this.maxGridFailures == other.getMaxGridFailures() &&
            this.maxTokenCRFailures == other.getMaxTokenCRFailures() &&
            this.maxTokenROFailures == other.getMaxTokenROFailures() &&
            this.maxOTPFailures == other.getMaxOTPFailures() &&
            this.maxQAFailures == other.getMaxQAFailures() &&
            this.maxRBAIPAuthFailures == other.getMaxRBAIPAuthFailures() &&
            this.maxRBAMachineAuthFailures == other.getMaxRBAMachineAuthFailures() &&
            this.maxRBACertificateAuthFailures == other.getMaxRBACertificateAuthFailures() &&
            this.maxRBAExternalRiskAuthFailures == other.getMaxRBAExternalRiskAuthFailures() &&
            this.lockoutTime == other.getLockoutTime() &&
            this.maxSecretSize == other.getMaxSecretSize() &&
            this.maxSecretNumber == other.getMaxSecretNumber() &&
            ((this.genericAuthType==null && other.getGenericAuthType()==null) || 
             (this.genericAuthType!=null &&
              java.util.Arrays.equals(this.genericAuthType, other.getGenericAuthType()))) &&
            ((this.enhancedGenericAuthType==null && other.getEnhancedGenericAuthType()==null) || 
             (this.enhancedGenericAuthType!=null &&
              java.util.Arrays.equals(this.enhancedGenericAuthType, other.getEnhancedGenericAuthType()))) &&
            ((this.machineAuthType==null && other.getMachineAuthType()==null) || 
             (this.machineAuthType!=null &&
              java.util.Arrays.equals(this.machineAuthType, other.getMachineAuthType()))) &&
            ((this.authTypeCanViewSecrets==null && other.getAuthTypeCanViewSecrets()==null) || 
             (this.authTypeCanViewSecrets!=null &&
              java.util.Arrays.equals(this.authTypeCanViewSecrets, other.getAuthTypeCanViewSecrets()))) &&
            ((this.authTypeCanModifySecrets==null && other.getAuthTypeCanModifySecrets()==null) || 
             (this.authTypeCanModifySecrets!=null &&
              java.util.Arrays.equals(this.authTypeCanModifySecrets, other.getAuthTypeCanModifySecrets()))) &&
            this.maxMachineSecrets == other.getMaxMachineSecrets() &&
            this.maxMachineSecretsSize == other.getMaxMachineSecretsSize() &&
            this.machineSecretRequiresMachineNonce == other.isMachineSecretRequiresMachineNonce() &&
            this.machineSecretRequiresSequenceNonce == other.isMachineSecretRequiresSequenceNonce() &&
            this.machineSecretRequiresAppData == other.getMachineSecretRequiresAppData() &&
            this.machineSecretAllowsBadAppData == other.getMachineSecretAllowsBadAppData() &&
            this.machineSecretLifetime == other.getMachineSecretLifetime() &&
            this.failedMachineAuthIncrementsLockout == other.isFailedMachineAuthIncrementsLockout() &&
            this.maxAuthSecrets == other.getMaxAuthSecrets() &&
            this.maxAuthSecretsSize == other.getMaxAuthSecretsSize() &&
            this.maxQuestions == other.getMaxQuestions() &&
            this.maxQASize == other.getMaxQASize() &&
            this.QAChallengeSize == other.getQAChallengeSize() &&
            this.minQAChallengeSize == other.getMinQAChallengeSize() &&
            this.maxQAChallengeSize == other.getMaxQAChallengeSize() &&
            this.disableQAChallengeRetention == other.isDisableQAChallengeRetention() &&
            this.QAChallengeLifetime == other.getQAChallengeLifetime() &&
            this.updateLockoutForReplacedQAChallenge == other.isUpdateLockoutForReplacedQAChallenge() &&
            this.qaDefaultWrongAnswersAllowed == other.getQaDefaultWrongAnswersAllowed() &&
            this.qaMaximumWrongAnswersAllowed == other.getQaMaximumWrongAnswersAllowed() &&
            this.qaInexactMatchAllowed == other.isQaInexactMatchAllowed() &&
            ((this.OTPCellAlphabet==null && other.getOTPCellAlphabet()==null) || 
             (this.OTPCellAlphabet!=null &&
              java.util.Arrays.equals(this.OTPCellAlphabet, other.getOTPCellAlphabet()))) &&
            ((this.OTPCellReplacements==null && other.getOTPCellReplacements()==null) || 
             (this.OTPCellReplacements!=null &&
              java.util.Arrays.equals(this.OTPCellReplacements, other.getOTPCellReplacements()))) &&
            this.OTPLifetime == other.getOTPLifetime() &&
            this.OTPLength == other.getOTPLength() &&
            this.OTPDeliveryEnabled == other.isOTPDeliveryEnabled() &&
            this.OTPAlwaysGenerate == other.isOTPAlwaysGenerate() &&
            this.OTPDynamicRefresh == other.isOTPDynamicRefresh() &&
            this.OTPNumberOutstanding == other.getOTPNumberOutstanding() &&
            this.OTPRefreshThreshold == other.getOTPRefreshThreshold() &&
            this.returnAuthSecretWithChall == other.isReturnAuthSecretWithChall() &&
            this.autoUnassignTokens == other.isAutoUnassignTokens() &&
            this.autoMoveTokens == other.isAutoMoveTokens() &&
            this.disableTokenChallengeRetention == other.isDisableTokenChallengeRetention() &&
            this.tokenChallengeLifetime == other.getTokenChallengeLifetime() &&
            this.updateLockoutForReplacedTokenChallenge == other.isUpdateLockoutForReplacedTokenChallenge() &&
            this.maxAllowedTokenSets == other.getMaxAllowedTokenSets() &&
            this.allowNONEAuthentication == other.isAllowNONEAuthentication() &&
            this.considerTempPINLast == other.isConsiderTempPINLast() &&
            this.storeLastAuthInfo == other.isStoreLastAuthInfo() &&
            this.allowCreateIfDisabledInRepository == other.isAllowCreateIfDisabledInRepository() &&
            this.allowCreateIfExpiredInRepository == other.isAllowCreateIfExpiredInRepository() &&
            this.allowAuthIfDisabledInRepository == other.isAllowAuthIfDisabledInRepository() &&
            this.allowAuthIfExpiredInRepository == other.isAllowAuthIfExpiredInRepository() &&
            ((this.transactionSignatureType==null && other.getTransactionSignatureType()==null) || 
             (this.transactionSignatureType!=null &&
              this.transactionSignatureType.equals(other.getTransactionSignatureType()))) &&
            this.transactionLifetime == other.getTransactionLifetime() &&
            this.maxNumTransactionDetails == other.getMaxNumTransactionDetails() &&
            this.allowSelfSignedUserCert == other.isAllowSelfSignedUserCert() &&
            this.allowCertNotIssuedByRegisteredCA == other.isAllowCertNotIssuedByRegisteredCA() &&
            this.allowAllRegisteredCAs == other.isAllowAllRegisteredCAs() &&
            ((this.allowedRegisteredCAs==null && other.getAllowedRegisteredCAs()==null) || 
             (this.allowedRegisteredCAs!=null &&
              java.util.Arrays.equals(this.allowedRegisteredCAs, other.getAllowedRegisteredCAs()))) &&
            this.allowCertNotIssuedByManagedCA == other.isAllowCertNotIssuedByManagedCA() &&
            this.allowAllManagedCAs == other.isAllowAllManagedCAs() &&
            ((this.allowedManagedCAs==null && other.getAllowedManagedCAs()==null) || 
             (this.allowedManagedCAs!=null &&
              java.util.Arrays.equals(this.allowedManagedCAs, other.getAllowedManagedCAs()))) &&
            ((this.certificateAuthenticationHashAlg==null && other.getCertificateAuthenticationHashAlg()==null) || 
             (this.certificateAuthenticationHashAlg!=null &&
              this.certificateAuthenticationHashAlg.equals(other.getCertificateAuthenticationHashAlg()))) &&
            this.certificateAuthenticationChallengeSize == other.getCertificateAuthenticationChallengeSize() &&
            this.maxCertsPerUser == other.getMaxCertsPerUser() &&
            this.autoDeleteUserCerts == other.isAutoDeleteUserCerts() &&
            this.disableCertificateChallengeRetention == other.isDisableCertificateChallengeRetention() &&
            this.certificateChallengeLifetime == other.getCertificateChallengeLifetime() &&
            this.updateLockoutForReplacedCertificateChallenge == other.isUpdateLockoutForReplacedCertificateChallenge() &&
            this.allowCertificateChallengeDelivery == other.isAllowCertificateChallengeDelivery() &&
            this.allowCertificateTransactionDelivery == other.isAllowCertificateTransactionDelivery() &&
            this.allowCertificateSign == other.isAllowCertificateSign() &&
            this.allowAllSmartCredentialDefinitions == other.isAllowAllSmartCredentialDefinitions() &&
            ((this.allowedSmartCredentialDefinitions==null && other.getAllowedSmartCredentialDefinitions()==null) || 
             (this.allowedSmartCredentialDefinitions!=null &&
              java.util.Arrays.equals(this.allowedSmartCredentialDefinitions, other.getAllowedSmartCredentialDefinitions()))) &&
            this.maxSmartCredentialsPerUser == other.getMaxSmartCredentialsPerUser() &&
            ((this.smartCredentialIDPrefix==null && other.getSmartCredentialIDPrefix()==null) || 
             (this.smartCredentialIDPrefix!=null &&
              this.smartCredentialIDPrefix.equals(other.getSmartCredentialIDPrefix()))) &&
            ((this.smartCredentialTokenVendor==null && other.getSmartCredentialTokenVendor()==null) || 
             (this.smartCredentialTokenVendor!=null &&
              this.smartCredentialTokenVendor.equals(other.getSmartCredentialTokenVendor()))) &&
            this.autoUnassignSmartCredentials == other.isAutoUnassignSmartCredentials() &&
            this.autoCancelSmartCredentials == other.isAutoCancelSmartCredentials() &&
            this.autoCancelSmartCredentialsForce == other.isAutoCancelSmartCredentialsForce() &&
            this.autoMoveSmartCredentials == other.isAutoMoveSmartCredentials() &&
            this.autoRegisterSmartCredentialsToPACS == other.isAutoRegisterSmartCredentialsToPACS() &&
            this.autoSuspendSmartCredentialsFromPACS == other.isAutoSuspendSmartCredentialsFromPACS() &&
            this.allowSoftwareSmartCredentials == other.isAllowSoftwareSmartCredentials() &&
            ((this.mobileSmartCredentialPINPrompt==null && other.getMobileSmartCredentialPINPrompt()==null) || 
             (this.mobileSmartCredentialPINPrompt!=null &&
              this.mobileSmartCredentialPINPrompt.equals(other.getMobileSmartCredentialPINPrompt()))) &&
            this.mobileSmartCredentialSessionTimeout == other.getMobileSmartCredentialSessionTimeout() &&
            this.allowAllDigitalIdConfigs == other.isAllowAllDigitalIdConfigs() &&
            ((this.allowedDigitalIdConfigs==null && other.getAllowedDigitalIdConfigs()==null) || 
             (this.allowedDigitalIdConfigs!=null &&
              java.util.Arrays.equals(this.allowedDigitalIdConfigs, other.getAllowedDigitalIdConfigs()))) &&
            this.maxDigitalIdsPerUser == other.getMaxDigitalIdsPerUser() &&
            this.maxClientTypesPerDigitalId == other.getMaxClientTypesPerDigitalId() &&
            this.autoCancelDigitalIds == other.isAutoCancelDigitalIds() &&
            this.userRegistrationPasswordLifetime == other.getUserRegistrationPasswordLifetime() &&
            this.userRegistrationPasswordLength == other.getUserRegistrationPasswordLength() &&
            this.maxFederationsPerUser == other.getMaxFederationsPerUser() &&
            this.maxNumUserPreferences == other.getMaxNumUserPreferences() &&
            this.maxSizeUserPreference == other.getMaxSizeUserPreference() &&
            this.PVNLength == other.getPVNLength() &&
            this.PVNChangeRequiredOnAdminReset == other.isPVNChangeRequiredOnAdminReset() &&
            ((this.authTypesRequiringPVN==null && other.getAuthTypesRequiringPVN()==null) || 
             (this.authTypesRequiringPVN!=null &&
              java.util.Arrays.equals(this.authTypesRequiringPVN, other.getAuthTypesRequiringPVN()))) &&
            this.allTokenVendorsRequirePVN == other.isAllTokenVendorsRequirePVN() &&
            ((this.tokenVendorsRequiringPVN==null && other.getTokenVendorsRequiringPVN()==null) || 
             (this.tokenVendorsRequiringPVN!=null &&
              java.util.Arrays.equals(this.tokenVendorsRequiringPVN, other.getTokenVendorsRequiringPVN()))) &&
            this.numDaysForActivation == other.getNumDaysForActivation() &&
            ((this.activationAuthTypes==null && other.getActivationAuthTypes()==null) || 
             (this.activationAuthTypes!=null &&
              java.util.Arrays.equals(this.activationAuthTypes, other.getActivationAuthTypes()))) &&
            this.checkIPAddressInLocationHistory == other.isCheckIPAddressInLocationHistory() &&
            this.maxLocationHistorySize == other.getMaxLocationHistorySize() &&
            this.locationHistoryLifetime == other.getLocationHistoryLifetime() &&
            this.maxVelocity == other.getMaxVelocity() &&
            this.checkVelocity == other.isCheckVelocity() &&
            ((this.countryBlacklist==null && other.getCountryBlacklist()==null) || 
             (this.countryBlacklist!=null &&
              java.util.Arrays.equals(this.countryBlacklist, other.getCountryBlacklist()))) &&
            ((this.expectedLocations==null && other.getExpectedLocations()==null) || 
             (this.expectedLocations!=null &&
              java.util.Arrays.equals(this.expectedLocations, other.getExpectedLocations()))) &&
            this.maxUserExpectedLocationsSize == other.getMaxUserExpectedLocationsSize() &&
            ((this.normalReject==null && other.getNormalReject()==null) || 
             (this.normalReject!=null &&
              this.normalReject.equals(other.getNormalReject()))) &&
            ((this.normalAuthenticated==null && other.getNormalAuthenticated()==null) || 
             (this.normalAuthenticated!=null &&
              this.normalAuthenticated.equals(other.getNormalAuthenticated()))) &&
            ((this.enhancedReject==null && other.getEnhancedReject()==null) || 
             (this.enhancedReject!=null &&
              this.enhancedReject.equals(other.getEnhancedReject()))) &&
            ((this.enhancedAuthenticated==null && other.getEnhancedAuthenticated()==null) || 
             (this.enhancedAuthenticated!=null &&
              this.enhancedAuthenticated.equals(other.getEnhancedAuthenticated()))) &&
            this.externalRiskScoreNormalPass == other.getExternalRiskScoreNormalPass() &&
            this.externalRiskScoreNormalFail == other.getExternalRiskScoreNormalFail() &&
            this.externalRiskScoreEnhancedPass == other.getExternalRiskScoreEnhancedPass() &&
            this.externalRiskScoreEnhancedFail == other.getExternalRiskScoreEnhancedFail() &&
            ((this.externalRiskEngine==null && other.getExternalRiskEngine()==null) || 
             (this.externalRiskEngine!=null &&
              this.externalRiskEngine.equals(other.getExternalRiskEngine()))) &&
            this.performTransactionDelivery == other.isPerformTransactionDelivery() &&
            this.softTokenPINRequired == other.isSoftTokenPINRequired() &&
            this.softTokenOTPLength == other.getSoftTokenOTPLength() &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comment==null && other.getComment()==null) || 
             (this.comment!=null &&
              this.comment.equals(other.getComment())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        _hashCode += getMaxAliases();
        _hashCode += getMaxContactInfoNumber();
        if (getLockoutMode() != null) {
            _hashCode += getLockoutMode().hashCode();
        }
        _hashCode += getMaxFailures();
        _hashCode += getMaxGlobalFailures();
        _hashCode += getMaxCertificateFailures();
        _hashCode += getMaxExternalFailures();
        _hashCode += getMaxGridFailures();
        _hashCode += getMaxTokenCRFailures();
        _hashCode += getMaxTokenROFailures();
        _hashCode += getMaxOTPFailures();
        _hashCode += getMaxQAFailures();
        _hashCode += getMaxRBAIPAuthFailures();
        _hashCode += getMaxRBAMachineAuthFailures();
        _hashCode += getMaxRBACertificateAuthFailures();
        _hashCode += getMaxRBAExternalRiskAuthFailures();
        _hashCode += getLockoutTime();
        _hashCode += getMaxSecretSize();
        _hashCode += getMaxSecretNumber();
        if (getGenericAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getGenericAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getGenericAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getEnhancedGenericAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getEnhancedGenericAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getEnhancedGenericAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMachineAuthType() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getMachineAuthType());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getMachineAuthType(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAuthTypeCanViewSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypeCanViewSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypeCanViewSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAuthTypeCanModifySecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypeCanModifySecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypeCanModifySecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getMaxMachineSecrets();
        _hashCode += getMaxMachineSecretsSize();
        _hashCode += (isMachineSecretRequiresMachineNonce() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isMachineSecretRequiresSequenceNonce() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getMachineSecretRequiresAppData();
        _hashCode += getMachineSecretAllowsBadAppData();
        _hashCode += getMachineSecretLifetime();
        _hashCode += (isFailedMachineAuthIncrementsLockout() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getMaxAuthSecrets();
        _hashCode += getMaxAuthSecretsSize();
        _hashCode += getMaxQuestions();
        _hashCode += getMaxQASize();
        _hashCode += getQAChallengeSize();
        _hashCode += getMinQAChallengeSize();
        _hashCode += getMaxQAChallengeSize();
        _hashCode += (isDisableQAChallengeRetention() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getQAChallengeLifetime();
        _hashCode += (isUpdateLockoutForReplacedQAChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getQaDefaultWrongAnswersAllowed();
        _hashCode += getQaMaximumWrongAnswersAllowed();
        _hashCode += (isQaInexactMatchAllowed() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getOTPCellAlphabet() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOTPCellAlphabet());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOTPCellAlphabet(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getOTPCellReplacements() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOTPCellReplacements());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOTPCellReplacements(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getOTPLifetime();
        _hashCode += getOTPLength();
        _hashCode += (isOTPDeliveryEnabled() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isOTPAlwaysGenerate() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isOTPDynamicRefresh() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getOTPNumberOutstanding();
        _hashCode += getOTPRefreshThreshold();
        _hashCode += (isReturnAuthSecretWithChall() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoUnassignTokens() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoMoveTokens() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isDisableTokenChallengeRetention() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getTokenChallengeLifetime();
        _hashCode += (isUpdateLockoutForReplacedTokenChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getMaxAllowedTokenSets();
        _hashCode += (isAllowNONEAuthentication() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isConsiderTempPINLast() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isStoreLastAuthInfo() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCreateIfDisabledInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCreateIfExpiredInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowAuthIfDisabledInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowAuthIfExpiredInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getTransactionSignatureType() != null) {
            _hashCode += getTransactionSignatureType().hashCode();
        }
        _hashCode += getTransactionLifetime();
        _hashCode += getMaxNumTransactionDetails();
        _hashCode += (isAllowSelfSignedUserCert() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCertNotIssuedByRegisteredCA() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowAllRegisteredCAs() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getAllowedRegisteredCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedRegisteredCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedRegisteredCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllowCertNotIssuedByManagedCA() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowAllManagedCAs() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getAllowedManagedCAs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedManagedCAs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedManagedCAs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCertificateAuthenticationHashAlg() != null) {
            _hashCode += getCertificateAuthenticationHashAlg().hashCode();
        }
        _hashCode += getCertificateAuthenticationChallengeSize();
        _hashCode += getMaxCertsPerUser();
        _hashCode += (isAutoDeleteUserCerts() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isDisableCertificateChallengeRetention() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getCertificateChallengeLifetime();
        _hashCode += (isUpdateLockoutForReplacedCertificateChallenge() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCertificateChallengeDelivery() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCertificateTransactionDelivery() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowCertificateSign() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowAllSmartCredentialDefinitions() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getAllowedSmartCredentialDefinitions() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedSmartCredentialDefinitions());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedSmartCredentialDefinitions(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getMaxSmartCredentialsPerUser();
        if (getSmartCredentialIDPrefix() != null) {
            _hashCode += getSmartCredentialIDPrefix().hashCode();
        }
        if (getSmartCredentialTokenVendor() != null) {
            _hashCode += getSmartCredentialTokenVendor().hashCode();
        }
        _hashCode += (isAutoUnassignSmartCredentials() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoCancelSmartCredentials() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoCancelSmartCredentialsForce() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoMoveSmartCredentials() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoRegisterSmartCredentialsToPACS() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAutoSuspendSmartCredentialsFromPACS() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isAllowSoftwareSmartCredentials() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getMobileSmartCredentialPINPrompt() != null) {
            _hashCode += getMobileSmartCredentialPINPrompt().hashCode();
        }
        _hashCode += getMobileSmartCredentialSessionTimeout();
        _hashCode += (isAllowAllDigitalIdConfigs() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getAllowedDigitalIdConfigs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAllowedDigitalIdConfigs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAllowedDigitalIdConfigs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getMaxDigitalIdsPerUser();
        _hashCode += getMaxClientTypesPerDigitalId();
        _hashCode += (isAutoCancelDigitalIds() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getUserRegistrationPasswordLifetime();
        _hashCode += getUserRegistrationPasswordLength();
        _hashCode += getMaxFederationsPerUser();
        _hashCode += getMaxNumUserPreferences();
        _hashCode += getMaxSizeUserPreference();
        _hashCode += getPVNLength();
        _hashCode += (isPVNChangeRequiredOnAdminReset() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getAuthTypesRequiringPVN() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthTypesRequiringPVN());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthTypesRequiringPVN(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isAllTokenVendorsRequirePVN() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getTokenVendorsRequiringPVN() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokenVendorsRequiringPVN());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokenVendorsRequiringPVN(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getNumDaysForActivation();
        if (getActivationAuthTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getActivationAuthTypes());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getActivationAuthTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isCheckIPAddressInLocationHistory() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getMaxLocationHistorySize();
        _hashCode += getLocationHistoryLifetime();
        _hashCode += getMaxVelocity();
        _hashCode += (isCheckVelocity() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCountryBlacklist() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCountryBlacklist());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCountryBlacklist(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getExpectedLocations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getExpectedLocations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getExpectedLocations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += getMaxUserExpectedLocationsSize();
        if (getNormalReject() != null) {
            _hashCode += getNormalReject().hashCode();
        }
        if (getNormalAuthenticated() != null) {
            _hashCode += getNormalAuthenticated().hashCode();
        }
        if (getEnhancedReject() != null) {
            _hashCode += getEnhancedReject().hashCode();
        }
        if (getEnhancedAuthenticated() != null) {
            _hashCode += getEnhancedAuthenticated().hashCode();
        }
        _hashCode += getExternalRiskScoreNormalPass();
        _hashCode += getExternalRiskScoreNormalFail();
        _hashCode += getExternalRiskScoreEnhancedPass();
        _hashCode += getExternalRiskScoreEnhancedFail();
        if (getExternalRiskEngine() != null) {
            _hashCode += getExternalRiskEngine().hashCode();
        }
        _hashCode += (isPerformTransactionDelivery() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isSoftTokenPINRequired() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += getSoftTokenOTPLength();
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComment() != null) {
            _hashCode += getComment().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserSpecInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSpecInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxContactInfoNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxContactInfoNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutMode");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lockoutMode"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "LockoutMode"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxGlobalFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxGlobalFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxCertificateFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxCertificateFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxExternalFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxExternalFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxGridFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxGridFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxTokenCRFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxTokenCRFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxTokenROFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxTokenROFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxOTPFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxOTPFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQAFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQAFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAIPAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAIPAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAMachineAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAMachineAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBACertificateAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBACertificateAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxRBAExternalRiskAuthFailures");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxRBAExternalRiskAuthFailures"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutTime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "lockoutTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSecretSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxSecretSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSecretNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxSecretNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("genericAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "genericAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedGenericAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedGenericAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineAuthType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineAuthType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypeCanViewSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "authTypeCanViewSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypeCanModifySecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "authTypeCanModifySecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxMachineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxMachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxMachineSecretsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxMachineSecretsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresMachineNonce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresMachineNonce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresSequenceNonce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresSequenceNonce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretRequiresAppData");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretRequiresAppData"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretAllowsBadAppData");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretAllowsBadAppData"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecretLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "machineSecretLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("failedMachineAuthIncrementsLockout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "failedMachineAuthIncrementsLockout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAuthSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAuthSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAuthSecretsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxAuthSecretsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQuestions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQuestions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQASize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQASize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("QAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("minQAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "minQAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxQAChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxQAChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableQAChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableQAChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("QAChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QAChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedQAChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedQAChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaDefaultWrongAnswersAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaDefaultWrongAnswersAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaMaximumWrongAnswersAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaMaximumWrongAnswersAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaInexactMatchAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "qaInexactMatchAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPCellAlphabet");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPCellAlphabet"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPCellReplacements");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPCellReplacements"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CellReplacement"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPAlwaysGenerate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPAlwaysGenerate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDynamicRefresh");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDynamicRefresh"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPNumberOutstanding");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPNumberOutstanding"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPRefreshThreshold");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPRefreshThreshold"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("returnAuthSecretWithChall");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ReturnAuthSecretWithChall"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoUnassignTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoUnassignTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoMoveTokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoMoveTokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableTokenChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableTokenChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedTokenChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedTokenChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxAllowedTokenSets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxAllowedTokenSets"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowNONEAuthentication");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowNONEAuthentication"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("considerTempPINLast");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ConsiderTempPINLast"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("storeLastAuthInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "StoreLastAuthInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCreateIfDisabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCreateIfDisabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCreateIfExpiredInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCreateIfExpiredInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAuthIfDisabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAuthIfDisabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAuthIfExpiredInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAuthIfExpiredInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transactionSignatureType");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TransactionSignatureType"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "TransactionSignatureType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transactionLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TransactionLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumTransactionDetails");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxNumTransactionDetails"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowSelfSignedUserCert");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowSelfSignedUserCert"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertNotIssuedByRegisteredCA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCertNotIssuedByRegisteredCA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedRegisteredCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedRegisteredCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertNotIssuedByManagedCA");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowCertNotIssuedByManagedCA"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedManagedCAs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedManagedCAs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAuthenticationHashAlg");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateAuthenticationHashAlg"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateAuthenticationChallengeSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CertificateAuthenticationChallengeSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxCertsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxCertsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoDeleteUserCerts");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoDeleteUserCerts"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disableCertificateChallengeRetention");
        elemField.setXmlName(new javax.xml.namespace.QName("", "disableCertificateChallengeRetention"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificateChallengeLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificateChallengeLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("updateLockoutForReplacedCertificateChallenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "updateLockoutForReplacedCertificateChallenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateChallengeDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateChallengeDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateTransactionDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateTransactionDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowCertificateSign");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allowCertificateSign"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedSmartCredentialDefinitions");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedSmartCredentialDefinitions"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSmartCredentialsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxSmartCredentialsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialIDPrefix");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialIDPrefix"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentialTokenVendor");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentialTokenVendor"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoUnassignSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoUnassignSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelSmartCredentialsForce");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelSmartCredentialsForce"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoMoveSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoMoveSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoRegisterSmartCredentialsToPACS");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoRegisterSmartCredentialsToPACS"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoSuspendSmartCredentialsFromPACS");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoSuspendSmartCredentialsFromPACS"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowSoftwareSmartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowSoftwareSmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileSmartCredentialPINPrompt");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileSmartCredentialPINPrompt"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "PINPromptType"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("mobileSmartCredentialSessionTimeout");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MobileSmartCredentialSessionTimeout"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowAllDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowAllDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allowedDigitalIdConfigs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AllowedDigitalIdConfigs"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxDigitalIdsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxDigitalIdsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxClientTypesPerDigitalId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxClientTypesPerDigitalId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoCancelDigitalIds");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoCancelDigitalIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userRegistrationPasswordLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserRegistrationPasswordLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userRegistrationPasswordLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserRegistrationPasswordLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxFederationsPerUser");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxFederationsPerUser"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxNumUserPreferences");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxNumUserPreferences"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxSizeUserPreference");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MaxSizeUserPreference"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVNLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVNLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVNChangeRequiredOnAdminReset");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVNChangeRequiredOnAdminReset"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authTypesRequiringPVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AuthTypesRequiringPVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("allTokenVendorsRequirePVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "allTokenVendorsRequirePVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenVendorsRequiringPVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "tokenVendorsRequiringPVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("numDaysForActivation");
        elemField.setXmlName(new javax.xml.namespace.QName("", "numDaysForActivation"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationAuthTypes");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationAuthTypes"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationType"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locationHistoryLifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "locationHistoryLifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("countryBlacklist");
        elemField.setXmlName(new javax.xml.namespace.QName("", "countryBlacklist"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "CountryInfo"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ExpectedLocation"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxUserExpectedLocationsSize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxUserExpectedLocationsSize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalReject");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalReject"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("normalAuthenticated");
        elemField.setXmlName(new javax.xml.namespace.QName("", "normalAuthenticated"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedReject");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedReject"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enhancedAuthenticated");
        elemField.setXmlName(new javax.xml.namespace.QName("", "enhancedAuthenticated"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "RBAExpressionList"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreNormalPass");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreNormalPass"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreNormalFail");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreNormalFail"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreEnhancedPass");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreEnhancedPass"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskScoreEnhancedFail");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskScoreEnhancedFail"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("externalRiskEngine");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExternalRiskEngine"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("performTransactionDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PerformTransactionDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("softTokenPINRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SoftTokenPINRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("softTokenOTPLength");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SoftTokenOTPLength"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "rolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comment");
        elemField.setXmlName(new javax.xml.namespace.QName("", "comment"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
