/**
 * UserPasswordParms.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines the parameters passed when creating or modifying
 *                         a user password. All values can be null, indicating
 * that the
 *                         default is used for create or the value is
 * not changed
 *                         for modify.
 */
public class UserPasswordParms  implements java.io.Serializable {
    /* The password value. Must be null if autoGenerate is
     *                                 used. */
    private String password;

    /* If true, indicates a random password will be generated.
     *                                 Default is false during password creation. */
    private Boolean autoGenerate;

    /* If set, this value contains Base-64 encoded
     *                                 password information imported from
     * an
     *                                 external password source such as Entrust
     * RoamingServer.  An imported password will
     *                                 be validated and converted to an Entrust
     * IdentityGuard password at the first 
     *                                 authentication.  If an ImportedPassword
     * value is specified, the Password value
     *                                 can not be specified. */
    private String importedPassword;

    /* The lifetime of the password in days. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the password has infinite
     * lifetime.
     *                                 When modifying a password and setting
     * this value,
     *                                 the expiry date will be calculated
     * from the current date,
     *                                 not the date the password was created. */
    private Integer daysToExpiry;

    /* Indicates if a password change will be required by user.
     *                                 Default is true during password creation. */
    private Boolean changeRequired;

    /* Indicates if the password history must be cleared.
     *                                 Default is false during password creation. */
    private Boolean clearPasswordHistory;

    /* Indicates if the retrievable password must be cleared.
     *                                 Default is false during password creation.
     * Setting this to true will generate a fault if
     *                                 autoGenerate is also set to true. */
    private Boolean clearRetrievablePassword;

    public UserPasswordParms() {
    }

    public UserPasswordParms(
           String password,
           Boolean autoGenerate,
           String importedPassword,
           Integer daysToExpiry,
           Boolean changeRequired,
           Boolean clearPasswordHistory,
           Boolean clearRetrievablePassword) {
           this.password = password;
           this.autoGenerate = autoGenerate;
           this.importedPassword = importedPassword;
           this.daysToExpiry = daysToExpiry;
           this.changeRequired = changeRequired;
           this.clearPasswordHistory = clearPasswordHistory;
           this.clearRetrievablePassword = clearRetrievablePassword;
    }


    /**
     * Gets the password value for this UserPasswordParms.
     * 
     * @return password   * The password value. Must be null if autoGenerate is
     *                                 used.
     */
    public String getPassword() {
        return password;
    }


    /**
     * Sets the password value for this UserPasswordParms.
     * 
     * @param password   * The password value. Must be null if autoGenerate is
     *                                 used.
     */
    public void setPassword(String password) {
        this.password = password;
    }


    /**
     * Gets the autoGenerate value for this UserPasswordParms.
     * 
     * @return autoGenerate   * If true, indicates a random password will be generated.
     *                                 Default is false during password creation.
     */
    public Boolean getAutoGenerate() {
        return autoGenerate;
    }


    /**
     * Sets the autoGenerate value for this UserPasswordParms.
     * 
     * @param autoGenerate   * If true, indicates a random password will be generated.
     *                                 Default is false during password creation.
     */
    public void setAutoGenerate(Boolean autoGenerate) {
        this.autoGenerate = autoGenerate;
    }


    /**
     * Gets the importedPassword value for this UserPasswordParms.
     * 
     * @return importedPassword   * If set, this value contains Base-64 encoded
     *                                 password information imported from
     * an
     *                                 external password source such as Entrust
     * RoamingServer.  An imported password will
     *                                 be validated and converted to an Entrust
     * IdentityGuard password at the first 
     *                                 authentication.  If an ImportedPassword
     * value is specified, the Password value
     *                                 can not be specified.
     */
    public String getImportedPassword() {
        return importedPassword;
    }


    /**
     * Sets the importedPassword value for this UserPasswordParms.
     * 
     * @param importedPassword   * If set, this value contains Base-64 encoded
     *                                 password information imported from
     * an
     *                                 external password source such as Entrust
     * RoamingServer.  An imported password will
     *                                 be validated and converted to an Entrust
     * IdentityGuard password at the first 
     *                                 authentication.  If an ImportedPassword
     * value is specified, the Password value
     *                                 can not be specified.
     */
    public void setImportedPassword(String importedPassword) {
        this.importedPassword = importedPassword;
    }


    /**
     * Gets the daysToExpiry value for this UserPasswordParms.
     * 
     * @return daysToExpiry   * The lifetime of the password in days. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the password has infinite
     * lifetime.
     *                                 When modifying a password and setting
     * this value,
     *                                 the expiry date will be calculated
     * from the current date,
     *                                 not the date the password was created.
     */
    public Integer getDaysToExpiry() {
        return daysToExpiry;
    }


    /**
     * Sets the daysToExpiry value for this UserPasswordParms.
     * 
     * @param daysToExpiry   * The lifetime of the password in days. The
     *                                 value must be a non-negative integer.
     * A value
     *                                 of 0 means the password has infinite
     * lifetime.
     *                                 When modifying a password and setting
     * this value,
     *                                 the expiry date will be calculated
     * from the current date,
     *                                 not the date the password was created.
     */
    public void setDaysToExpiry(Integer daysToExpiry) {
        this.daysToExpiry = daysToExpiry;
    }


    /**
     * Gets the changeRequired value for this UserPasswordParms.
     * 
     * @return changeRequired   * Indicates if a password change will be required by user.
     *                                 Default is true during password creation.
     */
    public Boolean getChangeRequired() {
        return changeRequired;
    }


    /**
     * Sets the changeRequired value for this UserPasswordParms.
     * 
     * @param changeRequired   * Indicates if a password change will be required by user.
     *                                 Default is true during password creation.
     */
    public void setChangeRequired(Boolean changeRequired) {
        this.changeRequired = changeRequired;
    }


    /**
     * Gets the clearPasswordHistory value for this UserPasswordParms.
     * 
     * @return clearPasswordHistory   * Indicates if the password history must be cleared.
     *                                 Default is false during password creation.
     */
    public Boolean getClearPasswordHistory() {
        return clearPasswordHistory;
    }


    /**
     * Sets the clearPasswordHistory value for this UserPasswordParms.
     * 
     * @param clearPasswordHistory   * Indicates if the password history must be cleared.
     *                                 Default is false during password creation.
     */
    public void setClearPasswordHistory(Boolean clearPasswordHistory) {
        this.clearPasswordHistory = clearPasswordHistory;
    }


    /**
     * Gets the clearRetrievablePassword value for this UserPasswordParms.
     * 
     * @return clearRetrievablePassword   * Indicates if the retrievable password must be cleared.
     *                                 Default is false during password creation.
     * Setting this to true will generate a fault if
     *                                 autoGenerate is also set to true.
     */
    public Boolean getClearRetrievablePassword() {
        return clearRetrievablePassword;
    }


    /**
     * Sets the clearRetrievablePassword value for this UserPasswordParms.
     * 
     * @param clearRetrievablePassword   * Indicates if the retrievable password must be cleared.
     *                                 Default is false during password creation.
     * Setting this to true will generate a fault if
     *                                 autoGenerate is also set to true.
     */
    public void setClearRetrievablePassword(Boolean clearRetrievablePassword) {
        this.clearRetrievablePassword = clearRetrievablePassword;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserPasswordParms)) return false;
        UserPasswordParms other = (UserPasswordParms) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.password==null && other.getPassword()==null) || 
             (this.password!=null &&
              this.password.equals(other.getPassword()))) &&
            ((this.autoGenerate==null && other.getAutoGenerate()==null) || 
             (this.autoGenerate!=null &&
              this.autoGenerate.equals(other.getAutoGenerate()))) &&
            ((this.importedPassword==null && other.getImportedPassword()==null) || 
             (this.importedPassword!=null &&
              this.importedPassword.equals(other.getImportedPassword()))) &&
            ((this.daysToExpiry==null && other.getDaysToExpiry()==null) || 
             (this.daysToExpiry!=null &&
              this.daysToExpiry.equals(other.getDaysToExpiry()))) &&
            ((this.changeRequired==null && other.getChangeRequired()==null) || 
             (this.changeRequired!=null &&
              this.changeRequired.equals(other.getChangeRequired()))) &&
            ((this.clearPasswordHistory==null && other.getClearPasswordHistory()==null) || 
             (this.clearPasswordHistory!=null &&
              this.clearPasswordHistory.equals(other.getClearPasswordHistory()))) &&
            ((this.clearRetrievablePassword==null && other.getClearRetrievablePassword()==null) || 
             (this.clearRetrievablePassword!=null &&
              this.clearRetrievablePassword.equals(other.getClearRetrievablePassword())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getPassword() != null) {
            _hashCode += getPassword().hashCode();
        }
        if (getAutoGenerate() != null) {
            _hashCode += getAutoGenerate().hashCode();
        }
        if (getImportedPassword() != null) {
            _hashCode += getImportedPassword().hashCode();
        }
        if (getDaysToExpiry() != null) {
            _hashCode += getDaysToExpiry().hashCode();
        }
        if (getChangeRequired() != null) {
            _hashCode += getChangeRequired().hashCode();
        }
        if (getClearPasswordHistory() != null) {
            _hashCode += getClearPasswordHistory().hashCode();
        }
        if (getClearRetrievablePassword() != null) {
            _hashCode += getClearRetrievablePassword().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserPasswordParms.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPasswordParms"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("password");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Password"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("autoGenerate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AutoGenerate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("importedPassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ImportedPassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("daysToExpiry");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DaysToExpiry"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("changeRequired");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ChangeRequired"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("clearPasswordHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ClearPasswordHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("clearRetrievablePassword");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ClearRetrievablePassword"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
