/**
 * UserInfo.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * Defines information returned about a user.
 */
public class UserInfo  implements java.io.Serializable {
    /* The user ID of the user. */
    private String userid;

    /* The user name portion of the user ID. */
    private String userName;

    /* The group of the user. */
    private String group;

    /* The name of the partition the user is assigned
     *                                 to, or null if the user is not assigned
     * to a
     *                                 particular partition. */
    private String partition;

    /* The internal identifying number assigned to the
     *                                 user. */
    private java.math.BigInteger userNumber;

    /* When the user is stored in an LDAP directory
     *                                 and the LDAP entry has been renamed,
     * this
     *                                 value will contain the original Id
     * of the
     *                                 user.  Otherwise, this value will
     * contain
     *                                 the userid of the user. */
    private String originalId;

    /* The name of the repository that the user's
     *                                 information is stored in. */
    private String repository;

    /* The user's contact information. */
    private ContactInfo[] contactInfoList;

    /* The aliases of this user. */
    private String[] aliases;

    /* The full name of the user. If name mapping has
     *                             been enabled and no full name has been
     * explicitly
     *                             set for the user, then this will be the
     * same as
     *                             FullNameInRepository. If full name mapping
     * is
     *                             enabled, this full name may have been
     * explicitly
     *                             set to a value different from FullNameInRepository. */
    private String fullName;

    /* The user's full name as read from a repository
     *                             attribute not controlled by Entrust
     *                             IdentityGuard.  Full name mapping must
     * have
     *                             been turned on for this value to be set. */
    private String fullNameInRepository;

    /* The locale of the user. */
    private String locale;

    /* A flag indicating if the user data has integrity
     *                                 errors. In the case of an LDAP repository,
     * 
     *                                 an integrity error may indicate that
     * the
     *                                 user's name has changed in the repository
     * without having been changed in Entrust
     *                                 IdentityGuard. */
    private boolean badData;

    /* Information about the user's lockout state. */
    private UserLockoutInfo lockoutInfo;

    /* Information about the last successful
     *                                 authentication for this user.  This
     * value
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored. */
    private AuthenticationInfo lastAuth;

    /* Information about the last failed
     *                                 authentication for this user.  This
     * value 
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored. */
    private AuthenticationInfo lastFailedAuth;

    /* Flag indicating if this user's account is disabled
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This is a separate consideration
     *                                 from the user's state, but the user's
     * state,
     *                                 this flag, and whether or not the
     * user's account
     *                                 has expired in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being disabled in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository. */
    private boolean disabledInRepository;

    /* Flag indicating if this user's account is expired
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This flag, the user's state, and whether
     * or not the user's account
     *                                 is disabled in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being expired in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository. */
    private boolean expiredInRepository;

    /* The user's shared secrets.  May be null or
     *                                 an empty array if the user doesn't
     * have any
     *                                 shared secrets. */
    private SharedSecret[] sharedSecrets;

    /* The user's QA authentication values.  This
     *                                 attribute will have a null value if
     * the
     *                                 administrator doesn't have QA authentication
     * values or doesn't have the userGetQa
     *                                 permission.  If the administrator
     * doesn't have
     *                                 the userQaView permission, the answers
     * will not
     *                                 be included in the returned value. */
    private NameValue[] qaSecrets;

    /* The user's mutual authentication secrets. May be null or an
     * empty array if the user doesn't have any authentication
     *                                 secrets. */
    private NameValue[] authenticationSecrets;

    /* The user's machine secrets.  May be null or an
     *                                 empty array if the user doesn't have
     * any machine
     *                                 secrets. */
    private MachineSecretInfo[] machineSecrets;

    /* The user's PIN. Null if the user doesn't have a PIN. */
    private UserPINInfo PIN;

    /* The user's one-time passwords (OTPs). Null if the user doesn't
     * have any OTPs. */
    private UserOTPInfo[] OTPs;

    /* A flag indicating if the user can use an OTP
     *                                 for authentication. */
    private boolean OTPAllowed;

    /* If true, use the policy setting for
     *                                 OTPDeliveryEnabled. If false, OTPDeliveryEnabled
     * indicates whether or not OTP delivery is allowed. */
    private boolean usePolicyForOTPDeliveryEnabled;

    /* A flag indicating if the OTP can be delivered
     *                                 via an out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true. */
    private Boolean OTPDeliveryEnabled;

    /* The user's personal verification number (PVN).
     *                                 Null if the user doesn't have a PVN. */
    private UserPVNInfo PVN;

    /* The user's default password.
     *                                 Null if the user doesn't have a password. */
    private UserPasswordInfo password;

    /* The user's named passwords.
     *                                 Null if the user doesn't have named
     * passwords. */
    private UserPasswordInfo[] namedPasswords;

    /* The activation information for the user. */
    private ActivationInfo activationInfo;

    /* The user's cards. May be null or an empty array if the
     *                                 user doesn't have any cards. */
    private UserCardInfo[] cards;

    /* The user's tokens.  May be null or an empty array if the
     *                                 user doesn't have any tokens. */
    private UserTokenInfo[] tokens;

    /* The user's certificates.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 certificates. */
    private UserCertificateInfo[] certificates;

    /* The user's federations.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 federations. */
    private UserFederationInfo[] federations;

    /* The user's Digital Ids.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Digital Ids. */
    private UserDigitalIdInfo[] digitalIds;

    /* The user's Smart Credentials.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Smart Credentials. */
    private com.good.adapters.entrust.stubs.UserSmartCredentialInfo[] smartCredentials;

    /* The user's state. */
    private UserState userState;

    /* The reason for the user's suspension, if the user's
     *                                 state is SUSPENDED. */
    private String suspendReason;

    /* The list of the names of the roles assigned to
     *                                 this user. */
    private String[] roles;

    /* The list of locations that this user has
     *                                 authenticated from. */
    private UserLocation[] userLocations;

    /* If true, use the policy setting for
     *                                 maxLocationHistorySize. If false,
     * maxLocationHistorySize
     *                                 indicates the maximum location history
     * size. */
    private boolean usePolicyForMaxLocationHistorySize;

    /* The maximum size of the user location history
     *                                 list.  This attribute will not be
     * set if
     *                                 usePolicyForMaxLocationHistorySize
     * is true. */
    private Integer maxLocationHistorySize;

    /* If true, use the policy setting for
     *                                 checkVelocity. If false, checkVelocity
     * indicates whether or not to perform the velocity
     *                                 check when authenticating an IP address. */
    private boolean usePolicyForCheckVelocity;

    /* If true, perform the velocity check when
     *                                 authenticating an IP address.
     *                                 This attribute will not be set if
     *                                 usePolicyForCheckVelocity is true. */
    private Boolean checkVelocity;

    /* If true, use the policy setting for
     *                                 checkIPAddressInLocationHistory. If
     * false,
     *                                 checkIPAddressInLocationHistory
     *                                 indicates whether or not to check
     * the IP
     *                                 address when comparing a location
     * against the
     *                                 user's location history. */
    private boolean usePolicyForCheckIPAddressInLocationHistory;

    /* If true, check the IP address when comparing
     *                                 a location against the user's location
     * history.  This attribute will not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is true. */
    private Boolean checkIPAddressInLocationHistory;

    /* If true, this user uses the expected locations
     *                                 settings defined in policy.  Otherwise,
     * the
     *                                 per-user expectedLocations setting
     * is used. */
    private boolean usePolicyForExpectedLocations;

    /* A list of locations the user can authenticate
     *                                 from.  This value is ignored if
     *                                 usePolicyForExpectedLocations is true. */
    private ExpectedLocation[] expectedLocations;

    /* When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure. */
    private String[] rolesGrantingAccess;

    /* Optional descriptive comments about this user. */
    private String comments;

    public UserInfo() {
    }

    public UserInfo(
           String userid,
           String userName,
           String group,
           String partition,
           java.math.BigInteger userNumber,
           String originalId,
           String repository,
           ContactInfo[] contactInfoList,
           String[] aliases,
           String fullName,
           String fullNameInRepository,
           String locale,
           boolean badData,
           UserLockoutInfo lockoutInfo,
           AuthenticationInfo lastAuth,
           AuthenticationInfo lastFailedAuth,
           boolean disabledInRepository,
           boolean expiredInRepository,
           SharedSecret[] sharedSecrets,
           NameValue[] qaSecrets,
           NameValue[] authenticationSecrets,
           MachineSecretInfo[] machineSecrets,
           UserPINInfo PIN,
           UserOTPInfo[] OTPs,
           boolean OTPAllowed,
           boolean usePolicyForOTPDeliveryEnabled,
           Boolean OTPDeliveryEnabled,
           UserPVNInfo PVN,
           UserPasswordInfo password,
           UserPasswordInfo[] namedPasswords,
           ActivationInfo activationInfo,
           UserCardInfo[] cards,
           UserTokenInfo[] tokens,
           UserCertificateInfo[] certificates,
           UserFederationInfo[] federations,
           UserDigitalIdInfo[] digitalIds,
           com.good.adapters.entrust.stubs.UserSmartCredentialInfo[] smartCredentials,
           UserState userState,
           String suspendReason,
           String[] roles,
           UserLocation[] userLocations,
           boolean usePolicyForMaxLocationHistorySize,
           Integer maxLocationHistorySize,
           boolean usePolicyForCheckVelocity,
           Boolean checkVelocity,
           boolean usePolicyForCheckIPAddressInLocationHistory,
           Boolean checkIPAddressInLocationHistory,
           boolean usePolicyForExpectedLocations,
           ExpectedLocation[] expectedLocations,
           String[] rolesGrantingAccess,
           String comments) {
           this.userid = userid;
           this.userName = userName;
           this.group = group;
           this.partition = partition;
           this.userNumber = userNumber;
           this.originalId = originalId;
           this.repository = repository;
           this.contactInfoList = contactInfoList;
           this.aliases = aliases;
           this.fullName = fullName;
           this.fullNameInRepository = fullNameInRepository;
           this.locale = locale;
           this.badData = badData;
           this.lockoutInfo = lockoutInfo;
           this.lastAuth = lastAuth;
           this.lastFailedAuth = lastFailedAuth;
           this.disabledInRepository = disabledInRepository;
           this.expiredInRepository = expiredInRepository;
           this.sharedSecrets = sharedSecrets;
           this.qaSecrets = qaSecrets;
           this.authenticationSecrets = authenticationSecrets;
           this.machineSecrets = machineSecrets;
           this.PIN = PIN;
           this.OTPs = OTPs;
           this.OTPAllowed = OTPAllowed;
           this.usePolicyForOTPDeliveryEnabled = usePolicyForOTPDeliveryEnabled;
           this.OTPDeliveryEnabled = OTPDeliveryEnabled;
           this.PVN = PVN;
           this.password = password;
           this.namedPasswords = namedPasswords;
           this.activationInfo = activationInfo;
           this.cards = cards;
           this.tokens = tokens;
           this.certificates = certificates;
           this.federations = federations;
           this.digitalIds = digitalIds;
           this.smartCredentials = smartCredentials;
           this.userState = userState;
           this.suspendReason = suspendReason;
           this.roles = roles;
           this.userLocations = userLocations;
           this.usePolicyForMaxLocationHistorySize = usePolicyForMaxLocationHistorySize;
           this.maxLocationHistorySize = maxLocationHistorySize;
           this.usePolicyForCheckVelocity = usePolicyForCheckVelocity;
           this.checkVelocity = checkVelocity;
           this.usePolicyForCheckIPAddressInLocationHistory = usePolicyForCheckIPAddressInLocationHistory;
           this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
           this.usePolicyForExpectedLocations = usePolicyForExpectedLocations;
           this.expectedLocations = expectedLocations;
           this.rolesGrantingAccess = rolesGrantingAccess;
           this.comments = comments;
    }


    /**
     * Gets the userid value for this UserInfo.
     * 
     * @return userid   * The user ID of the user.
     */
    public String getUserid() {
        return userid;
    }


    /**
     * Sets the userid value for this UserInfo.
     * 
     * @param userid   * The user ID of the user.
     */
    public void setUserid(String userid) {
        this.userid = userid;
    }


    /**
     * Gets the userName value for this UserInfo.
     * 
     * @return userName   * The user name portion of the user ID.
     */
    public String getUserName() {
        return userName;
    }


    /**
     * Sets the userName value for this UserInfo.
     * 
     * @param userName   * The user name portion of the user ID.
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }


    /**
     * Gets the group value for this UserInfo.
     * 
     * @return group   * The group of the user.
     */
    public String getGroup() {
        return group;
    }


    /**
     * Sets the group value for this UserInfo.
     * 
     * @param group   * The group of the user.
     */
    public void setGroup(String group) {
        this.group = group;
    }


    /**
     * Gets the partition value for this UserInfo.
     * 
     * @return partition   * The name of the partition the user is assigned
     *                                 to, or null if the user is not assigned
     * to a
     *                                 particular partition.
     */
    public String getPartition() {
        return partition;
    }


    /**
     * Sets the partition value for this UserInfo.
     * 
     * @param partition   * The name of the partition the user is assigned
     *                                 to, or null if the user is not assigned
     * to a
     *                                 particular partition.
     */
    public void setPartition(String partition) {
        this.partition = partition;
    }


    /**
     * Gets the userNumber value for this UserInfo.
     * 
     * @return userNumber   * The internal identifying number assigned to the
     *                                 user.
     */
    public java.math.BigInteger getUserNumber() {
        return userNumber;
    }


    /**
     * Sets the userNumber value for this UserInfo.
     * 
     * @param userNumber   * The internal identifying number assigned to the
     *                                 user.
     */
    public void setUserNumber(java.math.BigInteger userNumber) {
        this.userNumber = userNumber;
    }


    /**
     * Gets the originalId value for this UserInfo.
     * 
     * @return originalId   * When the user is stored in an LDAP directory
     *                                 and the LDAP entry has been renamed,
     * this
     *                                 value will contain the original Id
     * of the
     *                                 user.  Otherwise, this value will
     * contain
     *                                 the userid of the user.
     */
    public String getOriginalId() {
        return originalId;
    }


    /**
     * Sets the originalId value for this UserInfo.
     * 
     * @param originalId   * When the user is stored in an LDAP directory
     *                                 and the LDAP entry has been renamed,
     * this
     *                                 value will contain the original Id
     * of the
     *                                 user.  Otherwise, this value will
     * contain
     *                                 the userid of the user.
     */
    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }


    /**
     * Gets the repository value for this UserInfo.
     * 
     * @return repository   * The name of the repository that the user's
     *                                 information is stored in.
     */
    public String getRepository() {
        return repository;
    }


    /**
     * Sets the repository value for this UserInfo.
     * 
     * @param repository   * The name of the repository that the user's
     *                                 information is stored in.
     */
    public void setRepository(String repository) {
        this.repository = repository;
    }


    /**
     * Gets the contactInfoList value for this UserInfo.
     * 
     * @return contactInfoList   * The user's contact information.
     */
    public ContactInfo[] getContactInfoList() {
        return contactInfoList;
    }


    /**
     * Sets the contactInfoList value for this UserInfo.
     * 
     * @param contactInfoList   * The user's contact information.
     */
    public void setContactInfoList(ContactInfo[] contactInfoList) {
        this.contactInfoList = contactInfoList;
    }


    /**
     * Gets the aliases value for this UserInfo.
     * 
     * @return aliases   * The aliases of this user.
     */
    public String[] getAliases() {
        return aliases;
    }


    /**
     * Sets the aliases value for this UserInfo.
     * 
     * @param aliases   * The aliases of this user.
     */
    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }


    /**
     * Gets the fullName value for this UserInfo.
     * 
     * @return fullName   * The full name of the user. If name mapping has
     *                             been enabled and no full name has been
     * explicitly
     *                             set for the user, then this will be the
     * same as
     *                             FullNameInRepository. If full name mapping
     * is
     *                             enabled, this full name may have been
     * explicitly
     *                             set to a value different from FullNameInRepository.
     */
    public String getFullName() {
        return fullName;
    }


    /**
     * Sets the fullName value for this UserInfo.
     * 
     * @param fullName   * The full name of the user. If name mapping has
     *                             been enabled and no full name has been
     * explicitly
     *                             set for the user, then this will be the
     * same as
     *                             FullNameInRepository. If full name mapping
     * is
     *                             enabled, this full name may have been
     * explicitly
     *                             set to a value different from FullNameInRepository.
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }


    /**
     * Gets the fullNameInRepository value for this UserInfo.
     * 
     * @return fullNameInRepository   * The user's full name as read from a repository
     *                             attribute not controlled by Entrust
     *                             IdentityGuard.  Full name mapping must
     * have
     *                             been turned on for this value to be set.
     */
    public String getFullNameInRepository() {
        return fullNameInRepository;
    }


    /**
     * Sets the fullNameInRepository value for this UserInfo.
     * 
     * @param fullNameInRepository   * The user's full name as read from a repository
     *                             attribute not controlled by Entrust
     *                             IdentityGuard.  Full name mapping must
     * have
     *                             been turned on for this value to be set.
     */
    public void setFullNameInRepository(String fullNameInRepository) {
        this.fullNameInRepository = fullNameInRepository;
    }


    /**
     * Gets the locale value for this UserInfo.
     * 
     * @return locale   * The locale of the user.
     */
    public String getLocale() {
        return locale;
    }


    /**
     * Sets the locale value for this UserInfo.
     * 
     * @param locale   * The locale of the user.
     */
    public void setLocale(String locale) {
        this.locale = locale;
    }


    /**
     * Gets the badData value for this UserInfo.
     * 
     * @return badData   * A flag indicating if the user data has integrity
     *                                 errors. In the case of an LDAP repository,
     * 
     *                                 an integrity error may indicate that
     * the
     *                                 user's name has changed in the repository
     * without having been changed in Entrust
     *                                 IdentityGuard.
     */
    public boolean isBadData() {
        return badData;
    }


    /**
     * Sets the badData value for this UserInfo.
     * 
     * @param badData   * A flag indicating if the user data has integrity
     *                                 errors. In the case of an LDAP repository,
     * 
     *                                 an integrity error may indicate that
     * the
     *                                 user's name has changed in the repository
     * without having been changed in Entrust
     *                                 IdentityGuard.
     */
    public void setBadData(boolean badData) {
        this.badData = badData;
    }


    /**
     * Gets the lockoutInfo value for this UserInfo.
     * 
     * @return lockoutInfo   * Information about the user's lockout state.
     */
    public UserLockoutInfo getLockoutInfo() {
        return lockoutInfo;
    }


    /**
     * Sets the lockoutInfo value for this UserInfo.
     * 
     * @param lockoutInfo   * Information about the user's lockout state.
     */
    public void setLockoutInfo(UserLockoutInfo lockoutInfo) {
        this.lockoutInfo = lockoutInfo;
    }


    /**
     * Gets the lastAuth value for this UserInfo.
     * 
     * @return lastAuth   * Information about the last successful
     *                                 authentication for this user.  This
     * value
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored.
     */
    public AuthenticationInfo getLastAuth() {
        return lastAuth;
    }


    /**
     * Sets the lastAuth value for this UserInfo.
     * 
     * @param lastAuth   * Information about the last successful
     *                                 authentication for this user.  This
     * value
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored.
     */
    public void setLastAuth(AuthenticationInfo lastAuth) {
        this.lastAuth = lastAuth;
    }


    /**
     * Gets the lastFailedAuth value for this UserInfo.
     * 
     * @return lastFailedAuth   * Information about the last failed
     *                                 authentication for this user.  This
     * value 
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored.
     */
    public AuthenticationInfo getLastFailedAuth() {
        return lastFailedAuth;
    }


    /**
     * Sets the lastFailedAuth value for this UserInfo.
     * 
     * @param lastFailedAuth   * Information about the last failed
     *                                 authentication for this user.  This
     * value 
     *                                 will not be set if the user has never
     * authenticated or if the policy is defined
     *                                 such that information about the last
     * authentication is not stored.
     */
    public void setLastFailedAuth(AuthenticationInfo lastFailedAuth) {
        this.lastFailedAuth = lastFailedAuth;
    }


    /**
     * Gets the disabledInRepository value for this UserInfo.
     * 
     * @return disabledInRepository   * Flag indicating if this user's account is disabled
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This is a separate consideration
     *                                 from the user's state, but the user's
     * state,
     *                                 this flag, and whether or not the
     * user's account
     *                                 has expired in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being disabled in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository.
     */
    public boolean isDisabledInRepository() {
        return disabledInRepository;
    }


    /**
     * Sets the disabledInRepository value for this UserInfo.
     * 
     * @param disabledInRepository   * Flag indicating if this user's account is disabled
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This is a separate consideration
     *                                 from the user's state, but the user's
     * state,
     *                                 this flag, and whether or not the
     * user's account
     *                                 has expired in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being disabled in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository.
     */
    public void setDisabledInRepository(boolean disabledInRepository) {
        this.disabledInRepository = disabledInRepository;
    }


    /**
     * Gets the expiredInRepository value for this UserInfo.
     * 
     * @return expiredInRepository   * Flag indicating if this user's account is expired
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This flag, the user's state, and whether
     * or not the user's account
     *                                 is disabled in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being expired in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository.
     */
    public boolean isExpiredInRepository() {
        return expiredInRepository;
    }


    /**
     * Sets the expiredInRepository value for this UserInfo.
     * 
     * @param expiredInRepository   * Flag indicating if this user's account is expired
     *                                 in the repository, determined by attributes
     * in the
     *                                 repository that are not controlled
     * by Entrust IdentityGuard.
     *                                 This flag, the user's state, and whether
     * or not the user's account
     *                                 is disabled in the repository may
     * be taken in to account during
     *                                 an attempt to authenticate. Note that
     * the concept
     *                                 of a user being expired in the repository
     * is only
     *                                 applicable when the user's information
     * is stored
     *                                 in an LDAP repository.
     */
    public void setExpiredInRepository(boolean expiredInRepository) {
        this.expiredInRepository = expiredInRepository;
    }


    /**
     * Gets the sharedSecrets value for this UserInfo.
     * 
     * @return sharedSecrets   * The user's shared secrets.  May be null or
     *                                 an empty array if the user doesn't
     * have any
     *                                 shared secrets.
     */
    public SharedSecret[] getSharedSecrets() {
        return sharedSecrets;
    }


    /**
     * Sets the sharedSecrets value for this UserInfo.
     * 
     * @param sharedSecrets   * The user's shared secrets.  May be null or
     *                                 an empty array if the user doesn't
     * have any
     *                                 shared secrets.
     */
    public void setSharedSecrets(SharedSecret[] sharedSecrets) {
        this.sharedSecrets = sharedSecrets;
    }


    /**
     * Gets the qaSecrets value for this UserInfo.
     * 
     * @return qaSecrets   * The user's QA authentication values.  This
     *                                 attribute will have a null value if
     * the
     *                                 administrator doesn't have QA authentication
     * values or doesn't have the userGetQa
     *                                 permission.  If the administrator
     * doesn't have
     *                                 the userQaView permission, the answers
     * will not
     *                                 be included in the returned value.
     */
    public NameValue[] getQaSecrets() {
        return qaSecrets;
    }


    /**
     * Sets the qaSecrets value for this UserInfo.
     * 
     * @param qaSecrets   * The user's QA authentication values.  This
     *                                 attribute will have a null value if
     * the
     *                                 administrator doesn't have QA authentication
     * values or doesn't have the userGetQa
     *                                 permission.  If the administrator
     * doesn't have
     *                                 the userQaView permission, the answers
     * will not
     *                                 be included in the returned value.
     */
    public void setQaSecrets(NameValue[] qaSecrets) {
        this.qaSecrets = qaSecrets;
    }


    /**
     * Gets the authenticationSecrets value for this UserInfo.
     * 
     * @return authenticationSecrets   * The user's mutual authentication secrets. May be null or an
     * empty array if the user doesn't have any authentication
     *                                 secrets.
     */
    public NameValue[] getAuthenticationSecrets() {
        return authenticationSecrets;
    }


    /**
     * Sets the authenticationSecrets value for this UserInfo.
     * 
     * @param authenticationSecrets   * The user's mutual authentication secrets. May be null or an
     * empty array if the user doesn't have any authentication
     *                                 secrets.
     */
    public void setAuthenticationSecrets(NameValue[] authenticationSecrets) {
        this.authenticationSecrets = authenticationSecrets;
    }


    /**
     * Gets the machineSecrets value for this UserInfo.
     * 
     * @return machineSecrets   * The user's machine secrets.  May be null or an
     *                                 empty array if the user doesn't have
     * any machine
     *                                 secrets.
     */
    public MachineSecretInfo[] getMachineSecrets() {
        return machineSecrets;
    }


    /**
     * Sets the machineSecrets value for this UserInfo.
     * 
     * @param machineSecrets   * The user's machine secrets.  May be null or an
     *                                 empty array if the user doesn't have
     * any machine
     *                                 secrets.
     */
    public void setMachineSecrets(MachineSecretInfo[] machineSecrets) {
        this.machineSecrets = machineSecrets;
    }


    /**
     * Gets the PIN value for this UserInfo.
     * 
     * @return PIN   * The user's PIN. Null if the user doesn't have a PIN.
     */
    public UserPINInfo getPIN() {
        return PIN;
    }


    /**
     * Sets the PIN value for this UserInfo.
     * 
     * @param PIN   * The user's PIN. Null if the user doesn't have a PIN.
     */
    public void setPIN(UserPINInfo PIN) {
        this.PIN = PIN;
    }


    /**
     * Gets the OTPs value for this UserInfo.
     * 
     * @return OTPs   * The user's one-time passwords (OTPs). Null if the user doesn't
     * have any OTPs.
     */
    public UserOTPInfo[] getOTPs() {
        return OTPs;
    }


    /**
     * Sets the OTPs value for this UserInfo.
     * 
     * @param OTPs   * The user's one-time passwords (OTPs). Null if the user doesn't
     * have any OTPs.
     */
    public void setOTPs(UserOTPInfo[] OTPs) {
        this.OTPs = OTPs;
    }


    /**
     * Gets the OTPAllowed value for this UserInfo.
     * 
     * @return OTPAllowed   * A flag indicating if the user can use an OTP
     *                                 for authentication.
     */
    public boolean isOTPAllowed() {
        return OTPAllowed;
    }


    /**
     * Sets the OTPAllowed value for this UserInfo.
     * 
     * @param OTPAllowed   * A flag indicating if the user can use an OTP
     *                                 for authentication.
     */
    public void setOTPAllowed(boolean OTPAllowed) {
        this.OTPAllowed = OTPAllowed;
    }


    /**
     * Gets the usePolicyForOTPDeliveryEnabled value for this UserInfo.
     * 
     * @return usePolicyForOTPDeliveryEnabled   * If true, use the policy setting for
     *                                 OTPDeliveryEnabled. If false, OTPDeliveryEnabled
     * indicates whether or not OTP delivery is allowed.
     */
    public boolean isUsePolicyForOTPDeliveryEnabled() {
        return usePolicyForOTPDeliveryEnabled;
    }


    /**
     * Sets the usePolicyForOTPDeliveryEnabled value for this UserInfo.
     * 
     * @param usePolicyForOTPDeliveryEnabled   * If true, use the policy setting for
     *                                 OTPDeliveryEnabled. If false, OTPDeliveryEnabled
     * indicates whether or not OTP delivery is allowed.
     */
    public void setUsePolicyForOTPDeliveryEnabled(boolean usePolicyForOTPDeliveryEnabled) {
        this.usePolicyForOTPDeliveryEnabled = usePolicyForOTPDeliveryEnabled;
    }


    /**
     * Gets the OTPDeliveryEnabled value for this UserInfo.
     * 
     * @return OTPDeliveryEnabled   * A flag indicating if the OTP can be delivered
     *                                 via an out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true.
     */
    public Boolean getOTPDeliveryEnabled() {
        return OTPDeliveryEnabled;
    }


    /**
     * Sets the OTPDeliveryEnabled value for this UserInfo.
     * 
     * @param OTPDeliveryEnabled   * A flag indicating if the OTP can be delivered
     *                                 via an out-of-band delivery mechanism
     * to this user.
     *                                 This value is ignored if
     *                                 usePolicyForOTPDeliveryEnabled is
     * true.
     */
    public void setOTPDeliveryEnabled(Boolean OTPDeliveryEnabled) {
        this.OTPDeliveryEnabled = OTPDeliveryEnabled;
    }


    /**
     * Gets the PVN value for this UserInfo.
     * 
     * @return PVN   * The user's personal verification number (PVN).
     *                                 Null if the user doesn't have a PVN.
     */
    public UserPVNInfo getPVN() {
        return PVN;
    }


    /**
     * Sets the PVN value for this UserInfo.
     * 
     * @param PVN   * The user's personal verification number (PVN).
     *                                 Null if the user doesn't have a PVN.
     */
    public void setPVN(UserPVNInfo PVN) {
        this.PVN = PVN;
    }


    /**
     * Gets the password value for this UserInfo.
     * 
     * @return password   * The user's default password.
     *                                 Null if the user doesn't have a password.
     */
    public UserPasswordInfo getPassword() {
        return password;
    }


    /**
     * Sets the password value for this UserInfo.
     * 
     * @param password   * The user's default password.
     *                                 Null if the user doesn't have a password.
     */
    public void setPassword(UserPasswordInfo password) {
        this.password = password;
    }


    /**
     * Gets the namedPasswords value for this UserInfo.
     * 
     * @return namedPasswords   * The user's named passwords.
     *                                 Null if the user doesn't have named
     * passwords.
     */
    public UserPasswordInfo[] getNamedPasswords() {
        return namedPasswords;
    }


    /**
     * Sets the namedPasswords value for this UserInfo.
     * 
     * @param namedPasswords   * The user's named passwords.
     *                                 Null if the user doesn't have named
     * passwords.
     */
    public void setNamedPasswords(UserPasswordInfo[] namedPasswords) {
        this.namedPasswords = namedPasswords;
    }


    /**
     * Gets the activationInfo value for this UserInfo.
     * 
     * @return activationInfo   * The activation information for the user.
     */
    public ActivationInfo getActivationInfo() {
        return activationInfo;
    }


    /**
     * Sets the activationInfo value for this UserInfo.
     * 
     * @param activationInfo   * The activation information for the user.
     */
    public void setActivationInfo(ActivationInfo activationInfo) {
        this.activationInfo = activationInfo;
    }


    /**
     * Gets the cards value for this UserInfo.
     * 
     * @return cards   * The user's cards. May be null or an empty array if the
     *                                 user doesn't have any cards.
     */
    public UserCardInfo[] getCards() {
        return cards;
    }


    /**
     * Sets the cards value for this UserInfo.
     * 
     * @param cards   * The user's cards. May be null or an empty array if the
     *                                 user doesn't have any cards.
     */
    public void setCards(UserCardInfo[] cards) {
        this.cards = cards;
    }


    /**
     * Gets the tokens value for this UserInfo.
     * 
     * @return tokens   * The user's tokens.  May be null or an empty array if the
     *                                 user doesn't have any tokens.
     */
    public UserTokenInfo[] getTokens() {
        return tokens;
    }


    /**
     * Sets the tokens value for this UserInfo.
     * 
     * @param tokens   * The user's tokens.  May be null or an empty array if the
     *                                 user doesn't have any tokens.
     */
    public void setTokens(UserTokenInfo[] tokens) {
        this.tokens = tokens;
    }


    /**
     * Gets the certificates value for this UserInfo.
     * 
     * @return certificates   * The user's certificates.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 certificates.
     */
    public UserCertificateInfo[] getCertificates() {
        return certificates;
    }


    /**
     * Sets the certificates value for this UserInfo.
     * 
     * @param certificates   * The user's certificates.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 certificates.
     */
    public void setCertificates(UserCertificateInfo[] certificates) {
        this.certificates = certificates;
    }


    /**
     * Gets the federations value for this UserInfo.
     * 
     * @return federations   * The user's federations.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 federations.
     */
    public UserFederationInfo[] getFederations() {
        return federations;
    }


    /**
     * Sets the federations value for this UserInfo.
     * 
     * @param federations   * The user's federations.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 federations.
     */
    public void setFederations(UserFederationInfo[] federations) {
        this.federations = federations;
    }


    /**
     * Gets the digitalIds value for this UserInfo.
     * 
     * @return digitalIds   * The user's Digital Ids.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Digital Ids.
     */
    public UserDigitalIdInfo[] getDigitalIds() {
        return digitalIds;
    }


    /**
     * Sets the digitalIds value for this UserInfo.
     * 
     * @param digitalIds   * The user's Digital Ids.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Digital Ids.
     */
    public void setDigitalIds(UserDigitalIdInfo[] digitalIds) {
        this.digitalIds = digitalIds;
    }


    /**
     * Gets the smartCredentials value for this UserInfo.
     * 
     * @return smartCredentials   * The user's Smart Credentials.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Smart Credentials.
     */
    public com.good.adapters.entrust.stubs.UserSmartCredentialInfo[] getSmartCredentials() {
        return smartCredentials;
    }


    /**
     * Sets the smartCredentials value for this UserInfo.
     * 
     * @param smartCredentials   * The user's Smart Credentials.  May be null or an
     *                                 empty array if the user doesn't have
     * any
     *                                 Smart Credentials.
     */
    public void setSmartCredentials(com.good.adapters.entrust.stubs.UserSmartCredentialInfo[] smartCredentials) {
        this.smartCredentials = smartCredentials;
    }


    /**
     * Gets the userState value for this UserInfo.
     * 
     * @return userState   * The user's state.
     */
    public UserState getUserState() {
        return userState;
    }


    /**
     * Sets the userState value for this UserInfo.
     * 
     * @param userState   * The user's state.
     */
    public void setUserState(UserState userState) {
        this.userState = userState;
    }


    /**
     * Gets the suspendReason value for this UserInfo.
     * 
     * @return suspendReason   * The reason for the user's suspension, if the user's
     *                                 state is SUSPENDED.
     */
    public String getSuspendReason() {
        return suspendReason;
    }


    /**
     * Sets the suspendReason value for this UserInfo.
     * 
     * @param suspendReason   * The reason for the user's suspension, if the user's
     *                                 state is SUSPENDED.
     */
    public void setSuspendReason(String suspendReason) {
        this.suspendReason = suspendReason;
    }


    /**
     * Gets the roles value for this UserInfo.
     * 
     * @return roles   * The list of the names of the roles assigned to
     *                                 this user.
     */
    public String[] getRoles() {
        return roles;
    }


    /**
     * Sets the roles value for this UserInfo.
     * 
     * @param roles   * The list of the names of the roles assigned to
     *                                 this user.
     */
    public void setRoles(String[] roles) {
        this.roles = roles;
    }


    /**
     * Gets the userLocations value for this UserInfo.
     * 
     * @return userLocations   * The list of locations that this user has
     *                                 authenticated from.
     */
    public UserLocation[] getUserLocations() {
        return userLocations;
    }


    /**
     * Sets the userLocations value for this UserInfo.
     * 
     * @param userLocations   * The list of locations that this user has
     *                                 authenticated from.
     */
    public void setUserLocations(UserLocation[] userLocations) {
        this.userLocations = userLocations;
    }


    /**
     * Gets the usePolicyForMaxLocationHistorySize value for this UserInfo.
     * 
     * @return usePolicyForMaxLocationHistorySize   * If true, use the policy setting for
     *                                 maxLocationHistorySize. If false,
     * maxLocationHistorySize
     *                                 indicates the maximum location history
     * size.
     */
    public boolean isUsePolicyForMaxLocationHistorySize() {
        return usePolicyForMaxLocationHistorySize;
    }


    /**
     * Sets the usePolicyForMaxLocationHistorySize value for this UserInfo.
     * 
     * @param usePolicyForMaxLocationHistorySize   * If true, use the policy setting for
     *                                 maxLocationHistorySize. If false,
     * maxLocationHistorySize
     *                                 indicates the maximum location history
     * size.
     */
    public void setUsePolicyForMaxLocationHistorySize(boolean usePolicyForMaxLocationHistorySize) {
        this.usePolicyForMaxLocationHistorySize = usePolicyForMaxLocationHistorySize;
    }


    /**
     * Gets the maxLocationHistorySize value for this UserInfo.
     * 
     * @return maxLocationHistorySize   * The maximum size of the user location history
     *                                 list.  This attribute will not be
     * set if
     *                                 usePolicyForMaxLocationHistorySize
     * is true.
     */
    public Integer getMaxLocationHistorySize() {
        return maxLocationHistorySize;
    }


    /**
     * Sets the maxLocationHistorySize value for this UserInfo.
     * 
     * @param maxLocationHistorySize   * The maximum size of the user location history
     *                                 list.  This attribute will not be
     * set if
     *                                 usePolicyForMaxLocationHistorySize
     * is true.
     */
    public void setMaxLocationHistorySize(Integer maxLocationHistorySize) {
        this.maxLocationHistorySize = maxLocationHistorySize;
    }


    /**
     * Gets the usePolicyForCheckVelocity value for this UserInfo.
     * 
     * @return usePolicyForCheckVelocity   * If true, use the policy setting for
     *                                 checkVelocity. If false, checkVelocity
     * indicates whether or not to perform the velocity
     *                                 check when authenticating an IP address.
     */
    public boolean isUsePolicyForCheckVelocity() {
        return usePolicyForCheckVelocity;
    }


    /**
     * Sets the usePolicyForCheckVelocity value for this UserInfo.
     * 
     * @param usePolicyForCheckVelocity   * If true, use the policy setting for
     *                                 checkVelocity. If false, checkVelocity
     * indicates whether or not to perform the velocity
     *                                 check when authenticating an IP address.
     */
    public void setUsePolicyForCheckVelocity(boolean usePolicyForCheckVelocity) {
        this.usePolicyForCheckVelocity = usePolicyForCheckVelocity;
    }


    /**
     * Gets the checkVelocity value for this UserInfo.
     * 
     * @return checkVelocity   * If true, perform the velocity check when
     *                                 authenticating an IP address.
     *                                 This attribute will not be set if
     *                                 usePolicyForCheckVelocity is true.
     */
    public Boolean getCheckVelocity() {
        return checkVelocity;
    }


    /**
     * Sets the checkVelocity value for this UserInfo.
     * 
     * @param checkVelocity   * If true, perform the velocity check when
     *                                 authenticating an IP address.
     *                                 This attribute will not be set if
     *                                 usePolicyForCheckVelocity is true.
     */
    public void setCheckVelocity(Boolean checkVelocity) {
        this.checkVelocity = checkVelocity;
    }


    /**
     * Gets the usePolicyForCheckIPAddressInLocationHistory value for this UserInfo.
     * 
     * @return usePolicyForCheckIPAddressInLocationHistory   * If true, use the policy setting for
     *                                 checkIPAddressInLocationHistory. If
     * false,
     *                                 checkIPAddressInLocationHistory
     *                                 indicates whether or not to check
     * the IP
     *                                 address when comparing a location
     * against the
     *                                 user's location history.
     */
    public boolean isUsePolicyForCheckIPAddressInLocationHistory() {
        return usePolicyForCheckIPAddressInLocationHistory;
    }


    /**
     * Sets the usePolicyForCheckIPAddressInLocationHistory value for this UserInfo.
     * 
     * @param usePolicyForCheckIPAddressInLocationHistory   * If true, use the policy setting for
     *                                 checkIPAddressInLocationHistory. If
     * false,
     *                                 checkIPAddressInLocationHistory
     *                                 indicates whether or not to check
     * the IP
     *                                 address when comparing a location
     * against the
     *                                 user's location history.
     */
    public void setUsePolicyForCheckIPAddressInLocationHistory(boolean usePolicyForCheckIPAddressInLocationHistory) {
        this.usePolicyForCheckIPAddressInLocationHistory = usePolicyForCheckIPAddressInLocationHistory;
    }


    /**
     * Gets the checkIPAddressInLocationHistory value for this UserInfo.
     * 
     * @return checkIPAddressInLocationHistory   * If true, check the IP address when comparing
     *                                 a location against the user's location
     * history.  This attribute will not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is true.
     */
    public Boolean getCheckIPAddressInLocationHistory() {
        return checkIPAddressInLocationHistory;
    }


    /**
     * Sets the checkIPAddressInLocationHistory value for this UserInfo.
     * 
     * @param checkIPAddressInLocationHistory   * If true, check the IP address when comparing
     *                                 a location against the user's location
     * history.  This attribute will not be set if
     *                                 usePolicyForCheckIPAddressInLocationHistory
     * is true.
     */
    public void setCheckIPAddressInLocationHistory(Boolean checkIPAddressInLocationHistory) {
        this.checkIPAddressInLocationHistory = checkIPAddressInLocationHistory;
    }


    /**
     * Gets the usePolicyForExpectedLocations value for this UserInfo.
     * 
     * @return usePolicyForExpectedLocations   * If true, this user uses the expected locations
     *                                 settings defined in policy.  Otherwise,
     * the
     *                                 per-user expectedLocations setting
     * is used.
     */
    public boolean isUsePolicyForExpectedLocations() {
        return usePolicyForExpectedLocations;
    }


    /**
     * Sets the usePolicyForExpectedLocations value for this UserInfo.
     * 
     * @param usePolicyForExpectedLocations   * If true, this user uses the expected locations
     *                                 settings defined in policy.  Otherwise,
     * the
     *                                 per-user expectedLocations setting
     * is used.
     */
    public void setUsePolicyForExpectedLocations(boolean usePolicyForExpectedLocations) {
        this.usePolicyForExpectedLocations = usePolicyForExpectedLocations;
    }


    /**
     * Gets the expectedLocations value for this UserInfo.
     * 
     * @return expectedLocations   * A list of locations the user can authenticate
     *                                 from.  This value is ignored if
     *                                 usePolicyForExpectedLocations is true.
     */
    public ExpectedLocation[] getExpectedLocations() {
        return expectedLocations;
    }


    /**
     * Sets the expectedLocations value for this UserInfo.
     * 
     * @param expectedLocations   * A list of locations the user can authenticate
     *                                 from.  This value is ignored if
     *                                 usePolicyForExpectedLocations is true.
     */
    public void setExpectedLocations(ExpectedLocation[] expectedLocations) {
        this.expectedLocations = expectedLocations;
    }


    /**
     * Gets the rolesGrantingAccess value for this UserInfo.
     * 
     * @return rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public String[] getRolesGrantingAccess() {
        return rolesGrantingAccess;
    }


    /**
     * Sets the rolesGrantingAccess value for this UserInfo.
     * 
     * @param rolesGrantingAccess   * When this structure is returned by an admin
     *                                 service operation, this is the list
     * of the
     *                                 names of the roles that granted access
     * to this
     *                                 structure.
     */
    public void setRolesGrantingAccess(String[] rolesGrantingAccess) {
        this.rolesGrantingAccess = rolesGrantingAccess;
    }


    /**
     * Gets the comments value for this UserInfo.
     * 
     * @return comments   * Optional descriptive comments about this user.
     */
    public String getComments() {
        return comments;
    }


    /**
     * Sets the comments value for this UserInfo.
     * 
     * @param comments   * Optional descriptive comments about this user.
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof UserInfo)) return false;
        UserInfo other = (UserInfo) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.userid==null && other.getUserid()==null) || 
             (this.userid!=null &&
              this.userid.equals(other.getUserid()))) &&
            ((this.userName==null && other.getUserName()==null) || 
             (this.userName!=null &&
              this.userName.equals(other.getUserName()))) &&
            ((this.group==null && other.getGroup()==null) || 
             (this.group!=null &&
              this.group.equals(other.getGroup()))) &&
            ((this.partition==null && other.getPartition()==null) || 
             (this.partition!=null &&
              this.partition.equals(other.getPartition()))) &&
            ((this.userNumber==null && other.getUserNumber()==null) || 
             (this.userNumber!=null &&
              this.userNumber.equals(other.getUserNumber()))) &&
            ((this.originalId==null && other.getOriginalId()==null) || 
             (this.originalId!=null &&
              this.originalId.equals(other.getOriginalId()))) &&
            ((this.repository==null && other.getRepository()==null) || 
             (this.repository!=null &&
              this.repository.equals(other.getRepository()))) &&
            ((this.contactInfoList==null && other.getContactInfoList()==null) || 
             (this.contactInfoList!=null &&
              java.util.Arrays.equals(this.contactInfoList, other.getContactInfoList()))) &&
            ((this.aliases==null && other.getAliases()==null) || 
             (this.aliases!=null &&
              java.util.Arrays.equals(this.aliases, other.getAliases()))) &&
            ((this.fullName==null && other.getFullName()==null) || 
             (this.fullName!=null &&
              this.fullName.equals(other.getFullName()))) &&
            ((this.fullNameInRepository==null && other.getFullNameInRepository()==null) || 
             (this.fullNameInRepository!=null &&
              this.fullNameInRepository.equals(other.getFullNameInRepository()))) &&
            ((this.locale==null && other.getLocale()==null) || 
             (this.locale!=null &&
              this.locale.equals(other.getLocale()))) &&
            this.badData == other.isBadData() &&
            ((this.lockoutInfo==null && other.getLockoutInfo()==null) || 
             (this.lockoutInfo!=null &&
              this.lockoutInfo.equals(other.getLockoutInfo()))) &&
            ((this.lastAuth==null && other.getLastAuth()==null) || 
             (this.lastAuth!=null &&
              this.lastAuth.equals(other.getLastAuth()))) &&
            ((this.lastFailedAuth==null && other.getLastFailedAuth()==null) || 
             (this.lastFailedAuth!=null &&
              this.lastFailedAuth.equals(other.getLastFailedAuth()))) &&
            this.disabledInRepository == other.isDisabledInRepository() &&
            this.expiredInRepository == other.isExpiredInRepository() &&
            ((this.sharedSecrets==null && other.getSharedSecrets()==null) || 
             (this.sharedSecrets!=null &&
              java.util.Arrays.equals(this.sharedSecrets, other.getSharedSecrets()))) &&
            ((this.qaSecrets==null && other.getQaSecrets()==null) || 
             (this.qaSecrets!=null &&
              java.util.Arrays.equals(this.qaSecrets, other.getQaSecrets()))) &&
            ((this.authenticationSecrets==null && other.getAuthenticationSecrets()==null) || 
             (this.authenticationSecrets!=null &&
              java.util.Arrays.equals(this.authenticationSecrets, other.getAuthenticationSecrets()))) &&
            ((this.machineSecrets==null && other.getMachineSecrets()==null) || 
             (this.machineSecrets!=null &&
              java.util.Arrays.equals(this.machineSecrets, other.getMachineSecrets()))) &&
            ((this.PIN==null && other.getPIN()==null) || 
             (this.PIN!=null &&
              this.PIN.equals(other.getPIN()))) &&
            ((this.OTPs==null && other.getOTPs()==null) || 
             (this.OTPs!=null &&
              java.util.Arrays.equals(this.OTPs, other.getOTPs()))) &&
            this.OTPAllowed == other.isOTPAllowed() &&
            this.usePolicyForOTPDeliveryEnabled == other.isUsePolicyForOTPDeliveryEnabled() &&
            ((this.OTPDeliveryEnabled==null && other.getOTPDeliveryEnabled()==null) || 
             (this.OTPDeliveryEnabled!=null &&
              this.OTPDeliveryEnabled.equals(other.getOTPDeliveryEnabled()))) &&
            ((this.PVN==null && other.getPVN()==null) || 
             (this.PVN!=null &&
              this.PVN.equals(other.getPVN()))) &&
            ((this.password==null && other.getPassword()==null) || 
             (this.password!=null &&
              this.password.equals(other.getPassword()))) &&
            ((this.namedPasswords==null && other.getNamedPasswords()==null) || 
             (this.namedPasswords!=null &&
              java.util.Arrays.equals(this.namedPasswords, other.getNamedPasswords()))) &&
            ((this.activationInfo==null && other.getActivationInfo()==null) || 
             (this.activationInfo!=null &&
              this.activationInfo.equals(other.getActivationInfo()))) &&
            ((this.cards==null && other.getCards()==null) || 
             (this.cards!=null &&
              java.util.Arrays.equals(this.cards, other.getCards()))) &&
            ((this.tokens==null && other.getTokens()==null) || 
             (this.tokens!=null &&
              java.util.Arrays.equals(this.tokens, other.getTokens()))) &&
            ((this.certificates==null && other.getCertificates()==null) || 
             (this.certificates!=null &&
              java.util.Arrays.equals(this.certificates, other.getCertificates()))) &&
            ((this.federations==null && other.getFederations()==null) || 
             (this.federations!=null &&
              java.util.Arrays.equals(this.federations, other.getFederations()))) &&
            ((this.digitalIds==null && other.getDigitalIds()==null) || 
             (this.digitalIds!=null &&
              java.util.Arrays.equals(this.digitalIds, other.getDigitalIds()))) &&
            ((this.smartCredentials==null && other.getSmartCredentials()==null) || 
             (this.smartCredentials!=null &&
              java.util.Arrays.equals(this.smartCredentials, other.getSmartCredentials()))) &&
            ((this.userState==null && other.getUserState()==null) || 
             (this.userState!=null &&
              this.userState.equals(other.getUserState()))) &&
            ((this.suspendReason==null && other.getSuspendReason()==null) || 
             (this.suspendReason!=null &&
              this.suspendReason.equals(other.getSuspendReason()))) &&
            ((this.roles==null && other.getRoles()==null) || 
             (this.roles!=null &&
              java.util.Arrays.equals(this.roles, other.getRoles()))) &&
            ((this.userLocations==null && other.getUserLocations()==null) || 
             (this.userLocations!=null &&
              java.util.Arrays.equals(this.userLocations, other.getUserLocations()))) &&
            this.usePolicyForMaxLocationHistorySize == other.isUsePolicyForMaxLocationHistorySize() &&
            ((this.maxLocationHistorySize==null && other.getMaxLocationHistorySize()==null) || 
             (this.maxLocationHistorySize!=null &&
              this.maxLocationHistorySize.equals(other.getMaxLocationHistorySize()))) &&
            this.usePolicyForCheckVelocity == other.isUsePolicyForCheckVelocity() &&
            ((this.checkVelocity==null && other.getCheckVelocity()==null) || 
             (this.checkVelocity!=null &&
              this.checkVelocity.equals(other.getCheckVelocity()))) &&
            this.usePolicyForCheckIPAddressInLocationHistory == other.isUsePolicyForCheckIPAddressInLocationHistory() &&
            ((this.checkIPAddressInLocationHistory==null && other.getCheckIPAddressInLocationHistory()==null) || 
             (this.checkIPAddressInLocationHistory!=null &&
              this.checkIPAddressInLocationHistory.equals(other.getCheckIPAddressInLocationHistory()))) &&
            this.usePolicyForExpectedLocations == other.isUsePolicyForExpectedLocations() &&
            ((this.expectedLocations==null && other.getExpectedLocations()==null) || 
             (this.expectedLocations!=null &&
              java.util.Arrays.equals(this.expectedLocations, other.getExpectedLocations()))) &&
            ((this.rolesGrantingAccess==null && other.getRolesGrantingAccess()==null) || 
             (this.rolesGrantingAccess!=null &&
              java.util.Arrays.equals(this.rolesGrantingAccess, other.getRolesGrantingAccess()))) &&
            ((this.comments==null && other.getComments()==null) || 
             (this.comments!=null &&
              this.comments.equals(other.getComments())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUserid() != null) {
            _hashCode += getUserid().hashCode();
        }
        if (getUserName() != null) {
            _hashCode += getUserName().hashCode();
        }
        if (getGroup() != null) {
            _hashCode += getGroup().hashCode();
        }
        if (getPartition() != null) {
            _hashCode += getPartition().hashCode();
        }
        if (getUserNumber() != null) {
            _hashCode += getUserNumber().hashCode();
        }
        if (getOriginalId() != null) {
            _hashCode += getOriginalId().hashCode();
        }
        if (getRepository() != null) {
            _hashCode += getRepository().hashCode();
        }
        if (getContactInfoList() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getContactInfoList());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getContactInfoList(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAliases() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAliases());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAliases(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getFullName() != null) {
            _hashCode += getFullName().hashCode();
        }
        if (getFullNameInRepository() != null) {
            _hashCode += getFullNameInRepository().hashCode();
        }
        if (getLocale() != null) {
            _hashCode += getLocale().hashCode();
        }
        _hashCode += (isBadData() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getLockoutInfo() != null) {
            _hashCode += getLockoutInfo().hashCode();
        }
        if (getLastAuth() != null) {
            _hashCode += getLastAuth().hashCode();
        }
        if (getLastFailedAuth() != null) {
            _hashCode += getLastFailedAuth().hashCode();
        }
        _hashCode += (isDisabledInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isExpiredInRepository() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getSharedSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSharedSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSharedSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getQaSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getQaSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getQaSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAuthenticationSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAuthenticationSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getAuthenticationSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getMachineSecrets() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getMachineSecrets());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getMachineSecrets(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getPIN() != null) {
            _hashCode += getPIN().hashCode();
        }
        if (getOTPs() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getOTPs());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getOTPs(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isOTPAllowed() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        _hashCode += (isUsePolicyForOTPDeliveryEnabled() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getOTPDeliveryEnabled() != null) {
            _hashCode += getOTPDeliveryEnabled().hashCode();
        }
        if (getPVN() != null) {
            _hashCode += getPVN().hashCode();
        }
        if (getPassword() != null) {
            _hashCode += getPassword().hashCode();
        }
        if (getNamedPasswords() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getNamedPasswords());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getNamedPasswords(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getActivationInfo() != null) {
            _hashCode += getActivationInfo().hashCode();
        }
        if (getCards() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCards());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCards(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getTokens() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTokens());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getTokens(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCertificates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCertificates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCertificates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getFederations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getFederations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getFederations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getDigitalIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDigitalIds());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getDigitalIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentials() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentials());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentials(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getUserState() != null) {
            _hashCode += getUserState().hashCode();
        }
        if (getSuspendReason() != null) {
            _hashCode += getSuspendReason().hashCode();
        }
        if (getRoles() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRoles());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRoles(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getUserLocations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getUserLocations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getUserLocations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        _hashCode += (isUsePolicyForMaxLocationHistorySize() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getMaxLocationHistorySize() != null) {
            _hashCode += getMaxLocationHistorySize().hashCode();
        }
        _hashCode += (isUsePolicyForCheckVelocity() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCheckVelocity() != null) {
            _hashCode += getCheckVelocity().hashCode();
        }
        _hashCode += (isUsePolicyForCheckIPAddressInLocationHistory() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getCheckIPAddressInLocationHistory() != null) {
            _hashCode += getCheckIPAddressInLocationHistory().hashCode();
        }
        _hashCode += (isUsePolicyForExpectedLocations() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        if (getExpectedLocations() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getExpectedLocations());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getExpectedLocations(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getRolesGrantingAccess() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRolesGrantingAccess());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getRolesGrantingAccess(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getComments() != null) {
            _hashCode += getComments().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserInfo.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserInfo"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userid");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Userid"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("group");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Group"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("partition");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Partition"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userNumber");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserNumber"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "integer"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("originalId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OriginalId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("repository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Repository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("contactInfoList");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ContactInfoList"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ContactInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("aliases");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Aliases"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("fullName");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FullName"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("fullNameInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "FullNameInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("locale");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Locale"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("badData");
        elemField.setXmlName(new javax.xml.namespace.QName("", "BadData"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lockoutInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LockoutInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserLockoutInfo"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LastAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastFailedAuth");
        elemField.setXmlName(new javax.xml.namespace.QName("", "LastFailedAuth"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "AuthenticationInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("disabledInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DisabledInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expiredInRepository");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ExpiredInRepository"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sharedSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SharedSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "SharedSecret"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("qaSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "QaSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authenticationSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "AuthenticationSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "NameValue"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("machineSecrets");
        elemField.setXmlName(new javax.xml.namespace.QName("", "MachineSecrets"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "MachineSecretInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PIN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PIN"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPINInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPs");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPs"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserOTPInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPAllowed");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPAllowed"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForOTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForOTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("OTPDeliveryEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("", "OTPDeliveryEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("PVN");
        elemField.setXmlName(new javax.xml.namespace.QName("", "PVN"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPVNInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("password");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Password"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPasswordInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("namedPasswords");
        elemField.setXmlName(new javax.xml.namespace.QName("", "NamedPasswords"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserPasswordInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("activationInfo");
        elemField.setXmlName(new javax.xml.namespace.QName("", "ActivationInfo"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ActivationInfo"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("cards");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Cards"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserCardInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokens");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Tokens"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserTokenInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Certificates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserCertificateInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("federations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Federations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserFederationInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("digitalIds");
        elemField.setXmlName(new javax.xml.namespace.QName("", "DigitalIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserDigitalIdInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SmartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserSmartCredentialInfo"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userState");
        elemField.setXmlName(new javax.xml.namespace.QName("", "UserState"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserState"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("suspendReason");
        elemField.setXmlName(new javax.xml.namespace.QName("", "SuspendReason"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("roles");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Roles"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("userLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "userLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "UserLocation"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForMaxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForMaxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxLocationHistorySize");
        elemField.setXmlName(new javax.xml.namespace.QName("", "maxLocationHistorySize"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForCheckVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForCheckVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkVelocity");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkVelocity"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForCheckIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForCheckIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("checkIPAddressInLocationHistory");
        elemField.setXmlName(new javax.xml.namespace.QName("", "checkIPAddressInLocationHistory"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("usePolicyForExpectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "usePolicyForExpectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("expectedLocations");
        elemField.setXmlName(new javax.xml.namespace.QName("", "expectedLocations"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:adminV9:wsdl", "ExpectedLocation"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("rolesGrantingAccess");
        elemField.setXmlName(new javax.xml.namespace.QName("", "RolesGrantingAccess"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("comments");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Comments"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
