/**
 * CertificateChallenge.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Apr 22, 2006 (06:55:48 PDT) WSDL2Java emitter.
 */

package com.good.adapters.entrust.stubs;


/**
 * This structure contains information about a certificate challenge.
 * To authenticate a certificate challenge, the client should hash
 *             the challenge using one of the listed allowed hashing
 * algorithms
 *             and then sign the resulting value using the private key
 * corresponding to one of the specified certificates or smart
 *             credentials.
 */
public class CertificateChallenge  implements java.io.Serializable {
    /* The certificate challenge.  The application must hash
     *                   and sign this challenge to authenticate the challenge. */
    private String challenge;

    /* The hashing algorithm to be used to hash 
     *                   the challenge before it is signed. */
    private String hashingAlgorithm;

    /* The certificates that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge. */
    private CertificateData[] certificates;

    /* The smart credentials that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge. */
    private SmartCredentialData[] smartCredentials;

    /* The transaction id associated with this request.
     *                   This value will be set only when the challenge was
     * delivered to one or more smart credentials.  This transaction
     *                   id should be specified in a subsequent
     *                   authenticateGenericChallenge call when the application
     * 
     *                   doesn't provide a response expected the response
     * to be
     *                   returned to Entrust IdentityGuard out of band. */
    private String transactionId;

    /* The time that this challenge was created. */
    private java.util.Calendar createDate;

    /* The lifetime of this challenge in seconds. */
    private int lifetime;

    public CertificateChallenge() {
    }

    public CertificateChallenge(
           String challenge,
           String hashingAlgorithm,
           CertificateData[] certificates,
           SmartCredentialData[] smartCredentials,
           String transactionId,
           java.util.Calendar createDate,
           int lifetime) {
           this.challenge = challenge;
           this.hashingAlgorithm = hashingAlgorithm;
           this.certificates = certificates;
           this.smartCredentials = smartCredentials;
           this.transactionId = transactionId;
           this.createDate = createDate;
           this.lifetime = lifetime;
    }


    /**
     * Gets the challenge value for this CertificateChallenge.
     * 
     * @return challenge   * The certificate challenge.  The application must hash
     *                   and sign this challenge to authenticate the challenge.
     */
    public String getChallenge() {
        return challenge;
    }


    /**
     * Sets the challenge value for this CertificateChallenge.
     * 
     * @param challenge   * The certificate challenge.  The application must hash
     *                   and sign this challenge to authenticate the challenge.
     */
    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }


    /**
     * Gets the hashingAlgorithm value for this CertificateChallenge.
     * 
     * @return hashingAlgorithm   * The hashing algorithm to be used to hash 
     *                   the challenge before it is signed.
     */
    public String getHashingAlgorithm() {
        return hashingAlgorithm;
    }


    /**
     * Sets the hashingAlgorithm value for this CertificateChallenge.
     * 
     * @param hashingAlgorithm   * The hashing algorithm to be used to hash 
     *                   the challenge before it is signed.
     */
    public void setHashingAlgorithm(String hashingAlgorithm) {
        this.hashingAlgorithm = hashingAlgorithm;
    }


    /**
     * Gets the certificates value for this CertificateChallenge.
     * 
     * @return certificates   * The certificates that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge.
     */
    public CertificateData[] getCertificates() {
        return certificates;
    }


    /**
     * Sets the certificates value for this CertificateChallenge.
     * 
     * @param certificates   * The certificates that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge.
     */
    public void setCertificates(CertificateData[] certificates) {
        this.certificates = certificates;
    }


    /**
     * Gets the smartCredentials value for this CertificateChallenge.
     * 
     * @return smartCredentials   * The smart credentials that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge.
     */
    public SmartCredentialData[] getSmartCredentials() {
        return smartCredentials;
    }


    /**
     * Sets the smartCredentials value for this CertificateChallenge.
     * 
     * @param smartCredentials   * The smart credentials that can be used to authenticate the
     *                   challenge.  The application must use a private key
     * corresponding to one of the certificates or one
     *                   of the smart credentials to sign the hash of the
     * challenge.
     */
    public void setSmartCredentials(SmartCredentialData[] smartCredentials) {
        this.smartCredentials = smartCredentials;
    }


    /**
     * Gets the transactionId value for this CertificateChallenge.
     * 
     * @return transactionId   * The transaction id associated with this request.
     *                   This value will be set only when the challenge was
     * delivered to one or more smart credentials.  This transaction
     *                   id should be specified in a subsequent
     *                   authenticateGenericChallenge call when the application
     * 
     *                   doesn't provide a response expected the response
     * to be
     *                   returned to Entrust IdentityGuard out of band.
     */
    public String getTransactionId() {
        return transactionId;
    }


    /**
     * Sets the transactionId value for this CertificateChallenge.
     * 
     * @param transactionId   * The transaction id associated with this request.
     *                   This value will be set only when the challenge was
     * delivered to one or more smart credentials.  This transaction
     *                   id should be specified in a subsequent
     *                   authenticateGenericChallenge call when the application
     * 
     *                   doesn't provide a response expected the response
     * to be
     *                   returned to Entrust IdentityGuard out of band.
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }


    /**
     * Gets the createDate value for this CertificateChallenge.
     * 
     * @return createDate   * The time that this challenge was created.
     */
    public java.util.Calendar getCreateDate() {
        return createDate;
    }


    /**
     * Sets the createDate value for this CertificateChallenge.
     * 
     * @param createDate   * The time that this challenge was created.
     */
    public void setCreateDate(java.util.Calendar createDate) {
        this.createDate = createDate;
    }


    /**
     * Gets the lifetime value for this CertificateChallenge.
     * 
     * @return lifetime   * The lifetime of this challenge in seconds.
     */
    public int getLifetime() {
        return lifetime;
    }


    /**
     * Sets the lifetime value for this CertificateChallenge.
     * 
     * @param lifetime   * The lifetime of this challenge in seconds.
     */
    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    private Object __equalsCalc = null;
    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof CertificateChallenge)) return false;
        CertificateChallenge other = (CertificateChallenge) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.challenge==null && other.getChallenge()==null) || 
             (this.challenge!=null &&
              this.challenge.equals(other.getChallenge()))) &&
            ((this.hashingAlgorithm==null && other.getHashingAlgorithm()==null) || 
             (this.hashingAlgorithm!=null &&
              this.hashingAlgorithm.equals(other.getHashingAlgorithm()))) &&
            ((this.certificates==null && other.getCertificates()==null) || 
             (this.certificates!=null &&
              java.util.Arrays.equals(this.certificates, other.getCertificates()))) &&
            ((this.smartCredentials==null && other.getSmartCredentials()==null) || 
             (this.smartCredentials!=null &&
              java.util.Arrays.equals(this.smartCredentials, other.getSmartCredentials()))) &&
            ((this.transactionId==null && other.getTransactionId()==null) || 
             (this.transactionId!=null &&
              this.transactionId.equals(other.getTransactionId()))) &&
            ((this.createDate==null && other.getCreateDate()==null) || 
             (this.createDate!=null &&
              this.createDate.equals(other.getCreateDate()))) &&
            this.lifetime == other.getLifetime();
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getChallenge() != null) {
            _hashCode += getChallenge().hashCode();
        }
        if (getHashingAlgorithm() != null) {
            _hashCode += getHashingAlgorithm().hashCode();
        }
        if (getCertificates() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCertificates());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getCertificates(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSmartCredentials() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSmartCredentials());
                 i++) {
                Object obj = java.lang.reflect.Array.get(getSmartCredentials(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getTransactionId() != null) {
            _hashCode += getTransactionId().hashCode();
        }
        if (getCreateDate() != null) {
            _hashCode += getCreateDate().hashCode();
        }
        _hashCode += getLifetime();
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(CertificateChallenge.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "CertificateChallenge"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("challenge");
        elemField.setXmlName(new javax.xml.namespace.QName("", "challenge"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hashingAlgorithm");
        elemField.setXmlName(new javax.xml.namespace.QName("", "hashingAlgorithm"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("certificates");
        elemField.setXmlName(new javax.xml.namespace.QName("", "certificates"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "CertificateData"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("smartCredentials");
        elemField.setXmlName(new javax.xml.namespace.QName("", "smartCredentials"));
        elemField.setXmlType(new javax.xml.namespace.QName("urn:entrust.com:ig:commonV9", "SmartCredentialData"));
        elemField.setNillable(true);
        elemField.setItemQName(new javax.xml.namespace.QName("", "item"));
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("transactionId");
        elemField.setXmlName(new javax.xml.namespace.QName("", "TransactionId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setNillable(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("createDate");
        elemField.setXmlName(new javax.xml.namespace.QName("", "CreateDate"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lifetime");
        elemField.setXmlName(new javax.xml.namespace.QName("", "Lifetime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           String mechType,
           Class _javaType,
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
