package com.good.service.test;

import com.good.service.test.data.PropertiesLoader;
import com.google.common.math.DoubleMath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

/**
 * Created by ibilyi on 13.11.2015.
 */
public class TestEntryPoint {

    private static final Log LOG = LogFactory.getLog(TestEntryPoint.class);
    
    public static void main(String[]args) {
        PropertiesLoader propertiesLoader = PropertiesLoader.getInstance();
        int length = Integer.valueOf(propertiesLoader.get("requestsNumber"));
        long[] time = new long[length];
        String [] responses = new String[length];
        RequestInvoker requestInvoker = new RequestInvoker(time, responses, 0, length);
        ForkJoinPool pool = new ForkJoinPool();
        pool.execute(requestInvoker);
        while (!requestInvoker.isDone()) {
            try {
                TimeUnit.SECONDS.sleep(2);
            } catch (InterruptedException e) {
                LOG.error("Thread was interrupted", e);
                return;
            }
        }
        pool.shutdown();
        printReport(responses,time);
    }

    private static void printReport(String[] responses, long[] time) {
        int length = responses.length;
        for(int i = 0; i < length; i++) {
            LOG.info("[" + i + "] Time spent : " + time[i] + ", response :" + responses[i]);
        }
        double avarageTimePerRequest = DoubleMath.mean(time);
        LOG.info("Time per request was : " + avarageTimePerRequest);
    }
}
