package com.good.service.test;

import com.good.service.test.data.HttpRequestFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;

import java.io.IOException;
import java.util.concurrent.RecursiveAction;

/**
 * Created by ibilyi on 13.11.2015.
 */
public class RequestInvoker extends RecursiveAction {

    private static final Log LOG = LogFactory.getLog(RequestInvoker.class);

    private static final int NUMBER_OF_REQUESTS = 4;

    private final long[] resultsTimeout;
    private final String[] results;
    private final int indexOfFirstRequest;
    private final int numberOfRequests;

    public RequestInvoker(long[] resultsTimeout, String[] results, int indexOfFirstRequest, int numberOfRequests) {
        this.resultsTimeout = resultsTimeout;
        this.results = results;
        this.indexOfFirstRequest = indexOfFirstRequest;
        this.numberOfRequests = numberOfRequests;
    }

    private void performRequests() throws IOException{
        LOG.debug("Performing requests : " + toString());
        HttpRequestFactory clientFactory = HttpRequestFactory.getInstance();
        HttpPost postRequest = clientFactory.getPostRequest();
        long before = System.currentTimeMillis();
        for (int i = indexOfFirstRequest; i < indexOfFirstRequest + numberOfRequests; i++) {
            LOG.debug("[" + i + "] Start");
            HttpResponse httpResponse = clientFactory.getHTTPClient().execute(postRequest);
            long timeSpend = System.currentTimeMillis() - before;
            results[i] = IOUtils.toString(httpResponse.getEntity().getContent());
            resultsTimeout[i] = timeSpend;
            before = System.currentTimeMillis();
        }
    }

    @Override
    protected void compute() {
        if (numberOfRequests < NUMBER_OF_REQUESTS) {
            try {
                performRequests();
            } catch (IOException e) {
                LOG.error("Exception during sending requests", e);
            }
            return;
        }
        int newLength = numberOfRequests / 2;
        RequestInvoker first = new RequestInvoker(resultsTimeout, results, indexOfFirstRequest, newLength);
        RequestInvoker second = new RequestInvoker(resultsTimeout, results, indexOfFirstRequest + newLength, numberOfRequests - newLength);
        LOG.debug("Splitted : \n\tfitst:" + first.toString() + "\n\tsecond" + second);
        invokeAll(first, second);
        return;
    }

    @Override
    public String toString() {
        return "{indexOfFirstRequest=" + indexOfFirstRequest +
                ", numberOfRequests=" + numberOfRequests +
                '}';
    }
}
