package com.good.security.x509;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import java.util.Collection;

/**
 * Class extends {@link org.springframework.security.core.userdetails.User} for customization
 * @author Stanislav Kyfenko
 *         28.09.2015
 */
public class X509CustomUser extends User {

    /**
     * Instantiates a new X 509 custom user. Calls super of the extended class
     *
     * @see org.springframework.security.core.userdetails.User#User(String, String, Collection)
     */
    public X509CustomUser(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
    }

    /**
     * Instantiates a new X 509 custom user. Calls super of the extended class
     *
     * @see org.springframework.security.core.userdetails.User#User(String, String, boolean, boolean, boolean, boolean, Collection)
     */
    public X509CustomUser(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }
}
