package com.good.filters.validators;

import com.good.domain.GDP12CertificateRequest;
import com.good.domain.P12CertificateFailure;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Class provide check that all mandatory field are presented in request body. Filter always should be applied after 
 * success work of {@link ObjectMappingValidator} filter. For verification class requires deserialized request body in 
 * the {@link ValidationChain#getInputData()}.
 * If any of mandatory fields will be missed response with {@link P12CertificateFailure#BAD_REQUEST} error code
 * in it's body will be returned.
 * 
 * @author Ivan Bilyi
 * 28.10.2015.
 */
public class RequestDataValidator implements ValidatorBean {
    private static final Log LOG = LogFactory.getLog(RequestDataValidator.class);

    /**
     * Validate that all mandatory fields are presented in request body
     * 
     * @param validationChain chain of filters 
     */
    @Override
    public void filter(ValidationChain validationChain) {
        LOG.info("Validating request fields content.");
        GDP12CertificateRequest data = validationChain.getInputData();
        if(StringUtils.isEmpty(data.getReqId()) || data.getmType() == null || data.getUser() == null) {
            LOG.debug("Some of required request body fields are empty.");
            validationChain.addErrorMessage(P12CertificateFailure.BAD_REQUEST);
            return;
        }
        LOG.debug("All required fields are presented.");
        validationChain.doValidation();
    }
}
